/*
 * main.h
 *
 *  Created on: Nov 21, 2019
 *      Author: nxa13309
 */

#ifndef MAIN_H_
#define MAIN_H_

#include "board.h"
#include "common.h"
#include "printf.h"
#include "wcop.h"
#include "string.h"
#include "math.h"
#include "intrinsic_math.h"
#include "ECLIB_Ramp16.h"
#include "app_config.h"
#include "control.h"


typedef void (*FCN_POINTER)(void); /* pointer to function */

typedef enum
{   BLDC_INIT,
    BLDC_STOP,    
    BLDC_RUN,
    BLDC_FAULT,
} BLDC_STATE_ENUM;

typedef union {
  byte Byte;
  struct {
    byte Hard_OCFault      	:1; /* hardware over current fault flag */
    byte Soft_OCFault		:1; /* software over current fault flag */
    byte OverVoltageFault   :1; /* over voltage fault flag */
    byte UnderVoltageFault  :1; /* under voltage fault flag */
    byte Bit4   			:1; /*  */
    byte Bit5       		:1; /*  */
    byte Bit6               :1; /*  */
    byte Bit7         	    :1; /*  */
  } Bits;
} BLDC_FAULT_FLAGS;

typedef struct
{
	uint16_t uw16FTM_cntr;
	uint16_t uw16FTM_cntr_last;
	uint16_t uw16Comm_Period;
	uint16_t uw16Comm_Cntr;
	uint16_t uw16Speed_Act;
	uint16_t uw16Speed_Act_Tmp;
	uint16_t uw16Speed_Act_Tmp0;
	uint16_t uw16Speed_Act_Tmp1;
	uint16_t uw16Speed_Act_Tmp2;
	uint16_t uw16CoefVelocityPeriodScale;
	uint16_t w16Speed_Act_flt;
	int16_t w16Speed_req;
	int16_t w16Speed_ramp;
	int16_t w16Speed_err;
	CTR_sPIparams sSpeedPiParams;
	uint8_t HALL_signal;
	uint8_t HALL_vector;
	uint8_t HALL_vector_pre;
	byte Direction;
	int16_t w16Vdc;
	int16_t w16Idc;
	int32_t w32Idc_offsetTmp;
	int16_t w16Idc_offset;
	uint16_t uw16IDCOffset_cntr;
	uint16_t uw32ButtonCnt;
	uint16_t uw32SpeedStimulatorCnt;
	uint8_t ACMP_DACValue;

} CTR_sDrive;

#endif /* MAIN_H_ */
