/*
 * app_init.h
 *
 *  Created on: Nov 8, 2019
 *      Author: nxa13309
 */

#ifndef APP_INIT_H_
#define APP_INIT_H_

/******************************************************************************
* Macros
******************************************************************************/

/*bus clock configuration*/
#define BUSCLOCK_FREQUENCY_MHZ 16.0/* 16M */

/*ADC channels*/
#define ADC_VDC_CHANNEL    7
#define ADC_IDC_CHANNEL    3


/*PWM settings*/
#define PWM_FREQUENCY_KHZ   10.0/* PWM FREQUENCY 10 [kHz] */
#define PWM_MODULO          (unsigned int)((BUSCLOCK_FREQUENCY_MHZ*1000.0/PWM_FREQUENCY_KHZ)-1)/* PWM MOD value */




/******************************************************************************
* Global function
******************************************************************************/
extern void Init_ADC( void );
extern unsigned short ADC_GetResult( unsigned char channel);
extern void Init_FTM2( void );
extern void Init_HALL( void );
extern void IPCInit( void );
extern void Init_ACMP1( void );
extern void Init_FDS( void );
extern void MTIM1_Init(void);
extern void MTIM1_Start(void);
extern void MTIM1_Stop(void);
extern void Init_OPAMP( void );
extern void Init_Buttons(void);  



#endif /* APP_INIT_H_ */
