/*
** ###################################################################
**     Filename  : mc9s08pb16.h
**     Processor : MC9S08PB16
**     DataSheet : MC9S08PB16RM Rev. 0, 01/2019
**     Compiler  : CodeWarrior compiler
**     Date/Time : 2019-04-02 15:23:13
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2019 NXP Semiconductor, Inc. All Rights Reserved.
**
**     http      : www.nxp.com
**     mail      : support@nxp.com
** ###################################################################
*/

#ifndef _MC9S08PB16_H
#define _MC9S08PB16_H


/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

/* Watchdog reset macro */
#ifndef __RESET_WATCHDOG
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG()  (void)(void)(SYS_SRS = 0x55U, SYS_SRS = 0xAAU)
#endif
#endif /* __RESET_WATCHDOG */

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vnvm           39U
#define VectorNumber_VReserved38    38U
#define VectorNumber_Vkbi0          37U
#define VectorNumber_VReserved36    36U
#define VectorNumber_Vrtc           35U
#define VectorNumber_Viic           34U
#define VectorNumber_VReserved33    33U
#define VectorNumber_VReserved32    32U
#define VectorNumber_VReserved31    31U
#define VectorNumber_VReserved30    30U
#define VectorNumber_VReserved29    29U
#define VectorNumber_VReserved28    28U
#define VectorNumber_VReserved27    27U
#define VectorNumber_VReserved26    26U
#define VectorNumber_Vsci0txd       25U
#define VectorNumber_Vsci0rxd       24U
#define VectorNumber_Vsci0err       23U
#define VectorNumber_Vadc           22U
#define VectorNumber_Vacmp0         21U
#define VectorNumber_Vmtim1         20U
#define VectorNumber_Vmtim0         19U
#define VectorNumber_Vftm0ovf       18U
#define VectorNumber_Vftm0ch1       17U
#define VectorNumber_Vftm0ch0       16U
#define VectorNumber_Vacmp1         15U
#define VectorNumber_Vpwtovf        14U
#define VectorNumber_Vpwtrdy        13U
#define VectorNumber_Vftm2ovf       12U
#define VectorNumber_Vftm2ch5       11U
#define VectorNumber_Vftm2ch4       10U
#define VectorNumber_Vftm2ch3       9U
#define VectorNumber_Vftm2ch2       8U
#define VectorNumber_Vftm2ch1       7U
#define VectorNumber_Vftm2ch0       6U
#define VectorNumber_Vfds           5U
#define VectorNumber_Vclk           4U
#define VectorNumber_Vlvw           3U
#define VectorNumber_Virq           2U
#define VectorNumber_Vswi           1U
#define VectorNumber_Vreset         0U

/**************** interrupt vector table ****************/
#define Vnvm                        0xFFB0U
#define VReserved38                 0xFFB2U
#define Vkbi0                       0xFFB4U
#define VReserved36                 0xFFB6U
#define Vrtc                        0xFFB8U
#define Viic                        0xFFBAU
#define VReserved33                 0xFFBCU
#define VReserved32                 0xFFBEU
#define VReserved31                 0xFFC0U
#define VReserved30                 0xFFC2U
#define VReserved29                 0xFFC4U
#define VReserved28                 0xFFC6U
#define VReserved27                 0xFFC8U
#define VReserved26                 0xFFCAU
#define Vsci0txd                    0xFFCCU
#define Vsci0rxd                    0xFFCEU
#define Vsci0err                    0xFFD0U
#define Vadc                        0xFFD2U
#define Vacmp0                      0xFFD4U
#define Vmtim1                      0xFFD6U
#define Vmtim0                      0xFFD8U
#define Vftm0ovf                    0xFFDAU
#define Vftm0ch1                    0xFFDCU
#define Vftm0ch0                    0xFFDEU
#define Vacmp1                      0xFFE0U
#define Vpwtovf                     0xFFE2U
#define Vpwtrdy                     0xFFE4U
#define Vftm2ovf                    0xFFE6U
#define Vftm2ch5                    0xFFE8U
#define Vftm2ch4                    0xFFEAU
#define Vftm2ch3                    0xFFECU
#define Vftm2ch2                    0xFFEEU
#define Vftm2ch1                    0xFFF0U
#define Vftm2ch0                    0xFFF2U
#define Vfds                        0xFFF4U
#define Vclk                        0xFFF6U
#define Vlvw                        0xFFF8U
#define Virq                        0xFFFAU
#define Vswi                        0xFFFCU
#define Vreset                      0xFFFEU

/*** PORT_PTAD Port A Data Register; 0x00000000 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTAD0      : 1;
    byte  PTAD1      : 1;
    byte  PTAD2      : 1;
    byte  PTAD3      : 1;
    byte  PTAD4      : 1;
    byte  PTAD5      : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPTAD    : 6;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PORT_PTADSTR;
extern volatile PORT_PTADSTR _PORT_PTAD @0x00000000;
#define PORT_PTAD                 _PORT_PTAD.Byte
#define PORT_PTAD_PTAD0           _PORT_PTAD.Bits.PTAD0
#define PORT_PTAD_PTAD1           _PORT_PTAD.Bits.PTAD1
#define PORT_PTAD_PTAD2           _PORT_PTAD.Bits.PTAD2
#define PORT_PTAD_PTAD3           _PORT_PTAD.Bits.PTAD3
#define PORT_PTAD_PTAD4           _PORT_PTAD.Bits.PTAD4
#define PORT_PTAD_PTAD5           _PORT_PTAD.Bits.PTAD5
#define PORT_PTAD_PTAD            _PORT_PTAD.MergedBits.grpPTAD

#define PORT_PTAD_PTAD0_MASK      1U
#define PORT_PTAD_PTAD0_BITNUM    0
#define PORT_PTAD_PTAD1_MASK      2U
#define PORT_PTAD_PTAD1_BITNUM    1
#define PORT_PTAD_PTAD2_MASK      4U
#define PORT_PTAD_PTAD2_BITNUM    2
#define PORT_PTAD_PTAD3_MASK      8U
#define PORT_PTAD_PTAD3_BITNUM    3
#define PORT_PTAD_PTAD4_MASK      16U
#define PORT_PTAD_PTAD4_BITNUM    4
#define PORT_PTAD_PTAD5_MASK      32U
#define PORT_PTAD_PTAD5_BITNUM    5
#define PORT_PTAD_PTAD_MASK       63U
#define PORT_PTAD_PTAD_BITNUM     0


/*** PORT_PTBD Port B Data Register; 0x00000001 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTBD0      : 1;
    byte  PTBD1      : 1;
    byte  PTBD2      : 1;
    byte  PTBD3      : 1;
    byte  PTBD4      : 1;
    byte  PTBD5      : 1;
    byte  PTBD6      : 1;
    byte  PTBD7      : 1;
  } Bits;
} PORT_PTBDSTR;
extern volatile PORT_PTBDSTR _PORT_PTBD @0x00000001;
#define PORT_PTBD                 _PORT_PTBD.Byte
#define PORT_PTBD_PTBD0           _PORT_PTBD.Bits.PTBD0
#define PORT_PTBD_PTBD1           _PORT_PTBD.Bits.PTBD1
#define PORT_PTBD_PTBD2           _PORT_PTBD.Bits.PTBD2
#define PORT_PTBD_PTBD3           _PORT_PTBD.Bits.PTBD3
#define PORT_PTBD_PTBD4           _PORT_PTBD.Bits.PTBD4
#define PORT_PTBD_PTBD5           _PORT_PTBD.Bits.PTBD5
#define PORT_PTBD_PTBD6           _PORT_PTBD.Bits.PTBD6
#define PORT_PTBD_PTBD7           _PORT_PTBD.Bits.PTBD7

#define PORT_PTBD_PTBD0_MASK      1U
#define PORT_PTBD_PTBD0_BITNUM    0
#define PORT_PTBD_PTBD1_MASK      2U
#define PORT_PTBD_PTBD1_BITNUM    1
#define PORT_PTBD_PTBD2_MASK      4U
#define PORT_PTBD_PTBD2_BITNUM    2
#define PORT_PTBD_PTBD3_MASK      8U
#define PORT_PTBD_PTBD3_BITNUM    3
#define PORT_PTBD_PTBD4_MASK      16U
#define PORT_PTBD_PTBD4_BITNUM    4
#define PORT_PTBD_PTBD5_MASK      32U
#define PORT_PTBD_PTBD5_BITNUM    5
#define PORT_PTBD_PTBD6_MASK      64U
#define PORT_PTBD_PTBD6_BITNUM    6
#define PORT_PTBD_PTBD7_MASK      128U
#define PORT_PTBD_PTBD7_BITNUM    7


/*** PORT_PTCD Port C Data Register; 0x00000002 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTCD0      : 1;
    byte  PTCD1      : 1;
    byte  PTCD2      : 1;
    byte  PTCD3      : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPTCD    : 4;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PORT_PTCDSTR;
extern volatile PORT_PTCDSTR _PORT_PTCD @0x00000002;
#define PORT_PTCD                 _PORT_PTCD.Byte
#define PORT_PTCD_PTCD0           _PORT_PTCD.Bits.PTCD0
#define PORT_PTCD_PTCD1           _PORT_PTCD.Bits.PTCD1
#define PORT_PTCD_PTCD2           _PORT_PTCD.Bits.PTCD2
#define PORT_PTCD_PTCD3           _PORT_PTCD.Bits.PTCD3
#define PORT_PTCD_PTCD            _PORT_PTCD.MergedBits.grpPTCD

#define PORT_PTCD_PTCD0_MASK      1U
#define PORT_PTCD_PTCD0_BITNUM    0
#define PORT_PTCD_PTCD1_MASK      2U
#define PORT_PTCD_PTCD1_BITNUM    1
#define PORT_PTCD_PTCD2_MASK      4U
#define PORT_PTCD_PTCD2_BITNUM    2
#define PORT_PTCD_PTCD3_MASK      8U
#define PORT_PTCD_PTCD3_BITNUM    3
#define PORT_PTCD_PTCD_MASK       15U
#define PORT_PTCD_PTCD_BITNUM     0


/*** ADC_SC1 Status and Control Register 1; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte  ADCH0      : 1;
    byte  ADCH1      : 1;
    byte  ADCH2      : 1;
    byte  ADCH3      : 1;
    byte  ADCH4      : 1;
    byte  ADCO       : 1;
    byte  AIEN       : 1;
    byte  COCO       : 1;
  } Bits;
  struct {
    byte  grpADCH    : 5;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ADC_SC1STR;
extern volatile ADC_SC1STR _ADC_SC1 @0x00000010;
#define ADC_SC1                   _ADC_SC1.Byte
#define ADC_SC1_ADCH0             _ADC_SC1.Bits.ADCH0
#define ADC_SC1_ADCH1             _ADC_SC1.Bits.ADCH1
#define ADC_SC1_ADCH2             _ADC_SC1.Bits.ADCH2
#define ADC_SC1_ADCH3             _ADC_SC1.Bits.ADCH3
#define ADC_SC1_ADCH4             _ADC_SC1.Bits.ADCH4
#define ADC_SC1_ADCO              _ADC_SC1.Bits.ADCO
#define ADC_SC1_AIEN              _ADC_SC1.Bits.AIEN
#define ADC_SC1_COCO              _ADC_SC1.Bits.COCO
#define ADC_SC1_ADCH              _ADC_SC1.MergedBits.grpADCH

#define ADC_SC1_ADCH0_MASK        1U
#define ADC_SC1_ADCH0_BITNUM      0
#define ADC_SC1_ADCH1_MASK        2U
#define ADC_SC1_ADCH1_BITNUM      1
#define ADC_SC1_ADCH2_MASK        4U
#define ADC_SC1_ADCH2_BITNUM      2
#define ADC_SC1_ADCH3_MASK        8U
#define ADC_SC1_ADCH3_BITNUM      3
#define ADC_SC1_ADCH4_MASK        16U
#define ADC_SC1_ADCH4_BITNUM      4
#define ADC_SC1_ADCO_MASK         32U
#define ADC_SC1_ADCO_BITNUM       5
#define ADC_SC1_AIEN_MASK         64U
#define ADC_SC1_AIEN_BITNUM       6
#define ADC_SC1_COCO_MASK         128U
#define ADC_SC1_COCO_BITNUM       7
#define ADC_SC1_ADCH_MASK         31U
#define ADC_SC1_ADCH_BITNUM       0


/*** ADC_SC2 Status and Control Register 2; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte  REFSEL0    : 1;
    byte  REFSEL1    : 1;
    byte  FFULL      : 1;
    byte  FEMPTY     : 1;
    byte  ACFGT      : 1;
    byte  ACFE       : 1;
    byte  ADTRG      : 1;
    byte  ADACT      : 1;
  } Bits;
  struct {
    byte  grpREFSEL  : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ADC_SC2STR;
extern volatile ADC_SC2STR _ADC_SC2 @0x00000011;
#define ADC_SC2                   _ADC_SC2.Byte
#define ADC_SC2_REFSEL0           _ADC_SC2.Bits.REFSEL0
#define ADC_SC2_REFSEL1           _ADC_SC2.Bits.REFSEL1
#define ADC_SC2_FFULL             _ADC_SC2.Bits.FFULL
#define ADC_SC2_FEMPTY            _ADC_SC2.Bits.FEMPTY
#define ADC_SC2_ACFGT             _ADC_SC2.Bits.ACFGT
#define ADC_SC2_ACFE              _ADC_SC2.Bits.ACFE
#define ADC_SC2_ADTRG             _ADC_SC2.Bits.ADTRG
#define ADC_SC2_ADACT             _ADC_SC2.Bits.ADACT
#define ADC_SC2_REFSEL            _ADC_SC2.MergedBits.grpREFSEL

#define ADC_SC2_REFSEL0_MASK      1U
#define ADC_SC2_REFSEL0_BITNUM    0
#define ADC_SC2_REFSEL1_MASK      2U
#define ADC_SC2_REFSEL1_BITNUM    1
#define ADC_SC2_FFULL_MASK        4U
#define ADC_SC2_FFULL_BITNUM      2
#define ADC_SC2_FEMPTY_MASK       8U
#define ADC_SC2_FEMPTY_BITNUM     3
#define ADC_SC2_ACFGT_MASK        16U
#define ADC_SC2_ACFGT_BITNUM      4
#define ADC_SC2_ACFE_MASK         32U
#define ADC_SC2_ACFE_BITNUM       5
#define ADC_SC2_ADTRG_MASK        64U
#define ADC_SC2_ADTRG_BITNUM      6
#define ADC_SC2_ADACT_MASK        128U
#define ADC_SC2_ADACT_BITNUM      7
#define ADC_SC2_REFSEL_MASK       3U
#define ADC_SC2_REFSEL_BITNUM     0


/*** ADC_SC3 Status and Control Register 3; 0x00000012 ***/
typedef union {
  byte Byte;
  struct {
    byte  ADICLK0    : 1;
    byte  ADICLK1    : 1;
    byte  MODE0      : 1;
    byte  MODE1      : 1;
    byte  ADLSMP     : 1;
    byte  ADIV0      : 1;
    byte  ADIV1      : 1;
    byte  ADLPC      : 1;
  } Bits;
  struct {
    byte  grpADICLK  : 2;
    byte  grpMODE    : 2;
    byte             : 1;
    byte  grpADIV    : 2;
    byte             : 1;
  } MergedBits;
} ADC_SC3STR;
extern volatile ADC_SC3STR _ADC_SC3 @0x00000012;
#define ADC_SC3                   _ADC_SC3.Byte
#define ADC_SC3_ADICLK0           _ADC_SC3.Bits.ADICLK0
#define ADC_SC3_ADICLK1           _ADC_SC3.Bits.ADICLK1
#define ADC_SC3_MODE0             _ADC_SC3.Bits.MODE0
#define ADC_SC3_MODE1             _ADC_SC3.Bits.MODE1
#define ADC_SC3_ADLSMP            _ADC_SC3.Bits.ADLSMP
#define ADC_SC3_ADIV0             _ADC_SC3.Bits.ADIV0
#define ADC_SC3_ADIV1             _ADC_SC3.Bits.ADIV1
#define ADC_SC3_ADLPC             _ADC_SC3.Bits.ADLPC
#define ADC_SC3_ADICLK            _ADC_SC3.MergedBits.grpADICLK
#define ADC_SC3_MODE              _ADC_SC3.MergedBits.grpMODE
#define ADC_SC3_ADIV              _ADC_SC3.MergedBits.grpADIV

#define ADC_SC3_ADICLK0_MASK      1U
#define ADC_SC3_ADICLK0_BITNUM    0
#define ADC_SC3_ADICLK1_MASK      2U
#define ADC_SC3_ADICLK1_BITNUM    1
#define ADC_SC3_MODE0_MASK        4U
#define ADC_SC3_MODE0_BITNUM      2
#define ADC_SC3_MODE1_MASK        8U
#define ADC_SC3_MODE1_BITNUM      3
#define ADC_SC3_ADLSMP_MASK       16U
#define ADC_SC3_ADLSMP_BITNUM     4
#define ADC_SC3_ADIV0_MASK        32U
#define ADC_SC3_ADIV0_BITNUM      5
#define ADC_SC3_ADIV1_MASK        64U
#define ADC_SC3_ADIV1_BITNUM      6
#define ADC_SC3_ADLPC_MASK        128U
#define ADC_SC3_ADLPC_BITNUM      7
#define ADC_SC3_ADICLK_MASK       3U
#define ADC_SC3_ADICLK_BITNUM     0
#define ADC_SC3_MODE_MASK         12U
#define ADC_SC3_MODE_BITNUM       2
#define ADC_SC3_ADIV_MASK         96U
#define ADC_SC3_ADIV_BITNUM       5


/*** ADC_SC4 Status and Control Register 4; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte  AFDEP0     : 1;
    byte  AFDEP1     : 1;
    byte  AFDEP2     : 1;
    byte  HTRGMASKSEL : 1;
    byte  HTRGMASKE  : 1;
    byte  ACFSEL     : 1;
    byte  ASCANE     : 1;
    byte  HTRGME     : 1;
  } Bits;
  struct {
    byte  grpAFDEP   : 3;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ADC_SC4STR;
extern volatile ADC_SC4STR _ADC_SC4 @0x00000013;
#define ADC_SC4                   _ADC_SC4.Byte
#define ADC_SC4_AFDEP0            _ADC_SC4.Bits.AFDEP0
#define ADC_SC4_AFDEP1            _ADC_SC4.Bits.AFDEP1
#define ADC_SC4_AFDEP2            _ADC_SC4.Bits.AFDEP2
#define ADC_SC4_HTRGMASKSEL       _ADC_SC4.Bits.HTRGMASKSEL
#define ADC_SC4_HTRGMASKE         _ADC_SC4.Bits.HTRGMASKE
#define ADC_SC4_ACFSEL            _ADC_SC4.Bits.ACFSEL
#define ADC_SC4_ASCANE            _ADC_SC4.Bits.ASCANE
#define ADC_SC4_HTRGME            _ADC_SC4.Bits.HTRGME
#define ADC_SC4_AFDEP             _ADC_SC4.MergedBits.grpAFDEP

#define ADC_SC4_AFDEP0_MASK       1U
#define ADC_SC4_AFDEP0_BITNUM     0
#define ADC_SC4_AFDEP1_MASK       2U
#define ADC_SC4_AFDEP1_BITNUM     1
#define ADC_SC4_AFDEP2_MASK       4U
#define ADC_SC4_AFDEP2_BITNUM     2
#define ADC_SC4_HTRGMASKSEL_MASK  8U
#define ADC_SC4_HTRGMASKSEL_BITNUM 3
#define ADC_SC4_HTRGMASKE_MASK    16U
#define ADC_SC4_HTRGMASKE_BITNUM  4
#define ADC_SC4_ACFSEL_MASK       32U
#define ADC_SC4_ACFSEL_BITNUM     5
#define ADC_SC4_ASCANE_MASK       64U
#define ADC_SC4_ASCANE_BITNUM     6
#define ADC_SC4_HTRGME_MASK       128U
#define ADC_SC4_HTRGME_BITNUM     7
#define ADC_SC4_AFDEP_MASK        7U
#define ADC_SC4_AFDEP_BITNUM      0


/*** ADC_R Conversion Result Register; 0x00000014 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** ADC_RH Conversion Result High Register; 0x00000014 ***/
    union {
      byte Byte;
      struct {
        byte  ADR0       : 1;
        byte  ADR1       : 1;
        byte  ADR2       : 1;
        byte  ADR3       : 1;
        byte             : 1;
        byte             : 1;
        byte             : 1;
        byte             : 1;
      } Bits;
      struct {
        byte  grpADR     : 4;
        byte             : 1;
        byte             : 1;
        byte             : 1;
        byte             : 1;
      } MergedBits;
    } ADC_RHSTR;
    #define ADC_RH                    _ADC_R.Overlap_STR.ADC_RHSTR.Byte
    #define ADC_RH_ADR0               _ADC_R.Overlap_STR.ADC_RHSTR.Bits.ADR0
    #define ADC_RH_ADR1               _ADC_R.Overlap_STR.ADC_RHSTR.Bits.ADR1
    #define ADC_RH_ADR2               _ADC_R.Overlap_STR.ADC_RHSTR.Bits.ADR2
    #define ADC_RH_ADR3               _ADC_R.Overlap_STR.ADC_RHSTR.Bits.ADR3
    #define ADC_RH_ADR                _ADC_R.Overlap_STR.ADC_RHSTR.MergedBits.grpADR
    
    #define ADC_RH_ADR0_MASK          1U
    #define ADC_RH_ADR0_BITNUM        0
    #define ADC_RH_ADR1_MASK          2U
    #define ADC_RH_ADR1_BITNUM        1
    #define ADC_RH_ADR2_MASK          4U
    #define ADC_RH_ADR2_BITNUM        2
    #define ADC_RH_ADR3_MASK          8U
    #define ADC_RH_ADR3_BITNUM        3
    #define ADC_RH_ADR_MASK           15U
    #define ADC_RH_ADR_BITNUM         0
    
    /*** ADC_RL Conversion Result Low Register; 0x00000015 ***/
    union {
      byte Byte;
      struct {
        byte  ADR0       : 1;
        byte  ADR1       : 1;
        byte  ADR2       : 1;
        byte  ADR3       : 1;
        byte  ADR4       : 1;
        byte  ADR5       : 1;
        byte  ADR6       : 1;
        byte  ADR7       : 1;
      } Bits;
    } ADC_RLSTR;
    #define ADC_RL                    _ADC_R.Overlap_STR.ADC_RLSTR.Byte
    #define ADC_RL_ADR0               _ADC_R.Overlap_STR.ADC_RLSTR.Bits.ADR0
    #define ADC_RL_ADR1               _ADC_R.Overlap_STR.ADC_RLSTR.Bits.ADR1
    #define ADC_RL_ADR2               _ADC_R.Overlap_STR.ADC_RLSTR.Bits.ADR2
    #define ADC_RL_ADR3               _ADC_R.Overlap_STR.ADC_RLSTR.Bits.ADR3
    #define ADC_RL_ADR4               _ADC_R.Overlap_STR.ADC_RLSTR.Bits.ADR4
    #define ADC_RL_ADR5               _ADC_R.Overlap_STR.ADC_RLSTR.Bits.ADR5
    #define ADC_RL_ADR6               _ADC_R.Overlap_STR.ADC_RLSTR.Bits.ADR6
    #define ADC_RL_ADR7               _ADC_R.Overlap_STR.ADC_RLSTR.Bits.ADR7
    
    #define ADC_RL_ADR0_MASK          1U
    #define ADC_RL_ADR0_BITNUM        0
    #define ADC_RL_ADR1_MASK          2U
    #define ADC_RL_ADR1_BITNUM        1
    #define ADC_RL_ADR2_MASK          4U
    #define ADC_RL_ADR2_BITNUM        2
    #define ADC_RL_ADR3_MASK          8U
    #define ADC_RL_ADR3_BITNUM        3
    #define ADC_RL_ADR4_MASK          16U
    #define ADC_RL_ADR4_BITNUM        4
    #define ADC_RL_ADR5_MASK          32U
    #define ADC_RL_ADR5_BITNUM        5
    #define ADC_RL_ADR6_MASK          64U
    #define ADC_RL_ADR6_BITNUM        6
    #define ADC_RL_ADR7_MASK          128U
    #define ADC_RL_ADR7_BITNUM        7
    
  } Overlap_STR;
} ADC_RSTR;
extern volatile ADC_RSTR _ADC_R @0x00000014;
#define ADC_R                     _ADC_R.Word


/*** ADC_CV Compare Value Register; 0x00000016 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** ADC_CVH Compare Value High Register; 0x00000016 ***/
    union {
      byte Byte;
      struct {
        byte  CV0        : 1;
        byte  CV1        : 1;
        byte  CV2        : 1;
        byte  CV3        : 1;
        byte             : 1;
        byte             : 1;
        byte             : 1;
        byte             : 1;
      } Bits;
      struct {
        byte  grpCV      : 4;
        byte             : 1;
        byte             : 1;
        byte             : 1;
        byte             : 1;
      } MergedBits;
    } ADC_CVHSTR;
    #define ADC_CVH                   _ADC_CV.Overlap_STR.ADC_CVHSTR.Byte
    #define ADC_CVH_CV0               _ADC_CV.Overlap_STR.ADC_CVHSTR.Bits.CV0
    #define ADC_CVH_CV1               _ADC_CV.Overlap_STR.ADC_CVHSTR.Bits.CV1
    #define ADC_CVH_CV2               _ADC_CV.Overlap_STR.ADC_CVHSTR.Bits.CV2
    #define ADC_CVH_CV3               _ADC_CV.Overlap_STR.ADC_CVHSTR.Bits.CV3
    #define ADC_CVH_CV                _ADC_CV.Overlap_STR.ADC_CVHSTR.MergedBits.grpCV
    
    #define ADC_CVH_CV0_MASK          1U
    #define ADC_CVH_CV0_BITNUM        0
    #define ADC_CVH_CV1_MASK          2U
    #define ADC_CVH_CV1_BITNUM        1
    #define ADC_CVH_CV2_MASK          4U
    #define ADC_CVH_CV2_BITNUM        2
    #define ADC_CVH_CV3_MASK          8U
    #define ADC_CVH_CV3_BITNUM        3
    #define ADC_CVH_CV_MASK           15U
    #define ADC_CVH_CV_BITNUM         0
    
    /*** ADC_CVL Compare Value Low Register; 0x00000017 ***/
    union {
      byte Byte;
      struct {
        byte  CV0        : 1;
        byte  CV1        : 1;
        byte  CV2        : 1;
        byte  CV3        : 1;
        byte  CV4        : 1;
        byte  CV5        : 1;
        byte  CV6        : 1;
        byte  CV7        : 1;
      } Bits;
    } ADC_CVLSTR;
    #define ADC_CVL                   _ADC_CV.Overlap_STR.ADC_CVLSTR.Byte
    #define ADC_CVL_CV0               _ADC_CV.Overlap_STR.ADC_CVLSTR.Bits.CV0
    #define ADC_CVL_CV1               _ADC_CV.Overlap_STR.ADC_CVLSTR.Bits.CV1
    #define ADC_CVL_CV2               _ADC_CV.Overlap_STR.ADC_CVLSTR.Bits.CV2
    #define ADC_CVL_CV3               _ADC_CV.Overlap_STR.ADC_CVLSTR.Bits.CV3
    #define ADC_CVL_CV4               _ADC_CV.Overlap_STR.ADC_CVLSTR.Bits.CV4
    #define ADC_CVL_CV5               _ADC_CV.Overlap_STR.ADC_CVLSTR.Bits.CV5
    #define ADC_CVL_CV6               _ADC_CV.Overlap_STR.ADC_CVLSTR.Bits.CV6
    #define ADC_CVL_CV7               _ADC_CV.Overlap_STR.ADC_CVLSTR.Bits.CV7
    
    #define ADC_CVL_CV0_MASK          1U
    #define ADC_CVL_CV0_BITNUM        0
    #define ADC_CVL_CV1_MASK          2U
    #define ADC_CVL_CV1_BITNUM        1
    #define ADC_CVL_CV2_MASK          4U
    #define ADC_CVL_CV2_BITNUM        2
    #define ADC_CVL_CV3_MASK          8U
    #define ADC_CVL_CV3_BITNUM        3
    #define ADC_CVL_CV4_MASK          16U
    #define ADC_CVL_CV4_BITNUM        4
    #define ADC_CVL_CV5_MASK          32U
    #define ADC_CVL_CV5_BITNUM        5
    #define ADC_CVL_CV6_MASK          64U
    #define ADC_CVL_CV6_BITNUM        6
    #define ADC_CVL_CV7_MASK          128U
    #define ADC_CVL_CV7_BITNUM        7
    
  } Overlap_STR;
} ADC_CVSTR;
extern volatile ADC_CVSTR _ADC_CV @0x00000016;
#define ADC_CV                    _ADC_CV.Word


/*** MTIM0_SC MTIM Status and Control Register; 0x00000018 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  TSTP       : 1;
    byte  TRST       : 1;
    byte  TOIE       : 1;
    byte  TOF        : 1;
  } Bits;
} MTIM0_SCSTR;
extern volatile MTIM0_SCSTR _MTIM0_SC @0x00000018;
#define MTIM0_SC                  _MTIM0_SC.Byte
#define MTIM0_SC_TSTP             _MTIM0_SC.Bits.TSTP
#define MTIM0_SC_TRST             _MTIM0_SC.Bits.TRST
#define MTIM0_SC_TOIE             _MTIM0_SC.Bits.TOIE
#define MTIM0_SC_TOF              _MTIM0_SC.Bits.TOF

#define MTIM0_SC_TSTP_MASK        16U
#define MTIM0_SC_TSTP_BITNUM      4
#define MTIM0_SC_TRST_MASK        32U
#define MTIM0_SC_TRST_BITNUM      5
#define MTIM0_SC_TOIE_MASK        64U
#define MTIM0_SC_TOIE_BITNUM      6
#define MTIM0_SC_TOF_MASK         128U
#define MTIM0_SC_TOF_BITNUM       7


/*** MTIM0_CLK MTIM Clock Configuration Register; 0x00000019 ***/
typedef union {
  byte Byte;
  struct {
    byte  PS0        : 1;
    byte  PS1        : 1;
    byte  PS2        : 1;
    byte  PS3        : 1;
    byte  CLKS0      : 1;
    byte  CLKS1      : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPS      : 4;
    byte  grpCLKS    : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} MTIM0_CLKSTR;
extern volatile MTIM0_CLKSTR _MTIM0_CLK @0x00000019;
#define MTIM0_CLK                 _MTIM0_CLK.Byte
#define MTIM0_CLK_PS0             _MTIM0_CLK.Bits.PS0
#define MTIM0_CLK_PS1             _MTIM0_CLK.Bits.PS1
#define MTIM0_CLK_PS2             _MTIM0_CLK.Bits.PS2
#define MTIM0_CLK_PS3             _MTIM0_CLK.Bits.PS3
#define MTIM0_CLK_CLKS0           _MTIM0_CLK.Bits.CLKS0
#define MTIM0_CLK_CLKS1           _MTIM0_CLK.Bits.CLKS1
#define MTIM0_CLK_PS              _MTIM0_CLK.MergedBits.grpPS
#define MTIM0_CLK_CLKS            _MTIM0_CLK.MergedBits.grpCLKS

#define MTIM0_CLK_PS0_MASK        1U
#define MTIM0_CLK_PS0_BITNUM      0
#define MTIM0_CLK_PS1_MASK        2U
#define MTIM0_CLK_PS1_BITNUM      1
#define MTIM0_CLK_PS2_MASK        4U
#define MTIM0_CLK_PS2_BITNUM      2
#define MTIM0_CLK_PS3_MASK        8U
#define MTIM0_CLK_PS3_BITNUM      3
#define MTIM0_CLK_CLKS0_MASK      16U
#define MTIM0_CLK_CLKS0_BITNUM    4
#define MTIM0_CLK_CLKS1_MASK      32U
#define MTIM0_CLK_CLKS1_BITNUM    5
#define MTIM0_CLK_PS_MASK         15U
#define MTIM0_CLK_PS_BITNUM       0
#define MTIM0_CLK_CLKS_MASK       48U
#define MTIM0_CLK_CLKS_BITNUM     4


/*** MTIM0_CNT MTIM Counter Register; 0x0000001A ***/
typedef union {
  byte Byte;
  struct {
    byte  COUNT0     : 1;
    byte  COUNT1     : 1;
    byte  COUNT2     : 1;
    byte  COUNT3     : 1;
    byte  COUNT4     : 1;
    byte  COUNT5     : 1;
    byte  COUNT6     : 1;
    byte  COUNT7     : 1;
  } Bits;
} MTIM0_CNTSTR;
extern volatile MTIM0_CNTSTR _MTIM0_CNT @0x0000001A;
#define MTIM0_CNT                 _MTIM0_CNT.Byte
#define MTIM0_CNT_COUNT0          _MTIM0_CNT.Bits.COUNT0
#define MTIM0_CNT_COUNT1          _MTIM0_CNT.Bits.COUNT1
#define MTIM0_CNT_COUNT2          _MTIM0_CNT.Bits.COUNT2
#define MTIM0_CNT_COUNT3          _MTIM0_CNT.Bits.COUNT3
#define MTIM0_CNT_COUNT4          _MTIM0_CNT.Bits.COUNT4
#define MTIM0_CNT_COUNT5          _MTIM0_CNT.Bits.COUNT5
#define MTIM0_CNT_COUNT6          _MTIM0_CNT.Bits.COUNT6
#define MTIM0_CNT_COUNT7          _MTIM0_CNT.Bits.COUNT7

#define MTIM0_CNT_COUNT0_MASK     1U
#define MTIM0_CNT_COUNT0_BITNUM   0
#define MTIM0_CNT_COUNT1_MASK     2U
#define MTIM0_CNT_COUNT1_BITNUM   1
#define MTIM0_CNT_COUNT2_MASK     4U
#define MTIM0_CNT_COUNT2_BITNUM   2
#define MTIM0_CNT_COUNT3_MASK     8U
#define MTIM0_CNT_COUNT3_BITNUM   3
#define MTIM0_CNT_COUNT4_MASK     16U
#define MTIM0_CNT_COUNT4_BITNUM   4
#define MTIM0_CNT_COUNT5_MASK     32U
#define MTIM0_CNT_COUNT5_BITNUM   5
#define MTIM0_CNT_COUNT6_MASK     64U
#define MTIM0_CNT_COUNT6_BITNUM   6
#define MTIM0_CNT_COUNT7_MASK     128U
#define MTIM0_CNT_COUNT7_BITNUM   7


/*** MTIM0_MOD MTIM Modulo Register; 0x0000001B ***/
typedef union {
  byte Byte;
  struct {
    byte  MOD0       : 1;
    byte  MOD1       : 1;
    byte  MOD2       : 1;
    byte  MOD3       : 1;
    byte  MOD4       : 1;
    byte  MOD5       : 1;
    byte  MOD6       : 1;
    byte  MOD7       : 1;
  } Bits;
} MTIM0_MODSTR;
extern volatile MTIM0_MODSTR _MTIM0_MOD @0x0000001B;
#define MTIM0_MOD                 _MTIM0_MOD.Byte
#define MTIM0_MOD_MOD0            _MTIM0_MOD.Bits.MOD0
#define MTIM0_MOD_MOD1            _MTIM0_MOD.Bits.MOD1
#define MTIM0_MOD_MOD2            _MTIM0_MOD.Bits.MOD2
#define MTIM0_MOD_MOD3            _MTIM0_MOD.Bits.MOD3
#define MTIM0_MOD_MOD4            _MTIM0_MOD.Bits.MOD4
#define MTIM0_MOD_MOD5            _MTIM0_MOD.Bits.MOD5
#define MTIM0_MOD_MOD6            _MTIM0_MOD.Bits.MOD6
#define MTIM0_MOD_MOD7            _MTIM0_MOD.Bits.MOD7

#define MTIM0_MOD_MOD0_MASK       1U
#define MTIM0_MOD_MOD0_BITNUM     0
#define MTIM0_MOD_MOD1_MASK       2U
#define MTIM0_MOD_MOD1_BITNUM     1
#define MTIM0_MOD_MOD2_MASK       4U
#define MTIM0_MOD_MOD2_BITNUM     2
#define MTIM0_MOD_MOD3_MASK       8U
#define MTIM0_MOD_MOD3_BITNUM     3
#define MTIM0_MOD_MOD4_MASK       16U
#define MTIM0_MOD_MOD4_BITNUM     4
#define MTIM0_MOD_MOD5_MASK       32U
#define MTIM0_MOD_MOD5_BITNUM     5
#define MTIM0_MOD_MOD6_MASK       64U
#define MTIM0_MOD_MOD6_BITNUM     6
#define MTIM0_MOD_MOD7_MASK       128U
#define MTIM0_MOD_MOD7_BITNUM     7


/*** MTIM1_SC MTIM Status and Control Register; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  TSTP       : 1;
    byte  TRST       : 1;
    byte  TOIE       : 1;
    byte  TOF        : 1;
  } Bits;
} MTIM1_SCSTR;
extern volatile MTIM1_SCSTR _MTIM1_SC @0x0000001C;
#define MTIM1_SC                  _MTIM1_SC.Byte
#define MTIM1_SC_TSTP             _MTIM1_SC.Bits.TSTP
#define MTIM1_SC_TRST             _MTIM1_SC.Bits.TRST
#define MTIM1_SC_TOIE             _MTIM1_SC.Bits.TOIE
#define MTIM1_SC_TOF              _MTIM1_SC.Bits.TOF

#define MTIM1_SC_TSTP_MASK        16U
#define MTIM1_SC_TSTP_BITNUM      4
#define MTIM1_SC_TRST_MASK        32U
#define MTIM1_SC_TRST_BITNUM      5
#define MTIM1_SC_TOIE_MASK        64U
#define MTIM1_SC_TOIE_BITNUM      6
#define MTIM1_SC_TOF_MASK         128U
#define MTIM1_SC_TOF_BITNUM       7


/*** MTIM1_CLK MTIM Clock Configuration Register; 0x0000001D ***/
typedef union {
  byte Byte;
  struct {
    byte  PS0        : 1;
    byte  PS1        : 1;
    byte  PS2        : 1;
    byte  PS3        : 1;
    byte  CLKS0      : 1;
    byte  CLKS1      : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPS      : 4;
    byte  grpCLKS    : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} MTIM1_CLKSTR;
extern volatile MTIM1_CLKSTR _MTIM1_CLK @0x0000001D;
#define MTIM1_CLK                 _MTIM1_CLK.Byte
#define MTIM1_CLK_PS0             _MTIM1_CLK.Bits.PS0
#define MTIM1_CLK_PS1             _MTIM1_CLK.Bits.PS1
#define MTIM1_CLK_PS2             _MTIM1_CLK.Bits.PS2
#define MTIM1_CLK_PS3             _MTIM1_CLK.Bits.PS3
#define MTIM1_CLK_CLKS0           _MTIM1_CLK.Bits.CLKS0
#define MTIM1_CLK_CLKS1           _MTIM1_CLK.Bits.CLKS1
#define MTIM1_CLK_PS              _MTIM1_CLK.MergedBits.grpPS
#define MTIM1_CLK_CLKS            _MTIM1_CLK.MergedBits.grpCLKS

#define MTIM1_CLK_PS0_MASK        1U
#define MTIM1_CLK_PS0_BITNUM      0
#define MTIM1_CLK_PS1_MASK        2U
#define MTIM1_CLK_PS1_BITNUM      1
#define MTIM1_CLK_PS2_MASK        4U
#define MTIM1_CLK_PS2_BITNUM      2
#define MTIM1_CLK_PS3_MASK        8U
#define MTIM1_CLK_PS3_BITNUM      3
#define MTIM1_CLK_CLKS0_MASK      16U
#define MTIM1_CLK_CLKS0_BITNUM    4
#define MTIM1_CLK_CLKS1_MASK      32U
#define MTIM1_CLK_CLKS1_BITNUM    5
#define MTIM1_CLK_PS_MASK         15U
#define MTIM1_CLK_PS_BITNUM       0
#define MTIM1_CLK_CLKS_MASK       48U
#define MTIM1_CLK_CLKS_BITNUM     4


/*** MTIM1_CNT MTIM Counter Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte  COUNT0     : 1;
    byte  COUNT1     : 1;
    byte  COUNT2     : 1;
    byte  COUNT3     : 1;
    byte  COUNT4     : 1;
    byte  COUNT5     : 1;
    byte  COUNT6     : 1;
    byte  COUNT7     : 1;
  } Bits;
} MTIM1_CNTSTR;
extern volatile MTIM1_CNTSTR _MTIM1_CNT @0x0000001E;
#define MTIM1_CNT                 _MTIM1_CNT.Byte
#define MTIM1_CNT_COUNT0          _MTIM1_CNT.Bits.COUNT0
#define MTIM1_CNT_COUNT1          _MTIM1_CNT.Bits.COUNT1
#define MTIM1_CNT_COUNT2          _MTIM1_CNT.Bits.COUNT2
#define MTIM1_CNT_COUNT3          _MTIM1_CNT.Bits.COUNT3
#define MTIM1_CNT_COUNT4          _MTIM1_CNT.Bits.COUNT4
#define MTIM1_CNT_COUNT5          _MTIM1_CNT.Bits.COUNT5
#define MTIM1_CNT_COUNT6          _MTIM1_CNT.Bits.COUNT6
#define MTIM1_CNT_COUNT7          _MTIM1_CNT.Bits.COUNT7

#define MTIM1_CNT_COUNT0_MASK     1U
#define MTIM1_CNT_COUNT0_BITNUM   0
#define MTIM1_CNT_COUNT1_MASK     2U
#define MTIM1_CNT_COUNT1_BITNUM   1
#define MTIM1_CNT_COUNT2_MASK     4U
#define MTIM1_CNT_COUNT2_BITNUM   2
#define MTIM1_CNT_COUNT3_MASK     8U
#define MTIM1_CNT_COUNT3_BITNUM   3
#define MTIM1_CNT_COUNT4_MASK     16U
#define MTIM1_CNT_COUNT4_BITNUM   4
#define MTIM1_CNT_COUNT5_MASK     32U
#define MTIM1_CNT_COUNT5_BITNUM   5
#define MTIM1_CNT_COUNT6_MASK     64U
#define MTIM1_CNT_COUNT6_BITNUM   6
#define MTIM1_CNT_COUNT7_MASK     128U
#define MTIM1_CNT_COUNT7_BITNUM   7


/*** MTIM1_MOD MTIM Modulo Register; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte  MOD0       : 1;
    byte  MOD1       : 1;
    byte  MOD2       : 1;
    byte  MOD3       : 1;
    byte  MOD4       : 1;
    byte  MOD5       : 1;
    byte  MOD6       : 1;
    byte  MOD7       : 1;
  } Bits;
} MTIM1_MODSTR;
extern volatile MTIM1_MODSTR _MTIM1_MOD @0x0000001F;
#define MTIM1_MOD                 _MTIM1_MOD.Byte
#define MTIM1_MOD_MOD0            _MTIM1_MOD.Bits.MOD0
#define MTIM1_MOD_MOD1            _MTIM1_MOD.Bits.MOD1
#define MTIM1_MOD_MOD2            _MTIM1_MOD.Bits.MOD2
#define MTIM1_MOD_MOD3            _MTIM1_MOD.Bits.MOD3
#define MTIM1_MOD_MOD4            _MTIM1_MOD.Bits.MOD4
#define MTIM1_MOD_MOD5            _MTIM1_MOD.Bits.MOD5
#define MTIM1_MOD_MOD6            _MTIM1_MOD.Bits.MOD6
#define MTIM1_MOD_MOD7            _MTIM1_MOD.Bits.MOD7

#define MTIM1_MOD_MOD0_MASK       1U
#define MTIM1_MOD_MOD0_BITNUM     0
#define MTIM1_MOD_MOD1_MASK       2U
#define MTIM1_MOD_MOD1_BITNUM     1
#define MTIM1_MOD_MOD2_MASK       4U
#define MTIM1_MOD_MOD2_BITNUM     2
#define MTIM1_MOD_MOD3_MASK       8U
#define MTIM1_MOD_MOD3_BITNUM     3
#define MTIM1_MOD_MOD4_MASK       16U
#define MTIM1_MOD_MOD4_BITNUM     4
#define MTIM1_MOD_MOD5_MASK       32U
#define MTIM1_MOD_MOD5_BITNUM     5
#define MTIM1_MOD_MOD6_MASK       64U
#define MTIM1_MOD_MOD6_BITNUM     6
#define MTIM1_MOD_MOD7_MASK       128U
#define MTIM1_MOD_MOD7_BITNUM     7


/*** FTM0_SC Status and Control; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte  PS0        : 1;
    byte  PS1        : 1;
    byte  PS2        : 1;
    byte  CLKS0      : 1;
    byte  CLKS1      : 1;
    byte  CPWMS      : 1;
    byte  TOIE       : 1;
    byte  TOF        : 1;
  } Bits;
  struct {
    byte  grpPS      : 3;
    byte  grpCLKS    : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM0_SCSTR;
extern volatile FTM0_SCSTR _FTM0_SC @0x00000020;
#define FTM0_SC                   _FTM0_SC.Byte
#define FTM0_SC_PS0               _FTM0_SC.Bits.PS0
#define FTM0_SC_PS1               _FTM0_SC.Bits.PS1
#define FTM0_SC_PS2               _FTM0_SC.Bits.PS2
#define FTM0_SC_CLKS0             _FTM0_SC.Bits.CLKS0
#define FTM0_SC_CLKS1             _FTM0_SC.Bits.CLKS1
#define FTM0_SC_CPWMS             _FTM0_SC.Bits.CPWMS
#define FTM0_SC_TOIE              _FTM0_SC.Bits.TOIE
#define FTM0_SC_TOF               _FTM0_SC.Bits.TOF
#define FTM0_SC_PS                _FTM0_SC.MergedBits.grpPS
#define FTM0_SC_CLKS              _FTM0_SC.MergedBits.grpCLKS

#define FTM0_SC_PS0_MASK          1U
#define FTM0_SC_PS0_BITNUM        0
#define FTM0_SC_PS1_MASK          2U
#define FTM0_SC_PS1_BITNUM        1
#define FTM0_SC_PS2_MASK          4U
#define FTM0_SC_PS2_BITNUM        2
#define FTM0_SC_CLKS0_MASK        8U
#define FTM0_SC_CLKS0_BITNUM      3
#define FTM0_SC_CLKS1_MASK        16U
#define FTM0_SC_CLKS1_BITNUM      4
#define FTM0_SC_CPWMS_MASK        32U
#define FTM0_SC_CPWMS_BITNUM      5
#define FTM0_SC_TOIE_MASK         64U
#define FTM0_SC_TOIE_BITNUM       6
#define FTM0_SC_TOF_MASK          128U
#define FTM0_SC_TOF_BITNUM        7
#define FTM0_SC_PS_MASK           7U
#define FTM0_SC_PS_BITNUM         0
#define FTM0_SC_CLKS_MASK         24U
#define FTM0_SC_CLKS_BITNUM       3


/*** FTM0_CNT Counter  0x00000021 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM0_CNTH Counter High; 0x00000021 ***/
    union {
      byte Byte;
      struct {
        byte  COUNT_H0   : 1;
        byte  COUNT_H1   : 1;
        byte  COUNT_H2   : 1;
        byte  COUNT_H3   : 1;
        byte  COUNT_H4   : 1;
        byte  COUNT_H5   : 1;
        byte  COUNT_H6   : 1;
        byte  COUNT_H7   : 1;
      } Bits;
    } FTM0_CNTHSTR;
    #define FTM0_CNTH                 _FTM0_CNT.Overlap_STR.FTM0_CNTHSTR.Byte
    #define FTM0_CNTH_COUNT_H0        _FTM0_CNT.Overlap_STR.FTM0_CNTHSTR.Bits.COUNT_H0
    #define FTM0_CNTH_COUNT_H1        _FTM0_CNT.Overlap_STR.FTM0_CNTHSTR.Bits.COUNT_H1
    #define FTM0_CNTH_COUNT_H2        _FTM0_CNT.Overlap_STR.FTM0_CNTHSTR.Bits.COUNT_H2
    #define FTM0_CNTH_COUNT_H3        _FTM0_CNT.Overlap_STR.FTM0_CNTHSTR.Bits.COUNT_H3
    #define FTM0_CNTH_COUNT_H4        _FTM0_CNT.Overlap_STR.FTM0_CNTHSTR.Bits.COUNT_H4
    #define FTM0_CNTH_COUNT_H5        _FTM0_CNT.Overlap_STR.FTM0_CNTHSTR.Bits.COUNT_H5
    #define FTM0_CNTH_COUNT_H6        _FTM0_CNT.Overlap_STR.FTM0_CNTHSTR.Bits.COUNT_H6
    #define FTM0_CNTH_COUNT_H7        _FTM0_CNT.Overlap_STR.FTM0_CNTHSTR.Bits.COUNT_H7
    
    #define FTM0_CNTH_COUNT_H0_MASK   1U
    #define FTM0_CNTH_COUNT_H0_BITNUM 0
    #define FTM0_CNTH_COUNT_H1_MASK   2U
    #define FTM0_CNTH_COUNT_H1_BITNUM 1
    #define FTM0_CNTH_COUNT_H2_MASK   4U
    #define FTM0_CNTH_COUNT_H2_BITNUM 2
    #define FTM0_CNTH_COUNT_H3_MASK   8U
    #define FTM0_CNTH_COUNT_H3_BITNUM 3
    #define FTM0_CNTH_COUNT_H4_MASK   16U
    #define FTM0_CNTH_COUNT_H4_BITNUM 4
    #define FTM0_CNTH_COUNT_H5_MASK   32U
    #define FTM0_CNTH_COUNT_H5_BITNUM 5
    #define FTM0_CNTH_COUNT_H6_MASK   64U
    #define FTM0_CNTH_COUNT_H6_BITNUM 6
    #define FTM0_CNTH_COUNT_H7_MASK   128U
    #define FTM0_CNTH_COUNT_H7_BITNUM 7
    
    /*** FTM0_CNTL Counter Low; 0x00000022 ***/
    union {
      byte Byte;
      struct {
        byte  COUNT_L0   : 1;
        byte  COUNT_L1   : 1;
        byte  COUNT_L2   : 1;
        byte  COUNT_L3   : 1;
        byte  COUNT_L4   : 1;
        byte  COUNT_L5   : 1;
        byte  COUNT_L6   : 1;
        byte  COUNT_L7   : 1;
      } Bits;
    } FTM0_CNTLSTR;
    #define FTM0_CNTL                 _FTM0_CNT.Overlap_STR.FTM0_CNTLSTR.Byte
    #define FTM0_CNTL_COUNT_L0        _FTM0_CNT.Overlap_STR.FTM0_CNTLSTR.Bits.COUNT_L0
    #define FTM0_CNTL_COUNT_L1        _FTM0_CNT.Overlap_STR.FTM0_CNTLSTR.Bits.COUNT_L1
    #define FTM0_CNTL_COUNT_L2        _FTM0_CNT.Overlap_STR.FTM0_CNTLSTR.Bits.COUNT_L2
    #define FTM0_CNTL_COUNT_L3        _FTM0_CNT.Overlap_STR.FTM0_CNTLSTR.Bits.COUNT_L3
    #define FTM0_CNTL_COUNT_L4        _FTM0_CNT.Overlap_STR.FTM0_CNTLSTR.Bits.COUNT_L4
    #define FTM0_CNTL_COUNT_L5        _FTM0_CNT.Overlap_STR.FTM0_CNTLSTR.Bits.COUNT_L5
    #define FTM0_CNTL_COUNT_L6        _FTM0_CNT.Overlap_STR.FTM0_CNTLSTR.Bits.COUNT_L6
    #define FTM0_CNTL_COUNT_L7        _FTM0_CNT.Overlap_STR.FTM0_CNTLSTR.Bits.COUNT_L7
    
    #define FTM0_CNTL_COUNT_L0_MASK   1U
    #define FTM0_CNTL_COUNT_L0_BITNUM 0
    #define FTM0_CNTL_COUNT_L1_MASK   2U
    #define FTM0_CNTL_COUNT_L1_BITNUM 1
    #define FTM0_CNTL_COUNT_L2_MASK   4U
    #define FTM0_CNTL_COUNT_L2_BITNUM 2
    #define FTM0_CNTL_COUNT_L3_MASK   8U
    #define FTM0_CNTL_COUNT_L3_BITNUM 3
    #define FTM0_CNTL_COUNT_L4_MASK   16U
    #define FTM0_CNTL_COUNT_L4_BITNUM 4
    #define FTM0_CNTL_COUNT_L5_MASK   32U
    #define FTM0_CNTL_COUNT_L5_BITNUM 5
    #define FTM0_CNTL_COUNT_L6_MASK   64U
    #define FTM0_CNTL_COUNT_L6_BITNUM 6
    #define FTM0_CNTL_COUNT_L7_MASK   128U
    #define FTM0_CNTL_COUNT_L7_BITNUM 7
    
  } Overlap_STR;
} FTM0_CNTSTR;
extern volatile FTM0_CNTSTR _FTM0_CNT @0x00000021;
#define FTM0_CNT                  _FTM0_CNT.Word


/*** FTM0_MOD Modulo  0x00000023 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM0_MODH Modulo High; 0x00000023 ***/
    union {
      byte Byte;
      struct {
        byte  MOD_H0     : 1;
        byte  MOD_H1     : 1;
        byte  MOD_H2     : 1;
        byte  MOD_H3     : 1;
        byte  MOD_H4     : 1;
        byte  MOD_H5     : 1;
        byte  MOD_H6     : 1;
        byte  MOD_H7     : 1;
      } Bits;
    } FTM0_MODHSTR;
    #define FTM0_MODH                 _FTM0_MOD.Overlap_STR.FTM0_MODHSTR.Byte
    #define FTM0_MODH_MOD_H0          _FTM0_MOD.Overlap_STR.FTM0_MODHSTR.Bits.MOD_H0
    #define FTM0_MODH_MOD_H1          _FTM0_MOD.Overlap_STR.FTM0_MODHSTR.Bits.MOD_H1
    #define FTM0_MODH_MOD_H2          _FTM0_MOD.Overlap_STR.FTM0_MODHSTR.Bits.MOD_H2
    #define FTM0_MODH_MOD_H3          _FTM0_MOD.Overlap_STR.FTM0_MODHSTR.Bits.MOD_H3
    #define FTM0_MODH_MOD_H4          _FTM0_MOD.Overlap_STR.FTM0_MODHSTR.Bits.MOD_H4
    #define FTM0_MODH_MOD_H5          _FTM0_MOD.Overlap_STR.FTM0_MODHSTR.Bits.MOD_H5
    #define FTM0_MODH_MOD_H6          _FTM0_MOD.Overlap_STR.FTM0_MODHSTR.Bits.MOD_H6
    #define FTM0_MODH_MOD_H7          _FTM0_MOD.Overlap_STR.FTM0_MODHSTR.Bits.MOD_H7
    
    #define FTM0_MODH_MOD_H0_MASK     1U
    #define FTM0_MODH_MOD_H0_BITNUM   0
    #define FTM0_MODH_MOD_H1_MASK     2U
    #define FTM0_MODH_MOD_H1_BITNUM   1
    #define FTM0_MODH_MOD_H2_MASK     4U
    #define FTM0_MODH_MOD_H2_BITNUM   2
    #define FTM0_MODH_MOD_H3_MASK     8U
    #define FTM0_MODH_MOD_H3_BITNUM   3
    #define FTM0_MODH_MOD_H4_MASK     16U
    #define FTM0_MODH_MOD_H4_BITNUM   4
    #define FTM0_MODH_MOD_H5_MASK     32U
    #define FTM0_MODH_MOD_H5_BITNUM   5
    #define FTM0_MODH_MOD_H6_MASK     64U
    #define FTM0_MODH_MOD_H6_BITNUM   6
    #define FTM0_MODH_MOD_H7_MASK     128U
    #define FTM0_MODH_MOD_H7_BITNUM   7
    
    /*** FTM0_MODL Modulo Low; 0x00000024 ***/
    union {
      byte Byte;
      struct {
        byte  MOD_L0     : 1;
        byte  MOD_L1     : 1;
        byte  MOD_L2     : 1;
        byte  MOD_L3     : 1;
        byte  MOD_L4     : 1;
        byte  MOD_L5     : 1;
        byte  MOD_L6     : 1;
        byte  MOD_L7     : 1;
      } Bits;
    } FTM0_MODLSTR;
    #define FTM0_MODL                 _FTM0_MOD.Overlap_STR.FTM0_MODLSTR.Byte
    #define FTM0_MODL_MOD_L0          _FTM0_MOD.Overlap_STR.FTM0_MODLSTR.Bits.MOD_L0
    #define FTM0_MODL_MOD_L1          _FTM0_MOD.Overlap_STR.FTM0_MODLSTR.Bits.MOD_L1
    #define FTM0_MODL_MOD_L2          _FTM0_MOD.Overlap_STR.FTM0_MODLSTR.Bits.MOD_L2
    #define FTM0_MODL_MOD_L3          _FTM0_MOD.Overlap_STR.FTM0_MODLSTR.Bits.MOD_L3
    #define FTM0_MODL_MOD_L4          _FTM0_MOD.Overlap_STR.FTM0_MODLSTR.Bits.MOD_L4
    #define FTM0_MODL_MOD_L5          _FTM0_MOD.Overlap_STR.FTM0_MODLSTR.Bits.MOD_L5
    #define FTM0_MODL_MOD_L6          _FTM0_MOD.Overlap_STR.FTM0_MODLSTR.Bits.MOD_L6
    #define FTM0_MODL_MOD_L7          _FTM0_MOD.Overlap_STR.FTM0_MODLSTR.Bits.MOD_L7
    
    #define FTM0_MODL_MOD_L0_MASK     1U
    #define FTM0_MODL_MOD_L0_BITNUM   0
    #define FTM0_MODL_MOD_L1_MASK     2U
    #define FTM0_MODL_MOD_L1_BITNUM   1
    #define FTM0_MODL_MOD_L2_MASK     4U
    #define FTM0_MODL_MOD_L2_BITNUM   2
    #define FTM0_MODL_MOD_L3_MASK     8U
    #define FTM0_MODL_MOD_L3_BITNUM   3
    #define FTM0_MODL_MOD_L4_MASK     16U
    #define FTM0_MODL_MOD_L4_BITNUM   4
    #define FTM0_MODL_MOD_L5_MASK     32U
    #define FTM0_MODL_MOD_L5_BITNUM   5
    #define FTM0_MODL_MOD_L6_MASK     64U
    #define FTM0_MODL_MOD_L6_BITNUM   6
    #define FTM0_MODL_MOD_L7_MASK     128U
    #define FTM0_MODL_MOD_L7_BITNUM   7
    
  } Overlap_STR;
} FTM0_MODSTR;
extern volatile FTM0_MODSTR _FTM0_MOD @0x00000023;
#define FTM0_MOD                  _FTM0_MOD.Word


/*** FTM0_C0SC Channel Status and Control; 0x00000025 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  ELSA       : 1;
    byte  ELSB       : 1;
    byte  MSA        : 1;
    byte  MSB        : 1;
    byte  CHIE       : 1;
    byte  CHF        : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte  grpELSx    : 2;
    byte  grpMSx     : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM0_C0SCSTR;
extern volatile FTM0_C0SCSTR _FTM0_C0SC @0x00000025;
#define FTM0_C0SC                 _FTM0_C0SC.Byte
#define FTM0_C0SC_ELSA            _FTM0_C0SC.Bits.ELSA
#define FTM0_C0SC_ELSB            _FTM0_C0SC.Bits.ELSB
#define FTM0_C0SC_MSA             _FTM0_C0SC.Bits.MSA
#define FTM0_C0SC_MSB             _FTM0_C0SC.Bits.MSB
#define FTM0_C0SC_CHIE            _FTM0_C0SC.Bits.CHIE
#define FTM0_C0SC_CHF             _FTM0_C0SC.Bits.CHF
#define FTM0_C0SC_ELSx            _FTM0_C0SC.MergedBits.grpELSx
#define FTM0_C0SC_MSx             _FTM0_C0SC.MergedBits.grpMSx

#define FTM0_C0SC_ELSA_MASK       4U
#define FTM0_C0SC_ELSA_BITNUM     2
#define FTM0_C0SC_ELSB_MASK       8U
#define FTM0_C0SC_ELSB_BITNUM     3
#define FTM0_C0SC_MSA_MASK        16U
#define FTM0_C0SC_MSA_BITNUM      4
#define FTM0_C0SC_MSB_MASK        32U
#define FTM0_C0SC_MSB_BITNUM      5
#define FTM0_C0SC_CHIE_MASK       64U
#define FTM0_C0SC_CHIE_BITNUM     6
#define FTM0_C0SC_CHF_MASK        128U
#define FTM0_C0SC_CHF_BITNUM      7
#define FTM0_C0SC_ELSx_MASK       12U
#define FTM0_C0SC_ELSx_BITNUM     2
#define FTM0_C0SC_MSx_MASK        48U
#define FTM0_C0SC_MSx_BITNUM      4


/*** FTM0_C0V Channel Value  0x00000026 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM0_C0VH Channel Value High; 0x00000026 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_H0     : 1;
        byte  VAL_H1     : 1;
        byte  VAL_H2     : 1;
        byte  VAL_H3     : 1;
        byte  VAL_H4     : 1;
        byte  VAL_H5     : 1;
        byte  VAL_H6     : 1;
        byte  VAL_H7     : 1;
      } Bits;
    } FTM0_C0VHSTR;
    #define FTM0_C0VH                 _FTM0_C0V.Overlap_STR.FTM0_C0VHSTR.Byte
    #define FTM0_C0VH_VAL_H0          _FTM0_C0V.Overlap_STR.FTM0_C0VHSTR.Bits.VAL_H0
    #define FTM0_C0VH_VAL_H1          _FTM0_C0V.Overlap_STR.FTM0_C0VHSTR.Bits.VAL_H1
    #define FTM0_C0VH_VAL_H2          _FTM0_C0V.Overlap_STR.FTM0_C0VHSTR.Bits.VAL_H2
    #define FTM0_C0VH_VAL_H3          _FTM0_C0V.Overlap_STR.FTM0_C0VHSTR.Bits.VAL_H3
    #define FTM0_C0VH_VAL_H4          _FTM0_C0V.Overlap_STR.FTM0_C0VHSTR.Bits.VAL_H4
    #define FTM0_C0VH_VAL_H5          _FTM0_C0V.Overlap_STR.FTM0_C0VHSTR.Bits.VAL_H5
    #define FTM0_C0VH_VAL_H6          _FTM0_C0V.Overlap_STR.FTM0_C0VHSTR.Bits.VAL_H6
    #define FTM0_C0VH_VAL_H7          _FTM0_C0V.Overlap_STR.FTM0_C0VHSTR.Bits.VAL_H7
    
    #define FTM0_C0VH_VAL_H0_MASK     1U
    #define FTM0_C0VH_VAL_H0_BITNUM   0
    #define FTM0_C0VH_VAL_H1_MASK     2U
    #define FTM0_C0VH_VAL_H1_BITNUM   1
    #define FTM0_C0VH_VAL_H2_MASK     4U
    #define FTM0_C0VH_VAL_H2_BITNUM   2
    #define FTM0_C0VH_VAL_H3_MASK     8U
    #define FTM0_C0VH_VAL_H3_BITNUM   3
    #define FTM0_C0VH_VAL_H4_MASK     16U
    #define FTM0_C0VH_VAL_H4_BITNUM   4
    #define FTM0_C0VH_VAL_H5_MASK     32U
    #define FTM0_C0VH_VAL_H5_BITNUM   5
    #define FTM0_C0VH_VAL_H6_MASK     64U
    #define FTM0_C0VH_VAL_H6_BITNUM   6
    #define FTM0_C0VH_VAL_H7_MASK     128U
    #define FTM0_C0VH_VAL_H7_BITNUM   7
    
    /*** FTM0_C0VL Channel Value Low; 0x00000027 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_L0     : 1;
        byte  VAL_L1     : 1;
        byte  VAL_L2     : 1;
        byte  VAL_L3     : 1;
        byte  VAL_L4     : 1;
        byte  VAL_L5     : 1;
        byte  VAL_L6     : 1;
        byte  VAL_L7     : 1;
      } Bits;
    } FTM0_C0VLSTR;
    #define FTM0_C0VL                 _FTM0_C0V.Overlap_STR.FTM0_C0VLSTR.Byte
    #define FTM0_C0VL_VAL_L0          _FTM0_C0V.Overlap_STR.FTM0_C0VLSTR.Bits.VAL_L0
    #define FTM0_C0VL_VAL_L1          _FTM0_C0V.Overlap_STR.FTM0_C0VLSTR.Bits.VAL_L1
    #define FTM0_C0VL_VAL_L2          _FTM0_C0V.Overlap_STR.FTM0_C0VLSTR.Bits.VAL_L2
    #define FTM0_C0VL_VAL_L3          _FTM0_C0V.Overlap_STR.FTM0_C0VLSTR.Bits.VAL_L3
    #define FTM0_C0VL_VAL_L4          _FTM0_C0V.Overlap_STR.FTM0_C0VLSTR.Bits.VAL_L4
    #define FTM0_C0VL_VAL_L5          _FTM0_C0V.Overlap_STR.FTM0_C0VLSTR.Bits.VAL_L5
    #define FTM0_C0VL_VAL_L6          _FTM0_C0V.Overlap_STR.FTM0_C0VLSTR.Bits.VAL_L6
    #define FTM0_C0VL_VAL_L7          _FTM0_C0V.Overlap_STR.FTM0_C0VLSTR.Bits.VAL_L7
    
    #define FTM0_C0VL_VAL_L0_MASK     1U
    #define FTM0_C0VL_VAL_L0_BITNUM   0
    #define FTM0_C0VL_VAL_L1_MASK     2U
    #define FTM0_C0VL_VAL_L1_BITNUM   1
    #define FTM0_C0VL_VAL_L2_MASK     4U
    #define FTM0_C0VL_VAL_L2_BITNUM   2
    #define FTM0_C0VL_VAL_L3_MASK     8U
    #define FTM0_C0VL_VAL_L3_BITNUM   3
    #define FTM0_C0VL_VAL_L4_MASK     16U
    #define FTM0_C0VL_VAL_L4_BITNUM   4
    #define FTM0_C0VL_VAL_L5_MASK     32U
    #define FTM0_C0VL_VAL_L5_BITNUM   5
    #define FTM0_C0VL_VAL_L6_MASK     64U
    #define FTM0_C0VL_VAL_L6_BITNUM   6
    #define FTM0_C0VL_VAL_L7_MASK     128U
    #define FTM0_C0VL_VAL_L7_BITNUM   7
    
  } Overlap_STR;
} FTM0_C0VSTR;
extern volatile FTM0_C0VSTR _FTM0_C0V @0x00000026;
#define FTM0_C0V                  _FTM0_C0V.Word


/*** FTM0_C1SC Channel Status and Control; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  ELSA       : 1;
    byte  ELSB       : 1;
    byte  MSA        : 1;
    byte  MSB        : 1;
    byte  CHIE       : 1;
    byte  CHF        : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte  grpELSx    : 2;
    byte  grpMSx     : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM0_C1SCSTR;
extern volatile FTM0_C1SCSTR _FTM0_C1SC @0x00000028;
#define FTM0_C1SC                 _FTM0_C1SC.Byte
#define FTM0_C1SC_ELSA            _FTM0_C1SC.Bits.ELSA
#define FTM0_C1SC_ELSB            _FTM0_C1SC.Bits.ELSB
#define FTM0_C1SC_MSA             _FTM0_C1SC.Bits.MSA
#define FTM0_C1SC_MSB             _FTM0_C1SC.Bits.MSB
#define FTM0_C1SC_CHIE            _FTM0_C1SC.Bits.CHIE
#define FTM0_C1SC_CHF             _FTM0_C1SC.Bits.CHF
#define FTM0_C1SC_ELSx            _FTM0_C1SC.MergedBits.grpELSx
#define FTM0_C1SC_MSx             _FTM0_C1SC.MergedBits.grpMSx

#define FTM0_C1SC_ELSA_MASK       4U
#define FTM0_C1SC_ELSA_BITNUM     2
#define FTM0_C1SC_ELSB_MASK       8U
#define FTM0_C1SC_ELSB_BITNUM     3
#define FTM0_C1SC_MSA_MASK        16U
#define FTM0_C1SC_MSA_BITNUM      4
#define FTM0_C1SC_MSB_MASK        32U
#define FTM0_C1SC_MSB_BITNUM      5
#define FTM0_C1SC_CHIE_MASK       64U
#define FTM0_C1SC_CHIE_BITNUM     6
#define FTM0_C1SC_CHF_MASK        128U
#define FTM0_C1SC_CHF_BITNUM      7
#define FTM0_C1SC_ELSx_MASK       12U
#define FTM0_C1SC_ELSx_BITNUM     2
#define FTM0_C1SC_MSx_MASK        48U
#define FTM0_C1SC_MSx_BITNUM      4


/*** FTM0_C1V Channel Value  0x00000029 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM0_C1VH Channel Value High; 0x00000029 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_H0     : 1;
        byte  VAL_H1     : 1;
        byte  VAL_H2     : 1;
        byte  VAL_H3     : 1;
        byte  VAL_H4     : 1;
        byte  VAL_H5     : 1;
        byte  VAL_H6     : 1;
        byte  VAL_H7     : 1;
      } Bits;
    } FTM0_C1VHSTR;
    #define FTM0_C1VH                 _FTM0_C1V.Overlap_STR.FTM0_C1VHSTR.Byte
    #define FTM0_C1VH_VAL_H0          _FTM0_C1V.Overlap_STR.FTM0_C1VHSTR.Bits.VAL_H0
    #define FTM0_C1VH_VAL_H1          _FTM0_C1V.Overlap_STR.FTM0_C1VHSTR.Bits.VAL_H1
    #define FTM0_C1VH_VAL_H2          _FTM0_C1V.Overlap_STR.FTM0_C1VHSTR.Bits.VAL_H2
    #define FTM0_C1VH_VAL_H3          _FTM0_C1V.Overlap_STR.FTM0_C1VHSTR.Bits.VAL_H3
    #define FTM0_C1VH_VAL_H4          _FTM0_C1V.Overlap_STR.FTM0_C1VHSTR.Bits.VAL_H4
    #define FTM0_C1VH_VAL_H5          _FTM0_C1V.Overlap_STR.FTM0_C1VHSTR.Bits.VAL_H5
    #define FTM0_C1VH_VAL_H6          _FTM0_C1V.Overlap_STR.FTM0_C1VHSTR.Bits.VAL_H6
    #define FTM0_C1VH_VAL_H7          _FTM0_C1V.Overlap_STR.FTM0_C1VHSTR.Bits.VAL_H7
    
    #define FTM0_C1VH_VAL_H0_MASK     1U
    #define FTM0_C1VH_VAL_H0_BITNUM   0
    #define FTM0_C1VH_VAL_H1_MASK     2U
    #define FTM0_C1VH_VAL_H1_BITNUM   1
    #define FTM0_C1VH_VAL_H2_MASK     4U
    #define FTM0_C1VH_VAL_H2_BITNUM   2
    #define FTM0_C1VH_VAL_H3_MASK     8U
    #define FTM0_C1VH_VAL_H3_BITNUM   3
    #define FTM0_C1VH_VAL_H4_MASK     16U
    #define FTM0_C1VH_VAL_H4_BITNUM   4
    #define FTM0_C1VH_VAL_H5_MASK     32U
    #define FTM0_C1VH_VAL_H5_BITNUM   5
    #define FTM0_C1VH_VAL_H6_MASK     64U
    #define FTM0_C1VH_VAL_H6_BITNUM   6
    #define FTM0_C1VH_VAL_H7_MASK     128U
    #define FTM0_C1VH_VAL_H7_BITNUM   7
    
    /*** FTM0_C1VL Channel Value Low; 0x0000002A ***/
    union {
      byte Byte;
      struct {
        byte  VAL_L0     : 1;
        byte  VAL_L1     : 1;
        byte  VAL_L2     : 1;
        byte  VAL_L3     : 1;
        byte  VAL_L4     : 1;
        byte  VAL_L5     : 1;
        byte  VAL_L6     : 1;
        byte  VAL_L7     : 1;
      } Bits;
    } FTM0_C1VLSTR;
    #define FTM0_C1VL                 _FTM0_C1V.Overlap_STR.FTM0_C1VLSTR.Byte
    #define FTM0_C1VL_VAL_L0          _FTM0_C1V.Overlap_STR.FTM0_C1VLSTR.Bits.VAL_L0
    #define FTM0_C1VL_VAL_L1          _FTM0_C1V.Overlap_STR.FTM0_C1VLSTR.Bits.VAL_L1
    #define FTM0_C1VL_VAL_L2          _FTM0_C1V.Overlap_STR.FTM0_C1VLSTR.Bits.VAL_L2
    #define FTM0_C1VL_VAL_L3          _FTM0_C1V.Overlap_STR.FTM0_C1VLSTR.Bits.VAL_L3
    #define FTM0_C1VL_VAL_L4          _FTM0_C1V.Overlap_STR.FTM0_C1VLSTR.Bits.VAL_L4
    #define FTM0_C1VL_VAL_L5          _FTM0_C1V.Overlap_STR.FTM0_C1VLSTR.Bits.VAL_L5
    #define FTM0_C1VL_VAL_L6          _FTM0_C1V.Overlap_STR.FTM0_C1VLSTR.Bits.VAL_L6
    #define FTM0_C1VL_VAL_L7          _FTM0_C1V.Overlap_STR.FTM0_C1VLSTR.Bits.VAL_L7
    
    #define FTM0_C1VL_VAL_L0_MASK     1U
    #define FTM0_C1VL_VAL_L0_BITNUM   0
    #define FTM0_C1VL_VAL_L1_MASK     2U
    #define FTM0_C1VL_VAL_L1_BITNUM   1
    #define FTM0_C1VL_VAL_L2_MASK     4U
    #define FTM0_C1VL_VAL_L2_BITNUM   2
    #define FTM0_C1VL_VAL_L3_MASK     8U
    #define FTM0_C1VL_VAL_L3_BITNUM   3
    #define FTM0_C1VL_VAL_L4_MASK     16U
    #define FTM0_C1VL_VAL_L4_BITNUM   4
    #define FTM0_C1VL_VAL_L5_MASK     32U
    #define FTM0_C1VL_VAL_L5_BITNUM   5
    #define FTM0_C1VL_VAL_L6_MASK     64U
    #define FTM0_C1VL_VAL_L6_BITNUM   6
    #define FTM0_C1VL_VAL_L7_MASK     128U
    #define FTM0_C1VL_VAL_L7_BITNUM   7
    
  } Overlap_STR;
} FTM0_C1VSTR;
extern volatile FTM0_C1VSTR _FTM0_C1V @0x00000029;
#define FTM0_C1V                  _FTM0_C1V.Word


/*** ACMP0_CS ACMP Control and Status Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte  ACMOD0     : 1;
    byte  ACMOD1     : 1;
    byte  ACOPE      : 1;
    byte  ACO        : 1;
    byte  ACIE       : 1;
    byte  ACF        : 1;
    byte  HYST       : 1;
    byte  ACE        : 1;
  } Bits;
  struct {
    byte  grpACMOD   : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ACMP0_CSSTR;
extern volatile ACMP0_CSSTR _ACMP0_CS @0x0000002C;
#define ACMP0_CS                  _ACMP0_CS.Byte
#define ACMP0_CS_ACMOD0           _ACMP0_CS.Bits.ACMOD0
#define ACMP0_CS_ACMOD1           _ACMP0_CS.Bits.ACMOD1
#define ACMP0_CS_ACOPE            _ACMP0_CS.Bits.ACOPE
#define ACMP0_CS_ACO              _ACMP0_CS.Bits.ACO
#define ACMP0_CS_ACIE             _ACMP0_CS.Bits.ACIE
#define ACMP0_CS_ACF              _ACMP0_CS.Bits.ACF
#define ACMP0_CS_HYST             _ACMP0_CS.Bits.HYST
#define ACMP0_CS_ACE              _ACMP0_CS.Bits.ACE
#define ACMP0_CS_ACMOD            _ACMP0_CS.MergedBits.grpACMOD

#define ACMP0_CS_ACMOD0_MASK      1U
#define ACMP0_CS_ACMOD0_BITNUM    0
#define ACMP0_CS_ACMOD1_MASK      2U
#define ACMP0_CS_ACMOD1_BITNUM    1
#define ACMP0_CS_ACOPE_MASK       4U
#define ACMP0_CS_ACOPE_BITNUM     2
#define ACMP0_CS_ACO_MASK         8U
#define ACMP0_CS_ACO_BITNUM       3
#define ACMP0_CS_ACIE_MASK        16U
#define ACMP0_CS_ACIE_BITNUM      4
#define ACMP0_CS_ACF_MASK         32U
#define ACMP0_CS_ACF_BITNUM       5
#define ACMP0_CS_HYST_MASK        64U
#define ACMP0_CS_HYST_BITNUM      6
#define ACMP0_CS_ACE_MASK         128U
#define ACMP0_CS_ACE_BITNUM       7
#define ACMP0_CS_ACMOD_MASK       3U
#define ACMP0_CS_ACMOD_BITNUM     0


/*** ACMP0_C0 ACMP Control Register 0; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte  ACNSEL0    : 1;
    byte  ACNSEL1    : 1;
    byte             : 1;
    byte             : 1;
    byte  ACPSEL0    : 1;
    byte  ACPSEL1    : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpACNSEL  : 2;
    byte             : 1;
    byte             : 1;
    byte  grpACPSEL  : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ACMP0_C0STR;
extern volatile ACMP0_C0STR _ACMP0_C0 @0x0000002D;
#define ACMP0_C0                  _ACMP0_C0.Byte
#define ACMP0_C0_ACNSEL0          _ACMP0_C0.Bits.ACNSEL0
#define ACMP0_C0_ACNSEL1          _ACMP0_C0.Bits.ACNSEL1
#define ACMP0_C0_ACPSEL0          _ACMP0_C0.Bits.ACPSEL0
#define ACMP0_C0_ACPSEL1          _ACMP0_C0.Bits.ACPSEL1
#define ACMP0_C0_ACNSEL           _ACMP0_C0.MergedBits.grpACNSEL
#define ACMP0_C0_ACPSEL           _ACMP0_C0.MergedBits.grpACPSEL

#define ACMP0_C0_ACNSEL0_MASK     1U
#define ACMP0_C0_ACNSEL0_BITNUM   0
#define ACMP0_C0_ACNSEL1_MASK     2U
#define ACMP0_C0_ACNSEL1_BITNUM   1
#define ACMP0_C0_ACPSEL0_MASK     16U
#define ACMP0_C0_ACPSEL0_BITNUM   4
#define ACMP0_C0_ACPSEL1_MASK     32U
#define ACMP0_C0_ACPSEL1_BITNUM   5
#define ACMP0_C0_ACNSEL_MASK      3U
#define ACMP0_C0_ACNSEL_BITNUM    0
#define ACMP0_C0_ACPSEL_MASK      48U
#define ACMP0_C0_ACPSEL_BITNUM    4


/*** ACMP0_C1 ACMP Control Register 1; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte  DACVAL0    : 1;
    byte  DACVAL1    : 1;
    byte  DACVAL2    : 1;
    byte  DACVAL3    : 1;
    byte  DACVAL4    : 1;
    byte  DACVAL5    : 1;
    byte  DACREF     : 1;
    byte  DACEN      : 1;
  } Bits;
  struct {
    byte  grpDACVAL  : 6;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ACMP0_C1STR;
extern volatile ACMP0_C1STR _ACMP0_C1 @0x0000002E;
#define ACMP0_C1                  _ACMP0_C1.Byte
#define ACMP0_C1_DACVAL0          _ACMP0_C1.Bits.DACVAL0
#define ACMP0_C1_DACVAL1          _ACMP0_C1.Bits.DACVAL1
#define ACMP0_C1_DACVAL2          _ACMP0_C1.Bits.DACVAL2
#define ACMP0_C1_DACVAL3          _ACMP0_C1.Bits.DACVAL3
#define ACMP0_C1_DACVAL4          _ACMP0_C1.Bits.DACVAL4
#define ACMP0_C1_DACVAL5          _ACMP0_C1.Bits.DACVAL5
#define ACMP0_C1_DACREF           _ACMP0_C1.Bits.DACREF
#define ACMP0_C1_DACEN            _ACMP0_C1.Bits.DACEN
#define ACMP0_C1_DACVAL           _ACMP0_C1.MergedBits.grpDACVAL

#define ACMP0_C1_DACVAL0_MASK     1U
#define ACMP0_C1_DACVAL0_BITNUM   0
#define ACMP0_C1_DACVAL1_MASK     2U
#define ACMP0_C1_DACVAL1_BITNUM   1
#define ACMP0_C1_DACVAL2_MASK     4U
#define ACMP0_C1_DACVAL2_BITNUM   2
#define ACMP0_C1_DACVAL3_MASK     8U
#define ACMP0_C1_DACVAL3_BITNUM   3
#define ACMP0_C1_DACVAL4_MASK     16U
#define ACMP0_C1_DACVAL4_BITNUM   4
#define ACMP0_C1_DACVAL5_MASK     32U
#define ACMP0_C1_DACVAL5_BITNUM   5
#define ACMP0_C1_DACREF_MASK      64U
#define ACMP0_C1_DACREF_BITNUM    6
#define ACMP0_C1_DACEN_MASK       128U
#define ACMP0_C1_DACEN_BITNUM     7
#define ACMP0_C1_DACVAL_MASK      63U
#define ACMP0_C1_DACVAL_BITNUM    0


/*** ACMP0_C2 ACMP Control Register 2; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte  ACIPE0     : 1;
    byte  ACIPE1     : 1;
    byte  ACIPE2     : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpACIPE   : 3;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ACMP0_C2STR;
extern volatile ACMP0_C2STR _ACMP0_C2 @0x0000002F;
#define ACMP0_C2                  _ACMP0_C2.Byte
#define ACMP0_C2_ACIPE0           _ACMP0_C2.Bits.ACIPE0
#define ACMP0_C2_ACIPE1           _ACMP0_C2.Bits.ACIPE1
#define ACMP0_C2_ACIPE2           _ACMP0_C2.Bits.ACIPE2
#define ACMP0_C2_ACIPE            _ACMP0_C2.MergedBits.grpACIPE

#define ACMP0_C2_ACIPE0_MASK      1U
#define ACMP0_C2_ACIPE0_BITNUM    0
#define ACMP0_C2_ACIPE1_MASK      2U
#define ACMP0_C2_ACIPE1_BITNUM    1
#define ACMP0_C2_ACIPE2_MASK      4U
#define ACMP0_C2_ACIPE2_BITNUM    2
#define ACMP0_C2_ACIPE_MASK       7U
#define ACMP0_C2_ACIPE_BITNUM     0


/*** IRQ_SC Interrupt Pin Request Status and Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte  IRQMOD     : 1;
    byte  IRQIE      : 1;
    byte  IRQACK     : 1;
    byte  IRQF       : 1;
    byte  IRQPE      : 1;
    byte  IRQEDG     : 1;
    byte  IRQPDD     : 1;
    byte             : 1;
  } Bits;
} IRQ_SCSTR;
extern volatile IRQ_SCSTR _IRQ_SC @0x0000003B;
#define IRQ_SC                    _IRQ_SC.Byte
#define IRQ_SC_IRQMOD             _IRQ_SC.Bits.IRQMOD
#define IRQ_SC_IRQIE              _IRQ_SC.Bits.IRQIE
#define IRQ_SC_IRQACK             _IRQ_SC.Bits.IRQACK
#define IRQ_SC_IRQF               _IRQ_SC.Bits.IRQF
#define IRQ_SC_IRQPE              _IRQ_SC.Bits.IRQPE
#define IRQ_SC_IRQEDG             _IRQ_SC.Bits.IRQEDG
#define IRQ_SC_IRQPDD             _IRQ_SC.Bits.IRQPDD

#define IRQ_SC_IRQMOD_MASK        1U
#define IRQ_SC_IRQMOD_BITNUM      0
#define IRQ_SC_IRQIE_MASK         2U
#define IRQ_SC_IRQIE_BITNUM       1
#define IRQ_SC_IRQACK_MASK        4U
#define IRQ_SC_IRQACK_BITNUM      2
#define IRQ_SC_IRQF_MASK          8U
#define IRQ_SC_IRQF_BITNUM        3
#define IRQ_SC_IRQPE_MASK         16U
#define IRQ_SC_IRQPE_BITNUM       4
#define IRQ_SC_IRQEDG_MASK        32U
#define IRQ_SC_IRQEDG_BITNUM      5
#define IRQ_SC_IRQPDD_MASK        64U
#define IRQ_SC_IRQPDD_BITNUM      6


/*** KBI0_SC KBI Status and Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte  KBMOD      : 1;
    byte  KBIE       : 1;
    byte  KBACK      : 1;
    byte  KBF        : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
} KBI0_SCSTR;
extern volatile KBI0_SCSTR _KBI0_SC @0x0000003C;
#define KBI0_SC                   _KBI0_SC.Byte
#define KBI0_SC_KBMOD             _KBI0_SC.Bits.KBMOD
#define KBI0_SC_KBIE              _KBI0_SC.Bits.KBIE
#define KBI0_SC_KBACK             _KBI0_SC.Bits.KBACK
#define KBI0_SC_KBF               _KBI0_SC.Bits.KBF

#define KBI0_SC_KBMOD_MASK        1U
#define KBI0_SC_KBMOD_BITNUM      0
#define KBI0_SC_KBIE_MASK         2U
#define KBI0_SC_KBIE_BITNUM       1
#define KBI0_SC_KBACK_MASK        4U
#define KBI0_SC_KBACK_BITNUM      2
#define KBI0_SC_KBF_MASK          8U
#define KBI0_SC_KBF_BITNUM        3


/*** IPC_SC IPC Status and Control Register; 0x0000003E ***/
typedef union {
  byte Byte;
  struct {
    byte  IPM0       : 1;
    byte  IPM1       : 1;
    byte             : 1;
    byte  PULIPM     : 1;
    byte  PSF        : 1;
    byte  PSE        : 1;
    byte             : 1;
    byte  IPCE       : 1;
  } Bits;
  struct {
    byte  grpIPM     : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} IPC_SCSTR;
extern volatile IPC_SCSTR _IPC_SC @0x0000003E;
#define IPC_SC                    _IPC_SC.Byte
#define IPC_SC_IPM0               _IPC_SC.Bits.IPM0
#define IPC_SC_IPM1               _IPC_SC.Bits.IPM1
#define IPC_SC_PULIPM             _IPC_SC.Bits.PULIPM
#define IPC_SC_PSF                _IPC_SC.Bits.PSF
#define IPC_SC_PSE                _IPC_SC.Bits.PSE
#define IPC_SC_IPCE               _IPC_SC.Bits.IPCE
#define IPC_SC_IPM                _IPC_SC.MergedBits.grpIPM

#define IPC_SC_IPM0_MASK          1U
#define IPC_SC_IPM0_BITNUM        0
#define IPC_SC_IPM1_MASK          2U
#define IPC_SC_IPM1_BITNUM        1
#define IPC_SC_PULIPM_MASK        8U
#define IPC_SC_PULIPM_BITNUM      3
#define IPC_SC_PSF_MASK           16U
#define IPC_SC_PSF_BITNUM         4
#define IPC_SC_PSE_MASK           32U
#define IPC_SC_PSE_BITNUM         5
#define IPC_SC_IPCE_MASK          128U
#define IPC_SC_IPCE_BITNUM        7
#define IPC_SC_IPM_MASK           3U
#define IPC_SC_IPM_BITNUM         0


/*** IPC_IPMPS Interrupt Priority Mask Pseudo Stack Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte  IPM00      : 1;
    byte  IPM01      : 1;
    byte  IPM10      : 1;
    byte  IPM11      : 1;
    byte  IPM20      : 1;
    byte  IPM21      : 1;
    byte  IPM30      : 1;
    byte  IPM31      : 1;
  } Bits;
  struct {
    byte  grpIPM0    : 2;
    byte  grpIPM1    : 2;
    byte  grpIPM2    : 2;
    byte  grpIPM3    : 2;
  } MergedBits;
} IPC_IPMPSSTR;
extern volatile IPC_IPMPSSTR _IPC_IPMPS @0x0000003F;
#define IPC_IPMPS                 _IPC_IPMPS.Byte
#define IPC_IPMPS_IPM00           _IPC_IPMPS.Bits.IPM00
#define IPC_IPMPS_IPM01           _IPC_IPMPS.Bits.IPM01
#define IPC_IPMPS_IPM10           _IPC_IPMPS.Bits.IPM10
#define IPC_IPMPS_IPM11           _IPC_IPMPS.Bits.IPM11
#define IPC_IPMPS_IPM20           _IPC_IPMPS.Bits.IPM20
#define IPC_IPMPS_IPM21           _IPC_IPMPS.Bits.IPM21
#define IPC_IPMPS_IPM30           _IPC_IPMPS.Bits.IPM30
#define IPC_IPMPS_IPM31           _IPC_IPMPS.Bits.IPM31
#define IPC_IPMPS_IPM0            _IPC_IPMPS.MergedBits.grpIPM0
#define IPC_IPMPS_IPM1            _IPC_IPMPS.MergedBits.grpIPM1
#define IPC_IPMPS_IPM2            _IPC_IPMPS.MergedBits.grpIPM2
#define IPC_IPMPS_IPM3            _IPC_IPMPS.MergedBits.grpIPM3

#define IPC_IPMPS_IPM00_MASK      1U
#define IPC_IPMPS_IPM00_BITNUM    0
#define IPC_IPMPS_IPM01_MASK      2U
#define IPC_IPMPS_IPM01_BITNUM    1
#define IPC_IPMPS_IPM10_MASK      4U
#define IPC_IPMPS_IPM10_BITNUM    2
#define IPC_IPMPS_IPM11_MASK      8U
#define IPC_IPMPS_IPM11_BITNUM    3
#define IPC_IPMPS_IPM20_MASK      16U
#define IPC_IPMPS_IPM20_BITNUM    4
#define IPC_IPMPS_IPM21_MASK      32U
#define IPC_IPMPS_IPM21_BITNUM    5
#define IPC_IPMPS_IPM30_MASK      64U
#define IPC_IPMPS_IPM30_BITNUM    6
#define IPC_IPMPS_IPM31_MASK      128U
#define IPC_IPMPS_IPM31_BITNUM    7
#define IPC_IPMPS_IPM0_MASK       3U
#define IPC_IPMPS_IPM0_BITNUM     0
#define IPC_IPMPS_IPM1_MASK       12U
#define IPC_IPMPS_IPM1_BITNUM     2
#define IPC_IPMPS_IPM2_MASK       48U
#define IPC_IPMPS_IPM2_BITNUM     4
#define IPC_IPMPS_IPM3_MASK       192U
#define IPC_IPMPS_IPM3_BITNUM     6


/*** SYS_SRS System Reset Status Register; 0x00003000 ***/
typedef union {
  byte Byte;
  struct {
    byte  FILA       : 1;
    byte  LVD        : 1;
    byte  LOC        : 1;
    byte  ILAD       : 1;
    byte  ILOP       : 1;
    byte  WCOP       : 1;
    byte  PIN        : 1;
    byte  POR        : 1;
  } Bits;
} SYS_SRSSTR;
extern volatile SYS_SRSSTR _SYS_SRS @0x00003000;
#define SYS_SRS                   _SYS_SRS.Byte
#define SYS_SRS_FILA              _SYS_SRS.Bits.FILA
#define SYS_SRS_LVD               _SYS_SRS.Bits.LVD
#define SYS_SRS_LOC               _SYS_SRS.Bits.LOC
#define SYS_SRS_ILAD              _SYS_SRS.Bits.ILAD
#define SYS_SRS_ILOP              _SYS_SRS.Bits.ILOP
#define SYS_SRS_WCOP              _SYS_SRS.Bits.WCOP
#define SYS_SRS_PIN               _SYS_SRS.Bits.PIN
#define SYS_SRS_POR               _SYS_SRS.Bits.POR

#define SYS_SRS_FILA_MASK         1U
#define SYS_SRS_FILA_BITNUM       0
#define SYS_SRS_LVD_MASK          2U
#define SYS_SRS_LVD_BITNUM        1
#define SYS_SRS_LOC_MASK          4U
#define SYS_SRS_LOC_BITNUM        2
#define SYS_SRS_ILAD_MASK         8U
#define SYS_SRS_ILAD_BITNUM       3
#define SYS_SRS_ILOP_MASK         16U
#define SYS_SRS_ILOP_BITNUM       4
#define SYS_SRS_WCOP_MASK         32U
#define SYS_SRS_WCOP_BITNUM       5
#define SYS_SRS_PIN_MASK          64U
#define SYS_SRS_PIN_BITNUM        6
#define SYS_SRS_POR_MASK          128U
#define SYS_SRS_POR_BITNUM        7


/*** SYS_SBDFR System Background Debug Force Reset Register; 0x00003001 ***/
typedef union {
  byte Byte;
  struct {
    byte  BDFR       : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
} SYS_SBDFRSTR;
extern volatile SYS_SBDFRSTR _SYS_SBDFR @0x00003001;
#define SYS_SBDFR                 _SYS_SBDFR.Byte
#define SYS_SBDFR_BDFR            _SYS_SBDFR.Bits.BDFR

#define SYS_SBDFR_BDFR_MASK       1U
#define SYS_SBDFR_BDFR_BITNUM     0


/*** SYS_SDID System Device Identification Register:  0x00003002 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** SYS_SDIDH System Device Identification Register: High; 0x00003002 ***/
    union {
      byte Byte;
      struct {
        byte  ID0        : 1;
        byte  ID1        : 1;
        byte  ID2        : 1;
        byte  ID3        : 1;
        byte             : 1;
        byte             : 1;
        byte             : 1;
        byte             : 1;
      } Bits;
      struct {
        byte  grpID      : 4;
        byte             : 1;
        byte             : 1;
        byte             : 1;
        byte             : 1;
      } MergedBits;
    } SYS_SDIDHSTR;
    #define SYS_SDIDH                 _SYS_SDID.Overlap_STR.SYS_SDIDHSTR.Byte
    #define SYS_SDIDH_ID0             _SYS_SDID.Overlap_STR.SYS_SDIDHSTR.Bits.ID0
    #define SYS_SDIDH_ID1             _SYS_SDID.Overlap_STR.SYS_SDIDHSTR.Bits.ID1
    #define SYS_SDIDH_ID2             _SYS_SDID.Overlap_STR.SYS_SDIDHSTR.Bits.ID2
    #define SYS_SDIDH_ID3             _SYS_SDID.Overlap_STR.SYS_SDIDHSTR.Bits.ID3
    #define SYS_SDIDH_ID              _SYS_SDID.Overlap_STR.SYS_SDIDHSTR.MergedBits.grpID
    
    #define SYS_SDIDH_ID0_MASK        1U
    #define SYS_SDIDH_ID0_BITNUM      0
    #define SYS_SDIDH_ID1_MASK        2U
    #define SYS_SDIDH_ID1_BITNUM      1
    #define SYS_SDIDH_ID2_MASK        4U
    #define SYS_SDIDH_ID2_BITNUM      2
    #define SYS_SDIDH_ID3_MASK        8U
    #define SYS_SDIDH_ID3_BITNUM      3
    #define SYS_SDIDH_ID_MASK         15U
    #define SYS_SDIDH_ID_BITNUM       0
    
    /*** SYS_SDIDL System Device Identification Register: Low; 0x00003003 ***/
    union {
      byte Byte;
      struct {
        byte  ID0        : 1;
        byte  ID1        : 1;
        byte  ID2        : 1;
        byte  ID3        : 1;
        byte  ID4        : 1;
        byte  ID5        : 1;
        byte  ID6        : 1;
        byte  ID7        : 1;
      } Bits;
    } SYS_SDIDLSTR;
    #define SYS_SDIDL                 _SYS_SDID.Overlap_STR.SYS_SDIDLSTR.Byte
    #define SYS_SDIDL_ID0             _SYS_SDID.Overlap_STR.SYS_SDIDLSTR.Bits.ID0
    #define SYS_SDIDL_ID1             _SYS_SDID.Overlap_STR.SYS_SDIDLSTR.Bits.ID1
    #define SYS_SDIDL_ID2             _SYS_SDID.Overlap_STR.SYS_SDIDLSTR.Bits.ID2
    #define SYS_SDIDL_ID3             _SYS_SDID.Overlap_STR.SYS_SDIDLSTR.Bits.ID3
    #define SYS_SDIDL_ID4             _SYS_SDID.Overlap_STR.SYS_SDIDLSTR.Bits.ID4
    #define SYS_SDIDL_ID5             _SYS_SDID.Overlap_STR.SYS_SDIDLSTR.Bits.ID5
    #define SYS_SDIDL_ID6             _SYS_SDID.Overlap_STR.SYS_SDIDLSTR.Bits.ID6
    #define SYS_SDIDL_ID7             _SYS_SDID.Overlap_STR.SYS_SDIDLSTR.Bits.ID7
    
    #define SYS_SDIDL_ID0_MASK        1U
    #define SYS_SDIDL_ID0_BITNUM      0
    #define SYS_SDIDL_ID1_MASK        2U
    #define SYS_SDIDL_ID1_BITNUM      1
    #define SYS_SDIDL_ID2_MASK        4U
    #define SYS_SDIDL_ID2_BITNUM      2
    #define SYS_SDIDL_ID3_MASK        8U
    #define SYS_SDIDL_ID3_BITNUM      3
    #define SYS_SDIDL_ID4_MASK        16U
    #define SYS_SDIDL_ID4_BITNUM      4
    #define SYS_SDIDL_ID5_MASK        32U
    #define SYS_SDIDL_ID5_BITNUM      5
    #define SYS_SDIDL_ID6_MASK        64U
    #define SYS_SDIDL_ID6_BITNUM      6
    #define SYS_SDIDL_ID7_MASK        128U
    #define SYS_SDIDL_ID7_BITNUM      7
    
  } Overlap_STR;
} SYS_SDIDSTR;
extern volatile SYS_SDIDSTR _SYS_SDID @0x00003002;
#define SYS_SDID                  _SYS_SDID.Word


/*** SYS_SOPT1 System Options Register 1; 0x00003004 ***/
typedef union {
  byte Byte;
  struct {
    byte  STOPE      : 1;
    byte  FWAKE      : 1;
    byte  RSTPE      : 1;
    byte  BKGDPE     : 1;
    byte             : 1;
    byte  IICPS0     : 1;
    byte  IICPS1     : 1;
    byte  SCI0PS     : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  grpIICPS   : 2;
    byte             : 1;
  } MergedBits;
} SYS_SOPT1STR;
extern volatile SYS_SOPT1STR _SYS_SOPT1 @0x00003004;
#define SYS_SOPT1                 _SYS_SOPT1.Byte
#define SYS_SOPT1_STOPE           _SYS_SOPT1.Bits.STOPE
#define SYS_SOPT1_FWAKE           _SYS_SOPT1.Bits.FWAKE
#define SYS_SOPT1_RSTPE           _SYS_SOPT1.Bits.RSTPE
#define SYS_SOPT1_BKGDPE          _SYS_SOPT1.Bits.BKGDPE
#define SYS_SOPT1_IICPS0          _SYS_SOPT1.Bits.IICPS0
#define SYS_SOPT1_IICPS1          _SYS_SOPT1.Bits.IICPS1
#define SYS_SOPT1_SCI0PS          _SYS_SOPT1.Bits.SCI0PS
#define SYS_SOPT1_IICPS           _SYS_SOPT1.MergedBits.grpIICPS

#define SYS_SOPT1_STOPE_MASK      1U
#define SYS_SOPT1_STOPE_BITNUM    0
#define SYS_SOPT1_FWAKE_MASK      2U
#define SYS_SOPT1_FWAKE_BITNUM    1
#define SYS_SOPT1_RSTPE_MASK      4U
#define SYS_SOPT1_RSTPE_BITNUM    2
#define SYS_SOPT1_BKGDPE_MASK     8U
#define SYS_SOPT1_BKGDPE_BITNUM   3
#define SYS_SOPT1_IICPS0_MASK     32U
#define SYS_SOPT1_IICPS0_BITNUM   5
#define SYS_SOPT1_IICPS1_MASK     64U
#define SYS_SOPT1_IICPS1_BITNUM   6
#define SYS_SOPT1_SCI0PS_MASK     128U
#define SYS_SOPT1_SCI0PS_BITNUM   7
#define SYS_SOPT1_IICPS_MASK      96U
#define SYS_SOPT1_IICPS_BITNUM    5


/*** SYS_SOPT2 System Options Register 2; 0x00003005 ***/
typedef union {
  byte Byte;
  struct {
    byte  ADHWTS0    : 1;
    byte  ADHWTS1    : 1;
    byte  RTCC       : 1;
    byte  ACIC       : 1;
    byte  RXDCE      : 1;
    byte  RXDFE      : 1;
    byte  FTMES      : 1;
    byte  TXDME      : 1;
  } Bits;
  struct {
    byte  grpADHWTS  : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} SYS_SOPT2STR;
extern volatile SYS_SOPT2STR _SYS_SOPT2 @0x00003005;
#define SYS_SOPT2                 _SYS_SOPT2.Byte
#define SYS_SOPT2_ADHWTS0         _SYS_SOPT2.Bits.ADHWTS0
#define SYS_SOPT2_ADHWTS1         _SYS_SOPT2.Bits.ADHWTS1
#define SYS_SOPT2_RTCC            _SYS_SOPT2.Bits.RTCC
#define SYS_SOPT2_ACIC            _SYS_SOPT2.Bits.ACIC
#define SYS_SOPT2_RXDCE           _SYS_SOPT2.Bits.RXDCE
#define SYS_SOPT2_RXDFE           _SYS_SOPT2.Bits.RXDFE
#define SYS_SOPT2_FTMES           _SYS_SOPT2.Bits.FTMES
#define SYS_SOPT2_TXDME           _SYS_SOPT2.Bits.TXDME
#define SYS_SOPT2_ADHWTS          _SYS_SOPT2.MergedBits.grpADHWTS

#define SYS_SOPT2_ADHWTS0_MASK    1U
#define SYS_SOPT2_ADHWTS0_BITNUM  0
#define SYS_SOPT2_ADHWTS1_MASK    2U
#define SYS_SOPT2_ADHWTS1_BITNUM  1
#define SYS_SOPT2_RTCC_MASK       4U
#define SYS_SOPT2_RTCC_BITNUM     2
#define SYS_SOPT2_ACIC_MASK       8U
#define SYS_SOPT2_ACIC_BITNUM     3
#define SYS_SOPT2_RXDCE_MASK      16U
#define SYS_SOPT2_RXDCE_BITNUM    4
#define SYS_SOPT2_RXDFE_MASK      32U
#define SYS_SOPT2_RXDFE_BITNUM    5
#define SYS_SOPT2_FTMES_MASK      64U
#define SYS_SOPT2_FTMES_BITNUM    6
#define SYS_SOPT2_TXDME_MASK      128U
#define SYS_SOPT2_TXDME_BITNUM    7
#define SYS_SOPT2_ADHWTS_MASK     3U
#define SYS_SOPT2_ADHWTS_BITNUM   0


/*** SYS_SOPT3 System Options Register 3; 0x00003006 ***/
typedef union {
  byte Byte;
  struct {
    byte  BUSREF0    : 1;
    byte  BUSREF1    : 1;
    byte  BUSREF2    : 1;
    byte             : 1;
    byte  FTMCHS0    : 1;
    byte  FTMCHS1    : 1;
    byte  FTM0PS     : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpBUSREF  : 3;
    byte             : 1;
    byte  grpFTMCHS  : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} SYS_SOPT3STR;
extern volatile SYS_SOPT3STR _SYS_SOPT3 @0x00003006;
#define SYS_SOPT3                 _SYS_SOPT3.Byte
#define SYS_SOPT3_BUSREF0         _SYS_SOPT3.Bits.BUSREF0
#define SYS_SOPT3_BUSREF1         _SYS_SOPT3.Bits.BUSREF1
#define SYS_SOPT3_BUSREF2         _SYS_SOPT3.Bits.BUSREF2
#define SYS_SOPT3_FTMCHS0         _SYS_SOPT3.Bits.FTMCHS0
#define SYS_SOPT3_FTMCHS1         _SYS_SOPT3.Bits.FTMCHS1
#define SYS_SOPT3_FTM0PS          _SYS_SOPT3.Bits.FTM0PS
#define SYS_SOPT3_BUSREF          _SYS_SOPT3.MergedBits.grpBUSREF
#define SYS_SOPT3_FTMCHS          _SYS_SOPT3.MergedBits.grpFTMCHS

#define SYS_SOPT3_BUSREF0_MASK    1U
#define SYS_SOPT3_BUSREF0_BITNUM  0
#define SYS_SOPT3_BUSREF1_MASK    2U
#define SYS_SOPT3_BUSREF1_BITNUM  1
#define SYS_SOPT3_BUSREF2_MASK    4U
#define SYS_SOPT3_BUSREF2_BITNUM  2
#define SYS_SOPT3_FTMCHS0_MASK    16U
#define SYS_SOPT3_FTMCHS0_BITNUM  4
#define SYS_SOPT3_FTMCHS1_MASK    32U
#define SYS_SOPT3_FTMCHS1_BITNUM  5
#define SYS_SOPT3_FTM0PS_MASK     64U
#define SYS_SOPT3_FTM0PS_BITNUM   6
#define SYS_SOPT3_BUSREF_MASK     7U
#define SYS_SOPT3_BUSREF_BITNUM   0
#define SYS_SOPT3_FTMCHS_MASK     48U
#define SYS_SOPT3_FTMCHS_BITNUM   4


/*** SYS_SOPT4 System Options Register 4; 0x00003007 ***/
typedef union {
  byte Byte;
  struct {
    byte  DELAY0     : 1;
    byte  DELAY1     : 1;
    byte  DELAY2     : 1;
    byte  DELAY3     : 1;
    byte  DELAY4     : 1;
    byte  DELAY5     : 1;
    byte  DELAY6     : 1;
    byte  DELAY7     : 1;
  } Bits;
} SYS_SOPT4STR;
extern volatile SYS_SOPT4STR _SYS_SOPT4 @0x00003007;
#define SYS_SOPT4                 _SYS_SOPT4.Byte
#define SYS_SOPT4_DELAY0          _SYS_SOPT4.Bits.DELAY0
#define SYS_SOPT4_DELAY1          _SYS_SOPT4.Bits.DELAY1
#define SYS_SOPT4_DELAY2          _SYS_SOPT4.Bits.DELAY2
#define SYS_SOPT4_DELAY3          _SYS_SOPT4.Bits.DELAY3
#define SYS_SOPT4_DELAY4          _SYS_SOPT4.Bits.DELAY4
#define SYS_SOPT4_DELAY5          _SYS_SOPT4.Bits.DELAY5
#define SYS_SOPT4_DELAY6          _SYS_SOPT4.Bits.DELAY6
#define SYS_SOPT4_DELAY7          _SYS_SOPT4.Bits.DELAY7

#define SYS_SOPT4_DELAY0_MASK     1U
#define SYS_SOPT4_DELAY0_BITNUM   0
#define SYS_SOPT4_DELAY1_MASK     2U
#define SYS_SOPT4_DELAY1_BITNUM   1
#define SYS_SOPT4_DELAY2_MASK     4U
#define SYS_SOPT4_DELAY2_BITNUM   2
#define SYS_SOPT4_DELAY3_MASK     8U
#define SYS_SOPT4_DELAY3_BITNUM   3
#define SYS_SOPT4_DELAY4_MASK     16U
#define SYS_SOPT4_DELAY4_BITNUM   4
#define SYS_SOPT4_DELAY5_MASK     32U
#define SYS_SOPT4_DELAY5_BITNUM   5
#define SYS_SOPT4_DELAY6_MASK     64U
#define SYS_SOPT4_DELAY6_BITNUM   6
#define SYS_SOPT4_DELAY7_MASK     128U
#define SYS_SOPT4_DELAY7_BITNUM   7


/*** SYS_SOPT5 System Options Register 5; 0x00003008 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  COPW       : 1;
    byte  COPCLKS0   : 1;
    byte  COPCLKS1   : 1;
    byte  COPT0      : 1;
    byte  COPT1      : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  grpCOPCLKS : 2;
    byte  grpCOPT    : 2;
  } MergedBits;
} SYS_SOPT5STR;
extern volatile SYS_SOPT5STR _SYS_SOPT5 @0x00003008;
#define SYS_SOPT5                 _SYS_SOPT5.Byte
#define SYS_SOPT5_COPW            _SYS_SOPT5.Bits.COPW
#define SYS_SOPT5_COPCLKS0        _SYS_SOPT5.Bits.COPCLKS0
#define SYS_SOPT5_COPCLKS1        _SYS_SOPT5.Bits.COPCLKS1
#define SYS_SOPT5_COPT0           _SYS_SOPT5.Bits.COPT0
#define SYS_SOPT5_COPT1           _SYS_SOPT5.Bits.COPT1
#define SYS_SOPT5_COPCLKS         _SYS_SOPT5.MergedBits.grpCOPCLKS
#define SYS_SOPT5_COPT            _SYS_SOPT5.MergedBits.grpCOPT

#define SYS_SOPT5_COPW_MASK       8U
#define SYS_SOPT5_COPW_BITNUM     3
#define SYS_SOPT5_COPCLKS0_MASK   16U
#define SYS_SOPT5_COPCLKS0_BITNUM 4
#define SYS_SOPT5_COPCLKS1_MASK   32U
#define SYS_SOPT5_COPCLKS1_BITNUM 5
#define SYS_SOPT5_COPT0_MASK      64U
#define SYS_SOPT5_COPT0_BITNUM    6
#define SYS_SOPT5_COPT1_MASK      128U
#define SYS_SOPT5_COPT1_BITNUM    7
#define SYS_SOPT5_COPCLKS_MASK    48U
#define SYS_SOPT5_COPCLKS_BITNUM  4
#define SYS_SOPT5_COPT_MASK       192U
#define SYS_SOPT5_COPT_BITNUM     6


/*** SYS_SOPT6 System Options Register 6; 0x00003009 ***/
typedef union {
  byte Byte;
  struct {
    byte  AMPEN      : 1;
    byte  VREFSEL0   : 1;
    byte  VREFSEL1   : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  ESFC       : 1;
  } Bits;
  struct {
    byte             : 1;
    byte  grpVREFSEL : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} SYS_SOPT6STR;
extern volatile SYS_SOPT6STR _SYS_SOPT6 @0x00003009;
#define SYS_SOPT6                 _SYS_SOPT6.Byte
#define SYS_SOPT6_AMPEN           _SYS_SOPT6.Bits.AMPEN
#define SYS_SOPT6_VREFSEL0        _SYS_SOPT6.Bits.VREFSEL0
#define SYS_SOPT6_VREFSEL1        _SYS_SOPT6.Bits.VREFSEL1
#define SYS_SOPT6_ESFC            _SYS_SOPT6.Bits.ESFC
#define SYS_SOPT6_VREFSEL         _SYS_SOPT6.MergedBits.grpVREFSEL

#define SYS_SOPT6_AMPEN_MASK      1U
#define SYS_SOPT6_AMPEN_BITNUM    0
#define SYS_SOPT6_VREFSEL0_MASK   2U
#define SYS_SOPT6_VREFSEL0_BITNUM 1
#define SYS_SOPT6_VREFSEL1_MASK   4U
#define SYS_SOPT6_VREFSEL1_BITNUM 2
#define SYS_SOPT6_ESFC_MASK       128U
#define SYS_SOPT6_ESFC_BITNUM     7
#define SYS_SOPT6_VREFSEL_MASK    6U
#define SYS_SOPT6_VREFSEL_BITNUM  1


/*** SYS_SOPT7 System Options Register 7; 0x0000300A ***/
typedef union {
  byte Byte;
  struct {
    byte  FTM0CH0OC  : 1;
    byte  FTM0CH1OC  : 1;
    byte  FTM2CH0OC  : 1;
    byte  FTM2CH1OC  : 1;
    byte  FTM2CH2OC  : 1;
    byte  FTM2CH3OC  : 1;
    byte  FTM2CH4OC  : 1;
    byte  FTM2CH5OC  : 1;
  } Bits;
} SYS_SOPT7STR;
extern volatile SYS_SOPT7STR _SYS_SOPT7 @0x0000300A;
#define SYS_SOPT7                 _SYS_SOPT7.Byte
#define SYS_SOPT7_FTM0CH0OC       _SYS_SOPT7.Bits.FTM0CH0OC
#define SYS_SOPT7_FTM0CH1OC       _SYS_SOPT7.Bits.FTM0CH1OC
#define SYS_SOPT7_FTM2CH0OC       _SYS_SOPT7.Bits.FTM2CH0OC
#define SYS_SOPT7_FTM2CH1OC       _SYS_SOPT7.Bits.FTM2CH1OC
#define SYS_SOPT7_FTM2CH2OC       _SYS_SOPT7.Bits.FTM2CH2OC
#define SYS_SOPT7_FTM2CH3OC       _SYS_SOPT7.Bits.FTM2CH3OC
#define SYS_SOPT7_FTM2CH4OC       _SYS_SOPT7.Bits.FTM2CH4OC
#define SYS_SOPT7_FTM2CH5OC       _SYS_SOPT7.Bits.FTM2CH5OC

#define SYS_SOPT7_FTM0CH0OC_MASK  1U
#define SYS_SOPT7_FTM0CH0OC_BITNUM 0
#define SYS_SOPT7_FTM0CH1OC_MASK  2U
#define SYS_SOPT7_FTM0CH1OC_BITNUM 1
#define SYS_SOPT7_FTM2CH0OC_MASK  4U
#define SYS_SOPT7_FTM2CH0OC_BITNUM 2
#define SYS_SOPT7_FTM2CH1OC_MASK  8U
#define SYS_SOPT7_FTM2CH1OC_BITNUM 3
#define SYS_SOPT7_FTM2CH2OC_MASK  16U
#define SYS_SOPT7_FTM2CH2OC_BITNUM 4
#define SYS_SOPT7_FTM2CH3OC_MASK  32U
#define SYS_SOPT7_FTM2CH3OC_BITNUM 5
#define SYS_SOPT7_FTM2CH4OC_MASK  64U
#define SYS_SOPT7_FTM2CH4OC_BITNUM 6
#define SYS_SOPT7_FTM2CH5OC_MASK  128U
#define SYS_SOPT7_FTM2CH5OC_BITNUM 7


/*** SYS_SOPT8 System Options Register 8; 0x0000300B ***/
typedef union {
  byte Byte;
  struct {
    byte  FTM0CH0OCV : 1;
    byte  FTM0CH1OCV : 1;
    byte  FTM2CH0OCV : 1;
    byte  FTM2CH1OCV : 1;
    byte  FTM2CH2OCV : 1;
    byte  FTM2CH3OCV : 1;
    byte  FTM2CH4OCV : 1;
    byte  FTM2CH5OCV : 1;
  } Bits;
} SYS_SOPT8STR;
extern volatile SYS_SOPT8STR _SYS_SOPT8 @0x0000300B;
#define SYS_SOPT8                 _SYS_SOPT8.Byte
#define SYS_SOPT8_FTM0CH0OCV      _SYS_SOPT8.Bits.FTM0CH0OCV
#define SYS_SOPT8_FTM0CH1OCV      _SYS_SOPT8.Bits.FTM0CH1OCV
#define SYS_SOPT8_FTM2CH0OCV      _SYS_SOPT8.Bits.FTM2CH0OCV
#define SYS_SOPT8_FTM2CH1OCV      _SYS_SOPT8.Bits.FTM2CH1OCV
#define SYS_SOPT8_FTM2CH2OCV      _SYS_SOPT8.Bits.FTM2CH2OCV
#define SYS_SOPT8_FTM2CH3OCV      _SYS_SOPT8.Bits.FTM2CH3OCV
#define SYS_SOPT8_FTM2CH4OCV      _SYS_SOPT8.Bits.FTM2CH4OCV
#define SYS_SOPT8_FTM2CH5OCV      _SYS_SOPT8.Bits.FTM2CH5OCV

#define SYS_SOPT8_FTM0CH0OCV_MASK 1U
#define SYS_SOPT8_FTM0CH0OCV_BITNUM 0
#define SYS_SOPT8_FTM0CH1OCV_MASK 2U
#define SYS_SOPT8_FTM0CH1OCV_BITNUM 1
#define SYS_SOPT8_FTM2CH0OCV_MASK 4U
#define SYS_SOPT8_FTM2CH0OCV_BITNUM 2
#define SYS_SOPT8_FTM2CH1OCV_MASK 8U
#define SYS_SOPT8_FTM2CH1OCV_BITNUM 3
#define SYS_SOPT8_FTM2CH2OCV_MASK 16U
#define SYS_SOPT8_FTM2CH2OCV_BITNUM 4
#define SYS_SOPT8_FTM2CH3OCV_MASK 32U
#define SYS_SOPT8_FTM2CH3OCV_BITNUM 5
#define SYS_SOPT8_FTM2CH4OCV_MASK 64U
#define SYS_SOPT8_FTM2CH4OCV_BITNUM 6
#define SYS_SOPT8_FTM2CH5OCV_MASK 128U
#define SYS_SOPT8_FTM2CH5OCV_BITNUM 7


/*** SYS_SCGC1 System Clock Gating Control 1 Register; 0x0000300C ***/
typedef union {
  byte Byte;
  struct {
    byte  RTC        : 1;
    byte  MTIM0      : 1;
    byte  MTIM1      : 1;
    byte  PWT        : 1;
    byte             : 1;
    byte  FTM0       : 1;
    byte             : 1;
    byte  FTM2       : 1;
  } Bits;
  struct {
    byte             : 1;
    byte  grpMTIM    : 2;
    byte             : 1;
    byte             : 1;
    byte  grpFTM     : 2;
    byte             : 1;
  } MergedBits;
} SYS_SCGC1STR;
extern volatile SYS_SCGC1STR _SYS_SCGC1 @0x0000300C;
#define SYS_SCGC1                 _SYS_SCGC1.Byte
#define SYS_SCGC1_RTC             _SYS_SCGC1.Bits.RTC
#define SYS_SCGC1_MTIM0           _SYS_SCGC1.Bits.MTIM0
#define SYS_SCGC1_MTIM1           _SYS_SCGC1.Bits.MTIM1
#define SYS_SCGC1_PWT             _SYS_SCGC1.Bits.PWT
#define SYS_SCGC1_FTM0            _SYS_SCGC1.Bits.FTM0
#define SYS_SCGC1_FTM2            _SYS_SCGC1.Bits.FTM2
#define SYS_SCGC1_MTIM            _SYS_SCGC1.MergedBits.grpMTIM
#define SYS_SCGC1_FTM             _SYS_SCGC1.MergedBits.grpFTM

#define SYS_SCGC1_RTC_MASK        1U
#define SYS_SCGC1_RTC_BITNUM      0
#define SYS_SCGC1_MTIM0_MASK      2U
#define SYS_SCGC1_MTIM0_BITNUM    1
#define SYS_SCGC1_MTIM1_MASK      4U
#define SYS_SCGC1_MTIM1_BITNUM    2
#define SYS_SCGC1_PWT_MASK        8U
#define SYS_SCGC1_PWT_BITNUM      3
#define SYS_SCGC1_FTM0_MASK       32U
#define SYS_SCGC1_FTM0_BITNUM     5
#define SYS_SCGC1_FTM2_MASK       128U
#define SYS_SCGC1_FTM2_BITNUM     7
#define SYS_SCGC1_MTIM_MASK       6U
#define SYS_SCGC1_MTIM_BITNUM     1
#define SYS_SCGC1_FTM_MASK        96U
#define SYS_SCGC1_FTM_BITNUM      5


/*** SYS_SCGC2 System Clock Gating Control 2 Register; 0x0000300D ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  CRC        : 1;
    byte  IPC        : 1;
    byte  NVM        : 1;
    byte  DBG        : 1;
    byte  PMC        : 1;
    byte  FDS        : 1;
  } Bits;
} SYS_SCGC2STR;
extern volatile SYS_SCGC2STR _SYS_SCGC2 @0x0000300D;
#define SYS_SCGC2                 _SYS_SCGC2.Byte
#define SYS_SCGC2_CRC             _SYS_SCGC2.Bits.CRC
#define SYS_SCGC2_IPC             _SYS_SCGC2.Bits.IPC
#define SYS_SCGC2_NVM             _SYS_SCGC2.Bits.NVM
#define SYS_SCGC2_DBG             _SYS_SCGC2.Bits.DBG
#define SYS_SCGC2_PMC             _SYS_SCGC2.Bits.PMC
#define SYS_SCGC2_FDS             _SYS_SCGC2.Bits.FDS

#define SYS_SCGC2_CRC_MASK        4U
#define SYS_SCGC2_CRC_BITNUM      2
#define SYS_SCGC2_IPC_MASK        8U
#define SYS_SCGC2_IPC_BITNUM      3
#define SYS_SCGC2_NVM_MASK        16U
#define SYS_SCGC2_NVM_BITNUM      4
#define SYS_SCGC2_DBG_MASK        32U
#define SYS_SCGC2_DBG_BITNUM      5
#define SYS_SCGC2_PMC_MASK        64U
#define SYS_SCGC2_PMC_BITNUM      6
#define SYS_SCGC2_FDS_MASK        128U
#define SYS_SCGC2_FDS_BITNUM      7


/*** SYS_SCGC3 System Clock Gating Control 3 Register; 0x0000300E ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte  IIC        : 1;
    byte             : 1;
    byte             : 1;
    byte  SCI0       : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
} SYS_SCGC3STR;
extern volatile SYS_SCGC3STR _SYS_SCGC3 @0x0000300E;
#define SYS_SCGC3                 _SYS_SCGC3.Byte
#define SYS_SCGC3_IIC             _SYS_SCGC3.Bits.IIC
#define SYS_SCGC3_SCI0            _SYS_SCGC3.Bits.SCI0

#define SYS_SCGC3_IIC_MASK        2U
#define SYS_SCGC3_IIC_BITNUM      1
#define SYS_SCGC3_SCI0_MASK       16U
#define SYS_SCGC3_SCI0_BITNUM     4


/*** SYS_SCGC4 System Clock Gating Control 2 Register; 0x0000300F ***/
typedef union {
  byte Byte;
  struct {
    byte  KBI0       : 1;
    byte             : 1;
    byte             : 1;
    byte  IRQ        : 1;
    byte             : 1;
    byte  ADC        : 1;
    byte  ACMP1      : 1;
    byte  ACMP0      : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  grpACMP    : 2;
  } MergedBits;
} SYS_SCGC4STR;
extern volatile SYS_SCGC4STR _SYS_SCGC4 @0x0000300F;
#define SYS_SCGC4                 _SYS_SCGC4.Byte
#define SYS_SCGC4_KBI0            _SYS_SCGC4.Bits.KBI0
#define SYS_SCGC4_IRQ             _SYS_SCGC4.Bits.IRQ
#define SYS_SCGC4_ADC             _SYS_SCGC4.Bits.ADC
#define SYS_SCGC4_ACMP1           _SYS_SCGC4.Bits.ACMP1
#define SYS_SCGC4_ACMP0           _SYS_SCGC4.Bits.ACMP0
#define SYS_SCGC4_ACMP            _SYS_SCGC4.MergedBits.grpACMP

#define SYS_SCGC4_KBI0_MASK       1U
#define SYS_SCGC4_KBI0_BITNUM     0
#define SYS_SCGC4_IRQ_MASK        8U
#define SYS_SCGC4_IRQ_BITNUM      3
#define SYS_SCGC4_ADC_MASK        32U
#define SYS_SCGC4_ADC_BITNUM      5
#define SYS_SCGC4_ACMP1_MASK      64U
#define SYS_SCGC4_ACMP1_BITNUM    6
#define SYS_SCGC4_ACMP0_MASK      128U
#define SYS_SCGC4_ACMP0_BITNUM    7
#define SYS_SCGC4_ACMP_MASK       192U
#define SYS_SCGC4_ACMP_BITNUM     6


/*** DBG_CA Debug Comparator A Register; 0x00003010 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** DBG_CAH Debug Comparator A High Register; 0x00003010 ***/
    union {
      byte Byte;
      struct {
        byte  CA0        : 1;
        byte  CA1        : 1;
        byte  CA2        : 1;
        byte  CA3        : 1;
        byte  CA4        : 1;
        byte  CA5        : 1;
        byte  CA6        : 1;
        byte  CA7        : 1;
      } Bits;
    } DBG_CAHSTR;
    #define DBG_CAH                   _DBG_CA.Overlap_STR.DBG_CAHSTR.Byte
    #define DBG_CAH_CA0               _DBG_CA.Overlap_STR.DBG_CAHSTR.Bits.CA0
    #define DBG_CAH_CA1               _DBG_CA.Overlap_STR.DBG_CAHSTR.Bits.CA1
    #define DBG_CAH_CA2               _DBG_CA.Overlap_STR.DBG_CAHSTR.Bits.CA2
    #define DBG_CAH_CA3               _DBG_CA.Overlap_STR.DBG_CAHSTR.Bits.CA3
    #define DBG_CAH_CA4               _DBG_CA.Overlap_STR.DBG_CAHSTR.Bits.CA4
    #define DBG_CAH_CA5               _DBG_CA.Overlap_STR.DBG_CAHSTR.Bits.CA5
    #define DBG_CAH_CA6               _DBG_CA.Overlap_STR.DBG_CAHSTR.Bits.CA6
    #define DBG_CAH_CA7               _DBG_CA.Overlap_STR.DBG_CAHSTR.Bits.CA7
    
    #define DBG_CAH_CA0_MASK          1U
    #define DBG_CAH_CA0_BITNUM        0
    #define DBG_CAH_CA1_MASK          2U
    #define DBG_CAH_CA1_BITNUM        1
    #define DBG_CAH_CA2_MASK          4U
    #define DBG_CAH_CA2_BITNUM        2
    #define DBG_CAH_CA3_MASK          8U
    #define DBG_CAH_CA3_BITNUM        3
    #define DBG_CAH_CA4_MASK          16U
    #define DBG_CAH_CA4_BITNUM        4
    #define DBG_CAH_CA5_MASK          32U
    #define DBG_CAH_CA5_BITNUM        5
    #define DBG_CAH_CA6_MASK          64U
    #define DBG_CAH_CA6_BITNUM        6
    #define DBG_CAH_CA7_MASK          128U
    #define DBG_CAH_CA7_BITNUM        7
    
    /*** DBG_CAL Debug Comparator A Low Register; 0x00003011 ***/
    union {
      byte Byte;
      struct {
        byte  CA0        : 1;
        byte  CA1        : 1;
        byte  CA2        : 1;
        byte  CA3        : 1;
        byte  CA4        : 1;
        byte  CA5        : 1;
        byte  CA6        : 1;
        byte  CA7        : 1;
      } Bits;
    } DBG_CALSTR;
    #define DBG_CAL                   _DBG_CA.Overlap_STR.DBG_CALSTR.Byte
    #define DBG_CAL_CA0               _DBG_CA.Overlap_STR.DBG_CALSTR.Bits.CA0
    #define DBG_CAL_CA1               _DBG_CA.Overlap_STR.DBG_CALSTR.Bits.CA1
    #define DBG_CAL_CA2               _DBG_CA.Overlap_STR.DBG_CALSTR.Bits.CA2
    #define DBG_CAL_CA3               _DBG_CA.Overlap_STR.DBG_CALSTR.Bits.CA3
    #define DBG_CAL_CA4               _DBG_CA.Overlap_STR.DBG_CALSTR.Bits.CA4
    #define DBG_CAL_CA5               _DBG_CA.Overlap_STR.DBG_CALSTR.Bits.CA5
    #define DBG_CAL_CA6               _DBG_CA.Overlap_STR.DBG_CALSTR.Bits.CA6
    #define DBG_CAL_CA7               _DBG_CA.Overlap_STR.DBG_CALSTR.Bits.CA7
    
    #define DBG_CAL_CA0_MASK          1U
    #define DBG_CAL_CA0_BITNUM        0
    #define DBG_CAL_CA1_MASK          2U
    #define DBG_CAL_CA1_BITNUM        1
    #define DBG_CAL_CA2_MASK          4U
    #define DBG_CAL_CA2_BITNUM        2
    #define DBG_CAL_CA3_MASK          8U
    #define DBG_CAL_CA3_BITNUM        3
    #define DBG_CAL_CA4_MASK          16U
    #define DBG_CAL_CA4_BITNUM        4
    #define DBG_CAL_CA5_MASK          32U
    #define DBG_CAL_CA5_BITNUM        5
    #define DBG_CAL_CA6_MASK          64U
    #define DBG_CAL_CA6_BITNUM        6
    #define DBG_CAL_CA7_MASK          128U
    #define DBG_CAL_CA7_BITNUM        7
    
  } Overlap_STR;
} DBG_CASTR;
extern volatile DBG_CASTR _DBG_CA @0x00003010;
#define DBG_CA                    _DBG_CA.Word


/*** DBG_CB Debug Comparator B Register; 0x00003012 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** DBG_CBH Debug Comparator B High Register; 0x00003012 ***/
    union {
      byte Byte;
      struct {
        byte  CB0        : 1;
        byte  CB1        : 1;
        byte  CB2        : 1;
        byte  CB3        : 1;
        byte  CB4        : 1;
        byte  CB5        : 1;
        byte  CB6        : 1;
        byte  CB7        : 1;
      } Bits;
    } DBG_CBHSTR;
    #define DBG_CBH                   _DBG_CB.Overlap_STR.DBG_CBHSTR.Byte
    #define DBG_CBH_CB0               _DBG_CB.Overlap_STR.DBG_CBHSTR.Bits.CB0
    #define DBG_CBH_CB1               _DBG_CB.Overlap_STR.DBG_CBHSTR.Bits.CB1
    #define DBG_CBH_CB2               _DBG_CB.Overlap_STR.DBG_CBHSTR.Bits.CB2
    #define DBG_CBH_CB3               _DBG_CB.Overlap_STR.DBG_CBHSTR.Bits.CB3
    #define DBG_CBH_CB4               _DBG_CB.Overlap_STR.DBG_CBHSTR.Bits.CB4
    #define DBG_CBH_CB5               _DBG_CB.Overlap_STR.DBG_CBHSTR.Bits.CB5
    #define DBG_CBH_CB6               _DBG_CB.Overlap_STR.DBG_CBHSTR.Bits.CB6
    #define DBG_CBH_CB7               _DBG_CB.Overlap_STR.DBG_CBHSTR.Bits.CB7
    
    #define DBG_CBH_CB0_MASK          1U
    #define DBG_CBH_CB0_BITNUM        0
    #define DBG_CBH_CB1_MASK          2U
    #define DBG_CBH_CB1_BITNUM        1
    #define DBG_CBH_CB2_MASK          4U
    #define DBG_CBH_CB2_BITNUM        2
    #define DBG_CBH_CB3_MASK          8U
    #define DBG_CBH_CB3_BITNUM        3
    #define DBG_CBH_CB4_MASK          16U
    #define DBG_CBH_CB4_BITNUM        4
    #define DBG_CBH_CB5_MASK          32U
    #define DBG_CBH_CB5_BITNUM        5
    #define DBG_CBH_CB6_MASK          64U
    #define DBG_CBH_CB6_BITNUM        6
    #define DBG_CBH_CB7_MASK          128U
    #define DBG_CBH_CB7_BITNUM        7
    
    /*** DBG_CBL Debug Comparator B Low Register; 0x00003013 ***/
    union {
      byte Byte;
      struct {
        byte  CB0        : 1;
        byte  CB1        : 1;
        byte  CB2        : 1;
        byte  CB3        : 1;
        byte  CB4        : 1;
        byte  CB5        : 1;
        byte  CB6        : 1;
        byte  CB7        : 1;
      } Bits;
    } DBG_CBLSTR;
    #define DBG_CBL                   _DBG_CB.Overlap_STR.DBG_CBLSTR.Byte
    #define DBG_CBL_CB0               _DBG_CB.Overlap_STR.DBG_CBLSTR.Bits.CB0
    #define DBG_CBL_CB1               _DBG_CB.Overlap_STR.DBG_CBLSTR.Bits.CB1
    #define DBG_CBL_CB2               _DBG_CB.Overlap_STR.DBG_CBLSTR.Bits.CB2
    #define DBG_CBL_CB3               _DBG_CB.Overlap_STR.DBG_CBLSTR.Bits.CB3
    #define DBG_CBL_CB4               _DBG_CB.Overlap_STR.DBG_CBLSTR.Bits.CB4
    #define DBG_CBL_CB5               _DBG_CB.Overlap_STR.DBG_CBLSTR.Bits.CB5
    #define DBG_CBL_CB6               _DBG_CB.Overlap_STR.DBG_CBLSTR.Bits.CB6
    #define DBG_CBL_CB7               _DBG_CB.Overlap_STR.DBG_CBLSTR.Bits.CB7
    
    #define DBG_CBL_CB0_MASK          1U
    #define DBG_CBL_CB0_BITNUM        0
    #define DBG_CBL_CB1_MASK          2U
    #define DBG_CBL_CB1_BITNUM        1
    #define DBG_CBL_CB2_MASK          4U
    #define DBG_CBL_CB2_BITNUM        2
    #define DBG_CBL_CB3_MASK          8U
    #define DBG_CBL_CB3_BITNUM        3
    #define DBG_CBL_CB4_MASK          16U
    #define DBG_CBL_CB4_BITNUM        4
    #define DBG_CBL_CB5_MASK          32U
    #define DBG_CBL_CB5_BITNUM        5
    #define DBG_CBL_CB6_MASK          64U
    #define DBG_CBL_CB6_BITNUM        6
    #define DBG_CBL_CB7_MASK          128U
    #define DBG_CBL_CB7_BITNUM        7
    
  } Overlap_STR;
} DBG_CBSTR;
extern volatile DBG_CBSTR _DBG_CB @0x00003012;
#define DBG_CB                    _DBG_CB.Word


/*** DBG_CC Debug Comparator C Register; 0x00003014 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** DBG_CCH Debug Comparator C High Register; 0x00003014 ***/
    union {
      byte Byte;
      struct {
        byte  CC0        : 1;
        byte  CC1        : 1;
        byte  CC2        : 1;
        byte  CC3        : 1;
        byte  CC4        : 1;
        byte  CC5        : 1;
        byte  CC6        : 1;
        byte  CC7        : 1;
      } Bits;
    } DBG_CCHSTR;
    #define DBG_CCH                   _DBG_CC.Overlap_STR.DBG_CCHSTR.Byte
    #define DBG_CCH_CC0               _DBG_CC.Overlap_STR.DBG_CCHSTR.Bits.CC0
    #define DBG_CCH_CC1               _DBG_CC.Overlap_STR.DBG_CCHSTR.Bits.CC1
    #define DBG_CCH_CC2               _DBG_CC.Overlap_STR.DBG_CCHSTR.Bits.CC2
    #define DBG_CCH_CC3               _DBG_CC.Overlap_STR.DBG_CCHSTR.Bits.CC3
    #define DBG_CCH_CC4               _DBG_CC.Overlap_STR.DBG_CCHSTR.Bits.CC4
    #define DBG_CCH_CC5               _DBG_CC.Overlap_STR.DBG_CCHSTR.Bits.CC5
    #define DBG_CCH_CC6               _DBG_CC.Overlap_STR.DBG_CCHSTR.Bits.CC6
    #define DBG_CCH_CC7               _DBG_CC.Overlap_STR.DBG_CCHSTR.Bits.CC7
    
    #define DBG_CCH_CC0_MASK          1U
    #define DBG_CCH_CC0_BITNUM        0
    #define DBG_CCH_CC1_MASK          2U
    #define DBG_CCH_CC1_BITNUM        1
    #define DBG_CCH_CC2_MASK          4U
    #define DBG_CCH_CC2_BITNUM        2
    #define DBG_CCH_CC3_MASK          8U
    #define DBG_CCH_CC3_BITNUM        3
    #define DBG_CCH_CC4_MASK          16U
    #define DBG_CCH_CC4_BITNUM        4
    #define DBG_CCH_CC5_MASK          32U
    #define DBG_CCH_CC5_BITNUM        5
    #define DBG_CCH_CC6_MASK          64U
    #define DBG_CCH_CC6_BITNUM        6
    #define DBG_CCH_CC7_MASK          128U
    #define DBG_CCH_CC7_BITNUM        7
    
    /*** DBG_CCL Debug Comparator C Low Register; 0x00003015 ***/
    union {
      byte Byte;
      struct {
        byte  CC0        : 1;
        byte  CC1        : 1;
        byte  CC2        : 1;
        byte  CC3        : 1;
        byte  CC4        : 1;
        byte  CC5        : 1;
        byte  CC6        : 1;
        byte  CC7        : 1;
      } Bits;
    } DBG_CCLSTR;
    #define DBG_CCL                   _DBG_CC.Overlap_STR.DBG_CCLSTR.Byte
    #define DBG_CCL_CC0               _DBG_CC.Overlap_STR.DBG_CCLSTR.Bits.CC0
    #define DBG_CCL_CC1               _DBG_CC.Overlap_STR.DBG_CCLSTR.Bits.CC1
    #define DBG_CCL_CC2               _DBG_CC.Overlap_STR.DBG_CCLSTR.Bits.CC2
    #define DBG_CCL_CC3               _DBG_CC.Overlap_STR.DBG_CCLSTR.Bits.CC3
    #define DBG_CCL_CC4               _DBG_CC.Overlap_STR.DBG_CCLSTR.Bits.CC4
    #define DBG_CCL_CC5               _DBG_CC.Overlap_STR.DBG_CCLSTR.Bits.CC5
    #define DBG_CCL_CC6               _DBG_CC.Overlap_STR.DBG_CCLSTR.Bits.CC6
    #define DBG_CCL_CC7               _DBG_CC.Overlap_STR.DBG_CCLSTR.Bits.CC7
    
    #define DBG_CCL_CC0_MASK          1U
    #define DBG_CCL_CC0_BITNUM        0
    #define DBG_CCL_CC1_MASK          2U
    #define DBG_CCL_CC1_BITNUM        1
    #define DBG_CCL_CC2_MASK          4U
    #define DBG_CCL_CC2_BITNUM        2
    #define DBG_CCL_CC3_MASK          8U
    #define DBG_CCL_CC3_BITNUM        3
    #define DBG_CCL_CC4_MASK          16U
    #define DBG_CCL_CC4_BITNUM        4
    #define DBG_CCL_CC5_MASK          32U
    #define DBG_CCL_CC5_BITNUM        5
    #define DBG_CCL_CC6_MASK          64U
    #define DBG_CCL_CC6_BITNUM        6
    #define DBG_CCL_CC7_MASK          128U
    #define DBG_CCL_CC7_BITNUM        7
    
  } Overlap_STR;
} DBG_CCSTR;
extern volatile DBG_CCSTR _DBG_CC @0x00003014;
#define DBG_CC                    _DBG_CC.Word


/*** DBG_F Debug FIFO Register; 0x00003016 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** DBG_FH Debug FIFO High Register; 0x00003016 ***/
    union {
      byte Byte;
      struct {
        byte  F0         : 1;
        byte  F1         : 1;
        byte  F2         : 1;
        byte  F3         : 1;
        byte  F4         : 1;
        byte  F5         : 1;
        byte  F6         : 1;
        byte  F7         : 1;
      } Bits;
    } DBG_FHSTR;
    #define DBG_FH                    _DBG_F.Overlap_STR.DBG_FHSTR.Byte
    #define DBG_FH_F0                 _DBG_F.Overlap_STR.DBG_FHSTR.Bits.F0
    #define DBG_FH_F1                 _DBG_F.Overlap_STR.DBG_FHSTR.Bits.F1
    #define DBG_FH_F2                 _DBG_F.Overlap_STR.DBG_FHSTR.Bits.F2
    #define DBG_FH_F3                 _DBG_F.Overlap_STR.DBG_FHSTR.Bits.F3
    #define DBG_FH_F4                 _DBG_F.Overlap_STR.DBG_FHSTR.Bits.F4
    #define DBG_FH_F5                 _DBG_F.Overlap_STR.DBG_FHSTR.Bits.F5
    #define DBG_FH_F6                 _DBG_F.Overlap_STR.DBG_FHSTR.Bits.F6
    #define DBG_FH_F7                 _DBG_F.Overlap_STR.DBG_FHSTR.Bits.F7
    
    #define DBG_FH_F0_MASK            1U
    #define DBG_FH_F0_BITNUM          0
    #define DBG_FH_F1_MASK            2U
    #define DBG_FH_F1_BITNUM          1
    #define DBG_FH_F2_MASK            4U
    #define DBG_FH_F2_BITNUM          2
    #define DBG_FH_F3_MASK            8U
    #define DBG_FH_F3_BITNUM          3
    #define DBG_FH_F4_MASK            16U
    #define DBG_FH_F4_BITNUM          4
    #define DBG_FH_F5_MASK            32U
    #define DBG_FH_F5_BITNUM          5
    #define DBG_FH_F6_MASK            64U
    #define DBG_FH_F6_BITNUM          6
    #define DBG_FH_F7_MASK            128U
    #define DBG_FH_F7_BITNUM          7
    
    /*** DBG_FL Debug FIFO Low Register; 0x00003017 ***/
    union {
      byte Byte;
      struct {
        byte  F0         : 1;
        byte  F1         : 1;
        byte  F2         : 1;
        byte  F3         : 1;
        byte  F4         : 1;
        byte  F5         : 1;
        byte  F6         : 1;
        byte  F7         : 1;
      } Bits;
    } DBG_FLSTR;
    #define DBG_FL                    _DBG_F.Overlap_STR.DBG_FLSTR.Byte
    #define DBG_FL_F0                 _DBG_F.Overlap_STR.DBG_FLSTR.Bits.F0
    #define DBG_FL_F1                 _DBG_F.Overlap_STR.DBG_FLSTR.Bits.F1
    #define DBG_FL_F2                 _DBG_F.Overlap_STR.DBG_FLSTR.Bits.F2
    #define DBG_FL_F3                 _DBG_F.Overlap_STR.DBG_FLSTR.Bits.F3
    #define DBG_FL_F4                 _DBG_F.Overlap_STR.DBG_FLSTR.Bits.F4
    #define DBG_FL_F5                 _DBG_F.Overlap_STR.DBG_FLSTR.Bits.F5
    #define DBG_FL_F6                 _DBG_F.Overlap_STR.DBG_FLSTR.Bits.F6
    #define DBG_FL_F7                 _DBG_F.Overlap_STR.DBG_FLSTR.Bits.F7
    
    #define DBG_FL_F0_MASK            1U
    #define DBG_FL_F0_BITNUM          0
    #define DBG_FL_F1_MASK            2U
    #define DBG_FL_F1_BITNUM          1
    #define DBG_FL_F2_MASK            4U
    #define DBG_FL_F2_BITNUM          2
    #define DBG_FL_F3_MASK            8U
    #define DBG_FL_F3_BITNUM          3
    #define DBG_FL_F4_MASK            16U
    #define DBG_FL_F4_BITNUM          4
    #define DBG_FL_F5_MASK            32U
    #define DBG_FL_F5_BITNUM          5
    #define DBG_FL_F6_MASK            64U
    #define DBG_FL_F6_BITNUM          6
    #define DBG_FL_F7_MASK            128U
    #define DBG_FL_F7_BITNUM          7
    
  } Overlap_STR;
} DBG_FSTR;
extern volatile DBG_FSTR _DBG_F @0x00003016;
#define DBG_F                     _DBG_F.Word


/*** DBG_CAX Debug Comparator A Extension Register; 0x00003018 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  RWA        : 1;
    byte  RWAEN      : 1;
  } Bits;
} DBG_CAXSTR;
extern volatile DBG_CAXSTR _DBG_CAX @0x00003018;
#define DBG_CAX                   _DBG_CAX.Byte
#define DBG_CAX_RWA               _DBG_CAX.Bits.RWA
#define DBG_CAX_RWAEN             _DBG_CAX.Bits.RWAEN

#define DBG_CAX_RWA_MASK          64U
#define DBG_CAX_RWA_BITNUM        6
#define DBG_CAX_RWAEN_MASK        128U
#define DBG_CAX_RWAEN_BITNUM      7


/*** DBG_CBX Debug Comparator B Extension Register; 0x00003019 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  RWB        : 1;
    byte  RWBEN      : 1;
  } Bits;
} DBG_CBXSTR;
extern volatile DBG_CBXSTR _DBG_CBX @0x00003019;
#define DBG_CBX                   _DBG_CBX.Byte
#define DBG_CBX_RWB               _DBG_CBX.Bits.RWB
#define DBG_CBX_RWBEN             _DBG_CBX.Bits.RWBEN

#define DBG_CBX_RWB_MASK          64U
#define DBG_CBX_RWB_BITNUM        6
#define DBG_CBX_RWBEN_MASK        128U
#define DBG_CBX_RWBEN_BITNUM      7


/*** DBG_CCX Debug Comparator C Extension Register; 0x0000301A ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  RWC        : 1;
    byte  RWCEN      : 1;
  } Bits;
} DBG_CCXSTR;
extern volatile DBG_CCXSTR _DBG_CCX @0x0000301A;
#define DBG_CCX                   _DBG_CCX.Byte
#define DBG_CCX_RWC               _DBG_CCX.Bits.RWC
#define DBG_CCX_RWCEN             _DBG_CCX.Bits.RWCEN

#define DBG_CCX_RWC_MASK          64U
#define DBG_CCX_RWC_BITNUM        6
#define DBG_CCX_RWCEN_MASK        128U
#define DBG_CCX_RWCEN_BITNUM      7


/*** DBG_FX Debug FIFO Extended Information Register; 0x0000301B ***/
typedef union {
  byte Byte;
  struct {
    byte  Bit16      : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  PPACC      : 1;
  } Bits;
} DBG_FXSTR;
extern volatile DBG_FXSTR _DBG_FX @0x0000301B;
#define DBG_FX                    _DBG_FX.Byte
#define DBG_FX_Bit16              _DBG_FX.Bits.Bit16
#define DBG_FX_PPACC              _DBG_FX.Bits.PPACC

#define DBG_FX_Bit16_MASK         1U
#define DBG_FX_Bit16_BITNUM       0
#define DBG_FX_PPACC_MASK         128U
#define DBG_FX_PPACC_BITNUM       7


/*** DBG_C Debug Control Register; 0x0000301C ***/
typedef union {
  byte Byte;
  struct {
    byte  LOOP1      : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  BRKEN      : 1;
    byte  TAG        : 1;
    byte  ARM        : 1;
    byte  DBGEN      : 1;
  } Bits;
} DBG_CSTR;
extern volatile DBG_CSTR _DBG_C @0x0000301C;
#define DBG_C                     _DBG_C.Byte
#define DBG_C_LOOP1               _DBG_C.Bits.LOOP1
#define DBG_C_BRKEN               _DBG_C.Bits.BRKEN
#define DBG_C_TAG                 _DBG_C.Bits.TAG
#define DBG_C_ARM                 _DBG_C.Bits.ARM
#define DBG_C_DBGEN               _DBG_C.Bits.DBGEN

#define DBG_C_LOOP1_MASK          1U
#define DBG_C_LOOP1_BITNUM        0
#define DBG_C_BRKEN_MASK          16U
#define DBG_C_BRKEN_BITNUM        4
#define DBG_C_TAG_MASK            32U
#define DBG_C_TAG_BITNUM          5
#define DBG_C_ARM_MASK            64U
#define DBG_C_ARM_BITNUM          6
#define DBG_C_DBGEN_MASK          128U
#define DBG_C_DBGEN_BITNUM        7


/*** DBG_T Debug Trigger Register; 0x0000301D ***/
typedef union {
  byte Byte;
  struct {
    byte  TRG0       : 1;
    byte  TRG1       : 1;
    byte  TRG2       : 1;
    byte  TRG3       : 1;
    byte             : 1;
    byte             : 1;
    byte  BEGIN      : 1;
    byte  TRGSEL     : 1;
  } Bits;
  struct {
    byte  grpTRG     : 4;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} DBG_TSTR;
extern volatile DBG_TSTR _DBG_T @0x0000301D;
#define DBG_T                     _DBG_T.Byte
#define DBG_T_TRG0                _DBG_T.Bits.TRG0
#define DBG_T_TRG1                _DBG_T.Bits.TRG1
#define DBG_T_TRG2                _DBG_T.Bits.TRG2
#define DBG_T_TRG3                _DBG_T.Bits.TRG3
#define DBG_T_BEGIN               _DBG_T.Bits.BEGIN
#define DBG_T_TRGSEL              _DBG_T.Bits.TRGSEL
#define DBG_T_TRG                 _DBG_T.MergedBits.grpTRG

#define DBG_T_TRG0_MASK           1U
#define DBG_T_TRG0_BITNUM         0
#define DBG_T_TRG1_MASK           2U
#define DBG_T_TRG1_BITNUM         1
#define DBG_T_TRG2_MASK           4U
#define DBG_T_TRG2_BITNUM         2
#define DBG_T_TRG3_MASK           8U
#define DBG_T_TRG3_BITNUM         3
#define DBG_T_BEGIN_MASK          64U
#define DBG_T_BEGIN_BITNUM        6
#define DBG_T_TRGSEL_MASK         128U
#define DBG_T_TRGSEL_BITNUM       7
#define DBG_T_TRG_MASK            15U
#define DBG_T_TRG_BITNUM          0


/*** DBG_S Debug Status Register; 0x0000301E ***/
typedef union {
  byte Byte;
  struct {
    byte  ARMF       : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  CF         : 1;
    byte  BF         : 1;
    byte  AF         : 1;
  } Bits;
} DBG_SSTR;
extern volatile DBG_SSTR _DBG_S @0x0000301E;
#define DBG_S                     _DBG_S.Byte
#define DBG_S_ARMF                _DBG_S.Bits.ARMF
#define DBG_S_CF                  _DBG_S.Bits.CF
#define DBG_S_BF                  _DBG_S.Bits.BF
#define DBG_S_AF                  _DBG_S.Bits.AF

#define DBG_S_ARMF_MASK           1U
#define DBG_S_ARMF_BITNUM         0
#define DBG_S_CF_MASK             32U
#define DBG_S_CF_BITNUM           5
#define DBG_S_BF_MASK             64U
#define DBG_S_BF_BITNUM           6
#define DBG_S_AF_MASK             128U
#define DBG_S_AF_BITNUM           7


/*** DBG_CNT Debug Count Status Register; 0x0000301F ***/
typedef union {
  byte Byte;
  struct {
    byte  CNT0       : 1;
    byte  CNT1       : 1;
    byte  CNT2       : 1;
    byte  CNT3       : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpCNT     : 4;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} DBG_CNTSTR;
extern volatile DBG_CNTSTR _DBG_CNT @0x0000301F;
#define DBG_CNT                   _DBG_CNT.Byte
#define DBG_CNT_CNT0              _DBG_CNT.Bits.CNT0
#define DBG_CNT_CNT1              _DBG_CNT.Bits.CNT1
#define DBG_CNT_CNT2              _DBG_CNT.Bits.CNT2
#define DBG_CNT_CNT3              _DBG_CNT.Bits.CNT3
#define DBG_CNT_CNT               _DBG_CNT.MergedBits.grpCNT

#define DBG_CNT_CNT0_MASK         1U
#define DBG_CNT_CNT0_BITNUM       0
#define DBG_CNT_CNT1_MASK         2U
#define DBG_CNT_CNT1_BITNUM       1
#define DBG_CNT_CNT2_MASK         4U
#define DBG_CNT_CNT2_BITNUM       2
#define DBG_CNT_CNT3_MASK         8U
#define DBG_CNT_CNT3_BITNUM       3
#define DBG_CNT_CNT_MASK          15U
#define DBG_CNT_CNT_BITNUM        0


/*** FTMRH_FCLKDIV Flash Clock Divider Register; 0x00003020 ***/
typedef union {
  byte Byte;
  struct {
    byte  FDIV0      : 1;
    byte  FDIV1      : 1;
    byte  FDIV2      : 1;
    byte  FDIV3      : 1;
    byte  FDIV4      : 1;
    byte  FDIV5      : 1;
    byte  FDIVLCK    : 1;
    byte  FDIVLD     : 1;
  } Bits;
  struct {
    byte  grpFDIV    : 6;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTMRH_FCLKDIVSTR;
extern volatile FTMRH_FCLKDIVSTR _FTMRH_FCLKDIV @0x00003020;
#define FTMRH_FCLKDIV             _FTMRH_FCLKDIV.Byte
#define FTMRH_FCLKDIV_FDIV0       _FTMRH_FCLKDIV.Bits.FDIV0
#define FTMRH_FCLKDIV_FDIV1       _FTMRH_FCLKDIV.Bits.FDIV1
#define FTMRH_FCLKDIV_FDIV2       _FTMRH_FCLKDIV.Bits.FDIV2
#define FTMRH_FCLKDIV_FDIV3       _FTMRH_FCLKDIV.Bits.FDIV3
#define FTMRH_FCLKDIV_FDIV4       _FTMRH_FCLKDIV.Bits.FDIV4
#define FTMRH_FCLKDIV_FDIV5       _FTMRH_FCLKDIV.Bits.FDIV5
#define FTMRH_FCLKDIV_FDIVLCK     _FTMRH_FCLKDIV.Bits.FDIVLCK
#define FTMRH_FCLKDIV_FDIVLD      _FTMRH_FCLKDIV.Bits.FDIVLD
#define FTMRH_FCLKDIV_FDIV        _FTMRH_FCLKDIV.MergedBits.grpFDIV

#define FTMRH_FCLKDIV_FDIV0_MASK  1U
#define FTMRH_FCLKDIV_FDIV0_BITNUM 0
#define FTMRH_FCLKDIV_FDIV1_MASK  2U
#define FTMRH_FCLKDIV_FDIV1_BITNUM 1
#define FTMRH_FCLKDIV_FDIV2_MASK  4U
#define FTMRH_FCLKDIV_FDIV2_BITNUM 2
#define FTMRH_FCLKDIV_FDIV3_MASK  8U
#define FTMRH_FCLKDIV_FDIV3_BITNUM 3
#define FTMRH_FCLKDIV_FDIV4_MASK  16U
#define FTMRH_FCLKDIV_FDIV4_BITNUM 4
#define FTMRH_FCLKDIV_FDIV5_MASK  32U
#define FTMRH_FCLKDIV_FDIV5_BITNUM 5
#define FTMRH_FCLKDIV_FDIVLCK_MASK 64U
#define FTMRH_FCLKDIV_FDIVLCK_BITNUM 6
#define FTMRH_FCLKDIV_FDIVLD_MASK 128U
#define FTMRH_FCLKDIV_FDIVLD_BITNUM 7
#define FTMRH_FCLKDIV_FDIV_MASK   63U
#define FTMRH_FCLKDIV_FDIV_BITNUM 0


/*** FTMRH_FSEC Flash Security Register; 0x00003021 ***/
typedef union {
  byte Byte;
  struct {
    byte  SEC0       : 1;
    byte  SEC1       : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  KEYEN0     : 1;
    byte  KEYEN1     : 1;
  } Bits;
  struct {
    byte  grpSEC     : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  grpKEYEN   : 2;
  } MergedBits;
} FTMRH_FSECSTR;
extern volatile FTMRH_FSECSTR _FTMRH_FSEC @0x00003021;
#define FTMRH_FSEC                _FTMRH_FSEC.Byte
#define FTMRH_FSEC_SEC0           _FTMRH_FSEC.Bits.SEC0
#define FTMRH_FSEC_SEC1           _FTMRH_FSEC.Bits.SEC1
#define FTMRH_FSEC_KEYEN0         _FTMRH_FSEC.Bits.KEYEN0
#define FTMRH_FSEC_KEYEN1         _FTMRH_FSEC.Bits.KEYEN1
#define FTMRH_FSEC_SEC            _FTMRH_FSEC.MergedBits.grpSEC
#define FTMRH_FSEC_KEYEN          _FTMRH_FSEC.MergedBits.grpKEYEN

#define FTMRH_FSEC_SEC0_MASK      1U
#define FTMRH_FSEC_SEC0_BITNUM    0
#define FTMRH_FSEC_SEC1_MASK      2U
#define FTMRH_FSEC_SEC1_BITNUM    1
#define FTMRH_FSEC_KEYEN0_MASK    64U
#define FTMRH_FSEC_KEYEN0_BITNUM  6
#define FTMRH_FSEC_KEYEN1_MASK    128U
#define FTMRH_FSEC_KEYEN1_BITNUM  7
#define FTMRH_FSEC_SEC_MASK       3U
#define FTMRH_FSEC_SEC_BITNUM     0
#define FTMRH_FSEC_KEYEN_MASK     192U
#define FTMRH_FSEC_KEYEN_BITNUM   6


/*** FTMRH_FCCOBIX Flash CCOB Index Register; 0x00003022 ***/
typedef union {
  byte Byte;
  struct {
    byte  CCOBIX0    : 1;
    byte  CCOBIX1    : 1;
    byte  CCOBIX2    : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpCCOBIX  : 3;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTMRH_FCCOBIXSTR;
extern volatile FTMRH_FCCOBIXSTR _FTMRH_FCCOBIX @0x00003022;
#define FTMRH_FCCOBIX             _FTMRH_FCCOBIX.Byte
#define FTMRH_FCCOBIX_CCOBIX0     _FTMRH_FCCOBIX.Bits.CCOBIX0
#define FTMRH_FCCOBIX_CCOBIX1     _FTMRH_FCCOBIX.Bits.CCOBIX1
#define FTMRH_FCCOBIX_CCOBIX2     _FTMRH_FCCOBIX.Bits.CCOBIX2
#define FTMRH_FCCOBIX_CCOBIX      _FTMRH_FCCOBIX.MergedBits.grpCCOBIX

#define FTMRH_FCCOBIX_CCOBIX0_MASK 1U
#define FTMRH_FCCOBIX_CCOBIX0_BITNUM 0
#define FTMRH_FCCOBIX_CCOBIX1_MASK 2U
#define FTMRH_FCCOBIX_CCOBIX1_BITNUM 1
#define FTMRH_FCCOBIX_CCOBIX2_MASK 4U
#define FTMRH_FCCOBIX_CCOBIX2_BITNUM 2
#define FTMRH_FCCOBIX_CCOBIX_MASK 7U
#define FTMRH_FCCOBIX_CCOBIX_BITNUM 0


/*** FTMRH_FCNFG Flash Configuration Register; 0x00003024 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  CCIE       : 1;
  } Bits;
} FTMRH_FCNFGSTR;
extern volatile FTMRH_FCNFGSTR _FTMRH_FCNFG @0x00003024;
#define FTMRH_FCNFG               _FTMRH_FCNFG.Byte
#define FTMRH_FCNFG_CCIE          _FTMRH_FCNFG.Bits.CCIE

#define FTMRH_FCNFG_CCIE_MASK     128U
#define FTMRH_FCNFG_CCIE_BITNUM   7


/*** FTMRH_FSTAT Flash Status Register; 0x00003026 ***/
typedef union {
  byte Byte;
  struct {
    byte  MGSTAT0    : 1;
    byte  MGSTAT1    : 1;
    byte             : 1;
    byte  MGBUSY     : 1;
    byte  FPVIOL     : 1;
    byte  ACCERR     : 1;
    byte             : 1;
    byte  CCIF       : 1;
  } Bits;
  struct {
    byte  grpMGSTAT  : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTMRH_FSTATSTR;
extern volatile FTMRH_FSTATSTR _FTMRH_FSTAT @0x00003026;
#define FTMRH_FSTAT               _FTMRH_FSTAT.Byte
#define FTMRH_FSTAT_MGSTAT0       _FTMRH_FSTAT.Bits.MGSTAT0
#define FTMRH_FSTAT_MGSTAT1       _FTMRH_FSTAT.Bits.MGSTAT1
#define FTMRH_FSTAT_MGBUSY        _FTMRH_FSTAT.Bits.MGBUSY
#define FTMRH_FSTAT_FPVIOL        _FTMRH_FSTAT.Bits.FPVIOL
#define FTMRH_FSTAT_ACCERR        _FTMRH_FSTAT.Bits.ACCERR
#define FTMRH_FSTAT_CCIF          _FTMRH_FSTAT.Bits.CCIF
#define FTMRH_FSTAT_MGSTAT        _FTMRH_FSTAT.MergedBits.grpMGSTAT

#define FTMRH_FSTAT_MGSTAT0_MASK  1U
#define FTMRH_FSTAT_MGSTAT0_BITNUM 0
#define FTMRH_FSTAT_MGSTAT1_MASK  2U
#define FTMRH_FSTAT_MGSTAT1_BITNUM 1
#define FTMRH_FSTAT_MGBUSY_MASK   8U
#define FTMRH_FSTAT_MGBUSY_BITNUM 3
#define FTMRH_FSTAT_FPVIOL_MASK   16U
#define FTMRH_FSTAT_FPVIOL_BITNUM 4
#define FTMRH_FSTAT_ACCERR_MASK   32U
#define FTMRH_FSTAT_ACCERR_BITNUM 5
#define FTMRH_FSTAT_CCIF_MASK     128U
#define FTMRH_FSTAT_CCIF_BITNUM   7
#define FTMRH_FSTAT_MGSTAT_MASK   3U
#define FTMRH_FSTAT_MGSTAT_BITNUM 0


/*** FTMRH_FPROT Flash Protection Register; 0x00003028 ***/
typedef union {
  byte Byte;
  struct {
    byte  RNV0       : 1;
    byte  RNV1       : 1;
    byte  RNV2       : 1;
    byte  FPHS0      : 1;
    byte  FPHS1      : 1;
    byte  FPHDIS     : 1;
    byte  RNV6       : 1;
    byte  FPOPEN     : 1;
  } Bits;
  struct {
    byte  grpRNV     : 3;
    byte  grpFPHS    : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTMRH_FPROTSTR;
extern volatile FTMRH_FPROTSTR _FTMRH_FPROT @0x00003028;
#define FTMRH_FPROT               _FTMRH_FPROT.Byte
#define FTMRH_FPROT_RNV0          _FTMRH_FPROT.Bits.RNV0
#define FTMRH_FPROT_RNV1          _FTMRH_FPROT.Bits.RNV1
#define FTMRH_FPROT_RNV2          _FTMRH_FPROT.Bits.RNV2
#define FTMRH_FPROT_FPHS0         _FTMRH_FPROT.Bits.FPHS0
#define FTMRH_FPROT_FPHS1         _FTMRH_FPROT.Bits.FPHS1
#define FTMRH_FPROT_FPHDIS        _FTMRH_FPROT.Bits.FPHDIS
#define FTMRH_FPROT_RNV6          _FTMRH_FPROT.Bits.RNV6
#define FTMRH_FPROT_FPOPEN        _FTMRH_FPROT.Bits.FPOPEN
#define FTMRH_FPROT_RNV           _FTMRH_FPROT.MergedBits.grpRNV
#define FTMRH_FPROT_FPHS          _FTMRH_FPROT.MergedBits.grpFPHS

#define FTMRH_FPROT_RNV0_MASK     1U
#define FTMRH_FPROT_RNV0_BITNUM   0
#define FTMRH_FPROT_RNV1_MASK     2U
#define FTMRH_FPROT_RNV1_BITNUM   1
#define FTMRH_FPROT_RNV2_MASK     4U
#define FTMRH_FPROT_RNV2_BITNUM   2
#define FTMRH_FPROT_FPHS0_MASK    8U
#define FTMRH_FPROT_FPHS0_BITNUM  3
#define FTMRH_FPROT_FPHS1_MASK    16U
#define FTMRH_FPROT_FPHS1_BITNUM  4
#define FTMRH_FPROT_FPHDIS_MASK   32U
#define FTMRH_FPROT_FPHDIS_BITNUM 5
#define FTMRH_FPROT_RNV6_MASK     64U
#define FTMRH_FPROT_RNV6_BITNUM   6
#define FTMRH_FPROT_FPOPEN_MASK   128U
#define FTMRH_FPROT_FPOPEN_BITNUM 7
#define FTMRH_FPROT_RNV_MASK      7U
#define FTMRH_FPROT_RNV_BITNUM    0
#define FTMRH_FPROT_FPHS_MASK     24U
#define FTMRH_FPROT_FPHS_BITNUM   3


/*** FTMRH_FCCOBHI Flash Common Command Object Register:High; 0x0000302A ***/
typedef union {
  byte Byte;
  struct {
    byte  CCOB0      : 1;
    byte  CCOB1      : 1;
    byte  CCOB2      : 1;
    byte  CCOB3      : 1;
    byte  CCOB4      : 1;
    byte  CCOB5      : 1;
    byte  CCOB6      : 1;
    byte  CCOB7      : 1;
  } Bits;
} FTMRH_FCCOBHISTR;
extern volatile FTMRH_FCCOBHISTR _FTMRH_FCCOBHI @0x0000302A;
#define FTMRH_FCCOBHI             _FTMRH_FCCOBHI.Byte
#define FTMRH_FCCOBHI_CCOB0       _FTMRH_FCCOBHI.Bits.CCOB0
#define FTMRH_FCCOBHI_CCOB1       _FTMRH_FCCOBHI.Bits.CCOB1
#define FTMRH_FCCOBHI_CCOB2       _FTMRH_FCCOBHI.Bits.CCOB2
#define FTMRH_FCCOBHI_CCOB3       _FTMRH_FCCOBHI.Bits.CCOB3
#define FTMRH_FCCOBHI_CCOB4       _FTMRH_FCCOBHI.Bits.CCOB4
#define FTMRH_FCCOBHI_CCOB5       _FTMRH_FCCOBHI.Bits.CCOB5
#define FTMRH_FCCOBHI_CCOB6       _FTMRH_FCCOBHI.Bits.CCOB6
#define FTMRH_FCCOBHI_CCOB7       _FTMRH_FCCOBHI.Bits.CCOB7

#define FTMRH_FCCOBHI_CCOB0_MASK  1U
#define FTMRH_FCCOBHI_CCOB0_BITNUM 0
#define FTMRH_FCCOBHI_CCOB1_MASK  2U
#define FTMRH_FCCOBHI_CCOB1_BITNUM 1
#define FTMRH_FCCOBHI_CCOB2_MASK  4U
#define FTMRH_FCCOBHI_CCOB2_BITNUM 2
#define FTMRH_FCCOBHI_CCOB3_MASK  8U
#define FTMRH_FCCOBHI_CCOB3_BITNUM 3
#define FTMRH_FCCOBHI_CCOB4_MASK  16U
#define FTMRH_FCCOBHI_CCOB4_BITNUM 4
#define FTMRH_FCCOBHI_CCOB5_MASK  32U
#define FTMRH_FCCOBHI_CCOB5_BITNUM 5
#define FTMRH_FCCOBHI_CCOB6_MASK  64U
#define FTMRH_FCCOBHI_CCOB6_BITNUM 6
#define FTMRH_FCCOBHI_CCOB7_MASK  128U
#define FTMRH_FCCOBHI_CCOB7_BITNUM 7


/*** FTMRH_FCCOBLO Flash Common Command Object Register: Low; 0x0000302B ***/
typedef union {
  byte Byte;
  struct {
    byte  CCOB0      : 1;
    byte  CCOB1      : 1;
    byte  CCOB2      : 1;
    byte  CCOB3      : 1;
    byte  CCOB4      : 1;
    byte  CCOB5      : 1;
    byte  CCOB6      : 1;
    byte  CCOB7      : 1;
  } Bits;
} FTMRH_FCCOBLOSTR;
extern volatile FTMRH_FCCOBLOSTR _FTMRH_FCCOBLO @0x0000302B;
#define FTMRH_FCCOBLO             _FTMRH_FCCOBLO.Byte
#define FTMRH_FCCOBLO_CCOB0       _FTMRH_FCCOBLO.Bits.CCOB0
#define FTMRH_FCCOBLO_CCOB1       _FTMRH_FCCOBLO.Bits.CCOB1
#define FTMRH_FCCOBLO_CCOB2       _FTMRH_FCCOBLO.Bits.CCOB2
#define FTMRH_FCCOBLO_CCOB3       _FTMRH_FCCOBLO.Bits.CCOB3
#define FTMRH_FCCOBLO_CCOB4       _FTMRH_FCCOBLO.Bits.CCOB4
#define FTMRH_FCCOBLO_CCOB5       _FTMRH_FCCOBLO.Bits.CCOB5
#define FTMRH_FCCOBLO_CCOB6       _FTMRH_FCCOBLO.Bits.CCOB6
#define FTMRH_FCCOBLO_CCOB7       _FTMRH_FCCOBLO.Bits.CCOB7

#define FTMRH_FCCOBLO_CCOB0_MASK  1U
#define FTMRH_FCCOBLO_CCOB0_BITNUM 0
#define FTMRH_FCCOBLO_CCOB1_MASK  2U
#define FTMRH_FCCOBLO_CCOB1_BITNUM 1
#define FTMRH_FCCOBLO_CCOB2_MASK  4U
#define FTMRH_FCCOBLO_CCOB2_BITNUM 2
#define FTMRH_FCCOBLO_CCOB3_MASK  8U
#define FTMRH_FCCOBLO_CCOB3_BITNUM 3
#define FTMRH_FCCOBLO_CCOB4_MASK  16U
#define FTMRH_FCCOBLO_CCOB4_BITNUM 4
#define FTMRH_FCCOBLO_CCOB5_MASK  32U
#define FTMRH_FCCOBLO_CCOB5_BITNUM 5
#define FTMRH_FCCOBLO_CCOB6_MASK  64U
#define FTMRH_FCCOBLO_CCOB6_BITNUM 6
#define FTMRH_FCCOBLO_CCOB7_MASK  128U
#define FTMRH_FCCOBLO_CCOB7_BITNUM 7


/*** FTMRH_FOPT Flash Option Register; 0x0000302C ***/
typedef union {
  byte Byte;
  struct {
    byte  NV0        : 1;
    byte  NV1        : 1;
    byte  NV2        : 1;
    byte  NV3        : 1;
    byte  NV4        : 1;
    byte  NV5        : 1;
    byte  NV6        : 1;
    byte  NV7        : 1;
  } Bits;
} FTMRH_FOPTSTR;
extern volatile FTMRH_FOPTSTR _FTMRH_FOPT @0x0000302C;
#define FTMRH_FOPT                _FTMRH_FOPT.Byte
#define FTMRH_FOPT_NV0            _FTMRH_FOPT.Bits.NV0
#define FTMRH_FOPT_NV1            _FTMRH_FOPT.Bits.NV1
#define FTMRH_FOPT_NV2            _FTMRH_FOPT.Bits.NV2
#define FTMRH_FOPT_NV3            _FTMRH_FOPT.Bits.NV3
#define FTMRH_FOPT_NV4            _FTMRH_FOPT.Bits.NV4
#define FTMRH_FOPT_NV5            _FTMRH_FOPT.Bits.NV5
#define FTMRH_FOPT_NV6            _FTMRH_FOPT.Bits.NV6
#define FTMRH_FOPT_NV7            _FTMRH_FOPT.Bits.NV7

#define FTMRH_FOPT_NV0_MASK       1U
#define FTMRH_FOPT_NV0_BITNUM     0
#define FTMRH_FOPT_NV1_MASK       2U
#define FTMRH_FOPT_NV1_BITNUM     1
#define FTMRH_FOPT_NV2_MASK       4U
#define FTMRH_FOPT_NV2_BITNUM     2
#define FTMRH_FOPT_NV3_MASK       8U
#define FTMRH_FOPT_NV3_BITNUM     3
#define FTMRH_FOPT_NV4_MASK       16U
#define FTMRH_FOPT_NV4_BITNUM     4
#define FTMRH_FOPT_NV5_MASK       32U
#define FTMRH_FOPT_NV5_BITNUM     5
#define FTMRH_FOPT_NV6_MASK       64U
#define FTMRH_FOPT_NV6_BITNUM     6
#define FTMRH_FOPT_NV7_MASK       128U
#define FTMRH_FOPT_NV7_BITNUM     7


/*** PWT_CS Pulse Width Timer Control and Status Register; 0x00003030 ***/
typedef union {
  byte Byte;
  struct {
    byte  PWTOV      : 1;
    byte  PWTRDY     : 1;
    byte             : 1;
    byte  PWTSR      : 1;
    byte  POVIE      : 1;
    byte  PRDYIE     : 1;
    byte  PWTIE      : 1;
    byte  PWTEN      : 1;
  } Bits;
} PWT_CSSTR;
extern volatile PWT_CSSTR _PWT_CS @0x00003030;
#define PWT_CS                    _PWT_CS.Byte
#define PWT_CS_PWTOV              _PWT_CS.Bits.PWTOV
#define PWT_CS_PWTRDY             _PWT_CS.Bits.PWTRDY
#define PWT_CS_PWTSR              _PWT_CS.Bits.PWTSR
#define PWT_CS_POVIE              _PWT_CS.Bits.POVIE
#define PWT_CS_PRDYIE             _PWT_CS.Bits.PRDYIE
#define PWT_CS_PWTIE              _PWT_CS.Bits.PWTIE
#define PWT_CS_PWTEN              _PWT_CS.Bits.PWTEN

#define PWT_CS_PWTOV_MASK         1U
#define PWT_CS_PWTOV_BITNUM       0
#define PWT_CS_PWTRDY_MASK        2U
#define PWT_CS_PWTRDY_BITNUM      1
#define PWT_CS_PWTSR_MASK         8U
#define PWT_CS_PWTSR_BITNUM       3
#define PWT_CS_POVIE_MASK         16U
#define PWT_CS_POVIE_BITNUM       4
#define PWT_CS_PRDYIE_MASK        32U
#define PWT_CS_PRDYIE_BITNUM      5
#define PWT_CS_PWTIE_MASK         64U
#define PWT_CS_PWTIE_BITNUM       6
#define PWT_CS_PWTEN_MASK         128U
#define PWT_CS_PWTEN_BITNUM       7


/*** PWT_CR Pulse Width Timer Control Register; 0x00003031 ***/
typedef union {
  byte Byte;
  struct {
    byte  PRE0       : 1;
    byte  PRE1       : 1;
    byte  PRE2       : 1;
    byte  EDGE0      : 1;
    byte  EDGE1      : 1;
    byte  PINSEL0    : 1;
    byte  PINSEL1    : 1;
    byte  PCLKS      : 1;
  } Bits;
  struct {
    byte  grpPRE     : 3;
    byte  grpEDGE    : 2;
    byte  grpPINSEL  : 2;
    byte             : 1;
  } MergedBits;
} PWT_CRSTR;
extern volatile PWT_CRSTR _PWT_CR @0x00003031;
#define PWT_CR                    _PWT_CR.Byte
#define PWT_CR_PRE0               _PWT_CR.Bits.PRE0
#define PWT_CR_PRE1               _PWT_CR.Bits.PRE1
#define PWT_CR_PRE2               _PWT_CR.Bits.PRE2
#define PWT_CR_EDGE0              _PWT_CR.Bits.EDGE0
#define PWT_CR_EDGE1              _PWT_CR.Bits.EDGE1
#define PWT_CR_PINSEL0            _PWT_CR.Bits.PINSEL0
#define PWT_CR_PINSEL1            _PWT_CR.Bits.PINSEL1
#define PWT_CR_PCLKS              _PWT_CR.Bits.PCLKS
#define PWT_CR_PRE                _PWT_CR.MergedBits.grpPRE
#define PWT_CR_EDGE               _PWT_CR.MergedBits.grpEDGE
#define PWT_CR_PINSEL             _PWT_CR.MergedBits.grpPINSEL

#define PWT_CR_PRE0_MASK          1U
#define PWT_CR_PRE0_BITNUM        0
#define PWT_CR_PRE1_MASK          2U
#define PWT_CR_PRE1_BITNUM        1
#define PWT_CR_PRE2_MASK          4U
#define PWT_CR_PRE2_BITNUM        2
#define PWT_CR_EDGE0_MASK         8U
#define PWT_CR_EDGE0_BITNUM       3
#define PWT_CR_EDGE1_MASK         16U
#define PWT_CR_EDGE1_BITNUM       4
#define PWT_CR_PINSEL0_MASK       32U
#define PWT_CR_PINSEL0_BITNUM     5
#define PWT_CR_PINSEL1_MASK       64U
#define PWT_CR_PINSEL1_BITNUM     6
#define PWT_CR_PCLKS_MASK         128U
#define PWT_CR_PCLKS_BITNUM       7
#define PWT_CR_PRE_MASK           7U
#define PWT_CR_PRE_BITNUM         0
#define PWT_CR_EDGE_MASK          24U
#define PWT_CR_EDGE_BITNUM        3
#define PWT_CR_PINSEL_MASK        96U
#define PWT_CR_PINSEL_BITNUM      5


/*** PWT_PP Pulse Width Timer Positive Pulse Width Register:  0x00003032 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** PWT_PPH Pulse Width Timer Positive Pulse Width Register: High; 0x00003032 ***/
    union {
      byte Byte;
      struct {
        byte  PPWH0      : 1;
        byte  PPWH1      : 1;
        byte  PPWH2      : 1;
        byte  PPWH3      : 1;
        byte  PPWH4      : 1;
        byte  PPWH5      : 1;
        byte  PPWH6      : 1;
        byte  PPWH7      : 1;
      } Bits;
    } PWT_PPHSTR;
    #define PWT_PPH                   _PWT_PP.Overlap_STR.PWT_PPHSTR.Byte
    #define PWT_PPH_PPWH0             _PWT_PP.Overlap_STR.PWT_PPHSTR.Bits.PPWH0
    #define PWT_PPH_PPWH1             _PWT_PP.Overlap_STR.PWT_PPHSTR.Bits.PPWH1
    #define PWT_PPH_PPWH2             _PWT_PP.Overlap_STR.PWT_PPHSTR.Bits.PPWH2
    #define PWT_PPH_PPWH3             _PWT_PP.Overlap_STR.PWT_PPHSTR.Bits.PPWH3
    #define PWT_PPH_PPWH4             _PWT_PP.Overlap_STR.PWT_PPHSTR.Bits.PPWH4
    #define PWT_PPH_PPWH5             _PWT_PP.Overlap_STR.PWT_PPHSTR.Bits.PPWH5
    #define PWT_PPH_PPWH6             _PWT_PP.Overlap_STR.PWT_PPHSTR.Bits.PPWH6
    #define PWT_PPH_PPWH7             _PWT_PP.Overlap_STR.PWT_PPHSTR.Bits.PPWH7
    
    #define PWT_PPH_PPWH0_MASK        1U
    #define PWT_PPH_PPWH0_BITNUM      0
    #define PWT_PPH_PPWH1_MASK        2U
    #define PWT_PPH_PPWH1_BITNUM      1
    #define PWT_PPH_PPWH2_MASK        4U
    #define PWT_PPH_PPWH2_BITNUM      2
    #define PWT_PPH_PPWH3_MASK        8U
    #define PWT_PPH_PPWH3_BITNUM      3
    #define PWT_PPH_PPWH4_MASK        16U
    #define PWT_PPH_PPWH4_BITNUM      4
    #define PWT_PPH_PPWH5_MASK        32U
    #define PWT_PPH_PPWH5_BITNUM      5
    #define PWT_PPH_PPWH6_MASK        64U
    #define PWT_PPH_PPWH6_BITNUM      6
    #define PWT_PPH_PPWH7_MASK        128U
    #define PWT_PPH_PPWH7_BITNUM      7
    
    /*** PWT_PPL Pulse Width Timer Positive Pulse Width Register: Loq; 0x00003033 ***/
    union {
      byte Byte;
      struct {
        byte  PPWL0      : 1;
        byte  PPWL1      : 1;
        byte  PPWL2      : 1;
        byte  PPWL3      : 1;
        byte  PPWL4      : 1;
        byte  PPWL5      : 1;
        byte  PPWL6      : 1;
        byte  PPWL7      : 1;
      } Bits;
    } PWT_PPLSTR;
    #define PWT_PPL                   _PWT_PP.Overlap_STR.PWT_PPLSTR.Byte
    #define PWT_PPL_PPWL0             _PWT_PP.Overlap_STR.PWT_PPLSTR.Bits.PPWL0
    #define PWT_PPL_PPWL1             _PWT_PP.Overlap_STR.PWT_PPLSTR.Bits.PPWL1
    #define PWT_PPL_PPWL2             _PWT_PP.Overlap_STR.PWT_PPLSTR.Bits.PPWL2
    #define PWT_PPL_PPWL3             _PWT_PP.Overlap_STR.PWT_PPLSTR.Bits.PPWL3
    #define PWT_PPL_PPWL4             _PWT_PP.Overlap_STR.PWT_PPLSTR.Bits.PPWL4
    #define PWT_PPL_PPWL5             _PWT_PP.Overlap_STR.PWT_PPLSTR.Bits.PPWL5
    #define PWT_PPL_PPWL6             _PWT_PP.Overlap_STR.PWT_PPLSTR.Bits.PPWL6
    #define PWT_PPL_PPWL7             _PWT_PP.Overlap_STR.PWT_PPLSTR.Bits.PPWL7
    
    #define PWT_PPL_PPWL0_MASK        1U
    #define PWT_PPL_PPWL0_BITNUM      0
    #define PWT_PPL_PPWL1_MASK        2U
    #define PWT_PPL_PPWL1_BITNUM      1
    #define PWT_PPL_PPWL2_MASK        4U
    #define PWT_PPL_PPWL2_BITNUM      2
    #define PWT_PPL_PPWL3_MASK        8U
    #define PWT_PPL_PPWL3_BITNUM      3
    #define PWT_PPL_PPWL4_MASK        16U
    #define PWT_PPL_PPWL4_BITNUM      4
    #define PWT_PPL_PPWL5_MASK        32U
    #define PWT_PPL_PPWL5_BITNUM      5
    #define PWT_PPL_PPWL6_MASK        64U
    #define PWT_PPL_PPWL6_BITNUM      6
    #define PWT_PPL_PPWL7_MASK        128U
    #define PWT_PPL_PPWL7_BITNUM      7
    
  } Overlap_STR;
} PWT_PPSTR;
extern volatile PWT_PPSTR _PWT_PP @0x00003032;
#define PWT_PP                    _PWT_PP.Word


/*** PWT_NP Pulse Width Timer Negative Pulse Width Register:  0x00003034 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** PWT_NPH Pulse Width Timer Negative Pulse Width Register: High; 0x00003034 ***/
    union {
      byte Byte;
      struct {
        byte  NPWH0      : 1;
        byte  NPWH1      : 1;
        byte  NPWH2      : 1;
        byte  NPWH3      : 1;
        byte  NPWH4      : 1;
        byte  NPWH5      : 1;
        byte  NPWH6      : 1;
        byte  NPWH7      : 1;
      } Bits;
    } PWT_NPHSTR;
    #define PWT_NPH                   _PWT_NP.Overlap_STR.PWT_NPHSTR.Byte
    #define PWT_NPH_NPWH0             _PWT_NP.Overlap_STR.PWT_NPHSTR.Bits.NPWH0
    #define PWT_NPH_NPWH1             _PWT_NP.Overlap_STR.PWT_NPHSTR.Bits.NPWH1
    #define PWT_NPH_NPWH2             _PWT_NP.Overlap_STR.PWT_NPHSTR.Bits.NPWH2
    #define PWT_NPH_NPWH3             _PWT_NP.Overlap_STR.PWT_NPHSTR.Bits.NPWH3
    #define PWT_NPH_NPWH4             _PWT_NP.Overlap_STR.PWT_NPHSTR.Bits.NPWH4
    #define PWT_NPH_NPWH5             _PWT_NP.Overlap_STR.PWT_NPHSTR.Bits.NPWH5
    #define PWT_NPH_NPWH6             _PWT_NP.Overlap_STR.PWT_NPHSTR.Bits.NPWH6
    #define PWT_NPH_NPWH7             _PWT_NP.Overlap_STR.PWT_NPHSTR.Bits.NPWH7
    
    #define PWT_NPH_NPWH0_MASK        1U
    #define PWT_NPH_NPWH0_BITNUM      0
    #define PWT_NPH_NPWH1_MASK        2U
    #define PWT_NPH_NPWH1_BITNUM      1
    #define PWT_NPH_NPWH2_MASK        4U
    #define PWT_NPH_NPWH2_BITNUM      2
    #define PWT_NPH_NPWH3_MASK        8U
    #define PWT_NPH_NPWH3_BITNUM      3
    #define PWT_NPH_NPWH4_MASK        16U
    #define PWT_NPH_NPWH4_BITNUM      4
    #define PWT_NPH_NPWH5_MASK        32U
    #define PWT_NPH_NPWH5_BITNUM      5
    #define PWT_NPH_NPWH6_MASK        64U
    #define PWT_NPH_NPWH6_BITNUM      6
    #define PWT_NPH_NPWH7_MASK        128U
    #define PWT_NPH_NPWH7_BITNUM      7
    
    /*** PWT_NPL Pulse Width Timer Negative Pulse Width Register: Low; 0x00003035 ***/
    union {
      byte Byte;
      struct {
        byte  NPWL0      : 1;
        byte  NPWL1      : 1;
        byte  NPWL2      : 1;
        byte  NPWL3      : 1;
        byte  NPWL4      : 1;
        byte  NPWL5      : 1;
        byte  NPWL6      : 1;
        byte  NPWL7      : 1;
      } Bits;
    } PWT_NPLSTR;
    #define PWT_NPL                   _PWT_NP.Overlap_STR.PWT_NPLSTR.Byte
    #define PWT_NPL_NPWL0             _PWT_NP.Overlap_STR.PWT_NPLSTR.Bits.NPWL0
    #define PWT_NPL_NPWL1             _PWT_NP.Overlap_STR.PWT_NPLSTR.Bits.NPWL1
    #define PWT_NPL_NPWL2             _PWT_NP.Overlap_STR.PWT_NPLSTR.Bits.NPWL2
    #define PWT_NPL_NPWL3             _PWT_NP.Overlap_STR.PWT_NPLSTR.Bits.NPWL3
    #define PWT_NPL_NPWL4             _PWT_NP.Overlap_STR.PWT_NPLSTR.Bits.NPWL4
    #define PWT_NPL_NPWL5             _PWT_NP.Overlap_STR.PWT_NPLSTR.Bits.NPWL5
    #define PWT_NPL_NPWL6             _PWT_NP.Overlap_STR.PWT_NPLSTR.Bits.NPWL6
    #define PWT_NPL_NPWL7             _PWT_NP.Overlap_STR.PWT_NPLSTR.Bits.NPWL7
    
    #define PWT_NPL_NPWL0_MASK        1U
    #define PWT_NPL_NPWL0_BITNUM      0
    #define PWT_NPL_NPWL1_MASK        2U
    #define PWT_NPL_NPWL1_BITNUM      1
    #define PWT_NPL_NPWL2_MASK        4U
    #define PWT_NPL_NPWL2_BITNUM      2
    #define PWT_NPL_NPWL3_MASK        8U
    #define PWT_NPL_NPWL3_BITNUM      3
    #define PWT_NPL_NPWL4_MASK        16U
    #define PWT_NPL_NPWL4_BITNUM      4
    #define PWT_NPL_NPWL5_MASK        32U
    #define PWT_NPL_NPWL5_BITNUM      5
    #define PWT_NPL_NPWL6_MASK        64U
    #define PWT_NPL_NPWL6_BITNUM      6
    #define PWT_NPL_NPWL7_MASK        128U
    #define PWT_NPL_NPWL7_BITNUM      7
    
  } Overlap_STR;
} PWT_NPSTR;
extern volatile PWT_NPSTR _PWT_NP @0x00003034;
#define PWT_NP                    _PWT_NP.Word


/*** PWT_CNT Pulse Width Timer Counter Register:  0x00003036 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** PWT_CNTH Pulse Width Timer Counter Register: High; 0x00003036 ***/
    union {
      byte Byte;
      struct {
        byte  PWTH0      : 1;
        byte  PWTH1      : 1;
        byte  PWTH2      : 1;
        byte  PWTH3      : 1;
        byte  PWTH4      : 1;
        byte  PWTH5      : 1;
        byte  PWTH6      : 1;
        byte  PWTH7      : 1;
      } Bits;
    } PWT_CNTHSTR;
    #define PWT_CNTH                  _PWT_CNT.Overlap_STR.PWT_CNTHSTR.Byte
    #define PWT_CNTH_PWTH0            _PWT_CNT.Overlap_STR.PWT_CNTHSTR.Bits.PWTH0
    #define PWT_CNTH_PWTH1            _PWT_CNT.Overlap_STR.PWT_CNTHSTR.Bits.PWTH1
    #define PWT_CNTH_PWTH2            _PWT_CNT.Overlap_STR.PWT_CNTHSTR.Bits.PWTH2
    #define PWT_CNTH_PWTH3            _PWT_CNT.Overlap_STR.PWT_CNTHSTR.Bits.PWTH3
    #define PWT_CNTH_PWTH4            _PWT_CNT.Overlap_STR.PWT_CNTHSTR.Bits.PWTH4
    #define PWT_CNTH_PWTH5            _PWT_CNT.Overlap_STR.PWT_CNTHSTR.Bits.PWTH5
    #define PWT_CNTH_PWTH6            _PWT_CNT.Overlap_STR.PWT_CNTHSTR.Bits.PWTH6
    #define PWT_CNTH_PWTH7            _PWT_CNT.Overlap_STR.PWT_CNTHSTR.Bits.PWTH7
    
    #define PWT_CNTH_PWTH0_MASK       1U
    #define PWT_CNTH_PWTH0_BITNUM     0
    #define PWT_CNTH_PWTH1_MASK       2U
    #define PWT_CNTH_PWTH1_BITNUM     1
    #define PWT_CNTH_PWTH2_MASK       4U
    #define PWT_CNTH_PWTH2_BITNUM     2
    #define PWT_CNTH_PWTH3_MASK       8U
    #define PWT_CNTH_PWTH3_BITNUM     3
    #define PWT_CNTH_PWTH4_MASK       16U
    #define PWT_CNTH_PWTH4_BITNUM     4
    #define PWT_CNTH_PWTH5_MASK       32U
    #define PWT_CNTH_PWTH5_BITNUM     5
    #define PWT_CNTH_PWTH6_MASK       64U
    #define PWT_CNTH_PWTH6_BITNUM     6
    #define PWT_CNTH_PWTH7_MASK       128U
    #define PWT_CNTH_PWTH7_BITNUM     7
    
    /*** PWT_CNTL Pulse Width Timer Counter Register: Low; 0x00003037 ***/
    union {
      byte Byte;
      struct {
        byte  PWTL0      : 1;
        byte  PWTL1      : 1;
        byte  PWTL2      : 1;
        byte  PWTL3      : 1;
        byte  PWTL4      : 1;
        byte  PWTL5      : 1;
        byte  PWTL6      : 1;
        byte  PWTL7      : 1;
      } Bits;
    } PWT_CNTLSTR;
    #define PWT_CNTL                  _PWT_CNT.Overlap_STR.PWT_CNTLSTR.Byte
    #define PWT_CNTL_PWTL0            _PWT_CNT.Overlap_STR.PWT_CNTLSTR.Bits.PWTL0
    #define PWT_CNTL_PWTL1            _PWT_CNT.Overlap_STR.PWT_CNTLSTR.Bits.PWTL1
    #define PWT_CNTL_PWTL2            _PWT_CNT.Overlap_STR.PWT_CNTLSTR.Bits.PWTL2
    #define PWT_CNTL_PWTL3            _PWT_CNT.Overlap_STR.PWT_CNTLSTR.Bits.PWTL3
    #define PWT_CNTL_PWTL4            _PWT_CNT.Overlap_STR.PWT_CNTLSTR.Bits.PWTL4
    #define PWT_CNTL_PWTL5            _PWT_CNT.Overlap_STR.PWT_CNTLSTR.Bits.PWTL5
    #define PWT_CNTL_PWTL6            _PWT_CNT.Overlap_STR.PWT_CNTLSTR.Bits.PWTL6
    #define PWT_CNTL_PWTL7            _PWT_CNT.Overlap_STR.PWT_CNTLSTR.Bits.PWTL7
    
    #define PWT_CNTL_PWTL0_MASK       1U
    #define PWT_CNTL_PWTL0_BITNUM     0
    #define PWT_CNTL_PWTL1_MASK       2U
    #define PWT_CNTL_PWTL1_BITNUM     1
    #define PWT_CNTL_PWTL2_MASK       4U
    #define PWT_CNTL_PWTL2_BITNUM     2
    #define PWT_CNTL_PWTL3_MASK       8U
    #define PWT_CNTL_PWTL3_BITNUM     3
    #define PWT_CNTL_PWTL4_MASK       16U
    #define PWT_CNTL_PWTL4_BITNUM     4
    #define PWT_CNTL_PWTL5_MASK       32U
    #define PWT_CNTL_PWTL5_BITNUM     5
    #define PWT_CNTL_PWTL6_MASK       64U
    #define PWT_CNTL_PWTL6_BITNUM     6
    #define PWT_CNTL_PWTL7_MASK       128U
    #define PWT_CNTL_PWTL7_BITNUM     7
    
  } Overlap_STR;
} PWT_CNTSTR;
extern volatile PWT_CNTSTR _PWT_CNT @0x00003036;
#define PWT_CNT                   _PWT_CNT.Word


/*** ICS_C1 ICS Control Register 1; 0x00003038 ***/
typedef union {
  byte Byte;
  struct {
    byte  IREFSTEN   : 1;
    byte  IRCLKEN    : 1;
    byte  IREFS      : 1;
    byte  RDIV0      : 1;
    byte  RDIV1      : 1;
    byte  RDIV2      : 1;
    byte  CLKS0      : 1;
    byte  CLKS1      : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  grpRDIV    : 3;
    byte  grpCLKS    : 2;
  } MergedBits;
} ICS_C1STR;
extern volatile ICS_C1STR _ICS_C1 @0x00003038;
#define ICS_C1                    _ICS_C1.Byte
#define ICS_C1_IREFSTEN           _ICS_C1.Bits.IREFSTEN
#define ICS_C1_IRCLKEN            _ICS_C1.Bits.IRCLKEN
#define ICS_C1_IREFS              _ICS_C1.Bits.IREFS
#define ICS_C1_RDIV0              _ICS_C1.Bits.RDIV0
#define ICS_C1_RDIV1              _ICS_C1.Bits.RDIV1
#define ICS_C1_RDIV2              _ICS_C1.Bits.RDIV2
#define ICS_C1_CLKS0              _ICS_C1.Bits.CLKS0
#define ICS_C1_CLKS1              _ICS_C1.Bits.CLKS1
#define ICS_C1_RDIV               _ICS_C1.MergedBits.grpRDIV
#define ICS_C1_CLKS               _ICS_C1.MergedBits.grpCLKS

#define ICS_C1_IREFSTEN_MASK      1U
#define ICS_C1_IREFSTEN_BITNUM    0
#define ICS_C1_IRCLKEN_MASK       2U
#define ICS_C1_IRCLKEN_BITNUM     1
#define ICS_C1_IREFS_MASK         4U
#define ICS_C1_IREFS_BITNUM       2
#define ICS_C1_RDIV0_MASK         8U
#define ICS_C1_RDIV0_BITNUM       3
#define ICS_C1_RDIV1_MASK         16U
#define ICS_C1_RDIV1_BITNUM       4
#define ICS_C1_RDIV2_MASK         32U
#define ICS_C1_RDIV2_BITNUM       5
#define ICS_C1_CLKS0_MASK         64U
#define ICS_C1_CLKS0_BITNUM       6
#define ICS_C1_CLKS1_MASK         128U
#define ICS_C1_CLKS1_BITNUM       7
#define ICS_C1_RDIV_MASK          56U
#define ICS_C1_RDIV_BITNUM        3
#define ICS_C1_CLKS_MASK          192U
#define ICS_C1_CLKS_BITNUM        6


/*** ICS_C2 ICS Control Register 2; 0x00003039 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  LP         : 1;
    byte  BDIV0      : 1;
    byte  BDIV1      : 1;
    byte  BDIV2      : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  grpBDIV    : 3;
  } MergedBits;
} ICS_C2STR;
extern volatile ICS_C2STR _ICS_C2 @0x00003039;
#define ICS_C2                    _ICS_C2.Byte
#define ICS_C2_LP                 _ICS_C2.Bits.LP
#define ICS_C2_BDIV0              _ICS_C2.Bits.BDIV0
#define ICS_C2_BDIV1              _ICS_C2.Bits.BDIV1
#define ICS_C2_BDIV2              _ICS_C2.Bits.BDIV2
#define ICS_C2_BDIV               _ICS_C2.MergedBits.grpBDIV

#define ICS_C2_LP_MASK            16U
#define ICS_C2_LP_BITNUM          4
#define ICS_C2_BDIV0_MASK         32U
#define ICS_C2_BDIV0_BITNUM       5
#define ICS_C2_BDIV1_MASK         64U
#define ICS_C2_BDIV1_BITNUM       6
#define ICS_C2_BDIV2_MASK         128U
#define ICS_C2_BDIV2_BITNUM       7
#define ICS_C2_BDIV_MASK          224U
#define ICS_C2_BDIV_BITNUM        5


/*** ICS_C3 ICS Control Register 3; 0x0000303A ***/
typedef union {
  byte Byte;
  struct {
    byte  SCTRIM0    : 1;
    byte  SCTRIM1    : 1;
    byte  SCTRIM2    : 1;
    byte  SCTRIM3    : 1;
    byte  SCTRIM4    : 1;
    byte  SCTRIM5    : 1;
    byte  SCTRIM6    : 1;
    byte  SCTRIM7    : 1;
  } Bits;
} ICS_C3STR;
extern volatile ICS_C3STR _ICS_C3 @0x0000303A;
#define ICS_C3                    _ICS_C3.Byte
#define ICS_C3_SCTRIM0            _ICS_C3.Bits.SCTRIM0
#define ICS_C3_SCTRIM1            _ICS_C3.Bits.SCTRIM1
#define ICS_C3_SCTRIM2            _ICS_C3.Bits.SCTRIM2
#define ICS_C3_SCTRIM3            _ICS_C3.Bits.SCTRIM3
#define ICS_C3_SCTRIM4            _ICS_C3.Bits.SCTRIM4
#define ICS_C3_SCTRIM5            _ICS_C3.Bits.SCTRIM5
#define ICS_C3_SCTRIM6            _ICS_C3.Bits.SCTRIM6
#define ICS_C3_SCTRIM7            _ICS_C3.Bits.SCTRIM7

#define ICS_C3_SCTRIM0_MASK       1U
#define ICS_C3_SCTRIM0_BITNUM     0
#define ICS_C3_SCTRIM1_MASK       2U
#define ICS_C3_SCTRIM1_BITNUM     1
#define ICS_C3_SCTRIM2_MASK       4U
#define ICS_C3_SCTRIM2_BITNUM     2
#define ICS_C3_SCTRIM3_MASK       8U
#define ICS_C3_SCTRIM3_BITNUM     3
#define ICS_C3_SCTRIM4_MASK       16U
#define ICS_C3_SCTRIM4_BITNUM     4
#define ICS_C3_SCTRIM5_MASK       32U
#define ICS_C3_SCTRIM5_BITNUM     5
#define ICS_C3_SCTRIM6_MASK       64U
#define ICS_C3_SCTRIM6_BITNUM     6
#define ICS_C3_SCTRIM7_MASK       128U
#define ICS_C3_SCTRIM7_BITNUM     7


/*** ICS_C4 ICS Control Register 4; 0x0000303B ***/
typedef union {
  byte Byte;
  struct {
    byte  SCFTRIM    : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  CME        : 1;
    byte             : 1;
    byte  LOLIE      : 1;
  } Bits;
} ICS_C4STR;
extern volatile ICS_C4STR _ICS_C4 @0x0000303B;
#define ICS_C4                    _ICS_C4.Byte
#define ICS_C4_SCFTRIM            _ICS_C4.Bits.SCFTRIM
#define ICS_C4_CME                _ICS_C4.Bits.CME
#define ICS_C4_LOLIE              _ICS_C4.Bits.LOLIE

#define ICS_C4_SCFTRIM_MASK       1U
#define ICS_C4_SCFTRIM_BITNUM     0
#define ICS_C4_CME_MASK           32U
#define ICS_C4_CME_BITNUM         5
#define ICS_C4_LOLIE_MASK         128U
#define ICS_C4_LOLIE_BITNUM       7


/*** ICS_S ICS Status Register; 0x0000303C ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  CLKST0     : 1;
    byte  CLKST1     : 1;
    byte  IREFST     : 1;
    byte             : 1;
    byte  LOCK       : 1;
    byte  LOLS       : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte  grpCLKST   : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ICS_SSTR;
extern volatile ICS_SSTR _ICS_S @0x0000303C;
#define ICS_S                     _ICS_S.Byte
#define ICS_S_CLKST0              _ICS_S.Bits.CLKST0
#define ICS_S_CLKST1              _ICS_S.Bits.CLKST1
#define ICS_S_IREFST              _ICS_S.Bits.IREFST
#define ICS_S_LOCK                _ICS_S.Bits.LOCK
#define ICS_S_LOLS                _ICS_S.Bits.LOLS
#define ICS_S_CLKST               _ICS_S.MergedBits.grpCLKST

#define ICS_S_CLKST0_MASK         4U
#define ICS_S_CLKST0_BITNUM       2
#define ICS_S_CLKST1_MASK         8U
#define ICS_S_CLKST1_BITNUM       3
#define ICS_S_IREFST_MASK         16U
#define ICS_S_IREFST_BITNUM       4
#define ICS_S_LOCK_MASK           64U
#define ICS_S_LOCK_BITNUM         6
#define ICS_S_LOLS_MASK           128U
#define ICS_S_LOLS_BITNUM         7
#define ICS_S_CLKST_MASK          12U
#define ICS_S_CLKST_BITNUM        2


/*** OSC_CR OSC Control Register; 0x0000303E ***/
typedef union {
  byte Byte;
  struct {
    byte  OSCINIT    : 1;
    byte  HGO        : 1;
    byte  RANGE      : 1;
    byte             : 1;
    byte  OSCOS      : 1;
    byte  OSCSTEN    : 1;
    byte             : 1;
    byte  OSCEN      : 1;
  } Bits;
} OSC_CRSTR;
extern volatile OSC_CRSTR _OSC_CR @0x0000303E;
#define OSC_CR                    _OSC_CR.Byte
#define OSC_CR_OSCINIT            _OSC_CR.Bits.OSCINIT
#define OSC_CR_HGO                _OSC_CR.Bits.HGO
#define OSC_CR_RANGE              _OSC_CR.Bits.RANGE
#define OSC_CR_OSCOS              _OSC_CR.Bits.OSCOS
#define OSC_CR_OSCSTEN            _OSC_CR.Bits.OSCSTEN
#define OSC_CR_OSCEN              _OSC_CR.Bits.OSCEN

#define OSC_CR_OSCINIT_MASK       1U
#define OSC_CR_OSCINIT_BITNUM     0
#define OSC_CR_HGO_MASK           2U
#define OSC_CR_HGO_BITNUM         1
#define OSC_CR_RANGE_MASK         4U
#define OSC_CR_RANGE_BITNUM       2
#define OSC_CR_OSCOS_MASK         16U
#define OSC_CR_OSCOS_BITNUM       4
#define OSC_CR_OSCSTEN_MASK       32U
#define OSC_CR_OSCSTEN_BITNUM     5
#define OSC_CR_OSCEN_MASK         128U
#define OSC_CR_OSCEN_BITNUM       7


/*** PMC_SPMSC1 System Power Management Status and Control 1 Register; 0x00003040 ***/
typedef union {
  byte Byte;
  struct {
    byte  BGBE       : 1;
    byte  BGBDS      : 1;
    byte  LVDE       : 1;
    byte  LVDSE      : 1;
    byte  LVDRE      : 1;
    byte  LVWIE      : 1;
    byte  LVWACK     : 1;
    byte  LVWF       : 1;
  } Bits;
} PMC_SPMSC1STR;
extern volatile PMC_SPMSC1STR _PMC_SPMSC1 @0x00003040;
#define PMC_SPMSC1                _PMC_SPMSC1.Byte
#define PMC_SPMSC1_BGBE           _PMC_SPMSC1.Bits.BGBE
#define PMC_SPMSC1_BGBDS          _PMC_SPMSC1.Bits.BGBDS
#define PMC_SPMSC1_LVDE           _PMC_SPMSC1.Bits.LVDE
#define PMC_SPMSC1_LVDSE          _PMC_SPMSC1.Bits.LVDSE
#define PMC_SPMSC1_LVDRE          _PMC_SPMSC1.Bits.LVDRE
#define PMC_SPMSC1_LVWIE          _PMC_SPMSC1.Bits.LVWIE
#define PMC_SPMSC1_LVWACK         _PMC_SPMSC1.Bits.LVWACK
#define PMC_SPMSC1_LVWF           _PMC_SPMSC1.Bits.LVWF

#define PMC_SPMSC1_BGBE_MASK      1U
#define PMC_SPMSC1_BGBE_BITNUM    0
#define PMC_SPMSC1_BGBDS_MASK     2U
#define PMC_SPMSC1_BGBDS_BITNUM   1
#define PMC_SPMSC1_LVDE_MASK      4U
#define PMC_SPMSC1_LVDE_BITNUM    2
#define PMC_SPMSC1_LVDSE_MASK     8U
#define PMC_SPMSC1_LVDSE_BITNUM   3
#define PMC_SPMSC1_LVDRE_MASK     16U
#define PMC_SPMSC1_LVDRE_BITNUM   4
#define PMC_SPMSC1_LVWIE_MASK     32U
#define PMC_SPMSC1_LVWIE_BITNUM   5
#define PMC_SPMSC1_LVWACK_MASK    64U
#define PMC_SPMSC1_LVWACK_BITNUM  6
#define PMC_SPMSC1_LVWF_MASK      128U
#define PMC_SPMSC1_LVWF_BITNUM    7


/*** PMC_SPMSC2 System Power Management Status and Control 2 Register; 0x00003041 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  LVWV0      : 1;
    byte  LVWV1      : 1;
    byte  LVDV       : 1;
    byte             : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  grpLVWV    : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PMC_SPMSC2STR;
extern volatile PMC_SPMSC2STR _PMC_SPMSC2 @0x00003041;
#define PMC_SPMSC2                _PMC_SPMSC2.Byte
#define PMC_SPMSC2_LVWV0          _PMC_SPMSC2.Bits.LVWV0
#define PMC_SPMSC2_LVWV1          _PMC_SPMSC2.Bits.LVWV1
#define PMC_SPMSC2_LVDV           _PMC_SPMSC2.Bits.LVDV
#define PMC_SPMSC2_LVWV           _PMC_SPMSC2.MergedBits.grpLVWV

#define PMC_SPMSC2_LVWV0_MASK     16U
#define PMC_SPMSC2_LVWV0_BITNUM   4
#define PMC_SPMSC2_LVWV1_MASK     32U
#define PMC_SPMSC2_LVWV1_BITNUM   5
#define PMC_SPMSC2_LVDV_MASK      64U
#define PMC_SPMSC2_LVDV_BITNUM    6
#define PMC_SPMSC2_LVWV_MASK      48U
#define PMC_SPMSC2_LVWV_BITNUM    4


/*** SYS_ILLA Illegal Address Register:  0x0000304A ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** SYS_ILLAH Illegal Address Register: High; 0x0000304A ***/
    union {
      byte Byte;
      struct {
        byte  ADDR0      : 1;
        byte  ADDR1      : 1;
        byte  ADDR2      : 1;
        byte  ADDR3      : 1;
        byte  ADDR4      : 1;
        byte  ADDR5      : 1;
        byte  ADDR6      : 1;
        byte  ADDR7      : 1;
      } Bits;
    } SYS_ILLAHSTR;
    #define SYS_ILLAH                 _SYS_ILLA.Overlap_STR.SYS_ILLAHSTR.Byte
    #define SYS_ILLAH_ADDR0           _SYS_ILLA.Overlap_STR.SYS_ILLAHSTR.Bits.ADDR0
    #define SYS_ILLAH_ADDR1           _SYS_ILLA.Overlap_STR.SYS_ILLAHSTR.Bits.ADDR1
    #define SYS_ILLAH_ADDR2           _SYS_ILLA.Overlap_STR.SYS_ILLAHSTR.Bits.ADDR2
    #define SYS_ILLAH_ADDR3           _SYS_ILLA.Overlap_STR.SYS_ILLAHSTR.Bits.ADDR3
    #define SYS_ILLAH_ADDR4           _SYS_ILLA.Overlap_STR.SYS_ILLAHSTR.Bits.ADDR4
    #define SYS_ILLAH_ADDR5           _SYS_ILLA.Overlap_STR.SYS_ILLAHSTR.Bits.ADDR5
    #define SYS_ILLAH_ADDR6           _SYS_ILLA.Overlap_STR.SYS_ILLAHSTR.Bits.ADDR6
    #define SYS_ILLAH_ADDR7           _SYS_ILLA.Overlap_STR.SYS_ILLAHSTR.Bits.ADDR7
    
    #define SYS_ILLAH_ADDR0_MASK      1U
    #define SYS_ILLAH_ADDR0_BITNUM    0
    #define SYS_ILLAH_ADDR1_MASK      2U
    #define SYS_ILLAH_ADDR1_BITNUM    1
    #define SYS_ILLAH_ADDR2_MASK      4U
    #define SYS_ILLAH_ADDR2_BITNUM    2
    #define SYS_ILLAH_ADDR3_MASK      8U
    #define SYS_ILLAH_ADDR3_BITNUM    3
    #define SYS_ILLAH_ADDR4_MASK      16U
    #define SYS_ILLAH_ADDR4_BITNUM    4
    #define SYS_ILLAH_ADDR5_MASK      32U
    #define SYS_ILLAH_ADDR5_BITNUM    5
    #define SYS_ILLAH_ADDR6_MASK      64U
    #define SYS_ILLAH_ADDR6_BITNUM    6
    #define SYS_ILLAH_ADDR7_MASK      128U
    #define SYS_ILLAH_ADDR7_BITNUM    7
    
    /*** SYS_ILLAL Illegal Address Register: Low; 0x0000304B ***/
    union {
      byte Byte;
      struct {
        byte  ADDR0      : 1;
        byte  ADDR1      : 1;
        byte  ADDR2      : 1;
        byte  ADDR3      : 1;
        byte  ADDR4      : 1;
        byte  ADDR5      : 1;
        byte  ADDR6      : 1;
        byte  ADDR7      : 1;
      } Bits;
    } SYS_ILLALSTR;
    #define SYS_ILLAL                 _SYS_ILLA.Overlap_STR.SYS_ILLALSTR.Byte
    #define SYS_ILLAL_ADDR0           _SYS_ILLA.Overlap_STR.SYS_ILLALSTR.Bits.ADDR0
    #define SYS_ILLAL_ADDR1           _SYS_ILLA.Overlap_STR.SYS_ILLALSTR.Bits.ADDR1
    #define SYS_ILLAL_ADDR2           _SYS_ILLA.Overlap_STR.SYS_ILLALSTR.Bits.ADDR2
    #define SYS_ILLAL_ADDR3           _SYS_ILLA.Overlap_STR.SYS_ILLALSTR.Bits.ADDR3
    #define SYS_ILLAL_ADDR4           _SYS_ILLA.Overlap_STR.SYS_ILLALSTR.Bits.ADDR4
    #define SYS_ILLAL_ADDR5           _SYS_ILLA.Overlap_STR.SYS_ILLALSTR.Bits.ADDR5
    #define SYS_ILLAL_ADDR6           _SYS_ILLA.Overlap_STR.SYS_ILLALSTR.Bits.ADDR6
    #define SYS_ILLAL_ADDR7           _SYS_ILLA.Overlap_STR.SYS_ILLALSTR.Bits.ADDR7
    
    #define SYS_ILLAL_ADDR0_MASK      1U
    #define SYS_ILLAL_ADDR0_BITNUM    0
    #define SYS_ILLAL_ADDR1_MASK      2U
    #define SYS_ILLAL_ADDR1_BITNUM    1
    #define SYS_ILLAL_ADDR2_MASK      4U
    #define SYS_ILLAL_ADDR2_BITNUM    2
    #define SYS_ILLAL_ADDR3_MASK      8U
    #define SYS_ILLAL_ADDR3_BITNUM    3
    #define SYS_ILLAL_ADDR4_MASK      16U
    #define SYS_ILLAL_ADDR4_BITNUM    4
    #define SYS_ILLAL_ADDR5_MASK      32U
    #define SYS_ILLAL_ADDR5_BITNUM    5
    #define SYS_ILLAL_ADDR6_MASK      64U
    #define SYS_ILLAL_ADDR6_BITNUM    6
    #define SYS_ILLAL_ADDR7_MASK      128U
    #define SYS_ILLAL_ADDR7_BITNUM    7
    
  } Overlap_STR;
} SYS_ILLASTR;
extern volatile SYS_ILLASTR _SYS_ILLA @0x0000304A;
#define SYS_ILLA                  _SYS_ILLA.Word


/*** IPC_ILRS0 Interrupt Level Setting Registers n; 0x00003050 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS0STR;
extern volatile IPC_ILRS0STR _IPC_ILRS0 @0x00003050;
#define IPC_ILRS0                 _IPC_ILRS0.Byte
#define IPC_ILRS0_ILRn00          _IPC_ILRS0.Bits.ILRn00
#define IPC_ILRS0_ILRn01          _IPC_ILRS0.Bits.ILRn01
#define IPC_ILRS0_ILRn10          _IPC_ILRS0.Bits.ILRn10
#define IPC_ILRS0_ILRn11          _IPC_ILRS0.Bits.ILRn11
#define IPC_ILRS0_ILRn20          _IPC_ILRS0.Bits.ILRn20
#define IPC_ILRS0_ILRn21          _IPC_ILRS0.Bits.ILRn21
#define IPC_ILRS0_ILRn30          _IPC_ILRS0.Bits.ILRn30
#define IPC_ILRS0_ILRn31          _IPC_ILRS0.Bits.ILRn31
#define IPC_ILRS0_ILRn0           _IPC_ILRS0.MergedBits.grpILRn0
#define IPC_ILRS0_ILRn1           _IPC_ILRS0.MergedBits.grpILRn1
#define IPC_ILRS0_ILRn2           _IPC_ILRS0.MergedBits.grpILRn2
#define IPC_ILRS0_ILRn3           _IPC_ILRS0.MergedBits.grpILRn3

#define IPC_ILRS0_ILRn00_MASK     1U
#define IPC_ILRS0_ILRn00_BITNUM   0
#define IPC_ILRS0_ILRn01_MASK     2U
#define IPC_ILRS0_ILRn01_BITNUM   1
#define IPC_ILRS0_ILRn10_MASK     4U
#define IPC_ILRS0_ILRn10_BITNUM   2
#define IPC_ILRS0_ILRn11_MASK     8U
#define IPC_ILRS0_ILRn11_BITNUM   3
#define IPC_ILRS0_ILRn20_MASK     16U
#define IPC_ILRS0_ILRn20_BITNUM   4
#define IPC_ILRS0_ILRn21_MASK     32U
#define IPC_ILRS0_ILRn21_BITNUM   5
#define IPC_ILRS0_ILRn30_MASK     64U
#define IPC_ILRS0_ILRn30_BITNUM   6
#define IPC_ILRS0_ILRn31_MASK     128U
#define IPC_ILRS0_ILRn31_BITNUM   7
#define IPC_ILRS0_ILRn0_MASK      3U
#define IPC_ILRS0_ILRn0_BITNUM    0
#define IPC_ILRS0_ILRn1_MASK      12U
#define IPC_ILRS0_ILRn1_BITNUM    2
#define IPC_ILRS0_ILRn2_MASK      48U
#define IPC_ILRS0_ILRn2_BITNUM    4
#define IPC_ILRS0_ILRn3_MASK      192U
#define IPC_ILRS0_ILRn3_BITNUM    6


/*** IPC_ILRS1 Interrupt Level Setting Registers n; 0x00003051 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS1STR;
extern volatile IPC_ILRS1STR _IPC_ILRS1 @0x00003051;
#define IPC_ILRS1                 _IPC_ILRS1.Byte
#define IPC_ILRS1_ILRn00          _IPC_ILRS1.Bits.ILRn00
#define IPC_ILRS1_ILRn01          _IPC_ILRS1.Bits.ILRn01
#define IPC_ILRS1_ILRn10          _IPC_ILRS1.Bits.ILRn10
#define IPC_ILRS1_ILRn11          _IPC_ILRS1.Bits.ILRn11
#define IPC_ILRS1_ILRn20          _IPC_ILRS1.Bits.ILRn20
#define IPC_ILRS1_ILRn21          _IPC_ILRS1.Bits.ILRn21
#define IPC_ILRS1_ILRn30          _IPC_ILRS1.Bits.ILRn30
#define IPC_ILRS1_ILRn31          _IPC_ILRS1.Bits.ILRn31
#define IPC_ILRS1_ILRn0           _IPC_ILRS1.MergedBits.grpILRn0
#define IPC_ILRS1_ILRn1           _IPC_ILRS1.MergedBits.grpILRn1
#define IPC_ILRS1_ILRn2           _IPC_ILRS1.MergedBits.grpILRn2
#define IPC_ILRS1_ILRn3           _IPC_ILRS1.MergedBits.grpILRn3

#define IPC_ILRS1_ILRn00_MASK     1U
#define IPC_ILRS1_ILRn00_BITNUM   0
#define IPC_ILRS1_ILRn01_MASK     2U
#define IPC_ILRS1_ILRn01_BITNUM   1
#define IPC_ILRS1_ILRn10_MASK     4U
#define IPC_ILRS1_ILRn10_BITNUM   2
#define IPC_ILRS1_ILRn11_MASK     8U
#define IPC_ILRS1_ILRn11_BITNUM   3
#define IPC_ILRS1_ILRn20_MASK     16U
#define IPC_ILRS1_ILRn20_BITNUM   4
#define IPC_ILRS1_ILRn21_MASK     32U
#define IPC_ILRS1_ILRn21_BITNUM   5
#define IPC_ILRS1_ILRn30_MASK     64U
#define IPC_ILRS1_ILRn30_BITNUM   6
#define IPC_ILRS1_ILRn31_MASK     128U
#define IPC_ILRS1_ILRn31_BITNUM   7
#define IPC_ILRS1_ILRn0_MASK      3U
#define IPC_ILRS1_ILRn0_BITNUM    0
#define IPC_ILRS1_ILRn1_MASK      12U
#define IPC_ILRS1_ILRn1_BITNUM    2
#define IPC_ILRS1_ILRn2_MASK      48U
#define IPC_ILRS1_ILRn2_BITNUM    4
#define IPC_ILRS1_ILRn3_MASK      192U
#define IPC_ILRS1_ILRn3_BITNUM    6


/*** IPC_ILRS2 Interrupt Level Setting Registers n; 0x00003052 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS2STR;
extern volatile IPC_ILRS2STR _IPC_ILRS2 @0x00003052;
#define IPC_ILRS2                 _IPC_ILRS2.Byte
#define IPC_ILRS2_ILRn00          _IPC_ILRS2.Bits.ILRn00
#define IPC_ILRS2_ILRn01          _IPC_ILRS2.Bits.ILRn01
#define IPC_ILRS2_ILRn10          _IPC_ILRS2.Bits.ILRn10
#define IPC_ILRS2_ILRn11          _IPC_ILRS2.Bits.ILRn11
#define IPC_ILRS2_ILRn20          _IPC_ILRS2.Bits.ILRn20
#define IPC_ILRS2_ILRn21          _IPC_ILRS2.Bits.ILRn21
#define IPC_ILRS2_ILRn30          _IPC_ILRS2.Bits.ILRn30
#define IPC_ILRS2_ILRn31          _IPC_ILRS2.Bits.ILRn31
#define IPC_ILRS2_ILRn0           _IPC_ILRS2.MergedBits.grpILRn0
#define IPC_ILRS2_ILRn1           _IPC_ILRS2.MergedBits.grpILRn1
#define IPC_ILRS2_ILRn2           _IPC_ILRS2.MergedBits.grpILRn2
#define IPC_ILRS2_ILRn3           _IPC_ILRS2.MergedBits.grpILRn3

#define IPC_ILRS2_ILRn00_MASK     1U
#define IPC_ILRS2_ILRn00_BITNUM   0
#define IPC_ILRS2_ILRn01_MASK     2U
#define IPC_ILRS2_ILRn01_BITNUM   1
#define IPC_ILRS2_ILRn10_MASK     4U
#define IPC_ILRS2_ILRn10_BITNUM   2
#define IPC_ILRS2_ILRn11_MASK     8U
#define IPC_ILRS2_ILRn11_BITNUM   3
#define IPC_ILRS2_ILRn20_MASK     16U
#define IPC_ILRS2_ILRn20_BITNUM   4
#define IPC_ILRS2_ILRn21_MASK     32U
#define IPC_ILRS2_ILRn21_BITNUM   5
#define IPC_ILRS2_ILRn30_MASK     64U
#define IPC_ILRS2_ILRn30_BITNUM   6
#define IPC_ILRS2_ILRn31_MASK     128U
#define IPC_ILRS2_ILRn31_BITNUM   7
#define IPC_ILRS2_ILRn0_MASK      3U
#define IPC_ILRS2_ILRn0_BITNUM    0
#define IPC_ILRS2_ILRn1_MASK      12U
#define IPC_ILRS2_ILRn1_BITNUM    2
#define IPC_ILRS2_ILRn2_MASK      48U
#define IPC_ILRS2_ILRn2_BITNUM    4
#define IPC_ILRS2_ILRn3_MASK      192U
#define IPC_ILRS2_ILRn3_BITNUM    6


/*** IPC_ILRS3 Interrupt Level Setting Registers n; 0x00003053 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS3STR;
extern volatile IPC_ILRS3STR _IPC_ILRS3 @0x00003053;
#define IPC_ILRS3                 _IPC_ILRS3.Byte
#define IPC_ILRS3_ILRn00          _IPC_ILRS3.Bits.ILRn00
#define IPC_ILRS3_ILRn01          _IPC_ILRS3.Bits.ILRn01
#define IPC_ILRS3_ILRn10          _IPC_ILRS3.Bits.ILRn10
#define IPC_ILRS3_ILRn11          _IPC_ILRS3.Bits.ILRn11
#define IPC_ILRS3_ILRn20          _IPC_ILRS3.Bits.ILRn20
#define IPC_ILRS3_ILRn21          _IPC_ILRS3.Bits.ILRn21
#define IPC_ILRS3_ILRn30          _IPC_ILRS3.Bits.ILRn30
#define IPC_ILRS3_ILRn31          _IPC_ILRS3.Bits.ILRn31
#define IPC_ILRS3_ILRn0           _IPC_ILRS3.MergedBits.grpILRn0
#define IPC_ILRS3_ILRn1           _IPC_ILRS3.MergedBits.grpILRn1
#define IPC_ILRS3_ILRn2           _IPC_ILRS3.MergedBits.grpILRn2
#define IPC_ILRS3_ILRn3           _IPC_ILRS3.MergedBits.grpILRn3

#define IPC_ILRS3_ILRn00_MASK     1U
#define IPC_ILRS3_ILRn00_BITNUM   0
#define IPC_ILRS3_ILRn01_MASK     2U
#define IPC_ILRS3_ILRn01_BITNUM   1
#define IPC_ILRS3_ILRn10_MASK     4U
#define IPC_ILRS3_ILRn10_BITNUM   2
#define IPC_ILRS3_ILRn11_MASK     8U
#define IPC_ILRS3_ILRn11_BITNUM   3
#define IPC_ILRS3_ILRn20_MASK     16U
#define IPC_ILRS3_ILRn20_BITNUM   4
#define IPC_ILRS3_ILRn21_MASK     32U
#define IPC_ILRS3_ILRn21_BITNUM   5
#define IPC_ILRS3_ILRn30_MASK     64U
#define IPC_ILRS3_ILRn30_BITNUM   6
#define IPC_ILRS3_ILRn31_MASK     128U
#define IPC_ILRS3_ILRn31_BITNUM   7
#define IPC_ILRS3_ILRn0_MASK      3U
#define IPC_ILRS3_ILRn0_BITNUM    0
#define IPC_ILRS3_ILRn1_MASK      12U
#define IPC_ILRS3_ILRn1_BITNUM    2
#define IPC_ILRS3_ILRn2_MASK      48U
#define IPC_ILRS3_ILRn2_BITNUM    4
#define IPC_ILRS3_ILRn3_MASK      192U
#define IPC_ILRS3_ILRn3_BITNUM    6


/*** IPC_ILRS4 Interrupt Level Setting Registers n; 0x00003054 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS4STR;
extern volatile IPC_ILRS4STR _IPC_ILRS4 @0x00003054;
#define IPC_ILRS4                 _IPC_ILRS4.Byte
#define IPC_ILRS4_ILRn00          _IPC_ILRS4.Bits.ILRn00
#define IPC_ILRS4_ILRn01          _IPC_ILRS4.Bits.ILRn01
#define IPC_ILRS4_ILRn10          _IPC_ILRS4.Bits.ILRn10
#define IPC_ILRS4_ILRn11          _IPC_ILRS4.Bits.ILRn11
#define IPC_ILRS4_ILRn20          _IPC_ILRS4.Bits.ILRn20
#define IPC_ILRS4_ILRn21          _IPC_ILRS4.Bits.ILRn21
#define IPC_ILRS4_ILRn30          _IPC_ILRS4.Bits.ILRn30
#define IPC_ILRS4_ILRn31          _IPC_ILRS4.Bits.ILRn31
#define IPC_ILRS4_ILRn0           _IPC_ILRS4.MergedBits.grpILRn0
#define IPC_ILRS4_ILRn1           _IPC_ILRS4.MergedBits.grpILRn1
#define IPC_ILRS4_ILRn2           _IPC_ILRS4.MergedBits.grpILRn2
#define IPC_ILRS4_ILRn3           _IPC_ILRS4.MergedBits.grpILRn3

#define IPC_ILRS4_ILRn00_MASK     1U
#define IPC_ILRS4_ILRn00_BITNUM   0
#define IPC_ILRS4_ILRn01_MASK     2U
#define IPC_ILRS4_ILRn01_BITNUM   1
#define IPC_ILRS4_ILRn10_MASK     4U
#define IPC_ILRS4_ILRn10_BITNUM   2
#define IPC_ILRS4_ILRn11_MASK     8U
#define IPC_ILRS4_ILRn11_BITNUM   3
#define IPC_ILRS4_ILRn20_MASK     16U
#define IPC_ILRS4_ILRn20_BITNUM   4
#define IPC_ILRS4_ILRn21_MASK     32U
#define IPC_ILRS4_ILRn21_BITNUM   5
#define IPC_ILRS4_ILRn30_MASK     64U
#define IPC_ILRS4_ILRn30_BITNUM   6
#define IPC_ILRS4_ILRn31_MASK     128U
#define IPC_ILRS4_ILRn31_BITNUM   7
#define IPC_ILRS4_ILRn0_MASK      3U
#define IPC_ILRS4_ILRn0_BITNUM    0
#define IPC_ILRS4_ILRn1_MASK      12U
#define IPC_ILRS4_ILRn1_BITNUM    2
#define IPC_ILRS4_ILRn2_MASK      48U
#define IPC_ILRS4_ILRn2_BITNUM    4
#define IPC_ILRS4_ILRn3_MASK      192U
#define IPC_ILRS4_ILRn3_BITNUM    6


/*** IPC_ILRS5 Interrupt Level Setting Registers n; 0x00003055 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS5STR;
extern volatile IPC_ILRS5STR _IPC_ILRS5 @0x00003055;
#define IPC_ILRS5                 _IPC_ILRS5.Byte
#define IPC_ILRS5_ILRn00          _IPC_ILRS5.Bits.ILRn00
#define IPC_ILRS5_ILRn01          _IPC_ILRS5.Bits.ILRn01
#define IPC_ILRS5_ILRn10          _IPC_ILRS5.Bits.ILRn10
#define IPC_ILRS5_ILRn11          _IPC_ILRS5.Bits.ILRn11
#define IPC_ILRS5_ILRn20          _IPC_ILRS5.Bits.ILRn20
#define IPC_ILRS5_ILRn21          _IPC_ILRS5.Bits.ILRn21
#define IPC_ILRS5_ILRn30          _IPC_ILRS5.Bits.ILRn30
#define IPC_ILRS5_ILRn31          _IPC_ILRS5.Bits.ILRn31
#define IPC_ILRS5_ILRn0           _IPC_ILRS5.MergedBits.grpILRn0
#define IPC_ILRS5_ILRn1           _IPC_ILRS5.MergedBits.grpILRn1
#define IPC_ILRS5_ILRn2           _IPC_ILRS5.MergedBits.grpILRn2
#define IPC_ILRS5_ILRn3           _IPC_ILRS5.MergedBits.grpILRn3

#define IPC_ILRS5_ILRn00_MASK     1U
#define IPC_ILRS5_ILRn00_BITNUM   0
#define IPC_ILRS5_ILRn01_MASK     2U
#define IPC_ILRS5_ILRn01_BITNUM   1
#define IPC_ILRS5_ILRn10_MASK     4U
#define IPC_ILRS5_ILRn10_BITNUM   2
#define IPC_ILRS5_ILRn11_MASK     8U
#define IPC_ILRS5_ILRn11_BITNUM   3
#define IPC_ILRS5_ILRn20_MASK     16U
#define IPC_ILRS5_ILRn20_BITNUM   4
#define IPC_ILRS5_ILRn21_MASK     32U
#define IPC_ILRS5_ILRn21_BITNUM   5
#define IPC_ILRS5_ILRn30_MASK     64U
#define IPC_ILRS5_ILRn30_BITNUM   6
#define IPC_ILRS5_ILRn31_MASK     128U
#define IPC_ILRS5_ILRn31_BITNUM   7
#define IPC_ILRS5_ILRn0_MASK      3U
#define IPC_ILRS5_ILRn0_BITNUM    0
#define IPC_ILRS5_ILRn1_MASK      12U
#define IPC_ILRS5_ILRn1_BITNUM    2
#define IPC_ILRS5_ILRn2_MASK      48U
#define IPC_ILRS5_ILRn2_BITNUM    4
#define IPC_ILRS5_ILRn3_MASK      192U
#define IPC_ILRS5_ILRn3_BITNUM    6


/*** IPC_ILRS6 Interrupt Level Setting Registers n; 0x00003056 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS6STR;
extern volatile IPC_ILRS6STR _IPC_ILRS6 @0x00003056;
#define IPC_ILRS6                 _IPC_ILRS6.Byte
#define IPC_ILRS6_ILRn00          _IPC_ILRS6.Bits.ILRn00
#define IPC_ILRS6_ILRn01          _IPC_ILRS6.Bits.ILRn01
#define IPC_ILRS6_ILRn10          _IPC_ILRS6.Bits.ILRn10
#define IPC_ILRS6_ILRn11          _IPC_ILRS6.Bits.ILRn11
#define IPC_ILRS6_ILRn20          _IPC_ILRS6.Bits.ILRn20
#define IPC_ILRS6_ILRn21          _IPC_ILRS6.Bits.ILRn21
#define IPC_ILRS6_ILRn30          _IPC_ILRS6.Bits.ILRn30
#define IPC_ILRS6_ILRn31          _IPC_ILRS6.Bits.ILRn31
#define IPC_ILRS6_ILRn0           _IPC_ILRS6.MergedBits.grpILRn0
#define IPC_ILRS6_ILRn1           _IPC_ILRS6.MergedBits.grpILRn1
#define IPC_ILRS6_ILRn2           _IPC_ILRS6.MergedBits.grpILRn2
#define IPC_ILRS6_ILRn3           _IPC_ILRS6.MergedBits.grpILRn3

#define IPC_ILRS6_ILRn00_MASK     1U
#define IPC_ILRS6_ILRn00_BITNUM   0
#define IPC_ILRS6_ILRn01_MASK     2U
#define IPC_ILRS6_ILRn01_BITNUM   1
#define IPC_ILRS6_ILRn10_MASK     4U
#define IPC_ILRS6_ILRn10_BITNUM   2
#define IPC_ILRS6_ILRn11_MASK     8U
#define IPC_ILRS6_ILRn11_BITNUM   3
#define IPC_ILRS6_ILRn20_MASK     16U
#define IPC_ILRS6_ILRn20_BITNUM   4
#define IPC_ILRS6_ILRn21_MASK     32U
#define IPC_ILRS6_ILRn21_BITNUM   5
#define IPC_ILRS6_ILRn30_MASK     64U
#define IPC_ILRS6_ILRn30_BITNUM   6
#define IPC_ILRS6_ILRn31_MASK     128U
#define IPC_ILRS6_ILRn31_BITNUM   7
#define IPC_ILRS6_ILRn0_MASK      3U
#define IPC_ILRS6_ILRn0_BITNUM    0
#define IPC_ILRS6_ILRn1_MASK      12U
#define IPC_ILRS6_ILRn1_BITNUM    2
#define IPC_ILRS6_ILRn2_MASK      48U
#define IPC_ILRS6_ILRn2_BITNUM    4
#define IPC_ILRS6_ILRn3_MASK      192U
#define IPC_ILRS6_ILRn3_BITNUM    6


/*** IPC_ILRS7 Interrupt Level Setting Registers n; 0x00003057 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS7STR;
extern volatile IPC_ILRS7STR _IPC_ILRS7 @0x00003057;
#define IPC_ILRS7                 _IPC_ILRS7.Byte
#define IPC_ILRS7_ILRn00          _IPC_ILRS7.Bits.ILRn00
#define IPC_ILRS7_ILRn01          _IPC_ILRS7.Bits.ILRn01
#define IPC_ILRS7_ILRn10          _IPC_ILRS7.Bits.ILRn10
#define IPC_ILRS7_ILRn11          _IPC_ILRS7.Bits.ILRn11
#define IPC_ILRS7_ILRn20          _IPC_ILRS7.Bits.ILRn20
#define IPC_ILRS7_ILRn21          _IPC_ILRS7.Bits.ILRn21
#define IPC_ILRS7_ILRn30          _IPC_ILRS7.Bits.ILRn30
#define IPC_ILRS7_ILRn31          _IPC_ILRS7.Bits.ILRn31
#define IPC_ILRS7_ILRn0           _IPC_ILRS7.MergedBits.grpILRn0
#define IPC_ILRS7_ILRn1           _IPC_ILRS7.MergedBits.grpILRn1
#define IPC_ILRS7_ILRn2           _IPC_ILRS7.MergedBits.grpILRn2
#define IPC_ILRS7_ILRn3           _IPC_ILRS7.MergedBits.grpILRn3

#define IPC_ILRS7_ILRn00_MASK     1U
#define IPC_ILRS7_ILRn00_BITNUM   0
#define IPC_ILRS7_ILRn01_MASK     2U
#define IPC_ILRS7_ILRn01_BITNUM   1
#define IPC_ILRS7_ILRn10_MASK     4U
#define IPC_ILRS7_ILRn10_BITNUM   2
#define IPC_ILRS7_ILRn11_MASK     8U
#define IPC_ILRS7_ILRn11_BITNUM   3
#define IPC_ILRS7_ILRn20_MASK     16U
#define IPC_ILRS7_ILRn20_BITNUM   4
#define IPC_ILRS7_ILRn21_MASK     32U
#define IPC_ILRS7_ILRn21_BITNUM   5
#define IPC_ILRS7_ILRn30_MASK     64U
#define IPC_ILRS7_ILRn30_BITNUM   6
#define IPC_ILRS7_ILRn31_MASK     128U
#define IPC_ILRS7_ILRn31_BITNUM   7
#define IPC_ILRS7_ILRn0_MASK      3U
#define IPC_ILRS7_ILRn0_BITNUM    0
#define IPC_ILRS7_ILRn1_MASK      12U
#define IPC_ILRS7_ILRn1_BITNUM    2
#define IPC_ILRS7_ILRn2_MASK      48U
#define IPC_ILRS7_ILRn2_BITNUM    4
#define IPC_ILRS7_ILRn3_MASK      192U
#define IPC_ILRS7_ILRn3_BITNUM    6


/*** IPC_ILRS8 Interrupt Level Setting Registers n; 0x00003058 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS8STR;
extern volatile IPC_ILRS8STR _IPC_ILRS8 @0x00003058;
#define IPC_ILRS8                 _IPC_ILRS8.Byte
#define IPC_ILRS8_ILRn00          _IPC_ILRS8.Bits.ILRn00
#define IPC_ILRS8_ILRn01          _IPC_ILRS8.Bits.ILRn01
#define IPC_ILRS8_ILRn10          _IPC_ILRS8.Bits.ILRn10
#define IPC_ILRS8_ILRn11          _IPC_ILRS8.Bits.ILRn11
#define IPC_ILRS8_ILRn20          _IPC_ILRS8.Bits.ILRn20
#define IPC_ILRS8_ILRn21          _IPC_ILRS8.Bits.ILRn21
#define IPC_ILRS8_ILRn30          _IPC_ILRS8.Bits.ILRn30
#define IPC_ILRS8_ILRn31          _IPC_ILRS8.Bits.ILRn31
#define IPC_ILRS8_ILRn0           _IPC_ILRS8.MergedBits.grpILRn0
#define IPC_ILRS8_ILRn1           _IPC_ILRS8.MergedBits.grpILRn1
#define IPC_ILRS8_ILRn2           _IPC_ILRS8.MergedBits.grpILRn2
#define IPC_ILRS8_ILRn3           _IPC_ILRS8.MergedBits.grpILRn3

#define IPC_ILRS8_ILRn00_MASK     1U
#define IPC_ILRS8_ILRn00_BITNUM   0
#define IPC_ILRS8_ILRn01_MASK     2U
#define IPC_ILRS8_ILRn01_BITNUM   1
#define IPC_ILRS8_ILRn10_MASK     4U
#define IPC_ILRS8_ILRn10_BITNUM   2
#define IPC_ILRS8_ILRn11_MASK     8U
#define IPC_ILRS8_ILRn11_BITNUM   3
#define IPC_ILRS8_ILRn20_MASK     16U
#define IPC_ILRS8_ILRn20_BITNUM   4
#define IPC_ILRS8_ILRn21_MASK     32U
#define IPC_ILRS8_ILRn21_BITNUM   5
#define IPC_ILRS8_ILRn30_MASK     64U
#define IPC_ILRS8_ILRn30_BITNUM   6
#define IPC_ILRS8_ILRn31_MASK     128U
#define IPC_ILRS8_ILRn31_BITNUM   7
#define IPC_ILRS8_ILRn0_MASK      3U
#define IPC_ILRS8_ILRn0_BITNUM    0
#define IPC_ILRS8_ILRn1_MASK      12U
#define IPC_ILRS8_ILRn1_BITNUM    2
#define IPC_ILRS8_ILRn2_MASK      48U
#define IPC_ILRS8_ILRn2_BITNUM    4
#define IPC_ILRS8_ILRn3_MASK      192U
#define IPC_ILRS8_ILRn3_BITNUM    6


/*** IPC_ILRS9 Interrupt Level Setting Registers n; 0x00003059 ***/
typedef union {
  byte Byte;
  struct {
    byte  ILRn00     : 1;
    byte  ILRn01     : 1;
    byte  ILRn10     : 1;
    byte  ILRn11     : 1;
    byte  ILRn20     : 1;
    byte  ILRn21     : 1;
    byte  ILRn30     : 1;
    byte  ILRn31     : 1;
  } Bits;
  struct {
    byte  grpILRn0   : 2;
    byte  grpILRn1   : 2;
    byte  grpILRn2   : 2;
    byte  grpILRn3   : 2;
  } MergedBits;
} IPC_ILRS9STR;
extern volatile IPC_ILRS9STR _IPC_ILRS9 @0x00003059;
#define IPC_ILRS9                 _IPC_ILRS9.Byte
#define IPC_ILRS9_ILRn00          _IPC_ILRS9.Bits.ILRn00
#define IPC_ILRS9_ILRn01          _IPC_ILRS9.Bits.ILRn01
#define IPC_ILRS9_ILRn10          _IPC_ILRS9.Bits.ILRn10
#define IPC_ILRS9_ILRn11          _IPC_ILRS9.Bits.ILRn11
#define IPC_ILRS9_ILRn20          _IPC_ILRS9.Bits.ILRn20
#define IPC_ILRS9_ILRn21          _IPC_ILRS9.Bits.ILRn21
#define IPC_ILRS9_ILRn30          _IPC_ILRS9.Bits.ILRn30
#define IPC_ILRS9_ILRn31          _IPC_ILRS9.Bits.ILRn31
#define IPC_ILRS9_ILRn0           _IPC_ILRS9.MergedBits.grpILRn0
#define IPC_ILRS9_ILRn1           _IPC_ILRS9.MergedBits.grpILRn1
#define IPC_ILRS9_ILRn2           _IPC_ILRS9.MergedBits.grpILRn2
#define IPC_ILRS9_ILRn3           _IPC_ILRS9.MergedBits.grpILRn3

#define IPC_ILRS9_ILRn00_MASK     1U
#define IPC_ILRS9_ILRn00_BITNUM   0
#define IPC_ILRS9_ILRn01_MASK     2U
#define IPC_ILRS9_ILRn01_BITNUM   1
#define IPC_ILRS9_ILRn10_MASK     4U
#define IPC_ILRS9_ILRn10_BITNUM   2
#define IPC_ILRS9_ILRn11_MASK     8U
#define IPC_ILRS9_ILRn11_BITNUM   3
#define IPC_ILRS9_ILRn20_MASK     16U
#define IPC_ILRS9_ILRn20_BITNUM   4
#define IPC_ILRS9_ILRn21_MASK     32U
#define IPC_ILRS9_ILRn21_BITNUM   5
#define IPC_ILRS9_ILRn30_MASK     64U
#define IPC_ILRS9_ILRn30_BITNUM   6
#define IPC_ILRS9_ILRn31_MASK     128U
#define IPC_ILRS9_ILRn31_BITNUM   7
#define IPC_ILRS9_ILRn0_MASK      3U
#define IPC_ILRS9_ILRn0_BITNUM    0
#define IPC_ILRS9_ILRn1_MASK      12U
#define IPC_ILRS9_ILRn1_BITNUM    2
#define IPC_ILRS9_ILRn2_MASK      48U
#define IPC_ILRS9_ILRn2_BITNUM    4
#define IPC_ILRS9_ILRn3_MASK      192U
#define IPC_ILRS9_ILRn3_BITNUM    6


/*** ACMP1_CS ACMP Control and Status Register; 0x0000305C ***/
typedef union {
  byte Byte;
  struct {
    byte  ACMOD0     : 1;
    byte  ACMOD1     : 1;
    byte  ACOPE      : 1;
    byte  ACO        : 1;
    byte  ACIE       : 1;
    byte  ACF        : 1;
    byte  HYST       : 1;
    byte  ACE        : 1;
  } Bits;
  struct {
    byte  grpACMOD   : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ACMP1_CSSTR;
extern volatile ACMP1_CSSTR _ACMP1_CS @0x0000305C;
#define ACMP1_CS                  _ACMP1_CS.Byte
#define ACMP1_CS_ACMOD0           _ACMP1_CS.Bits.ACMOD0
#define ACMP1_CS_ACMOD1           _ACMP1_CS.Bits.ACMOD1
#define ACMP1_CS_ACOPE            _ACMP1_CS.Bits.ACOPE
#define ACMP1_CS_ACO              _ACMP1_CS.Bits.ACO
#define ACMP1_CS_ACIE             _ACMP1_CS.Bits.ACIE
#define ACMP1_CS_ACF              _ACMP1_CS.Bits.ACF
#define ACMP1_CS_HYST             _ACMP1_CS.Bits.HYST
#define ACMP1_CS_ACE              _ACMP1_CS.Bits.ACE
#define ACMP1_CS_ACMOD            _ACMP1_CS.MergedBits.grpACMOD

#define ACMP1_CS_ACMOD0_MASK      1U
#define ACMP1_CS_ACMOD0_BITNUM    0
#define ACMP1_CS_ACMOD1_MASK      2U
#define ACMP1_CS_ACMOD1_BITNUM    1
#define ACMP1_CS_ACOPE_MASK       4U
#define ACMP1_CS_ACOPE_BITNUM     2
#define ACMP1_CS_ACO_MASK         8U
#define ACMP1_CS_ACO_BITNUM       3
#define ACMP1_CS_ACIE_MASK        16U
#define ACMP1_CS_ACIE_BITNUM      4
#define ACMP1_CS_ACF_MASK         32U
#define ACMP1_CS_ACF_BITNUM       5
#define ACMP1_CS_HYST_MASK        64U
#define ACMP1_CS_HYST_BITNUM      6
#define ACMP1_CS_ACE_MASK         128U
#define ACMP1_CS_ACE_BITNUM       7
#define ACMP1_CS_ACMOD_MASK       3U
#define ACMP1_CS_ACMOD_BITNUM     0


/*** ACMP1_C0 ACMP Control Register 0; 0x0000305D ***/
typedef union {
  byte Byte;
  struct {
    byte  ACNSEL0    : 1;
    byte  ACNSEL1    : 1;
    byte             : 1;
    byte             : 1;
    byte  ACPSEL0    : 1;
    byte  ACPSEL1    : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpACNSEL  : 2;
    byte             : 1;
    byte             : 1;
    byte  grpACPSEL  : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ACMP1_C0STR;
extern volatile ACMP1_C0STR _ACMP1_C0 @0x0000305D;
#define ACMP1_C0                  _ACMP1_C0.Byte
#define ACMP1_C0_ACNSEL0          _ACMP1_C0.Bits.ACNSEL0
#define ACMP1_C0_ACNSEL1          _ACMP1_C0.Bits.ACNSEL1
#define ACMP1_C0_ACPSEL0          _ACMP1_C0.Bits.ACPSEL0
#define ACMP1_C0_ACPSEL1          _ACMP1_C0.Bits.ACPSEL1
#define ACMP1_C0_ACNSEL           _ACMP1_C0.MergedBits.grpACNSEL
#define ACMP1_C0_ACPSEL           _ACMP1_C0.MergedBits.grpACPSEL

#define ACMP1_C0_ACNSEL0_MASK     1U
#define ACMP1_C0_ACNSEL0_BITNUM   0
#define ACMP1_C0_ACNSEL1_MASK     2U
#define ACMP1_C0_ACNSEL1_BITNUM   1
#define ACMP1_C0_ACPSEL0_MASK     16U
#define ACMP1_C0_ACPSEL0_BITNUM   4
#define ACMP1_C0_ACPSEL1_MASK     32U
#define ACMP1_C0_ACPSEL1_BITNUM   5
#define ACMP1_C0_ACNSEL_MASK      3U
#define ACMP1_C0_ACNSEL_BITNUM    0
#define ACMP1_C0_ACPSEL_MASK      48U
#define ACMP1_C0_ACPSEL_BITNUM    4


/*** ACMP1_C1 ACMP Control Register 1; 0x0000305E ***/
typedef union {
  byte Byte;
  struct {
    byte  DACVAL0    : 1;
    byte  DACVAL1    : 1;
    byte  DACVAL2    : 1;
    byte  DACVAL3    : 1;
    byte  DACVAL4    : 1;
    byte  DACVAL5    : 1;
    byte  DACREF     : 1;
    byte  DACEN      : 1;
  } Bits;
  struct {
    byte  grpDACVAL  : 6;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ACMP1_C1STR;
extern volatile ACMP1_C1STR _ACMP1_C1 @0x0000305E;
#define ACMP1_C1                  _ACMP1_C1.Byte
#define ACMP1_C1_DACVAL0          _ACMP1_C1.Bits.DACVAL0
#define ACMP1_C1_DACVAL1          _ACMP1_C1.Bits.DACVAL1
#define ACMP1_C1_DACVAL2          _ACMP1_C1.Bits.DACVAL2
#define ACMP1_C1_DACVAL3          _ACMP1_C1.Bits.DACVAL3
#define ACMP1_C1_DACVAL4          _ACMP1_C1.Bits.DACVAL4
#define ACMP1_C1_DACVAL5          _ACMP1_C1.Bits.DACVAL5
#define ACMP1_C1_DACREF           _ACMP1_C1.Bits.DACREF
#define ACMP1_C1_DACEN            _ACMP1_C1.Bits.DACEN
#define ACMP1_C1_DACVAL           _ACMP1_C1.MergedBits.grpDACVAL

#define ACMP1_C1_DACVAL0_MASK     1U
#define ACMP1_C1_DACVAL0_BITNUM   0
#define ACMP1_C1_DACVAL1_MASK     2U
#define ACMP1_C1_DACVAL1_BITNUM   1
#define ACMP1_C1_DACVAL2_MASK     4U
#define ACMP1_C1_DACVAL2_BITNUM   2
#define ACMP1_C1_DACVAL3_MASK     8U
#define ACMP1_C1_DACVAL3_BITNUM   3
#define ACMP1_C1_DACVAL4_MASK     16U
#define ACMP1_C1_DACVAL4_BITNUM   4
#define ACMP1_C1_DACVAL5_MASK     32U
#define ACMP1_C1_DACVAL5_BITNUM   5
#define ACMP1_C1_DACREF_MASK      64U
#define ACMP1_C1_DACREF_BITNUM    6
#define ACMP1_C1_DACEN_MASK       128U
#define ACMP1_C1_DACEN_BITNUM     7
#define ACMP1_C1_DACVAL_MASK      63U
#define ACMP1_C1_DACVAL_BITNUM    0


/*** ACMP1_C2 ACMP Control Register 2; 0x0000305F ***/
typedef union {
  byte Byte;
  struct {
    byte  ACIPE0     : 1;
    byte  ACIPE1     : 1;
    byte  ACIPE2     : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpACIPE   : 3;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ACMP1_C2STR;
extern volatile ACMP1_C2STR _ACMP1_C2 @0x0000305F;
#define ACMP1_C2                  _ACMP1_C2.Byte
#define ACMP1_C2_ACIPE0           _ACMP1_C2.Bits.ACIPE0
#define ACMP1_C2_ACIPE1           _ACMP1_C2.Bits.ACIPE1
#define ACMP1_C2_ACIPE2           _ACMP1_C2.Bits.ACIPE2
#define ACMP1_C2_ACIPE            _ACMP1_C2.MergedBits.grpACIPE

#define ACMP1_C2_ACIPE0_MASK      1U
#define ACMP1_C2_ACIPE0_BITNUM    0
#define ACMP1_C2_ACIPE1_MASK      2U
#define ACMP1_C2_ACIPE1_BITNUM    1
#define ACMP1_C2_ACIPE2_MASK      4U
#define ACMP1_C2_ACIPE2_BITNUM    2
#define ACMP1_C2_ACIPE_MASK       7U
#define ACMP1_C2_ACIPE_BITNUM     0


/*** CRC_D0 CRC Data 0 Register; 0x00003060 ***/
typedef union {
  byte Byte;
  struct {
    byte  DH00       : 1;
    byte  DH01       : 1;
    byte  DH02       : 1;
    byte  DH03       : 1;
    byte  DH04       : 1;
    byte  DH05       : 1;
    byte  DH06       : 1;
    byte  DH07       : 1;
  } Bits;
} CRC_D0STR;
extern volatile CRC_D0STR _CRC_D0 @0x00003060;
#define CRC_D0                    _CRC_D0.Byte
#define CRC_D0_DH00               _CRC_D0.Bits.DH00
#define CRC_D0_DH01               _CRC_D0.Bits.DH01
#define CRC_D0_DH02               _CRC_D0.Bits.DH02
#define CRC_D0_DH03               _CRC_D0.Bits.DH03
#define CRC_D0_DH04               _CRC_D0.Bits.DH04
#define CRC_D0_DH05               _CRC_D0.Bits.DH05
#define CRC_D0_DH06               _CRC_D0.Bits.DH06
#define CRC_D0_DH07               _CRC_D0.Bits.DH07

#define CRC_D0_DH00_MASK          1U
#define CRC_D0_DH00_BITNUM        0
#define CRC_D0_DH01_MASK          2U
#define CRC_D0_DH01_BITNUM        1
#define CRC_D0_DH02_MASK          4U
#define CRC_D0_DH02_BITNUM        2
#define CRC_D0_DH03_MASK          8U
#define CRC_D0_DH03_BITNUM        3
#define CRC_D0_DH04_MASK          16U
#define CRC_D0_DH04_BITNUM        4
#define CRC_D0_DH05_MASK          32U
#define CRC_D0_DH05_BITNUM        5
#define CRC_D0_DH06_MASK          64U
#define CRC_D0_DH06_BITNUM        6
#define CRC_D0_DH07_MASK          128U
#define CRC_D0_DH07_BITNUM        7


/*** CRC_D1 CRC Data 1 Register; 0x00003061 ***/
typedef union {
  byte Byte;
  struct {
    byte  D10        : 1;
    byte  D11        : 1;
    byte  D12        : 1;
    byte  D13        : 1;
    byte  D14        : 1;
    byte  D15        : 1;
    byte  D16        : 1;
    byte  D17        : 1;
  } Bits;
} CRC_D1STR;
extern volatile CRC_D1STR _CRC_D1 @0x00003061;
#define CRC_D1                    _CRC_D1.Byte
#define CRC_D1_D10                _CRC_D1.Bits.D10
#define CRC_D1_D11                _CRC_D1.Bits.D11
#define CRC_D1_D12                _CRC_D1.Bits.D12
#define CRC_D1_D13                _CRC_D1.Bits.D13
#define CRC_D1_D14                _CRC_D1.Bits.D14
#define CRC_D1_D15                _CRC_D1.Bits.D15
#define CRC_D1_D16                _CRC_D1.Bits.D16
#define CRC_D1_D17                _CRC_D1.Bits.D17

#define CRC_D1_D10_MASK           1U
#define CRC_D1_D10_BITNUM         0
#define CRC_D1_D11_MASK           2U
#define CRC_D1_D11_BITNUM         1
#define CRC_D1_D12_MASK           4U
#define CRC_D1_D12_BITNUM         2
#define CRC_D1_D13_MASK           8U
#define CRC_D1_D13_BITNUM         3
#define CRC_D1_D14_MASK           16U
#define CRC_D1_D14_BITNUM         4
#define CRC_D1_D15_MASK           32U
#define CRC_D1_D15_BITNUM         5
#define CRC_D1_D16_MASK           64U
#define CRC_D1_D16_BITNUM         6
#define CRC_D1_D17_MASK           128U
#define CRC_D1_D17_BITNUM         7


/*** CRC_D2 CRC Data 2 Register; 0x00003062 ***/
typedef union {
  byte Byte;
  struct {
    byte  D20        : 1;
    byte  D21        : 1;
    byte  D22        : 1;
    byte  D23        : 1;
    byte  D24        : 1;
    byte  D25        : 1;
    byte  D26        : 1;
    byte  D27        : 1;
  } Bits;
} CRC_D2STR;
extern volatile CRC_D2STR _CRC_D2 @0x00003062;
#define CRC_D2                    _CRC_D2.Byte
#define CRC_D2_D20                _CRC_D2.Bits.D20
#define CRC_D2_D21                _CRC_D2.Bits.D21
#define CRC_D2_D22                _CRC_D2.Bits.D22
#define CRC_D2_D23                _CRC_D2.Bits.D23
#define CRC_D2_D24                _CRC_D2.Bits.D24
#define CRC_D2_D25                _CRC_D2.Bits.D25
#define CRC_D2_D26                _CRC_D2.Bits.D26
#define CRC_D2_D27                _CRC_D2.Bits.D27

#define CRC_D2_D20_MASK           1U
#define CRC_D2_D20_BITNUM         0
#define CRC_D2_D21_MASK           2U
#define CRC_D2_D21_BITNUM         1
#define CRC_D2_D22_MASK           4U
#define CRC_D2_D22_BITNUM         2
#define CRC_D2_D23_MASK           8U
#define CRC_D2_D23_BITNUM         3
#define CRC_D2_D24_MASK           16U
#define CRC_D2_D24_BITNUM         4
#define CRC_D2_D25_MASK           32U
#define CRC_D2_D25_BITNUM         5
#define CRC_D2_D26_MASK           64U
#define CRC_D2_D26_BITNUM         6
#define CRC_D2_D27_MASK           128U
#define CRC_D2_D27_BITNUM         7


/*** CRC_D3 CRC Data 3 Register; 0x00003063 ***/
typedef union {
  byte Byte;
  struct {
    byte  D30        : 1;
    byte  D31        : 1;
    byte  D32        : 1;
    byte  D33        : 1;
    byte  D34        : 1;
    byte  D35        : 1;
    byte  D36        : 1;
    byte  D37        : 1;
  } Bits;
} CRC_D3STR;
extern volatile CRC_D3STR _CRC_D3 @0x00003063;
#define CRC_D3                    _CRC_D3.Byte
#define CRC_D3_D30                _CRC_D3.Bits.D30
#define CRC_D3_D31                _CRC_D3.Bits.D31
#define CRC_D3_D32                _CRC_D3.Bits.D32
#define CRC_D3_D33                _CRC_D3.Bits.D33
#define CRC_D3_D34                _CRC_D3.Bits.D34
#define CRC_D3_D35                _CRC_D3.Bits.D35
#define CRC_D3_D36                _CRC_D3.Bits.D36
#define CRC_D3_D37                _CRC_D3.Bits.D37

#define CRC_D3_D30_MASK           1U
#define CRC_D3_D30_BITNUM         0
#define CRC_D3_D31_MASK           2U
#define CRC_D3_D31_BITNUM         1
#define CRC_D3_D32_MASK           4U
#define CRC_D3_D32_BITNUM         2
#define CRC_D3_D33_MASK           8U
#define CRC_D3_D33_BITNUM         3
#define CRC_D3_D34_MASK           16U
#define CRC_D3_D34_BITNUM         4
#define CRC_D3_D35_MASK           32U
#define CRC_D3_D35_BITNUM         5
#define CRC_D3_D36_MASK           64U
#define CRC_D3_D36_BITNUM         6
#define CRC_D3_D37_MASK           128U
#define CRC_D3_D37_BITNUM         7


/*** CRC_P0 CRC Polynomial 0 Register; 0x00003064 ***/
typedef union {
  byte Byte;
  struct {
    byte  P00        : 1;
    byte  P01        : 1;
    byte  P02        : 1;
    byte  P03        : 1;
    byte  P04        : 1;
    byte  P05        : 1;
    byte  P06        : 1;
    byte  P07        : 1;
  } Bits;
} CRC_P0STR;
extern volatile CRC_P0STR _CRC_P0 @0x00003064;
#define CRC_P0                    _CRC_P0.Byte
#define CRC_P0_P00                _CRC_P0.Bits.P00
#define CRC_P0_P01                _CRC_P0.Bits.P01
#define CRC_P0_P02                _CRC_P0.Bits.P02
#define CRC_P0_P03                _CRC_P0.Bits.P03
#define CRC_P0_P04                _CRC_P0.Bits.P04
#define CRC_P0_P05                _CRC_P0.Bits.P05
#define CRC_P0_P06                _CRC_P0.Bits.P06
#define CRC_P0_P07                _CRC_P0.Bits.P07

#define CRC_P0_P00_MASK           1U
#define CRC_P0_P00_BITNUM         0
#define CRC_P0_P01_MASK           2U
#define CRC_P0_P01_BITNUM         1
#define CRC_P0_P02_MASK           4U
#define CRC_P0_P02_BITNUM         2
#define CRC_P0_P03_MASK           8U
#define CRC_P0_P03_BITNUM         3
#define CRC_P0_P04_MASK           16U
#define CRC_P0_P04_BITNUM         4
#define CRC_P0_P05_MASK           32U
#define CRC_P0_P05_BITNUM         5
#define CRC_P0_P06_MASK           64U
#define CRC_P0_P06_BITNUM         6
#define CRC_P0_P07_MASK           128U
#define CRC_P0_P07_BITNUM         7


/*** CRC_P1 CRC Polynomial 1 Register; 0x00003065 ***/
typedef union {
  byte Byte;
  struct {
    byte  P10        : 1;
    byte  P11        : 1;
    byte  P12        : 1;
    byte  P13        : 1;
    byte  P14        : 1;
    byte  P15        : 1;
    byte  P16        : 1;
    byte  P17        : 1;
  } Bits;
} CRC_P1STR;
extern volatile CRC_P1STR _CRC_P1 @0x00003065;
#define CRC_P1                    _CRC_P1.Byte
#define CRC_P1_P10                _CRC_P1.Bits.P10
#define CRC_P1_P11                _CRC_P1.Bits.P11
#define CRC_P1_P12                _CRC_P1.Bits.P12
#define CRC_P1_P13                _CRC_P1.Bits.P13
#define CRC_P1_P14                _CRC_P1.Bits.P14
#define CRC_P1_P15                _CRC_P1.Bits.P15
#define CRC_P1_P16                _CRC_P1.Bits.P16
#define CRC_P1_P17                _CRC_P1.Bits.P17

#define CRC_P1_P10_MASK           1U
#define CRC_P1_P10_BITNUM         0
#define CRC_P1_P11_MASK           2U
#define CRC_P1_P11_BITNUM         1
#define CRC_P1_P12_MASK           4U
#define CRC_P1_P12_BITNUM         2
#define CRC_P1_P13_MASK           8U
#define CRC_P1_P13_BITNUM         3
#define CRC_P1_P14_MASK           16U
#define CRC_P1_P14_BITNUM         4
#define CRC_P1_P15_MASK           32U
#define CRC_P1_P15_BITNUM         5
#define CRC_P1_P16_MASK           64U
#define CRC_P1_P16_BITNUM         6
#define CRC_P1_P17_MASK           128U
#define CRC_P1_P17_BITNUM         7


/*** CRC_P2 CRC Polynomial 2 Register; 0x00003066 ***/
typedef union {
  byte Byte;
  struct {
    byte  P20        : 1;
    byte  P21        : 1;
    byte  P22        : 1;
    byte  P23        : 1;
    byte  P24        : 1;
    byte  P25        : 1;
    byte  P26        : 1;
    byte  P27        : 1;
  } Bits;
} CRC_P2STR;
extern volatile CRC_P2STR _CRC_P2 @0x00003066;
#define CRC_P2                    _CRC_P2.Byte
#define CRC_P2_P20                _CRC_P2.Bits.P20
#define CRC_P2_P21                _CRC_P2.Bits.P21
#define CRC_P2_P22                _CRC_P2.Bits.P22
#define CRC_P2_P23                _CRC_P2.Bits.P23
#define CRC_P2_P24                _CRC_P2.Bits.P24
#define CRC_P2_P25                _CRC_P2.Bits.P25
#define CRC_P2_P26                _CRC_P2.Bits.P26
#define CRC_P2_P27                _CRC_P2.Bits.P27

#define CRC_P2_P20_MASK           1U
#define CRC_P2_P20_BITNUM         0
#define CRC_P2_P21_MASK           2U
#define CRC_P2_P21_BITNUM         1
#define CRC_P2_P22_MASK           4U
#define CRC_P2_P22_BITNUM         2
#define CRC_P2_P23_MASK           8U
#define CRC_P2_P23_BITNUM         3
#define CRC_P2_P24_MASK           16U
#define CRC_P2_P24_BITNUM         4
#define CRC_P2_P25_MASK           32U
#define CRC_P2_P25_BITNUM         5
#define CRC_P2_P26_MASK           64U
#define CRC_P2_P26_BITNUM         6
#define CRC_P2_P27_MASK           128U
#define CRC_P2_P27_BITNUM         7


/*** CRC_P3 CRC Polynomial 3 Register; 0x00003067 ***/
typedef union {
  byte Byte;
  struct {
    byte  P30        : 1;
    byte  P31        : 1;
    byte  P32        : 1;
    byte  P33        : 1;
    byte  P34        : 1;
    byte  P35        : 1;
    byte  P36        : 1;
    byte  P37        : 1;
  } Bits;
} CRC_P3STR;
extern volatile CRC_P3STR _CRC_P3 @0x00003067;
#define CRC_P3                    _CRC_P3.Byte
#define CRC_P3_P30                _CRC_P3.Bits.P30
#define CRC_P3_P31                _CRC_P3.Bits.P31
#define CRC_P3_P32                _CRC_P3.Bits.P32
#define CRC_P3_P33                _CRC_P3.Bits.P33
#define CRC_P3_P34                _CRC_P3.Bits.P34
#define CRC_P3_P35                _CRC_P3.Bits.P35
#define CRC_P3_P36                _CRC_P3.Bits.P36
#define CRC_P3_P37                _CRC_P3.Bits.P37

#define CRC_P3_P30_MASK           1U
#define CRC_P3_P30_BITNUM         0
#define CRC_P3_P31_MASK           2U
#define CRC_P3_P31_BITNUM         1
#define CRC_P3_P32_MASK           4U
#define CRC_P3_P32_BITNUM         2
#define CRC_P3_P33_MASK           8U
#define CRC_P3_P33_BITNUM         3
#define CRC_P3_P34_MASK           16U
#define CRC_P3_P34_BITNUM         4
#define CRC_P3_P35_MASK           32U
#define CRC_P3_P35_BITNUM         5
#define CRC_P3_P36_MASK           64U
#define CRC_P3_P36_BITNUM         6
#define CRC_P3_P37_MASK           128U
#define CRC_P3_P37_BITNUM         7


/*** CRC_CTRL CRC Control Register; 0x00003068 ***/
typedef union {
  byte Byte;
  struct {
    byte  TCRC       : 1;
    byte  WAS        : 1;
    byte  FXOR       : 1;
    byte             : 1;
    byte  TOTR0      : 1;
    byte  TOTR1      : 1;
    byte  TOT0       : 1;
    byte  TOT1       : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  grpTOTR    : 2;
    byte  grpTOT     : 2;
  } MergedBits;
} CRC_CTRLSTR;
extern volatile CRC_CTRLSTR _CRC_CTRL @0x00003068;
#define CRC_CTRL                  _CRC_CTRL.Byte
#define CRC_CTRL_TCRC             _CRC_CTRL.Bits.TCRC
#define CRC_CTRL_WAS              _CRC_CTRL.Bits.WAS
#define CRC_CTRL_FXOR             _CRC_CTRL.Bits.FXOR
#define CRC_CTRL_TOTR0            _CRC_CTRL.Bits.TOTR0
#define CRC_CTRL_TOTR1            _CRC_CTRL.Bits.TOTR1
#define CRC_CTRL_TOT0             _CRC_CTRL.Bits.TOT0
#define CRC_CTRL_TOT1             _CRC_CTRL.Bits.TOT1
#define CRC_CTRL_TOTR             _CRC_CTRL.MergedBits.grpTOTR
#define CRC_CTRL_TOT              _CRC_CTRL.MergedBits.grpTOT

#define CRC_CTRL_TCRC_MASK        1U
#define CRC_CTRL_TCRC_BITNUM      0
#define CRC_CTRL_WAS_MASK         2U
#define CRC_CTRL_WAS_BITNUM       1
#define CRC_CTRL_FXOR_MASK        4U
#define CRC_CTRL_FXOR_BITNUM      2
#define CRC_CTRL_TOTR0_MASK       16U
#define CRC_CTRL_TOTR0_BITNUM     4
#define CRC_CTRL_TOTR1_MASK       32U
#define CRC_CTRL_TOTR1_BITNUM     5
#define CRC_CTRL_TOT0_MASK        64U
#define CRC_CTRL_TOT0_BITNUM      6
#define CRC_CTRL_TOT1_MASK        128U
#define CRC_CTRL_TOT1_BITNUM      7
#define CRC_CTRL_TOTR_MASK        48U
#define CRC_CTRL_TOTR_BITNUM      4
#define CRC_CTRL_TOT_MASK         192U
#define CRC_CTRL_TOT_BITNUM       6


/*** RTC_SC1 RTC Status and Control Register 1; 0x0000306A ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  RTIE       : 1;
    byte  RTIF       : 1;
  } Bits;
} RTC_SC1STR;
extern volatile RTC_SC1STR _RTC_SC1 @0x0000306A;
#define RTC_SC1                   _RTC_SC1.Byte
#define RTC_SC1_RTIE              _RTC_SC1.Bits.RTIE
#define RTC_SC1_RTIF              _RTC_SC1.Bits.RTIF

#define RTC_SC1_RTIE_MASK         64U
#define RTC_SC1_RTIE_BITNUM       6
#define RTC_SC1_RTIF_MASK         128U
#define RTC_SC1_RTIF_BITNUM       7


/*** RTC_SC2 RTC Status and Control Register 2; 0x0000306B ***/
typedef union {
  byte Byte;
  struct {
    byte  RTCPS0     : 1;
    byte  RTCPS1     : 1;
    byte  RTCPS2     : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  RTCLKS0    : 1;
    byte  RTCLKS1    : 1;
  } Bits;
  struct {
    byte  grpRTCPS   : 3;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  grpRTCLKS  : 2;
  } MergedBits;
} RTC_SC2STR;
extern volatile RTC_SC2STR _RTC_SC2 @0x0000306B;
#define RTC_SC2                   _RTC_SC2.Byte
#define RTC_SC2_RTCPS0            _RTC_SC2.Bits.RTCPS0
#define RTC_SC2_RTCPS1            _RTC_SC2.Bits.RTCPS1
#define RTC_SC2_RTCPS2            _RTC_SC2.Bits.RTCPS2
#define RTC_SC2_RTCLKS0           _RTC_SC2.Bits.RTCLKS0
#define RTC_SC2_RTCLKS1           _RTC_SC2.Bits.RTCLKS1
#define RTC_SC2_RTCPS             _RTC_SC2.MergedBits.grpRTCPS
#define RTC_SC2_RTCLKS            _RTC_SC2.MergedBits.grpRTCLKS

#define RTC_SC2_RTCPS0_MASK       1U
#define RTC_SC2_RTCPS0_BITNUM     0
#define RTC_SC2_RTCPS1_MASK       2U
#define RTC_SC2_RTCPS1_BITNUM     1
#define RTC_SC2_RTCPS2_MASK       4U
#define RTC_SC2_RTCPS2_BITNUM     2
#define RTC_SC2_RTCLKS0_MASK      64U
#define RTC_SC2_RTCLKS0_BITNUM    6
#define RTC_SC2_RTCLKS1_MASK      128U
#define RTC_SC2_RTCLKS1_BITNUM    7
#define RTC_SC2_RTCPS_MASK        7U
#define RTC_SC2_RTCPS_BITNUM      0
#define RTC_SC2_RTCLKS_MASK       192U
#define RTC_SC2_RTCLKS_BITNUM     6


/*** RTC_MOD RTC Modulo Register:  0x0000306C ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** RTC_MODH RTC Modulo Register: High; 0x0000306C ***/
    union {
      byte Byte;
      struct {
        byte  MODH0      : 1;
        byte  MODH1      : 1;
        byte  MODH2      : 1;
        byte  MODH3      : 1;
        byte  MODH4      : 1;
        byte  MODH5      : 1;
        byte  MODH6      : 1;
        byte  MODH7      : 1;
      } Bits;
    } RTC_MODHSTR;
    #define RTC_MODH                  _RTC_MOD.Overlap_STR.RTC_MODHSTR.Byte
    #define RTC_MODH_MODH0            _RTC_MOD.Overlap_STR.RTC_MODHSTR.Bits.MODH0
    #define RTC_MODH_MODH1            _RTC_MOD.Overlap_STR.RTC_MODHSTR.Bits.MODH1
    #define RTC_MODH_MODH2            _RTC_MOD.Overlap_STR.RTC_MODHSTR.Bits.MODH2
    #define RTC_MODH_MODH3            _RTC_MOD.Overlap_STR.RTC_MODHSTR.Bits.MODH3
    #define RTC_MODH_MODH4            _RTC_MOD.Overlap_STR.RTC_MODHSTR.Bits.MODH4
    #define RTC_MODH_MODH5            _RTC_MOD.Overlap_STR.RTC_MODHSTR.Bits.MODH5
    #define RTC_MODH_MODH6            _RTC_MOD.Overlap_STR.RTC_MODHSTR.Bits.MODH6
    #define RTC_MODH_MODH7            _RTC_MOD.Overlap_STR.RTC_MODHSTR.Bits.MODH7
    
    #define RTC_MODH_MODH0_MASK       1U
    #define RTC_MODH_MODH0_BITNUM     0
    #define RTC_MODH_MODH1_MASK       2U
    #define RTC_MODH_MODH1_BITNUM     1
    #define RTC_MODH_MODH2_MASK       4U
    #define RTC_MODH_MODH2_BITNUM     2
    #define RTC_MODH_MODH3_MASK       8U
    #define RTC_MODH_MODH3_BITNUM     3
    #define RTC_MODH_MODH4_MASK       16U
    #define RTC_MODH_MODH4_BITNUM     4
    #define RTC_MODH_MODH5_MASK       32U
    #define RTC_MODH_MODH5_BITNUM     5
    #define RTC_MODH_MODH6_MASK       64U
    #define RTC_MODH_MODH6_BITNUM     6
    #define RTC_MODH_MODH7_MASK       128U
    #define RTC_MODH_MODH7_BITNUM     7
    
    /*** RTC_MODL RTC Modulo Register: Low; 0x0000306D ***/
    union {
      byte Byte;
      struct {
        byte  MODL0      : 1;
        byte  MODL1      : 1;
        byte  MODL2      : 1;
        byte  MODL3      : 1;
        byte  MODL4      : 1;
        byte  MODL5      : 1;
        byte  MODL6      : 1;
        byte  MODL7      : 1;
      } Bits;
    } RTC_MODLSTR;
    #define RTC_MODL                  _RTC_MOD.Overlap_STR.RTC_MODLSTR.Byte
    #define RTC_MODL_MODL0            _RTC_MOD.Overlap_STR.RTC_MODLSTR.Bits.MODL0
    #define RTC_MODL_MODL1            _RTC_MOD.Overlap_STR.RTC_MODLSTR.Bits.MODL1
    #define RTC_MODL_MODL2            _RTC_MOD.Overlap_STR.RTC_MODLSTR.Bits.MODL2
    #define RTC_MODL_MODL3            _RTC_MOD.Overlap_STR.RTC_MODLSTR.Bits.MODL3
    #define RTC_MODL_MODL4            _RTC_MOD.Overlap_STR.RTC_MODLSTR.Bits.MODL4
    #define RTC_MODL_MODL5            _RTC_MOD.Overlap_STR.RTC_MODLSTR.Bits.MODL5
    #define RTC_MODL_MODL6            _RTC_MOD.Overlap_STR.RTC_MODLSTR.Bits.MODL6
    #define RTC_MODL_MODL7            _RTC_MOD.Overlap_STR.RTC_MODLSTR.Bits.MODL7
    
    #define RTC_MODL_MODL0_MASK       1U
    #define RTC_MODL_MODL0_BITNUM     0
    #define RTC_MODL_MODL1_MASK       2U
    #define RTC_MODL_MODL1_BITNUM     1
    #define RTC_MODL_MODL2_MASK       4U
    #define RTC_MODL_MODL2_BITNUM     2
    #define RTC_MODL_MODL3_MASK       8U
    #define RTC_MODL_MODL3_BITNUM     3
    #define RTC_MODL_MODL4_MASK       16U
    #define RTC_MODL_MODL4_BITNUM     4
    #define RTC_MODL_MODL5_MASK       32U
    #define RTC_MODL_MODL5_BITNUM     5
    #define RTC_MODL_MODL6_MASK       64U
    #define RTC_MODL_MODL6_BITNUM     6
    #define RTC_MODL_MODL7_MASK       128U
    #define RTC_MODL_MODL7_BITNUM     7
    
  } Overlap_STR;
} RTC_MODSTR;
extern volatile RTC_MODSTR _RTC_MOD @0x0000306C;
#define RTC_MOD                   _RTC_MOD.Word


/*** RTC_CNT RTC Counter Register:  0x0000306E ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** RTC_CNTH RTC Counter Register: High; 0x0000306E ***/
    union {
      byte Byte;
      struct {
        byte  CNTH0      : 1;
        byte  CNTH1      : 1;
        byte  CNTH2      : 1;
        byte  CNTH3      : 1;
        byte  CNTH4      : 1;
        byte  CNTH5      : 1;
        byte  CNTH6      : 1;
        byte  CNTH7      : 1;
      } Bits;
    } RTC_CNTHSTR;
    #define RTC_CNTH                  _RTC_CNT.Overlap_STR.RTC_CNTHSTR.Byte
    #define RTC_CNTH_CNTH0            _RTC_CNT.Overlap_STR.RTC_CNTHSTR.Bits.CNTH0
    #define RTC_CNTH_CNTH1            _RTC_CNT.Overlap_STR.RTC_CNTHSTR.Bits.CNTH1
    #define RTC_CNTH_CNTH2            _RTC_CNT.Overlap_STR.RTC_CNTHSTR.Bits.CNTH2
    #define RTC_CNTH_CNTH3            _RTC_CNT.Overlap_STR.RTC_CNTHSTR.Bits.CNTH3
    #define RTC_CNTH_CNTH4            _RTC_CNT.Overlap_STR.RTC_CNTHSTR.Bits.CNTH4
    #define RTC_CNTH_CNTH5            _RTC_CNT.Overlap_STR.RTC_CNTHSTR.Bits.CNTH5
    #define RTC_CNTH_CNTH6            _RTC_CNT.Overlap_STR.RTC_CNTHSTR.Bits.CNTH6
    #define RTC_CNTH_CNTH7            _RTC_CNT.Overlap_STR.RTC_CNTHSTR.Bits.CNTH7
    
    #define RTC_CNTH_CNTH0_MASK       1U
    #define RTC_CNTH_CNTH0_BITNUM     0
    #define RTC_CNTH_CNTH1_MASK       2U
    #define RTC_CNTH_CNTH1_BITNUM     1
    #define RTC_CNTH_CNTH2_MASK       4U
    #define RTC_CNTH_CNTH2_BITNUM     2
    #define RTC_CNTH_CNTH3_MASK       8U
    #define RTC_CNTH_CNTH3_BITNUM     3
    #define RTC_CNTH_CNTH4_MASK       16U
    #define RTC_CNTH_CNTH4_BITNUM     4
    #define RTC_CNTH_CNTH5_MASK       32U
    #define RTC_CNTH_CNTH5_BITNUM     5
    #define RTC_CNTH_CNTH6_MASK       64U
    #define RTC_CNTH_CNTH6_BITNUM     6
    #define RTC_CNTH_CNTH7_MASK       128U
    #define RTC_CNTH_CNTH7_BITNUM     7
    
    /*** RTC_CNTL RTC Counter Register: Low; 0x0000306F ***/
    union {
      byte Byte;
      struct {
        byte  CNTL0      : 1;
        byte  CNTL1      : 1;
        byte  CNTL2      : 1;
        byte  CNTL3      : 1;
        byte  CNTL4      : 1;
        byte  CNTL5      : 1;
        byte  CNTL6      : 1;
        byte  CNTL7      : 1;
      } Bits;
    } RTC_CNTLSTR;
    #define RTC_CNTL                  _RTC_CNT.Overlap_STR.RTC_CNTLSTR.Byte
    #define RTC_CNTL_CNTL0            _RTC_CNT.Overlap_STR.RTC_CNTLSTR.Bits.CNTL0
    #define RTC_CNTL_CNTL1            _RTC_CNT.Overlap_STR.RTC_CNTLSTR.Bits.CNTL1
    #define RTC_CNTL_CNTL2            _RTC_CNT.Overlap_STR.RTC_CNTLSTR.Bits.CNTL2
    #define RTC_CNTL_CNTL3            _RTC_CNT.Overlap_STR.RTC_CNTLSTR.Bits.CNTL3
    #define RTC_CNTL_CNTL4            _RTC_CNT.Overlap_STR.RTC_CNTLSTR.Bits.CNTL4
    #define RTC_CNTL_CNTL5            _RTC_CNT.Overlap_STR.RTC_CNTLSTR.Bits.CNTL5
    #define RTC_CNTL_CNTL6            _RTC_CNT.Overlap_STR.RTC_CNTLSTR.Bits.CNTL6
    #define RTC_CNTL_CNTL7            _RTC_CNT.Overlap_STR.RTC_CNTLSTR.Bits.CNTL7
    
    #define RTC_CNTL_CNTL0_MASK       1U
    #define RTC_CNTL_CNTL0_BITNUM     0
    #define RTC_CNTL_CNTL1_MASK       2U
    #define RTC_CNTL_CNTL1_BITNUM     1
    #define RTC_CNTL_CNTL2_MASK       4U
    #define RTC_CNTL_CNTL2_BITNUM     2
    #define RTC_CNTL_CNTL3_MASK       8U
    #define RTC_CNTL_CNTL3_BITNUM     3
    #define RTC_CNTL_CNTL4_MASK       16U
    #define RTC_CNTL_CNTL4_BITNUM     4
    #define RTC_CNTL_CNTL5_MASK       32U
    #define RTC_CNTL_CNTL5_BITNUM     5
    #define RTC_CNTL_CNTL6_MASK       64U
    #define RTC_CNTL_CNTL6_BITNUM     6
    #define RTC_CNTL_CNTL7_MASK       128U
    #define RTC_CNTL_CNTL7_BITNUM     7
    
  } Overlap_STR;
} RTC_CNTSTR;
extern volatile RTC_CNTSTR _RTC_CNT @0x0000306E;
#define RTC_CNT                   _RTC_CNT.Word


/*** I2C_A1 I2C Address Register 1; 0x00003070 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte  AD0        : 1;
    byte  AD1        : 1;
    byte  AD2        : 1;
    byte  AD3        : 1;
    byte  AD4        : 1;
    byte  AD5        : 1;
    byte  AD6        : 1;
  } Bits;
  struct {
    byte             : 1;
    byte  grpAD      : 7;
  } MergedBits;
} I2C_A1STR;
extern volatile I2C_A1STR _I2C_A1 @0x00003070;
#define I2C_A1                    _I2C_A1.Byte
#define I2C_A1_AD0                _I2C_A1.Bits.AD0
#define I2C_A1_AD1                _I2C_A1.Bits.AD1
#define I2C_A1_AD2                _I2C_A1.Bits.AD2
#define I2C_A1_AD3                _I2C_A1.Bits.AD3
#define I2C_A1_AD4                _I2C_A1.Bits.AD4
#define I2C_A1_AD5                _I2C_A1.Bits.AD5
#define I2C_A1_AD6                _I2C_A1.Bits.AD6
#define I2C_A1_AD                 _I2C_A1.MergedBits.grpAD

#define I2C_A1_AD0_MASK           2U
#define I2C_A1_AD0_BITNUM         1
#define I2C_A1_AD1_MASK           4U
#define I2C_A1_AD1_BITNUM         2
#define I2C_A1_AD2_MASK           8U
#define I2C_A1_AD2_BITNUM         3
#define I2C_A1_AD3_MASK           16U
#define I2C_A1_AD3_BITNUM         4
#define I2C_A1_AD4_MASK           32U
#define I2C_A1_AD4_BITNUM         5
#define I2C_A1_AD5_MASK           64U
#define I2C_A1_AD5_BITNUM         6
#define I2C_A1_AD6_MASK           128U
#define I2C_A1_AD6_BITNUM         7
#define I2C_A1_AD_MASK            254U
#define I2C_A1_AD_BITNUM          1


/*** I2C_F I2C Frequency Divider register; 0x00003071 ***/
typedef union {
  byte Byte;
  struct {
    byte  ICR0       : 1;
    byte  ICR1       : 1;
    byte  ICR2       : 1;
    byte  ICR3       : 1;
    byte  ICR4       : 1;
    byte  ICR5       : 1;
    byte  MULT0      : 1;
    byte  MULT1      : 1;
  } Bits;
  struct {
    byte  grpICR     : 6;
    byte  grpMULT    : 2;
  } MergedBits;
} I2C_FSTR;
extern volatile I2C_FSTR _I2C_F @0x00003071;
#define I2C_F                     _I2C_F.Byte
#define I2C_F_ICR0                _I2C_F.Bits.ICR0
#define I2C_F_ICR1                _I2C_F.Bits.ICR1
#define I2C_F_ICR2                _I2C_F.Bits.ICR2
#define I2C_F_ICR3                _I2C_F.Bits.ICR3
#define I2C_F_ICR4                _I2C_F.Bits.ICR4
#define I2C_F_ICR5                _I2C_F.Bits.ICR5
#define I2C_F_MULT0               _I2C_F.Bits.MULT0
#define I2C_F_MULT1               _I2C_F.Bits.MULT1
#define I2C_F_ICR                 _I2C_F.MergedBits.grpICR
#define I2C_F_MULT                _I2C_F.MergedBits.grpMULT

#define I2C_F_ICR0_MASK           1U
#define I2C_F_ICR0_BITNUM         0
#define I2C_F_ICR1_MASK           2U
#define I2C_F_ICR1_BITNUM         1
#define I2C_F_ICR2_MASK           4U
#define I2C_F_ICR2_BITNUM         2
#define I2C_F_ICR3_MASK           8U
#define I2C_F_ICR3_BITNUM         3
#define I2C_F_ICR4_MASK           16U
#define I2C_F_ICR4_BITNUM         4
#define I2C_F_ICR5_MASK           32U
#define I2C_F_ICR5_BITNUM         5
#define I2C_F_MULT0_MASK          64U
#define I2C_F_MULT0_BITNUM        6
#define I2C_F_MULT1_MASK          128U
#define I2C_F_MULT1_BITNUM        7
#define I2C_F_ICR_MASK            63U
#define I2C_F_ICR_BITNUM          0
#define I2C_F_MULT_MASK           192U
#define I2C_F_MULT_BITNUM         6


/*** I2C_C1 I2C Control Register 1; 0x00003072 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte  WUEN       : 1;
    byte  RSTA       : 1;
    byte  TXAK       : 1;
    byte  TX         : 1;
    byte  MST        : 1;
    byte  IICIE      : 1;
    byte  IICEN      : 1;
  } Bits;
} I2C_C1STR;
extern volatile I2C_C1STR _I2C_C1 @0x00003072;
#define I2C_C1                    _I2C_C1.Byte
#define I2C_C1_WUEN               _I2C_C1.Bits.WUEN
#define I2C_C1_RSTA               _I2C_C1.Bits.RSTA
#define I2C_C1_TXAK               _I2C_C1.Bits.TXAK
#define I2C_C1_TX                 _I2C_C1.Bits.TX
#define I2C_C1_MST                _I2C_C1.Bits.MST
#define I2C_C1_IICIE              _I2C_C1.Bits.IICIE
#define I2C_C1_IICEN              _I2C_C1.Bits.IICEN

#define I2C_C1_WUEN_MASK          2U
#define I2C_C1_WUEN_BITNUM        1
#define I2C_C1_RSTA_MASK          4U
#define I2C_C1_RSTA_BITNUM        2
#define I2C_C1_TXAK_MASK          8U
#define I2C_C1_TXAK_BITNUM        3
#define I2C_C1_TX_MASK            16U
#define I2C_C1_TX_BITNUM          4
#define I2C_C1_MST_MASK           32U
#define I2C_C1_MST_BITNUM         5
#define I2C_C1_IICIE_MASK         64U
#define I2C_C1_IICIE_BITNUM       6
#define I2C_C1_IICEN_MASK         128U
#define I2C_C1_IICEN_BITNUM       7


/*** I2C_S I2C Status register; 0x00003073 ***/
typedef union {
  byte Byte;
  struct {
    byte  RXAK       : 1;
    byte  IICIF      : 1;
    byte  SRW        : 1;
    byte  RAM        : 1;
    byte  ARBL       : 1;
    byte  BUSY       : 1;
    byte  IAAS       : 1;
    byte  TCF        : 1;
  } Bits;
} I2C_SSTR;
extern volatile I2C_SSTR _I2C_S @0x00003073;
#define I2C_S                     _I2C_S.Byte
#define I2C_S_RXAK                _I2C_S.Bits.RXAK
#define I2C_S_IICIF               _I2C_S.Bits.IICIF
#define I2C_S_SRW                 _I2C_S.Bits.SRW
#define I2C_S_RAM                 _I2C_S.Bits.RAM
#define I2C_S_ARBL                _I2C_S.Bits.ARBL
#define I2C_S_BUSY                _I2C_S.Bits.BUSY
#define I2C_S_IAAS                _I2C_S.Bits.IAAS
#define I2C_S_TCF                 _I2C_S.Bits.TCF

#define I2C_S_RXAK_MASK           1U
#define I2C_S_RXAK_BITNUM         0
#define I2C_S_IICIF_MASK          2U
#define I2C_S_IICIF_BITNUM        1
#define I2C_S_SRW_MASK            4U
#define I2C_S_SRW_BITNUM          2
#define I2C_S_RAM_MASK            8U
#define I2C_S_RAM_BITNUM          3
#define I2C_S_ARBL_MASK           16U
#define I2C_S_ARBL_BITNUM         4
#define I2C_S_BUSY_MASK           32U
#define I2C_S_BUSY_BITNUM         5
#define I2C_S_IAAS_MASK           64U
#define I2C_S_IAAS_BITNUM         6
#define I2C_S_TCF_MASK            128U
#define I2C_S_TCF_BITNUM          7


/*** I2C_D I2C Data I/O register; 0x00003074 ***/
typedef union {
  byte Byte;
  struct {
    byte  DATA0      : 1;
    byte  DATA1      : 1;
    byte  DATA2      : 1;
    byte  DATA3      : 1;
    byte  DATA4      : 1;
    byte  DATA5      : 1;
    byte  DATA6      : 1;
    byte  DATA7      : 1;
  } Bits;
} I2C_DSTR;
extern volatile I2C_DSTR _I2C_D @0x00003074;
#define I2C_D                     _I2C_D.Byte
#define I2C_D_DATA0               _I2C_D.Bits.DATA0
#define I2C_D_DATA1               _I2C_D.Bits.DATA1
#define I2C_D_DATA2               _I2C_D.Bits.DATA2
#define I2C_D_DATA3               _I2C_D.Bits.DATA3
#define I2C_D_DATA4               _I2C_D.Bits.DATA4
#define I2C_D_DATA5               _I2C_D.Bits.DATA5
#define I2C_D_DATA6               _I2C_D.Bits.DATA6
#define I2C_D_DATA7               _I2C_D.Bits.DATA7

#define I2C_D_DATA0_MASK          1U
#define I2C_D_DATA0_BITNUM        0
#define I2C_D_DATA1_MASK          2U
#define I2C_D_DATA1_BITNUM        1
#define I2C_D_DATA2_MASK          4U
#define I2C_D_DATA2_BITNUM        2
#define I2C_D_DATA3_MASK          8U
#define I2C_D_DATA3_BITNUM        3
#define I2C_D_DATA4_MASK          16U
#define I2C_D_DATA4_BITNUM        4
#define I2C_D_DATA5_MASK          32U
#define I2C_D_DATA5_BITNUM        5
#define I2C_D_DATA6_MASK          64U
#define I2C_D_DATA6_BITNUM        6
#define I2C_D_DATA7_MASK          128U
#define I2C_D_DATA7_BITNUM        7


/*** I2C_C2 I2C Control Register 2; 0x00003075 ***/
typedef union {
  byte Byte;
  struct {
    byte  AD0        : 1;
    byte  AD1        : 1;
    byte  AD2        : 1;
    byte  RMEN       : 1;
    byte  SBRC       : 1;
    byte             : 1;
    byte  ADEXT      : 1;
    byte  GCAEN      : 1;
  } Bits;
  struct {
    byte  grpAD      : 3;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} I2C_C2STR;
extern volatile I2C_C2STR _I2C_C2 @0x00003075;
#define I2C_C2                    _I2C_C2.Byte
#define I2C_C2_AD0                _I2C_C2.Bits.AD0
#define I2C_C2_AD1                _I2C_C2.Bits.AD1
#define I2C_C2_AD2                _I2C_C2.Bits.AD2
#define I2C_C2_RMEN               _I2C_C2.Bits.RMEN
#define I2C_C2_SBRC               _I2C_C2.Bits.SBRC
#define I2C_C2_ADEXT              _I2C_C2.Bits.ADEXT
#define I2C_C2_GCAEN              _I2C_C2.Bits.GCAEN
#define I2C_C2_AD                 _I2C_C2.MergedBits.grpAD

#define I2C_C2_AD0_MASK           1U
#define I2C_C2_AD0_BITNUM         0
#define I2C_C2_AD1_MASK           2U
#define I2C_C2_AD1_BITNUM         1
#define I2C_C2_AD2_MASK           4U
#define I2C_C2_AD2_BITNUM         2
#define I2C_C2_RMEN_MASK          8U
#define I2C_C2_RMEN_BITNUM        3
#define I2C_C2_SBRC_MASK          16U
#define I2C_C2_SBRC_BITNUM        4
#define I2C_C2_ADEXT_MASK         64U
#define I2C_C2_ADEXT_BITNUM       6
#define I2C_C2_GCAEN_MASK         128U
#define I2C_C2_GCAEN_BITNUM       7
#define I2C_C2_AD_MASK            7U
#define I2C_C2_AD_BITNUM          0


/*** I2C_FLT I2C; 0x00003076 ***/
typedef union {
  byte Byte;
  struct {
    byte  FLT0       : 1;
    byte  FLT1       : 1;
    byte  FLT2       : 1;
    byte  FLT3       : 1;
    byte  STARTF     : 1;
    byte  SSIE       : 1;
    byte  STOPF      : 1;
    byte  SHEN       : 1;
  } Bits;
  struct {
    byte  grpFLT     : 4;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} I2C_FLTSTR;
extern volatile I2C_FLTSTR _I2C_FLT @0x00003076;
#define I2C_FLT                   _I2C_FLT.Byte
#define I2C_FLT_FLT0              _I2C_FLT.Bits.FLT0
#define I2C_FLT_FLT1              _I2C_FLT.Bits.FLT1
#define I2C_FLT_FLT2              _I2C_FLT.Bits.FLT2
#define I2C_FLT_FLT3              _I2C_FLT.Bits.FLT3
#define I2C_FLT_STARTF            _I2C_FLT.Bits.STARTF
#define I2C_FLT_SSIE              _I2C_FLT.Bits.SSIE
#define I2C_FLT_STOPF             _I2C_FLT.Bits.STOPF
#define I2C_FLT_SHEN              _I2C_FLT.Bits.SHEN
#define I2C_FLT_FLT               _I2C_FLT.MergedBits.grpFLT

#define I2C_FLT_FLT0_MASK         1U
#define I2C_FLT_FLT0_BITNUM       0
#define I2C_FLT_FLT1_MASK         2U
#define I2C_FLT_FLT1_BITNUM       1
#define I2C_FLT_FLT2_MASK         4U
#define I2C_FLT_FLT2_BITNUM       2
#define I2C_FLT_FLT3_MASK         8U
#define I2C_FLT_FLT3_BITNUM       3
#define I2C_FLT_STARTF_MASK       16U
#define I2C_FLT_STARTF_BITNUM     4
#define I2C_FLT_SSIE_MASK         32U
#define I2C_FLT_SSIE_BITNUM       5
#define I2C_FLT_STOPF_MASK        64U
#define I2C_FLT_STOPF_BITNUM      6
#define I2C_FLT_SHEN_MASK         128U
#define I2C_FLT_SHEN_BITNUM       7
#define I2C_FLT_FLT_MASK          15U
#define I2C_FLT_FLT_BITNUM        0


/*** I2C_RA I2C Range Address register; 0x00003077 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte  RAD0       : 1;
    byte  RAD1       : 1;
    byte  RAD2       : 1;
    byte  RAD3       : 1;
    byte  RAD4       : 1;
    byte  RAD5       : 1;
    byte  RAD6       : 1;
  } Bits;
  struct {
    byte             : 1;
    byte  grpRAD     : 7;
  } MergedBits;
} I2C_RASTR;
extern volatile I2C_RASTR _I2C_RA @0x00003077;
#define I2C_RA                    _I2C_RA.Byte
#define I2C_RA_RAD0               _I2C_RA.Bits.RAD0
#define I2C_RA_RAD1               _I2C_RA.Bits.RAD1
#define I2C_RA_RAD2               _I2C_RA.Bits.RAD2
#define I2C_RA_RAD3               _I2C_RA.Bits.RAD3
#define I2C_RA_RAD4               _I2C_RA.Bits.RAD4
#define I2C_RA_RAD5               _I2C_RA.Bits.RAD5
#define I2C_RA_RAD6               _I2C_RA.Bits.RAD6
#define I2C_RA_RAD                _I2C_RA.MergedBits.grpRAD

#define I2C_RA_RAD0_MASK          2U
#define I2C_RA_RAD0_BITNUM        1
#define I2C_RA_RAD1_MASK          4U
#define I2C_RA_RAD1_BITNUM        2
#define I2C_RA_RAD2_MASK          8U
#define I2C_RA_RAD2_BITNUM        3
#define I2C_RA_RAD3_MASK          16U
#define I2C_RA_RAD3_BITNUM        4
#define I2C_RA_RAD4_MASK          32U
#define I2C_RA_RAD4_BITNUM        5
#define I2C_RA_RAD5_MASK          64U
#define I2C_RA_RAD5_BITNUM        6
#define I2C_RA_RAD6_MASK          128U
#define I2C_RA_RAD6_BITNUM        7
#define I2C_RA_RAD_MASK           254U
#define I2C_RA_RAD_BITNUM         1


/*** I2C_SMB I2C SMBus Control and Status register; 0x00003078 ***/
typedef union {
  byte Byte;
  struct {
    byte  SHTF2IE    : 1;
    byte  SHTF2      : 1;
    byte  SHTF1      : 1;
    byte  SLTF       : 1;
    byte  TCKSEL     : 1;
    byte  SIICAEN    : 1;
    byte  ALERTEN    : 1;
    byte  FACK       : 1;
  } Bits;
  struct {
    byte             : 1;
    byte  grpSHTF    : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} I2C_SMBSTR;
extern volatile I2C_SMBSTR _I2C_SMB @0x00003078;
#define I2C_SMB                   _I2C_SMB.Byte
#define I2C_SMB_SHTF2IE           _I2C_SMB.Bits.SHTF2IE
#define I2C_SMB_SHTF2             _I2C_SMB.Bits.SHTF2
#define I2C_SMB_SHTF1             _I2C_SMB.Bits.SHTF1
#define I2C_SMB_SLTF              _I2C_SMB.Bits.SLTF
#define I2C_SMB_TCKSEL            _I2C_SMB.Bits.TCKSEL
#define I2C_SMB_SIICAEN           _I2C_SMB.Bits.SIICAEN
#define I2C_SMB_ALERTEN           _I2C_SMB.Bits.ALERTEN
#define I2C_SMB_FACK              _I2C_SMB.Bits.FACK
#define I2C_SMB_SHTF              _I2C_SMB.MergedBits.grpSHTF

#define I2C_SMB_SHTF2IE_MASK      1U
#define I2C_SMB_SHTF2IE_BITNUM    0
#define I2C_SMB_SHTF2_MASK        2U
#define I2C_SMB_SHTF2_BITNUM      1
#define I2C_SMB_SHTF1_MASK        4U
#define I2C_SMB_SHTF1_BITNUM      2
#define I2C_SMB_SLTF_MASK         8U
#define I2C_SMB_SLTF_BITNUM       3
#define I2C_SMB_TCKSEL_MASK       16U
#define I2C_SMB_TCKSEL_BITNUM     4
#define I2C_SMB_SIICAEN_MASK      32U
#define I2C_SMB_SIICAEN_BITNUM    5
#define I2C_SMB_ALERTEN_MASK      64U
#define I2C_SMB_ALERTEN_BITNUM    6
#define I2C_SMB_FACK_MASK         128U
#define I2C_SMB_FACK_BITNUM       7
#define I2C_SMB_SHTF_MASK         6U
#define I2C_SMB_SHTF_BITNUM       1


/*** I2C_A2 I2C Address Register 2; 0x00003079 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte  SAD0       : 1;
    byte  SAD1       : 1;
    byte  SAD2       : 1;
    byte  SAD3       : 1;
    byte  SAD4       : 1;
    byte  SAD5       : 1;
    byte  SAD6       : 1;
  } Bits;
  struct {
    byte             : 1;
    byte  grpSAD     : 7;
  } MergedBits;
} I2C_A2STR;
extern volatile I2C_A2STR _I2C_A2 @0x00003079;
#define I2C_A2                    _I2C_A2.Byte
#define I2C_A2_SAD0               _I2C_A2.Bits.SAD0
#define I2C_A2_SAD1               _I2C_A2.Bits.SAD1
#define I2C_A2_SAD2               _I2C_A2.Bits.SAD2
#define I2C_A2_SAD3               _I2C_A2.Bits.SAD3
#define I2C_A2_SAD4               _I2C_A2.Bits.SAD4
#define I2C_A2_SAD5               _I2C_A2.Bits.SAD5
#define I2C_A2_SAD6               _I2C_A2.Bits.SAD6
#define I2C_A2_SAD                _I2C_A2.MergedBits.grpSAD

#define I2C_A2_SAD0_MASK          2U
#define I2C_A2_SAD0_BITNUM        1
#define I2C_A2_SAD1_MASK          4U
#define I2C_A2_SAD1_BITNUM        2
#define I2C_A2_SAD2_MASK          8U
#define I2C_A2_SAD2_BITNUM        3
#define I2C_A2_SAD3_MASK          16U
#define I2C_A2_SAD3_BITNUM        4
#define I2C_A2_SAD4_MASK          32U
#define I2C_A2_SAD4_BITNUM        5
#define I2C_A2_SAD5_MASK          64U
#define I2C_A2_SAD5_BITNUM        6
#define I2C_A2_SAD6_MASK          128U
#define I2C_A2_SAD6_BITNUM        7
#define I2C_A2_SAD_MASK           254U
#define I2C_A2_SAD_BITNUM         1


/*** I2C_SLT I2C SCL Low Timeout Register  0x0000307A ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** I2C_SLTH I2C SCL Low Timeout Register High; 0x0000307A ***/
    union {
      byte Byte;
      struct {
        byte  SSLT0      : 1;
        byte  SSLT1      : 1;
        byte  SSLT2      : 1;
        byte  SSLT3      : 1;
        byte  SSLT4      : 1;
        byte  SSLT5      : 1;
        byte  SSLT6      : 1;
        byte  SSLT7      : 1;
      } Bits;
    } I2C_SLTHSTR;
    #define I2C_SLTH                  _I2C_SLT.Overlap_STR.I2C_SLTHSTR.Byte
    #define I2C_SLTH_SSLT0            _I2C_SLT.Overlap_STR.I2C_SLTHSTR.Bits.SSLT0
    #define I2C_SLTH_SSLT1            _I2C_SLT.Overlap_STR.I2C_SLTHSTR.Bits.SSLT1
    #define I2C_SLTH_SSLT2            _I2C_SLT.Overlap_STR.I2C_SLTHSTR.Bits.SSLT2
    #define I2C_SLTH_SSLT3            _I2C_SLT.Overlap_STR.I2C_SLTHSTR.Bits.SSLT3
    #define I2C_SLTH_SSLT4            _I2C_SLT.Overlap_STR.I2C_SLTHSTR.Bits.SSLT4
    #define I2C_SLTH_SSLT5            _I2C_SLT.Overlap_STR.I2C_SLTHSTR.Bits.SSLT5
    #define I2C_SLTH_SSLT6            _I2C_SLT.Overlap_STR.I2C_SLTHSTR.Bits.SSLT6
    #define I2C_SLTH_SSLT7            _I2C_SLT.Overlap_STR.I2C_SLTHSTR.Bits.SSLT7
    
    #define I2C_SLTH_SSLT0_MASK       1U
    #define I2C_SLTH_SSLT0_BITNUM     0
    #define I2C_SLTH_SSLT1_MASK       2U
    #define I2C_SLTH_SSLT1_BITNUM     1
    #define I2C_SLTH_SSLT2_MASK       4U
    #define I2C_SLTH_SSLT2_BITNUM     2
    #define I2C_SLTH_SSLT3_MASK       8U
    #define I2C_SLTH_SSLT3_BITNUM     3
    #define I2C_SLTH_SSLT4_MASK       16U
    #define I2C_SLTH_SSLT4_BITNUM     4
    #define I2C_SLTH_SSLT5_MASK       32U
    #define I2C_SLTH_SSLT5_BITNUM     5
    #define I2C_SLTH_SSLT6_MASK       64U
    #define I2C_SLTH_SSLT6_BITNUM     6
    #define I2C_SLTH_SSLT7_MASK       128U
    #define I2C_SLTH_SSLT7_BITNUM     7
    
    /*** I2C_SLTL I2C SCL Low Timeout Register Low; 0x0000307B ***/
    union {
      byte Byte;
      struct {
        byte  SSLT0      : 1;
        byte  SSLT1      : 1;
        byte  SSLT2      : 1;
        byte  SSLT3      : 1;
        byte  SSLT4      : 1;
        byte  SSLT5      : 1;
        byte  SSLT6      : 1;
        byte  SSLT7      : 1;
      } Bits;
    } I2C_SLTLSTR;
    #define I2C_SLTL                  _I2C_SLT.Overlap_STR.I2C_SLTLSTR.Byte
    #define I2C_SLTL_SSLT0            _I2C_SLT.Overlap_STR.I2C_SLTLSTR.Bits.SSLT0
    #define I2C_SLTL_SSLT1            _I2C_SLT.Overlap_STR.I2C_SLTLSTR.Bits.SSLT1
    #define I2C_SLTL_SSLT2            _I2C_SLT.Overlap_STR.I2C_SLTLSTR.Bits.SSLT2
    #define I2C_SLTL_SSLT3            _I2C_SLT.Overlap_STR.I2C_SLTLSTR.Bits.SSLT3
    #define I2C_SLTL_SSLT4            _I2C_SLT.Overlap_STR.I2C_SLTLSTR.Bits.SSLT4
    #define I2C_SLTL_SSLT5            _I2C_SLT.Overlap_STR.I2C_SLTLSTR.Bits.SSLT5
    #define I2C_SLTL_SSLT6            _I2C_SLT.Overlap_STR.I2C_SLTLSTR.Bits.SSLT6
    #define I2C_SLTL_SSLT7            _I2C_SLT.Overlap_STR.I2C_SLTLSTR.Bits.SSLT7
    
    #define I2C_SLTL_SSLT0_MASK       1U
    #define I2C_SLTL_SSLT0_BITNUM     0
    #define I2C_SLTL_SSLT1_MASK       2U
    #define I2C_SLTL_SSLT1_BITNUM     1
    #define I2C_SLTL_SSLT2_MASK       4U
    #define I2C_SLTL_SSLT2_BITNUM     2
    #define I2C_SLTL_SSLT3_MASK       8U
    #define I2C_SLTL_SSLT3_BITNUM     3
    #define I2C_SLTL_SSLT4_MASK       16U
    #define I2C_SLTL_SSLT4_BITNUM     4
    #define I2C_SLTL_SSLT5_MASK       32U
    #define I2C_SLTL_SSLT5_BITNUM     5
    #define I2C_SLTL_SSLT6_MASK       64U
    #define I2C_SLTL_SSLT6_BITNUM     6
    #define I2C_SLTL_SSLT7_MASK       128U
    #define I2C_SLTL_SSLT7_BITNUM     7
    
  } Overlap_STR;
} I2C_SLTSTR;
extern volatile I2C_SLTSTR _I2C_SLT @0x0000307A;
#define I2C_SLT                   _I2C_SLT.Word


/*** KBI0_PE KBI Pin Enable Register; 0x0000307C ***/
typedef union {
  byte Byte;
  struct {
    byte  KBIPE0     : 1;
    byte  KBIPE1     : 1;
    byte  KBIPE2     : 1;
    byte  KBIPE3     : 1;
    byte  KBIPE4     : 1;
    byte  KBIPE5     : 1;
    byte  KBIPE6     : 1;
    byte  KBIPE7     : 1;
  } Bits;
} KBI0_PESTR;
extern volatile KBI0_PESTR _KBI0_PE @0x0000307C;
#define KBI0_PE                   _KBI0_PE.Byte
#define KBI0_PE_KBIPE0            _KBI0_PE.Bits.KBIPE0
#define KBI0_PE_KBIPE1            _KBI0_PE.Bits.KBIPE1
#define KBI0_PE_KBIPE2            _KBI0_PE.Bits.KBIPE2
#define KBI0_PE_KBIPE3            _KBI0_PE.Bits.KBIPE3
#define KBI0_PE_KBIPE4            _KBI0_PE.Bits.KBIPE4
#define KBI0_PE_KBIPE5            _KBI0_PE.Bits.KBIPE5
#define KBI0_PE_KBIPE6            _KBI0_PE.Bits.KBIPE6
#define KBI0_PE_KBIPE7            _KBI0_PE.Bits.KBIPE7

#define KBI0_PE_KBIPE0_MASK       1U
#define KBI0_PE_KBIPE0_BITNUM     0
#define KBI0_PE_KBIPE1_MASK       2U
#define KBI0_PE_KBIPE1_BITNUM     1
#define KBI0_PE_KBIPE2_MASK       4U
#define KBI0_PE_KBIPE2_BITNUM     2
#define KBI0_PE_KBIPE3_MASK       8U
#define KBI0_PE_KBIPE3_BITNUM     3
#define KBI0_PE_KBIPE4_MASK       16U
#define KBI0_PE_KBIPE4_BITNUM     4
#define KBI0_PE_KBIPE5_MASK       32U
#define KBI0_PE_KBIPE5_BITNUM     5
#define KBI0_PE_KBIPE6_MASK       64U
#define KBI0_PE_KBIPE6_BITNUM     6
#define KBI0_PE_KBIPE7_MASK       128U
#define KBI0_PE_KBIPE7_BITNUM     7


/*** KBI0_ES KBI Edge Select Register; 0x0000307D ***/
typedef union {
  byte Byte;
  struct {
    byte  KBEDG0     : 1;
    byte  KBEDG1     : 1;
    byte  KBEDG2     : 1;
    byte  KBEDG3     : 1;
    byte  KBEDG4     : 1;
    byte  KBEDG5     : 1;
    byte  KBEDG6     : 1;
    byte  KBEDG7     : 1;
  } Bits;
} KBI0_ESSTR;
extern volatile KBI0_ESSTR _KBI0_ES @0x0000307D;
#define KBI0_ES                   _KBI0_ES.Byte
#define KBI0_ES_KBEDG0            _KBI0_ES.Bits.KBEDG0
#define KBI0_ES_KBEDG1            _KBI0_ES.Bits.KBEDG1
#define KBI0_ES_KBEDG2            _KBI0_ES.Bits.KBEDG2
#define KBI0_ES_KBEDG3            _KBI0_ES.Bits.KBEDG3
#define KBI0_ES_KBEDG4            _KBI0_ES.Bits.KBEDG4
#define KBI0_ES_KBEDG5            _KBI0_ES.Bits.KBEDG5
#define KBI0_ES_KBEDG6            _KBI0_ES.Bits.KBEDG6
#define KBI0_ES_KBEDG7            _KBI0_ES.Bits.KBEDG7

#define KBI0_ES_KBEDG0_MASK       1U
#define KBI0_ES_KBEDG0_BITNUM     0
#define KBI0_ES_KBEDG1_MASK       2U
#define KBI0_ES_KBEDG1_BITNUM     1
#define KBI0_ES_KBEDG2_MASK       4U
#define KBI0_ES_KBEDG2_BITNUM     2
#define KBI0_ES_KBEDG3_MASK       8U
#define KBI0_ES_KBEDG3_BITNUM     3
#define KBI0_ES_KBEDG4_MASK       16U
#define KBI0_ES_KBEDG4_BITNUM     4
#define KBI0_ES_KBEDG5_MASK       32U
#define KBI0_ES_KBEDG5_BITNUM     5
#define KBI0_ES_KBEDG6_MASK       64U
#define KBI0_ES_KBEDG6_BITNUM     6
#define KBI0_ES_KBEDG7_MASK       128U
#define KBI0_ES_KBEDG7_BITNUM     7


/*** SCI0_BD SCI; 0x00003080 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** SCI0_BDH SCI; 0x00003080 ***/
    union {
      byte Byte;
      struct {
        byte  SBR0       : 1;
        byte  SBR1       : 1;
        byte  SBR2       : 1;
        byte  SBR3       : 1;
        byte  SBR4       : 1;
        byte  SBNS       : 1;
        byte  RXEDGIE    : 1;
        byte  LBKDIE     : 1;
      } Bits;
      struct {
        byte  grpSBR     : 5;
        byte             : 1;
        byte             : 1;
        byte             : 1;
      } MergedBits;
    } SCI0_BDHSTR;
    #define SCI0_BDH                  _SCI0_BD.Overlap_STR.SCI0_BDHSTR.Byte
    #define SCI0_BDH_SBR0             _SCI0_BD.Overlap_STR.SCI0_BDHSTR.Bits.SBR0
    #define SCI0_BDH_SBR1             _SCI0_BD.Overlap_STR.SCI0_BDHSTR.Bits.SBR1
    #define SCI0_BDH_SBR2             _SCI0_BD.Overlap_STR.SCI0_BDHSTR.Bits.SBR2
    #define SCI0_BDH_SBR3             _SCI0_BD.Overlap_STR.SCI0_BDHSTR.Bits.SBR3
    #define SCI0_BDH_SBR4             _SCI0_BD.Overlap_STR.SCI0_BDHSTR.Bits.SBR4
    #define SCI0_BDH_SBNS             _SCI0_BD.Overlap_STR.SCI0_BDHSTR.Bits.SBNS
    #define SCI0_BDH_RXEDGIE          _SCI0_BD.Overlap_STR.SCI0_BDHSTR.Bits.RXEDGIE
    #define SCI0_BDH_LBKDIE           _SCI0_BD.Overlap_STR.SCI0_BDHSTR.Bits.LBKDIE
    #define SCI0_BDH_SBR              _SCI0_BD.Overlap_STR.SCI0_BDHSTR.MergedBits.grpSBR
    
    #define SCI0_BDH_SBR0_MASK        1U
    #define SCI0_BDH_SBR0_BITNUM      0
    #define SCI0_BDH_SBR1_MASK        2U
    #define SCI0_BDH_SBR1_BITNUM      1
    #define SCI0_BDH_SBR2_MASK        4U
    #define SCI0_BDH_SBR2_BITNUM      2
    #define SCI0_BDH_SBR3_MASK        8U
    #define SCI0_BDH_SBR3_BITNUM      3
    #define SCI0_BDH_SBR4_MASK        16U
    #define SCI0_BDH_SBR4_BITNUM      4
    #define SCI0_BDH_SBNS_MASK        32U
    #define SCI0_BDH_SBNS_BITNUM      5
    #define SCI0_BDH_RXEDGIE_MASK     64U
    #define SCI0_BDH_RXEDGIE_BITNUM   6
    #define SCI0_BDH_LBKDIE_MASK      128U
    #define SCI0_BDH_LBKDIE_BITNUM    7
    #define SCI0_BDH_SBR_MASK         31U
    #define SCI0_BDH_SBR_BITNUM       0
    
    /*** SCI0_BDL SCI; 0x00003081 ***/
    union {
      byte Byte;
      struct {
        byte  SBR0       : 1;
        byte  SBR1       : 1;
        byte  SBR2       : 1;
        byte  SBR3       : 1;
        byte  SBR4       : 1;
        byte  SBR5       : 1;
        byte  SBR6       : 1;
        byte  SBR7       : 1;
      } Bits;
    } SCI0_BDLSTR;
    #define SCI0_BDL                  _SCI0_BD.Overlap_STR.SCI0_BDLSTR.Byte
    #define SCI0_BDL_SBR0             _SCI0_BD.Overlap_STR.SCI0_BDLSTR.Bits.SBR0
    #define SCI0_BDL_SBR1             _SCI0_BD.Overlap_STR.SCI0_BDLSTR.Bits.SBR1
    #define SCI0_BDL_SBR2             _SCI0_BD.Overlap_STR.SCI0_BDLSTR.Bits.SBR2
    #define SCI0_BDL_SBR3             _SCI0_BD.Overlap_STR.SCI0_BDLSTR.Bits.SBR3
    #define SCI0_BDL_SBR4             _SCI0_BD.Overlap_STR.SCI0_BDLSTR.Bits.SBR4
    #define SCI0_BDL_SBR5             _SCI0_BD.Overlap_STR.SCI0_BDLSTR.Bits.SBR5
    #define SCI0_BDL_SBR6             _SCI0_BD.Overlap_STR.SCI0_BDLSTR.Bits.SBR6
    #define SCI0_BDL_SBR7             _SCI0_BD.Overlap_STR.SCI0_BDLSTR.Bits.SBR7
    
    #define SCI0_BDL_SBR0_MASK        1U
    #define SCI0_BDL_SBR0_BITNUM      0
    #define SCI0_BDL_SBR1_MASK        2U
    #define SCI0_BDL_SBR1_BITNUM      1
    #define SCI0_BDL_SBR2_MASK        4U
    #define SCI0_BDL_SBR2_BITNUM      2
    #define SCI0_BDL_SBR3_MASK        8U
    #define SCI0_BDL_SBR3_BITNUM      3
    #define SCI0_BDL_SBR4_MASK        16U
    #define SCI0_BDL_SBR4_BITNUM      4
    #define SCI0_BDL_SBR5_MASK        32U
    #define SCI0_BDL_SBR5_BITNUM      5
    #define SCI0_BDL_SBR6_MASK        64U
    #define SCI0_BDL_SBR6_BITNUM      6
    #define SCI0_BDL_SBR7_MASK        128U
    #define SCI0_BDL_SBR7_BITNUM      7
    
  } Overlap_STR;
} SCI0_BDSTR;
extern volatile SCI0_BDSTR _SCI0_BD @0x00003080;
#define SCI0_BD                   _SCI0_BD.Word


/*** SCI0_C1 SCI; 0x00003082 ***/
typedef union {
  byte Byte;
  struct {
    byte  PT         : 1;
    byte  PE         : 1;
    byte  ILT        : 1;
    byte  WAKE       : 1;
    byte  M          : 1;
    byte  RSRC       : 1;
    byte  SCISWAI    : 1;
    byte  LOOPS      : 1;
  } Bits;
} SCI0_C1STR;
extern volatile SCI0_C1STR _SCI0_C1 @0x00003082;
#define SCI0_C1                   _SCI0_C1.Byte
#define SCI0_C1_PT                _SCI0_C1.Bits.PT
#define SCI0_C1_PE                _SCI0_C1.Bits.PE
#define SCI0_C1_ILT               _SCI0_C1.Bits.ILT
#define SCI0_C1_WAKE              _SCI0_C1.Bits.WAKE
#define SCI0_C1_M                 _SCI0_C1.Bits.M
#define SCI0_C1_RSRC              _SCI0_C1.Bits.RSRC
#define SCI0_C1_SCISWAI           _SCI0_C1.Bits.SCISWAI
#define SCI0_C1_LOOPS             _SCI0_C1.Bits.LOOPS

#define SCI0_C1_PT_MASK           1U
#define SCI0_C1_PT_BITNUM         0
#define SCI0_C1_PE_MASK           2U
#define SCI0_C1_PE_BITNUM         1
#define SCI0_C1_ILT_MASK          4U
#define SCI0_C1_ILT_BITNUM        2
#define SCI0_C1_WAKE_MASK         8U
#define SCI0_C1_WAKE_BITNUM       3
#define SCI0_C1_M_MASK            16U
#define SCI0_C1_M_BITNUM          4
#define SCI0_C1_RSRC_MASK         32U
#define SCI0_C1_RSRC_BITNUM       5
#define SCI0_C1_SCISWAI_MASK      64U
#define SCI0_C1_SCISWAI_BITNUM    6
#define SCI0_C1_LOOPS_MASK        128U
#define SCI0_C1_LOOPS_BITNUM      7


/*** SCI0_C2 SCI; 0x00003083 ***/
typedef union {
  byte Byte;
  struct {
    byte  SBK        : 1;
    byte  RWU        : 1;
    byte  RE         : 1;
    byte  TE         : 1;
    byte  ILIE       : 1;
    byte  RIE        : 1;
    byte  TCIE       : 1;
    byte  TIE        : 1;
  } Bits;
} SCI0_C2STR;
extern volatile SCI0_C2STR _SCI0_C2 @0x00003083;
#define SCI0_C2                   _SCI0_C2.Byte
#define SCI0_C2_SBK               _SCI0_C2.Bits.SBK
#define SCI0_C2_RWU               _SCI0_C2.Bits.RWU
#define SCI0_C2_RE                _SCI0_C2.Bits.RE
#define SCI0_C2_TE                _SCI0_C2.Bits.TE
#define SCI0_C2_ILIE              _SCI0_C2.Bits.ILIE
#define SCI0_C2_RIE               _SCI0_C2.Bits.RIE
#define SCI0_C2_TCIE              _SCI0_C2.Bits.TCIE
#define SCI0_C2_TIE               _SCI0_C2.Bits.TIE

#define SCI0_C2_SBK_MASK          1U
#define SCI0_C2_SBK_BITNUM        0
#define SCI0_C2_RWU_MASK          2U
#define SCI0_C2_RWU_BITNUM        1
#define SCI0_C2_RE_MASK           4U
#define SCI0_C2_RE_BITNUM         2
#define SCI0_C2_TE_MASK           8U
#define SCI0_C2_TE_BITNUM         3
#define SCI0_C2_ILIE_MASK         16U
#define SCI0_C2_ILIE_BITNUM       4
#define SCI0_C2_RIE_MASK          32U
#define SCI0_C2_RIE_BITNUM        5
#define SCI0_C2_TCIE_MASK         64U
#define SCI0_C2_TCIE_BITNUM       6
#define SCI0_C2_TIE_MASK          128U
#define SCI0_C2_TIE_BITNUM        7


/*** SCI0_S1 SCI; 0x00003084 ***/
typedef union {
  byte Byte;
  struct {
    byte  PF         : 1;
    byte  FE         : 1;
    byte  NF         : 1;
    byte  OR         : 1;
    byte  IDLE       : 1;
    byte  RDRF       : 1;
    byte  TC         : 1;
    byte  TDRE       : 1;
  } Bits;
} SCI0_S1STR;
extern volatile SCI0_S1STR _SCI0_S1 @0x00003084;
#define SCI0_S1                   _SCI0_S1.Byte
#define SCI0_S1_PF                _SCI0_S1.Bits.PF
#define SCI0_S1_FE                _SCI0_S1.Bits.FE
#define SCI0_S1_NF                _SCI0_S1.Bits.NF
#define SCI0_S1_OR                _SCI0_S1.Bits.OR
#define SCI0_S1_IDLE              _SCI0_S1.Bits.IDLE
#define SCI0_S1_RDRF              _SCI0_S1.Bits.RDRF
#define SCI0_S1_TC                _SCI0_S1.Bits.TC
#define SCI0_S1_TDRE              _SCI0_S1.Bits.TDRE

#define SCI0_S1_PF_MASK           1U
#define SCI0_S1_PF_BITNUM         0
#define SCI0_S1_FE_MASK           2U
#define SCI0_S1_FE_BITNUM         1
#define SCI0_S1_NF_MASK           4U
#define SCI0_S1_NF_BITNUM         2
#define SCI0_S1_OR_MASK           8U
#define SCI0_S1_OR_BITNUM         3
#define SCI0_S1_IDLE_MASK         16U
#define SCI0_S1_IDLE_BITNUM       4
#define SCI0_S1_RDRF_MASK         32U
#define SCI0_S1_RDRF_BITNUM       5
#define SCI0_S1_TC_MASK           64U
#define SCI0_S1_TC_BITNUM         6
#define SCI0_S1_TDRE_MASK         128U
#define SCI0_S1_TDRE_BITNUM       7


/*** SCI0_S2 SCI; 0x00003085 ***/
typedef union {
  byte Byte;
  struct {
    byte  RAF        : 1;
    byte  LBKDE      : 1;
    byte  BRK13      : 1;
    byte  RWUID      : 1;
    byte  RXINV      : 1;
    byte             : 1;
    byte  RXEDGIF    : 1;
    byte  LBKDIF     : 1;
  } Bits;
} SCI0_S2STR;
extern volatile SCI0_S2STR _SCI0_S2 @0x00003085;
#define SCI0_S2                   _SCI0_S2.Byte
#define SCI0_S2_RAF               _SCI0_S2.Bits.RAF
#define SCI0_S2_LBKDE             _SCI0_S2.Bits.LBKDE
#define SCI0_S2_BRK13             _SCI0_S2.Bits.BRK13
#define SCI0_S2_RWUID             _SCI0_S2.Bits.RWUID
#define SCI0_S2_RXINV             _SCI0_S2.Bits.RXINV
#define SCI0_S2_RXEDGIF           _SCI0_S2.Bits.RXEDGIF
#define SCI0_S2_LBKDIF            _SCI0_S2.Bits.LBKDIF

#define SCI0_S2_RAF_MASK          1U
#define SCI0_S2_RAF_BITNUM        0
#define SCI0_S2_LBKDE_MASK        2U
#define SCI0_S2_LBKDE_BITNUM      1
#define SCI0_S2_BRK13_MASK        4U
#define SCI0_S2_BRK13_BITNUM      2
#define SCI0_S2_RWUID_MASK        8U
#define SCI0_S2_RWUID_BITNUM      3
#define SCI0_S2_RXINV_MASK        16U
#define SCI0_S2_RXINV_BITNUM      4
#define SCI0_S2_RXEDGIF_MASK      64U
#define SCI0_S2_RXEDGIF_BITNUM    6
#define SCI0_S2_LBKDIF_MASK       128U
#define SCI0_S2_LBKDIF_BITNUM     7


/*** SCI0_C3 SCI; 0x00003086 ***/
typedef union {
  byte Byte;
  struct {
    byte  PEIE       : 1;
    byte  FEIE       : 1;
    byte  NEIE       : 1;
    byte  ORIE       : 1;
    byte  TXINV      : 1;
    byte  TXDIR      : 1;
    byte  T8         : 1;
    byte  R8         : 1;
  } Bits;
} SCI0_C3STR;
extern volatile SCI0_C3STR _SCI0_C3 @0x00003086;
#define SCI0_C3                   _SCI0_C3.Byte
#define SCI0_C3_PEIE              _SCI0_C3.Bits.PEIE
#define SCI0_C3_FEIE              _SCI0_C3.Bits.FEIE
#define SCI0_C3_NEIE              _SCI0_C3.Bits.NEIE
#define SCI0_C3_ORIE              _SCI0_C3.Bits.ORIE
#define SCI0_C3_TXINV             _SCI0_C3.Bits.TXINV
#define SCI0_C3_TXDIR             _SCI0_C3.Bits.TXDIR
#define SCI0_C3_T8                _SCI0_C3.Bits.T8
#define SCI0_C3_R8                _SCI0_C3.Bits.R8

#define SCI0_C3_PEIE_MASK         1U
#define SCI0_C3_PEIE_BITNUM       0
#define SCI0_C3_FEIE_MASK         2U
#define SCI0_C3_FEIE_BITNUM       1
#define SCI0_C3_NEIE_MASK         4U
#define SCI0_C3_NEIE_BITNUM       2
#define SCI0_C3_ORIE_MASK         8U
#define SCI0_C3_ORIE_BITNUM       3
#define SCI0_C3_TXINV_MASK        16U
#define SCI0_C3_TXINV_BITNUM      4
#define SCI0_C3_TXDIR_MASK        32U
#define SCI0_C3_TXDIR_BITNUM      5
#define SCI0_C3_T8_MASK           64U
#define SCI0_C3_T8_BITNUM         6
#define SCI0_C3_R8_MASK           128U
#define SCI0_C3_R8_BITNUM         7


/*** SCI0_D SCI; 0x00003087 ***/
typedef union {
  byte Byte;
  struct {
    byte  R0T0       : 1;
    byte  R1T1       : 1;
    byte  R2T2       : 1;
    byte  R3T3       : 1;
    byte  R4T4       : 1;
    byte  R5T5       : 1;
    byte  R6T6       : 1;
    byte  R7T7       : 1;
  } Bits;
} SCI0_DSTR;
extern volatile SCI0_DSTR _SCI0_D @0x00003087;
#define SCI0_D                    _SCI0_D.Byte
#define SCI0_D_R0T0               _SCI0_D.Bits.R0T0
#define SCI0_D_R1T1               _SCI0_D.Bits.R1T1
#define SCI0_D_R2T2               _SCI0_D.Bits.R2T2
#define SCI0_D_R3T3               _SCI0_D.Bits.R3T3
#define SCI0_D_R4T4               _SCI0_D.Bits.R4T4
#define SCI0_D_R5T5               _SCI0_D.Bits.R5T5
#define SCI0_D_R6T6               _SCI0_D.Bits.R6T6
#define SCI0_D_R7T7               _SCI0_D.Bits.R7T7

#define SCI0_D_R0T0_MASK          1U
#define SCI0_D_R0T0_BITNUM        0
#define SCI0_D_R1T1_MASK          2U
#define SCI0_D_R1T1_BITNUM        1
#define SCI0_D_R2T2_MASK          4U
#define SCI0_D_R2T2_BITNUM        2
#define SCI0_D_R3T3_MASK          8U
#define SCI0_D_R3T3_BITNUM        3
#define SCI0_D_R4T4_MASK          16U
#define SCI0_D_R4T4_BITNUM        4
#define SCI0_D_R5T5_MASK          32U
#define SCI0_D_R5T5_BITNUM        5
#define SCI0_D_R6T6_MASK          64U
#define SCI0_D_R6T6_BITNUM        6
#define SCI0_D_R7T7_MASK          128U
#define SCI0_D_R7T7_BITNUM        7


/*** ADC_APCTL1 Pin Control 1 Register; 0x000030AC ***/
typedef union {
  byte Byte;
  struct {
    byte  ADPC0      : 1;
    byte  ADPC1      : 1;
    byte  ADPC2      : 1;
    byte  ADPC3      : 1;
    byte  ADPC4      : 1;
    byte  ADPC5      : 1;
    byte  ADPC6      : 1;
    byte  ADPC7      : 1;
  } Bits;
} ADC_APCTL1STR;
extern volatile ADC_APCTL1STR _ADC_APCTL1 @0x000030AC;
#define ADC_APCTL1                _ADC_APCTL1.Byte
#define ADC_APCTL1_ADPC0          _ADC_APCTL1.Bits.ADPC0
#define ADC_APCTL1_ADPC1          _ADC_APCTL1.Bits.ADPC1
#define ADC_APCTL1_ADPC2          _ADC_APCTL1.Bits.ADPC2
#define ADC_APCTL1_ADPC3          _ADC_APCTL1.Bits.ADPC3
#define ADC_APCTL1_ADPC4          _ADC_APCTL1.Bits.ADPC4
#define ADC_APCTL1_ADPC5          _ADC_APCTL1.Bits.ADPC5
#define ADC_APCTL1_ADPC6          _ADC_APCTL1.Bits.ADPC6
#define ADC_APCTL1_ADPC7          _ADC_APCTL1.Bits.ADPC7

#define ADC_APCTL1_ADPC0_MASK     1U
#define ADC_APCTL1_ADPC0_BITNUM   0
#define ADC_APCTL1_ADPC1_MASK     2U
#define ADC_APCTL1_ADPC1_BITNUM   1
#define ADC_APCTL1_ADPC2_MASK     4U
#define ADC_APCTL1_ADPC2_BITNUM   2
#define ADC_APCTL1_ADPC3_MASK     8U
#define ADC_APCTL1_ADPC3_BITNUM   3
#define ADC_APCTL1_ADPC4_MASK     16U
#define ADC_APCTL1_ADPC4_BITNUM   4
#define ADC_APCTL1_ADPC5_MASK     32U
#define ADC_APCTL1_ADPC5_BITNUM   5
#define ADC_APCTL1_ADPC6_MASK     64U
#define ADC_APCTL1_ADPC6_BITNUM   6
#define ADC_APCTL1_ADPC7_MASK     128U
#define ADC_APCTL1_ADPC7_BITNUM   7


/*** ADC_APCTL2 Pin Control 2 Register; 0x000030AD ***/
typedef union {
  byte Byte;
  struct {
    byte  ADPC8      : 1;
    byte  ADPC9      : 1;
    byte  ADPC10     : 1;
    byte  ADPC11     : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpADPC    : 2;
    byte  grpADPC1   : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} ADC_APCTL2STR;
extern volatile ADC_APCTL2STR _ADC_APCTL2 @0x000030AD;
#define ADC_APCTL2                _ADC_APCTL2.Byte
#define ADC_APCTL2_ADPC8          _ADC_APCTL2.Bits.ADPC8
#define ADC_APCTL2_ADPC9          _ADC_APCTL2.Bits.ADPC9
#define ADC_APCTL2_ADPC10         _ADC_APCTL2.Bits.ADPC10
#define ADC_APCTL2_ADPC11         _ADC_APCTL2.Bits.ADPC11
#define ADC_APCTL2_ADPC           _ADC_APCTL2.MergedBits.grpADPC
#define ADC_APCTL2_ADPC1          _ADC_APCTL2.MergedBits.grpADPC1

#define ADC_APCTL2_ADPC8_MASK     1U
#define ADC_APCTL2_ADPC8_BITNUM   0
#define ADC_APCTL2_ADPC9_MASK     2U
#define ADC_APCTL2_ADPC9_BITNUM   1
#define ADC_APCTL2_ADPC10_MASK    4U
#define ADC_APCTL2_ADPC10_BITNUM  2
#define ADC_APCTL2_ADPC11_MASK    8U
#define ADC_APCTL2_ADPC11_BITNUM  3
#define ADC_APCTL2_ADPC_MASK      3U
#define ADC_APCTL2_ADPC_BITNUM    0
#define ADC_APCTL2_ADPC1_MASK     12U
#define ADC_APCTL2_ADPC1_BITNUM   2


/*** PORT_PTAOE Port A Output Enable Register; 0x000030B0 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTAOE0     : 1;
    byte  PTAOE1     : 1;
    byte  PTAOE2     : 1;
    byte  PTAOE3     : 1;
    byte  PTAOE4     : 1;
    byte  PTAOE5     : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPTAOE   : 6;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PORT_PTAOESTR;
extern volatile PORT_PTAOESTR _PORT_PTAOE @0x000030B0;
#define PORT_PTAOE                _PORT_PTAOE.Byte
#define PORT_PTAOE_PTAOE0         _PORT_PTAOE.Bits.PTAOE0
#define PORT_PTAOE_PTAOE1         _PORT_PTAOE.Bits.PTAOE1
#define PORT_PTAOE_PTAOE2         _PORT_PTAOE.Bits.PTAOE2
#define PORT_PTAOE_PTAOE3         _PORT_PTAOE.Bits.PTAOE3
#define PORT_PTAOE_PTAOE4         _PORT_PTAOE.Bits.PTAOE4
#define PORT_PTAOE_PTAOE5         _PORT_PTAOE.Bits.PTAOE5
#define PORT_PTAOE_PTAOE          _PORT_PTAOE.MergedBits.grpPTAOE

#define PORT_PTAOE_PTAOE0_MASK    1U
#define PORT_PTAOE_PTAOE0_BITNUM  0
#define PORT_PTAOE_PTAOE1_MASK    2U
#define PORT_PTAOE_PTAOE1_BITNUM  1
#define PORT_PTAOE_PTAOE2_MASK    4U
#define PORT_PTAOE_PTAOE2_BITNUM  2
#define PORT_PTAOE_PTAOE3_MASK    8U
#define PORT_PTAOE_PTAOE3_BITNUM  3
#define PORT_PTAOE_PTAOE4_MASK    16U
#define PORT_PTAOE_PTAOE4_BITNUM  4
#define PORT_PTAOE_PTAOE5_MASK    32U
#define PORT_PTAOE_PTAOE5_BITNUM  5
#define PORT_PTAOE_PTAOE_MASK     63U
#define PORT_PTAOE_PTAOE_BITNUM   0


/*** PORT_PTBOE Port B Output Enable Register; 0x000030B1 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTBOE0     : 1;
    byte  PTBOE1     : 1;
    byte  PTBOE2     : 1;
    byte  PTBOE3     : 1;
    byte  PTBOE4     : 1;
    byte  PTBOE5     : 1;
    byte  PTBOE6     : 1;
    byte  PTBOE7     : 1;
  } Bits;
} PORT_PTBOESTR;
extern volatile PORT_PTBOESTR _PORT_PTBOE @0x000030B1;
#define PORT_PTBOE                _PORT_PTBOE.Byte
#define PORT_PTBOE_PTBOE0         _PORT_PTBOE.Bits.PTBOE0
#define PORT_PTBOE_PTBOE1         _PORT_PTBOE.Bits.PTBOE1
#define PORT_PTBOE_PTBOE2         _PORT_PTBOE.Bits.PTBOE2
#define PORT_PTBOE_PTBOE3         _PORT_PTBOE.Bits.PTBOE3
#define PORT_PTBOE_PTBOE4         _PORT_PTBOE.Bits.PTBOE4
#define PORT_PTBOE_PTBOE5         _PORT_PTBOE.Bits.PTBOE5
#define PORT_PTBOE_PTBOE6         _PORT_PTBOE.Bits.PTBOE6
#define PORT_PTBOE_PTBOE7         _PORT_PTBOE.Bits.PTBOE7

#define PORT_PTBOE_PTBOE0_MASK    1U
#define PORT_PTBOE_PTBOE0_BITNUM  0
#define PORT_PTBOE_PTBOE1_MASK    2U
#define PORT_PTBOE_PTBOE1_BITNUM  1
#define PORT_PTBOE_PTBOE2_MASK    4U
#define PORT_PTBOE_PTBOE2_BITNUM  2
#define PORT_PTBOE_PTBOE3_MASK    8U
#define PORT_PTBOE_PTBOE3_BITNUM  3
#define PORT_PTBOE_PTBOE4_MASK    16U
#define PORT_PTBOE_PTBOE4_BITNUM  4
#define PORT_PTBOE_PTBOE5_MASK    32U
#define PORT_PTBOE_PTBOE5_BITNUM  5
#define PORT_PTBOE_PTBOE6_MASK    64U
#define PORT_PTBOE_PTBOE6_BITNUM  6
#define PORT_PTBOE_PTBOE7_MASK    128U
#define PORT_PTBOE_PTBOE7_BITNUM  7


/*** PORT_PTCOE Port C Output Enable Register; 0x000030B2 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTCOE0     : 1;
    byte  PTCOE1     : 1;
    byte  PTCOE2     : 1;
    byte  PTCOE3     : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPTCOE   : 4;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PORT_PTCOESTR;
extern volatile PORT_PTCOESTR _PORT_PTCOE @0x000030B2;
#define PORT_PTCOE                _PORT_PTCOE.Byte
#define PORT_PTCOE_PTCOE0         _PORT_PTCOE.Bits.PTCOE0
#define PORT_PTCOE_PTCOE1         _PORT_PTCOE.Bits.PTCOE1
#define PORT_PTCOE_PTCOE2         _PORT_PTCOE.Bits.PTCOE2
#define PORT_PTCOE_PTCOE3         _PORT_PTCOE.Bits.PTCOE3
#define PORT_PTCOE_PTCOE          _PORT_PTCOE.MergedBits.grpPTCOE

#define PORT_PTCOE_PTCOE0_MASK    1U
#define PORT_PTCOE_PTCOE0_BITNUM  0
#define PORT_PTCOE_PTCOE1_MASK    2U
#define PORT_PTCOE_PTCOE1_BITNUM  1
#define PORT_PTCOE_PTCOE2_MASK    4U
#define PORT_PTCOE_PTCOE2_BITNUM  2
#define PORT_PTCOE_PTCOE3_MASK    8U
#define PORT_PTCOE_PTCOE3_BITNUM  3
#define PORT_PTCOE_PTCOE_MASK     15U
#define PORT_PTCOE_PTCOE_BITNUM   0


/*** PORT_PTAIE Port A Input Enable Register; 0x000030B8 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTAIE0     : 1;
    byte  PTAIE1     : 1;
    byte  PTAIE2     : 1;
    byte  PTAIE3     : 1;
    byte             : 1;
    byte  PTAIE5     : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPTAIE   : 4;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PORT_PTAIESTR;
extern volatile PORT_PTAIESTR _PORT_PTAIE @0x000030B8;
#define PORT_PTAIE                _PORT_PTAIE.Byte
#define PORT_PTAIE_PTAIE0         _PORT_PTAIE.Bits.PTAIE0
#define PORT_PTAIE_PTAIE1         _PORT_PTAIE.Bits.PTAIE1
#define PORT_PTAIE_PTAIE2         _PORT_PTAIE.Bits.PTAIE2
#define PORT_PTAIE_PTAIE3         _PORT_PTAIE.Bits.PTAIE3
#define PORT_PTAIE_PTAIE5         _PORT_PTAIE.Bits.PTAIE5
#define PORT_PTAIE_PTAIE          _PORT_PTAIE.MergedBits.grpPTAIE

#define PORT_PTAIE_PTAIE0_MASK    1U
#define PORT_PTAIE_PTAIE0_BITNUM  0
#define PORT_PTAIE_PTAIE1_MASK    2U
#define PORT_PTAIE_PTAIE1_BITNUM  1
#define PORT_PTAIE_PTAIE2_MASK    4U
#define PORT_PTAIE_PTAIE2_BITNUM  2
#define PORT_PTAIE_PTAIE3_MASK    8U
#define PORT_PTAIE_PTAIE3_BITNUM  3
#define PORT_PTAIE_PTAIE5_MASK    32U
#define PORT_PTAIE_PTAIE5_BITNUM  5
#define PORT_PTAIE_PTAIE_MASK     15U
#define PORT_PTAIE_PTAIE_BITNUM   0


/*** PORT_PTBIE Port B Input Enable Register; 0x000030B9 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTBIE0     : 1;
    byte  PTBIE1     : 1;
    byte  PTBIE2     : 1;
    byte  PTBIE3     : 1;
    byte  PTBIE4     : 1;
    byte  PTBIE5     : 1;
    byte  PTBIE6     : 1;
    byte  PTBIE7     : 1;
  } Bits;
} PORT_PTBIESTR;
extern volatile PORT_PTBIESTR _PORT_PTBIE @0x000030B9;
#define PORT_PTBIE                _PORT_PTBIE.Byte
#define PORT_PTBIE_PTBIE0         _PORT_PTBIE.Bits.PTBIE0
#define PORT_PTBIE_PTBIE1         _PORT_PTBIE.Bits.PTBIE1
#define PORT_PTBIE_PTBIE2         _PORT_PTBIE.Bits.PTBIE2
#define PORT_PTBIE_PTBIE3         _PORT_PTBIE.Bits.PTBIE3
#define PORT_PTBIE_PTBIE4         _PORT_PTBIE.Bits.PTBIE4
#define PORT_PTBIE_PTBIE5         _PORT_PTBIE.Bits.PTBIE5
#define PORT_PTBIE_PTBIE6         _PORT_PTBIE.Bits.PTBIE6
#define PORT_PTBIE_PTBIE7         _PORT_PTBIE.Bits.PTBIE7

#define PORT_PTBIE_PTBIE0_MASK    1U
#define PORT_PTBIE_PTBIE0_BITNUM  0
#define PORT_PTBIE_PTBIE1_MASK    2U
#define PORT_PTBIE_PTBIE1_BITNUM  1
#define PORT_PTBIE_PTBIE2_MASK    4U
#define PORT_PTBIE_PTBIE2_BITNUM  2
#define PORT_PTBIE_PTBIE3_MASK    8U
#define PORT_PTBIE_PTBIE3_BITNUM  3
#define PORT_PTBIE_PTBIE4_MASK    16U
#define PORT_PTBIE_PTBIE4_BITNUM  4
#define PORT_PTBIE_PTBIE5_MASK    32U
#define PORT_PTBIE_PTBIE5_BITNUM  5
#define PORT_PTBIE_PTBIE6_MASK    64U
#define PORT_PTBIE_PTBIE6_BITNUM  6
#define PORT_PTBIE_PTBIE7_MASK    128U
#define PORT_PTBIE_PTBIE7_BITNUM  7


/*** PORT_PTCIE Port C Input Enable Register; 0x000030BA ***/
typedef union {
  byte Byte;
  struct {
    byte  PTCIE0     : 1;
    byte  PTCIE1     : 1;
    byte  PTCIE2     : 1;
    byte  PTCIE3     : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPTCIE   : 4;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PORT_PTCIESTR;
extern volatile PORT_PTCIESTR _PORT_PTCIE @0x000030BA;
#define PORT_PTCIE                _PORT_PTCIE.Byte
#define PORT_PTCIE_PTCIE0         _PORT_PTCIE.Bits.PTCIE0
#define PORT_PTCIE_PTCIE1         _PORT_PTCIE.Bits.PTCIE1
#define PORT_PTCIE_PTCIE2         _PORT_PTCIE.Bits.PTCIE2
#define PORT_PTCIE_PTCIE3         _PORT_PTCIE.Bits.PTCIE3
#define PORT_PTCIE_PTCIE          _PORT_PTCIE.MergedBits.grpPTCIE

#define PORT_PTCIE_PTCIE0_MASK    1U
#define PORT_PTCIE_PTCIE0_BITNUM  0
#define PORT_PTCIE_PTCIE1_MASK    2U
#define PORT_PTCIE_PTCIE1_BITNUM  1
#define PORT_PTCIE_PTCIE2_MASK    4U
#define PORT_PTCIE_PTCIE2_BITNUM  2
#define PORT_PTCIE_PTCIE3_MASK    8U
#define PORT_PTCIE_PTCIE3_BITNUM  3
#define PORT_PTCIE_PTCIE_MASK     15U
#define PORT_PTCIE_PTCIE_BITNUM   0


/*** FTM2_SC Status and Control; 0x000030C0 ***/
typedef union {
  byte Byte;
  struct {
    byte  PS0        : 1;
    byte  PS1        : 1;
    byte  PS2        : 1;
    byte  CLKS0      : 1;
    byte  CLKS1      : 1;
    byte  CPWMS      : 1;
    byte  TOIE       : 1;
    byte  TOF        : 1;
  } Bits;
  struct {
    byte  grpPS      : 3;
    byte  grpCLKS    : 2;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM2_SCSTR;
extern volatile FTM2_SCSTR _FTM2_SC @0x000030C0;
#define FTM2_SC                   _FTM2_SC.Byte
#define FTM2_SC_PS0               _FTM2_SC.Bits.PS0
#define FTM2_SC_PS1               _FTM2_SC.Bits.PS1
#define FTM2_SC_PS2               _FTM2_SC.Bits.PS2
#define FTM2_SC_CLKS0             _FTM2_SC.Bits.CLKS0
#define FTM2_SC_CLKS1             _FTM2_SC.Bits.CLKS1
#define FTM2_SC_CPWMS             _FTM2_SC.Bits.CPWMS
#define FTM2_SC_TOIE              _FTM2_SC.Bits.TOIE
#define FTM2_SC_TOF               _FTM2_SC.Bits.TOF
#define FTM2_SC_PS                _FTM2_SC.MergedBits.grpPS
#define FTM2_SC_CLKS              _FTM2_SC.MergedBits.grpCLKS

#define FTM2_SC_PS0_MASK          1U
#define FTM2_SC_PS0_BITNUM        0
#define FTM2_SC_PS1_MASK          2U
#define FTM2_SC_PS1_BITNUM        1
#define FTM2_SC_PS2_MASK          4U
#define FTM2_SC_PS2_BITNUM        2
#define FTM2_SC_CLKS0_MASK        8U
#define FTM2_SC_CLKS0_BITNUM      3
#define FTM2_SC_CLKS1_MASK        16U
#define FTM2_SC_CLKS1_BITNUM      4
#define FTM2_SC_CPWMS_MASK        32U
#define FTM2_SC_CPWMS_BITNUM      5
#define FTM2_SC_TOIE_MASK         64U
#define FTM2_SC_TOIE_BITNUM       6
#define FTM2_SC_TOF_MASK          128U
#define FTM2_SC_TOF_BITNUM        7
#define FTM2_SC_PS_MASK           7U
#define FTM2_SC_PS_BITNUM         0
#define FTM2_SC_CLKS_MASK         24U
#define FTM2_SC_CLKS_BITNUM       3


/*** FTM2_CNT Counter  0x000030C1 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM2_CNTH Counter High; 0x000030C1 ***/
    union {
      byte Byte;
      struct {
        byte  COUNT_H0   : 1;
        byte  COUNT_H1   : 1;
        byte  COUNT_H2   : 1;
        byte  COUNT_H3   : 1;
        byte  COUNT_H4   : 1;
        byte  COUNT_H5   : 1;
        byte  COUNT_H6   : 1;
        byte  COUNT_H7   : 1;
      } Bits;
    } FTM2_CNTHSTR;
    #define FTM2_CNTH                 _FTM2_CNT.Overlap_STR.FTM2_CNTHSTR.Byte
    #define FTM2_CNTH_COUNT_H0        _FTM2_CNT.Overlap_STR.FTM2_CNTHSTR.Bits.COUNT_H0
    #define FTM2_CNTH_COUNT_H1        _FTM2_CNT.Overlap_STR.FTM2_CNTHSTR.Bits.COUNT_H1
    #define FTM2_CNTH_COUNT_H2        _FTM2_CNT.Overlap_STR.FTM2_CNTHSTR.Bits.COUNT_H2
    #define FTM2_CNTH_COUNT_H3        _FTM2_CNT.Overlap_STR.FTM2_CNTHSTR.Bits.COUNT_H3
    #define FTM2_CNTH_COUNT_H4        _FTM2_CNT.Overlap_STR.FTM2_CNTHSTR.Bits.COUNT_H4
    #define FTM2_CNTH_COUNT_H5        _FTM2_CNT.Overlap_STR.FTM2_CNTHSTR.Bits.COUNT_H5
    #define FTM2_CNTH_COUNT_H6        _FTM2_CNT.Overlap_STR.FTM2_CNTHSTR.Bits.COUNT_H6
    #define FTM2_CNTH_COUNT_H7        _FTM2_CNT.Overlap_STR.FTM2_CNTHSTR.Bits.COUNT_H7
    
    #define FTM2_CNTH_COUNT_H0_MASK   1U
    #define FTM2_CNTH_COUNT_H0_BITNUM 0
    #define FTM2_CNTH_COUNT_H1_MASK   2U
    #define FTM2_CNTH_COUNT_H1_BITNUM 1
    #define FTM2_CNTH_COUNT_H2_MASK   4U
    #define FTM2_CNTH_COUNT_H2_BITNUM 2
    #define FTM2_CNTH_COUNT_H3_MASK   8U
    #define FTM2_CNTH_COUNT_H3_BITNUM 3
    #define FTM2_CNTH_COUNT_H4_MASK   16U
    #define FTM2_CNTH_COUNT_H4_BITNUM 4
    #define FTM2_CNTH_COUNT_H5_MASK   32U
    #define FTM2_CNTH_COUNT_H5_BITNUM 5
    #define FTM2_CNTH_COUNT_H6_MASK   64U
    #define FTM2_CNTH_COUNT_H6_BITNUM 6
    #define FTM2_CNTH_COUNT_H7_MASK   128U
    #define FTM2_CNTH_COUNT_H7_BITNUM 7
    
    /*** FTM2_CNTL Counter Low; 0x000030C2 ***/
    union {
      byte Byte;
      struct {
        byte  COUNT_L0   : 1;
        byte  COUNT_L1   : 1;
        byte  COUNT_L2   : 1;
        byte  COUNT_L3   : 1;
        byte  COUNT_L4   : 1;
        byte  COUNT_L5   : 1;
        byte  COUNT_L6   : 1;
        byte  COUNT_L7   : 1;
      } Bits;
    } FTM2_CNTLSTR;
    #define FTM2_CNTL                 _FTM2_CNT.Overlap_STR.FTM2_CNTLSTR.Byte
    #define FTM2_CNTL_COUNT_L0        _FTM2_CNT.Overlap_STR.FTM2_CNTLSTR.Bits.COUNT_L0
    #define FTM2_CNTL_COUNT_L1        _FTM2_CNT.Overlap_STR.FTM2_CNTLSTR.Bits.COUNT_L1
    #define FTM2_CNTL_COUNT_L2        _FTM2_CNT.Overlap_STR.FTM2_CNTLSTR.Bits.COUNT_L2
    #define FTM2_CNTL_COUNT_L3        _FTM2_CNT.Overlap_STR.FTM2_CNTLSTR.Bits.COUNT_L3
    #define FTM2_CNTL_COUNT_L4        _FTM2_CNT.Overlap_STR.FTM2_CNTLSTR.Bits.COUNT_L4
    #define FTM2_CNTL_COUNT_L5        _FTM2_CNT.Overlap_STR.FTM2_CNTLSTR.Bits.COUNT_L5
    #define FTM2_CNTL_COUNT_L6        _FTM2_CNT.Overlap_STR.FTM2_CNTLSTR.Bits.COUNT_L6
    #define FTM2_CNTL_COUNT_L7        _FTM2_CNT.Overlap_STR.FTM2_CNTLSTR.Bits.COUNT_L7
    
    #define FTM2_CNTL_COUNT_L0_MASK   1U
    #define FTM2_CNTL_COUNT_L0_BITNUM 0
    #define FTM2_CNTL_COUNT_L1_MASK   2U
    #define FTM2_CNTL_COUNT_L1_BITNUM 1
    #define FTM2_CNTL_COUNT_L2_MASK   4U
    #define FTM2_CNTL_COUNT_L2_BITNUM 2
    #define FTM2_CNTL_COUNT_L3_MASK   8U
    #define FTM2_CNTL_COUNT_L3_BITNUM 3
    #define FTM2_CNTL_COUNT_L4_MASK   16U
    #define FTM2_CNTL_COUNT_L4_BITNUM 4
    #define FTM2_CNTL_COUNT_L5_MASK   32U
    #define FTM2_CNTL_COUNT_L5_BITNUM 5
    #define FTM2_CNTL_COUNT_L6_MASK   64U
    #define FTM2_CNTL_COUNT_L6_BITNUM 6
    #define FTM2_CNTL_COUNT_L7_MASK   128U
    #define FTM2_CNTL_COUNT_L7_BITNUM 7
    
  } Overlap_STR;
} FTM2_CNTSTR;
extern volatile FTM2_CNTSTR _FTM2_CNT @0x000030C1;
#define FTM2_CNT                  _FTM2_CNT.Word


/*** FTM2_MOD Modulo  0x000030C3 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM2_MODH Modulo High; 0x000030C3 ***/
    union {
      byte Byte;
      struct {
        byte  MOD_H0     : 1;
        byte  MOD_H1     : 1;
        byte  MOD_H2     : 1;
        byte  MOD_H3     : 1;
        byte  MOD_H4     : 1;
        byte  MOD_H5     : 1;
        byte  MOD_H6     : 1;
        byte  MOD_H7     : 1;
      } Bits;
    } FTM2_MODHSTR;
    #define FTM2_MODH                 _FTM2_MOD.Overlap_STR.FTM2_MODHSTR.Byte
    #define FTM2_MODH_MOD_H0          _FTM2_MOD.Overlap_STR.FTM2_MODHSTR.Bits.MOD_H0
    #define FTM2_MODH_MOD_H1          _FTM2_MOD.Overlap_STR.FTM2_MODHSTR.Bits.MOD_H1
    #define FTM2_MODH_MOD_H2          _FTM2_MOD.Overlap_STR.FTM2_MODHSTR.Bits.MOD_H2
    #define FTM2_MODH_MOD_H3          _FTM2_MOD.Overlap_STR.FTM2_MODHSTR.Bits.MOD_H3
    #define FTM2_MODH_MOD_H4          _FTM2_MOD.Overlap_STR.FTM2_MODHSTR.Bits.MOD_H4
    #define FTM2_MODH_MOD_H5          _FTM2_MOD.Overlap_STR.FTM2_MODHSTR.Bits.MOD_H5
    #define FTM2_MODH_MOD_H6          _FTM2_MOD.Overlap_STR.FTM2_MODHSTR.Bits.MOD_H6
    #define FTM2_MODH_MOD_H7          _FTM2_MOD.Overlap_STR.FTM2_MODHSTR.Bits.MOD_H7
    
    #define FTM2_MODH_MOD_H0_MASK     1U
    #define FTM2_MODH_MOD_H0_BITNUM   0
    #define FTM2_MODH_MOD_H1_MASK     2U
    #define FTM2_MODH_MOD_H1_BITNUM   1
    #define FTM2_MODH_MOD_H2_MASK     4U
    #define FTM2_MODH_MOD_H2_BITNUM   2
    #define FTM2_MODH_MOD_H3_MASK     8U
    #define FTM2_MODH_MOD_H3_BITNUM   3
    #define FTM2_MODH_MOD_H4_MASK     16U
    #define FTM2_MODH_MOD_H4_BITNUM   4
    #define FTM2_MODH_MOD_H5_MASK     32U
    #define FTM2_MODH_MOD_H5_BITNUM   5
    #define FTM2_MODH_MOD_H6_MASK     64U
    #define FTM2_MODH_MOD_H6_BITNUM   6
    #define FTM2_MODH_MOD_H7_MASK     128U
    #define FTM2_MODH_MOD_H7_BITNUM   7
    
    /*** FTM2_MODL Modulo Low; 0x000030C4 ***/
    union {
      byte Byte;
      struct {
        byte  MOD_L0     : 1;
        byte  MOD_L1     : 1;
        byte  MOD_L2     : 1;
        byte  MOD_L3     : 1;
        byte  MOD_L4     : 1;
        byte  MOD_L5     : 1;
        byte  MOD_L6     : 1;
        byte  MOD_L7     : 1;
      } Bits;
    } FTM2_MODLSTR;
    #define FTM2_MODL                 _FTM2_MOD.Overlap_STR.FTM2_MODLSTR.Byte
    #define FTM2_MODL_MOD_L0          _FTM2_MOD.Overlap_STR.FTM2_MODLSTR.Bits.MOD_L0
    #define FTM2_MODL_MOD_L1          _FTM2_MOD.Overlap_STR.FTM2_MODLSTR.Bits.MOD_L1
    #define FTM2_MODL_MOD_L2          _FTM2_MOD.Overlap_STR.FTM2_MODLSTR.Bits.MOD_L2
    #define FTM2_MODL_MOD_L3          _FTM2_MOD.Overlap_STR.FTM2_MODLSTR.Bits.MOD_L3
    #define FTM2_MODL_MOD_L4          _FTM2_MOD.Overlap_STR.FTM2_MODLSTR.Bits.MOD_L4
    #define FTM2_MODL_MOD_L5          _FTM2_MOD.Overlap_STR.FTM2_MODLSTR.Bits.MOD_L5
    #define FTM2_MODL_MOD_L6          _FTM2_MOD.Overlap_STR.FTM2_MODLSTR.Bits.MOD_L6
    #define FTM2_MODL_MOD_L7          _FTM2_MOD.Overlap_STR.FTM2_MODLSTR.Bits.MOD_L7
    
    #define FTM2_MODL_MOD_L0_MASK     1U
    #define FTM2_MODL_MOD_L0_BITNUM   0
    #define FTM2_MODL_MOD_L1_MASK     2U
    #define FTM2_MODL_MOD_L1_BITNUM   1
    #define FTM2_MODL_MOD_L2_MASK     4U
    #define FTM2_MODL_MOD_L2_BITNUM   2
    #define FTM2_MODL_MOD_L3_MASK     8U
    #define FTM2_MODL_MOD_L3_BITNUM   3
    #define FTM2_MODL_MOD_L4_MASK     16U
    #define FTM2_MODL_MOD_L4_BITNUM   4
    #define FTM2_MODL_MOD_L5_MASK     32U
    #define FTM2_MODL_MOD_L5_BITNUM   5
    #define FTM2_MODL_MOD_L6_MASK     64U
    #define FTM2_MODL_MOD_L6_BITNUM   6
    #define FTM2_MODL_MOD_L7_MASK     128U
    #define FTM2_MODL_MOD_L7_BITNUM   7
    
  } Overlap_STR;
} FTM2_MODSTR;
extern volatile FTM2_MODSTR _FTM2_MOD @0x000030C3;
#define FTM2_MOD                  _FTM2_MOD.Word


/*** FTM2_C0SC Channel Status and Control; 0x000030C5 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  ELSA       : 1;
    byte  ELSB       : 1;
    byte  MSA        : 1;
    byte  MSB        : 1;
    byte  CHIE       : 1;
    byte  CHF        : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte  grpELSx    : 2;
    byte  grpMSx     : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM2_C0SCSTR;
extern volatile FTM2_C0SCSTR _FTM2_C0SC @0x000030C5;
#define FTM2_C0SC                 _FTM2_C0SC.Byte
#define FTM2_C0SC_ELSA            _FTM2_C0SC.Bits.ELSA
#define FTM2_C0SC_ELSB            _FTM2_C0SC.Bits.ELSB
#define FTM2_C0SC_MSA             _FTM2_C0SC.Bits.MSA
#define FTM2_C0SC_MSB             _FTM2_C0SC.Bits.MSB
#define FTM2_C0SC_CHIE            _FTM2_C0SC.Bits.CHIE
#define FTM2_C0SC_CHF             _FTM2_C0SC.Bits.CHF
#define FTM2_C0SC_ELSx            _FTM2_C0SC.MergedBits.grpELSx
#define FTM2_C0SC_MSx             _FTM2_C0SC.MergedBits.grpMSx

#define FTM2_C0SC_ELSA_MASK       4U
#define FTM2_C0SC_ELSA_BITNUM     2
#define FTM2_C0SC_ELSB_MASK       8U
#define FTM2_C0SC_ELSB_BITNUM     3
#define FTM2_C0SC_MSA_MASK        16U
#define FTM2_C0SC_MSA_BITNUM      4
#define FTM2_C0SC_MSB_MASK        32U
#define FTM2_C0SC_MSB_BITNUM      5
#define FTM2_C0SC_CHIE_MASK       64U
#define FTM2_C0SC_CHIE_BITNUM     6
#define FTM2_C0SC_CHF_MASK        128U
#define FTM2_C0SC_CHF_BITNUM      7
#define FTM2_C0SC_ELSx_MASK       12U
#define FTM2_C0SC_ELSx_BITNUM     2
#define FTM2_C0SC_MSx_MASK        48U
#define FTM2_C0SC_MSx_BITNUM      4


/*** FTM2_C0V Channel Value  0x000030C6 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM2_C0VH Channel Value High; 0x000030C6 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_H0     : 1;
        byte  VAL_H1     : 1;
        byte  VAL_H2     : 1;
        byte  VAL_H3     : 1;
        byte  VAL_H4     : 1;
        byte  VAL_H5     : 1;
        byte  VAL_H6     : 1;
        byte  VAL_H7     : 1;
      } Bits;
    } FTM2_C0VHSTR;
    #define FTM2_C0VH                 _FTM2_C0V.Overlap_STR.FTM2_C0VHSTR.Byte
    #define FTM2_C0VH_VAL_H0          _FTM2_C0V.Overlap_STR.FTM2_C0VHSTR.Bits.VAL_H0
    #define FTM2_C0VH_VAL_H1          _FTM2_C0V.Overlap_STR.FTM2_C0VHSTR.Bits.VAL_H1
    #define FTM2_C0VH_VAL_H2          _FTM2_C0V.Overlap_STR.FTM2_C0VHSTR.Bits.VAL_H2
    #define FTM2_C0VH_VAL_H3          _FTM2_C0V.Overlap_STR.FTM2_C0VHSTR.Bits.VAL_H3
    #define FTM2_C0VH_VAL_H4          _FTM2_C0V.Overlap_STR.FTM2_C0VHSTR.Bits.VAL_H4
    #define FTM2_C0VH_VAL_H5          _FTM2_C0V.Overlap_STR.FTM2_C0VHSTR.Bits.VAL_H5
    #define FTM2_C0VH_VAL_H6          _FTM2_C0V.Overlap_STR.FTM2_C0VHSTR.Bits.VAL_H6
    #define FTM2_C0VH_VAL_H7          _FTM2_C0V.Overlap_STR.FTM2_C0VHSTR.Bits.VAL_H7
    
    #define FTM2_C0VH_VAL_H0_MASK     1U
    #define FTM2_C0VH_VAL_H0_BITNUM   0
    #define FTM2_C0VH_VAL_H1_MASK     2U
    #define FTM2_C0VH_VAL_H1_BITNUM   1
    #define FTM2_C0VH_VAL_H2_MASK     4U
    #define FTM2_C0VH_VAL_H2_BITNUM   2
    #define FTM2_C0VH_VAL_H3_MASK     8U
    #define FTM2_C0VH_VAL_H3_BITNUM   3
    #define FTM2_C0VH_VAL_H4_MASK     16U
    #define FTM2_C0VH_VAL_H4_BITNUM   4
    #define FTM2_C0VH_VAL_H5_MASK     32U
    #define FTM2_C0VH_VAL_H5_BITNUM   5
    #define FTM2_C0VH_VAL_H6_MASK     64U
    #define FTM2_C0VH_VAL_H6_BITNUM   6
    #define FTM2_C0VH_VAL_H7_MASK     128U
    #define FTM2_C0VH_VAL_H7_BITNUM   7
    
    /*** FTM2_C0VL Channel Value Low; 0x000030C7 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_L0     : 1;
        byte  VAL_L1     : 1;
        byte  VAL_L2     : 1;
        byte  VAL_L3     : 1;
        byte  VAL_L4     : 1;
        byte  VAL_L5     : 1;
        byte  VAL_L6     : 1;
        byte  VAL_L7     : 1;
      } Bits;
    } FTM2_C0VLSTR;
    #define FTM2_C0VL                 _FTM2_C0V.Overlap_STR.FTM2_C0VLSTR.Byte
    #define FTM2_C0VL_VAL_L0          _FTM2_C0V.Overlap_STR.FTM2_C0VLSTR.Bits.VAL_L0
    #define FTM2_C0VL_VAL_L1          _FTM2_C0V.Overlap_STR.FTM2_C0VLSTR.Bits.VAL_L1
    #define FTM2_C0VL_VAL_L2          _FTM2_C0V.Overlap_STR.FTM2_C0VLSTR.Bits.VAL_L2
    #define FTM2_C0VL_VAL_L3          _FTM2_C0V.Overlap_STR.FTM2_C0VLSTR.Bits.VAL_L3
    #define FTM2_C0VL_VAL_L4          _FTM2_C0V.Overlap_STR.FTM2_C0VLSTR.Bits.VAL_L4
    #define FTM2_C0VL_VAL_L5          _FTM2_C0V.Overlap_STR.FTM2_C0VLSTR.Bits.VAL_L5
    #define FTM2_C0VL_VAL_L6          _FTM2_C0V.Overlap_STR.FTM2_C0VLSTR.Bits.VAL_L6
    #define FTM2_C0VL_VAL_L7          _FTM2_C0V.Overlap_STR.FTM2_C0VLSTR.Bits.VAL_L7
    
    #define FTM2_C0VL_VAL_L0_MASK     1U
    #define FTM2_C0VL_VAL_L0_BITNUM   0
    #define FTM2_C0VL_VAL_L1_MASK     2U
    #define FTM2_C0VL_VAL_L1_BITNUM   1
    #define FTM2_C0VL_VAL_L2_MASK     4U
    #define FTM2_C0VL_VAL_L2_BITNUM   2
    #define FTM2_C0VL_VAL_L3_MASK     8U
    #define FTM2_C0VL_VAL_L3_BITNUM   3
    #define FTM2_C0VL_VAL_L4_MASK     16U
    #define FTM2_C0VL_VAL_L4_BITNUM   4
    #define FTM2_C0VL_VAL_L5_MASK     32U
    #define FTM2_C0VL_VAL_L5_BITNUM   5
    #define FTM2_C0VL_VAL_L6_MASK     64U
    #define FTM2_C0VL_VAL_L6_BITNUM   6
    #define FTM2_C0VL_VAL_L7_MASK     128U
    #define FTM2_C0VL_VAL_L7_BITNUM   7
    
  } Overlap_STR;
} FTM2_C0VSTR;
extern volatile FTM2_C0VSTR _FTM2_C0V @0x000030C6;
#define FTM2_C0V                  _FTM2_C0V.Word


/*** FTM2_C1SC Channel Status and Control; 0x000030C8 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  ELSA       : 1;
    byte  ELSB       : 1;
    byte  MSA        : 1;
    byte  MSB        : 1;
    byte  CHIE       : 1;
    byte  CHF        : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte  grpELSx    : 2;
    byte  grpMSx     : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM2_C1SCSTR;
extern volatile FTM2_C1SCSTR _FTM2_C1SC @0x000030C8;
#define FTM2_C1SC                 _FTM2_C1SC.Byte
#define FTM2_C1SC_ELSA            _FTM2_C1SC.Bits.ELSA
#define FTM2_C1SC_ELSB            _FTM2_C1SC.Bits.ELSB
#define FTM2_C1SC_MSA             _FTM2_C1SC.Bits.MSA
#define FTM2_C1SC_MSB             _FTM2_C1SC.Bits.MSB
#define FTM2_C1SC_CHIE            _FTM2_C1SC.Bits.CHIE
#define FTM2_C1SC_CHF             _FTM2_C1SC.Bits.CHF
#define FTM2_C1SC_ELSx            _FTM2_C1SC.MergedBits.grpELSx
#define FTM2_C1SC_MSx             _FTM2_C1SC.MergedBits.grpMSx

#define FTM2_C1SC_ELSA_MASK       4U
#define FTM2_C1SC_ELSA_BITNUM     2
#define FTM2_C1SC_ELSB_MASK       8U
#define FTM2_C1SC_ELSB_BITNUM     3
#define FTM2_C1SC_MSA_MASK        16U
#define FTM2_C1SC_MSA_BITNUM      4
#define FTM2_C1SC_MSB_MASK        32U
#define FTM2_C1SC_MSB_BITNUM      5
#define FTM2_C1SC_CHIE_MASK       64U
#define FTM2_C1SC_CHIE_BITNUM     6
#define FTM2_C1SC_CHF_MASK        128U
#define FTM2_C1SC_CHF_BITNUM      7
#define FTM2_C1SC_ELSx_MASK       12U
#define FTM2_C1SC_ELSx_BITNUM     2
#define FTM2_C1SC_MSx_MASK        48U
#define FTM2_C1SC_MSx_BITNUM      4


/*** FTM2_C1V Channel Value  0x000030C9 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM2_C1VH Channel Value High; 0x000030C9 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_H0     : 1;
        byte  VAL_H1     : 1;
        byte  VAL_H2     : 1;
        byte  VAL_H3     : 1;
        byte  VAL_H4     : 1;
        byte  VAL_H5     : 1;
        byte  VAL_H6     : 1;
        byte  VAL_H7     : 1;
      } Bits;
    } FTM2_C1VHSTR;
    #define FTM2_C1VH                 _FTM2_C1V.Overlap_STR.FTM2_C1VHSTR.Byte
    #define FTM2_C1VH_VAL_H0          _FTM2_C1V.Overlap_STR.FTM2_C1VHSTR.Bits.VAL_H0
    #define FTM2_C1VH_VAL_H1          _FTM2_C1V.Overlap_STR.FTM2_C1VHSTR.Bits.VAL_H1
    #define FTM2_C1VH_VAL_H2          _FTM2_C1V.Overlap_STR.FTM2_C1VHSTR.Bits.VAL_H2
    #define FTM2_C1VH_VAL_H3          _FTM2_C1V.Overlap_STR.FTM2_C1VHSTR.Bits.VAL_H3
    #define FTM2_C1VH_VAL_H4          _FTM2_C1V.Overlap_STR.FTM2_C1VHSTR.Bits.VAL_H4
    #define FTM2_C1VH_VAL_H5          _FTM2_C1V.Overlap_STR.FTM2_C1VHSTR.Bits.VAL_H5
    #define FTM2_C1VH_VAL_H6          _FTM2_C1V.Overlap_STR.FTM2_C1VHSTR.Bits.VAL_H6
    #define FTM2_C1VH_VAL_H7          _FTM2_C1V.Overlap_STR.FTM2_C1VHSTR.Bits.VAL_H7
    
    #define FTM2_C1VH_VAL_H0_MASK     1U
    #define FTM2_C1VH_VAL_H0_BITNUM   0
    #define FTM2_C1VH_VAL_H1_MASK     2U
    #define FTM2_C1VH_VAL_H1_BITNUM   1
    #define FTM2_C1VH_VAL_H2_MASK     4U
    #define FTM2_C1VH_VAL_H2_BITNUM   2
    #define FTM2_C1VH_VAL_H3_MASK     8U
    #define FTM2_C1VH_VAL_H3_BITNUM   3
    #define FTM2_C1VH_VAL_H4_MASK     16U
    #define FTM2_C1VH_VAL_H4_BITNUM   4
    #define FTM2_C1VH_VAL_H5_MASK     32U
    #define FTM2_C1VH_VAL_H5_BITNUM   5
    #define FTM2_C1VH_VAL_H6_MASK     64U
    #define FTM2_C1VH_VAL_H6_BITNUM   6
    #define FTM2_C1VH_VAL_H7_MASK     128U
    #define FTM2_C1VH_VAL_H7_BITNUM   7
    
    /*** FTM2_C1VL Channel Value Low; 0x000030CA ***/
    union {
      byte Byte;
      struct {
        byte  VAL_L0     : 1;
        byte  VAL_L1     : 1;
        byte  VAL_L2     : 1;
        byte  VAL_L3     : 1;
        byte  VAL_L4     : 1;
        byte  VAL_L5     : 1;
        byte  VAL_L6     : 1;
        byte  VAL_L7     : 1;
      } Bits;
    } FTM2_C1VLSTR;
    #define FTM2_C1VL                 _FTM2_C1V.Overlap_STR.FTM2_C1VLSTR.Byte
    #define FTM2_C1VL_VAL_L0          _FTM2_C1V.Overlap_STR.FTM2_C1VLSTR.Bits.VAL_L0
    #define FTM2_C1VL_VAL_L1          _FTM2_C1V.Overlap_STR.FTM2_C1VLSTR.Bits.VAL_L1
    #define FTM2_C1VL_VAL_L2          _FTM2_C1V.Overlap_STR.FTM2_C1VLSTR.Bits.VAL_L2
    #define FTM2_C1VL_VAL_L3          _FTM2_C1V.Overlap_STR.FTM2_C1VLSTR.Bits.VAL_L3
    #define FTM2_C1VL_VAL_L4          _FTM2_C1V.Overlap_STR.FTM2_C1VLSTR.Bits.VAL_L4
    #define FTM2_C1VL_VAL_L5          _FTM2_C1V.Overlap_STR.FTM2_C1VLSTR.Bits.VAL_L5
    #define FTM2_C1VL_VAL_L6          _FTM2_C1V.Overlap_STR.FTM2_C1VLSTR.Bits.VAL_L6
    #define FTM2_C1VL_VAL_L7          _FTM2_C1V.Overlap_STR.FTM2_C1VLSTR.Bits.VAL_L7
    
    #define FTM2_C1VL_VAL_L0_MASK     1U
    #define FTM2_C1VL_VAL_L0_BITNUM   0
    #define FTM2_C1VL_VAL_L1_MASK     2U
    #define FTM2_C1VL_VAL_L1_BITNUM   1
    #define FTM2_C1VL_VAL_L2_MASK     4U
    #define FTM2_C1VL_VAL_L2_BITNUM   2
    #define FTM2_C1VL_VAL_L3_MASK     8U
    #define FTM2_C1VL_VAL_L3_BITNUM   3
    #define FTM2_C1VL_VAL_L4_MASK     16U
    #define FTM2_C1VL_VAL_L4_BITNUM   4
    #define FTM2_C1VL_VAL_L5_MASK     32U
    #define FTM2_C1VL_VAL_L5_BITNUM   5
    #define FTM2_C1VL_VAL_L6_MASK     64U
    #define FTM2_C1VL_VAL_L6_BITNUM   6
    #define FTM2_C1VL_VAL_L7_MASK     128U
    #define FTM2_C1VL_VAL_L7_BITNUM   7
    
  } Overlap_STR;
} FTM2_C1VSTR;
extern volatile FTM2_C1VSTR _FTM2_C1V @0x000030C9;
#define FTM2_C1V                  _FTM2_C1V.Word


/*** FTM2_C2SC Channel Status and Control; 0x000030CB ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  ELSA       : 1;
    byte  ELSB       : 1;
    byte  MSA        : 1;
    byte  MSB        : 1;
    byte  CHIE       : 1;
    byte  CHF        : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte  grpELSx    : 2;
    byte  grpMSx     : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM2_C2SCSTR;
extern volatile FTM2_C2SCSTR _FTM2_C2SC @0x000030CB;
#define FTM2_C2SC                 _FTM2_C2SC.Byte
#define FTM2_C2SC_ELSA            _FTM2_C2SC.Bits.ELSA
#define FTM2_C2SC_ELSB            _FTM2_C2SC.Bits.ELSB
#define FTM2_C2SC_MSA             _FTM2_C2SC.Bits.MSA
#define FTM2_C2SC_MSB             _FTM2_C2SC.Bits.MSB
#define FTM2_C2SC_CHIE            _FTM2_C2SC.Bits.CHIE
#define FTM2_C2SC_CHF             _FTM2_C2SC.Bits.CHF
#define FTM2_C2SC_ELSx            _FTM2_C2SC.MergedBits.grpELSx
#define FTM2_C2SC_MSx             _FTM2_C2SC.MergedBits.grpMSx

#define FTM2_C2SC_ELSA_MASK       4U
#define FTM2_C2SC_ELSA_BITNUM     2
#define FTM2_C2SC_ELSB_MASK       8U
#define FTM2_C2SC_ELSB_BITNUM     3
#define FTM2_C2SC_MSA_MASK        16U
#define FTM2_C2SC_MSA_BITNUM      4
#define FTM2_C2SC_MSB_MASK        32U
#define FTM2_C2SC_MSB_BITNUM      5
#define FTM2_C2SC_CHIE_MASK       64U
#define FTM2_C2SC_CHIE_BITNUM     6
#define FTM2_C2SC_CHF_MASK        128U
#define FTM2_C2SC_CHF_BITNUM      7
#define FTM2_C2SC_ELSx_MASK       12U
#define FTM2_C2SC_ELSx_BITNUM     2
#define FTM2_C2SC_MSx_MASK        48U
#define FTM2_C2SC_MSx_BITNUM      4


/*** FTM2_C2V Channel Value  0x000030CC ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM2_C2VH Channel Value High; 0x000030CC ***/
    union {
      byte Byte;
      struct {
        byte  VAL_H0     : 1;
        byte  VAL_H1     : 1;
        byte  VAL_H2     : 1;
        byte  VAL_H3     : 1;
        byte  VAL_H4     : 1;
        byte  VAL_H5     : 1;
        byte  VAL_H6     : 1;
        byte  VAL_H7     : 1;
      } Bits;
    } FTM2_C2VHSTR;
    #define FTM2_C2VH                 _FTM2_C2V.Overlap_STR.FTM2_C2VHSTR.Byte
    #define FTM2_C2VH_VAL_H0          _FTM2_C2V.Overlap_STR.FTM2_C2VHSTR.Bits.VAL_H0
    #define FTM2_C2VH_VAL_H1          _FTM2_C2V.Overlap_STR.FTM2_C2VHSTR.Bits.VAL_H1
    #define FTM2_C2VH_VAL_H2          _FTM2_C2V.Overlap_STR.FTM2_C2VHSTR.Bits.VAL_H2
    #define FTM2_C2VH_VAL_H3          _FTM2_C2V.Overlap_STR.FTM2_C2VHSTR.Bits.VAL_H3
    #define FTM2_C2VH_VAL_H4          _FTM2_C2V.Overlap_STR.FTM2_C2VHSTR.Bits.VAL_H4
    #define FTM2_C2VH_VAL_H5          _FTM2_C2V.Overlap_STR.FTM2_C2VHSTR.Bits.VAL_H5
    #define FTM2_C2VH_VAL_H6          _FTM2_C2V.Overlap_STR.FTM2_C2VHSTR.Bits.VAL_H6
    #define FTM2_C2VH_VAL_H7          _FTM2_C2V.Overlap_STR.FTM2_C2VHSTR.Bits.VAL_H7
    
    #define FTM2_C2VH_VAL_H0_MASK     1U
    #define FTM2_C2VH_VAL_H0_BITNUM   0
    #define FTM2_C2VH_VAL_H1_MASK     2U
    #define FTM2_C2VH_VAL_H1_BITNUM   1
    #define FTM2_C2VH_VAL_H2_MASK     4U
    #define FTM2_C2VH_VAL_H2_BITNUM   2
    #define FTM2_C2VH_VAL_H3_MASK     8U
    #define FTM2_C2VH_VAL_H3_BITNUM   3
    #define FTM2_C2VH_VAL_H4_MASK     16U
    #define FTM2_C2VH_VAL_H4_BITNUM   4
    #define FTM2_C2VH_VAL_H5_MASK     32U
    #define FTM2_C2VH_VAL_H5_BITNUM   5
    #define FTM2_C2VH_VAL_H6_MASK     64U
    #define FTM2_C2VH_VAL_H6_BITNUM   6
    #define FTM2_C2VH_VAL_H7_MASK     128U
    #define FTM2_C2VH_VAL_H7_BITNUM   7
    
    /*** FTM2_C2VL Channel Value Low; 0x000030CD ***/
    union {
      byte Byte;
      struct {
        byte  VAL_L0     : 1;
        byte  VAL_L1     : 1;
        byte  VAL_L2     : 1;
        byte  VAL_L3     : 1;
        byte  VAL_L4     : 1;
        byte  VAL_L5     : 1;
        byte  VAL_L6     : 1;
        byte  VAL_L7     : 1;
      } Bits;
    } FTM2_C2VLSTR;
    #define FTM2_C2VL                 _FTM2_C2V.Overlap_STR.FTM2_C2VLSTR.Byte
    #define FTM2_C2VL_VAL_L0          _FTM2_C2V.Overlap_STR.FTM2_C2VLSTR.Bits.VAL_L0
    #define FTM2_C2VL_VAL_L1          _FTM2_C2V.Overlap_STR.FTM2_C2VLSTR.Bits.VAL_L1
    #define FTM2_C2VL_VAL_L2          _FTM2_C2V.Overlap_STR.FTM2_C2VLSTR.Bits.VAL_L2
    #define FTM2_C2VL_VAL_L3          _FTM2_C2V.Overlap_STR.FTM2_C2VLSTR.Bits.VAL_L3
    #define FTM2_C2VL_VAL_L4          _FTM2_C2V.Overlap_STR.FTM2_C2VLSTR.Bits.VAL_L4
    #define FTM2_C2VL_VAL_L5          _FTM2_C2V.Overlap_STR.FTM2_C2VLSTR.Bits.VAL_L5
    #define FTM2_C2VL_VAL_L6          _FTM2_C2V.Overlap_STR.FTM2_C2VLSTR.Bits.VAL_L6
    #define FTM2_C2VL_VAL_L7          _FTM2_C2V.Overlap_STR.FTM2_C2VLSTR.Bits.VAL_L7
    
    #define FTM2_C2VL_VAL_L0_MASK     1U
    #define FTM2_C2VL_VAL_L0_BITNUM   0
    #define FTM2_C2VL_VAL_L1_MASK     2U
    #define FTM2_C2VL_VAL_L1_BITNUM   1
    #define FTM2_C2VL_VAL_L2_MASK     4U
    #define FTM2_C2VL_VAL_L2_BITNUM   2
    #define FTM2_C2VL_VAL_L3_MASK     8U
    #define FTM2_C2VL_VAL_L3_BITNUM   3
    #define FTM2_C2VL_VAL_L4_MASK     16U
    #define FTM2_C2VL_VAL_L4_BITNUM   4
    #define FTM2_C2VL_VAL_L5_MASK     32U
    #define FTM2_C2VL_VAL_L5_BITNUM   5
    #define FTM2_C2VL_VAL_L6_MASK     64U
    #define FTM2_C2VL_VAL_L6_BITNUM   6
    #define FTM2_C2VL_VAL_L7_MASK     128U
    #define FTM2_C2VL_VAL_L7_BITNUM   7
    
  } Overlap_STR;
} FTM2_C2VSTR;
extern volatile FTM2_C2VSTR _FTM2_C2V @0x000030CC;
#define FTM2_C2V                  _FTM2_C2V.Word


/*** FTM2_C3SC Channel Status and Control; 0x000030CE ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  ELSA       : 1;
    byte  ELSB       : 1;
    byte  MSA        : 1;
    byte  MSB        : 1;
    byte  CHIE       : 1;
    byte  CHF        : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte  grpELSx    : 2;
    byte  grpMSx     : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM2_C3SCSTR;
extern volatile FTM2_C3SCSTR _FTM2_C3SC @0x000030CE;
#define FTM2_C3SC                 _FTM2_C3SC.Byte
#define FTM2_C3SC_ELSA            _FTM2_C3SC.Bits.ELSA
#define FTM2_C3SC_ELSB            _FTM2_C3SC.Bits.ELSB
#define FTM2_C3SC_MSA             _FTM2_C3SC.Bits.MSA
#define FTM2_C3SC_MSB             _FTM2_C3SC.Bits.MSB
#define FTM2_C3SC_CHIE            _FTM2_C3SC.Bits.CHIE
#define FTM2_C3SC_CHF             _FTM2_C3SC.Bits.CHF
#define FTM2_C3SC_ELSx            _FTM2_C3SC.MergedBits.grpELSx
#define FTM2_C3SC_MSx             _FTM2_C3SC.MergedBits.grpMSx

#define FTM2_C3SC_ELSA_MASK       4U
#define FTM2_C3SC_ELSA_BITNUM     2
#define FTM2_C3SC_ELSB_MASK       8U
#define FTM2_C3SC_ELSB_BITNUM     3
#define FTM2_C3SC_MSA_MASK        16U
#define FTM2_C3SC_MSA_BITNUM      4
#define FTM2_C3SC_MSB_MASK        32U
#define FTM2_C3SC_MSB_BITNUM      5
#define FTM2_C3SC_CHIE_MASK       64U
#define FTM2_C3SC_CHIE_BITNUM     6
#define FTM2_C3SC_CHF_MASK        128U
#define FTM2_C3SC_CHF_BITNUM      7
#define FTM2_C3SC_ELSx_MASK       12U
#define FTM2_C3SC_ELSx_BITNUM     2
#define FTM2_C3SC_MSx_MASK        48U
#define FTM2_C3SC_MSx_BITNUM      4


/*** FTM2_C3V Channel Value  0x000030CF ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM2_C3VH Channel Value High; 0x000030CF ***/
    union {
      byte Byte;
      struct {
        byte  VAL_H0     : 1;
        byte  VAL_H1     : 1;
        byte  VAL_H2     : 1;
        byte  VAL_H3     : 1;
        byte  VAL_H4     : 1;
        byte  VAL_H5     : 1;
        byte  VAL_H6     : 1;
        byte  VAL_H7     : 1;
      } Bits;
    } FTM2_C3VHSTR;
    #define FTM2_C3VH                 _FTM2_C3V.Overlap_STR.FTM2_C3VHSTR.Byte
    #define FTM2_C3VH_VAL_H0          _FTM2_C3V.Overlap_STR.FTM2_C3VHSTR.Bits.VAL_H0
    #define FTM2_C3VH_VAL_H1          _FTM2_C3V.Overlap_STR.FTM2_C3VHSTR.Bits.VAL_H1
    #define FTM2_C3VH_VAL_H2          _FTM2_C3V.Overlap_STR.FTM2_C3VHSTR.Bits.VAL_H2
    #define FTM2_C3VH_VAL_H3          _FTM2_C3V.Overlap_STR.FTM2_C3VHSTR.Bits.VAL_H3
    #define FTM2_C3VH_VAL_H4          _FTM2_C3V.Overlap_STR.FTM2_C3VHSTR.Bits.VAL_H4
    #define FTM2_C3VH_VAL_H5          _FTM2_C3V.Overlap_STR.FTM2_C3VHSTR.Bits.VAL_H5
    #define FTM2_C3VH_VAL_H6          _FTM2_C3V.Overlap_STR.FTM2_C3VHSTR.Bits.VAL_H6
    #define FTM2_C3VH_VAL_H7          _FTM2_C3V.Overlap_STR.FTM2_C3VHSTR.Bits.VAL_H7
    
    #define FTM2_C3VH_VAL_H0_MASK     1U
    #define FTM2_C3VH_VAL_H0_BITNUM   0
    #define FTM2_C3VH_VAL_H1_MASK     2U
    #define FTM2_C3VH_VAL_H1_BITNUM   1
    #define FTM2_C3VH_VAL_H2_MASK     4U
    #define FTM2_C3VH_VAL_H2_BITNUM   2
    #define FTM2_C3VH_VAL_H3_MASK     8U
    #define FTM2_C3VH_VAL_H3_BITNUM   3
    #define FTM2_C3VH_VAL_H4_MASK     16U
    #define FTM2_C3VH_VAL_H4_BITNUM   4
    #define FTM2_C3VH_VAL_H5_MASK     32U
    #define FTM2_C3VH_VAL_H5_BITNUM   5
    #define FTM2_C3VH_VAL_H6_MASK     64U
    #define FTM2_C3VH_VAL_H6_BITNUM   6
    #define FTM2_C3VH_VAL_H7_MASK     128U
    #define FTM2_C3VH_VAL_H7_BITNUM   7
    
    /*** FTM2_C3VL Channel Value Low; 0x000030D0 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_L0     : 1;
        byte  VAL_L1     : 1;
        byte  VAL_L2     : 1;
        byte  VAL_L3     : 1;
        byte  VAL_L4     : 1;
        byte  VAL_L5     : 1;
        byte  VAL_L6     : 1;
        byte  VAL_L7     : 1;
      } Bits;
    } FTM2_C3VLSTR;
    #define FTM2_C3VL                 _FTM2_C3V.Overlap_STR.FTM2_C3VLSTR.Byte
    #define FTM2_C3VL_VAL_L0          _FTM2_C3V.Overlap_STR.FTM2_C3VLSTR.Bits.VAL_L0
    #define FTM2_C3VL_VAL_L1          _FTM2_C3V.Overlap_STR.FTM2_C3VLSTR.Bits.VAL_L1
    #define FTM2_C3VL_VAL_L2          _FTM2_C3V.Overlap_STR.FTM2_C3VLSTR.Bits.VAL_L2
    #define FTM2_C3VL_VAL_L3          _FTM2_C3V.Overlap_STR.FTM2_C3VLSTR.Bits.VAL_L3
    #define FTM2_C3VL_VAL_L4          _FTM2_C3V.Overlap_STR.FTM2_C3VLSTR.Bits.VAL_L4
    #define FTM2_C3VL_VAL_L5          _FTM2_C3V.Overlap_STR.FTM2_C3VLSTR.Bits.VAL_L5
    #define FTM2_C3VL_VAL_L6          _FTM2_C3V.Overlap_STR.FTM2_C3VLSTR.Bits.VAL_L6
    #define FTM2_C3VL_VAL_L7          _FTM2_C3V.Overlap_STR.FTM2_C3VLSTR.Bits.VAL_L7
    
    #define FTM2_C3VL_VAL_L0_MASK     1U
    #define FTM2_C3VL_VAL_L0_BITNUM   0
    #define FTM2_C3VL_VAL_L1_MASK     2U
    #define FTM2_C3VL_VAL_L1_BITNUM   1
    #define FTM2_C3VL_VAL_L2_MASK     4U
    #define FTM2_C3VL_VAL_L2_BITNUM   2
    #define FTM2_C3VL_VAL_L3_MASK     8U
    #define FTM2_C3VL_VAL_L3_BITNUM   3
    #define FTM2_C3VL_VAL_L4_MASK     16U
    #define FTM2_C3VL_VAL_L4_BITNUM   4
    #define FTM2_C3VL_VAL_L5_MASK     32U
    #define FTM2_C3VL_VAL_L5_BITNUM   5
    #define FTM2_C3VL_VAL_L6_MASK     64U
    #define FTM2_C3VL_VAL_L6_BITNUM   6
    #define FTM2_C3VL_VAL_L7_MASK     128U
    #define FTM2_C3VL_VAL_L7_BITNUM   7
    
  } Overlap_STR;
} FTM2_C3VSTR;
extern volatile FTM2_C3VSTR _FTM2_C3V @0x000030CF;
#define FTM2_C3V                  _FTM2_C3V.Word


/*** FTM2_C4SC Channel Status and Control; 0x000030D1 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  ELSA       : 1;
    byte  ELSB       : 1;
    byte  MSA        : 1;
    byte  MSB        : 1;
    byte  CHIE       : 1;
    byte  CHF        : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte  grpELSx    : 2;
    byte  grpMSx     : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM2_C4SCSTR;
extern volatile FTM2_C4SCSTR _FTM2_C4SC @0x000030D1;
#define FTM2_C4SC                 _FTM2_C4SC.Byte
#define FTM2_C4SC_ELSA            _FTM2_C4SC.Bits.ELSA
#define FTM2_C4SC_ELSB            _FTM2_C4SC.Bits.ELSB
#define FTM2_C4SC_MSA             _FTM2_C4SC.Bits.MSA
#define FTM2_C4SC_MSB             _FTM2_C4SC.Bits.MSB
#define FTM2_C4SC_CHIE            _FTM2_C4SC.Bits.CHIE
#define FTM2_C4SC_CHF             _FTM2_C4SC.Bits.CHF
#define FTM2_C4SC_ELSx            _FTM2_C4SC.MergedBits.grpELSx
#define FTM2_C4SC_MSx             _FTM2_C4SC.MergedBits.grpMSx

#define FTM2_C4SC_ELSA_MASK       4U
#define FTM2_C4SC_ELSA_BITNUM     2
#define FTM2_C4SC_ELSB_MASK       8U
#define FTM2_C4SC_ELSB_BITNUM     3
#define FTM2_C4SC_MSA_MASK        16U
#define FTM2_C4SC_MSA_BITNUM      4
#define FTM2_C4SC_MSB_MASK        32U
#define FTM2_C4SC_MSB_BITNUM      5
#define FTM2_C4SC_CHIE_MASK       64U
#define FTM2_C4SC_CHIE_BITNUM     6
#define FTM2_C4SC_CHF_MASK        128U
#define FTM2_C4SC_CHF_BITNUM      7
#define FTM2_C4SC_ELSx_MASK       12U
#define FTM2_C4SC_ELSx_BITNUM     2
#define FTM2_C4SC_MSx_MASK        48U
#define FTM2_C4SC_MSx_BITNUM      4


/*** FTM2_C4V Channel Value  0x000030D2 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM2_C4VH Channel Value High; 0x000030D2 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_H0     : 1;
        byte  VAL_H1     : 1;
        byte  VAL_H2     : 1;
        byte  VAL_H3     : 1;
        byte  VAL_H4     : 1;
        byte  VAL_H5     : 1;
        byte  VAL_H6     : 1;
        byte  VAL_H7     : 1;
      } Bits;
    } FTM2_C4VHSTR;
    #define FTM2_C4VH                 _FTM2_C4V.Overlap_STR.FTM2_C4VHSTR.Byte
    #define FTM2_C4VH_VAL_H0          _FTM2_C4V.Overlap_STR.FTM2_C4VHSTR.Bits.VAL_H0
    #define FTM2_C4VH_VAL_H1          _FTM2_C4V.Overlap_STR.FTM2_C4VHSTR.Bits.VAL_H1
    #define FTM2_C4VH_VAL_H2          _FTM2_C4V.Overlap_STR.FTM2_C4VHSTR.Bits.VAL_H2
    #define FTM2_C4VH_VAL_H3          _FTM2_C4V.Overlap_STR.FTM2_C4VHSTR.Bits.VAL_H3
    #define FTM2_C4VH_VAL_H4          _FTM2_C4V.Overlap_STR.FTM2_C4VHSTR.Bits.VAL_H4
    #define FTM2_C4VH_VAL_H5          _FTM2_C4V.Overlap_STR.FTM2_C4VHSTR.Bits.VAL_H5
    #define FTM2_C4VH_VAL_H6          _FTM2_C4V.Overlap_STR.FTM2_C4VHSTR.Bits.VAL_H6
    #define FTM2_C4VH_VAL_H7          _FTM2_C4V.Overlap_STR.FTM2_C4VHSTR.Bits.VAL_H7
    
    #define FTM2_C4VH_VAL_H0_MASK     1U
    #define FTM2_C4VH_VAL_H0_BITNUM   0
    #define FTM2_C4VH_VAL_H1_MASK     2U
    #define FTM2_C4VH_VAL_H1_BITNUM   1
    #define FTM2_C4VH_VAL_H2_MASK     4U
    #define FTM2_C4VH_VAL_H2_BITNUM   2
    #define FTM2_C4VH_VAL_H3_MASK     8U
    #define FTM2_C4VH_VAL_H3_BITNUM   3
    #define FTM2_C4VH_VAL_H4_MASK     16U
    #define FTM2_C4VH_VAL_H4_BITNUM   4
    #define FTM2_C4VH_VAL_H5_MASK     32U
    #define FTM2_C4VH_VAL_H5_BITNUM   5
    #define FTM2_C4VH_VAL_H6_MASK     64U
    #define FTM2_C4VH_VAL_H6_BITNUM   6
    #define FTM2_C4VH_VAL_H7_MASK     128U
    #define FTM2_C4VH_VAL_H7_BITNUM   7
    
    /*** FTM2_C4VL Channel Value Low; 0x000030D3 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_L0     : 1;
        byte  VAL_L1     : 1;
        byte  VAL_L2     : 1;
        byte  VAL_L3     : 1;
        byte  VAL_L4     : 1;
        byte  VAL_L5     : 1;
        byte  VAL_L6     : 1;
        byte  VAL_L7     : 1;
      } Bits;
    } FTM2_C4VLSTR;
    #define FTM2_C4VL                 _FTM2_C4V.Overlap_STR.FTM2_C4VLSTR.Byte
    #define FTM2_C4VL_VAL_L0          _FTM2_C4V.Overlap_STR.FTM2_C4VLSTR.Bits.VAL_L0
    #define FTM2_C4VL_VAL_L1          _FTM2_C4V.Overlap_STR.FTM2_C4VLSTR.Bits.VAL_L1
    #define FTM2_C4VL_VAL_L2          _FTM2_C4V.Overlap_STR.FTM2_C4VLSTR.Bits.VAL_L2
    #define FTM2_C4VL_VAL_L3          _FTM2_C4V.Overlap_STR.FTM2_C4VLSTR.Bits.VAL_L3
    #define FTM2_C4VL_VAL_L4          _FTM2_C4V.Overlap_STR.FTM2_C4VLSTR.Bits.VAL_L4
    #define FTM2_C4VL_VAL_L5          _FTM2_C4V.Overlap_STR.FTM2_C4VLSTR.Bits.VAL_L5
    #define FTM2_C4VL_VAL_L6          _FTM2_C4V.Overlap_STR.FTM2_C4VLSTR.Bits.VAL_L6
    #define FTM2_C4VL_VAL_L7          _FTM2_C4V.Overlap_STR.FTM2_C4VLSTR.Bits.VAL_L7
    
    #define FTM2_C4VL_VAL_L0_MASK     1U
    #define FTM2_C4VL_VAL_L0_BITNUM   0
    #define FTM2_C4VL_VAL_L1_MASK     2U
    #define FTM2_C4VL_VAL_L1_BITNUM   1
    #define FTM2_C4VL_VAL_L2_MASK     4U
    #define FTM2_C4VL_VAL_L2_BITNUM   2
    #define FTM2_C4VL_VAL_L3_MASK     8U
    #define FTM2_C4VL_VAL_L3_BITNUM   3
    #define FTM2_C4VL_VAL_L4_MASK     16U
    #define FTM2_C4VL_VAL_L4_BITNUM   4
    #define FTM2_C4VL_VAL_L5_MASK     32U
    #define FTM2_C4VL_VAL_L5_BITNUM   5
    #define FTM2_C4VL_VAL_L6_MASK     64U
    #define FTM2_C4VL_VAL_L6_BITNUM   6
    #define FTM2_C4VL_VAL_L7_MASK     128U
    #define FTM2_C4VL_VAL_L7_BITNUM   7
    
  } Overlap_STR;
} FTM2_C4VSTR;
extern volatile FTM2_C4VSTR _FTM2_C4V @0x000030D2;
#define FTM2_C4V                  _FTM2_C4V.Word


/*** FTM2_C5SC Channel Status and Control; 0x000030D4 ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte  ELSA       : 1;
    byte  ELSB       : 1;
    byte  MSA        : 1;
    byte  MSB        : 1;
    byte  CHIE       : 1;
    byte  CHF        : 1;
  } Bits;
  struct {
    byte             : 1;
    byte             : 1;
    byte  grpELSx    : 2;
    byte  grpMSx     : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} FTM2_C5SCSTR;
extern volatile FTM2_C5SCSTR _FTM2_C5SC @0x000030D4;
#define FTM2_C5SC                 _FTM2_C5SC.Byte
#define FTM2_C5SC_ELSA            _FTM2_C5SC.Bits.ELSA
#define FTM2_C5SC_ELSB            _FTM2_C5SC.Bits.ELSB
#define FTM2_C5SC_MSA             _FTM2_C5SC.Bits.MSA
#define FTM2_C5SC_MSB             _FTM2_C5SC.Bits.MSB
#define FTM2_C5SC_CHIE            _FTM2_C5SC.Bits.CHIE
#define FTM2_C5SC_CHF             _FTM2_C5SC.Bits.CHF
#define FTM2_C5SC_ELSx            _FTM2_C5SC.MergedBits.grpELSx
#define FTM2_C5SC_MSx             _FTM2_C5SC.MergedBits.grpMSx

#define FTM2_C5SC_ELSA_MASK       4U
#define FTM2_C5SC_ELSA_BITNUM     2
#define FTM2_C5SC_ELSB_MASK       8U
#define FTM2_C5SC_ELSB_BITNUM     3
#define FTM2_C5SC_MSA_MASK        16U
#define FTM2_C5SC_MSA_BITNUM      4
#define FTM2_C5SC_MSB_MASK        32U
#define FTM2_C5SC_MSB_BITNUM      5
#define FTM2_C5SC_CHIE_MASK       64U
#define FTM2_C5SC_CHIE_BITNUM     6
#define FTM2_C5SC_CHF_MASK        128U
#define FTM2_C5SC_CHF_BITNUM      7
#define FTM2_C5SC_ELSx_MASK       12U
#define FTM2_C5SC_ELSx_BITNUM     2
#define FTM2_C5SC_MSx_MASK        48U
#define FTM2_C5SC_MSx_BITNUM      4


/*** FTM2_C5V Channel Value  0x000030D5 ***/
typedef union {
  word Word;
  /* Overlapped registers: */
  struct {

    /*** FTM2_C5VH Channel Value High; 0x000030D5 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_H0     : 1;
        byte  VAL_H1     : 1;
        byte  VAL_H2     : 1;
        byte  VAL_H3     : 1;
        byte  VAL_H4     : 1;
        byte  VAL_H5     : 1;
        byte  VAL_H6     : 1;
        byte  VAL_H7     : 1;
      } Bits;
    } FTM2_C5VHSTR;
    #define FTM2_C5VH                 _FTM2_C5V.Overlap_STR.FTM2_C5VHSTR.Byte
    #define FTM2_C5VH_VAL_H0          _FTM2_C5V.Overlap_STR.FTM2_C5VHSTR.Bits.VAL_H0
    #define FTM2_C5VH_VAL_H1          _FTM2_C5V.Overlap_STR.FTM2_C5VHSTR.Bits.VAL_H1
    #define FTM2_C5VH_VAL_H2          _FTM2_C5V.Overlap_STR.FTM2_C5VHSTR.Bits.VAL_H2
    #define FTM2_C5VH_VAL_H3          _FTM2_C5V.Overlap_STR.FTM2_C5VHSTR.Bits.VAL_H3
    #define FTM2_C5VH_VAL_H4          _FTM2_C5V.Overlap_STR.FTM2_C5VHSTR.Bits.VAL_H4
    #define FTM2_C5VH_VAL_H5          _FTM2_C5V.Overlap_STR.FTM2_C5VHSTR.Bits.VAL_H5
    #define FTM2_C5VH_VAL_H6          _FTM2_C5V.Overlap_STR.FTM2_C5VHSTR.Bits.VAL_H6
    #define FTM2_C5VH_VAL_H7          _FTM2_C5V.Overlap_STR.FTM2_C5VHSTR.Bits.VAL_H7
    
    #define FTM2_C5VH_VAL_H0_MASK     1U
    #define FTM2_C5VH_VAL_H0_BITNUM   0
    #define FTM2_C5VH_VAL_H1_MASK     2U
    #define FTM2_C5VH_VAL_H1_BITNUM   1
    #define FTM2_C5VH_VAL_H2_MASK     4U
    #define FTM2_C5VH_VAL_H2_BITNUM   2
    #define FTM2_C5VH_VAL_H3_MASK     8U
    #define FTM2_C5VH_VAL_H3_BITNUM   3
    #define FTM2_C5VH_VAL_H4_MASK     16U
    #define FTM2_C5VH_VAL_H4_BITNUM   4
    #define FTM2_C5VH_VAL_H5_MASK     32U
    #define FTM2_C5VH_VAL_H5_BITNUM   5
    #define FTM2_C5VH_VAL_H6_MASK     64U
    #define FTM2_C5VH_VAL_H6_BITNUM   6
    #define FTM2_C5VH_VAL_H7_MASK     128U
    #define FTM2_C5VH_VAL_H7_BITNUM   7
    
    /*** FTM2_C5VL Channel Value Low; 0x000030D6 ***/
    union {
      byte Byte;
      struct {
        byte  VAL_L0     : 1;
        byte  VAL_L1     : 1;
        byte  VAL_L2     : 1;
        byte  VAL_L3     : 1;
        byte  VAL_L4     : 1;
        byte  VAL_L5     : 1;
        byte  VAL_L6     : 1;
        byte  VAL_L7     : 1;
      } Bits;
    } FTM2_C5VLSTR;
    #define FTM2_C5VL                 _FTM2_C5V.Overlap_STR.FTM2_C5VLSTR.Byte
    #define FTM2_C5VL_VAL_L0          _FTM2_C5V.Overlap_STR.FTM2_C5VLSTR.Bits.VAL_L0
    #define FTM2_C5VL_VAL_L1          _FTM2_C5V.Overlap_STR.FTM2_C5VLSTR.Bits.VAL_L1
    #define FTM2_C5VL_VAL_L2          _FTM2_C5V.Overlap_STR.FTM2_C5VLSTR.Bits.VAL_L2
    #define FTM2_C5VL_VAL_L3          _FTM2_C5V.Overlap_STR.FTM2_C5VLSTR.Bits.VAL_L3
    #define FTM2_C5VL_VAL_L4          _FTM2_C5V.Overlap_STR.FTM2_C5VLSTR.Bits.VAL_L4
    #define FTM2_C5VL_VAL_L5          _FTM2_C5V.Overlap_STR.FTM2_C5VLSTR.Bits.VAL_L5
    #define FTM2_C5VL_VAL_L6          _FTM2_C5V.Overlap_STR.FTM2_C5VLSTR.Bits.VAL_L6
    #define FTM2_C5VL_VAL_L7          _FTM2_C5V.Overlap_STR.FTM2_C5VLSTR.Bits.VAL_L7
    
    #define FTM2_C5VL_VAL_L0_MASK     1U
    #define FTM2_C5VL_VAL_L0_BITNUM   0
    #define FTM2_C5VL_VAL_L1_MASK     2U
    #define FTM2_C5VL_VAL_L1_BITNUM   1
    #define FTM2_C5VL_VAL_L2_MASK     4U
    #define FTM2_C5VL_VAL_L2_BITNUM   2
    #define FTM2_C5VL_VAL_L3_MASK     8U
    #define FTM2_C5VL_VAL_L3_BITNUM   3
    #define FTM2_C5VL_VAL_L4_MASK     16U
    #define FTM2_C5VL_VAL_L4_BITNUM   4
    #define FTM2_C5VL_VAL_L5_MASK     32U
    #define FTM2_C5VL_VAL_L5_BITNUM   5
    #define FTM2_C5VL_VAL_L6_MASK     64U
    #define FTM2_C5VL_VAL_L6_BITNUM   6
    #define FTM2_C5VL_VAL_L7_MASK     128U
    #define FTM2_C5VL_VAL_L7_BITNUM   7
    
  } Overlap_STR;
} FTM2_C5VSTR;
extern volatile FTM2_C5VSTR _FTM2_C5V @0x000030D5;
#define FTM2_C5V                  _FTM2_C5V.Word


/*** FDS_CS FDS Control and Status Register; 0x000030DD ***/
typedef union {
  byte Byte;
  struct {
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte  FORCEF     : 1;
    byte  FDEN       : 1;
    byte  FDIE       : 1;
    byte  FDF        : 1;
  } Bits;
} FDS_CSSTR;
extern volatile FDS_CSSTR _FDS_CS @0x000030DD;
#define FDS_CS                    _FDS_CS.Byte
#define FDS_CS_FORCEF             _FDS_CS.Bits.FORCEF
#define FDS_CS_FDEN               _FDS_CS.Bits.FDEN
#define FDS_CS_FDIE               _FDS_CS.Bits.FDIE
#define FDS_CS_FDF                _FDS_CS.Bits.FDF

#define FDS_CS_FORCEF_MASK        16U
#define FDS_CS_FORCEF_BITNUM      4
#define FDS_CS_FDEN_MASK          32U
#define FDS_CS_FDEN_BITNUM        5
#define FDS_CS_FDIE_MASK          64U
#define FDS_CS_FDIE_BITNUM        6
#define FDS_CS_FDF_MASK           128U
#define FDS_CS_FDF_BITNUM         7


/*** FDS_INE FDS Input Enable Register; 0x000030DE ***/
typedef union {
  byte Byte;
  struct {
    byte  FINE0      : 1;
    byte  FINE1      : 1;
    byte  FINE2      : 1;
    byte  FINE3      : 1;
    byte  FINE4      : 1;
    byte  FINE5      : 1;
    byte  FINE6      : 1;
    byte  FINE7      : 1;
  } Bits;
} FDS_INESTR;
extern volatile FDS_INESTR _FDS_INE @0x000030DE;
#define FDS_INE                   _FDS_INE.Byte
#define FDS_INE_FINE0             _FDS_INE.Bits.FINE0
#define FDS_INE_FINE1             _FDS_INE.Bits.FINE1
#define FDS_INE_FINE2             _FDS_INE.Bits.FINE2
#define FDS_INE_FINE3             _FDS_INE.Bits.FINE3
#define FDS_INE_FINE4             _FDS_INE.Bits.FINE4
#define FDS_INE_FINE5             _FDS_INE.Bits.FINE5
#define FDS_INE_FINE6             _FDS_INE.Bits.FINE6
#define FDS_INE_FINE7             _FDS_INE.Bits.FINE7

#define FDS_INE_FINE0_MASK        1U
#define FDS_INE_FINE0_BITNUM      0
#define FDS_INE_FINE1_MASK        2U
#define FDS_INE_FINE1_BITNUM      1
#define FDS_INE_FINE2_MASK        4U
#define FDS_INE_FINE2_BITNUM      2
#define FDS_INE_FINE3_MASK        8U
#define FDS_INE_FINE3_BITNUM      3
#define FDS_INE_FINE4_MASK        16U
#define FDS_INE_FINE4_BITNUM      4
#define FDS_INE_FINE5_MASK        32U
#define FDS_INE_FINE5_BITNUM      5
#define FDS_INE_FINE6_MASK        64U
#define FDS_INE_FINE6_BITNUM      6
#define FDS_INE_FINE7_MASK        128U
#define FDS_INE_FINE7_BITNUM      7


/*** FDS_PCE FDS Pin Configuration Enable Register; 0x000030DF ***/
typedef union {
  byte Byte;
  struct {
    byte  FPCE0      : 1;
    byte  FPCE1      : 1;
    byte  FPCE2      : 1;
    byte  FPCE3      : 1;
    byte  FPCE4      : 1;
    byte  FPCE5      : 1;
    byte  FPCE6      : 1;
    byte  FPCE7      : 1;
  } Bits;
} FDS_PCESTR;
extern volatile FDS_PCESTR _FDS_PCE @0x000030DF;
#define FDS_PCE                   _FDS_PCE.Byte
#define FDS_PCE_FPCE0             _FDS_PCE.Bits.FPCE0
#define FDS_PCE_FPCE1             _FDS_PCE.Bits.FPCE1
#define FDS_PCE_FPCE2             _FDS_PCE.Bits.FPCE2
#define FDS_PCE_FPCE3             _FDS_PCE.Bits.FPCE3
#define FDS_PCE_FPCE4             _FDS_PCE.Bits.FPCE4
#define FDS_PCE_FPCE5             _FDS_PCE.Bits.FPCE5
#define FDS_PCE_FPCE6             _FDS_PCE.Bits.FPCE6
#define FDS_PCE_FPCE7             _FDS_PCE.Bits.FPCE7

#define FDS_PCE_FPCE0_MASK        1U
#define FDS_PCE_FPCE0_BITNUM      0
#define FDS_PCE_FPCE1_MASK        2U
#define FDS_PCE_FPCE1_BITNUM      1
#define FDS_PCE_FPCE2_MASK        4U
#define FDS_PCE_FPCE2_BITNUM      2
#define FDS_PCE_FPCE3_MASK        8U
#define FDS_PCE_FPCE3_BITNUM      3
#define FDS_PCE_FPCE4_MASK        16U
#define FDS_PCE_FPCE4_BITNUM      4
#define FDS_PCE_FPCE5_MASK        32U
#define FDS_PCE_FPCE5_BITNUM      5
#define FDS_PCE_FPCE6_MASK        64U
#define FDS_PCE_FPCE6_BITNUM      6
#define FDS_PCE_FPCE7_MASK        128U
#define FDS_PCE_FPCE7_BITNUM      7


/*** FDS_PCD FDS Pin Configuration Direction Register (FDSPCD); 0x000030E0 ***/
typedef union {
  byte Byte;
  struct {
    byte  FPCD0      : 1;
    byte  FPCD1      : 1;
    byte  FPCD2      : 1;
    byte  FPCD3      : 1;
    byte  FPCD4      : 1;
    byte  FPCD5      : 1;
    byte  FPCD6      : 1;
    byte  FPCD7      : 1;
  } Bits;
} FDS_PCDSTR;
extern volatile FDS_PCDSTR _FDS_PCD @0x000030E0;
#define FDS_PCD                   _FDS_PCD.Byte
#define FDS_PCD_FPCD0             _FDS_PCD.Bits.FPCD0
#define FDS_PCD_FPCD1             _FDS_PCD.Bits.FPCD1
#define FDS_PCD_FPCD2             _FDS_PCD.Bits.FPCD2
#define FDS_PCD_FPCD3             _FDS_PCD.Bits.FPCD3
#define FDS_PCD_FPCD4             _FDS_PCD.Bits.FPCD4
#define FDS_PCD_FPCD5             _FDS_PCD.Bits.FPCD5
#define FDS_PCD_FPCD6             _FDS_PCD.Bits.FPCD6
#define FDS_PCD_FPCD7             _FDS_PCD.Bits.FPCD7

#define FDS_PCD_FPCD0_MASK        1U
#define FDS_PCD_FPCD0_BITNUM      0
#define FDS_PCD_FPCD1_MASK        2U
#define FDS_PCD_FPCD1_BITNUM      1
#define FDS_PCD_FPCD2_MASK        4U
#define FDS_PCD_FPCD2_BITNUM      2
#define FDS_PCD_FPCD3_MASK        8U
#define FDS_PCD_FPCD3_BITNUM      3
#define FDS_PCD_FPCD4_MASK        16U
#define FDS_PCD_FPCD4_BITNUM      4
#define FDS_PCD_FPCD5_MASK        32U
#define FDS_PCD_FPCD5_BITNUM      5
#define FDS_PCD_FPCD6_MASK        64U
#define FDS_PCD_FPCD6_BITNUM      6
#define FDS_PCD_FPCD7_MASK        128U
#define FDS_PCD_FPCD7_BITNUM      7


/*** FDS_PCV FDS Pin Configuration Value Register; 0x000030E1 ***/
typedef union {
  byte Byte;
  struct {
    byte  FPCV0      : 1;
    byte  FPCV1      : 1;
    byte  FPCV2      : 1;
    byte  FPCV3      : 1;
    byte  FPCV4      : 1;
    byte  FPCV5      : 1;
    byte  FPCV6      : 1;
    byte  FPCV7      : 1;
  } Bits;
} FDS_PCVSTR;
extern volatile FDS_PCVSTR _FDS_PCV @0x000030E1;
#define FDS_PCV                   _FDS_PCV.Byte
#define FDS_PCV_FPCV0             _FDS_PCV.Bits.FPCV0
#define FDS_PCV_FPCV1             _FDS_PCV.Bits.FPCV1
#define FDS_PCV_FPCV2             _FDS_PCV.Bits.FPCV2
#define FDS_PCV_FPCV3             _FDS_PCV.Bits.FPCV3
#define FDS_PCV_FPCV4             _FDS_PCV.Bits.FPCV4
#define FDS_PCV_FPCV5             _FDS_PCV.Bits.FPCV5
#define FDS_PCV_FPCV6             _FDS_PCV.Bits.FPCV6
#define FDS_PCV_FPCV7             _FDS_PCV.Bits.FPCV7

#define FDS_PCV_FPCV0_MASK        1U
#define FDS_PCV_FPCV0_BITNUM      0
#define FDS_PCV_FPCV1_MASK        2U
#define FDS_PCV_FPCV1_BITNUM      1
#define FDS_PCV_FPCV2_MASK        4U
#define FDS_PCV_FPCV2_BITNUM      2
#define FDS_PCV_FPCV3_MASK        8U
#define FDS_PCV_FPCV3_BITNUM      3
#define FDS_PCV_FPCV4_MASK        16U
#define FDS_PCV_FPCV4_BITNUM      4
#define FDS_PCV_FPCV5_MASK        32U
#define FDS_PCV_FPCV5_BITNUM      5
#define FDS_PCV_FPCV6_MASK        64U
#define FDS_PCV_FPCV6_BITNUM      6
#define FDS_PCV_FPCV7_MASK        128U
#define FDS_PCV_FPCV7_BITNUM      7


/*** FDS_INL FDS Input Latched Register; 0x000030E2 ***/
typedef union {
  byte Byte;
  struct {
    byte  FINL0      : 1;
    byte  FINL1      : 1;
    byte  FINL2      : 1;
    byte  FINL3      : 1;
    byte  FINL4      : 1;
    byte  FINL5      : 1;
    byte  FINL6      : 1;
    byte  FINL7      : 1;
  } Bits;
} FDS_INLSTR;
extern volatile FDS_INLSTR _FDS_INL @0x000030E2;
#define FDS_INL                   _FDS_INL.Byte
#define FDS_INL_FINL0             _FDS_INL.Bits.FINL0
#define FDS_INL_FINL1             _FDS_INL.Bits.FINL1
#define FDS_INL_FINL2             _FDS_INL.Bits.FINL2
#define FDS_INL_FINL3             _FDS_INL.Bits.FINL3
#define FDS_INL_FINL4             _FDS_INL.Bits.FINL4
#define FDS_INL_FINL5             _FDS_INL.Bits.FINL5
#define FDS_INL_FINL6             _FDS_INL.Bits.FINL6
#define FDS_INL_FINL7             _FDS_INL.Bits.FINL7

#define FDS_INL_FINL0_MASK        1U
#define FDS_INL_FINL0_BITNUM      0
#define FDS_INL_FINL1_MASK        2U
#define FDS_INL_FINL1_BITNUM      1
#define FDS_INL_FINL2_MASK        4U
#define FDS_INL_FINL2_BITNUM      2
#define FDS_INL_FINL3_MASK        8U
#define FDS_INL_FINL3_BITNUM      3
#define FDS_INL_FINL4_MASK        16U
#define FDS_INL_FINL4_BITNUM      4
#define FDS_INL_FINL5_MASK        32U
#define FDS_INL_FINL5_BITNUM      5
#define FDS_INL_FINL6_MASK        64U
#define FDS_INL_FINL6_BITNUM      6
#define FDS_INL_FINL7_MASK        128U
#define FDS_INL_FINL7_BITNUM      7


/*** PORT_IOFLT0 Port Filter Register 0; 0x000030EC ***/
typedef union {
  byte Byte;
  struct {
    byte  FLTA0      : 1;
    byte  FLTA1      : 1;
    byte  FLTB0      : 1;
    byte  FLTB1      : 1;
    byte  FLTC0      : 1;
    byte  FLTC1      : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpFLTA    : 2;
    byte  grpFLTB    : 2;
    byte  grpFLTC    : 2;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PORT_IOFLT0STR;
extern volatile PORT_IOFLT0STR _PORT_IOFLT0 @0x000030EC;
#define PORT_IOFLT0               _PORT_IOFLT0.Byte
#define PORT_IOFLT0_FLTA0         _PORT_IOFLT0.Bits.FLTA0
#define PORT_IOFLT0_FLTA1         _PORT_IOFLT0.Bits.FLTA1
#define PORT_IOFLT0_FLTB0         _PORT_IOFLT0.Bits.FLTB0
#define PORT_IOFLT0_FLTB1         _PORT_IOFLT0.Bits.FLTB1
#define PORT_IOFLT0_FLTC0         _PORT_IOFLT0.Bits.FLTC0
#define PORT_IOFLT0_FLTC1         _PORT_IOFLT0.Bits.FLTC1
#define PORT_IOFLT0_FLTA          _PORT_IOFLT0.MergedBits.grpFLTA
#define PORT_IOFLT0_FLTB          _PORT_IOFLT0.MergedBits.grpFLTB
#define PORT_IOFLT0_FLTC          _PORT_IOFLT0.MergedBits.grpFLTC

#define PORT_IOFLT0_FLTA0_MASK    1U
#define PORT_IOFLT0_FLTA0_BITNUM  0
#define PORT_IOFLT0_FLTA1_MASK    2U
#define PORT_IOFLT0_FLTA1_BITNUM  1
#define PORT_IOFLT0_FLTB0_MASK    4U
#define PORT_IOFLT0_FLTB0_BITNUM  2
#define PORT_IOFLT0_FLTB1_MASK    8U
#define PORT_IOFLT0_FLTB1_BITNUM  3
#define PORT_IOFLT0_FLTC0_MASK    16U
#define PORT_IOFLT0_FLTC0_BITNUM  4
#define PORT_IOFLT0_FLTC1_MASK    32U
#define PORT_IOFLT0_FLTC1_BITNUM  5
#define PORT_IOFLT0_FLTA_MASK     3U
#define PORT_IOFLT0_FLTA_BITNUM   0
#define PORT_IOFLT0_FLTB_MASK     12U
#define PORT_IOFLT0_FLTB_BITNUM   2
#define PORT_IOFLT0_FLTC_MASK     48U
#define PORT_IOFLT0_FLTC_BITNUM   4


/*** PORT_IOFLT2 Port Filter Register 2; 0x000030EE ***/
typedef union {
  byte Byte;
  struct {
    byte  FLTRST0    : 1;
    byte  FLTRST1    : 1;
    byte  FLTKBI00   : 1;
    byte  FLTKBI01   : 1;
    byte  FLTPWT0    : 1;
    byte  FLTPWT1    : 1;
    byte  FLTFDS0    : 1;
    byte  FLTFDS1    : 1;
  } Bits;
  struct {
    byte  grpFLTRST  : 2;
    byte  grpFLTKBI0 : 2;
    byte  grpFLTPWT  : 2;
    byte  grpFLTFDS  : 2;
  } MergedBits;
} PORT_IOFLT2STR;
extern volatile PORT_IOFLT2STR _PORT_IOFLT2 @0x000030EE;
#define PORT_IOFLT2               _PORT_IOFLT2.Byte
#define PORT_IOFLT2_FLTRST0       _PORT_IOFLT2.Bits.FLTRST0
#define PORT_IOFLT2_FLTRST1       _PORT_IOFLT2.Bits.FLTRST1
#define PORT_IOFLT2_FLTKBI00      _PORT_IOFLT2.Bits.FLTKBI00
#define PORT_IOFLT2_FLTKBI01      _PORT_IOFLT2.Bits.FLTKBI01
#define PORT_IOFLT2_FLTPWT0       _PORT_IOFLT2.Bits.FLTPWT0
#define PORT_IOFLT2_FLTPWT1       _PORT_IOFLT2.Bits.FLTPWT1
#define PORT_IOFLT2_FLTFDS0       _PORT_IOFLT2.Bits.FLTFDS0
#define PORT_IOFLT2_FLTFDS1       _PORT_IOFLT2.Bits.FLTFDS1
#define PORT_IOFLT2_FLTRST        _PORT_IOFLT2.MergedBits.grpFLTRST
#define PORT_IOFLT2_FLTKBI0       _PORT_IOFLT2.MergedBits.grpFLTKBI0
#define PORT_IOFLT2_FLTPWT        _PORT_IOFLT2.MergedBits.grpFLTPWT
#define PORT_IOFLT2_FLTFDS        _PORT_IOFLT2.MergedBits.grpFLTFDS

#define PORT_IOFLT2_FLTRST0_MASK  1U
#define PORT_IOFLT2_FLTRST0_BITNUM 0
#define PORT_IOFLT2_FLTRST1_MASK  2U
#define PORT_IOFLT2_FLTRST1_BITNUM 1
#define PORT_IOFLT2_FLTKBI00_MASK 4U
#define PORT_IOFLT2_FLTKBI00_BITNUM 2
#define PORT_IOFLT2_FLTKBI01_MASK 8U
#define PORT_IOFLT2_FLTKBI01_BITNUM 3
#define PORT_IOFLT2_FLTPWT0_MASK  16U
#define PORT_IOFLT2_FLTPWT0_BITNUM 4
#define PORT_IOFLT2_FLTPWT1_MASK  32U
#define PORT_IOFLT2_FLTPWT1_BITNUM 5
#define PORT_IOFLT2_FLTFDS0_MASK  64U
#define PORT_IOFLT2_FLTFDS0_BITNUM 6
#define PORT_IOFLT2_FLTFDS1_MASK  128U
#define PORT_IOFLT2_FLTFDS1_BITNUM 7
#define PORT_IOFLT2_FLTRST_MASK   3U
#define PORT_IOFLT2_FLTRST_BITNUM 0
#define PORT_IOFLT2_FLTKBI0_MASK  12U
#define PORT_IOFLT2_FLTKBI0_BITNUM 2
#define PORT_IOFLT2_FLTPWT_MASK   48U
#define PORT_IOFLT2_FLTPWT_BITNUM 4
#define PORT_IOFLT2_FLTFDS_MASK   192U
#define PORT_IOFLT2_FLTFDS_BITNUM 6


/*** PORT_FCLKDIV Port Clock Division Register; 0x000030EF ***/
typedef union {
  byte Byte;
  struct {
    byte  FLTDIV10   : 1;
    byte  FLTDIV11   : 1;
    byte  FLTDIV20   : 1;
    byte  FLTDIV21   : 1;
    byte  FLTDIV22   : 1;
    byte  FLTDIV30   : 1;
    byte  FLTDIV31   : 1;
    byte  FLTDIV32   : 1;
  } Bits;
  struct {
    byte  grpFLTDIV1 : 2;
    byte  grpFLTDIV2 : 3;
    byte  grpFLTDIV3 : 3;
  } MergedBits;
} PORT_FCLKDIVSTR;
extern volatile PORT_FCLKDIVSTR _PORT_FCLKDIV @0x000030EF;
#define PORT_FCLKDIV              _PORT_FCLKDIV.Byte
#define PORT_FCLKDIV_FLTDIV10     _PORT_FCLKDIV.Bits.FLTDIV10
#define PORT_FCLKDIV_FLTDIV11     _PORT_FCLKDIV.Bits.FLTDIV11
#define PORT_FCLKDIV_FLTDIV20     _PORT_FCLKDIV.Bits.FLTDIV20
#define PORT_FCLKDIV_FLTDIV21     _PORT_FCLKDIV.Bits.FLTDIV21
#define PORT_FCLKDIV_FLTDIV22     _PORT_FCLKDIV.Bits.FLTDIV22
#define PORT_FCLKDIV_FLTDIV30     _PORT_FCLKDIV.Bits.FLTDIV30
#define PORT_FCLKDIV_FLTDIV31     _PORT_FCLKDIV.Bits.FLTDIV31
#define PORT_FCLKDIV_FLTDIV32     _PORT_FCLKDIV.Bits.FLTDIV32
#define PORT_FCLKDIV_FLTDIV1      _PORT_FCLKDIV.MergedBits.grpFLTDIV1
#define PORT_FCLKDIV_FLTDIV2      _PORT_FCLKDIV.MergedBits.grpFLTDIV2
#define PORT_FCLKDIV_FLTDIV3      _PORT_FCLKDIV.MergedBits.grpFLTDIV3

#define PORT_FCLKDIV_FLTDIV10_MASK 1U
#define PORT_FCLKDIV_FLTDIV10_BITNUM 0
#define PORT_FCLKDIV_FLTDIV11_MASK 2U
#define PORT_FCLKDIV_FLTDIV11_BITNUM 1
#define PORT_FCLKDIV_FLTDIV20_MASK 4U
#define PORT_FCLKDIV_FLTDIV20_BITNUM 2
#define PORT_FCLKDIV_FLTDIV21_MASK 8U
#define PORT_FCLKDIV_FLTDIV21_BITNUM 3
#define PORT_FCLKDIV_FLTDIV22_MASK 16U
#define PORT_FCLKDIV_FLTDIV22_BITNUM 4
#define PORT_FCLKDIV_FLTDIV30_MASK 32U
#define PORT_FCLKDIV_FLTDIV30_BITNUM 5
#define PORT_FCLKDIV_FLTDIV31_MASK 64U
#define PORT_FCLKDIV_FLTDIV31_BITNUM 6
#define PORT_FCLKDIV_FLTDIV32_MASK 128U
#define PORT_FCLKDIV_FLTDIV32_BITNUM 7
#define PORT_FCLKDIV_FLTDIV1_MASK 3U
#define PORT_FCLKDIV_FLTDIV1_BITNUM 0
#define PORT_FCLKDIV_FLTDIV2_MASK 28U
#define PORT_FCLKDIV_FLTDIV2_BITNUM 2
#define PORT_FCLKDIV_FLTDIV3_MASK 224U
#define PORT_FCLKDIV_FLTDIV3_BITNUM 5


/*** PORT_PTAPE Port A Pullup Enable Register; 0x000030F0 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTAPE0     : 1;
    byte  PTAPE1     : 1;
    byte  PTAPE2     : 1;
    byte  PTAPE3     : 1;
    byte             : 1;
    byte  PTAPE5     : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPTAPE   : 4;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PORT_PTAPESTR;
extern volatile PORT_PTAPESTR _PORT_PTAPE @0x000030F0;
#define PORT_PTAPE                _PORT_PTAPE.Byte
#define PORT_PTAPE_PTAPE0         _PORT_PTAPE.Bits.PTAPE0
#define PORT_PTAPE_PTAPE1         _PORT_PTAPE.Bits.PTAPE1
#define PORT_PTAPE_PTAPE2         _PORT_PTAPE.Bits.PTAPE2
#define PORT_PTAPE_PTAPE3         _PORT_PTAPE.Bits.PTAPE3
#define PORT_PTAPE_PTAPE5         _PORT_PTAPE.Bits.PTAPE5
#define PORT_PTAPE_PTAPE          _PORT_PTAPE.MergedBits.grpPTAPE

#define PORT_PTAPE_PTAPE0_MASK    1U
#define PORT_PTAPE_PTAPE0_BITNUM  0
#define PORT_PTAPE_PTAPE1_MASK    2U
#define PORT_PTAPE_PTAPE1_BITNUM  1
#define PORT_PTAPE_PTAPE2_MASK    4U
#define PORT_PTAPE_PTAPE2_BITNUM  2
#define PORT_PTAPE_PTAPE3_MASK    8U
#define PORT_PTAPE_PTAPE3_BITNUM  3
#define PORT_PTAPE_PTAPE5_MASK    32U
#define PORT_PTAPE_PTAPE5_BITNUM  5
#define PORT_PTAPE_PTAPE_MASK     15U
#define PORT_PTAPE_PTAPE_BITNUM   0


/*** PORT_PTBPE Port B Pullup Enable Register; 0x000030F1 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTBPE0     : 1;
    byte  PTBPE1     : 1;
    byte  PTBPE2     : 1;
    byte  PTBPE3     : 1;
    byte  PTBPE4     : 1;
    byte  PTBPE5     : 1;
    byte  PTBPE6     : 1;
    byte  PTBPE7     : 1;
  } Bits;
} PORT_PTBPESTR;
extern volatile PORT_PTBPESTR _PORT_PTBPE @0x000030F1;
#define PORT_PTBPE                _PORT_PTBPE.Byte
#define PORT_PTBPE_PTBPE0         _PORT_PTBPE.Bits.PTBPE0
#define PORT_PTBPE_PTBPE1         _PORT_PTBPE.Bits.PTBPE1
#define PORT_PTBPE_PTBPE2         _PORT_PTBPE.Bits.PTBPE2
#define PORT_PTBPE_PTBPE3         _PORT_PTBPE.Bits.PTBPE3
#define PORT_PTBPE_PTBPE4         _PORT_PTBPE.Bits.PTBPE4
#define PORT_PTBPE_PTBPE5         _PORT_PTBPE.Bits.PTBPE5
#define PORT_PTBPE_PTBPE6         _PORT_PTBPE.Bits.PTBPE6
#define PORT_PTBPE_PTBPE7         _PORT_PTBPE.Bits.PTBPE7

#define PORT_PTBPE_PTBPE0_MASK    1U
#define PORT_PTBPE_PTBPE0_BITNUM  0
#define PORT_PTBPE_PTBPE1_MASK    2U
#define PORT_PTBPE_PTBPE1_BITNUM  1
#define PORT_PTBPE_PTBPE2_MASK    4U
#define PORT_PTBPE_PTBPE2_BITNUM  2
#define PORT_PTBPE_PTBPE3_MASK    8U
#define PORT_PTBPE_PTBPE3_BITNUM  3
#define PORT_PTBPE_PTBPE4_MASK    16U
#define PORT_PTBPE_PTBPE4_BITNUM  4
#define PORT_PTBPE_PTBPE5_MASK    32U
#define PORT_PTBPE_PTBPE5_BITNUM  5
#define PORT_PTBPE_PTBPE6_MASK    64U
#define PORT_PTBPE_PTBPE6_BITNUM  6
#define PORT_PTBPE_PTBPE7_MASK    128U
#define PORT_PTBPE_PTBPE7_BITNUM  7


/*** PORT_PTCPE Port C Pullup Enable Register; 0x000030F2 ***/
typedef union {
  byte Byte;
  struct {
    byte  PTCPE0     : 1;
    byte  PTCPE1     : 1;
    byte  PTCPE2     : 1;
    byte  PTCPE3     : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } Bits;
  struct {
    byte  grpPTCPE   : 4;
    byte             : 1;
    byte             : 1;
    byte             : 1;
    byte             : 1;
  } MergedBits;
} PORT_PTCPESTR;
extern volatile PORT_PTCPESTR _PORT_PTCPE @0x000030F2;
#define PORT_PTCPE                _PORT_PTCPE.Byte
#define PORT_PTCPE_PTCPE0         _PORT_PTCPE.Bits.PTCPE0
#define PORT_PTCPE_PTCPE1         _PORT_PTCPE.Bits.PTCPE1
#define PORT_PTCPE_PTCPE2         _PORT_PTCPE.Bits.PTCPE2
#define PORT_PTCPE_PTCPE3         _PORT_PTCPE.Bits.PTCPE3
#define PORT_PTCPE_PTCPE          _PORT_PTCPE.MergedBits.grpPTCPE

#define PORT_PTCPE_PTCPE0_MASK    1U
#define PORT_PTCPE_PTCPE0_BITNUM  0
#define PORT_PTCPE_PTCPE1_MASK    2U
#define PORT_PTCPE_PTCPE1_BITNUM  1
#define PORT_PTCPE_PTCPE2_MASK    4U
#define PORT_PTCPE_PTCPE2_BITNUM  2
#define PORT_PTCPE_PTCPE3_MASK    8U
#define PORT_PTCPE_PTCPE3_BITNUM  3
#define PORT_PTCPE_PTCPE_MASK     15U
#define PORT_PTCPE_PTCPE_BITNUM   0


/*** SYS_UUID1 Universally Unique Identifier Register 1; 0x000030F8 ***/
typedef union {
  byte Byte;
  struct {
    byte  ID0        : 1;
    byte  ID1        : 1;
    byte  ID2        : 1;
    byte  ID3        : 1;
    byte  ID4        : 1;
    byte  ID5        : 1;
    byte  ID6        : 1;
    byte  ID7        : 1;
  } Bits;
} SYS_UUID1STR;
extern volatile SYS_UUID1STR _SYS_UUID1 @0x000030F8;
#define SYS_UUID1                 _SYS_UUID1.Byte
#define SYS_UUID1_ID0             _SYS_UUID1.Bits.ID0
#define SYS_UUID1_ID1             _SYS_UUID1.Bits.ID1
#define SYS_UUID1_ID2             _SYS_UUID1.Bits.ID2
#define SYS_UUID1_ID3             _SYS_UUID1.Bits.ID3
#define SYS_UUID1_ID4             _SYS_UUID1.Bits.ID4
#define SYS_UUID1_ID5             _SYS_UUID1.Bits.ID5
#define SYS_UUID1_ID6             _SYS_UUID1.Bits.ID6
#define SYS_UUID1_ID7             _SYS_UUID1.Bits.ID7

#define SYS_UUID1_ID0_MASK        1U
#define SYS_UUID1_ID0_BITNUM      0
#define SYS_UUID1_ID1_MASK        2U
#define SYS_UUID1_ID1_BITNUM      1
#define SYS_UUID1_ID2_MASK        4U
#define SYS_UUID1_ID2_BITNUM      2
#define SYS_UUID1_ID3_MASK        8U
#define SYS_UUID1_ID3_BITNUM      3
#define SYS_UUID1_ID4_MASK        16U
#define SYS_UUID1_ID4_BITNUM      4
#define SYS_UUID1_ID5_MASK        32U
#define SYS_UUID1_ID5_BITNUM      5
#define SYS_UUID1_ID6_MASK        64U
#define SYS_UUID1_ID6_BITNUM      6
#define SYS_UUID1_ID7_MASK        128U
#define SYS_UUID1_ID7_BITNUM      7


/*** SYS_UUID2 Universally Unique Identifier Register 2; 0x000030F9 ***/
typedef union {
  byte Byte;
  struct {
    byte  ID0        : 1;
    byte  ID1        : 1;
    byte  ID2        : 1;
    byte  ID3        : 1;
    byte  ID4        : 1;
    byte  ID5        : 1;
    byte  ID6        : 1;
    byte  ID7        : 1;
  } Bits;
} SYS_UUID2STR;
extern volatile SYS_UUID2STR _SYS_UUID2 @0x000030F9;
#define SYS_UUID2                 _SYS_UUID2.Byte
#define SYS_UUID2_ID0             _SYS_UUID2.Bits.ID0
#define SYS_UUID2_ID1             _SYS_UUID2.Bits.ID1
#define SYS_UUID2_ID2             _SYS_UUID2.Bits.ID2
#define SYS_UUID2_ID3             _SYS_UUID2.Bits.ID3
#define SYS_UUID2_ID4             _SYS_UUID2.Bits.ID4
#define SYS_UUID2_ID5             _SYS_UUID2.Bits.ID5
#define SYS_UUID2_ID6             _SYS_UUID2.Bits.ID6
#define SYS_UUID2_ID7             _SYS_UUID2.Bits.ID7

#define SYS_UUID2_ID0_MASK        1U
#define SYS_UUID2_ID0_BITNUM      0
#define SYS_UUID2_ID1_MASK        2U
#define SYS_UUID2_ID1_BITNUM      1
#define SYS_UUID2_ID2_MASK        4U
#define SYS_UUID2_ID2_BITNUM      2
#define SYS_UUID2_ID3_MASK        8U
#define SYS_UUID2_ID3_BITNUM      3
#define SYS_UUID2_ID4_MASK        16U
#define SYS_UUID2_ID4_BITNUM      4
#define SYS_UUID2_ID5_MASK        32U
#define SYS_UUID2_ID5_BITNUM      5
#define SYS_UUID2_ID6_MASK        64U
#define SYS_UUID2_ID6_BITNUM      6
#define SYS_UUID2_ID7_MASK        128U
#define SYS_UUID2_ID7_BITNUM      7


/*** SYS_UUID3 Universally Unique Identifier Register 3; 0x000030FA ***/
typedef union {
  byte Byte;
  struct {
    byte  ID0        : 1;
    byte  ID1        : 1;
    byte  ID2        : 1;
    byte  ID3        : 1;
    byte  ID4        : 1;
    byte  ID5        : 1;
    byte  ID6        : 1;
    byte  ID7        : 1;
  } Bits;
} SYS_UUID3STR;
extern volatile SYS_UUID3STR _SYS_UUID3 @0x000030FA;
#define SYS_UUID3                 _SYS_UUID3.Byte
#define SYS_UUID3_ID0             _SYS_UUID3.Bits.ID0
#define SYS_UUID3_ID1             _SYS_UUID3.Bits.ID1
#define SYS_UUID3_ID2             _SYS_UUID3.Bits.ID2
#define SYS_UUID3_ID3             _SYS_UUID3.Bits.ID3
#define SYS_UUID3_ID4             _SYS_UUID3.Bits.ID4
#define SYS_UUID3_ID5             _SYS_UUID3.Bits.ID5
#define SYS_UUID3_ID6             _SYS_UUID3.Bits.ID6
#define SYS_UUID3_ID7             _SYS_UUID3.Bits.ID7

#define SYS_UUID3_ID0_MASK        1U
#define SYS_UUID3_ID0_BITNUM      0
#define SYS_UUID3_ID1_MASK        2U
#define SYS_UUID3_ID1_BITNUM      1
#define SYS_UUID3_ID2_MASK        4U
#define SYS_UUID3_ID2_BITNUM      2
#define SYS_UUID3_ID3_MASK        8U
#define SYS_UUID3_ID3_BITNUM      3
#define SYS_UUID3_ID4_MASK        16U
#define SYS_UUID3_ID4_BITNUM      4
#define SYS_UUID3_ID5_MASK        32U
#define SYS_UUID3_ID5_BITNUM      5
#define SYS_UUID3_ID6_MASK        64U
#define SYS_UUID3_ID6_BITNUM      6
#define SYS_UUID3_ID7_MASK        128U
#define SYS_UUID3_ID7_BITNUM      7


/*** SYS_UUID4 Universally Unique Identifier Register 4; 0x000030FB ***/
typedef union {
  byte Byte;
  struct {
    byte  ID0        : 1;
    byte  ID1        : 1;
    byte  ID2        : 1;
    byte  ID3        : 1;
    byte  ID4        : 1;
    byte  ID5        : 1;
    byte  ID6        : 1;
    byte  ID7        : 1;
  } Bits;
} SYS_UUID4STR;
extern volatile SYS_UUID4STR _SYS_UUID4 @0x000030FB;
#define SYS_UUID4                 _SYS_UUID4.Byte
#define SYS_UUID4_ID0             _SYS_UUID4.Bits.ID0
#define SYS_UUID4_ID1             _SYS_UUID4.Bits.ID1
#define SYS_UUID4_ID2             _SYS_UUID4.Bits.ID2
#define SYS_UUID4_ID3             _SYS_UUID4.Bits.ID3
#define SYS_UUID4_ID4             _SYS_UUID4.Bits.ID4
#define SYS_UUID4_ID5             _SYS_UUID4.Bits.ID5
#define SYS_UUID4_ID6             _SYS_UUID4.Bits.ID6
#define SYS_UUID4_ID7             _SYS_UUID4.Bits.ID7

#define SYS_UUID4_ID0_MASK        1U
#define SYS_UUID4_ID0_BITNUM      0
#define SYS_UUID4_ID1_MASK        2U
#define SYS_UUID4_ID1_BITNUM      1
#define SYS_UUID4_ID2_MASK        4U
#define SYS_UUID4_ID2_BITNUM      2
#define SYS_UUID4_ID3_MASK        8U
#define SYS_UUID4_ID3_BITNUM      3
#define SYS_UUID4_ID4_MASK        16U
#define SYS_UUID4_ID4_BITNUM      4
#define SYS_UUID4_ID5_MASK        32U
#define SYS_UUID4_ID5_BITNUM      5
#define SYS_UUID4_ID6_MASK        64U
#define SYS_UUID4_ID6_BITNUM      6
#define SYS_UUID4_ID7_MASK        128U
#define SYS_UUID4_ID7_BITNUM      7


/*** SYS_UUID5 Universally Unique Identifier Register 5; 0x000030FC ***/
typedef union {
  byte Byte;
  struct {
    byte  ID0        : 1;
    byte  ID1        : 1;
    byte  ID2        : 1;
    byte  ID3        : 1;
    byte  ID4        : 1;
    byte  ID5        : 1;
    byte  ID6        : 1;
    byte  ID7        : 1;
  } Bits;
} SYS_UUID5STR;
extern volatile SYS_UUID5STR _SYS_UUID5 @0x000030FC;
#define SYS_UUID5                 _SYS_UUID5.Byte
#define SYS_UUID5_ID0             _SYS_UUID5.Bits.ID0
#define SYS_UUID5_ID1             _SYS_UUID5.Bits.ID1
#define SYS_UUID5_ID2             _SYS_UUID5.Bits.ID2
#define SYS_UUID5_ID3             _SYS_UUID5.Bits.ID3
#define SYS_UUID5_ID4             _SYS_UUID5.Bits.ID4
#define SYS_UUID5_ID5             _SYS_UUID5.Bits.ID5
#define SYS_UUID5_ID6             _SYS_UUID5.Bits.ID6
#define SYS_UUID5_ID7             _SYS_UUID5.Bits.ID7

#define SYS_UUID5_ID0_MASK        1U
#define SYS_UUID5_ID0_BITNUM      0
#define SYS_UUID5_ID1_MASK        2U
#define SYS_UUID5_ID1_BITNUM      1
#define SYS_UUID5_ID2_MASK        4U
#define SYS_UUID5_ID2_BITNUM      2
#define SYS_UUID5_ID3_MASK        8U
#define SYS_UUID5_ID3_BITNUM      3
#define SYS_UUID5_ID4_MASK        16U
#define SYS_UUID5_ID4_BITNUM      4
#define SYS_UUID5_ID5_MASK        32U
#define SYS_UUID5_ID5_BITNUM      5
#define SYS_UUID5_ID6_MASK        64U
#define SYS_UUID5_ID6_BITNUM      6
#define SYS_UUID5_ID7_MASK        128U
#define SYS_UUID5_ID7_BITNUM      7


/*** SYS_UUID6 Universally Unique Identifier Register 6; 0x000030FD ***/
typedef union {
  byte Byte;
  struct {
    byte  ID0        : 1;
    byte  ID1        : 1;
    byte  ID2        : 1;
    byte  ID3        : 1;
    byte  ID4        : 1;
    byte  ID5        : 1;
    byte  ID6        : 1;
    byte  ID7        : 1;
  } Bits;
} SYS_UUID6STR;
extern volatile SYS_UUID6STR _SYS_UUID6 @0x000030FD;
#define SYS_UUID6                 _SYS_UUID6.Byte
#define SYS_UUID6_ID0             _SYS_UUID6.Bits.ID0
#define SYS_UUID6_ID1             _SYS_UUID6.Bits.ID1
#define SYS_UUID6_ID2             _SYS_UUID6.Bits.ID2
#define SYS_UUID6_ID3             _SYS_UUID6.Bits.ID3
#define SYS_UUID6_ID4             _SYS_UUID6.Bits.ID4
#define SYS_UUID6_ID5             _SYS_UUID6.Bits.ID5
#define SYS_UUID6_ID6             _SYS_UUID6.Bits.ID6
#define SYS_UUID6_ID7             _SYS_UUID6.Bits.ID7

#define SYS_UUID6_ID0_MASK        1U
#define SYS_UUID6_ID0_BITNUM      0
#define SYS_UUID6_ID1_MASK        2U
#define SYS_UUID6_ID1_BITNUM      1
#define SYS_UUID6_ID2_MASK        4U
#define SYS_UUID6_ID2_BITNUM      2
#define SYS_UUID6_ID3_MASK        8U
#define SYS_UUID6_ID3_BITNUM      3
#define SYS_UUID6_ID4_MASK        16U
#define SYS_UUID6_ID4_BITNUM      4
#define SYS_UUID6_ID5_MASK        32U
#define SYS_UUID6_ID5_BITNUM      5
#define SYS_UUID6_ID6_MASK        64U
#define SYS_UUID6_ID6_BITNUM      6
#define SYS_UUID6_ID7_MASK        128U
#define SYS_UUID6_ID7_BITNUM      7


/*** SYS_UUID7 Universally Unique Identifier Register 7; 0x000030FE ***/
typedef union {
  byte Byte;
  struct {
    byte  ID0        : 1;
    byte  ID1        : 1;
    byte  ID2        : 1;
    byte  ID3        : 1;
    byte  ID4        : 1;
    byte  ID5        : 1;
    byte  ID6        : 1;
    byte  ID7        : 1;
  } Bits;
} SYS_UUID7STR;
extern volatile SYS_UUID7STR _SYS_UUID7 @0x000030FE;
#define SYS_UUID7                 _SYS_UUID7.Byte
#define SYS_UUID7_ID0             _SYS_UUID7.Bits.ID0
#define SYS_UUID7_ID1             _SYS_UUID7.Bits.ID1
#define SYS_UUID7_ID2             _SYS_UUID7.Bits.ID2
#define SYS_UUID7_ID3             _SYS_UUID7.Bits.ID3
#define SYS_UUID7_ID4             _SYS_UUID7.Bits.ID4
#define SYS_UUID7_ID5             _SYS_UUID7.Bits.ID5
#define SYS_UUID7_ID6             _SYS_UUID7.Bits.ID6
#define SYS_UUID7_ID7             _SYS_UUID7.Bits.ID7

#define SYS_UUID7_ID0_MASK        1U
#define SYS_UUID7_ID0_BITNUM      0
#define SYS_UUID7_ID1_MASK        2U
#define SYS_UUID7_ID1_BITNUM      1
#define SYS_UUID7_ID2_MASK        4U
#define SYS_UUID7_ID2_BITNUM      2
#define SYS_UUID7_ID3_MASK        8U
#define SYS_UUID7_ID3_BITNUM      3
#define SYS_UUID7_ID4_MASK        16U
#define SYS_UUID7_ID4_BITNUM      4
#define SYS_UUID7_ID5_MASK        32U
#define SYS_UUID7_ID5_BITNUM      5
#define SYS_UUID7_ID6_MASK        64U
#define SYS_UUID7_ID6_BITNUM      6
#define SYS_UUID7_ID7_MASK        128U
#define SYS_UUID7_ID7_BITNUM      7


/*** SYS_UUID8 Universally Unique Identifier Register 8; 0x000030FF ***/
typedef union {
  byte Byte;
  struct {
    byte  ID0        : 1;
    byte  ID1        : 1;
    byte  ID2        : 1;
    byte  ID3        : 1;
    byte  ID4        : 1;
    byte  ID5        : 1;
    byte  ID6        : 1;
    byte  ID7        : 1;
  } Bits;
} SYS_UUID8STR;
extern volatile SYS_UUID8STR _SYS_UUID8 @0x000030FF;
#define SYS_UUID8                 _SYS_UUID8.Byte
#define SYS_UUID8_ID0             _SYS_UUID8.Bits.ID0
#define SYS_UUID8_ID1             _SYS_UUID8.Bits.ID1
#define SYS_UUID8_ID2             _SYS_UUID8.Bits.ID2
#define SYS_UUID8_ID3             _SYS_UUID8.Bits.ID3
#define SYS_UUID8_ID4             _SYS_UUID8.Bits.ID4
#define SYS_UUID8_ID5             _SYS_UUID8.Bits.ID5
#define SYS_UUID8_ID6             _SYS_UUID8.Bits.ID6
#define SYS_UUID8_ID7             _SYS_UUID8.Bits.ID7

#define SYS_UUID8_ID0_MASK        1U
#define SYS_UUID8_ID0_BITNUM      0
#define SYS_UUID8_ID1_MASK        2U
#define SYS_UUID8_ID1_BITNUM      1
#define SYS_UUID8_ID2_MASK        4U
#define SYS_UUID8_ID2_BITNUM      2
#define SYS_UUID8_ID3_MASK        8U
#define SYS_UUID8_ID3_BITNUM      3
#define SYS_UUID8_ID4_MASK        16U
#define SYS_UUID8_ID4_BITNUM      4
#define SYS_UUID8_ID5_MASK        32U
#define SYS_UUID8_ID5_BITNUM      5
#define SYS_UUID8_ID6_MASK        64U
#define SYS_UUID8_ID6_BITNUM      6
#define SYS_UUID8_ID7_MASK        128U
#define SYS_UUID8_ID7_BITNUM      7



#endif
/*lint -restore  +esym(961,18.4) +esym(961,19.7) Enable MISRA rule (1.1,18.4,6.4,19.7) checking. */
