/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      intrinsic_math.c
*
* @author    r30322
* 
* @version   1.0.7.0
* 
* @date      Nov-11-2009
* 
* @brief     basic mathematical functions assembler file
*
* target     HCS08
*
* tested on compiler:  
*            CodeWarrior Development Studio for Microcontrollers V6.2 Release
*
*
*******************************************************************************/

/*****************************************************************************
*  Included files
*****************************************************************************/

/* header files */
#include "intrinsic_math.h"


/*****************************************************************************
*
* Module: unsigned int umul16_8to16(unsigned int x, unsigned char y)
*
* Description: Unsigned multiplication
*   x(L)*y/256+x(H)*y = x*y/256
*
* Returns: x*y/256
*
* Global Data:None
*
* Arguments:
*   x (in)
*   y (in)
*
* Range Issues: None
*
* Special Issues: None
*
*****************************************************************************/
unsigned int umul16_8to16(unsigned int x, unsigned char y)
{
    return (unsigned int)((unsigned int)((unsigned char)(x>>8)*(y))+\
           (unsigned char)(((unsigned char)(x)*(y))>>8));
}

/*******************************************************************************
*
* Function: unsigned int umul16_16to16(unsigned int x, unsigned int y)
*
* Description:
*   x(L)*y(H)/256+x(H)*y(L)/256+x(H)*y(H)
*
* Returns: x*y/65536
*
* Global Data:None
*
* Arguments:
*   x (in)
*   y (in)
*
* Range Issues: None
*
* Special Issues: None
*
*******************************************************************************/
unsigned int umul16_16to16(unsigned int x, unsigned int y)
{
return(unsigned int)((unsigned int)((unsigned char)(x>>8)*(unsigned char)(y>>8))+\
                 (unsigned char)(((unsigned char)(x>>8)*(unsigned char)(y))>>8 )+\
                 (unsigned char)(((unsigned char)(x)*(unsigned char)(y>>8))>>8 ));
}

/*****************************************************************************
*
* Module: unsigned int umul16_8to16(unsigned int x, unsigned char y)
*
* Description: Unsigned multiplication
*   x(L)*y/256+x(H)*y = x*y/256
*
* Returns: x*y/256
*
* Global Data:None
*
* Arguments:
*   x (in)
*   y (in)
*
* Range Issues: None
*
* Special Issues: None
*
*****************************************************************************/
unsigned int umul8_8to16(unsigned char x, unsigned char y)
{
    return (unsigned int)((unsigned char)x*(unsigned char)y);
}


#if 0
/*****************************************************************************
 * Function:        l_sys_irq_disable
 *
 * Description:     Disable interrupts
 *
 * Returns:         Interrupt mask before disabling
 *
 * Notes:           Inline assembler used.
 *                  Returned value is in register A.
 *                  Some compilers may generate the warning, 
 *                  e.g. "Return expected".
 *
 *****************************************************************************/
unsigned char irq_disable(void){
    asm(tpa);
    asm(sei);
    /*return 0; Changed 03.07.04 */
}

/*****************************************************************************
 * Function:        l_sys_irq_restore
 *
 * Description:     Restore interrupts
 *
 * Returns:         none
 *
 * Notes:           Restore <previous> interrupt mask.
 *                  Inline assembler used.
 *                  Input value is in register A.
 *                  Some compilers may generate the warning, 
 *                  e.g. "Parameter declared in function but not referenced".
 *
 *****************************************************************************/
void irq_restore(unsigned char previous){
    /* cli(); */
    asm(tap);  /* Changed 03.07.28 */
}
#endif
