/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
******************************************************************************* 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
********************************************************************************
*
* $File Name: ECLIB_Ramp16.c$
*
* $Date:      Nov-11-2009$
*
* $Version:   0.0.2.0$
*
* Description:File contains ECLIB_Ramp16 function
*
*****************************************************************************/

#include "intrinsic_math.h" /* include S08math */

/*****************************************************************************
*
* Function: ECLIB_Ramp16 (signed int increment, signed int reqValue, signed int actValue)
*
* Description:
*   The function increments or decrements the output value by a defined step 
*   to bring the actual value closer to the required value.
*     
* Returns:
*   actValue + (reqValue-actValue)*increment/abs(reqValue-actValue)
*
* Arguments:
*   increment signed int    - Increment
*   actValue  signed int    - Actual value
*   reqValue  signed int    - Required value
*
* Range Issues: None
*
* Special Issues: None
*
*****************************************************************************/

signed int ECLIB_Ramp16(signed int increment, signed int reqValue, signed int actValue)
{
    signed int temp;
    
    temp = add16(actValue,increment);
    
    /* Is there space to increment ?*/
    if (temp <= reqValue) return (temp);
    else
    {
        temp = sub16(actValue,increment); 
        /* Is there space to decrement ? */
        if (temp >= reqValue) return (temp);
        else return (reqValue);
    }
}