/* touch_2d.c */

#include "touch_2d.h"

int32_t touch_channel_baselines[TOUCH_2D_ALL_COUNT];

/* using hardware filter, software calibration would not check the idle state. */
bool touch_2d_calib(int32_t *inputs)
{
    for (uint32_t i = 0u; i < TOUCH_2D_ALL_COUNT; i++)
    {
        touch_channel_baselines[i] = inputs[i];
    }
    return true;
}

/* 输入为offset值 */
bool touch_slider_calc_position(int32_t *inputs, int32_t shield_val)
{
    return true;
}

int32_t touch_channel_offsets[TOUCH_2D_ALL_COUNT] = {0};
int32_t touch_channel_offsets2[TOUCH_2D_ALL_COUNT] = {0};

#define TOUCH_BOUNDARY_THRESHOLD  20
#define TOUCH_ON_TOUCH_THRESHOLD  50
#define TOUCH_BOUNDARY_X_OFFSET   (TOUCH_2D_X_POS_RANGE / 2)
#define TOUCH_BOUNDARY_Y_OFFSET   (TOUCH_2D_Y_POS_RANGE / 2)

/* 返回错误码 */
int32_t touch_2d_calc_position(int32_t *inputs, int32_t *x_pos, int32_t *y_pos)
{
    uint32_t m_touch_val_max_idx = 0;
    uint32_t m_touch_val_min_idx = 0;

    touch_channel_offsets[0] = touch_channel_baselines[0] - inputs[0];

    /* cut off the baseline for each channel. */
    for (uint32_t i = 1u; i < TOUCH_2D_ALL_COUNT; i++)
    {
        touch_channel_offsets[i] = touch_channel_baselines[i] - inputs[i];

        if (touch_channel_offsets[i] > touch_channel_offsets[m_touch_val_max_idx])
        {
            m_touch_val_max_idx = i;
        }
        if (touch_channel_offsets[i] < touch_channel_offsets[m_touch_val_min_idx])
        {
            m_touch_val_min_idx = i;
        }
    }
    /* shield不参与计算, 但用于边界判定 */
    //touch_channel_offsets[TOUCH_2D_ALL_COUNT-1] = touch_channel_baselines[TOUCH_2D_ALL_COUNT-1] - inputs[TOUCH_2D_ALL_COUNT-1];

    /* cut off the baseline in system. */
    for (uint32_t i = 0u; i < TOUCH_2D_ALL_COUNT; i++)
    {
        touch_channel_offsets2[i] = touch_channel_offsets[i] - touch_channel_offsets[m_touch_val_min_idx];
    }
#if 1
    if (touch_channel_offsets2[TOUCH_2D_ALL_COUNT-1] > TOUCH_BOUNDARY_THRESHOLD)
    {
        return 1; /* 触摸到边界, 位置无效. */
    }
#endif
    if (touch_channel_offsets2[m_touch_val_max_idx] < TOUCH_ON_TOUCH_THRESHOLD)
    {
        return 2; /* 凸显不多, 触摸无效. */
    }

    /* x. */
    int32_t *calc_base = touch_channel_offsets2;
    int32_t m_touch_calc_val[2];
    m_touch_calc_val[0] = 0;
    m_touch_calc_val[1] = 0;
    for (uint32_t i = 0u; i < TOUCH_2D_X_COUNT; i++)
    {
        m_touch_calc_val[0] += (*calc_base) * i;
        m_touch_calc_val[1] += (*calc_base);
        calc_base++;
    }

    m_touch_calc_val[0] = m_touch_calc_val[0] * TOUCH_2D_X_POS_RANGE / m_touch_calc_val[1];
    m_touch_calc_val[0] -= TOUCH_BOUNDARY_X_OFFSET;
    *x_pos = (m_touch_calc_val[0] > 0) ? m_touch_calc_val[0] : 0;

    /* y. */
    m_touch_calc_val[0] = 0;
    m_touch_calc_val[1] = 0;
    for (uint32_t i = 0u; i < TOUCH_2D_Y_COUNT; i++)
    {
        m_touch_calc_val[0] += (*calc_base) * i;
        m_touch_calc_val[1] += (*calc_base);
        calc_base++;
    }

    m_touch_calc_val[0] = m_touch_calc_val[0] * TOUCH_2D_Y_POS_RANGE / m_touch_calc_val[1];
    m_touch_calc_val[0] -= TOUCH_BOUNDARY_Y_OFFSET;
    *y_pos = (m_touch_calc_val[0] > 0) ? m_touch_calc_val[0] : 0;

    return 0;
}

/* EOF. */

