/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2018 NXP
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef TEMPERATURE_SENSOR_H_
#define TEMPERATURE_SENSOR_H_

/*!*********************************************************************************
*************************************************************************************
* Includes
*************************************************************************************
********************************************************************************** */
#include "timers.h"
#include "temperature_interface.h"
/*!*********************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
********************************************************************************** */

/*!*********************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
********************************************************************************** */

#define gAdvTime_c                      30000 /* 30 s*/

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */
extern deviceId_t  mPeerDeviceId;
extern bool_t g_ButtonPress;
extern bool_t g_ButtonLongPress;
extern gapAdvertisingParameters_t   gAdvParams;
extern tmsConfig_t tmsServiceConfig;
extern gapAdvertisingData_t gAppAdvertisingData;
extern gapScanResponseData_t gAppScanRspData;
/*!*********************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
********************************************************************************** */

/*****************************************************************************
******************************************************************************
* Private memory declarations
******************************************************************************
*****************************************************************************/

/*! Unique identifier type for a connected device. */
typedef uint8_t deviceId_t;

/*! *********************************************************************************
*************************************************************************************
* Private prototypes
*************************************************************************************
********************************************************************************** */
void App_Start(void);
void App_config();
void Button_Initialization();
void ConnectionCallback(deviceId_t peerDeviceId, gapConnectionEvent_t* pConnectionEvent);
void AdvertisingCallback(gapAdvertisingEvent_t* pAdvertisingEvent);
void BleApp_GenericCallback(gapGenericEvent_t* pGenericEvent);
void BleApp_GattServerCallback (deviceId_t deviceId, gattServerEvent_t* pServerEvent);
void BleApp_SendTemperature(void);
#endif /* TEMPERATURE_SENSOR_H_ */
