/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2018 NXP
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef FSCI_SPI_H_
#define FSCI_SPI_H_

/*! *********************************************************************************
*************************************************************************************
* Include
*************************************************************************************
********************************************************************************** */
#include "fsl_dspi.h"
#include "FreeRTOS.h"
#include "timers.h"
/*! *********************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
********************************************************************************** */
extern uint32_t item_cnt;
/*! *********************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
********************************************************************************** */
#define EXAMPLE_DSPI_MASTER_BASEADDR SPI0
#define EXAMPLE_DSPI_MASTER_CLK_SRC DSPI0_CLK_SRC
#define EXAMPLE_DSPI_MASTER_CLK_FREQ CLOCK_GetFreq(DSPI0_CLK_SRC)
#define EXAMPLE_DSPI_MASTER_PCS kDSPI_Pcs0
#define EXAMPLE_DSPI_MASTER_IRQ SPI0_IRQn
#define EXAMPLE_DSPI_MASTER_IRQHandler SPI0_IRQHandler

/* DATA_SIZE set to 64, if user have FSCI request command size more than it
 * then increase it accordingly */
#define DATA_SIZE 64

/*! *********************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */


/*! *********************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
********************************************************************************** */
void BOARD_SPIInitPins(void);
void SPI_Init(void);
void SPI_SendData(uint8_t *buffer_ptr, uint16_t buffer_size);
void Prepare_FSCI_Response(uint8_t *Rxdata);
void RespMonitorTimerCallback(TimerHandle_t xTimer);
#endif /* FSCI_SPI_H_ */
