/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2018 NXP
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef FSCI_FSCI_MAIN_H_
#define FSCI_FSCI_MAIN_H_

/*! *********************************************************************************
*************************************************************************************
* Include
*************************************************************************************
********************************************************************************** */
#include "BLE_Abstraction_main.h"
#include "fsl_os_abstraction_free_rtos.h"
#include "ble_FSCI.h"
#include "EmbeddedTypes.h"
#include "gattdb_interface.h"
/*! *********************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
********************************************************************************** */
typedef PACKED_STRUCT packetHdr_tag
{
	uint8_t    startMarker;
	uint8_t    opGroup;
	uint8_t    opCode;
	uint16_t   len;
}packetHdr_t;

/*! *********************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
********************************************************************************** */
#define gFsci_TailBytes_c (1)
#define gFSCI_StartMarker_c     0x02

#define gEvtMsgFromFSCI_c  (1 << 3)

/*! *********************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */
extern osa_msgq_handle_t rx_msg_queue;
extern bool_t is3SecTimerExpired;
#ifdef gTempTimerSupported
extern TimerHandle_t sendTempTimerHandle;
#endif
/*! *********************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
********************************************************************************** */
void FSCI_HandleMessageInput(msgBLEabsToFSCI_t *pMsg);
uint8_t FSCI_computeChecksum( void *pBuffer, uint16_t size );
void FSCI_transmitPayload(uint8_t opGroup, uint8_t opCode, uint8_t *payload, uint16_t Length);
osa_status_t FSCIInit(void);
#ifdef gTempTimerSupported
void SendTempTimerCallback(TimerHandle_t xTimer);
#endif
#endif /* FSCI_FSCI_MAIN_H_ */
