/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*System includes.*/
#include "ApplMain.h"
#include "ble_FSCI.h"
#include "gatt_server.h"
#include "fsl_debug_console.h"

/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/
gattServerCallback_t pfGattServerCallback = NULL;

/*! *********************************************************************************
* \brief  Installs an application callback for the GATT Server module.
*
* \param[in] callback Application-defined callback to be triggered by this module.
*
* \return  gBleSuccess_c or error.
*
* \remarks This function executes synchronously.
*
********************************************************************************** */
bleResult_t Gatt_RegisterCallback
(
    gattServerCallback_t serverCallback
)
{
	msgBLEabsToFSCI_t *msgToFSCI = NULL;
	uint32_t ulNotifiedValue;
	BaseType_t result;
	msgToFSCI = malloc(MAX_REQUEST_SIZE * sizeof(uint8_t));

	msgToFSCI->opCode = gattServerCallbackRegister;
	msgToFSCI->opGroup = bleGATT;
	msgToFSCI->length = 0;

	pfGattServerCallback = serverCallback;

	OSA_MsgQPut(&tx_msg_queue, msgToFSCI);

	/* Signal FSCI thread for message into message queue */
	OSA_EventSet(&eventHandle, gFSCIEvtMsgFromAbs_c);

	result = xTaskNotifyWait(0x00, 0, &ulNotifiedValue, pdMS_TO_TICKS(200));

	free(msgToFSCI);
	msgToFSCI = NULL;

	if(result == pdTRUE)
	{
		return ulNotifiedValue;
	}
	else
	{
		return RESP_TIMEOUT_ERROR;
	}
}

bleResult_t Gatt_SendNotification
(
    deviceId_t              deviceId,
    uint16_t                handle
)
{
	msgBLEabsToFSCI_t *msgToFSCI = NULL;
	uint32_t ulNotifiedValue;

	osa_status_t result;

	msgToFSCI = malloc(MAX_REQUEST_SIZE * sizeof(uint8_t));
	msgToFSCI->opCode = gattSendNotification;
	msgToFSCI->opGroup = bleGATT;
	msgToFSCI->length = sizeof(gattServerSendNotificationReq_t);

	msgToFSCI->bleRequestType.sendNotification.deviceId = deviceId;
	msgToFSCI->bleRequestType.sendNotification.handle = handle;

	OSA_MsgQPut(&tx_msg_queue, msgToFSCI);

	/* Signal FSCI thread for message into message queue */
	OSA_EventSet(&eventHandle, gFSCIEvtMsgFromAbs_c);

	result = xTaskNotifyWait(0x00, 0, &ulNotifiedValue, pdMS_TO_TICKS(200));

	free(msgToFSCI);
	msgToFSCI = NULL;

	if(result == pdTRUE)
	{
		return ulNotifiedValue;
	}
	else
	{
		return RESP_TIMEOUT_ERROR;
	}
}
