/*
 * FreeRTOS Kernel V10.2.0
 * Copyright (C) 2019 Amazon.com, Inc. or its affiliates.  All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * http://www.FreeRTOS.org
 * http://aws.amazon.com/freertos
 *
 * 1 tab == 4 spaces!
 */

#ifndef BLE_ABSTRACTION_MAIN_H
#define BLE_ABSTRACTION_MAIN_H

/* Kernel includes. */
#include "FreeRTOS.h"
#include "queue.h"

/* Freescale includes. */
#include "fsl_common.h"
#include "fsl_os_abstraction.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* Application Events */
#define gFSCIEvtMsgFromAbs_c  (1 << 1)

#define MAX_QUEUE_LENGTH 10
#define MSG_SIZE	 50

#define MSG_QUEUE_WAIT_TIME pdMS_TO_TICKS(2000)

#define RESP_TIMEOUT_ERROR 0xFF
/*******************************************************************************
 * Globals
 ******************************************************************************/
/* queue handle */
extern osa_msgq_handle_t tx_msg_queue;

extern osa_event_handle_t evt_handle;

extern TaskHandle_t recv_task_handle;
/*******************************************************************************
 * Prototypes
 ******************************************************************************/
/* Application API */

osa_status_t mBLEAbsInit(void);

#endif /* BLE_ABSTRACTION_MAIN_H */
