/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2018 NXP
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef APPLMAIN_H_
#define APPLMAIN_H_

/*! *********************************************************************************
*************************************************************************************
* Include
*************************************************************************************
********************************************************************************** */
#include "gap_interface.h"
#include "gatt_server.h"
#include "gattdb_interface.h"
/*! *********************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
********************************************************************************** */

/*! *********************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
********************************************************************************** */
/* Enable to create timer to send temperature data at every 3 sec Interval */
#define gTempTimerSupported

/*! *********************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */
extern TaskHandle_t task_handle;
extern osa_event_handle_t eventHandle;
/*! *********************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
********************************************************************************** */

/*! *********************************************************************************
* \brief  Application wrapper function for Gap_StartAdvertising.
*
* \param[in] advertisingCallback   Callback used by the application to receive advertising events.
*                                  Can be NULL.
* \param[in] connectionCallback    Callback used by the application to receive connection events.
*                                  Can be NULL.
*
* \return                          None.
*
* \remarks This function should be used by the application if the callback should
*          be executed in the context of the Application Task.
*
********************************************************************************** */
void App_StartAdvertising(
    gapAdvertisingCallback_t advertisingCallback,
	gapConnectionCallback_t  connectionCallback
);

void App_GenericCallback (gapGenericEvent_t *pGenericEvent);
void App_GattServerCallback (deviceId_t deviceId, gattServerEvent_t* pServerEvent);
#endif /* APPLMAIN_H_ */
