/*******************************************************************************
*
* E M B E D D E D   W I Z A R D   P R O J E C T
*
*                                                Copyright (c) TARA Systems GmbH
*                                    written by Paul Banach and Manfred Schweyer
*
********************************************************************************
*
* This file was generated automatically by Embedded Wizard Studio.
*
* Please do not make any modifications of this file! The modifications are lost
* when the file is generated again by Embedded Wizard Studio!
*
* The template of this heading text can be found in the file 'head.ewt' in the
* directory 'Platforms' of your Embedded Wizard installation directory. If you
* wish to adapt this text, please copy the template file 'head.ewt' into your
* project directory and edit the copy only. Please avoid any modifications of
* the original template file!
*
* Version  : 9.20
* Profile  : Profile
* Platform : NXP.iMX_RT.RGBA8888
*
*******************************************************************************/

#include "ewlocale.h"
#include "_ResourcesBitmap.h"
#include "_ResourcesFont.h"
#include "Resources.h"

/* Compressed strings for the language 'Default'. */
static const unsigned int _StringsDefault0[] =
{
  0x00000058, /* ratio 95.45 % */
  0xB8005500, 0x00000452, 0x00D0002A, 0x04000328, 0xE4003800, 0x70F37800, 0x74004461,
  0x0869E400, 0x230004E0, 0x6800C317, 0x800A7163, 0x58F40034, 0xE510E8F4, 0x00528E1C,
  0x80020C14, 0x0027C708, 0x0260009C, 0x17000B20, 0x0C1A8306, 0x00000008, 0x00000000
};

/* Constant values used in this 'C' module only. */
static const XPoint _Const0000 = { 0, 0 };
static const XStringRes _Const0001 = { _StringsDefault0, 0x0003 };

/* Initializer for the class 'Resources::Bitmap' */
void ResourcesBitmap__Init( ResourcesBitmap _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  CoreResource__Init( &_this->_Super, aLink, aArg );

  /* Setup the VMT pointer */
  _this->_VMT = EW_CLASS( ResourcesBitmap );

  /* ... and initialize objects, variables, properties, etc. */
  _this->NoOfFrames = 1;

  /* Call the user defined constructor */
  ResourcesBitmap_Init( _this, aArg );
}

/* Re-Initializer for the class 'Resources::Bitmap' */
void ResourcesBitmap__ReInit( ResourcesBitmap _this )
{
  /* At first re-initialize the super class ... */
  CoreResource__ReInit( &_this->_Super );
}

/* Finalizer method for the class 'Resources::Bitmap' */
void ResourcesBitmap__Done( ResourcesBitmap _this )
{
  /* Finalize this class */
  _this->_VMT = EW_CLASS( ResourcesBitmap );

  /* Call the user defined destructor of the class */
  ResourcesBitmap_Done( _this );

  /* Don't forget to deinitialize the super class ... */
  CoreResource__Done( &_this->_Super );
}

/* 'C' function for method : 'Resources::Bitmap.Done()' */
void ResourcesBitmap_Done( ResourcesBitmap _this )
{
  XHandle handle;

  if ( _this->bitmap == 0 )
    return;

  handle = _this->bitmap;
  EwFreeBitmap((XBitmap*)handle );
  _this->bitmap = 0;
  _this->FrameSize = _Const0000;
  _this->FrameDelay = 0;
  _this->NoOfFrames = 1;
  _this->Animated = 0;
}

/* 'C' function for method : 'Resources::Bitmap.Init()' */
void ResourcesBitmap_Init( ResourcesBitmap _this, XHandle aArg )
{
  XHandle handle;
  XInt32 noOfFrames;
  XPoint frameSize;
  XInt32 frameDelay;

  if ( aArg == 0 )
    return;

  handle = 0;
  noOfFrames = 1;
  frameSize = _Const0000;
  frameDelay = 0;
  {
    /* aArg is a pointer to the memory where the bitmap resource is stored. */
    XBitmap* bmp = EwLoadBitmap((const XBmpRes*)aArg );

    /* After the bitmap has been loaded get the size of the bitmap and store it
       in the following variables. */
    if ( bmp )
    {
      noOfFrames = bmp->NoOfFrames;
      frameSize  = bmp->FrameSize;
      frameDelay = bmp->FrameDelay;
    }

    handle = (XHandle)(void*)bmp;
  }
  _this->bitmap = handle;
  _this->NoOfFrames = noOfFrames;
  _this->FrameSize = frameSize;
  _this->FrameDelay = frameDelay;
  _this->Animated = (XBool)((( _this->bitmap != 0 ) && ( _this->FrameDelay > 0 )) 
  && ( _this->NoOfFrames > 1 ));
}

/* 'C' function for method : 'Resources::Bitmap.OnSetFrameSize()' */
void ResourcesBitmap_OnSetFrameSize( ResourcesBitmap _this, XPoint value )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( _this );
  EW_UNUSED_ARG( value );

  {
    EwThrow( EwLoadString( &_Const0001 ));
    return;
  }
}

/* Wrapper function for the virtual method : 'Resources::Bitmap.OnSetFrameSize()' */
void ResourcesBitmap__OnSetFrameSize( void* _this, XPoint value )
{
  ((ResourcesBitmap)_this)->_VMT->OnSetFrameSize((ResourcesBitmap)_this, value );
}

/* 'C' function for method : 'Resources::Bitmap.Update()' */
void ResourcesBitmap_Update( ResourcesBitmap _this )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( _this );
}

/* Wrapper function for the virtual method : 'Resources::Bitmap.Update()' */
void ResourcesBitmap__Update( void* _this )
{
  ((ResourcesBitmap)_this)->_VMT->Update((ResourcesBitmap)_this );
}

/* Variants derived from the class : 'Resources::Bitmap' */
EW_DEFINE_CLASS_VARIANTS( ResourcesBitmap )
EW_END_OF_CLASS_VARIANTS( ResourcesBitmap )

/* Virtual Method Table (VMT) for the class : 'Resources::Bitmap' */
EW_DEFINE_CLASS( ResourcesBitmap, CoreResource, _None, _None, _None, _None, _None, 
                 "Resources::Bitmap" )
  ResourcesBitmap_OnSetFrameSize,
  ResourcesBitmap_Update,
EW_END_OF_CLASS( ResourcesBitmap )

/* Initializer for the class 'Resources::Font' */
void ResourcesFont__Init( ResourcesFont _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  CoreResource__Init( &_this->_Super, aLink, aArg );

  /* Setup the VMT pointer */
  _this->_VMT = EW_CLASS( ResourcesFont );

  /* Call the user defined constructor */
  ResourcesFont_Init( _this, aArg );
}

/* Re-Initializer for the class 'Resources::Font' */
void ResourcesFont__ReInit( ResourcesFont _this )
{
  /* At first re-initialize the super class ... */
  CoreResource__ReInit( &_this->_Super );
}

/* Finalizer method for the class 'Resources::Font' */
void ResourcesFont__Done( ResourcesFont _this )
{
  /* Finalize this class */
  _this->_VMT = EW_CLASS( ResourcesFont );

  /* Call the user defined destructor of the class */
  ResourcesFont_Done( _this );

  /* Don't forget to deinitialize the super class ... */
  CoreResource__Done( &_this->_Super );
}

/* 'C' function for method : 'Resources::Font.Done()' */
void ResourcesFont_Done( ResourcesFont _this )
{
  XHandle handle;

  if ( _this->font == 0 )
    return;

  handle = _this->font;
  EwFreeFont((XFont*)handle );
  _this->font = 0;
  _this->Ascent = 0;
  _this->Descent = 0;
  _this->Leading = 0;
}

/* 'C' function for method : 'Resources::Font.Init()' */
void ResourcesFont_Init( ResourcesFont _this, XHandle aArg )
{
  XHandle handle;
  XInt32 ascent;
  XInt32 descent;
  XInt32 leading;

  if ( aArg == 0 )
    return;

  handle = 0;
  ascent = 0;
  descent = 0;
  leading = 0;
  {
    /* aArg is a pointer to a memory where the font resource is stored. */
    XFont* font = EwLoadFont((const XFntRes*)aArg );

    /* After the font has been loaded query its ascent and descent. */
    if ( font )
    {
      ascent  = font->Ascent;
      descent = font->Descent;
      leading = font->Leading;
    }

    handle = (XHandle)(void*)font;
  }
  _this->font = handle;
  _this->Ascent = ascent;
  _this->Descent = descent;
  _this->Leading = leading;
}

/* 'C' function for method : 'Resources::Font.GetFlowTextAdvance()' */
XInt32 ResourcesFont_GetFlowTextAdvance( ResourcesFont _this, XString aFlowString )
{
  XHandle handle;
  XInt32 advance;

  if ( _this->font == 0 )
    return 0;

  handle = _this->font;
  advance = 0;
  advance = EwGetFlowTextAdvance((XFont*)handle, aFlowString );
  return advance;
}

/* 'C' function for method : 'Resources::Font.ParseFlowString()' */
XString ResourcesFont_ParseFlowString( ResourcesFont _this, XString aString, XInt32 
  aOffset, XInt32 aWidth, XInt32 aMaxNoOfRows, XHandle aBidi )
{
  XHandle handle;
  XString result;

  if ( aOffset < 0 )
    aOffset = 0;

  if (( _this->font == 0 ) || (( aOffset > 0 ) && ( aOffset >= EwGetStringLength( 
      aString ))))
    return 0;

  handle = _this->font;
  result = 0;
  result = EwParseFlowString((XFont*)handle, aString + aOffset, aWidth, aMaxNoOfRows, aBidi );
  return result;
}

/* The method GetTextAdvance() calculates the horizontal advance in pixel of a text 
   row to print with this font. This value is calculated by the sum of advance values 
   of all affected glyphs. The text is passed in the parameter aString. The parameter 
   aOffset determines within aString the sign to start the calculation. If aOffset 
   is zero, the calculation starts with the first sign. The parameter aCount determines 
   the max. number of following sigs to calculate the advance value. If aCount is 
   -1, all signs until the end of the string will be evaluated. */
XInt32 ResourcesFont_GetTextAdvance( ResourcesFont _this, XString aString, XInt32 
  aOffset, XInt32 aCount )
{
  XHandle handle;
  XInt32 advance;

  if ( aOffset < 0 )
    aOffset = 0;

  if (( _this->font == 0 ) || (( aOffset > 0 ) && ( aOffset >= EwGetStringLength( 
      aString ))))
    return 0;

  handle = _this->font;
  advance = 0;
  advance = EwGetTextAdvance((XFont*)handle, aString + aOffset, aCount );
  return advance;
}

/* Default onget method for the property 'Leading' */
XInt32 ResourcesFont_OnGetLeading( ResourcesFont _this )
{
  return _this->Leading;
}

/* Wrapper function for the non virtual method : 'Resources::Font.OnGetLeading()' */
XInt32 ResourcesFont__OnGetLeading( void* _this )
{
  return ResourcesFont_OnGetLeading((ResourcesFont)_this );
}

/* Default onget method for the property 'Descent' */
XInt32 ResourcesFont_OnGetDescent( ResourcesFont _this )
{
  return _this->Descent;
}

/* Wrapper function for the non virtual method : 'Resources::Font.OnGetDescent()' */
XInt32 ResourcesFont__OnGetDescent( void* _this )
{
  return ResourcesFont_OnGetDescent((ResourcesFont)_this );
}

/* Default onget method for the property 'Ascent' */
XInt32 ResourcesFont_OnGetAscent( ResourcesFont _this )
{
  return _this->Ascent;
}

/* Wrapper function for the non virtual method : 'Resources::Font.OnGetAscent()' */
XInt32 ResourcesFont__OnGetAscent( void* _this )
{
  return ResourcesFont_OnGetAscent((ResourcesFont)_this );
}

/* Variants derived from the class : 'Resources::Font' */
EW_DEFINE_CLASS_VARIANTS( ResourcesFont )
EW_END_OF_CLASS_VARIANTS( ResourcesFont )

/* Virtual Method Table (VMT) for the class : 'Resources::Font' */
EW_DEFINE_CLASS( ResourcesFont, CoreResource, _None, _None, _None, _None, _None, 
                 "Resources::Font" )
EW_END_OF_CLASS( ResourcesFont )

/* The medium version of the default font resource. The resource is using 'Roboto' 
   TrueType font with 24 pixel height. */
EW_DEFINE_FONT_RES( ResourcesFontMedium, 19, 5, 0, 16, 0x0001, 0x00C0 )
  EW_GLYPH( 0x0001, 1, -14, 7, 14, 9, 0x00000000 ),
  EW_GLYPH( 0x0020, 0, 0, 0, 0, 5, 0x00000144 ),                /* ' ' */
  EW_GLYPH( 0x0021, 1, -14, 3, 14, 5, 0x00000144 ),             /* '!' */
  EW_GLYPH( 0x0022, 1, -15, 5, 5, 6, 0x000001A6 ),              /* '"' */
  EW_GLYPH( 0x0023, 1, -14, 12, 14, 12, 0x000001EC ),           /* '#' */
  EW_GLYPH( 0x0024, 1, -17, 10, 19, 11, 0x000003ED ),           /* '$' */
  EW_GLYPH( 0x0025, 1, -14, 13, 14, 15, 0x00000651 ),           /* '%' */
  EW_GLYPH( 0x0026, 1, -14, 12, 14, 12, 0x000008C9 ),           /* '&' */
  EW_GLYPH( 0x0027, 1, -15, 2, 5, 3, 0x00000B06 ),              /* ''' */
  EW_GLYPH( 0x0028, 1, -16, 6, 21, 7, 0x00000B1F ),             /* '(' */
  EW_GLYPH( 0x0029, 0, -16, 6, 21, 7, 0x00000C77 ),             /* ')' */
  EW_GLYPH( 0x002A, 0, -14, 9, 9, 9, 0x00000DCF ),              /* '*' */
  EW_GLYPH( 0x002B, 0, -13, 11, 12, 11, 0x00000ECB ),           /* '+' */
  EW_GLYPH( 0x002C, 0, -2, 3, 5, 4, 0x00000FB5 ),               /* ',' */
  EW_GLYPH( 0x002D, 0, -7, 6, 2, 6, 0x00000FEC ),               /* '-' */
  EW_GLYPH( 0x002E, 1, -2, 3, 2, 5, 0x00001010 ),               /* '.' */
  EW_GLYPH( 0x002F, 0, -14, 8, 15, 8, 0x00001025 ),             /* '/' */
  EW_GLYPH( 0x0030, 1, -14, 10, 14, 11, 0x00001140 ),           /* '0' */
  EW_GLYPH( 0x0031, 1, -14, 7, 14, 11, 0x000012C7 ),            /* '1' */
  EW_GLYPH( 0x0032, 0, -14, 11, 14, 11, 0x0000137F ),           /* '2' */
  EW_GLYPH( 0x0033, 0, -14, 10, 14, 11, 0x00001553 ),           /* '3' */
  EW_GLYPH( 0x0034, 0, -14, 11, 14, 11, 0x00001729 ),           /* '4' */
  EW_GLYPH( 0x0035, 1, -14, 10, 14, 11, 0x00001880 ),           /* '5' */
  EW_GLYPH( 0x0036, 1, -14, 10, 14, 11, 0x00001A41 ),           /* '6' */
  EW_GLYPH( 0x0037, 0, -14, 11, 14, 11, 0x00001C10 ),           /* '7' */
  EW_GLYPH( 0x0038, 1, -14, 10, 14, 11, 0x00001D8D ),           /* '8' */
  EW_GLYPH( 0x0039, 1, -14, 9, 14, 11, 0x00001F7B ),            /* '9' */
  EW_GLYPH( 0x003A, 1, -11, 3, 11, 5, 0x0000214E ),             /* ':' */
  EW_GLYPH( 0x003B, 0, -11, 4, 14, 4, 0x00002199 ),             /* ';' */
  EW_GLYPH( 0x003C, 0, -11, 9, 9, 10, 0x00002214 ),             /* '<' */
  EW_GLYPH( 0x003D, 1, -9, 9, 6, 11, 0x00002339 ),              /* '=' */
  EW_GLYPH( 0x003E, 1, -11, 9, 9, 10, 0x000023DE ),             /* '>' */
  EW_GLYPH( 0x003F, 0, -14, 9, 14, 9, 0x00002515 ),             /* '?' */
  EW_GLYPH( 0x0040, 1, -14, 17, 18, 18, 0x00002675 ),           /* '@' */
  EW_GLYPH( 0x0041, 0, -14, 13, 14, 13, 0x00002A91 ),           /* 'A' */
  EW_GLYPH( 0x0042, 1, -14, 11, 14, 12, 0x00002C7D ),           /* 'B' */
  EW_GLYPH( 0x0043, 1, -14, 12, 14, 13, 0x00002E29 ),           /* 'C' */
  EW_GLYPH( 0x0044, 1, -14, 11, 14, 13, 0x0000301F ),           /* 'D' */
  EW_GLYPH( 0x0045, 1, -14, 10, 14, 11, 0x00003198 ),           /* 'E' */
  EW_GLYPH( 0x0046, 1, -14, 10, 14, 11, 0x000032C9 ),           /* 'F' */
  EW_GLYPH( 0x0047, 1, -14, 12, 14, 14, 0x000033D3 ),           /* 'G' */
  EW_GLYPH( 0x0048, 1, -14, 12, 14, 14, 0x000035E3 ),           /* 'H' */
  EW_GLYPH( 0x0049, 1, -14, 3, 14, 5, 0x000036E6 ),             /* 'I' */
  EW_GLYPH( 0x004A, 0, -14, 10, 14, 11, 0x0000371D ),           /* 'J' */
  EW_GLYPH( 0x004B, 1, -14, 12, 14, 13, 0x0000382D ),           /* 'K' */
  EW_GLYPH( 0x004C, 1, -14, 10, 14, 11, 0x000039D8 ),           /* 'L' */
  EW_GLYPH( 0x004D, 1, -14, 15, 14, 17, 0x00003A90 ),           /* 'M' */
  EW_GLYPH( 0x004E, 1, -14, 12, 14, 14, 0x00003C96 ),           /* 'N' */
  EW_GLYPH( 0x004F, 1, -14, 12, 14, 14, 0x00003DFC ),           /* 'O' */
  EW_GLYPH( 0x0050, 1, -14, 12, 14, 13, 0x00004004 ),           /* 'P' */
  EW_GLYPH( 0x0051, 1, -14, 12, 17, 14, 0x00004185 ),           /* 'Q' */
  EW_GLYPH( 0x0052, 1, -14, 11, 14, 12, 0x000043F0 ),           /* 'R' */
  EW_GLYPH( 0x0053, 0, -14, 12, 14, 12, 0x00004592 ),           /* 'S' */
  EW_GLYPH( 0x0054, 0, -14, 12, 14, 12, 0x000047EF ),           /* 'T' */
  EW_GLYPH( 0x0055, 1, -14, 11, 14, 13, 0x000048F2 ),           /* 'U' */
  EW_GLYPH( 0x0056, 0, -14, 13, 14, 13, 0x00004A23 ),           /* 'V' */
  EW_GLYPH( 0x0057, 0, -14, 18, 14, 18, 0x00004BF9 ),           /* 'W' */
  EW_GLYPH( 0x0058, 0, -14, 12, 14, 13, 0x00004EB7 ),           /* 'X' */
  EW_GLYPH( 0x0059, 0, -14, 12, 14, 12, 0x000050BD ),           /* 'Y' */
  EW_GLYPH( 0x005A, 0, -14, 12, 14, 12, 0x00005235 ),           /* 'Z' */
  EW_GLYPH( 0x005B, 1, -16, 5, 19, 5, 0x000053DD ),             /* '[' */
  EW_GLYPH( 0x005C, 0, -14, 8, 15, 8, 0x00005466 ),             /* '\' */
  EW_GLYPH( 0x005D, 0, -16, 4, 19, 5, 0x0000558E ),             /* ']' */
  EW_GLYPH( 0x005E, 0, -14, 8, 7, 8, 0x00005602 ),              /* '^' */
  EW_GLYPH( 0x005F, 0, 0, 9, 2, 9, 0x000056BA ),                /* '_' */
  EW_GLYPH( 0x0060, 0, -15, 5, 3, 6, 0x000056F0 ),              /* '`' */
  EW_GLYPH( 0x0061, 1, -11, 9, 11, 11, 0x00005728 ),            /* 'a' */
  EW_GLYPH( 0x0062, 1, -15, 10, 15, 11, 0x00005895 ),           /* 'b' */
  EW_GLYPH( 0x0063, 0, -11, 10, 11, 10, 0x00005A17 ),           /* 'c' */
  EW_GLYPH( 0x0064, 0, -15, 10, 15, 11, 0x00005B90 ),           /* 'd' */
  EW_GLYPH( 0x0065, 1, -11, 10, 11, 11, 0x00005D1B ),           /* 'e' */
  EW_GLYPH( 0x0066, 0, -15, 7, 15, 7, 0x00005EAD ),             /* 'f' */
  EW_GLYPH( 0x0067, 0, -11, 10, 15, 11, 0x00005F82 ),           /* 'g' */
  EW_GLYPH( 0x0068, 1, -15, 9, 15, 11, 0x0000617B ),            /* 'h' */
  EW_GLYPH( 0x0069, 1, -15, 3, 15, 5, 0x00006275 ),             /* 'i' */
  EW_GLYPH( 0x006A, -1, -15, 5, 19, 5, 0x000062CF ),            /* 'j' */
  EW_GLYPH( 0x006B, 1, -15, 10, 15, 10, 0x0000637E ),           /* 'k' */
  EW_GLYPH( 0x006C, 1, -15, 3, 15, 5, 0x000064D8 ),             /* 'l' */
  EW_GLYPH( 0x006D, 1, -11, 16, 11, 18, 0x00006512 ),           /* 'm' */
  EW_GLYPH( 0x006E, 1, -11, 9, 11, 11, 0x000066A1 ),            /* 'n' */
  EW_GLYPH( 0x006F, 0, -11, 11, 11, 11, 0x00006773 ),           /* 'o' */
  EW_GLYPH( 0x0070, 1, -11, 10, 15, 11, 0x0000690E ),           /* 'p' */
  EW_GLYPH( 0x0071, 0, -11, 10, 15, 11, 0x00006AAB ),           /* 'q' */
  EW_GLYPH( 0x0072, 1, -11, 6, 11, 7, 0x00006C43 ),             /* 'r' */
  EW_GLYPH( 0x0073, 0, -11, 10, 11, 10, 0x00006CC4 ),           /* 's' */
  EW_GLYPH( 0x0074, 0, -14, 7, 14, 7, 0x00006E6E ),             /* 't' */
  EW_GLYPH( 0x0075, 1, -11, 9, 11, 11, 0x00006F22 ),            /* 'u' */
  EW_GLYPH( 0x0076, 0, -11, 10, 11, 10, 0x00006FEF ),           /* 'v' */
  EW_GLYPH( 0x0077, 0, -11, 15, 11, 15, 0x0000713A ),           /* 'w' */
  EW_GLYPH( 0x0078, 0, -11, 10, 11, 10, 0x00007336 ),           /* 'x' */
  EW_GLYPH( 0x0079, 0, -11, 9, 15, 9, 0x000074AB ),             /* 'y' */
  EW_GLYPH( 0x007A, 0, -11, 10, 11, 10, 0x00007643 ),           /* 'z' */
  EW_GLYPH( 0x007B, 0, -16, 7, 20, 7, 0x00007770 ),             /* '{' */
  EW_GLYPH( 0x007C, 1, -14, 3, 17, 5, 0x000078BA ),             /* '|' */
  EW_GLYPH( 0x007D, 0, -16, 7, 20, 7, 0x000078F8 ),             /* '}' */
  EW_GLYPH( 0x007E, 1, -8, 12, 4, 14, 0x00007A45 ),             /* '~' */
  EW_GLYPH( 0x00A0, 0, 0, 0, 0, 5, 0x00007B01 ),
  EW_GLYPH( 0x00A1, 1, -11, 3, 15, 5, 0x00007B01 ),
  EW_GLYPH( 0x00A2, 1, -14, 9, 17, 11, 0x00007B6B ),
  EW_GLYPH( 0x00A3, 1, -14, 11, 14, 12, 0x00007D24 ),
  EW_GLYPH( 0x00A4, 0, -13, 14, 14, 14, 0x00007EB3 ),
  EW_GLYPH( 0x00A5, 0, -14, 12, 14, 12, 0x0000812A ),
  EW_GLYPH( 0x00A6, 1, -14, 3, 17, 5, 0x0000831B ),
  EW_GLYPH( 0x00A7, 0, -14, 11, 19, 12, 0x00008375 ),
  EW_GLYPH( 0x00A8, 1, -14, 7, 2, 8, 0x0000868F ),
  EW_GLYPH( 0x00A9, 1, -14, 14, 14, 16, 0x000086B1 ),
  EW_GLYPH( 0x00AA, 1, -14, 7, 7, 9, 0x000089A7 ),
  EW_GLYPH( 0x00AB, 1, -9, 8, 8, 9, 0x00008A78 ),
  EW_GLYPH( 0x00AC, 1, -8, 9, 4, 11, 0x00008B6A ),
  EW_GLYPH( 0x00AD, 0, -7, 6, 2, 6, 0x00008BD2 ),
  EW_GLYPH( 0x00AE, 1, -14, 14, 14, 16, 0x00008BF6 ),
  EW_GLYPH( 0x00AF, 1, -14, 8, 1, 9, 0x00008EA0 ),
  EW_GLYPH( 0x00B0, 1, -14, 6, 6, 7, 0x00008EC9 ),
  EW_GLYPH( 0x00B1, 1, -12, 9, 12, 11, 0x00008F53 ),
  EW_GLYPH( 0x00B2, 0, -14, 7, 8, 7, 0x00009045 ),
  EW_GLYPH( 0x00B3, 0, -14, 7, 8, 7, 0x0000911B ),
  EW_GLYPH( 0x00B4, 1, -15, 5, 3, 6, 0x0000920A ),
  EW_GLYPH( 0x00B5, 1, -11, 9, 15, 11, 0x00009244 ),
  EW_GLYPH( 0x00B6, 0, -14, 9, 14, 10, 0x0000934F ),
  EW_GLYPH( 0x00B7, 1, -8, 3, 2, 5, 0x00009441 ),
  EW_GLYPH( 0x00B8, 1, 0, 4, 4, 5, 0x00009457 ),
  EW_GLYPH( 0x00B9, 1, -14, 4, 8, 7, 0x000094A4 ),
  EW_GLYPH( 0x00BA, 1, -14, 7, 7, 9, 0x000094F8 ),
  EW_GLYPH( 0x00BB, 0, -9, 10, 8, 9, 0x000095C9 ),
  EW_GLYPH( 0x00BC, 1, -14, 13, 14, 15, 0x000096CF ),
  EW_GLYPH( 0x00BD, 1, -14, 14, 14, 16, 0x000098D4 ),
  EW_GLYPH( 0x00BE, 0, -14, 15, 14, 16, 0x00009B0B ),
  EW_GLYPH( 0x00BF, 0, -11, 9, 15, 9, 0x00009DA9 ),
  EW_GLYPH( 0x00C0, 0, -18, 13, 18, 13, 0x00009F14 ),
  EW_GLYPH( 0x00C1, 0, -18, 13, 18, 13, 0x0000A16A ),
  EW_GLYPH( 0x00C2, 0, -18, 13, 18, 13, 0x0000A3C0 ),
  EW_GLYPH( 0x00C3, 0, -18, 13, 18, 13, 0x0000A639 ),
  EW_GLYPH( 0x00C4, 0, -17, 13, 17, 13, 0x0000A8B2 ),
  EW_GLYPH( 0x00C5, 0, -19, 13, 19, 13, 0x0000AAED ),
  EW_GLYPH( 0x00C6, -1, -14, 20, 14, 19, 0x0000AD6E ),
  EW_GLYPH( 0x00C7, 1, -14, 12, 18, 13, 0x0000B005 ),
  EW_GLYPH( 0x00C8, 1, -18, 10, 18, 11, 0x0000B277 ),
  EW_GLYPH( 0x00C9, 1, -18, 10, 18, 11, 0x0000B406 ),
  EW_GLYPH( 0x00CA, 1, -18, 10, 18, 11, 0x0000B595 ),
  EW_GLYPH( 0x00CB, 1, -17, 10, 17, 11, 0x0000B747 ),
  EW_GLYPH( 0x00CC, -1, -18, 5, 18, 5, 0x0000B8BE ),
  EW_GLYPH( 0x00CD, 1, -18, 6, 18, 5, 0x0000B95B ),
  EW_GLYPH( 0x00CE, -1, -18, 7, 18, 5, 0x0000BA0A ),
  EW_GLYPH( 0x00CF, 0, -17, 7, 17, 5, 0x0000BAEE ),
  EW_GLYPH( 0x00D0, 0, -14, 13, 14, 13, 0x0000BB9A ),
  EW_GLYPH( 0x00D1, 1, -18, 12, 18, 14, 0x0000BD66 ),
  EW_GLYPH( 0x00D2, 1, -18, 12, 18, 14, 0x0000BF55 ),
  EW_GLYPH( 0x00D3, 1, -18, 12, 18, 14, 0x0000C1C3 ),
  EW_GLYPH( 0x00D4, 1, -18, 12, 18, 14, 0x0000C431 ),
  EW_GLYPH( 0x00D5, 1, -18, 12, 18, 14, 0x0000C6C2 ),
  EW_GLYPH( 0x00D6, 1, -17, 12, 17, 14, 0x0000C953 ),
  EW_GLYPH( 0x00D7, 0, -11, 10, 9, 11, 0x0000CBA7 ),
  EW_GLYPH( 0x00D8, 1, -15, 12, 16, 14, 0x0000CD00 ),
  EW_GLYPH( 0x00D9, 1, -18, 11, 18, 13, 0x0000CF96 ),
  EW_GLYPH( 0x00DA, 1, -18, 11, 18, 13, 0x0000D129 ),
  EW_GLYPH( 0x00DB, 1, -18, 11, 18, 13, 0x0000D2BC ),
  EW_GLYPH( 0x00DC, 1, -17, 11, 17, 13, 0x0000D472 ),
  EW_GLYPH( 0x00DD, 0, -18, 12, 18, 12, 0x0000D5EC ),
  EW_GLYPH( 0x00DE, 1, -14, 10, 14, 12, 0x0000D7CA ),
  EW_GLYPH( 0x00DF, 1, -15, 11, 15, 12, 0x0000D922 ),
  EW_GLYPH( 0x00E0, 1, -15, 9, 15, 11, 0x0000DAE5 ),
  EW_GLYPH( 0x00E1, 1, -15, 9, 15, 11, 0x0000DCAC ),
  EW_GLYPH( 0x00E2, 1, -16, 9, 16, 11, 0x0000DE73 ),
  EW_GLYPH( 0x00E3, 1, -16, 9, 16, 11, 0x0000E066 ),
  EW_GLYPH( 0x00E4, 1, -15, 9, 15, 11, 0x0000E259 ),
  EW_GLYPH( 0x00E5, 1, -16, 9, 16, 11, 0x0000E412 ),
  EW_GLYPH( 0x00E6, 0, -11, 17, 11, 17, 0x0000E600 ),
  EW_GLYPH( 0x00E7, 0, -11, 10, 15, 10, 0x0000E8B4 ),
  EW_GLYPH( 0x00E8, 1, -15, 10, 15, 11, 0x0000EA9C ),
  EW_GLYPH( 0x00E9, 1, -15, 10, 15, 11, 0x0000EC8C ),
  EW_GLYPH( 0x00EA, 1, -16, 10, 16, 11, 0x0000EE7C ),
  EW_GLYPH( 0x00EB, 1, -15, 10, 15, 11, 0x0000F099 ),
  EW_GLYPH( 0x00EC, -1, -15, 5, 15, 5, 0x0000F27B ),
  EW_GLYPH( 0x00ED, 1, -15, 5, 15, 5, 0x0000F309 ),
  EW_GLYPH( 0x00EE, -1, -16, 7, 16, 5, 0x0000F397 ),
  EW_GLYPH( 0x00EF, -1, -15, 7, 15, 5, 0x0000F46D ),
  EW_GLYPH( 0x00F0, 1, -15, 10, 15, 12, 0x0000F50B ),
  EW_GLYPH( 0x00F1, 1, -16, 9, 16, 11, 0x0000F72B ),
  EW_GLYPH( 0x00F2, 0, -15, 11, 15, 11, 0x0000F883 ),
  EW_GLYPH( 0x00F3, 0, -15, 11, 15, 11, 0x0000FA80 ),
  EW_GLYPH( 0x00F4, 0, -16, 11, 16, 11, 0x0000FC7D ),
  EW_GLYPH( 0x00F5, 0, -16, 11, 16, 11, 0x0000FEA8 ),
  EW_GLYPH( 0x00F6, 0, -15, 11, 15, 11, 0x000100D3 ),
  EW_GLYPH( 0x00F7, 0, -12, 11, 10, 11, 0x000102C2 ),
  EW_GLYPH( 0x00F8, 0, -12, 11, 14, 11, 0x000103B8 ),
  EW_GLYPH( 0x00F9, 1, -15, 9, 15, 11, 0x000105D3 ),
  EW_GLYPH( 0x00FA, 1, -15, 9, 15, 11, 0x000106FA ),
  EW_GLYPH( 0x00FB, 1, -16, 9, 16, 11, 0x00010821 ),
  EW_GLYPH( 0x00FC, 1, -15, 9, 15, 11, 0x00010974 ),
  EW_GLYPH( 0x00FD, 0, -15, 9, 19, 9, 0x00010A8D ),
  EW_GLYPH( 0x00FE, 1, -15, 10, 19, 12, 0x00010C7F ),
  EW_GLYPH( 0x00FF, 0, -15, 9, 19, 9, 0x00010E33 ),

  EW_FONT_PIXEL( ResourcesFontMedium, 0x00011017 )              /* ratio 68.52 % */
    0xEF7BDEF7, 0xEF7BFF1D, 0xA4F0A7AE, 0x8F50F94C, 0xC2462067, 0xE6000FBC, 0xA246207D,
    0x5320CF1E, 0x93C29E3E, 0xDDEF7FE3, 0x2005DCF5, 0x600C1058, 0xACE307DC, 0x1F73FBC5,
    0x10E98301, 0x8FEF0182, 0x66D407F7, 0x4659906D, 0xDFEF7114, 0x11BEDBBE, 0xEF753EF7,
    0x981BDCF3, 0x1E409983, 0x3C641FC6, 0xFEFFC4D2, 0xEFB7FBED, 0xB8D77FE3, 0x0FBDD577,
    0xB02461F2, 0x9900F30E, 0x96180722, 0x00220134, 0xAC000376, 0xC0DFAE7F, 0x3FEA29D7,
    0x9EFB93E4, 0x37E5AF19, 0x5C259BC4, 0xFCE557E8, 0x66E2CF15, 0xC897CEFD, 0x5D9E5BFF,
    0x46777F30, 0x35BC42AB, 0x54103FA2, 0x93E6297C, 0xBFF3E6F1, 0x7B13F5E7, 0x24DFA886,
    0x2BF7E3DE, 0xE7BC0320, 0x773F4034, 0x7CF0133F, 0xF89FCF91, 0x93B83905, 0xB839045F,
    0x3C3F53D3, 0xE3B3E45F, 0x73F40BF7, 0xF57EB3F7, 0x7E9CF780, 0x1673BFAA, 0xE3AFDF88,
    0x5F81F7EC, 0xBAE4753D, 0x2627EA78, 0x42FDF882, 0x3D4F044C, 0x52EB91D4, 0xFB38BE1F,
    0x9EFB987D, 0x88779E06, 0xBDE381F5, 0x32C07CFF, 0xA5280565, 0xBE6F04D6, 0x106CDFBF,
    0xC0DBD64F, 0xAC3E2ABB, 0xFDFECD61, 0xBCBB27C6, 0xE7DE7963, 0xE604432D, 0xE54B3B3B,
    0x47C4421B, 0xBCF73CC7, 0xF630EF91, 0xEBECF14C, 0x4C485DC4, 0x0ADE0778, 0x7A293CE6,
    0xF0FC660E, 0x0FE4648D, 0x2263818F, 0x1048240C, 0x63C2C712, 0xBE0FE460, 0x43F19891,
    0xEB981AF4, 0xB98ADE24, 0x461779E0, 0x171CC0F7, 0x89E0F1DE, 0x3FC0F503, 0x1083D206,
    0x10816058, 0x31FE0F48, 0x0E2A0F50, 0xEA7878EE, 0x783D7E32, 0x173C05DE, 0x8C4AD400,
    0xEDFF78D7, 0xF9D72BBF, 0x4FFFEB0D, 0xAA06A786, 0x3C1F1BFB, 0x8FA81BD3, 0x600100FA,
    0x0000059C, 0xBDC60000, 0xEF7BEB77, 0xF7B8C002, 0x5DEF7D6E, 0x00000000, 0xEFC0BB20,
    0xDF91CCC2, 0x7BDEF5AC, 0x4CF3006F, 0x6099C401, 0x80ABE05A, 0x164E03CA, 0x9A607D44,
    0x630157E0, 0x4165F01C, 0x98AC0FAC, 0xC6027BE0, 0x02CBE038, 0x2F9EFFF4, 0x9E295BF1,
    0xFB1A9E1B, 0x5B5F279E, 0x4945F10F, 0x0130CF05, 0x00000002, 0x0A910098, 0xEF7F0CF1,
    0xAA945F10, 0xBE54F7DC, 0xE78A56FC, 0x87FAC406, 0xE7A76EFA, 0xEE6264F7, 0x01DE793D,
    0x00000000, 0x00000000, 0xF3DFFDE2, 0x299EE40D, 0x73A0FF9E, 0x789E7B9E, 0xFC437CA9,
    0x842F7E2C, 0xBD3053C5, 0x8039EA80, 0xA8179EFA, 0xE301F9EF, 0xF8C07E7B, 0xFC603F3F,
    0x46E01F9F, 0xBDEF7BDD, 0xDE20004B, 0x906FFF73, 0x3B9C867B, 0xCF73AE74, 0x1D1CD393,
    0x0DEDFDA2, 0xF1BC600C, 0xE7BBDC61, 0xC3630037, 0x56BFF7B8, 0xB946F903, 0xAC63081B,
    0x372C6F10, 0xA333DCFA, 0x9C84FD8D, 0xFF798137, 0xEF006C80, 0x02F59800, 0xDE0167B2,
    0x1D6602F1, 0x801AF640, 0xA9E03477, 0x795EF7BC, 0xBAC0097F, 0xE57BDEF7, 0x000001FD,
    0xEF7BDEEA, 0xB08024BD, 0x72F7BDEF, 0x00446024, 0xDDCF78E6, 0x8C339113, 0xFFBEF177,
    0x4378DF7B, 0x28CE64CD, 0x1F799FC0, 0x9E0F4A48, 0xF73B2A37, 0x61BC5FBD, 0x5BEA25BD,
    0x03BEEF90, 0x3C039EE6, 0x81DFFEAF, 0x184AFF8E, 0xCE500739, 0x38AFEE77, 0x7BF509FA,
    0xDBDDFCA4, 0x4F58A71A, 0x5CFE048E, 0xA2B17F05, 0x1993D61F, 0x1DBDDF1D, 0x1157F32F,
    0xDEE32FF5, 0xF7BDEF7B, 0xB8C4003E, 0xEF7BDEF7, 0xF1A80518, 0x007CDC02, 0x1D007EA3,
    0x05EA3013, 0x518098E8, 0xBC6F0033, 0x00567C80, 0xCF900FDA, 0xDFFE8093, 0x4AF625F3,
    0x8CF0DCF1, 0xF279EFB1, 0xFC43D7F5, 0x9E10170C, 0xAE7E21E8, 0x53DF72FC, 0x32E090FD,
    0x33DFFADF, 0x4BE2FB57, 0x200535D1, 0x621BC562, 0x3CC74655, 0x7B96B4F7, 0x10FDA8A6,
    0x45FFB9EF, 0x5FB219EC, 0x3BB9CF9D, 0x617E5567, 0x309CFF1C, 0x440989F2, 0x2FC617E5,
    0xEEE73C75, 0x227EE427, 0xBF29BF9E, 0x80313E73, 0xBB3C43F6, 0xDF3DC19E, 0xF3E41FA8,
    0x533CC2FD, 0x00027798, 0xCC14CF30, 0x9DE60933, 0x7E000000, 0xE4699817, 0x9802D667,
    0x4DE7582F, 0xF78F4FA2, 0xF55DEF17, 0xC7394FFB, 0xC6B90AFE, 0xDF442BFF, 0x113DBF59,
    0x1FDE3A7D, 0xD737FF58, 0x7BDEF7BD, 0xDEEB005F, 0x2FBDEF7B, 0xBDEF7580, 0xC017DEF7,
    0x9EF9013B, 0xCF7DF80E, 0xF3C0EFBA, 0x7FB5CFFB, 0xEAB7D903, 0xF55BE8C3, 0xD73DBF99,
    0xEF7E37FF, 0xE49BEEB3, 0xB5803A7B, 0xB792F9EF, 0xC4767887, 0x13CF7DCC, 0xB443BF53,
    0x1D30AB13, 0xC40F1D10, 0xBE12FC7F, 0x9AA81EFC, 0xB036180F, 0xE600016E, 0xCC000079,
    0xB7E7B9DF, 0x56FFEA00, 0xA053EA88, 0xBDF6B1BE, 0x206FB777, 0x607BB1BF, 0xED079BAC,
    0xF3DDFCA6, 0xC8F19C46, 0x4BB94DE7, 0x7B6B92CC, 0xEF7AF262, 0xFF1F705F, 0x89CD6427,
    0x292293C9, 0x9840D31F, 0x0A491387, 0xC04B8A66, 0x0D69EC49, 0xCCCF1E22, 0x7EDFD630,
    0xBF77CFC2, 0x73FDFEC7, 0x8E8D78AA, 0x4F1ADFE8, 0xA6B519FD, 0xE7D2CE75, 0xDE37817C,
    0x0563055F, 0xEFD47B90, 0x013BBBDC, 0xF14ADFB9, 0xBAC001EC, 0x07CF800B, 0x02C8E460,
    0x01C4E2F8, 0x2AB27AC4, 0x89C71580, 0xA8F17C09, 0x0B18C0FC, 0xF9F80E4F, 0xE983E7E3,
    0x16DDEF77, 0xE4C4009E, 0xEF7BDDF8, 0x8D64F9FD, 0x78C63502, 0xEFD7807C, 0xFBDEF7B9,
    0x3E4006FF, 0xF7BE81FF, 0x880D159E, 0x003000F6, 0xF7D0F9F9, 0x0BD3FFDE, 0xF7D12FC0,
    0x05E5FBDE, 0x000E5678, 0x78AE6016, 0x7DEF7BE8, 0xEA200DE3, 0xF7DE885B, 0x5EE426FC,
    0xE1FBD443, 0x7F7BED64, 0x519E99E3, 0x3F5D41BF, 0x4E6305DB, 0x7F78078F, 0x80000042,
    0x0F1E0010, 0x176CFEF0, 0x519E5CE4, 0x8F8EA0DF, 0xF7BECF93, 0xEE499E37, 0x8FBEA295,
    0xCF7BDEE7, 0xBD44026F, 0xDEF7D03B, 0xA01F18DF, 0x5C015576, 0x004CA007, 0x000C0099,
    0x02650019, 0xD9E20BB4, 0xDEFA1EA3, 0x01F18DF3, 0xCF0EEF51, 0x7BDEF7BD, 0x7D000BEF,
    0xBEF7BDEF, 0x00000000, 0xF7BDEF7D, 0xDEFA0007, 0x000FEF7B, 0xDF400000, 0x3FBDEF7B,
    0xEF7B9E00, 0x05DEF7BD, 0xBDEF7D00, 0x00002EF7, 0xF7BE8000, 0x4000BBDE, 0x5DEF7BDF,
    0x00000000, 0x7A200000, 0xE417B3DF, 0xFE8C435E, 0x7BED64E1, 0x8CF6A8F7, 0x7F8C1BF1,
    0xE20BDB4C, 0xA80B49FB, 0x000032C7, 0x637BDEF7, 0xC2860019, 0xF9F8B7BD, 0xFCA8C005,
    0xDF135117, 0xCF7BBF18, 0xFB109F2F, 0xF7CF90AD, 0x9E02EE79, 0x000002FB, 0x00000000,
    0xBDEF7D00, 0x00007EF7, 0xF7BDEF7D, 0x0000007E, 0x00000000, 0x002FB8C0, 0x00000000,
    0x0005DCF0, 0x00000000, 0x00000000, 0x59E60020, 0xB78F17F0, 0x6633D398, 0x637DEEFC,
    0x510F6F0E, 0x0BB9EBEF, 0xD600FDF4, 0x74F00FAA, 0x37E300FD, 0xC7FE403E, 0x9BAE2009,
    0x93E7FDC0, 0x016BA980, 0x5D3D7FC6, 0xF97E17C0, 0x389C4025, 0x178F4600, 0x00F9AAC0,
    0xCF97E2F8, 0x0000005D, 0x00000000, 0x00000000, 0x80000000, 0x7BDEF7BE, 0xBDCF0007,
    0x0FEFB005, 0x44063007, 0x5409F005, 0x06AB104C, 0xC5607E6E, 0x165F1819, 0xC409F2FC,
    0x0FCA838C, 0x13827A88, 0xA29AF013, 0xE318022A, 0xF800E333, 0x00B2F9F2, 0x00FCE8CC,
    0x002632B0, 0xBAC02B3E, 0xC3EEB01F, 0x03780053, 0x801FC8C0, 0xF0029EB7, 0xF9001BC6,
    0x1AC00FE6, 0xF138014F, 0x5F37C802, 0x0DCC6B00, 0xC80144E0, 0x806B0017, 0x4DF9EFB5,
    0x510F7F88, 0xD65F0FEF, 0xD597F7BE, 0x506FC6AA, 0xBDFC663B, 0x2A546620, 0x00A72FE0,
    0x530003A6, 0x0549D300, 0x0BDFE5FC, 0x8D554662, 0x31FEA0DF, 0xDF6A37C3, 0xC4D51BFB,
    0xFDEA21EE, 0x7BDEF711, 0x3000EEEF, 0xBDD40ED6, 0x06CAEEF7, 0x0058BF18, 0x9E00113C,
    0xA2F8C008, 0xBBDEF750, 0x5C806C9F, 0xDEF7513B, 0x0000EFFB, 0x00000000, 0xF3DF6B00,
    0x87BB109B, 0x6F87F7A8, 0x37F7BED4, 0xFC6A35EA, 0x158FF506, 0x19882F3F, 0x76C0586B,
    0x0B12C018, 0x9600CB00, 0x9DB01618, 0xB4C4179F, 0xA0DF8D46, 0x37C331FE, 0x1BFBDF6A,
    0x87BB12F5, 0xBED60908, 0x27733CE7, 0x0019D7C0, 0xDEEB19D6, 0x4DFFEF7B, 0xE07B9C80,
    0x9FFEF7BB, 0x72FC80B8, 0x0034C004, 0x2F8C01A6, 0xBDEEF82B, 0xA017C9FB, 0xF7BBE276,
    0xE3A003E6, 0x53D4F007, 0x00BC6F00, 0xEE6366F9, 0xDF837773, 0xFF58C23B, 0xF7D8D560,
    0xF1FC9FFE, 0xF2FC83D7, 0x3F782521, 0x27BF78BE, 0x8FFC87A8, 0x817B3BE7, 0xD1CCF7B1,
    0xFDE304FF, 0x9E5F27EF, 0x8A8DF182, 0x11605EF8, 0xB906FE4F, 0xD46FC32A, 0xF1DFF7BE,
    0x90ADFB12, 0xEF759773, 0x7BDEF7BD, 0x758002EF, 0xDEF2BDEF, 0x0000177B, 0x00000000,
    0x00000000, 0x00000000, 0x77BC0000, 0x005F7180, 0x00000000, 0x00000000, 0xC0160000,
    0x278941B1, 0x5EB10AD6, 0xF73EB65F, 0xFE69BC74, 0x6FCF109E, 0xBC05F79A, 0x8058CE77,
    0x028ACB15, 0x073E1515, 0x0591871C, 0x3C5F0B2A, 0xC781E278, 0xD641F1C1, 0x04A9E213,
    0x7F159627, 0x7FBF89E0, 0xAAAAC04C, 0xFD79F005, 0x16664601, 0xEA07CF80, 0xF07F3836,
    0x305151DD, 0x18AC0722, 0x2145019E, 0x7B0A18B3, 0xB3658D8C, 0x1EAAA20D, 0x4D943DFC,
    0x2A28EDF9, 0x8EC3C606, 0x1467F151, 0xA8AB0C54, 0xD5B0FE52, 0x1CCECB88, 0x14BFCA0A,
    0x6018ED4B, 0x8C415DCC, 0xF2A01F3D, 0x1B9550D9, 0xFC1447F8, 0x07250142, 0xF881888C,
    0xEDEF049F, 0xCC6178E8, 0x0F53CF6C, 0xFC5F8BDA, 0x8859ACC2, 0x06CE8E8E, 0x6F17E6B3,
    0x53D46F00, 0xAE002080, 0xC6B026A7, 0xF203B2FC, 0xC1F1D6CD, 0xD54F2F1B, 0xF0A7ACC3,
    0xE3B22FC6, 0xAFC6F907, 0xFB7D036F, 0x3310198D, 0xE868DE3A, 0x24AE5668, 0xF8E898D7,
    0xD4F0D1D1, 0x40AA7CCC, 0xE30357EB, 0x400E6A79, 0x2348068B, 0x00000000, 0xBDC00000,
    0xEF7BDEF7, 0xB82003FD, 0x6F7BDEF7, 0xAB558069, 0x80D5D500, 0xF803F378, 0xAE801BC6,
    0xAACF00B7, 0x7E5FC805, 0xC009C700, 0x62007A3B, 0xF7BDEF7A, 0xE0003BDE, 0x6006F7BD,
    0x000000DF, 0x00000000, 0x37D80000, 0x6605BCC0, 0x8055601C, 0xE318262F, 0x302CBE03,
    0x02AB00E3, 0x18C1317C, 0x8165F01F, 0x6B107F15, 0x02C7F805, 0xDEFFDF95, 0x002FFC1F,
    0x00000000, 0x0BFF0000, 0xC6306F60, 0x7C66F018, 0x0AE67A88, 0x4C5F7C66, 0x4FACCABE,
    0xDD64E1E5, 0xF7BDEF7B, 0x3FF1005E, 0xF8C38E29, 0xDFFDE219, 0x33BC86F3, 0x467BFCC5,
    0xD46A7BDF, 0x18E22FFA, 0xFBDFFDF2, 0xE8267B91, 0x3F7BFF58, 0x4D304E96, 0x7BDEB9AA,
    0x86FA837F, 0x77FB7F5C, 0x00000001, 0xE73BF200, 0x113EE037, 0xFFCC4FF5, 0xBE344F3D,
    0x02145F14, 0x0C30022A, 0xA80830C0, 0xBE21BE08, 0x9EFB3C28, 0x7EC47E27, 0xF2076A22,
    0xE42F773B, 0x8FE8C27E, 0x7BB9E637, 0xDE35153C, 0xE3E66E30, 0x033FE307, 0xFC780040,
    0x1A88D620, 0xCBD7C61D, 0x5DDCEB1B, 0xC27EE4B3, 0xB8805F78, 0x0000003F, 0xF9CEFC80,
    0x227DC41E, 0x7CBF0F9E, 0xA0FFF7FE, 0x92F94BE2, 0x03083051, 0x63200610, 0x2FCAC0C1,
    0xE7CE8BE4, 0xB883FFDC, 0xE1B3C44F, 0x25F3DDF9, 0xB9E257D6, 0x7BEC7B21, 0x673F5F3B,
    0xF1E3C6B0, 0x91DEF7BF, 0xEE222002, 0x1BDEF7BD, 0x7C700A33, 0xD47DE30F, 0x3DDEEF8A,
    0xA22AFE93, 0xDF7305BE, 0x0C3BCF3F, 0x3087BEAE, 0xF7396E79, 0x9CB73C01, 0x000000FB,
    0x00000000, 0xBF39DF90, 0xFB89FFF1, 0xE93FD444, 0x3FFDFFAC, 0xF94BF158, 0x80C0F112,
    0x91003004, 0xFC4F0305, 0xB378BE52, 0x20FFF7FE, 0x7F5113EE, 0x1F9CEFC8, 0x5C62BF21,
    0xBDDFACDB, 0xFF54D47B, 0x79FE8C27, 0x0000006F, 0xB9F46000, 0x185670BB, 0x7BBF125F,
    0x4B78789E, 0x120F0EBC, 0x00000000, 0x39E00000, 0x079E60CF, 0x00007DCF, 0x29E60000,
    0x58053CC0, 0x000001F7, 0x00000000, 0x3EEB17F0, 0xC5FC84F1, 0x0000077B, 0xF1000000,
    0x8FF8033F, 0x746F806F, 0x827A7E81, 0xE602D56F, 0x7FD00678, 0x8DF8A817, 0xB33CF017,
    0x02FCBF00, 0xEB3E3788, 0x0000003E, 0xB73C0000, 0x53FF7FFA, 0x12F9CEFD, 0xBEF94ADF,
    0x0E788ABF, 0x699EEFC6, 0xC73BB9D6, 0x8DE257E0, 0x4CF8C2F8, 0x48118C06, 0x00000000,
    0x00000000, 0x00000000, 0xEE7D9BDE, 0xC6159C2E, 0x9EEFC497, 0x12DE1E27, 0x0483C3AF,
    0x00000000, 0xFA200000, 0x881DFF7F, 0xFEB94AFF, 0xDFFA8F41, 0xE5668D7F, 0x972FE52F,
    0x189E0511, 0x82E1701C, 0x540788C3, 0x297F2B0C, 0xA8F4597F, 0xF8D7FDFF, 0x7295FF11,
    0xE4EFC3FD, 0x206FCE77, 0xFF5113F6, 0xFFBFF3C4, 0xF29BC68A, 0x15018517, 0x60061801,
    0x08A80C18, 0x0A2FE53A, 0x8AFFBFF5, 0xD444F7C6, 0x39DF3C4E, 0x000004BF, 0xCEFC6000,
    0xE57DC6F9, 0x3F9E22BF, 0xF7FE78DE, 0x4BF2A0FF, 0x0C1432F9, 0x600E0038, 0xE540C144,
    0x8E8BC617, 0x20FDDCE7, 0x1F3C4577, 0xEF9CEFE4, 0x00000001, 0x4EF9F758, 0xF6044FD3,
    0x1301E97D, 0x00000000, 0xF9CEFD40, 0x455FA83D, 0xF1B8B7D4, 0x2F17F7BB, 0xCFFB504B,
    0xADF9DF17, 0x52BF9831, 0x3BF50B7D, 0x2AC4F97B, 0xF7845746, 0x888AC62D, 0xEEF77F37,
    0xC2AFAC9C, 0x0BBF1B78, 0xCB77E000, 0x5BBF00BD, 0x000005EE, 0x30180000, 0x25BC1BEC,
    0xEE206EFD, 0x0000000B, 0xA4000000, 0x61BC7244, 0xCE789E5C, 0x257E49DD, 0x2EE78F9E,
    0xF89EB758, 0x1ACB2FC1, 0x6FE28E41, 0xFF2A3E51, 0x2AA073FC, 0x54F81EA2, 0x7BC8C1F9,
    0xEAA78073, 0x1F117E01, 0xCC48C630, 0x0FB9E0FB, 0x1FCB3B9E, 0x32B6C6D7, 0x350B150B,
    0xF1508D42, 0x6C5910C6, 0x4A2B9FE5, 0xEAFE3CD9, 0x28FF3F51, 0xEEDC8D54, 0x8F607AC8,
    0x8CF2945F, 0x4459943F, 0xC4460ABD, 0x504C8EC5, 0x9E428F0A, 0xF227388D, 0x0E8E8B1D,
    0x6631BC6B, 0x8EE8DC4D, 0xF59CC617, 0x04C4F826, 0x3C1788DE, 0x40D67CCF, 0x2E2FF674,
    0x63BC5B3A, 0x2B0F59A9, 0x1037DCDF, 0x2C2CFF77, 0xBF8FE9BF, 0x53C15519, 0xF8A96FE1,
    0x1FEFE2B3, 0x7A8AA88B, 0x0F2FD702, 0x8144F13C, 0x5DFC02A5, 0x780F1FE0, 0x3F73C156,
    0x4BE3110D, 0xF7BDEF70, 0xB8200BDE, 0xF8FBDEF7, 0x8174F580, 0xF2059FA7, 0xD7103E37,
    0x25F1BE01, 0xC40B7AE8, 0x7BDEF7D2, 0xDF900007, 0xB851D8C4, 0x828C497E, 0x58000034,
    0x62C6E22E, 0xE305FA9C, 0xCDF21A3F, 0x0201D309, 0x24640100, 0x9DA127A8, 0x8E73DC81,
    0x0000001B, 0xF3000000, 0x03D8A84B, 0xAA8869F9, 0x01006180, 0x8CC16380, 0xCEAF881B,
    0x0671DE20, 0x2D703B2B, 0xC8480000, 0xC6156408, 0x76B3C6CD, 0x7FEEFE42, 0x4B71EFC1,
    0x79561EF6, 0x631EEFB2, 0xE627CEDF, 0xBAA77632, 0xCF19339E, 0x25FE3079, 0x08309803,
    0xC0918000, 0x60003FD8, 0xF837EB1D, 0xE7FA8A75, 0xB3DF6353, 0x443BAFA2, 0xBC072B4F,
    0x2B00001F, 0xBAEB3C07, 0xA7EDF983, 0x8DF7BEC6, 0x6A295BF6, 0xBF58FA0F, 0xFF630004,
    0xF9EFB580, 0x887AF80D, 0x13C60FFA, 0x34567BBF, 0x2BA2598F, 0x5EFC2E19, 0xFA7FF800,
    0xF00017DE, 0x2FBDE6DF, 0x6002C000, 0xCBFE03FB, 0xEF7BDEEF, 0x0000001D, 0x77E78EF4,
    0xFBF19ECE, 0x22AFDC61, 0x3D0B7BC6, 0xFDEEFC62, 0x318FC455, 0x7BF5176A, 0x81A7E1E2,
    0x80311976, 0x300009CC, 0x93990062, 0x65DA069F, 0x7EA2ED64, 0xCCBF144F, 0x57F7BBF1,
    0xF3CE7F19, 0xBC622AFF, 0x9F3C55FF, 0x9ECE77E7, 0x03FBCDBA, 0x51CE777E, 0x74D54603,
    0x319AB85D, 0xE633C3C7, 0xD1D34740, 0x95AE6F10, 0xEF95806F, 0xF7BC163B, 0xF7B8C466,
    0x7BDE0005, 0xBEF7BCAF, 0x795EF7BC, 0x80017DEF, 0xEF2BDEF7, 0x78002FBD, 0xE00000EF,
    0x1DEF03BD, 0xE8800000, 0xC46EEF7D, 0x36B1835E, 0x77BED66F, 0xDF0CB18F, 0x485B1C60,
    0xFF8EDDC8, 0xAA86303B, 0x0F7CFB98, 0xE227AABE, 0x53E476F9, 0x3BFCEFBF, 0xD72047C7,
    0xE9F32B3F, 0xAE4E1101, 0x1BF9BE7D, 0x15BFF8D3, 0x31B35BCF, 0x2B2BE77F, 0x5F9E248D,
    0x0BF633C7, 0x3AB23386, 0xB1BD76A9, 0xC6FEF7FE, 0x14CF6A98, 0xA7FDB7A3, 0xBD10024F,
    0xC02BD9EF, 0xEE7BDD73, 0x77A785D9, 0xBE7BC60F, 0xE393BF12, 0xE317CE77, 0xF11ACD7B,
    0x53E788AF, 0x15AEFE73, 0xF93DBDEF, 0x9C8973FF, 0x04CF3FAC, 0x9C897200, 0xFACF3FAC,
    0x7BDE2B5D, 0xB3DFF27B, 0xE22BFC46, 0xF19CD4F9, 0xCEFC633B, 0x2F7C62F9, 0x307BFF4F,
    0xE7857CFA, 0xBBDCF7BA, 0xFF7FF30B, 0xFBBF78CB, 0x52F631EB, 0xFEFFDFA6, 0x0F77EB99,
    0x9F31963C, 0xCC1939FF, 0xC87FCC7F, 0xCE1DD1EE, 0xF1E79CF3, 0x0BE6FBE6, 0x9BEF9BC0,
    0x9CF3CE2F, 0x47BB21E7, 0xBDEEFC77, 0x00FBDEF7, 0xEF7BDDF8, 0xF7BC006D, 0xA2001BDE,
    0x057B3DF7, 0xCF7BAE78, 0xF4F0BB3D, 0xCF78C1EE, 0xF277E257, 0xE5F9EF7F, 0x1AEF5EF8,
    0x9CD47510, 0x3BDF47F5, 0x89CEFF93, 0xCF3577BE, 0x13900802, 0xF1F3EF7D, 0xFE01DFAC,
    0x359EFF83, 0xC6735040, 0x317FE4EF, 0x9E5EF8EF, 0xEF183DBE, 0x76CF0AF9, 0x1767B9EF,
    0xBDEF7BFF, 0xE9D9F437, 0xFB8E3159, 0xB8123DDC, 0x9F23DDCF, 0xB8C2E315, 0x0000000F,
    0xBEDDEF70, 0xEE00FF7B, 0xEF77DBBD, 0x8C00001F, 0xEF77E0FB, 0x05DEF7BD, 0xFFDFFCC0,
    0xBF94DEA3, 0x50EDCF30, 0x066F8C6F, 0x74BDFFF3, 0xC5678B7F, 0xB005DEEF, 0xA8FFF7FE,
    0xB3C5F94E, 0xC6215DEF, 0xEF07577B, 0x04723B7D, 0xF73ED4F1, 0x1A76678D, 0x13FBA85F,
    0xDC567E6F, 0xDC40DEF0, 0x00000017, 0x00300000, 0x69BC0616, 0x77FE30BC, 0xFD53303F,
    0xFBFFD0EB, 0x0005BF1B, 0xFDF20000, 0xB1877BDF, 0x401B8267, 0x2402400C, 0x1B800C40,
    0x0267B180, 0x04EFFEF9, 0x00000000, 0xFE8279E6, 0xC7FABF0F, 0x7DF7E1B8, 0xCEFBF311,
    0xB4E8C4FB, 0xE6000017, 0xF9A7FEFF, 0x7E77EDF6, 0x3FC678F5, 0x6B09CD60, 0x8CF1EBFE,
    0xF6FB7CFF, 0x7E5EFD3B, 0xF47AF42F, 0x2FE6307A, 0x7A25FCC7, 0x000E3D1C, 0x38F471E8,
    0x31CBF98C, 0x47AF497F, 0xDE7887AF, 0x337F600D, 0x339837C0, 0xF7E4ACC1, 0x00EE884E,
    0x3004CFD0, 0xE7700356, 0x5603F3C8, 0xF7E037B4, 0x39ADB78F, 0xE4F3DF80, 0x7AA8167B,
    0xFBC01E9D, 0xADEF1CE6, 0x017393FA, 0xBDE63F90, 0xCF1FEAB7, 0xDFD801BB, 0xCC06F80C,
    0xE12B3099, 0x77444EF7, 0x04CFD000, 0xC006AC60, 0xEFFE639D, 0xBA2B01FF, 0xE0BF94DE,
    0x9E66DFB7, 0xE7BF01DB, 0x6F8C6F51, 0xCC2F5506, 0x7DE2F7FF, 0x42DFDD13, 0xC56785CE,
    0x7F25DEEF, 0xFEFB5000, 0x86F88017, 0xC0DF01EC, 0x6267EFBB, 0xDE6B1256, 0xEE8879EF,
    0x9FA0CC00, 0xEEEB5C89, 0xA0D58D31, 0x774B77FF, 0xF93F3C8E, 0x4567ECA5, 0xFFCF037B,
    0x6DBC57FE, 0x7BF001CD, 0x02CF7C9E, 0x0F4EBD54, 0x39CDF780, 0x87F55BDE, 0xF2000B9C,
    0x56F7BCC7, 0x099CF1FD, 0x04CE7800, 0x03DF8C00, 0xFC40353C, 0x7F2F8162, 0x0FBD6F01,
    0x2827398C, 0xEF18007F, 0x9DE53748, 0xFBFF519E, 0x67FC351F, 0xF883F5C8, 0xC710049F,
    0x0CFC6001, 0x003D9E00, 0xF0017758, 0x1C8C00F9, 0x9C5F0059, 0x4F588038, 0xE2B00556,
    0x2F813138, 0x181F951E, 0x01C9E163, 0x7CFC7F3F, 0xBDEEFD30, 0x8013C2DB, 0x7BBF1C98,
    0x9F3FBDEF, 0xC6A051AC, 0xF00F8F18, 0x7F7501FA, 0x0FCDE200, 0x001B8AC0, 0xD6004EE6,
    0x3E7C005D, 0x16472300, 0x0E2717C0, 0x5593D620, 0x4E38AC01, 0x478BE04C, 0x58C607E5,
    0xCFC07278, 0x4C1F3F1F, 0xB6EF7BBF, 0x262004F0, 0x7BDEEFC7, 0x6B27CFEF, 0xC631A814,
    0x7EBC03E3, 0xC00FDE60, 0x403EBB7C, 0xCDFAD7FC, 0x3DAFC401, 0xBBAC007B, 0x007CF800,
    0x802C8E46, 0x401C4E2F, 0x02AB27AC, 0x989C7158, 0xCA8F17C0, 0xF0B18C0F, 0x3F9F80E4,
    0x7E983E7E, 0xE16DDEF7, 0x8E4C4009, 0xDEF7BDDF, 0x28D64F9F, 0xC78C6350, 0x00FD7807,
    0xE9F63004, 0xD6F02E78, 0x03F7FB39, 0xE7FF36BE, 0x01775801, 0x8C00F9F0, 0x5F00591C,
    0x5880389C, 0xB005564F, 0x813138E2, 0x1F951E2F, 0xC9E16318, 0xFC7F3F01, 0xEEFD307C,
    0x13C2DBBD, 0xBF1C9880, 0x3FBDEF7B, 0xA051AC9F, 0x0F8F18C6, 0xFF61FAF0, 0x000093E9,
    0x24FA7FD8, 0x800BBAC0, 0xE46007CF, 0xE2F802C8, 0x7AC401C4, 0x15802AB2, 0x7C0989C7,
    0xC0FCA8F1, 0x0E4F0B18, 0xE7E3F9F8, 0xEF77E983, 0x009E16DD, 0xDDF8E4C4, 0xF9FDEF7B,
    0x35028D64, 0x807C78C6, 0xF7E20FD7, 0xFBBC00FF, 0x0000139F, 0x139FFBBC, 0x0FFF7E20,
    0x00177580, 0xC8C00F9F, 0xC5F00591, 0xF5880389, 0x2B005564, 0xF813138E, 0x81F951E2,
    0x1C9E1631, 0xCFC7F3F0, 0xDEEFD307, 0x013C2DBB, 0xBBF1C988, 0xF3FBDEF7, 0x6A051AC9,
    0x00F8F18C, 0x7D801FAF, 0xDEF7BDEF, 0x46B003FB, 0x3BC40000, 0x7BDEF71E, 0x17E00FEF,
    0xF5000097, 0x0000233C, 0x0001B46F, 0xE7137CAC, 0x902F7BDE, 0x000E2E6F, 0xBEC1A378,
    0x9E0BDEF7, 0xDB7BDDF2, 0x0001A004, 0xBDEEB378, 0xC0067EF7, 0xDE01F198, 0xF7BDEF7B,
    0x09807571, 0xCF7DE880, 0x35EE426F, 0x4E1FBD44, 0x37F7BED6, 0xF519E99E, 0xB3F5D41B,
    0xF4E6305D, 0x27F78078, 0x08000004, 0x00F1E001, 0x4176CFEF, 0xF519E5CE, 0x38F8EA0D,
    0x7F7BECF9, 0x5EE499E3, 0x20FBEA29, 0x3F46BFFA, 0x07FABF00, 0xE001B8C0, 0xF1017DF7,
    0x71C4093F, 0x0067E300, 0xB9E03D9E, 0xEF7BDEF7, 0xEFA0017D, 0x17DEF7BD, 0xA0000000,
    0xFEF7BDEF, 0x7BDF4000, 0x0001FDEF, 0x7BE80000, 0x07F7BDEF, 0x03FBA800, 0x580FCDE2,
    0x3B980371, 0xEF7BDCF1, 0x00BEF7BD, 0x7BDEF7D0, 0x00000BEF, 0xDEF7D000, 0xA0007F7B,
    0xFEF7BDEF, 0x00000000, 0xDEF7BDF4, 0xF30003FB, 0xBB7CC07E, 0x5AFF883E, 0xBF1039BF,
    0x73C1ECF6, 0xDEF7BDEF, 0xDF4002FB, 0x2FBDEF7B, 0x40000000, 0xFDEF7BDF, 0xF7BE8001,
    0x0003FBDE, 0xF7D00000, 0x0FEF7BDE, 0x3E9FF600, 0x9FF60009, 0xF7B9E93E, 0x7DEF7BDE,
    0xBDEFA001, 0x0017DEF7, 0xEFA00000, 0x00FEF7BD, 0xEF7BDF40, 0x000001FD, 0xEF7BE800,
    0x4007F7BD, 0xE38A4FFC, 0xCF067E30, 0x02FB8C1E, 0x00000000, 0xA0000000, 0xF3788FEE,
    0xE60DC563, 0x017DC64E, 0x00000000, 0x00000000, 0x87EF3000, 0xE27D76F9, 0x8E6FD6BF,
    0x0F67B5F8, 0x00017DC6, 0x00000000, 0x00000000, 0xD3FEC000, 0x4FFB0127, 0x0BEE349F,
    0x00000000, 0x00000000, 0x88000000, 0xBBBDEF7B, 0xEEB18003, 0xDDEF7900, 0x3001FE33,
    0x60068EDE, 0x454002C5, 0xFBDE47BE, 0xF0000862, 0x8BEF791E, 0x48A80021, 0x600B1D00,
    0xF21A2B7C, 0xF89FBBDE, 0xDF462007, 0xB1804001, 0xC173C74F, 0xDFECE75B, 0xFE6D7C0F,
    0x3F7583CF, 0xA787DD60, 0x8006F000, 0x6F003F91, 0x8DE0053D, 0xCDF20037, 0x9E35801F,
    0x05E27002, 0x00BE6F90, 0xC01B98D6, 0x2F900289, 0xF880D600, 0xE388049F, 0x033F1800,
    0xC007B3C0, 0x26FCF7DA, 0xA887BFC4, 0x6B2F87F7, 0x6ACBFBDF, 0xA837E355, 0x5EFE331D,
    0x152A3310, 0x005397F0, 0x298001D3, 0x02A4E980, 0x05EFF2FE, 0xC6AAA331, 0x98FF506F,
    0xEFB51BE1, 0x626A8DFD, 0xFEF510F7, 0x00FEEA00, 0x600FCDE2, 0xB9800DC5, 0x3DF6B013,
    0xEFF109BF, 0xE1FDEA21, 0xFEF7DACB, 0xF8D55AB2, 0x8CC76A0D, 0x8CC417BF, 0xE5FC054A,
    0x0074C014, 0x3A600A60, 0xFCBF80A9, 0xA8CC417B, 0xD41BF1AA, 0x46F8663F, 0xA37F7BED,
    0x443DD89A, 0xDE603FBD, 0x5DBE600F, 0xB5FF101F, 0xF880737E, 0x600F67B5, 0x137E7BED,
    0xD443DFE2, 0xB597C3FB, 0xB565FDEF, 0xD41BF1AA, 0x2F7F198E, 0x0A951988, 0x8029CBF8,
    0x14C000E9, 0x015274C0, 0x82F7F97F, 0xE3555198, 0xCC7FA837, 0xF7DA8DF0, 0xB13546FE,
    0x7F7A887B, 0xFB180400, 0xBC173C74, 0xFDFECE75, 0xFFE6D7C0, 0xF7DAC03C, 0xBFC426FC,
    0x87F7A887, 0xFBDF6B2F, 0xE3556ACB, 0x331DA837, 0x33105EFE, 0x97F0152A, 0x01D30053,
    0xE9802980, 0xF2FE02A4, 0xA33105EF, 0x506FC6AA, 0x1BE198FF, 0x8DFDEFB5, 0x10F7626A,
    0xFEC0FEF5, 0x000127D3, 0x127D3FEC, 0x6FCF7DAC, 0x887BFC42, 0xB2F87F7A, 0xACBFBDF6,
    0x837E3556, 0xEFE331DA, 0x52A33105, 0x05397F01, 0x98001D30, 0x2A4E9802, 0x5EFF2FE0,
    0x6AAA3310, 0x8FF506FC, 0xFB51BE19, 0x26A8DFDE, 0xEF510F76, 0x7F21B30F, 0x389ABFE1,
    0x6B57E3CF, 0x8AFC7FC5, 0xEF1EF55F, 0x267CAF03, 0x84CF91C4, 0xBC7BBC6F, 0x8CF55F93,
    0x7FCB78FF, 0x3CFFE22D, 0xDCC28C00, 0x7F95ECE7, 0x8C4477EC, 0x31BE55DE, 0x9FFEF77E,
    0x17F89F20, 0x8F93E563, 0x3DB3D037, 0x37D6A147, 0x3B78949D, 0x139E8252, 0x25F31A52,
    0x37DD31E5, 0xDA71E729, 0xCE4F3E22, 0xCFF1975A, 0xDF61BD27, 0xB1F8C7BB, 0xF4611DF2,
    0xEE77FE0E, 0xF102F773, 0xE388093F, 0x019F8C00, 0xEF01ECF0, 0x17DC601D, 0x00000000,
    0x00000000, 0x05800000, 0xE2506C70, 0xAC42B589, 0xCFAD97D7, 0x9A6F1D3D, 0xF3C427BF,
    0x1FDD409B, 0x00FCDE20, 0xE6006E2B, 0x00EF784E, 0x0000BEE3, 0x00000000, 0x00000000,
    0x63802C00, 0xAC4F1283, 0xBEBD6215, 0xE9EE7D6C, 0x3DFCD378, 0x04DF9E21, 0xF9807EF3,
    0xFE207D76, 0x80E6FD6B, 0x0F67B5F8, 0xB8C03BDE, 0x0000002F, 0x00000000, 0x00000000,
    0xA0D8E00B, 0x856B13C4, 0x5B2FAF58, 0xDE3A7B9F, 0x884F7F34, 0xFFB137E7, 0xC00049F4,
    0x7927D3FE, 0xBEE300EF, 0x00000000, 0x00000000, 0x2C000000, 0x12836380, 0x6215AC4F,
    0x7D6CBEBD, 0xD378E9EE, 0x9E213DFC, 0xFDD404DF, 0x1F9BC401, 0x001B8AC0, 0x6DF42773,
    0x31BF6FA0, 0xC7466203, 0xCD1D0D1B, 0x1AE495CA, 0x3A3F1D13, 0x999A9E1A, 0xFD68154F,
    0x4F3C606A, 0xD16801CD, 0x00046900, 0x00000000, 0x00BB8C00, 0xDF400000, 0x6007777B,
    0xF7D07FAC, 0x05E35DDE, 0x801E2FC6, 0x81230091, 0xEFA28BF1, 0x0346BBBD, 0xBE83FD63,
    0x000EEEF7, 0xBDDCF788, 0xD1867FC0, 0xFFC6350B, 0xF6C3F17E, 0x8409E7A6, 0xBC016789,
    0xD66202F1, 0x66200000, 0xD6BBC035, 0xE7BFA00F, 0x079E7803, 0x013D43C6, 0x8BFBDDF5,
    0xD94CCF09, 0x824FFC4D, 0x7E300E38, 0x01ECF006, 0x79EFFEF1, 0x6299DE43, 0xEFA33DFE,
    0xFD6A353D, 0xF90C7117, 0xC8FDEFFE, 0xAC74133D, 0x4B1FBDFF, 0xD5269827, 0xBFBDEF5C,
    0xAE437D41, 0x7F750DBF, 0xC0FCDE20, 0xEE601B8A, 0xF7FF7884, 0x4CEF21BC, 0xD19EFF31,
    0xB51A9EF7, 0x86388BFE, 0x7EF7FF7C, 0x3A099EE4, 0x8FDEFFD6, 0x934C13A5, 0xDEF7AE6A,
    0x21BEA0DF, 0xBCC6DFD7, 0xD76F981F, 0xF5AFF887, 0xB5F8839B, 0xC4000F67, 0x0DE7BFFB,
    0xF98A6779, 0xF7BE8CF7, 0x5FF5A8D4, 0xFBE431C4, 0xF723F7BF, 0xFEB1D04C, 0x9D2C7EF7,
    0x73549A60, 0x06FEF7BD, 0xFEB90DF5, 0xFB182036, 0xB7973C74, 0x1FBFD9CE, 0xF3FF9B5F,
    0xFFDE2000, 0x3BC86F3D, 0x67BFCC53, 0x46A7BDF4, 0x8E22FFAD, 0xBDFFDF21, 0x8267B91F,
    0xF7BFF58E, 0xD304E963, 0xBDEB9AA4, 0x6FA837F7, 0xD9B7F5C8, 0x0024FA7F, 0x093E9FF6,
    0x7BFFBC40, 0xA67790DE, 0xE8CF7F98, 0x5A8D4F7B, 0x431C45FF, 0x3F7BFFBE, 0x1D04CF72,
    0xC7EF7FEB, 0x49A609D2, 0xEF7BD735, 0x90DF506F, 0xBF136FEB, 0xFDDE07FF, 0xDE0009CF,
    0xF109CFFD, 0xEF107FFB, 0xE4379EFF, 0xDFE6299D, 0x53DEFA33, 0x117FD6A3, 0xFFEF90C7,
    0x33DC8FDE, 0xDFFAC741, 0x8274B1FB, 0xF5CD5269, 0xD41BFBDE, 0xDBFAE437, 0xF773BF3C,
    0xFCE77E34, 0x6157D606, 0x22BFDFBC, 0xF3FC5FEA, 0x67CEEF77, 0x69FDEEFC, 0x4A317FBE,
    0x32473517, 0xFA77B9F7, 0x0977BDEE, 0x00008EFD, 0xEF7BBE33, 0xF7BDEFB4, 0x1EB191DE,
    0x86A18050, 0x82BBCB58, 0xFB93C431, 0xB9F4B69E, 0x19BE1F77, 0x3FFEEE72, 0x7E45E721,
    0xDC85EEE7, 0xF1FD184F, 0x8F773CC6, 0x1BC6A2A7, 0xFC7CCDC6, 0x0067FC60, 0x1F8F0008,
    0xA3511AC4, 0x797AF8C3, 0x6BBB9D63, 0x184FDC96, 0x66FC8BEF, 0xEAFC09DE, 0x01B8C01F,
    0x205F7DF8, 0x388127FE, 0x0CFC600E, 0xF007B3C0, 0x12F9EEFC, 0xDCF12BEB, 0xBDF63D90,
    0x339FAF9D, 0xF8F1E358, 0x48EF7BDF, 0xF7111001, 0x8DEF7BDE, 0xBE380519, 0x6A3EF187,
    0x9EEF77C5, 0x51157F49, 0x7F7502DF, 0x01F9BC40, 0x73006E2B, 0xEEFCF027, 0x2BEB12F9,
    0x3D90DCF1, 0xAF9DBDF6, 0xE358339F, 0x7BDFF8F1, 0x100148EF, 0x7BDEF711, 0x05198DEF,
    0xF187BE38, 0x77C56A3E, 0x7F499EEF, 0x82DF5115, 0xBE603F79, 0x7FC41F5D, 0x881CDFAD,
    0x00F67B5F, 0x3DDF9E00, 0x257D625F, 0xC7B21B9E, 0xF5F3B7BE, 0x3C6B0673, 0xEF7BFF1E,
    0x2200291D, 0xEF7BDEE2, 0x00A331BD, 0xDE30F7C7, 0xEEF8AD47, 0xAFE933DD, 0xEC5BEA22,
    0x00127D3F, 0x127D3FEC, 0xF77E7800, 0x95F5897C, 0x1EC86E78, 0xD7CEDEFB, 0xF1AC19CF,
    0xBDEFFC78, 0x8800A477, 0xBDEF7B88, 0x028CC6F7, 0x78C3DF1C, 0xBBE2B51F, 0xBFA4CF77,
    0x896FA88A, 0x1C7149FF, 0xD9E0CFC6, 0x001F7583, 0x00000000, 0x89FDD400, 0x6E2B3F37,
    0xF7593B98, 0x00000001, 0xE6000000, 0xAEDF30FD, 0xFAD7FC4F, 0xF6BF11CD, 0xDD6001EC,
    0x00000007, 0x00000000, 0xE9FF6000, 0xA7FD8093, 0xF758024F, 0x00000001, 0x00000000,
    0x0EFFE000, 0xF739C822, 0x7F24EF37, 0x77DE7AFF, 0x07E53D41, 0xD1EBF7F6, 0x139595F0,
    0x9BF3DF73, 0xA21DFA51, 0xDF15C8CA, 0x1F71FBBD, 0x8AF187BF, 0x58E70163, 0x7BF1F250,
    0xD93C6F98, 0xFAFBDDF1, 0xA88ABF58, 0x6304017F, 0xF2E78E9F, 0xF7FB39D6, 0x7FF36BE3,
    0x9BDE001E, 0x9C2EEE7D, 0xC497C615, 0x1E279EEF, 0xC3AF12DE, 0x00000483, 0x00000000,
    0x0127FE20, 0xF1801C71, 0x3D9E0033, 0xFDFFE880, 0x2BFE2077, 0x3D07FAE5, 0x35FF7FEA,
    0x94BF959A, 0x14465CBF, 0xC0706278, 0x230E0B85, 0xAC31501E, 0x65FCA5FC, 0xF7FEA3D1,
    0xFC47E35F, 0x0FF5CA57, 0x100FEEA0, 0x15807E6F, 0x27730037, 0xFFBFFD10, 0xA57FC40E,
    0x47A0FF5C, 0x46BFEFFD, 0xF297F2B3, 0x0288CB97, 0xB80E0C4F, 0xC461C170, 0x95862A03,
    0x2CBF94BF, 0xFEFFD47A, 0xFF88FC6B, 0x01FEB94A, 0xF300FDE6, 0xFC40FAED, 0x01CDFAD7,
    0x1ECF6BF1, 0xFFE88000, 0xFE2077FD, 0x07FAE52B, 0xFF7FEA3D, 0xBF959A35, 0x465CBF94,
    0x70627814, 0x0E0B85C0, 0x31501E23, 0xFCA5FCAC, 0xFEA3D165, 0x47E35FF7, 0xF5CA57FC,
    0x6301000F, 0xC2E78E9F, 0xDFECE75B, 0xFF36BE0F, 0x440001E7, 0x03BFEFFF, 0xD7295FF1,
    0xFF51E83F, 0xACD1AFFB, 0xE5FCA5FC, 0x13C0A232, 0x5C2E0383, 0x80F11870, 0x2FE5618A,
    0x1E8B2FE5, 0x1AFFBFF5, 0x52BFE23F, 0xFF607FAE, 0x800093E9, 0x024FA7FD, 0xF7FFA200,
    0xAFF881DF, 0xF41FEB94, 0xD7FDFFA8, 0x52FE5668, 0x511972FE, 0x01C189E0, 0x8C382E17,
    0xB0C54078, 0x97F297F2, 0xDFFA8F45, 0xF11F8D7F, 0x3FD7295F, 0x70053AC0, 0x079F4005,
    0xBDEEB000, 0xEF7BDEF7, 0xF7BAC000, 0xBDEF7BDE, 0x4EB00003, 0x80015C01, 0xBFFD0938,
    0xB1257FFF, 0x82B1CA57, 0xAFBFF51E, 0x97F2B1FC, 0x88CB37BE, 0xC4F9AE62, 0xD76E88E0,
    0x5C35E8E4, 0x6AD56231, 0xBF158F1E, 0x13E5F919, 0xFFF7587A, 0x32F88FE4, 0xDF81DAE5,
    0x077FDFF9, 0xFF1001EC, 0x038E2093, 0x3C019F8C, 0x0377E07B, 0x00005F71, 0x00000000,
    0xE3922520, 0xC4F2E30D, 0xF24EEE73, 0x407CF12B, 0x37881FDD, 0x06E2B03F, 0xBBF13B98,
    0x002FB881, 0x00000000, 0xC9129000, 0x797186F1, 0x277739E2, 0x3E7895F9, 0xE607EF30,
    0xFE21F5DB, 0x20E6FD6B, 0x03D9ED7E, 0xC40DDF80, 0x0000017D, 0x80000000, 0x378E4894,
    0xCF13CB8C, 0xAFC93BB9, 0xFF61F3C4, 0xD80093E9, 0x0024FA7F, 0xFB881BBF, 0x00000002,
    0x29000000, 0x186F1C91, 0x739E2797, 0x895F9277, 0xFDD403E7, 0x03F37881, 0xB9806E2B,
    0x71037D93, 0xF2C2CFF7, 0x9BF8FE9B, 0x153C1551, 0x3F8A96FE, 0xB1FEFE2B, 0x27A8AA88,
    0xC0F2FD70, 0x58144F13, 0x05DFC02A, 0x6780F1FE, 0xD3F73C15, 0x84BE3110, 0x00002EE7,
    0xF5800000, 0x6F05FFBF, 0xDF05ECA7, 0xC1BC6FBD, 0x2C6730FB, 0x4B0076C0, 0x6C009600,
    0xCE61F787, 0x7DEEF858, 0x4AE60DE3, 0xFEDC2EF9, 0x0004FFDF, 0xFF600000, 0xD80093E9,
    0x8024FA7F, 0xF771037D, 0x9BF2C2CF, 0x519BF8FE, 0xFE153C15, 0x2B3F8A96, 0x88B1FEFE,
    0x7027A8AA, 0x13C0F2FD, 0x2A58144F, 0xFE05DFC0, 0x156780F1, 0x10D3F73C, 0x0004BE31

  EW_FONT_KERNING_CODES( ResourcesFontMedium )
  EW_FONT_KERNING_VALUES( ResourcesFontMedium )
EW_END_OF_FONT_RES( ResourcesFontMedium )

/* Table with links to derived variants of the font resource : 'Resources::FontMedium' */
EW_RES_WITHOUT_VARIANTS( ResourcesFontMedium )

/* The large version of the default font resource. The resource is using 'Roboto' 
   TrueType font with 36 pixel height. */
EW_DEFINE_FONT_RES( ResourcesFontLarge, 28, 8, 0, 16, 0x0001, 0x00C0 )
  EW_GLYPH( 0x0001, 1, -21, 11, 21, 13, 0x00000000 ),
  EW_GLYPH( 0x0020, 0, 0, 0, 0, 7, 0x00000297 ),                /* ' ' */
  EW_GLYPH( 0x0021, 2, -21, 4, 21, 8, 0x00000297 ),             /* '!' */
  EW_GLYPH( 0x0022, 2, -23, 6, 7, 10, 0x00000340 ),             /* '"' */
  EW_GLYPH( 0x0023, 1, -21, 18, 21, 18, 0x0000039F ),           /* '#' */
  EW_GLYPH( 0x0024, 1, -25, 15, 28, 17, 0x00000718 ),           /* '$' */
  EW_GLYPH( 0x0025, 1, -21, 20, 21, 22, 0x00000B48 ),           /* '%' */
  EW_GLYPH( 0x0026, 1, -21, 18, 21, 19, 0x00000FCB ),           /* '&' */
  EW_GLYPH( 0x0027, 1, -23, 3, 7, 5, 0x000013F0 ),              /* ''' */
  EW_GLYPH( 0x0028, 2, -24, 8, 31, 10, 0x0000141D ),            /* '(' */
  EW_GLYPH( 0x0029, 0, -24, 9, 31, 10, 0x0000165A ),            /* ')' */
  EW_GLYPH( 0x002A, 0, -21, 13, 12, 13, 0x000018BC ),           /* '*' */
  EW_GLYPH( 0x002B, 1, -18, 15, 16, 17, 0x00001A91 ),           /* '+' */
  EW_GLYPH( 0x002C, 0, -3, 5, 7, 6, 0x00001C16 ),               /* ',' */
  EW_GLYPH( 0x002D, 0, -10, 8, 2, 8, 0x00001C7A ),              /* '-' */
  EW_GLYPH( 0x002E, 2, -3, 4, 3, 8, 0x00001CAC ),               /* '.' */
  EW_GLYPH( 0x002F, 0, -21, 12, 23, 12, 0x00001CE9 ),           /* '/' */
  EW_GLYPH( 0x0030, 1, -21, 15, 21, 17, 0x00001F03 ),           /* '0' */
  EW_GLYPH( 0x0031, 2, -21, 9, 21, 17, 0x000021DB ),            /* '1' */
  EW_GLYPH( 0x0032, 1, -21, 15, 21, 17, 0x00002312 ),           /* '2' */
  EW_GLYPH( 0x0033, 1, -21, 14, 21, 17, 0x00002630 ),           /* '3' */
  EW_GLYPH( 0x0034, 0, -21, 17, 21, 17, 0x00002989 ),           /* '4' */
  EW_GLYPH( 0x0035, 2, -21, 14, 21, 17, 0x00002C23 ),           /* '5' */
  EW_GLYPH( 0x0036, 1, -21, 15, 21, 17, 0x00002F32 ),           /* '6' */
  EW_GLYPH( 0x0037, 1, -21, 15, 21, 17, 0x000032A2 ),           /* '7' */
  EW_GLYPH( 0x0038, 1, -21, 15, 21, 17, 0x00003531 ),           /* '8' */
  EW_GLYPH( 0x0039, 1, -21, 14, 21, 17, 0x000038D9 ),           /* '9' */
  EW_GLYPH( 0x003A, 2, -16, 4, 16, 7, 0x00003C21 ),             /* ':' */
  EW_GLYPH( 0x003B, 0, -16, 6, 20, 6, 0x00003CD4 ),             /* ';' */
  EW_GLYPH( 0x003C, 1, -16, 12, 13, 15, 0x00003DCF ),           /* '<' */
  EW_GLYPH( 0x003D, 2, -14, 13, 8, 16, 0x00003FC0 ),            /* '=' */
  EW_GLYPH( 0x003E, 2, -16, 13, 13, 16, 0x000040CA ),           /* '>' */
  EW_GLYPH( 0x003F, 1, -21, 12, 21, 14, 0x000042E7 ),           /* '?' */
  EW_GLYPH( 0x0040, 1, -21, 25, 27, 27, 0x0000455C ),           /* '@' */
  EW_GLYPH( 0x0041, 0, -21, 20, 21, 20, 0x00004CB2 ),           /* 'A' */
  EW_GLYPH( 0x0042, 2, -21, 15, 21, 19, 0x0000502F ),           /* 'B' */
  EW_GLYPH( 0x0043, 1, -21, 18, 21, 20, 0x0000531D ),           /* 'C' */
  EW_GLYPH( 0x0044, 2, -21, 16, 21, 20, 0x000056B1 ),           /* 'D' */
  EW_GLYPH( 0x0045, 2, -21, 14, 21, 17, 0x0000596B ),           /* 'E' */
  EW_GLYPH( 0x0046, 2, -21, 14, 21, 17, 0x00005B75 ),           /* 'F' */
  EW_GLYPH( 0x0047, 1, -21, 18, 21, 20, 0x00005D53 ),           /* 'G' */
  EW_GLYPH( 0x0048, 2, -21, 17, 21, 21, 0x000060F7 ),           /* 'H' */
  EW_GLYPH( 0x0049, 2, -21, 4, 21, 8, 0x000062D2 ),             /* 'I' */
  EW_GLYPH( 0x004A, 0, -21, 15, 21, 17, 0x00006337 ),           /* 'J' */
  EW_GLYPH( 0x004B, 2, -21, 17, 21, 19, 0x00006546 ),           /* 'K' */
  EW_GLYPH( 0x004C, 2, -21, 14, 21, 16, 0x00006850 ),           /* 'L' */
  EW_GLYPH( 0x004D, 2, -21, 22, 21, 26, 0x000069B3 ),           /* 'M' */
  EW_GLYPH( 0x004E, 2, -21, 17, 21, 21, 0x00006D3B ),           /* 'N' */
  EW_GLYPH( 0x004F, 1, -21, 18, 21, 21, 0x00006F9E ),           /* 'O' */
  EW_GLYPH( 0x0050, 2, -21, 16, 21, 19, 0x0000732F ),           /* 'P' */
  EW_GLYPH( 0x0051, 1, -21, 18, 25, 21, 0x000075B7 ),           /* 'Q' */
  EW_GLYPH( 0x0052, 2, -21, 16, 21, 18, 0x000079F0 ),           /* 'R' */
  EW_GLYPH( 0x0053, 1, -21, 16, 21, 18, 0x00007CBC ),           /* 'S' */
  EW_GLYPH( 0x0054, 0, -21, 18, 21, 18, 0x000080B0 ),           /* 'T' */
  EW_GLYPH( 0x0055, 1, -21, 17, 21, 19, 0x000082B2 ),           /* 'U' */
  EW_GLYPH( 0x0056, 0, -21, 19, 21, 19, 0x000084FE ),           /* 'V' */
  EW_GLYPH( 0x0057, 0, -21, 26, 21, 27, 0x0000884C ),           /* 'W' */
  EW_GLYPH( 0x0058, 0, -21, 18, 21, 19, 0x00008CF6 ),           /* 'X' */
  EW_GLYPH( 0x0059, 0, -21, 18, 21, 18, 0x0000908D ),           /* 'Y' */
  EW_GLYPH( 0x005A, 1, -21, 16, 21, 18, 0x00009343 ),           /* 'Z' */
  EW_GLYPH( 0x005B, 2, -24, 6, 29, 8, 0x00009632 ),             /* '[' */
  EW_GLYPH( 0x005C, 0, -21, 13, 23, 12, 0x0000971B ),           /* '\' */
  EW_GLYPH( 0x005D, 0, -24, 6, 29, 8, 0x00009953 ),             /* ']' */
  EW_GLYPH( 0x005E, 1, -21, 11, 10, 13, 0x00009A38 ),           /* '^' */
  EW_GLYPH( 0x005F, 0, 0, 14, 2, 14, 0x00009B6B ),              /* '_' */
  EW_GLYPH( 0x0060, 0, -22, 7, 4, 9, 0x00009BBF ),              /* '`' */
  EW_GLYPH( 0x0061, 1, -16, 14, 16, 16, 0x00009C1C ),           /* 'a' */
  EW_GLYPH( 0x0062, 2, -23, 14, 23, 17, 0x00009EBE ),           /* 'b' */
  EW_GLYPH( 0x0063, 1, -16, 14, 16, 16, 0x0000A155 ),           /* 'c' */
  EW_GLYPH( 0x0064, 1, -23, 14, 23, 17, 0x0000A3D9 ),           /* 'd' */
  EW_GLYPH( 0x0065, 1, -16, 14, 16, 16, 0x0000A67C ),           /* 'e' */
  EW_GLYPH( 0x0066, 0, -23, 11, 23, 10, 0x0000A933 ),           /* 'f' */
  EW_GLYPH( 0x0067, 1, -16, 14, 22, 17, 0x0000AAD9 ),           /* 'g' */
  EW_GLYPH( 0x0068, 2, -23, 13, 23, 17, 0x0000AE2C ),           /* 'h' */
  EW_GLYPH( 0x0069, 2, -22, 4, 22, 7, 0x0000AFF7 ),             /* 'i' */
  EW_GLYPH( 0x006A, -1, -22, 6, 28, 7, 0x0000B092 ),            /* 'j' */
  EW_GLYPH( 0x006B, 2, -23, 14, 23, 15, 0x0000B1AF ),           /* 'k' */
  EW_GLYPH( 0x006C, 2, -23, 3, 23, 7, 0x0000B427 ),             /* 'l' */
  EW_GLYPH( 0x006D, 1, -16, 24, 16, 26, 0x0000B47A ),           /* 'm' */
  EW_GLYPH( 0x006E, 2, -16, 13, 16, 17, 0x0000B72C ),           /* 'n' */
  EW_GLYPH( 0x006F, 1, -16, 15, 16, 17, 0x0000B8A5 ),           /* 'o' */
  EW_GLYPH( 0x0070, 2, -16, 14, 22, 17, 0x0000BB46 ),           /* 'p' */
  EW_GLYPH( 0x0071, 1, -16, 14, 22, 17, 0x0000BDF8 ),           /* 'q' */
  EW_GLYPH( 0x0072, 2, -16, 8, 16, 10, 0x0000C0A3 ),            /* 'r' */
  EW_GLYPH( 0x0073, 1, -16, 13, 16, 15, 0x0000C180 ),           /* 's' */
  EW_GLYPH( 0x0074, 0, -20, 9, 20, 10, 0x0000C44C ),            /* 't' */
  EW_GLYPH( 0x0075, 2, -16, 13, 16, 17, 0x0000C58E ),           /* 'u' */
  EW_GLYPH( 0x0076, 0, -16, 15, 16, 15, 0x0000C6F1 ),           /* 'v' */
  EW_GLYPH( 0x0077, 0, -16, 23, 16, 23, 0x0000C91D ),           /* 'w' */
  EW_GLYPH( 0x0078, 0, -16, 15, 16, 15, 0x0000CC9F ),           /* 'x' */
  EW_GLYPH( 0x0079, 0, -16, 14, 22, 14, 0x0000CF00 ),           /* 'y' */
  EW_GLYPH( 0x007A, 1, -16, 13, 16, 15, 0x0000D1D7 ),           /* 'z' */
  EW_GLYPH( 0x007B, 0, -23, 10, 28, 10, 0x0000D3E7 ),           /* '{' */
  EW_GLYPH( 0x007C, 2, -21, 3, 25, 7, 0x0000D629 ),             /* '|' */
  EW_GLYPH( 0x007D, 0, -23, 10, 28, 10, 0x0000D682 ),           /* '}' */
  EW_GLYPH( 0x007E, 1, -12, 18, 5, 20, 0x0000D8B7 ),            /* '~' */
  EW_GLYPH( 0x00A0, 0, 0, 0, 0, 7, 0x0000DA04 ),
  EW_GLYPH( 0x00A1, 1, -16, 5, 21, 7, 0x0000DA04 ),
  EW_GLYPH( 0x00A2, 1, -20, 14, 24, 16, 0x0000DABC ),
  EW_GLYPH( 0x00A3, 1, -21, 16, 21, 17, 0x0000DDD3 ),
  EW_GLYPH( 0x00A4, 1, -19, 19, 20, 21, 0x0000E0A5 ),
  EW_GLYPH( 0x00A5, 0, -21, 18, 21, 18, 0x0000E508 ),
  EW_GLYPH( 0x00A6, 2, -21, 3, 25, 7, 0x0000E850 ),
  EW_GLYPH( 0x00A7, 1, -21, 16, 28, 18, 0x0000E8CB ),
  EW_GLYPH( 0x00A8, 1, -22, 10, 3, 13, 0x0000EE33 ),
  EW_GLYPH( 0x00A9, 1, -21, 22, 21, 24, 0x0000EEA3 ),
  EW_GLYPH( 0x00AA, 1, -21, 11, 11, 13, 0x0000F48D ),
  EW_GLYPH( 0x00AB, 1, -14, 12, 12, 14, 0x0000F625 ),
  EW_GLYPH( 0x00AC, 1, -12, 13, 6, 17, 0x0000F813 ),
  EW_GLYPH( 0x00AD, 0, -10, 8, 2, 8, 0x0000F8BE ),
  EW_GLYPH( 0x00AE, 1, -21, 22, 21, 24, 0x0000F8F0 ),
  EW_GLYPH( 0x00AF, 1, -21, 12, 2, 14, 0x0000FE56 ),
  EW_GLYPH( 0x00B0, 1, -21, 9, 8, 11, 0x0000FE9E ),
  EW_GLYPH( 0x00B1, 1, -19, 14, 19, 16, 0x0000FFA3 ),
  EW_GLYPH( 0x00B2, 1, -21, 9, 12, 11, 0x0001016B ),
  EW_GLYPH( 0x00B3, 0, -21, 10, 12, 11, 0x000102ED ),
  EW_GLYPH( 0x00B4, 1, -22, 7, 4, 9, 0x000104A7 ),
  EW_GLYPH( 0x00B5, 2, -16, 13, 22, 17, 0x00010506 ),
  EW_GLYPH( 0x00B6, 1, -21, 12, 21, 15, 0x000106CE ),
  EW_GLYPH( 0x00B7, 2, -12, 4, 3, 8, 0x0001087A ),
  EW_GLYPH( 0x00B8, 1, 0, 5, 6, 7, 0x000108B7 ),
  EW_GLYPH( 0x00B9, 1, -21, 7, 12, 11, 0x0001092A ),
  EW_GLYPH( 0x00BA, 2, -21, 10, 11, 14, 0x000109CF ),
  EW_GLYPH( 0x00BB, 1, -14, 12, 12, 14, 0x00010B31 ),
  EW_GLYPH( 0x00BC, 0, -21, 22, 21, 22, 0x00010D19 ),
  EW_GLYPH( 0x00BD, 0, -21, 22, 21, 23, 0x000110E9 ),
  EW_GLYPH( 0x00BE, 1, -21, 22, 21, 23, 0x00011521 ),
  EW_GLYPH( 0x00BF, 0, -16, 13, 22, 14, 0x000119F3 ),
  EW_GLYPH( 0x00C0, 0, -27, 20, 27, 20, 0x00011C8F ),
  EW_GLYPH( 0x00C1, 0, -27, 20, 27, 20, 0x000120D3 ),
  EW_GLYPH( 0x00C2, 0, -27, 20, 27, 20, 0x0001251A ),
  EW_GLYPH( 0x00C3, 0, -27, 20, 27, 20, 0x0001299A ),
  EW_GLYPH( 0x00C4, 0, -26, 20, 26, 20, 0x00012E3D ),
  EW_GLYPH( 0x00C5, 0, -29, 20, 29, 20, 0x0001328D ),
  EW_GLYPH( 0x00C6, -1, -21, 29, 21, 28, 0x00013740 ),
  EW_GLYPH( 0x00C7, 1, -21, 18, 27, 20, 0x00013BEB ),
  EW_GLYPH( 0x00C8, 2, -27, 14, 27, 17, 0x00014050 ),
  EW_GLYPH( 0x00C9, 2, -27, 14, 27, 17, 0x000142FD ),
  EW_GLYPH( 0x00CA, 2, -27, 14, 27, 17, 0x000145AD ),
  EW_GLYPH( 0x00CB, 2, -26, 14, 26, 17, 0x00014896 ),
  EW_GLYPH( 0x00CC, -1, -27, 7, 27, 8, 0x00014B55 ),
  EW_GLYPH( 0x00CD, 2, -27, 7, 27, 8, 0x00014C72 ),
  EW_GLYPH( 0x00CE, -1, -27, 10, 27, 8, 0x00014D92 ),
  EW_GLYPH( 0x00CF, -1, -26, 10, 26, 8, 0x00014F3C ),
  EW_GLYPH( 0x00D0, 0, -21, 19, 21, 20, 0x000150C0 ),
  EW_GLYPH( 0x00D1, 2, -27, 17, 27, 21, 0x000153ED ),
  EW_GLYPH( 0x00D2, 1, -27, 18, 27, 21, 0x00015764 ),
  EW_GLYPH( 0x00D3, 1, -27, 18, 27, 21, 0x00015BB0 ),
  EW_GLYPH( 0x00D4, 1, -27, 18, 27, 21, 0x00015FFF ),
  EW_GLYPH( 0x00D5, 1, -27, 18, 27, 21, 0x00016487 ),
  EW_GLYPH( 0x00D6, 1, -26, 18, 26, 21, 0x00016932 ),
  EW_GLYPH( 0x00D7, 1, -16, 14, 13, 16, 0x00016D8C ),
  EW_GLYPH( 0x00D8, 1, -22, 19, 24, 21, 0x00016FCE ),
  EW_GLYPH( 0x00D9, 1, -27, 17, 27, 19, 0x0001749B ),
  EW_GLYPH( 0x00DA, 1, -27, 17, 27, 19, 0x0001779C ),
  EW_GLYPH( 0x00DB, 1, -27, 17, 27, 19, 0x00017AA0 ),
  EW_GLYPH( 0x00DC, 1, -26, 17, 26, 19, 0x00017DDD ),
  EW_GLYPH( 0x00DD, 0, -27, 18, 27, 18, 0x000180ED ),
  EW_GLYPH( 0x00DE, 2, -21, 15, 21, 18, 0x00018461 ),
  EW_GLYPH( 0x00DF, 2, -23, 15, 23, 18, 0x000186C5 ),
  EW_GLYPH( 0x00E0, 1, -22, 14, 22, 16, 0x000189DC ),
  EW_GLYPH( 0x00E1, 1, -22, 14, 22, 16, 0x00018D21 ),
  EW_GLYPH( 0x00E2, 1, -22, 14, 22, 16, 0x00019069 ),
  EW_GLYPH( 0x00E3, 1, -22, 14, 22, 16, 0x000193EA ),
  EW_GLYPH( 0x00E4, 1, -21, 14, 21, 16, 0x0001978E ),
  EW_GLYPH( 0x00E5, 1, -24, 14, 24, 16, 0x00019AE5 ),
  EW_GLYPH( 0x00E6, 1, -16, 24, 16, 25, 0x00019E8D ),
  EW_GLYPH( 0x00E7, 1, -16, 14, 22, 16, 0x0001A343 ),
  EW_GLYPH( 0x00E8, 1, -22, 14, 22, 16, 0x0001A67B ),
  EW_GLYPH( 0x00E9, 1, -22, 14, 22, 16, 0x0001A9D5 ),
  EW_GLYPH( 0x00EA, 1, -22, 14, 22, 16, 0x0001AD32 ),
  EW_GLYPH( 0x00EB, 1, -21, 14, 21, 16, 0x0001B0C8 ),
  EW_GLYPH( 0x00EC, -2, -22, 7, 22, 7, 0x0001B434 ),
  EW_GLYPH( 0x00ED, 1, -22, 7, 22, 7, 0x0001B52B ),
  EW_GLYPH( 0x00EE, -1, -22, 10, 22, 7, 0x0001B625 ),
  EW_GLYPH( 0x00EF, -1, -21, 10, 21, 7, 0x0001B79A ),
  EW_GLYPH( 0x00F0, 2, -23, 14, 23, 18, 0x0001B8E9 ),
  EW_GLYPH( 0x00F1, 2, -22, 13, 22, 17, 0x0001BCB1 ),
  EW_GLYPH( 0x00F2, 1, -22, 15, 22, 17, 0x0001BF26 ),
  EW_GLYPH( 0x00F3, 1, -22, 15, 22, 17, 0x0001C270 ),
  EW_GLYPH( 0x00F4, 1, -22, 15, 22, 17, 0x0001C5BD ),
  EW_GLYPH( 0x00F5, 1, -22, 15, 22, 17, 0x0001C943 ),
  EW_GLYPH( 0x00F6, 1, -21, 15, 21, 17, 0x0001CCEC ),
  EW_GLYPH( 0x00F7, 1, -17, 15, 14, 17, 0x0001D047 ),
  EW_GLYPH( 0x00F8, 1, -18, 15, 20, 17, 0x0001D1F2 ),
  EW_GLYPH( 0x00F9, 2, -22, 13, 22, 17, 0x0001D575 ),
  EW_GLYPH( 0x00FA, 2, -22, 13, 22, 17, 0x0001D775 ),
  EW_GLYPH( 0x00FB, 2, -22, 13, 22, 17, 0x0001D978 ),
  EW_GLYPH( 0x00FC, 2, -21, 13, 21, 17, 0x0001DBB4 ),
  EW_GLYPH( 0x00FD, 0, -22, 14, 28, 14, 0x0001DDC7 ),
  EW_GLYPH( 0x00FE, 2, -23, 14, 29, 17, 0x0001E144 ),
  EW_GLYPH( 0x00FF, 0, -21, 14, 27, 14, 0x0001E459 ),

  EW_FONT_PIXEL( ResourcesFontLarge, 0x0001E7E5 )               /* ratio 57.09 % */
    0xBDEF7BBF, 0x33FBDEF7, 0xDEF7BDEE, 0xCC07A83B, 0x7F80EF8F, 0xED40C631, 0x9DC5EF81,
    0x0118D290, 0x01F7CFDE, 0xC048E463, 0x39801EFF, 0x028E600A, 0x1803DFF8, 0xEF024723,
    0x4A40FBE7, 0x2F7C0463, 0x0318C4EE, 0x01DF07B5, 0x301EA2FF, 0xF7BDC63F, 0x75877BDE,
    0x000000EF, 0x00024240, 0x037B9E00, 0xFC7FCEA0, 0x591FEB23, 0x017B86F7, 0x02189082,
    0x0C4842D3, 0xFF03BEC0, 0x4186009B, 0x30C02464, 0x8F0048F0, 0x6003C307, 0x00BBF8BB,
    0x03CB07A6, 0xC3BDEF71, 0x7DA6F7BE, 0x2000006F, 0x79AFBDEE, 0xDEF36DEF, 0xF8BB601B,
    0x07A600BB, 0xC46003CB, 0xC0063220, 0x18247890, 0xDC6DDEF7, 0xBDC67F7B, 0xC6000017,
    0xF7D877BD, 0xBDEFB4DE, 0x8C8830C0, 0x3C0C3001, 0x6263C012, 0x1B5C0078, 0xE3C0177F,
    0x4000F4C1, 0xB500018C, 0x0000000F, 0xFDFCC000, 0xF100EEE4, 0x6B182B7B, 0xF595F80F,
    0x0F23A7BF, 0x8A7663C6, 0xF145CAF5, 0x207E1581, 0x04824781, 0x068A0E46, 0x9467FFFA,
    0x6F8002FA, 0x003BEE78, 0xDCC47762, 0xCEB005FF, 0x2FFD9157, 0x5777E780, 0x440037E4,
    0x5CAE23FF, 0x8CB1812B, 0x3805DD5C, 0x2E02E2C4, 0x104AC391, 0xF716A653, 0xF0ECF109,
    0xEFC8DEA3, 0x9EA5F3DC, 0x8C0D7B98, 0x7B205FF9, 0x09BF734F, 0xEA700000, 0x9CEFD400,
    0xF30000DF, 0x2FF51157, 0x7BEB4400, 0x3DF83466, 0xBC4B5150, 0x1B5D1239, 0x8C14C252,
    0xC0002F99, 0x84A4178D, 0x14F1AC29, 0x3A25A8A8, 0x1FCDF333, 0x59EFAD10, 0x03A37AF1,
    0x51157F30, 0x3CF59AFF, 0xCE77EA00, 0x0FC7446F, 0x8E8BE000, 0x13DDCEF8, 0x733553C0,
    0x2FBC613F, 0xEAF17E20, 0x317F73AC, 0xA745F80B, 0x6D7A85F2, 0x2298CF50, 0x37805204,
    0x9BC0000E, 0x9021126F, 0x282D7602, 0x86D7AA5F, 0xEB3A07E7, 0x0B317F7F, 0x1867B900,
    0xCEFA82FD, 0x6000DF3D, 0xCF109EFD, 0x8DA3009E, 0x4DE5FF7D, 0xF21DC7C0, 0x32403E17,
    0x20000860, 0x266C01D3, 0xCC04C471, 0xC47B51D4, 0x8AF1003F, 0x0FFCCBFB, 0xF308F500,
    0x07E8003F, 0xAA5BF000, 0xFDF885CC, 0x7E796F06, 0xB21FA1BF, 0xE3EA9C8A, 0x21E57E9F,
    0x22711715, 0x10CBFCBE, 0xC45F182C, 0x04C91F2D, 0x2A2E52D5, 0x264AC0BC, 0x117635E2,
    0x58D52773, 0xEF77E31D, 0xB2DE3379, 0x46BDAC1E, 0xBF3BEA88, 0xFEEB1BF0, 0x02038240,
    0xCDF80778, 0xBC6AFC1F, 0x20FF9558, 0xA3781D5F, 0xE1728C1E, 0x03CB0593, 0x1E0C3615,
    0x6980CBF8, 0x04840482, 0x41210000, 0xFE09A602, 0x40F06032, 0x07960D85, 0x9460B27C,
    0x82A8DE0B, 0xEB01BD7C, 0x557C0FC9, 0xC7737E0D, 0x76A7802F, 0x03795A82, 0x7C07E574,
    0xF4C41351, 0x05C8DE03, 0x95C07CA2, 0x22051403, 0x8079606D, 0x092E0114, 0x0C006002,
    0x24B80080, 0x7A601148, 0x87806180, 0x8072D81F, 0x622B03E5, 0xFC1ABC41, 0x27AC26A2,
    0x1BCEA83F, 0x004ED4F0, 0x0002FBDE, 0xBC038E00, 0x33D7A805, 0xFBFDE77F, 0xC737E7BF,
    0xE3E6235A, 0xB23A3199, 0xCF7859F7, 0xA478895E, 0x7597C01D, 0x3E6059E3, 0x077B66F1,
    0x5669BDFC, 0x85EBF07C, 0x31805FB7, 0x7D9C0006, 0x00000000, 0x00000000, 0xEFFC0000,
    0xBCA6F7BD, 0x03FBDEF7, 0xBDEFFC00, 0xF7BCA6F7, 0x0003FBDE, 0x00000000, 0x00000000,
    0xB8805550, 0x26030177, 0x1E3591C3, 0xAC7E9F2D, 0xF7BDEF7B, 0x3FCEB007, 0x8BE7C8BF,
    0x5B9C007C, 0x00B23300, 0x2C803EFE, 0x0153E013, 0x4F0038F0, 0x4C7003C6, 0x803F2880,
    0xCF800C69, 0x0B195007, 0x880158E0, 0xC8AC01F2, 0x00F9F001, 0xF00988C6, 0x1D300153,
    0x00B22780, 0xCB20078E, 0x04A9F007, 0x3DCFB580, 0xBFE409BF, 0x777A8847, 0xCF78CDC0,
    0x30F8CB3D, 0xBD10CF53, 0x1397F154, 0x1479FCBC, 0xC323C310, 0x20863C01, 0xC0000801,
    0x00000004, 0x00008000, 0x41000316, 0x0C888600, 0x3C94C07F, 0x38A1880A, 0xC7E68162,
    0x442BBC33, 0x7FC0CF4F, 0x967B9F44, 0x577620FA, 0x007F7A88, 0xFD917BEA, 0xBF3C3DFF,
    0xAFAC4AFF, 0xF310FE62, 0x7CC2DE77, 0x0000000B, 0x00000000, 0x00000000, 0x00000000,
    0x7B200000, 0x137E7B9F, 0x211AF678, 0xE789DDEA, 0xF7BBF18B, 0x9F838D3F, 0x4EF917FC,
    0x5F84F1E3, 0x9FD71F80, 0x9FF09202, 0xCF080073, 0x6C5006FB, 0x01315C00, 0x1801A598,
    0x3C8026AD, 0xB8801F91, 0xE2002719, 0x001FF19F, 0x00DF11BE, 0x0AF8ABF0, 0x00BA57C0,
    0x009DE3F4, 0x6009E97A, 0x7BDEFA2C, 0xFEF7BDEF, 0xDEC80000, 0x07BFFEE7, 0x908D7B3C,
    0xEA0BF7CF, 0xF7BBF18B, 0x578FD4BF, 0xE9EC8BFE, 0x00BE9519, 0x0599151F, 0xFFF9E724,
    0x005C9007, 0xF1802C5A, 0x8C05F8AB, 0xF1AEEF7B, 0x0590007F, 0x7EEF7B8C, 0xE3003FA2,
    0x80079E5B, 0xC300070E, 0x003FFFEC, 0x600F9938, 0x581A1558, 0x7E34E6E1, 0x47AB7645,
    0xF7BBF52F, 0xFD0FD4BF, 0x7E7C839F, 0xFFC4003F, 0xBF0001DE, 0x01EA0004, 0x0002BC00,
    0x001399BC, 0x000BEA6A, 0x8001E7AF, 0xC001F8CE, 0xE0003A58, 0x9D0009A8, 0x98C002F1,
    0x1B8004DE, 0x1AC00163, 0x5F200071, 0xDEF7BFF1, 0x237BECDB, 0xEE300002, 0x7BDEF7BD,
    0x0DEFB36F, 0x00000000, 0x00000000, 0xEF7BDCE0, 0x8BDEF7BD, 0xBBE48000, 0xEF7BDEF7,
    0x4C009825, 0x00248012, 0x290012B8, 0xFFF73ED6, 0x47A3080D, 0x4C2F67C8, 0x2FDEFFD6,
    0xDBE7A4F5, 0xF34373C9, 0x2BE413BC, 0xFE1E001E, 0x00012400, 0x201FFFBC, 0xC0959389,
    0x0D09FFC3, 0x4E4F13E2, 0x7FA837CF, 0xB3CBD1FA, 0xE88DFDEF, 0x3267BD07, 0xB9005EE6,
    0x00FBFF7E, 0x2577FDE2, 0xFAA7FC40, 0xFE01F7FE, 0x93DFBE23, 0x0F7C3580, 0x0059AF00,
    0xC003E13C, 0xCEFE6396, 0x8F09BFFD, 0x7215BDF8, 0xF51A42EE, 0x88DF7BEC, 0x37D6092F,
    0xC2F17F98, 0x151E3068, 0x3CD803C1, 0x0843C001, 0x078F0009, 0xE2FE10F0, 0x3328B601,
    0x1478C075, 0x3C1FF95E, 0xBD43F17F, 0x5FBDF631, 0xEE603FE4, 0x1EF46299, 0xF7BDEFFC,
    0xBDEF7BDE, 0x20002EF7, 0x7BDEF7FE, 0x2EF7BDEF, 0xCD3000B1, 0x0F856000, 0x01279F00,
    0xC005E998, 0x350006A7, 0x2CB4005C, 0x03F0C600, 0x40098B40, 0x3F001796, 0x65C80131,
    0xF85F0005, 0x25531001, 0x005C3300, 0x300146BC, 0x9F800BC3, 0xED60007C, 0x026FCF73,
    0x4423DFE3, 0x27103BBD, 0x4FFDCFA3, 0x7A998FE3, 0xF1A77C85, 0xCD04C5B0, 0x90401A66,
    0x0608034C, 0xCBC1317F, 0x857A598F, 0xFC0D65E8, 0xACF73E96, 0x00C886E8, 0xFC9FFC40,
    0x7FAD3DCE, 0x4FB88DF8, 0x4B53F588, 0xA782563C, 0x60361EBC, 0x10000C8B, 0xCFE03F93,
    0x18066918, 0x7EC578A5, 0x788FF988, 0xBBF22FA9, 0xFF91BCF7, 0x847B73C4, 0x100FFEA8,
    0x9DDDEFBD, 0x8C1AEEA0, 0x45F90BB5, 0x32FEF77E, 0x711BC1BE, 0x5C46EA1F, 0xBE426659,
    0xE06C58C6, 0x403C97E1, 0x61800186, 0x0F000F06, 0x18C1881B, 0xD02F8266, 0x2BB516E2,
    0xDFCAF54C, 0x21ECBFBD, 0x3949FB98, 0x31FD2BFF, 0xBFFDFFBE, 0xF8003063, 0xE5C80144,
    0xE46E3005, 0x9DBEA202, 0xE7BAC179, 0x027678F7, 0x05FFFAB2, 0x17E7F9D6, 0xCF917CF9,
    0x0004FF3A, 0x75800000, 0x3E45F9FE, 0x3AC3E45F, 0x7C8BE4FF, 0xD61F22F8, 0x000027F9,
    0x00000000, 0x005DEE20, 0x47064C03, 0xF268F196, 0xEA0007E9, 0x5FECF007, 0x0DFFEB01,
    0x69D3EC81, 0xF6F8D7BC, 0xCF7B988A, 0xB227EDF8, 0xF4503BEF, 0x7A28057F, 0x9FF7E04F,
    0x0EF3DE31, 0x88AEF7C8, 0x440CF7B9, 0xBDE34E9F, 0x437FFAC0, 0x57FB3C00, 0xBDEF7BBF,
    0xEF7BDEF7, 0x7BBF0002, 0xDEF7BDEF, 0x0002EF7B, 0xFC000000, 0xDEF7BDEE, 0x0BBDEF7B,
    0x000AFC00, 0x004FFBF5, 0x09D3DF29, 0xC44F7FFC, 0xEA057FFA, 0xDF9E9DBB, 0x7FD6209E,
    0x29EF18CF, 0x887BBC60, 0x87B7D401, 0xFFF5C818, 0x53DE313D, 0xD3BFDF9E, 0xF393DBF3,
    0xAFFF5895, 0x3A7BE420, 0x27FDFA81, 0xBDF7A200, 0xEEA077FF, 0x4BDCE41A, 0xBDDF917E,
    0xC2FAE87B, 0xDC271879, 0xF1F20392, 0x62007DDC, 0x034C018C, 0xC03F49E0, 0x8C09C9F8,
    0x201BC47F, 0x015F11FF, 0x602BE237, 0x9700B7A6, 0xC0049009, 0x00005EEF, 0x6CEB0000,
    0x028C5F00, 0x003C62F8, 0xDFFBF310, 0x005BF67B, 0x3EFBDE20, 0xFBF98C49, 0x3D8C003F,
    0xDEFFDFCD, 0xBF2B7FFB, 0xF9FEA017, 0x3912B7DC, 0x0BE73B7F, 0x05FD17E4, 0x9CC7B180,
    0x005AC4E0, 0xE61A2710, 0xFFD60D18, 0x9C81BFFE, 0x10D3F131, 0x7B3E53BB, 0x32A7F3E2,
    0xEC63FE0B, 0x8E41CA7B, 0x3583EFE2, 0xB8443FF2, 0x051E18F0, 0x24205F9F, 0xA890D31C,
    0x4053098C, 0xED8114C8, 0x4182C301, 0x100C3018, 0xE9800612, 0x12101040, 0x00A40690,
    0x6901937F, 0x958063C0, 0x74C08863, 0x9E033F11, 0xB60F487C, 0x444FC8F5, 0x52F17E31,
    0xDF1958FE, 0xFA673FFD, 0x3FDFDFBE, 0x7EC4ACF8, 0xBA3D9E22, 0x1ED733C7, 0xF88D1518,
    0xF592F9CE, 0x4137FFBF, 0x0000D3C7, 0x05F5B460, 0x37CC0000, 0x1056FB9E, 0x0007FD63,
    0xFE62BFE6, 0x7767BDCE, 0xBF18004E, 0xF56495DD, 0xBC0001FF, 0x80000EF7, 0x30000FC5,
    0xF8000983, 0x8000F14B, 0x001C3D2C, 0x53E789F0, 0xB2D30009, 0x278007C2, 0x003CA27C,
    0x64707238, 0xA1F28801, 0x993001D2, 0xF800A9F0, 0x2623C054, 0x5901D2A0, 0xBBE1C03E,
    0x4B7BDEF7, 0x0005100E, 0x7FE1581F, 0xDEF7BDEF, 0x19F02CBB, 0x1313F009, 0x1801F863,
    0x03C7C3E9, 0x960C63C0, 0xF8FC0091, 0x8007E199, 0xEF75A691, 0xB3DEF7BD, 0x8C4002DF,
    0xBEC0FBF9, 0xCBBBDEF7, 0x7E3002F3, 0xFC000CC3, 0x00240028, 0x880027F0, 0x3C401647,
    0x7D85E33B, 0xCBE7BDEF, 0x3C0017FA, 0xBDEFB03F, 0xAC57FEF7, 0xADD9001F, 0xF8560016,
    0x0030C001, 0x0C400080, 0x3F0E8009, 0x729BE300, 0xEF7BDF61, 0x01718FDD, 0x09DBE7C8,
    0xCF73EF64, 0xFBC0056F, 0xF544235F, 0x3D37E02D, 0x66F3DEFB, 0xCB781EFC, 0x773106FA,
    0x553905FA, 0xE5E2D103, 0xE13C0347, 0xF000E4A1, 0x00B488C8, 0x6489CEF8, 0x00111000,
    0x00000000, 0x00000000, 0x44400192, 0xF800B488, 0x072509CE, 0x8F864780, 0x1F09E017,
    0x10267A63, 0xE1DE262D, 0x7739077D, 0x7FF017C6, 0xFFEF7DCC, 0xC40AFCCD, 0xEB20E7B7,
    0xBDD617FD, 0x767BDEF7, 0xB188000F, 0x7D802FF6, 0x467BBDEF, 0x78C001ED, 0x002791FF,
    0x01B2FE30, 0x00563C60, 0x001311C0, 0x08003F8A, 0x010C0013, 0x00000000, 0x80008600,
    0x8A001308, 0x261C003F, 0x03329E00, 0x06C9FA80, 0x917EFA88, 0x7BDF6027, 0x7B51EFCF,
    0xFB5A8800, 0xDEF75817, 0xF7BDEF7B, 0x0007FBDE, 0xF7BDEFB0, 0x1FEF7BDE, 0x00000000,
    0x00000000, 0xEFB00000, 0x7BDEF7BD, 0xFB000017, 0xBDEF7BDE, 0x00000177, 0x00000000,
    0x00000000, 0xDEFB0000, 0xF7BDEF7B, 0xDD60005E, 0xF7BDEF7B, 0x0FEF7BDE, 0xF7BEC000,
    0xBDEF7BDE, 0x0000003F, 0x00000000, 0xC0000000, 0x7BDEF7BE, 0x00001DEF, 0xBDEF7BEC,
    0x0001DEF7, 0x00000000, 0x00000000, 0x00000000, 0xE3000000, 0xDF9EE7DD, 0x7B7C404A,
    0x7BD5108E, 0x9E3FF881, 0x32F9EF7D, 0xE86FC17A, 0x7FCF106F, 0xD478C1E8, 0x3E5E5C02,
    0x450C601A, 0xFBA00189, 0x000F488D, 0x120C56B5, 0x00000800, 0x58000000, 0xEF7BDEF7,
    0x2000011D, 0xBDEEB049, 0x00F0C277, 0x01E27E00, 0x00686600, 0x00FE5A20, 0xFA8F9806,
    0xDF9F20CF, 0x37BE2463, 0xFEF73DF2, 0x03FCF2BF, 0xB20AEDE6, 0x7585FFFA, 0xDEE000EF,
    0x0000003F, 0x00000000, 0x00000000, 0x00000000, 0xBDF60000, 0xEF7BDEF7, 0x800000BD,
    0xF7BDEF7D, 0x002F7BDE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xF73C0000,
    0x0000002E, 0x00000000, 0x00000000, 0x000EF7BC, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x18000000, 0xF6300123, 0xF06001FE, 0x94311E00, 0x8A19E051,
    0xB10CDF0E, 0x5F19A27E, 0xE9EE7BC4, 0x6EA27FC8, 0xFFD5108F, 0x0077BAC1, 0x007EF77C,
    0x00FA8FD0, 0x01F196B0, 0x07FCB660, 0x1B8AF500, 0xFC4F8C00, 0x8FF18013, 0x790006F8,
    0x8800AFC2, 0x6001FA9B, 0x002C53FD, 0x00F883BC, 0x59E19E90, 0x13BE7800, 0xF9E001DE,
    0x009C4FE4, 0xF92CF178, 0xD52E8001, 0xEB4BE000, 0xE1388001, 0x5E300097, 0x7AC00071,
    0x7C000F8C, 0xDEEB99E9, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x7BDF6000, 0xDEF7BDEF, 0xF7580007, 0xBC8002DE,
    0x00E0FEF7, 0x04F007C0, 0x09802600, 0xF28013C0, 0x82647001, 0xB2007CBF, 0x0385403C,
    0x6302F1F0, 0x4F4C04AA, 0x03E3E00C, 0x8C023866, 0x93E04C7C, 0x3C470805, 0x800F8630,
    0x313E074A, 0x0D4F8005, 0x30002B2C, 0x3E198FC3, 0xF9328800, 0x5E00018C, 0x01F0C731,
    0x3EF86300, 0x9F000131, 0x80004CB1, 0x0007C219, 0x00095160, 0xF800E3E0, 0xC6005BDF,
    0x00DE2FBD, 0x000FE400, 0x200029E0, 0xA60001BC, 0xC3D0006C, 0xC370002C, 0x94C6000B,
    0x61E8002F, 0xE1B80016, 0xCA630005, 0x30F40017, 0x5E5C000B, 0x7C963000, 0x59A74001,
    0x02F0E000, 0x0004B180, 0x700009D0, 0x02C60000, 0x9EE7DEC8, 0x7BD004DF, 0x9EF5108D,
    0xD456F807, 0x19BCF7BE, 0x58F584DF, 0x3DCC41BF, 0xD55F20F4, 0xE6889C40, 0x9720170B,
    0xC00A254A, 0x0286279F, 0x249FE1E0, 0x05C4C100, 0x00000A40, 0x01C00000, 0x00648A40,
    0x0548CC10, 0x23DFC3C0, 0xC79FC00A, 0x2C402E17, 0x06AA7295, 0x2E8D117C, 0xFCC457EB,
    0x5BF01E97, 0xCF7BBF51, 0xA04DF19B, 0xAA211AF7, 0xEF7583CF, 0x7BDEF7BD, 0xC4002776,
    0xEF817B58, 0xF9EF7BDE, 0x10017A32, 0x009D4ECF, 0x000F9788, 0x9800018A, 0x80008000,
    0xE68001E2, 0x1ECF1003, 0xDEEF819E, 0x86F9EF7B, 0x631001F9, 0xF77C17ED, 0xEECF7BDE,
    0x00000001, 0x00000000, 0x00000000, 0x90000000, 0xBF3DCFBD, 0x1AF7A005, 0x03CFAA21,
    0x77EA2B7C, 0xBE32F9EF, 0x7EB1EB09, 0xF2FF3C45, 0x1A35E20E, 0x0CCB85F0, 0x18D3100D,
    0xFC00A27E, 0x001E19F8, 0x00492306, 0x000019A4, 0x00240000, 0x00000C80, 0x4D200249,
    0x60C003C3, 0xF00289F8, 0x068667E3, 0xF10C6988, 0x0BE02F1A, 0x7F31EB17, 0xF2FF3C45,
    0xD456F80E, 0xA5F3DEEF, 0x6BDE8135, 0x07CC1884, 0x3DCFBD90, 0x17BE23BB, 0x9A7FAC00,
    0xF630003F, 0x10001F18, 0x7BBF1FFB, 0x9EF7BDEF, 0x620003DD, 0xF701FDAC, 0x37CF7BDE,
    0xE2003F3C, 0x000AA5D9, 0x78007F2E, 0x00080048, 0xA0003140, 0xE78801F9, 0xF701AC3F,
    0x97CF7BDE, 0x79000DD1, 0xBDEF7017, 0x000991F7, 0x9C8005CD, 0x2FC00146, 0x32E40034,
    0x85F8001E, 0x725C8006, 0x17874001, 0x058A6200, 0xFF7BEDF5, 0xF7E204DF, 0xBCF9067B,
    0x65D881FF, 0x9BCF7BED, 0x753A2FF9, 0x88DE620F, 0x90162597, 0x01E11F2D, 0x0130B628,
    0xB92B7BB2, 0xFC7AD600, 0x40097F52, 0xFFF9E1DC, 0xFEE40066, 0xEFCF7A86, 0xBFF67801,
    0x02FF7D4B, 0x1D3BF5C8, 0xC4005BF9, 0x678F43BA, 0xBE68802D, 0x0F009DDD, 0x060079B9,
    0x0077A4F1, 0xE2276C7E, 0x9BF503DF, 0xC57634C6, 0x5FDEF7DA, 0xDFC8FE79, 0x98C4239E,
    0xDEE30BFB, 0xF7BDEF7B, 0xBDEF7BDE, 0x30000077, 0xDEF7BDEE, 0xDEF7BBE6, 0x0000077B,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0xBDC40000, 0xDEF7802F, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x09040000, 0x13CA1060, 0x11D32500,
    0x7E1BC03F, 0x57E78F3C, 0x4CF4DF18, 0xEEFD537C, 0x3F31FBBD, 0x08D7FEF0, 0xC5FFD631,
    0x4005F7BC, 0x5856BBDF, 0x51987800, 0xAA5400A2, 0xF803F870, 0x00B4A873, 0x11E0F12C,
    0x1309E00F, 0xF2E02E3E, 0x20152C83, 0x2FE018CA, 0x03F0A816, 0x2383F856, 0x02A51026,
    0x87002A51, 0xA805C589, 0x1E27C3F4, 0x72918F00, 0x3C7C0098, 0x64007E1E, 0x0319F9F9,
    0x0E637F00, 0xD0CC001F, 0x25800162, 0x3F800054, 0x2950000E, 0x0DDCE00B, 0x3806EFB0,
    0x400C7B77, 0x1180230C, 0x8580A6CA, 0x8AFE1E02, 0x606C6C01, 0x40D84653, 0x8CB01619,
    0x1180F1E0, 0xD220315E, 0xFC062D83, 0x8A0A93E4, 0x2941418D, 0x429FC365, 0xD8723F85,
    0x019282B6, 0x4789428F, 0xB02860F1, 0x443DB245, 0x0C1B14D9, 0x56C7F28A, 0xB8540A0C,
    0x0E4A142A, 0x28F0065B, 0x548C48DB, 0x3218051E, 0x33B2814A, 0x86A6C05C, 0x459ED81F,
    0x06238A01, 0x4C8E2278, 0xC02CA180, 0xC28014A3, 0x005C6C06, 0x8500789B, 0x003C5002,
    0xEF826523, 0xEFC017DE, 0x730BF6DE, 0x2D196600, 0x9A205C7E, 0x058CA78B, 0xF80D617E,
    0x47A89BC2, 0x2F168836, 0x2CC05E5E, 0x0A7A7535, 0x4CFD0DE0, 0xAF9003F9, 0x000742F8,
    0x0079E06B, 0x0001C3E0, 0xBC00343F, 0xC0058C29, 0xDE1FF298, 0xF1E87004, 0xD3A0178A,
    0x4D4358F3, 0xC3F12C60, 0xD2E01D0D, 0x07C53181, 0x9D04D43D, 0xF14C61EA, 0xE17E5E02,
    0x35013786, 0xFBDD6FC5, 0x3BDDF001, 0xC0067A57, 0x69A98C78, 0x19E5E680, 0xEA55006A,
    0x4D02E5C1, 0x828C78C3, 0xE8067867, 0x068AF0D0, 0x730F1A72, 0x43780998, 0x100D13F3,
    0x35339CAF, 0xDAFD2B00, 0x19680098, 0xA29E001A, 0x0E1C000A, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7BDEF758, 0xDEF7BDEF, 0x0003EF7B, 0xF7BDEEB0, 0xFDEF7BDE,
    0xF1000F18, 0x5F000713, 0x966004E8, 0x8B64009A, 0xE86F000F, 0x9A966000, 0x0F8B6400,
    0x02FC2700, 0x0F3C3580, 0x3F95E300, 0x06F0DC00, 0x02CC3D00, 0x02F94C60, 0x001784E0,
    0x5001569D, 0x2E00364B, 0xF7BDEF79, 0xFDEF7BDE, 0xEFFC0001, 0xC805F7BD, 0x00005F7B,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1817DEF2, 0xC6003EF7, 0x54F80070,
    0x01E15802, 0xE003E510, 0xE95002C8, 0x00A9F000, 0x1004C530, 0xD7001F8F, 0xF49E0018,
    0x0058F001, 0xC802627C, 0xAFE007F2, 0x1F0CC012, 0xC003CB00, 0x18C00B27, 0x4F3F000E,
    0x02619800, 0xDFF9F288, 0xFC0BEF7B, 0x000005EF, 0x00000000, 0x00000000, 0x00000000,
    0xC0000000, 0xF0005EFF, 0x651017DD, 0x9886F005, 0x303E94C0, 0xE07C8E23, 0x45E3C6B3,
    0x18D79F0D, 0xE18C355C, 0x55E2E595, 0x278593F9, 0xDEF7BBE3, 0xF7BDEF7B, 0x0000BBDE,
    0x5F0BBDDF, 0x7CAFC2E9, 0x83E55F89, 0xFF7BEEF1, 0x9EEF00EF, 0xE17B9C83, 0xEF7D9E9D,
    0xF4C4BA1E, 0x0FF1837C, 0x106BEF87, 0x279E258F, 0xDDEA1201, 0x105BDEE7, 0x011CDFBF,
    0x77E795F0, 0x5185BDEE, 0x280157E6, 0xC010003E, 0x3980F042, 0x193BC330, 0x11FE0BEF,
    0x567BBDEF, 0x295DC691, 0xD66DFBEA, 0x0001FEFF, 0x00000000, 0x00000000, 0xFCF00000,
    0x09BFFDCE, 0x9C855FBC, 0xFAE720BB, 0x7C46FBDF, 0xFCC9DD09, 0xC0B9178B, 0x70005478,
    0x09260029, 0x00000240, 0x43C00120, 0x7229B002, 0x8278F181, 0x7F9937E8, 0xFCE678D1,
    0x7C46FBDF, 0x157F7C89, 0xE602EE72, 0x7BF3DCEF, 0x42B7EC40, 0xFC0BF7D4, 0x67B9F447,
    0x7E1E8FA9, 0x7AB7442B, 0x1580F54C, 0x301B08EE, 0x400C3C6B, 0x0160DEFF, 0x0B040000,
    0xE4048780, 0x01FC2318, 0x1EA9B767, 0x0F470CF0, 0xFD6215BF, 0x447FC3D4, 0xEA3A7B9F,
    0x856FD887, 0x003F7E78, 0x007FBFF0, 0x00000000, 0x00000000, 0xFFF44000, 0x8C03DF9E,
    0xF7D452BB, 0xDE23FC41, 0x49EBFF73, 0x4337C2FC, 0x55288BF6, 0xF84F2660, 0x00783003,
    0x00000240, 0x3C180120, 0x03613C00, 0x6053CB10, 0x337C3A25, 0x3FC43764, 0xBFF73DE2,
    0x95DC60AA, 0x005FBEA2, 0xFFF73BF5, 0x55FBF015, 0xC2F7E7C8, 0xFFB9F4AF, 0xD2AC5CC7,
    0xDE57E42B, 0x5C0B1AF0, 0x80FC2AB1, 0x00307B0A, 0xF77E1C43, 0x4DEF7BDE, 0xFC380013,
    0xDEF7BDEF, 0x993FEF7B, 0x00385400, 0xC03CF2C4, 0xAFA753B7, 0x393DFA93, 0xFFD61EC5,
    0x57C55FDE, 0x149EFEC4, 0xCF016FA3, 0x407FDCEF, 0xC612157F, 0x81BDF632, 0x4780338F,
    0x00002026, 0x794DEE78, 0xF0001DEF, 0xDEF29BDC, 0x0000003B, 0x00000000, 0x00000000,
    0x00000000, 0x10000000, 0x37E7BFFD, 0xB8CFF7BD, 0xBFBD452B, 0xFA23FC44, 0xA14FD3DC,
    0x58856FC3, 0x03C6583F, 0x0FC2A49E, 0x10006480, 0x8000002C, 0x30F00160, 0x07E11800,
    0xE03C6580, 0xADFA7449, 0x7107EB10, 0xD3DCFA22, 0x2BB8C24F, 0x203FBD45, 0x6FCF7FFA,
    0xA6404822, 0x3405DE47, 0x06FECA9F, 0xC33C7BE3, 0xBDF678EC, 0x587CF1FB, 0xE7C847BB,
    0x17BBF1F7, 0x00000000, 0x00000000, 0xF2000000, 0x7BF3DFFD, 0xA299ED40, 0xB3DF05BE,
    0x4EA5FDEF, 0x2F506FD4, 0xF8A07E0F, 0x00020023, 0x00000000, 0x00000000, 0x00000000,
    0xF7800000, 0xA627A67E, 0x00FEF78A, 0x001FEFFC, 0x00000000, 0x77E00000, 0x1931519A,
    0xD3BF1315, 0x7F7B8000, 0x00000000, 0x00000000, 0x00000000, 0xFF160800, 0x14CE5B7B,
    0x7F7B8DCF, 0x00000000, 0x00000000, 0x00000000, 0x1FF73A80, 0xBC8BE300, 0x88FF1801,
    0x47FC8093, 0x6F2007FC, 0x710037C4, 0x97C01753, 0xF154027A, 0x5E30C003, 0xF30F6B00,
    0xC2768C01, 0xFE45812F, 0x99E001C4, 0x0EF00346, 0xE13800AB, 0x13F9000B, 0x00BDDF9F,
    0x00000000, 0xC4000000, 0x9DFCCBBD, 0xFB20EFFB, 0xC05ECF7F, 0x5C856FDD, 0x14AF6B3B,
    0xF15837A3, 0xE53FF7BB, 0xEF77F2F9, 0xB1058C7E, 0xF0CB7C8B, 0x3E97C62F, 0xCCFE0158,
    0x60024B00, 0x010607F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7FBBF000, 0xF9EFFEF9, 0x4CF6A03D, 0xF8C2DF51, 0x2FEF7D9E,
    0x1BF51275, 0x1F83CBD4, 0x8008FE28, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xDCEFE600, 0xEE409BF3, 0xBBD442B7, 0xF4477113, 0xDC63A7B9, 0x856FD3A0, 0x62D93F58,
    0x3CF01E7A, 0xE00E2C66, 0xE00F2EB0, 0x080126E1, 0x09200006, 0x0F2E3240, 0x038B7160,
    0x3C7CACB8, 0x0CC79E05, 0x10ADF4BF, 0xB89B27EB, 0xD3DCFA23, 0xF7206E31, 0xDDEA215B,
    0x9EBEFFC9, 0x37FFB9DF, 0x0ABEFE41, 0x3D417739, 0x88E9EE7D, 0x42B7E12F, 0xE4689FAC,
    0x02A19E03, 0x003C4F80, 0x0800243C, 0x45800000, 0x00483000, 0x07C8A27E, 0x6FC1433C,
    0xD13F5885, 0x3DCFA7C8, 0xFC25F11D, 0x77390ADE, 0xEE77F301, 0x00004DFF, 0x00000000,
    0xC8000000, 0xEFCF7FF7, 0x6A3FBBF1, 0xFDF514CF, 0xF117C626, 0x955FFB9E, 0x90CDF0E8,
    0x53CB22FD, 0x00B8A260, 0xC100161C, 0x08000000, 0x167F0006, 0x400B8B00, 0x84C0A796,
    0x64337C37, 0xC45F90BF, 0x157FEE7B, 0xD4533DA8, 0xFDF203F7, 0x007BF3DF, 0x00000000,
    0x00000000, 0xFFD5F7B8, 0x52BD8CDB, 0xEF77C4F0, 0x3C07DC4B, 0x00000009, 0x00000000,
    0x00000000, 0x9EE77E78, 0x7DF882DF, 0x9FFAA215, 0x7B9F4AFC, 0x31F2BC96, 0xF25E8857,
    0xF8F83609, 0xBDE40707, 0x33DA8F9D, 0xF18ADF01, 0x80FBCFFE, 0xF3115DBE, 0xFD6203DB,
    0xFE319ECE, 0xDE301119, 0xE77DF89F, 0xC5B90F02, 0xD4AE4904, 0xE7C3A82B, 0xF7B9F466,
    0xF21DE237, 0xB18856FF, 0xFDFF84F6, 0x00000003, 0xDE537BBF, 0xBBF003FB, 0x3FBDE537,
    0x00000000, 0x00000000, 0x80080000, 0x17C09647, 0x7C63777E, 0xFEEFE625, 0x00FEF701,
    0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x029FC009, 0x07784F0B, 0xCB646DE3,
    0x4F9EEF7D, 0x442AFE62, 0xDEE21F7D, 0x47BBF017, 0x14780594, 0xC2781447, 0x707F09E1,
    0x502CA145, 0x50311C16, 0x1F4A83E1, 0x478072FE, 0x9F807961, 0x80F8461C, 0x919F3E91,
    0x3F294F80, 0x34AE4780, 0x55787201, 0x3F84F800, 0x02C42B00, 0xC0151E20, 0xBBF01FB9,
    0x7FBBF01F, 0x0528814A, 0x062D8A3C, 0xC2305114, 0xF1705166, 0x6188A287, 0xB60A9943,
    0x1507940A, 0x8F0391D9, 0xF8313F0D, 0x18FC78AB, 0xA28460A1, 0x2515FDFC, 0xC8DB2807,
    0x5B48CB28, 0x67E3DB01, 0xB1E3C311, 0x6CAA2581, 0xF111ECFC, 0x119C3100, 0xF3F51E0F,
    0x1E3CFC00, 0x00DA61C8, 0x09F83F85, 0x05823005, 0xCA001C8A, 0x01523008, 0x98067BFF,
    0xD11C7EF7, 0x8C7E2D10, 0xE8741EA5, 0x4C66A740, 0x5B2BC135, 0x69A80F8B, 0xBC00E976,
    0x004D4B19, 0x9002F12F, 0xC6880044, 0xBC45F001, 0xBCB301B2, 0x880731F3, 0xC45F9636,
    0xA2685F05, 0xB32CC68D, 0x44398730, 0x5C57068B, 0xD403EF7D, 0x02E3FDBD, 0x28637E7F,
    0x4FC31960, 0x8FC2303C, 0x0F1F85C9, 0x951E0A51, 0xA461E238, 0x50E13C3F, 0xF09E502C,
    0xA88E0153, 0xE9500E1C, 0x3C01E23C, 0xF8029F9E, 0x8C00E189, 0x1F801441, 0x03E2800B,
    0x800391E0, 0x18C003CF, 0x3C75003E, 0x5FDFF809, 0x14C01F8E, 0xF7801FF3, 0xBDEF7BDE,
    0x00BBDEF7, 0xEF7BDE20, 0x18FEF7BD, 0x389F1013, 0x04E85F00, 0xC04CF2AC, 0xE00FE578,
    0xEF003786, 0xD3500AB0, 0xE27C4068, 0x13A17C00, 0x0133CAB0, 0x401F95E3, 0xDEF7BC87,
    0x03FDEF7B, 0x7BF3C000, 0x4ABEFC40, 0x05EC55F0, 0x700DF94F, 0x1E3C03C4, 0x00000040,
    0x06080200, 0xFCF06C50, 0x5FB883E4, 0xC4000B8C, 0xE05C62FD, 0x2807C9F9, 0x000C1036,
    0x80000001, 0x0078F000, 0x53C03C47, 0x2AF8037E, 0xFBF102F6, 0x01FDD72A, 0x00000000,
    0x00000000, 0x9007BF3C, 0xAC02FDF5, 0xD407D45F, 0x13C03D4F, 0x00B1E02E, 0x00000024,
    0x97004800, 0x0BA99807, 0x1BBF95B8, 0x2BFC0030, 0x86781BBE, 0x0F3603DF, 0x00000090,
    0xF0120000, 0x170CC058, 0xFA07AB54, 0xFF03F517, 0xE200FDFA, 0x9BFFDFFD, 0xDC69BF40,
    0x05EE7299, 0xC63726B9, 0xFE8AEEFF, 0xCCAAF90D, 0xEBF1A6E1, 0x95FF7DA8, 0x603DD1AF,
    0xEE7299ED, 0x78AFBBE4, 0x7C98F14C, 0xDF8005F7, 0x600001FD, 0x13000002, 0x04800000,
    0xC400918C, 0x00003FDE, 0xDE880000, 0xC603DFCC, 0x7EFA895D, 0x7BC47FC8, 0x8FAA7FEE,
    0x433FE237, 0xB233D3BE, 0x2A9A01AC, 0x19AC40FE, 0xEFD00797, 0x00000044, 0x3CB80020,
    0x36288880, 0xCB379EE0, 0xF6C2B04C, 0xEC87EC46, 0x22FC94F6, 0x4BFF7BBE, 0x12BBA87D,
    0xF440FDF5, 0x001EFE66, 0x88000000, 0xE3003FEE, 0x3BB3DFFD, 0x8A67BD00, 0x6B00EEB1,
    0x1D3DFFA9, 0x6BC40FF1, 0x57AC52FC, 0x81F0AC4C, 0x01E5C6C5, 0x80204A9E, 0x0102F7EF,
    0x07000000, 0xB36FFC00, 0x0017BDEF, 0x97DFF800, 0x017BDEEF, 0x09000006, 0x83000000,
    0x03CB8000, 0x00C65C80, 0xE30FFFE0, 0xBDEF7BDE, 0x0007DEF7, 0x11000480, 0x7F307B7C,
    0x0ADF9EE7, 0x7CC7FFF1, 0x6FFEBFE2, 0xEBBEA885, 0x3E6FC63F, 0x73DF33A2, 0x87A237CF,
    0xCF15F3F1, 0xF678867F, 0xA3C1FF22, 0xC63F403E, 0xF0068560, 0x53F1F88B, 0x8B2C4003,
    0x8B600361, 0x9300120C, 0x90400000, 0x61849800, 0xF48B6003, 0x2C400353, 0x802E158B,
    0x488FC45F, 0x43F403E3, 0xFE783DC8, 0x17B3C433, 0xA8731FF1, 0xF73DF22F, 0x47DE237C,
    0x7BF57D54, 0xAA215BCE, 0xB59EFCEF, 0x77F30FD4, 0xE0ADF9EE, 0x3FDEE36B, 0xC77BFF00,
    0xAC017298, 0x6F0E8734, 0x26CAF100, 0x1BC0BC5A, 0x4CCB303A, 0xD01EA9C8, 0xF11D0D11,
    0x067A6302, 0xD01331E3, 0x00D969A9, 0x1795555A, 0x7B74A780, 0xBDEF700A, 0xBDCF0C65,
    0x000002F7, 0x9B7BDEF7, 0x2F7BDEEF, 0xEF700000, 0xEEF9B7BD, 0x0002F7BD, 0x7BDEF700,
    0x7BDEEF9B, 0x0000002F, 0x00000000, 0xFBFF0000, 0x00000007, 0xFC0FF7FE, 0x00001FEF,
    0xFBF58000, 0x4DFFFBDF, 0x92574EA0, 0xEA07FEF5, 0xEFFEF917, 0x93FE4BDD, 0xA3267716,
    0x2A18B45B, 0x0C143581, 0x42231280, 0x97DF7C01, 0x200DFC96, 0x43BC279F, 0x4006BDED,
    0xFFDE8C4C, 0x13FF8077, 0xE7213DFD, 0xE86B25FE, 0xF7E77CF5, 0x3365DA84, 0xC53DBEA1,
    0xA77C8007, 0xF8049278, 0x80938FC8, 0x7EC658C0, 0xFA187807, 0xFFFB98CB, 0xC555F30E,
    0x722AFFF3, 0xFCC6FBEE, 0x7E77E781, 0xA00B8833, 0xBC46F3DE, 0xCC029EA5, 0x2F7F473F,
    0x94CB48C0, 0x68708003, 0x351E93C0, 0x4609FFD5, 0x778FC4FF, 0xBBDCEFC9, 0xD13FE457,
    0x9F20AEFF, 0xFFC83FF7, 0x3F4EFC29, 0x58AC8719, 0xCB21C64F, 0x7FEFCC02, 0x007BFFEF,
    0x49F79D60, 0x13FEF9F2, 0xF9ED7E20, 0xEFFFBDCE, 0xFC03F7C9, 0x04F7F6AB, 0x3C7B7CF9,
    0xE78EF03F, 0xE7BED697, 0xB55D8D37, 0xF8F8E630, 0xBEF510F5, 0xAF26F97C, 0xEEFE574B,
    0xD10E637D, 0x983551F1, 0x1F9662DE, 0x6C463E4F, 0x99C16446, 0xD3993C7F, 0xDEA09960,
    0x8B4CC707, 0xA4430000, 0x21800045, 0x4132C1A6, 0x398E0FBD, 0x0B223362, 0x993C4CCE,
    0x5BD306AA, 0xF93C52CC, 0xF23D2ED0, 0x731BEF77, 0x9C8F8E88, 0x21EEC7E3, 0x97C57DEA,
    0xDAADE26F, 0xFCF7DAC3, 0x59EBB1A6, 0x7F6357E0, 0xB7CF904F, 0xDF807E73, 0xEE77CF1B,
    0x7E4F7FFD, 0xDE79802F, 0xFBE7C927, 0xFF78803F, 0x79037CF7, 0x3FE78A67, 0xFF7DC8E8,
    0x7F392F19, 0xFD163E43, 0xFCF05C4E, 0xF436F7FE, 0x9E980957, 0x640DBDFF, 0xBACA1B1A,
    0xDF063F77, 0x7ABEB94A, 0x58FDD602, 0xE378C3F7, 0xC3F1BC67, 0xF1385F89, 0xC7ACBE0B,
    0x9F30F597, 0x5E27CD78, 0xED99BDB2, 0xDB20004D, 0xC4DED99B, 0x9F35E27C, 0x7ACBE178,
    0x9C0F597C, 0xBF1385F8, 0x67E378C0, 0x7B8BF1BC, 0xDEF7BDEF, 0x0005EF7B, 0xF7BDEF71,
    0x000B7BDE, 0xC0000000, 0x7BDEF7BA, 0xF980007F, 0x7FFDEFFD, 0xF3AC000F, 0xDF3E493E,
    0xAFC4027F, 0xEF73BF3D, 0x7DF27BFF, 0xFDAAFF01, 0xB7CF9055, 0x3BC0FCC7, 0x7BDC5F9E,
    0xD8CBD9EF, 0x398C2CF5, 0x6F46203E, 0xD7937CBE, 0xEEF7BA85, 0xF8E88F1C, 0xA3001AA8,
    0x2A3E4F24, 0x14AA00FE, 0xA094CC9E, 0xF1BFBDEE, 0x16111C0D, 0x330C0600, 0xDEF7502C,
    0x330C0E9F, 0x44F5000D, 0x0D8A88E1, 0xAA64F000, 0x9E12001A, 0x005D787C, 0x5E3A2FE1,
    0x719F1CC6, 0xE3B7D07F, 0xD6F037CB, 0xEC6013B3, 0xD5F8167A, 0xF9055FD8, 0x0FCE76FC,
    0xBF3D7BF0, 0xABFFEF73, 0xF3005EFC, 0xCF924FBC, 0xB8C07FF7, 0xEF7BDEF7, 0x000077BD,
    0x13FF77E3, 0x5DF25FE3, 0xF1DDF474, 0x33196352, 0x8C405846, 0xA913C69A, 0xDF3BBDE3,
    0x77C95F50, 0x005DEE01, 0x00000000, 0x00000000, 0xF7BDEF78, 0xFBDEF7D2, 0x7BDE0007,
    0xBDF4BDEF, 0x0001FEF7, 0x00000000, 0xA0000000, 0xFBF0012A, 0x7000003D, 0xDEF7BDEF,
    0x03BDEF7B, 0xB9DF9000, 0x3F630EFF, 0x475FD721, 0xF18BFB9D, 0x8F50ECCC, 0xF107FFFC,
    0x3E45F048, 0xF0B8ABF0, 0xEC49DCAB, 0xFF893B1A, 0x37E07678, 0x7BDEF73C, 0x3BF18003,
    0xCF06FFF7, 0x1DCE42BF, 0xFDCE78DE, 0xFF772E45, 0x18C23D42, 0xE2063D41, 0x00B79FDE,
    0x7BBDC42E, 0x60AD65CC, 0x7FB7B63C, 0x7B523C61, 0x3F19DDCE, 0xE72157F3, 0x9DEEFC4D,
    0x67A77974, 0xDF3B2779, 0xC05EEFC9, 0x00003FBD, 0x00000000, 0x00000000, 0x00000000,
    0x00300000, 0x601E07E0, 0x80FD724E, 0xF7FDEF78, 0xC2AFC033, 0x40D55FE8, 0x4BDDCEFD,
    0x00001AFF, 0x00000000, 0xF7B20000, 0x87DEF7B9, 0x6008D7B5, 0x0BE40075, 0x6C0013C0,
    0x2C002C00, 0x36002400, 0x80019E00, 0x9EE40093, 0xFBDE2001, 0x51007EEB, 0x00005D6B,
    0x00000000, 0x3C000000, 0xE46E3FE7, 0xB8BF2377, 0x3BC8F0FF, 0x24D17EEB, 0x5119B6EB,
    0x1EE6236F, 0x30EFBDEA, 0x7AA0337E, 0x00D6FC63, 0x00000000, 0xBEE60000, 0xDEFC4F67,
    0xB3FBC621, 0xAB6F7BCA, 0x6B2733F5, 0xB61B0DFA, 0x30600001, 0xCFC6B86C, 0xB7E9CC9C,
    0xABEF7BCA, 0xC23BDF96, 0xFDE67F78, 0x660FEF31, 0x16AB32D5, 0x6F0EF1BC, 0xC6F903BC,
    0x04E37C89, 0x359FC8D6, 0x33D707F2, 0x0004CF5D, 0x3D74CF5C, 0x67F23593, 0x6F91FC8D,
    0x4E37C89C, 0xBC3BC6F0, 0xD5660EF1, 0x1016AB32, 0x80000F73, 0x003BEF7A, 0x066FC600,
    0xC01BF100, 0x7E003F58, 0xBBB180F5, 0x1353D400, 0xF1BC4000, 0xF9D00002, 0x9A800026,
    0xF0000163, 0xA00005C6, 0xDCE20E73, 0x65630017, 0x70000BE3, 0x7002AC1D, 0x0D63D0EF,
    0x9000B3AA, 0xE3789B33, 0xBC4E0024, 0x0037F2F8, 0xAC53C6B0, 0xF90007EA, 0xF57C8FE6,
    0x03BCD3BD, 0x08C1D1BC, 0x1F3FE000, 0xDEF7BDC4, 0xE601DE69, 0x0000000B, 0x0F731000,
    0xEF7A8000, 0xC600003B, 0xF880066F, 0x3F58C00D, 0x807ABF00, 0xEA00BBB1, 0x200009A9,
    0x000178DE, 0x00137CE8, 0x00B1CD40, 0x02E37800, 0x8739D000, 0x77FDCEFC, 0xDB2B1800,
    0xF5C84FD8, 0x3A1D7007, 0x8C5FDCEA, 0x3D1DEE07, 0x876660D6, 0x3390247A, 0x20FFFF1B,
    0x789C091E, 0x0F917C01, 0x8029E358, 0xF905C55F, 0x57E00FE6, 0xD1BC13B9, 0xC6AFC401,
    0x1F3FE04E, 0xECF5FE20, 0xF017CC00, 0xEF7B9E1B, 0x002000BD, 0xFF73BF18, 0xF500006F,
    0x077390AF, 0x73A8E800, 0xC40B917F, 0xBFBB806F, 0xBF008F50, 0x4118C07A, 0x53D4063D,
    0xFEF71013, 0xE37885BC, 0x3A170005, 0x7B8804DF, 0x9A8B98F7, 0x279E0163, 0x1BCD8F18,
    0xFDF7E017, 0xCEA478C2, 0x2FB9C439, 0xCEEE73DA, 0xCD958DF8, 0x2AFE6017, 0x1D79BCE4,
    0x77EA0156, 0x1E8DFFEE, 0x02CEA86B, 0xE2D99C80, 0x7000938D, 0xDFCBE5E2, 0x9E358000,
    0x001FAAB2, 0xF27F37C8, 0xF34EF7D5, 0x0E8DE00E, 0xFF000023, 0xDEF710F9, 0x0779A77B,
    0x00005F30, 0xE3000000, 0x5F80067F, 0x97E007C6, 0xFF1801F1, 0x00000033, 0xDFBF9000,
    0x0D566003, 0x20079B00, 0x790031A7, 0x6E202E23, 0xD2F801EA, 0x3CA7809A, 0x0FC4700D,
    0x0800A940, 0x454F5006, 0xB5FBC018, 0x2A540547, 0xE7837C57, 0xB56A9F13, 0xBE22FDEF,
    0x1927ED64, 0xDDF016EB, 0xBE0000BB, 0xF00005D2, 0x00025F2B, 0x001F2AFC, 0x00BDBF00,
    0xC0000000, 0x0000EF7B, 0x0000FC58, 0x80009833, 0x000F14BF, 0x01C3D2C8, 0x3E789F00,
    0x2D300095, 0x78007C2B, 0x03CA27C2, 0x47072380, 0x1F288016, 0x93001D2A, 0x800A9F09,
    0x623C054F, 0x901D2A02, 0xBE1C03E5, 0xB7BDEF7B, 0x005100E4, 0xFE1581F0, 0xEF7BDEF7,
    0x9F02CBBD, 0x313F0091, 0x801F8631, 0x3C7C3E91, 0x60C63C00, 0x8FC00919, 0x007E199F,
    0xC0026918, 0x0009DEEF, 0x004EF2E8, 0x09DE59E0, 0x4EF9D800, 0x3FF78000, 0x00000001,
    0x0077BDE0, 0x007E2C00, 0x004C1980, 0x078A5FC0, 0xE1E96400, 0x3C4F8000, 0x98004A9F,
    0x003E1596, 0xE513E13C, 0x8391C001, 0x94400B23, 0x800E950F, 0x054F84C9, 0x1E02A7C0,
    0x0E950131, 0x0E01F2C8, 0xDEF7BDDF, 0x2880725B, 0x0AC0F800, 0xBDEF7BFF, 0x8165DEF7,
    0x9F8048CF, 0x0FC31898, 0x3E1F48C0, 0x631E001E, 0xE0048CB0, 0x3F0CCFC7, 0x01348C00,
    0x000A7BCC, 0x0AFA6FD0, 0xFBCAF400, 0xC60026F9, 0x1BF593C8, 0xBF18003B, 0x7FF9E0FF,
    0x00000001, 0x0077BDE0, 0x007E2C00, 0x004C1980, 0x078A5FC0, 0xE1E96400, 0x3C4F8000,
    0x98004A9F, 0x003E1596, 0xE513E13C, 0x8391C001, 0x94400B23, 0x800E950F, 0x054F84C9,
    0x1E02A7C0, 0x0E950131, 0x0E01F2C8, 0xDEF7BDDF, 0x2880725B, 0x0AC0F800, 0xBDEF7BFF,
    0x8165DEF7, 0x9F8048CF, 0x0FC31898, 0x3E1F48C0, 0x631E001E, 0xE0048CB0, 0x3F0CCFC7,
    0x01348C00, 0xE2004C80, 0x792BE73B, 0xFFE001FF, 0xFBBF3C44, 0xCC800ACF, 0x22AFEE71,
    0xCF2007E6, 0xE73BF50E, 0x0000000D, 0x03BDEF00, 0x03F16000, 0x0260CC00, 0x3C52FE00,
    0x0F4B2000, 0xE27C0007, 0xC00254F9, 0x01F0ACB4, 0x289F09E0, 0x1C8E000F, 0xA200591C,
    0x0074A87C, 0x2A7C264C, 0xF0153E00, 0x74A80988, 0x700F9640, 0xF7BDEEF8, 0x440392DE,
    0x5607C001, 0xEF7BDFF8, 0x0B2EF7BD, 0xFC02467C, 0x7E18C4C4, 0xF0FA4600, 0x18F000F1,
    0x00246583, 0xF8667E3F, 0x09A46001, 0x7E14FFE4, 0x327801A7, 0x00B1590E, 0x590E3278,
    0x3FF90016, 0x006DDF85, 0xEF000000, 0x600003BD, 0xCC0003F1, 0xFE000260, 0x20003C52,
    0x00070F4B, 0x54F9E27C, 0xACB4C002, 0x09E001F0, 0x000F289F, 0x591C1C8E, 0xA87CA200,
    0x264C0074, 0x3E002A7C, 0x0988F015, 0x964074A8, 0xEEF8700F, 0x92DEF7BD, 0xC0014403,
    0xDFF85607, 0xF7BDEF7B, 0x467C0B2E, 0xC4C4FC02, 0x46007E18, 0x00F1F0FA, 0x658318F0,
    0x7E3F0024, 0x6001F866, 0xDF1009A4, 0xF8000D39, 0x02F9EEAF, 0x39DE3180, 0x000005DF,
    0x7E8C6000, 0x8000BBE6, 0x7CF5FCFF, 0xCEF88001, 0x00000069, 0x1DEF7800, 0x1F8B0000,
    0x13066000, 0xE297F000, 0x7A590001, 0x13E00038, 0x0012A7CF, 0x0F8565A6, 0x44F84F00,
    0xE4700079, 0x1002C8E0, 0x03A543E5, 0x53E13260, 0x80A9F001, 0xA5404C47, 0x807CB203,
    0xBDEF77C3, 0x201C96F7, 0xB03E000A, 0x7BDEFFC2, 0x5977BDEF, 0xE01233E0, 0xF0C62627,
    0x87D23003, 0xC780078F, 0x01232C18, 0xC333F1F8, 0x4D23000F, 0xF7BDE000, 0xBDEF7BDE,
    0x02FBDEF7, 0x00013180, 0x7D057000, 0xDEF7BDEF, 0x58005F7B, 0x0005CBC3, 0x49AAF100,
    0x5F800000, 0x00000344, 0x608E63D4, 0x2BC00000, 0x0000021B, 0x0002352B, 0x0F55F200,
    0xDEF7BA86, 0x005DEF7B, 0x001788DE, 0x6F29E000, 0xDEF794C2, 0x0BBDEF7B, 0x0C02E5A0,
    0x794E8000, 0x96F7BDEF, 0x058C0000, 0x6B800000, 0xBDEF7BDC, 0x80004EF7, 0x4100BC39,
    0xF1B44000, 0x40005C00, 0x06001787, 0x0F1A6A00, 0xBDEFFC00, 0xEF7BDEF7, 0x2400BCD2,
    0xFBD90000, 0x015BF3DC, 0x08D7FEF0, 0xF80B7D51, 0xF7BECF4D, 0x07BF19BC, 0x41BEB2DE,
    0x417E9DCC, 0xB440D54E, 0x00D1F978, 0x3928784F, 0x22323C00, 0x73BE002D, 0x44001922,
    0x00000004, 0x00000000, 0x00648000, 0x2D221110, 0x4273BE00, 0x91E001C9, 0x7805E3E1,
    0x9E98C7C2, 0x898B4409, 0x41DF7877, 0x05F19DCE, 0xDF731FFC, 0xBF337FFB, 0x39EDF102,
    0x05FF7AC8, 0xDCBFDE30, 0x8F0009BF, 0xD40013BC, 0x0001A2FD, 0xB7580009, 0x5110004D,
    0xEEF8036F, 0xA57C005D, 0xF95F800B, 0xE55F8012, 0x5EDF8003, 0xF7580000, 0xBDEF7BDE,
    0x07FBDEF7, 0xBDEFB000, 0xEF7BDEF7, 0x0000001F, 0x00000000, 0xB0000000, 0xDEF7BDEF,
    0x0000177B, 0xEF7BDEFB, 0x000177BD, 0x00000000, 0x00000000, 0xFB000000, 0xBDEF7BDE,
    0x00005EF7, 0x04EF77E0, 0x009DE5D0, 0x004EF2CF, 0xC009DF3B, 0x00009FFB, 0x7BDEF758,
    0xDEF7BDEF, 0xB00007FB, 0xDEF7BDEF, 0x001FEF7B, 0x00000000, 0x00000000, 0xBDEFB000,
    0x177BDEF7, 0xDEFB0000, 0x77BDEF7B, 0x00000001, 0x00000000, 0x00000000, 0x7BDEFB00,
    0x5EF7BDEF, 0x7BCC0000, 0xE9BF400A, 0xBCAF402B, 0x31826F9F, 0xC6FD64F2, 0xFFBF180E,
    0x017FF9E0, 0xBDEEB000, 0xEF7BDEF7, 0x000FF7BD, 0xEF7BDF60, 0x3FDEF7BD, 0x00000000,
    0x00000000, 0xDF600000, 0xF7BDEF7B, 0xF600002E, 0x7BDEF7BD, 0x000002EF, 0x00000000,
    0x00000000, 0xBDF60000, 0xEF7BDEF7, 0xF90000BD, 0x69DF853F, 0x590E3278, 0x38C9E0B1,
    0xFF905964, 0x06DDF853, 0xDEF75800, 0xF7BDEF7B, 0x0007FBDE, 0xF7BDEFB0, 0x1FEF7BDE,
    0x00000000, 0x00000000, 0xEFB00000, 0x7BDEF7BD, 0xFB000017, 0xBDEF7BDE, 0x00000177,
    0x00000000, 0x00000000, 0xDEFB0000, 0xF7BDEF7B, 0x77C0005E, 0xBA57C2EF, 0xE25F2BF0,
    0x6FC0F957, 0x7B9E002F, 0x00000017, 0x00000000, 0x00000000, 0x00000000, 0x77E00000,
    0x3BCBA4EF, 0xD93BCB3D, 0xFFBC4EF9, 0xEF73C009, 0x00000002, 0x00000000, 0x00000000,
    0x00000000, 0xDE600000, 0xF4DFA053, 0xFDE57A15, 0x7918D37C, 0xC7637EB2, 0xCF07FDF8,
    0xF0000BFF, 0x0000BBDC, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x90000000, 0x9DF853FF, 0x590E327E, 0x438C9EB1, 0x53FF9596, 0x0006DDF8, 0x000BBDCF,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xDEF7BDC4,
    0x03DFFF7B, 0x77CF9000, 0xEF75001E, 0xE337FFBD, 0xF390006B, 0x001358FF, 0x001D0DF0,
    0x005E2B80, 0x000F48C0, 0x0000C940, 0x43DD721C, 0x00FF7BDD, 0xEB000013, 0xFBDEEA1E,
    0xC0000007, 0x021C0004, 0x01325000, 0x000F4A80, 0x000BC5A0, 0x007437E2, 0x6B2ED720,
    0x7BDEEA02, 0x35F99DFF, 0xF7CF1800, 0x3200007F, 0xF39DF101, 0x00FFBC95, 0xF3C44FFE,
    0x00ACFFBB, 0x5FDCE399, 0xC80FCC45, 0xCEFD43B3, 0x00000379, 0x8016F7FE, 0x378BEF71,
    0x03F90000, 0x000A7800, 0x80006F08, 0xF4001B29, 0xDC000B30, 0x318002F0, 0x7A000BE5,
    0x6E000598, 0x98C00178, 0x3D0005F2, 0x970002CC, 0x258C0017, 0x69D0005F, 0xBC380016,
    0x012C6000, 0x00027400, 0xB180001C, 0x177BBE00, 0x2E95F000, 0xBE57E000, 0x957E0004,
    0xB7E0000F, 0x00000017, 0x3DCFBD90, 0xF7A009BF, 0x3DEA211A, 0xA8ADF00F, 0x3379EF7D,
    0xB1EB09BE, 0x7B98837E, 0xAABE41E8, 0xCD113881, 0x2E402E17, 0x80144A95, 0x050C4F3F,
    0x493FC3C0, 0x0B898200, 0x00001480, 0x03800000, 0x00C91480, 0x0A919820, 0x47BF8780,
    0x8F3F8014, 0x58805C2F, 0x0D54E52A, 0x5D1A22F8, 0xF988AFD6, 0xB7E03D2F, 0x9EF77EA2,
    0x409BE337, 0x544235EF, 0xFC00079F, 0xA0009DEE, 0xE0013BCB, 0x0009DE59, 0x0013BE76,
    0x0013FF78, 0xDEC80000, 0x04DF9EE7, 0x108D7BD0, 0xF8079EF5, 0xF7BED456, 0x84DF19BC,
    0x41BF58F5, 0x20F43DCC, 0x9C40D55F, 0x170BE688, 0x254A9720, 0x279FC00A, 0xE1E00286,
    0xC100249F, 0x0A4005C4, 0x00000000, 0x8A4001C0, 0xCC100064, 0xC3C00548, 0xC00A23DF,
    0x2E17C79F, 0x72952C40, 0x117C06AA, 0x57EB2E8D, 0x1E97FCC4, 0xBF515BF0, 0xF19BCF7B,
    0x1AF7A04D, 0x03CFAA21, 0x00A7BCC0, 0x2BE9BF40, 0xFBCAF400, 0x318026F9, 0xC6FD64F2,
    0xFBF1800E, 0x17FF9E0F, 0xC8000000, 0xDF9EE7DE, 0x8D7BD004, 0x079EF510, 0xBED456F8,
    0xDF19BCF7, 0xBF58F584, 0xF43DCC41, 0x40D55F20, 0x0BE6889C, 0x4A972017, 0x9FC00A25,
    0xE0028627, 0x00249FE1, 0x4005C4C1, 0x0000000A, 0x4001C000, 0x1000648A, 0xC00548CC,
    0x0A23DFC3, 0x17C79FC0, 0x952C402E, 0x7C06AA72, 0xEB2E8D11, 0x97FCC457, 0x515BF01E,
    0x9BCF7BBF, 0xF7A04DF1, 0xCFAA211A, 0x04C80003, 0xAF9CEF88, 0xE007FDE4, 0xBF3C44FF,
    0x200ACFFB, 0xABFB9C73, 0xF201F988, 0x73BF50EC, 0x000000DE, 0xF73EF640, 0xDE8026FC,
    0xF7A8846B, 0xA2B7C03C, 0xCDE7BDF6, 0xC7AC26F8, 0xEE620DFA, 0xAAF907A1, 0x3444E206,
    0xB900B85F, 0x00512A54, 0x14313CFE, 0x24FF0F00, 0x2E260801, 0x00005200, 0x0E000000,
    0x03245200, 0x2A466080, 0x1EFE1E00, 0x3CFE0051, 0x620170BE, 0x355394A9, 0x74688BE0,
    0xE622BF59, 0xDF80F4BF, 0x7BDDFA8A, 0x026F8CDE, 0x5108D7BD, 0xFE401E7D, 0x1A77E14F,
    0x6438C9E0, 0x327802C5, 0x4016590E, 0x77E14FFE, 0x0000001B, 0xF3DCFBD9, 0xAF7A009B,
    0xF3DEA211, 0xDA8ADF00, 0xE3379EF7, 0xEB1EB09B, 0x87B98837, 0x1AABE41E, 0x7CD11388,
    0x52E402E1, 0xF80144A9, 0x0050C4F3, 0x0493FC3C, 0x00B89820, 0x00000148, 0x00380000,
    0x000C9148, 0x00A91982, 0x447BF878, 0xF8F3F801, 0xA58805C2, 0x80D54E52, 0x65D1A22F,
    0xFF988AFD, 0x2B7E03D2, 0x79EF77EA, 0xF409BE33, 0xF544235E, 0xC0366079, 0x6AEF3C37,
    0xB3FCF7E0, 0x2BF0D586, 0xD61FF195, 0x1F3CAFCB, 0x7EFCCBB1, 0xAFC0F9E5, 0x00F9E53C,
    0x201F906F, 0x101F904E, 0xE79561FF, 0xAB0FF883, 0x88F9E57F, 0x5F9AB0FF, 0xAC353E79,
    0x7CA95F86, 0xEFC0D5DE, 0x400027F9, 0xFD6201BF, 0x15BF3DCE, 0xF3011AE6, 0xBEA88576,
    0xFD07F3AB, 0x3DCEF8C6, 0x0747465F, 0x13F6796A, 0xF003D9E2, 0x34900FCA, 0xFC03F49E,
    0xCB87C862, 0xC3A9EA02, 0xDE00C965, 0xD22C3378, 0xD37CDE04, 0xCD400523, 0x6F0000B1,
    0x3A00201C, 0xC0110267, 0xA401A398, 0x982E3707, 0x1AD22592, 0xC5A4406B, 0x1B37CBE5,
    0x9A4F2E2C, 0x93E05E27, 0x598C5A0F, 0x9E1A1BE0, 0xFD419AC9, 0x2901F31E, 0xFEF73DE2,
    0xB305FA2A, 0x6215DB9E, 0x3A205EF4, 0xE77EB17E, 0x8812BD9E, 0x8000037B, 0x0005DEEF,
    0x0005D2BE, 0x004BE57E, 0x007CABF0, 0x005EDF80, 0xEF710000, 0x77BDE00B, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02410000,
    0x04F28418, 0xC474C940, 0x1F86F00F, 0x15F9E3CF, 0x133D37C6, 0x7BBF54DF, 0x0FCC7EEF,
    0x4235FFBC, 0x017FF58C, 0x04EF77E0, 0x04EF2E80, 0x13BCB3C0, 0x13BE7600, 0x09FFBC00,
    0xF7100000, 0x7BDE00BE, 0x00000007, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x24100000, 0x4F284180, 0x474C9400, 0xF86F00FC, 0x5F9E3CF1,
    0x33D37C61, 0xBBF54DF1, 0xFCC7EEF7, 0x235FFBC0, 0x17FF58C4, 0x014F7980, 0x2BE9BF40,
    0xFDE57A00, 0x8C60137C, 0xB1BF593C, 0xFF7E3003, 0x02FFF3C1, 0xDEE20000, 0xEF7BC017,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x04820000, 0x09E50830, 0x88E99280, 0x3F0DE01F, 0x2BF3C79E, 0x267A6F8C, 0xF77EA9BE,
    0x1F98FDDE, 0x846BFF78, 0x02FFEB18, 0xBF0A7FF2, 0xE32780D3, 0xF00B1590, 0x2CB21C64,
    0xE14FFE40, 0x00001B77, 0xC017DEE2, 0x0000EF7B, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08300482, 0x928009E5, 0xE01F88E9,
    0xC79E3F0D, 0x6F8C2BF3, 0xA9BE267A, 0xFDDEF77E, 0xFF781F98, 0xEB18846B, 0xDF8002FF,
    0x740013BD, 0x3C002779, 0xC0013BCB, 0x000277CE, 0x00027FEF, 0x7EF75800, 0xCEF77C00,
    0x30019E95, 0x1A6A631E, 0x867979A0, 0x7A95401A, 0xD340B970, 0xE0A31E30, 0x3A019E19,
    0x81A2BC34, 0x1CC3C69C, 0xD0DE0266, 0xC40344FC, 0x0D4CE72B, 0x36BF4AC0, 0x865A0026,
    0xA8A78006, 0x03870002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00077B9E,
    0x00000000, 0xBDF60000, 0x0ADF9EF7, 0x9DF54400, 0xEF7BDF60, 0x07DE3379, 0x7E1BCC40,
    0x1457C800, 0x00018A00, 0x00314000, 0x40144FC8, 0xB07E9BCC, 0xBCF7BDEF, 0x2003EF19,
    0xFB04EFAA, 0x6FCF7BDE, 0x00000005, 0x00000000, 0xEF7DE880, 0x5EC600EE, 0x00EEB183,
    0xF7BBE327, 0xA4F0B88B, 0x1AF3C3DF, 0x503C5703, 0x00034C4C, 0x004C5002, 0xA000C67C,
    0xAA600353, 0x0D846002, 0x800FE480, 0x8003CF28, 0x800B7C37, 0x017EA7FC, 0x2F987B18,
    0xE61FF100, 0x3F2E2000, 0x80012400, 0x92BD82E2, 0x3182C5A7, 0x97EF7FFA, 0xF78C05F1,
    0x82EE7249, 0xC005DEEF, 0xF800BA57, 0xF8012F95, 0xF8003E55, 0x000005ED, 0xFBDF778C,
    0xF778077F, 0x0BDCE41C, 0x7BECF4EF, 0xA625D0F7, 0x7F8C1BE7, 0x835F7C38, 0x3CF12C78,
    0xEF509009, 0x82DEF73E, 0x08E6FDF8, 0xBF3CAF80, 0x8C2DEF73, 0x400ABF32, 0x008001F1,
    0xCC078216, 0xC9DE1981, 0x8FF05F78, 0xB3DDEF78, 0x4AEE348A, 0xB36FDF51, 0x4EF77E00,
    0x09DE5D00, 0x04EF2CF0, 0x009DF3B0, 0x0009FFBC, 0xDF778C00, 0x78077FFB, 0xDCE41CF7,
    0xECF4EF0B, 0x25D0F77B, 0x8C1BE7A6, 0x5F7C387F, 0xF12C7883, 0x5090093C, 0xDEF73EEF,
    0xE6FDF882, 0x3CAF8008, 0x2DEF73BF, 0x0ABF328C, 0x8001F140, 0x07821600, 0xDE1981CC,
    0xF05F78C9, 0xDDEF788F, 0xEE348AB3, 0x6FDF514A, 0x4F7980B3, 0x7D37E801, 0xF795E805,
    0x46304DF3, 0xD8DFAC9E, 0x1FF7E301, 0x002FFF3C, 0xBEEF1800, 0xF00EFFF7, 0xB9C839EE,
    0xD9E9DE17, 0x4BA1EEF7, 0x1837CF4C, 0xBEF870FF, 0xE258F106, 0xA1201279, 0xBDEE7DDE,
    0xCDFBF105, 0x795F0011, 0x5BDEE77E, 0x157E6518, 0x0003E280, 0x0F042C01, 0xBC330398,
    0xE0BEF193, 0xBBDEF11F, 0xDC691567, 0xDFBEA295, 0x13200166, 0x2BE73BE2, 0xFF81FF79,
    0xEEFCF113, 0x1CC82B3F, 0x622AFEE7, 0x43B3C87E, 0x0379CEFD, 0xEEF18000, 0x00EFFF7B,
    0x9C839EEF, 0x9E9DE17B, 0xBA1EEF7D, 0x837CF4C4, 0xEF870FF1, 0x258F106B, 0x1201279E,
    0xDEE7DDEA, 0xDFBF105B, 0x95F0011C, 0xBDEE77E7, 0x57E65185, 0x003E2801, 0xF042C010,
    0xC3303980, 0x0BEF193B, 0xBDEF11FE, 0xC691567B, 0xFBEA295D, 0x3FF9166D, 0x7869DF85,
    0xB1590E32, 0x6438C9E0, 0x53FF9059, 0x0006DDF8, 0xBDF778C0, 0x778077FF, 0xBDCE41CF,
    0xBECF4EF0, 0x625D0F77, 0xF8C1BE7A, 0x35F7C387, 0xCF12C788, 0xF5090093, 0x2DEF73EE,
    0x8E6FDF88, 0xF3CAF800, 0xC2DEF73B, 0x00ABF328, 0x08001F14, 0xC0782160, 0x9DE1981C,
    0xFF05F78C, 0x3DDEF788, 0xAEE348AB, 0x36FDF514, 0x4E77C40B, 0xEEAFF803, 0x78C602F9,
    0x00177CE7, 0x9FA31800, 0xFF802EF9, 0x017CF5FC, 0x01A73BE2, 0xF778C000, 0x8077FFBD,
    0xCE41CF77, 0xCF4EF0BD, 0x5D0F77BE, 0xC1BE7A62, 0xF7C387F8, 0x12C78835, 0x090093CF,
    0xEF73EEF5, 0x6FDF882D, 0xCAF8008E, 0xDEF73BF3, 0xABF328C2, 0x001F1400, 0x78216008,
    0xE1981CC0, 0x05F78C9D, 0xDEF788FF, 0xE348AB3D, 0xFDF514AE, 0x77F30B36, 0xE42DF9EE,
    0xB7E7BFFB, 0x42B7EE40, 0x7B58EF54, 0x27FEA8A6, 0xF7FF30EE, 0x6A3BB1B4, 0x1E46FBDF,
    0x8A6F9A66, 0x1BF548F5, 0x2298CFCC, 0x8341C0FC, 0x39D6FE1A, 0x00631609, 0xE001078F,
    0xD4111C01, 0x77BDCFBB, 0xF7BDEF33, 0xFDF0DBDE, 0x000008E6, 0x73BF23D6, 0xBDF4DDEF,
    0xEF7BDEF7, 0xFD89F1BD, 0x4007F004, 0x02A0027A, 0x2280B080, 0x6587807E, 0xDBB3C9BC,
    0xF115F9E3, 0x87A5BEFC, 0x1BF7BFF9, 0xD46F7DF1, 0x55F3DEEF, 0xC847BB10, 0x7B98FBEA,
    0x77D5108D, 0xF73BF981, 0xFB101EFC, 0xFDF510AD, 0x7D11FF02, 0xA3EA59EE, 0xD10ADF87,
    0x3D531EAD, 0xC23B8560, 0x0F1ACC06, 0x37BFD003, 0x00000058, 0x21E002C1, 0x08C63901,
    0x6DD9C07F, 0xC33C07AA, 0x856FC3D1, 0xF0F53F58, 0x9EE7D11F, 0xF621FA8E, 0xDF9E215B,
    0xE45F980F, 0x91E00AFD, 0xFBA80277, 0x01200345, 0x009B6EB0, 0xC06DEA22, 0xE002EF77,
    0xFC005D2B, 0xFC0097CA, 0xFC001F2A, 0x000002F6, 0xFFDCEFD4, 0x57EFC057, 0x0BDF9F21,
    0xFEE7D2BF, 0x4AB1731F, 0x795F90AF, 0x702C6BC3, 0x03F0AAC5, 0x00C1EC2A, 0xDDF8710C,
    0x37BDEF7B, 0xF0E0004D, 0x7BDEF7BF, 0x64FFBDEF, 0x00E15002, 0x00F3CB10, 0xBE9D4EDF,
    0xE4F7EA4E, 0xFF587B14, 0x5F157F7B, 0x527BFB11, 0xE005BE8C, 0xD004EF77, 0xCF009DE5,
    0x3B004EF2, 0xFBC009DF, 0x8000009F, 0xFFFB9DFA, 0x2AFDF80A, 0xE17BF3E4, 0xFFDCFA57,
    0xE9562E63, 0x6F2BF215, 0xAE058D78, 0x407E1558, 0x80183D85, 0x7BBF0E21, 0xA6F7BDEF,
    0xFE1C0009, 0xEF7BDEF7, 0x4C9FF7BD, 0x001C2A00, 0xE01E7962, 0xD7D3A9DB, 0x9C9EFD49,
    0x7FEB0F62, 0x2BE2AFEF, 0x8A4F7F62, 0x7980B7D1, 0x37E8014F, 0x95E8057D, 0x304DF3F7,
    0xDFAC9E46, 0xF7E301D8, 0x2FFF3C1F, 0x7EA00000, 0x02BFFEE7, 0xF90ABF7E, 0x95F85EFC,
    0x98FFF73E, 0x857A558B, 0x5E1BCAFC, 0x562B8163, 0x61501F85, 0x8860060F, 0x7BDEEFC3,
    0x0269BDEF, 0xBDFF8700, 0xEF7BDEF7, 0x801327FD, 0x5880070A, 0x76F8079E, 0x5275F4EA,
    0xD8A727BF, 0xFBDFFAC3, 0xD88AF8AB, 0xF46293DF, 0x14FFE42D, 0xC9E1A77E, 0x82C56438,
    0x6590E327, 0xE14FFE41, 0x00001B77, 0xFFEE77EA, 0xABF7E02B, 0x85EFCF90, 0xFF73E95F,
    0xA558B98F, 0xBCAFC857, 0xB81635E1, 0x01F85562, 0x0060F615, 0xEEFC3886, 0x9BDEF7BD,
    0xF8700026, 0xBDEF7BDF, 0x327FDEF7, 0x0070A801, 0x8079E588, 0x5F4EA76F, 0x727BF527,
    0xFFAC3D8A, 0xAF8ABFBD, 0x293DFD88, 0xBBE2DF46, 0x5D2BE177, 0xF12F95F8, 0xB7E07CAB,
    0xF77E0017, 0x00000002, 0x00000000, 0x00000000, 0xDEEFC000, 0x7A779749, 0xF3B27796,
    0x13FF789D, 0x017BBF00, 0x00000000, 0x00000000, 0x00000000, 0x029EF300, 0xD0AFA6FD,
    0x9BE7EF2B, 0xF593C8C6, 0xEFC63B1B, 0x5FFE783F, 0xBDDF8000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0xE4000000, 0xA77E14FF, 0x56438C9F, 0x90E327AC, 0x14FFE565,
    0xC001B77E, 0x00005EEF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4AF67800,
    0xFFE8CE00, 0xFC0ED497, 0xEFAF678B, 0xFBF98597, 0xD8CFD14F, 0xCC2EC80F, 0x18D76A04,
    0xA3BC099E, 0xE09D09F7, 0xE27F25EC, 0x19E24607, 0x7FF78C16, 0xC4FE6FCF, 0xA299EF43,
    0xB5BF97DE, 0xFFBDDF8C, 0xD8D7C8C6, 0xD61DAE45, 0x43902E13, 0x9800316C, 0x8000001E,
    0xA4401E19, 0xC580A251, 0x406F0BEF, 0xE5B231B4, 0x711DA8BF, 0xDF8C6F99, 0xFF8CBFBD,
    0x306BDCC0, 0x64000EFA, 0xBE73BE22, 0xFC1FF792, 0x77E7889F, 0x732159FF, 0x88ABFB9C,
    0x876791F9, 0x06F39DFA, 0xFF77E000, 0xF3DFFDF2, 0x99ED407B, 0xF185BEA2, 0x5FDEFB3D,
    0x37EA24EA, 0x3F0797A8, 0x0011FC50, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
    0x177BBE00, 0x05D2BE00, 0x12F95F80, 0x07CABF00, 0x017B7E00, 0xBF980000, 0x026FCF73,
    0x510ADFB9, 0x1DC44EEF, 0x8E9EE7D1, 0xBF4E8371, 0x64FD6215, 0xC079E98B, 0x38B198F3,
    0x3CBAC380, 0x049B8780, 0x80001820, 0xB8C90024, 0x2DC5803C, 0xF2B2E00E, 0x1E7814F1,
    0xB7D2FC33, 0x6C9FAC42, 0x73E88EE2, 0x81B8C74F, 0xA8856FDC, 0xBF002777, 0x5D00277B,
    0x59E009DE, 0xCEC009DE, 0xFDE00277, 0x0000004F, 0xF9EE77F3, 0x5BF7204D, 0x89DDEA21,
    0xDCFA23B8, 0xD06E31D3, 0xAC42B7E9, 0x3D316C9F, 0x331E780F, 0x58700716, 0x70F00797,
    0x03040093, 0x20049000, 0xB0079719, 0x5C01C5B8, 0x029E3E56, 0x5F8663CF, 0xF58856FA,
    0x11DC4D93, 0x18E9EE7D, 0xADFB9037, 0x04EEF510, 0x0014F798, 0x00AFA6FD, 0x7CFDE57A,
    0x4F231813, 0x00EC6FD6, 0x3C1FF7E3, 0x00002FFF, 0x7B9DFCC0, 0xFDC8137E, 0x777A8856,
    0x3E88EE22, 0x1B8C74F7, 0x10ADFA74, 0x4C5B27EB, 0xC79E03CF, 0x1C01C58C, 0x3C01E5D6,
    0xC10024DC, 0x01240000, 0x01E5C648, 0x00716E2C, 0xA78F9597, 0xE198F3C0, 0x6215BE97,
    0x771364FD, 0x3A7B9F44, 0x7EE40DC6, 0x3BBD442B, 0xC4132001, 0xF257CE77, 0x4FFE03FE,
    0xFFBBF3C4, 0x38E640AC, 0xF31157F7, 0xD43B3C83, 0x00379CEF, 0x3BF98000, 0x9026FCF7,
    0xF510ADFB, 0x11DC44EE, 0x18E9EE7D, 0x5BF4E837, 0xB64FD621, 0x3C079E98, 0x038B198F,
    0x03CBAC38, 0x0049B878, 0x48000182, 0xCB8C9002, 0xE2DC5803, 0x1F2B2E00, 0x31E7814F,
    0x2B7D2FC3, 0x26C9FAC4, 0xF73E88EE, 0xC81B8C74, 0x7A8856FD, 0x4FFE4277, 0x3C1A77E1,
    0x58AC8719, 0x6438C9E0, 0xA7FF2059, 0x000DBBF0, 0xB9DFCC00, 0xDC8137E7, 0x77A8856F,
    0xE88EE227, 0xB8C74F73, 0x0ADFA741, 0xC5B27EB1, 0x79E03CF4, 0xC01C58CC, 0xC01E5D61,
    0x10024DC3, 0x1240000C, 0x1E5C6480, 0x0716E2C0, 0x78F95970, 0x198F3C0A, 0x215BE97E,
    0x71364FD6, 0xA7B9F447, 0xEE40DC63, 0xBBD442B7, 0x179F6013, 0x02623500, 0x004C46A0,
    0x0005E7D8, 0x7B800000, 0xDEF7BDEF, 0xF7BDEF7B, 0x7BDC0005, 0xDEF7BDEF, 0x2FBDEF7B,
    0x00000000, 0xA002F3EC, 0xD4004C46, 0xA0000988, 0xF78004DE, 0xCEFCF049, 0x5F2FBF3D,
    0x8855FD88, 0x8FF82C7A, 0x714F73E8, 0xADF87783, 0x9FCA4F10, 0x8AC1EA58, 0xC2B27A77,
    0xC7D47781, 0x456167F3, 0xF1209C1B, 0x5604828E, 0xEF241034, 0x967F1028, 0x5FE28D15,
    0xE1477AE1, 0xF3CB13CF, 0x9E9A8BC5, 0x2589E9D4, 0xC47F27D6, 0xA7BFF14D, 0x8C606F23,
    0xFDEA2151, 0x7F71BC27, 0x04DF9EE7, 0xEF8000F4, 0x2BE005DE, 0xE57E005D, 0xCABF004B,
    0x5EDF8007, 0xEEFC0000, 0x0FEF701F, 0x00000000, 0x00000000, 0x00000000, 0x80000000,
    0x29FC0090, 0x7784F0B0, 0xB646DE30, 0xF9EEF7DC, 0x42AFE624, 0xF001F7D4, 0x740277BB,
    0x59E02779, 0xF3B009DE, 0xFFDE009D, 0x77E00004, 0x7F7B80FF, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4FE00484, 0xBC278581, 0xB236F183, 0xCF77BEE5, 0x157F3127,
    0x300FBEA2, 0x7E8029EF, 0xAF4057D3, 0xC26F9FBC, 0x7EB27918, 0xEFC60763, 0x5FFE783F,
    0xF77E0000, 0x07F7B80F, 0x00000000, 0x00000000, 0x00000000, 0x40000000, 0x14FE0048,
    0x3BC27858, 0x5B236F18, 0x7CF77BEE, 0x2157F312, 0xFF20FBEA, 0x8D3BF0A7, 0x1590E327,
    0x21C64F0B, 0x4FFE42CB, 0x001B77E1, 0xC07FBBF0, 0x00003FBD, 0x00000000, 0x00000000,
    0x00000000, 0x02420000, 0xC2C0A7F0, 0x78C1DE13, 0xDF72D91B, 0x9893E7BB, 0xDF510ABF,
    0xBDDF8007, 0x77974013, 0x3BCB3C02, 0x277CEC01, 0x027FEF00, 0x7DEFA000, 0x7FB7BA80,
    0x6FCFE05C, 0x632C050C, 0x460789F8, 0xF0B931F8, 0xC14A21E3, 0x3C4712A3, 0x2787F48C,
    0xCA058A1C, 0xC02A7E13, 0x01C39511, 0x3C479D2A, 0x53F3C780, 0x1C313F00, 0x02883180,
    0x500163F0, 0x723C007C, 0x0079F000, 0xA007C318, 0xFF01278E, 0x03F1CBFB, 0x03FE6298,
    0x000FEF70, 0x00000000, 0x00000000, 0xF3000000, 0x03BFEE77, 0x215BDFAC, 0x9E301DD7,
    0xC4B3DCF7, 0x19FF103F, 0x9E345BA2, 0x005A5601, 0xE000C478, 0x026004CF, 0x02000580,
    0x0099FC00, 0x0CF0623C, 0xFC44D2B0, 0xF96E8867, 0xEE7BE462, 0xD604E259, 0xBAE42B7E,
    0x73BF9803, 0x00001DFF, 0x00000000, 0xC8000000, 0x4EFC29FF, 0xC87193C3, 0xC64F058A,
    0xFC82CB21, 0x36EFC29F, 0xFBDF4000, 0xFF6F7500, 0xDF9FC0B8, 0xC6580A18, 0x8C0F13F0,
    0xE17263F0, 0x829443C7, 0x788E2547, 0x4F0FE918, 0x940B1438, 0x8054FC27, 0x03872A23,
    0x788F3A54, 0xA7E78F00, 0x38627E00, 0x05106300, 0xA002C7E0, 0xE47800F8, 0x00F3E000,
    0x400F8630, 0xFE024F1D, 0x07E397F7, 0x07FCC530, 0x00000000

  EW_FONT_KERNING_CODES( ResourcesFontLarge )
  EW_FONT_KERNING_VALUES( ResourcesFontLarge )
EW_END_OF_FONT_RES( ResourcesFontLarge )

/* Table with links to derived variants of the font resource : 'Resources::FontLarge' */
EW_RES_WITHOUT_VARIANTS( ResourcesFontLarge )

/* Embedded Wizard */
