/*
 * The Clear BSD License
 * Copyright (c) 2017, NXP Semiconductors, Inc.
 * All rights reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer below) provided
 *  that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS LICENSE.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "board.h"
#include "fsl_usart.h"
#include "pin_mux.h"
#include "fsl_swm.h"
#include <stdbool.h>
/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/
/*!
 * @brief Main function
 */
int main(void)
{
    
    /* Get 9Mhz of main clock from 18MHz of FRO. */	
		BOARD_BootClockFRO18M();
		
		/* Enable SWM clock. */
    CLOCK_EnableClock(kCLOCK_Swm);
		/* Configure pin PIO0_8 for USART0 clock output. */
    SWM_SetMovablePinSelect(SWM0, kSWM_USART0_SCLK, kSWM_PortPin_P0_8);
		/* Disable SWM clock for saving power. */
    CLOCK_DisableClock(kCLOCK_Swm);
	
		/* Select the main clock as source clock of frg0. */
    CLOCK_Select(kFRG0_Clk_From_MainClk);
			
		/* Enable USART0 clock. */
    CLOCK_EnableClock(kCLOCK_Uart0);
		
		/* Set USART0 clock to 1.8Mhz divided by 5. */
		USART_SetBRGValue(USART0, 4);
				
		/* Select synchronous master mode and enable USART0. */
		USART0->CFG |= USART_CFG_SYNCEN(1) | USART_CFG_SYNCMST(1) | USART_CFG_ENABLE(1); 
		
		/* Generate continuous USART0 clock output. */
		USART0->CTL |= USART_CTL_CC(1);
		
		/* To start the clock output, select frg0 clock as source clock of USART0. */
    CLOCK_Select(kUART0_Clk_From_Frg0Clk);
		
		
		/* To stop the clock output, select none as source clock of USART0. 
    CLOCK_Select(CLK_MUX_DEFINE(UART0CLKSEL, 7U));*/
		/* To start the clock output, select frg0 clock as source clock of USART0. 
    CLOCK_Select(kUART0_Clk_From_Frg0Clk);*/
		
		while(1);
}
