/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _IIC_CONFIG_H
#define _IIC_CONFIG_H

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/** Macro for SUCCESS */
#define SUCCESS	                                    (uint8)1

/** Macro for FAILURE */
#define	FAIL	                                    (uint8)2

#define SET_I2C_BAUD_RATE(x)                                   { I2C1->F &= ~I2C_F_ICR_MASK; I2C1->F |= I2C_F_ICR(x); }

/*******************************************************************************
* Prototypes
******************************************************************************/
extern void IIC_Init(void);
extern void I2CStop(void);
extern void IICWriteData(uint32 ulnAddress,uint8 *pucData,uint16 NBytes);
extern void IICReadData(uint32 ulnAddress,uint8 *pucData,uint16 NBytes);
extern void I2CModuleInit(void);
#endif /*_IIC_CONFIG_H ends*/