/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "lcd.h"
#include "common.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/
uint8 LCDArray[NUM_FRONTPLANEPINS];

/*******************************************************************************
* Prototypes
******************************************************************************/
uint8 FrontPlanePins[]={19,20,21,22,23,24,25,26,28,30,31,32,33,34,35};
uint8 BackPlanePins[] ={6,7,8,14,15,16,17,18};

const uint8 lcd_char_table[] = {

    // ' ' (Space)
    LCD_SEG_NONE,

    // '-' (Minus Sign)
    LCD_SEG_G,

    // '0'
    LCD_SEG_F | LCD_SEG_E | LCD_SEG_A | LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,

    // '1'
    LCD_SEG_B | LCD_SEG_C,

    // '2'
    LCD_SEG_G | LCD_SEG_E | LCD_SEG_A | LCD_SEG_B | LCD_SEG_D,

    // '3'
    LCD_SEG_G | LCD_SEG_A | LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,

    // '4'
    LCD_SEG_F | LCD_SEG_G | LCD_SEG_B | LCD_SEG_C,

    // '5'
    LCD_SEG_F | LCD_SEG_G | LCD_SEG_A | LCD_SEG_C | LCD_SEG_D,

    // '6'
    LCD_SEG_F | LCD_SEG_E | LCD_SEG_G | LCD_SEG_A | LCD_SEG_D | LCD_SEG_C,

    // '7'
    LCD_SEG_A | LCD_SEG_B | LCD_SEG_C,

    // '8'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_G | LCD_SEG_A | LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,

    // '9'
    LCD_SEG_F | LCD_SEG_G | LCD_SEG_A | LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,

    // 'A'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_G | LCD_SEG_A | LCD_SEG_B | LCD_SEG_C,

    // 'B'
    LCD_SEG_F | LCD_SEG_G | LCD_SEG_E | LCD_SEG_C | LCD_SEG_D,

    // 'C'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_A | LCD_SEG_D,

    // 'D'
    LCD_SEG_G | LCD_SEG_E | LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,

    // 'E'
    LCD_SEG_G | LCD_SEG_F | LCD_SEG_E | LCD_SEG_A | LCD_SEG_D,

    // 'F'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_G | LCD_SEG_A,

    // 'G'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_G | LCD_SEG_A | LCD_SEG_C | LCD_SEG_D,

    // 'H'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_G | LCD_SEG_B | LCD_SEG_C,

    // 'I'
    LCD_SEG_E | LCD_SEG_F,

    // 'J'
    LCD_SEG_E | LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,

    // 'K'
    LCD_SEG_NONE,

    // 'L'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_D,

    // 'M'
    LCD_SEG_E | LCD_SEG_C | LCD_SEG_G,

    // 'N'
    LCD_SEG_E | LCD_SEG_C | LCD_SEG_G,

    // 'O'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_A | LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,

    // 'P'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_G | LCD_SEG_A | LCD_SEG_B,

    // 'Q'
    LCD_SEG_NONE,

    // 'R'
    LCD_SEG_E | LCD_SEG_G,

    // 'S'
    LCD_SEG_G | LCD_SEG_F | LCD_SEG_A | LCD_SEG_C |LCD_SEG_D,

    // 'T'
    LCD_SEG_G | LCD_SEG_F | LCD_SEG_E | LCD_SEG_D,

    // 'U'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_C | LCD_SEG_B | LCD_SEG_D,

    // 'V'
    LCD_SEG_E | LCD_SEG_F | LCD_SEG_C | LCD_SEG_B | LCD_SEG_D,

    // 'W'
    LCD_SEG_NONE,

    // 'X'
    LCD_SEG_NONE,

    // 'Y'
    LCD_SEG_F | LCD_SEG_G | LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,

    // 'Z'
    LCD_SEG_E | LCD_SEG_G | LCD_SEG_A | LCD_SEG_B | LCD_SEG_D,
};

/*******************************************************************************
 * Code
 ******************************************************************************/
/*!
 * @brief Finds the given character in the characters table.
 */
uint8 LCDFindChar(uint8 character)
{
  if(character == '-')
    return(LCD_CHAR_DASH);
  else if(character >= '0' && character <= '9')
    return(character - '0' + LCD_CHAR_0);
  else if(character >= 'A' && character <= 'Z')
    return(character - 'A' + LCD_CHAR_A);
  else if(character >= 'a' && character <= 'z')
    return(character - 'a' + LCD_CHAR_A);
  else
    return(LCD_CHAR_SPACE);
}
