/*
 * Copyright (c) 2010-2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __USERINTERFACE_H
#define __USERINTERFACE_H

#include "EEPROMAddrs.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/** Macro defined for ON state */
#define ON                                  (uint8)1

/** Macro defined for OFF state */
#define OFF                                 (uint8)2

/* ---------------------------------------------------------- */
#define DispConfigAddr   (DispAddr)
#define AutoDispTable    (DispAddr+0x20)
#define ManualDispTable  (DispAddr+0x80)
#define BattDispTable    (DispAddr+0x100)
#define DISPSIGN         0xBEEA
   
/* Max display param sizes: MaxPushDisps the highest */ 
#define MaxAutoDisps     0x60
#define MaxBattDisps     0x60
#define MaxPushDisps     0x80

#define MaxHRDisps       0x05
   
#define MaxBattDispsPerDay 20

/* Timeouts for display mode exit/entry */
#define DispManualExitTO   (10)
   

#define nBattModeDisps 6
typedef enum
{
  DISP_AUTO,
  DISP_MANUAL,
  DISP_BATTERY,
  nDISPMODES
}DISPMODES;

typedef enum
{
  DISP_ALL_ON = 0x10,
  DISP_VRMS,
  DISP_IRMS_PH,
  DISP_IRMS_N,
  DISP_IRMS,
  DISP_POWER_ACT,
  DISP_POWER_REACT,
  DISP_POWER_APP,
  DISP_PF,
  DISP_FREQ,
  DISP_DATE,
  DISP_TIME,
  DISP_METER_SNO,
  DISP_METER_REVNO,
  DISP_MANU_DATE,
  nDISPLAYS
}DISPLAY_PARAMS;

typedef enum
{
  DISP_MDTYPE_kW,
  DISP_MDTYPE_kVA,
  nDISP_MDTYPES,
} DISP_MDTYPES;

typedef enum
{
  DISP_POWERTYPE_kW,
  DISP_POWERTYPE_kVAr,
  DISP_POWERTYPE_kVA,
  nDISP_POWERTYPES,
} DISP_POWERTYPES;


typedef struct
{
  uint8  DispAutoSize;
  uint8  DispBattSize;
  uint8  DispManualSize;
  uint8  DispAutoTime;
  uint8  DispManualTime;
  uint8  DispBattCounts;
  uint16 DispSign;
}tDispConfig;

typedef enum
{
  DISP_DISPDATE,
  DISP_DISPTIME,
}DISP_DATETIME;

typedef enum
{
  FWTYPE_COMS,
  FWTYPE_COMB,
  FWTYPE_BLDR,
  nFWTYPES
}FWType_t;

/*******************************************************************************
* Prototypes
******************************************************************************/
extern vuint16 lcd_refresh_count;
extern vuint16 lcd_scroll_count;
extern uint8 DisplayMode;
extern uint8 DispMDTypes;
extern uint8 DispPowerTypes;
extern uint8 DownScroll;
extern uint8 UpScroll;
extern uint8 DispIndex;
extern tDispConfig DispConfig;
extern uint8 AutoScrollParam[MaxAutoDisps];
extern uint8 ManualScrollParam[MaxPushDisps];

/*
 * -----------------------------------------------------
 * User Interface Application Global Function Prototypes
 * -----------------------------------------------------
 */
extern void Display(void);
/*
 * -------------------------------------
 * LCD Driver Global Function Prototypes
 * -------------------------------------
 */
extern void LCDInit(void);
extern void LCDClear(void);
extern void UserInterfaceInit(void);
extern void LCDModuleInit(void);
extern void LCDPrintInitString(void);
extern void LCDModuleInitVal(uint32 Val);

extern void lcd_PrintString(void);
extern void UserInterface(void);
extern void ShutDownGPIOs(void);
extern void DisplayErase(void);
extern void DisplayDone(void);
#endif
