/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef DEFINE_H
#define DEFINE_H

#include "common.h"
#include "stdlib.h"
#include "stdarg.h"

#include "string.h"
#include "fsl_gpio.h"
#include "fsl_port.h"
#include "iohw.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* iRTC macros */
#define TAMPER0_BIT                     (1<<kIRTC_Tamper_0)
#define IRTC_TAMPER0_CONFIG             IRTC_TAMPER_PIN_POL_HIGH_CONFIG(TAMPER_FILT_CLK_2HZ,10)
#define TAMPER1_BIT                     (1<<kIRTC_Tamper_1)
#define IRTC_TAMPER1_HIGH_CONFIG        IRTC_TAMPER_PIN_POL_HIGH_CONFIG(TAMPER_FILT_CLK_2HZ,5)
#define IRTC_TAMPER1_LOW_CONFIG         IRTC_TAMPER_PIN_POL_LOW_CONFIG(TAMPER_FILT_CLK_2HZ,5)
#define TAMPER2_BIT                     (1<<kIRTC_Tamper_2)
#ifdef TOPEN
#define IRTC_TAMPER2_HIGH_CONFIG        IRTC_TAMPER_PIN_POL_HIGH_CONFIG(TAMPER_FILT_CLK_2HZ,5)
#define IRTC_TAMPER2_LOW_CONFIG         IRTC_TAMPER_PIN_POL_LOW_CONFIG(TAMPER_FILT_CLK_2HZ,5)
#else
#define IRTC_TAMPER2_CONFIG             IRTC_TAMPER_PIN_DI_CONFIG
#endif
#define IRTC_COPEN_CALLBACK             IRTC_TAMPER0_CALLBACK    // Cover Open Tamper
#define IRTC_MOPEN_CALLBACK             IRTC_TAMPER1_CALLBACK    // RF Open Tamper
#define IRTC_TOPEN_CALLBACK             IRTC_TAMPER2_CALLBACK    // Terminal cover Open Tamper
#define IRTC_COPEN_PIN                  kIRTC_Tamper_0
#define IRTC_MOPEN_PIN                  kIRTC_Tamper_1
#define IRTC_TOPEN_PIN                  kIRTC_Tamper_2
#define IRTC_COPEN_FILTER_CFG_BIT       (RTC->FILTER01_CFG & RTC_FILTER01_CFG_POL0_MASK)  
#define IRTC_MOPEN_FILTER_CFG_BIT       (RTC->FILTER01_CFG & RTC_FILTER01_CFG_POL1_MASK)
#define IRTC_TOPEN_FILTER_CFG_BIT       (RTC->FILTER2_CFG & RTC_FILTER2_CFG_POL2_MASK)
#ifdef TOPEN
#define RTCInterruptsMask               (IRTC_TAMPER0_MASK | IRTC_TAMPER1_MASK | IRTC_TAMPER2_MASK)
#else
#define RTCInterruptsMask               (IRTC_TAMPER0_MASK | IRTC_TAMPER1_MASK)
#endif
   
/* Analog frontend macros */
#define PHASE_CURRENT_AFE_CH                    (0)
#define PHASE_CURRENT_AFE_INIT                  AFE_CH0_Init
#define PHASE_CURRENT_AFE_INTERRUPT_PRIORITY    AFE0_INTERRUPT_PRIORITY
#define PHASE_CURRENT_AFE_CH_RR                 AFE->RR[0]
#define NEUTRAL_CURRENT_AFE_CH                  (1)
#define NEUTRAL_CURRENT_AFE_INIT                AFE_CH1_Init
#define NEUTRAL_CURRENT_AFE_INTERRUPT_PRIORITY  AFE1_INTERRUPT_PRIORITY
#define NEUTRAL_CURRENT_AFE_CH_RR               AFE->RR[1]
#define VOLTAGE_AFE_CH                          (2)
#define VOLTAGE_AFE_INIT                        AFE_CH2_Init
#define VOLTAGE_AFE_INTERRUPT_PRIORITY          AFE2_INTERRUPT_PRIORITY
#define VOLTAGE_AFE_CH_RR                       AFE->RR[2]
#define VOLTAGE_AFE_XBAR_COC                    kXBAR_InputAfeCh2CocFlag
#define V_Callback                              AFE_CH2_IRQHandler 
#define AFE_CR_COMBINED_MASK                    (AFE_CR_SOFT_TRG0_MASK | AFE_CR_SOFT_TRG1_MASK | AFE_CR_SOFT_TRG2_MASK)
#define CMP_IP_PSEL                             2U
#define CMP_INIT                                CMP2_Init
#define XBAR_CMPOUT                             kXBAR_InputCmp1Output
#define CMP_IP_NSEL                             7U
#define FREQ_COUNTER_DIV                        8
#define FREQ_COUNTER_MODULE_CLK_DIV             BUS_CLK_DIV8

#define PHASE_PHERR_PERHZ                       0.00080f
#define NEUTRAL_PHERR_PERHZ                     0.00065f

/* ComPortDriver specific macros */
/* Optical port specific */
#define ENABLE_OPTICAL_UART_PORT_CLK            (SIM->SCGC4|=SIM_SCGC4_UART0_MASK)
#define UART_OPTICAL_INIT                       UART0_Init
#define UART_BASE_PTR_OPTICAL                   UART0
#define UART_OPTICAL_GETCHAR                    UART_ReadByte(UART0)
#define UART_OPTICAL_PUTCHAR(c)                 UART_WriteByte(UART0,c)
#define UART_OPTICAL_CALLBACK                   UART0_CALLBACK
#define UART_OPTICAL_CLOCK                      SystemState.BusClk
#define UART_OPTICAL_TXPORT_INIT                PORT_SetPinMux(PORTF, UART_OPTICAL_TXPIN, kPORT_MuxAlt4)
#define UART_OPTICAL_RXPORT_INIT                PORT_SetPinMux(PORTF, UART_OPTICAL_RXPIN, kPORT_MuxAlt4)
#define UART_OPTICAL_TXPORT_MODULE_MODE         kPORT_MuxAlt4
#define UART_OPTICAL_RXPORT_MODULE_MODE         kPORT_MuxAlt4
#define UART_OPTICAL_TXPIN                      4U
#define UART_OPTICAL_RXPIN                      3U
#define UART_OPTICAL_C2                         UART0->C2

/* Electrical (RS232,..) port specific */
#define ENABLE_ELEC_UART_PORT_CLK               (SIM->SCGC4|=SIM_SCGC4_UART3_MASK)
#define UART_ELEC_INIT                          UART3_Init
#define UART_BASE_PTR_ELEC                      UART3
#define UART_ELEC_GETCHAR                       UART_ReadByte(UART3)
#define UART_ELEC_PUTCHAR(c)                    UART_WriteByte(UART3,c)
#define UART_ELEC_CALLBACK                      UART3_CALLBACK
#define UART_ELEC_CLOCK                         mSystemState.SysClk
#define UART_ELEC_TXPORT_INIT                   PORT_SetPinMux(PORTC, UART_ELEC_TXPIN, kPORT_MuxAlt2)
#define UART_ELEC_RXPORT_INIT                   PORT_SetPinMux(PORTC, UART_ELEC_RXPIN, kPORT_MuxAlt2)
#define UART_ELEC_TXPORT_MODULE_MODE            kPORT_MuxAlt2
#define UART_ELEC_RXPORT_MODULE_MODE            kPORT_MuxAlt2
#define UART_ELEC_TXPIN                         2U
#define UART_ELEC_RXPIN                         3U
#define UART_ELEC_C2                            UART3->C2   

/* Mains_On/PFAL */
#define MAINS_ON_PORT                           PORTE
#define MAINS_ON_GPIO                           GPIOE
#define MAINS_ON_PIN                            5U
#define GPIO_GET_MAINS_ON                       GPIO_PinRead(GPIOE, MAINS_ON_PIN)
#define MAINS_ON_LLWU_PTE                       1U
   
/* Push Button Down */
#define PB_PORT                                 PORTA
#define PB_GPIO                                 GPIOA
#define PB_PIN                                  6U
#define GPIO_GET_PB                             GPIO_PinRead(GPIOA, PB_PIN)
#define PB_ACTIVE_LEVEL                         0
#define PB_LLWU_PTE                             14U

/* Magnet Sense */
#define MAG_PORT                                PORTD
#define MAG_GPIO                                GPIOD
#define MAG_PIN                                 4U
#define GPIO_GET_MAG                            GPIO_PinRead(GPIOD, MAG_PIN)
#define MAG_ACTIVE_LEVEL                        0

/* MD Reset */
#define MDR_PORT                                PORTE
#define MDR_GPIO                                GPIOE
#define MDR_PIN                                 0U
#define GPIO_GET_MDR                            GPIO_PinRead(GPIOE, MDR_PIN)
#define MDR_ACTIVE_LEVEL                        0

/* Coommunication latch */
#define COMMS_LATCH
#define COMMS_LATCH_PORT                	PORTC
#define COMMS_LATCH_GPIO                  	GPIOC
#define COMMS_LATCH_PIN				4U
#define COMMS_LATCH_OFF                         GPIO_PortClear(GPIOC,1<<COMMS_LATCH_PIN)
#define COMMS_LATCH_ON                          GPIO_PortSet(GPIOC,1<<COMMS_LATCH_PIN)   

/* kWh LED */
#define KWH_LED_PORT                            PORTA
#define KWH_LED_GPIO                            GPIOA
#define KWH_LED_PIN                             4U
#define ON_KWH_LED                              GPIO_PortClear(GPIOA,1<<KWH_LED_PIN)
#define OFF_KWH_LED                             GPIO_PortSet(GPIOA,1<<KWH_LED_PIN)

/* kVArh LED */
#define KVARH_LED_PORT    			            
#define KVARH_LED_GPIO                          
#define KVARH_LED_PIN                          	
#define ON_KVARHLED                             
#define OFF_KVARHLED                            
   
/* i2c */
#define I2C_MASTER_BASEADDR                     I2C1
#define SCL_PORT                                PORTF
#define SCL_GPIO                                GPIOF
#define SDA_PORT                                PORTF
#define SDA_GPIO                                GPIOF
#define SCL_PIN                                 5U
#define SDA_PIN                                 6U
#define CLR_SCL                                 GPIO_PortClear(GPIOF,(1<<SCL_PIN))
#define SET_SCL                                 GPIO_PortSet(GPIOF,(1<<SCL_PIN))
#define CLR_SDA                                 GPIO_PortClear(GPIOF,(1<<SDA_PIN))
#define SET_SDA                                 GPIO_PortSet(GPIOF,(1<<SDA_PIN))
  
/* RELAYONBOARD */
#define RELAYONBOARD   
#define RELAY_OPEN_PORT                         PORTC
#define RELAY_OPEN_GPIO                         GPIOC
#define RELAY_OPEN_PIN                          7U
#define RELAY_OPEN_HI                           GPIO_PortSet(GPIOC,1<<RELAY_OPEN_PIN)
#define RELAY_OPEN_LO                           GPIO_PortClear(GPIOC,1<<RELAY_OPEN_PIN)
#define RELAY_CLOSE_PORT                        PORTC
#define RELAY_CLOSE_GPIO                        GPIOC
#define RELAY_CLOSE_PIN                         6U
#define RELAY_CLOSE_HI                          GPIO_PortSet(GPIOC,1<<RELAY_CLOSE_PIN)
#define RELAY_CLOSE_LO                          GPIO_PortClear(GPIOC,1<<RELAY_CLOSE_PIN)

#define BLIT_PORT                            
#define BLIT_GPIO                            
#define BLIT_PIN                             
#define BLIT_ON                               
#define BLIT_OFF                              
             
#define SYS_FREQ_4MHZ       3996742
#define SYS_FREQ_2MHZ       1996742

#define INTERRUPT_FREQUENCY               (uint32)50
#define CNTS_IN_SEC                       (uint32)(1000/INTERRUPT_FREQUENCY)
#define ONE_SECOND_COUNTER                (uint16)(CNTS_IN_SEC)
#define TEN_MS_DELAY_2MHZ                 (uint32)10000

/* To implement FOTA on same flash for KM35Z512 */
#define FlashMemFOTA                      (1)
#define FlashMemFOTAStartAddr             0x00040000
#define FlashMemFOTAEndAddr               0x00080000
/*******************************************************************************
* Prototypes
******************************************************************************/
#endif
