/* touch_hal.c */
#include "touch_hal.h"

#include "fsl_power.h"
#include "fsl_gpio.h"
#include "fsl_swm.h"
#include "fsl_iocon.h"
#include "fsl_capt.h"

/* setup pins as captouch. */
void touch_hal_init_pins(void)
{
    /* Y. */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_10, IOCON_PIO_HYS_MASK); /* YH. */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_11, IOCON_PIO_HYS_MASK);  /* YL. */

    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_YH, kSWM_PortPin_P0_10);
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_YL, kSWM_PortPin_P0_11);

#if 1
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_4, IOCON_PIO_HYS_MASK); /*  X0.*/
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_13, IOCON_PIO_HYS_MASK); /* X1. */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_17, IOCON_PIO_HYS_MASK); /* X2. */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_16, IOCON_PIO_HYS_MASK); /* X3. */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_18, IOCON_PIO_HYS_MASK); /* X4 */
#endif

    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X0, kSWM_PortPin_P0_4); /* S1. */
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X1, kSWM_PortPin_P0_13); /* S2. */
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X2, kSWM_PortPin_P0_17); /* S3. */
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X3, kSWM_PortPin_P0_16); /* S4. */
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X4, kSWM_PortPin_P0_18); /* S5. */
}

/* setup pins as gpio, and grounded. */
void touch_hal_reset_pins(void)
{
    CLOCK_EnableClock(kCLOCK_Swm);
    CLOCK_EnableClock(kCLOCK_Gpio0);

    /* reset the swm connections. */
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_YH, kSWM_PortPin_Reset);
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_YL, kSWM_PortPin_Reset);

    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X0, kSWM_PortPin_Reset); /* S1. */
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X1, kSWM_PortPin_Reset); /* S2. */
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X2, kSWM_PortPin_Reset); /* S3. */
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X3, kSWM_PortPin_Reset); /* S4. */
    SWM_SetMovablePinSelect(SWM0, kSWM_CAPT_X4, kSWM_PortPin_Reset); /* S5. */

    /* setup up gpio. */
    gpio_pin_config_t gpio_pin_config;

    gpio_pin_config.pinDirection = kGPIO_DigitalOutput;
    gpio_pin_config.outputLogic = 0u;
    GPIO_PinInit(GPIO, 0u, 10u, &gpio_pin_config); /* YH. */
    GPIO_PinInit(GPIO, 0u, 11u, &gpio_pin_config); /* YL. */
    GPIO_PinInit(GPIO, 0u, 4u , &gpio_pin_config); /* X0. */
    GPIO_PinInit(GPIO, 0u, 13u, &gpio_pin_config); /* X1. */
    GPIO_PinInit(GPIO, 0u, 17u, &gpio_pin_config); /* X2. */
    GPIO_PinInit(GPIO, 0u, 16u, &gpio_pin_config); /* X3. */
    GPIO_PinInit(GPIO, 0u, 18u, &gpio_pin_config); /* X4. */
}

void touch_hal_init_capt(void)
{
    /* enable clocks. */
    CLOCK_EnableClock(kCLOCK_Iocon);
    CLOCK_EnableClock(kCLOCK_Swm);
    CLOCK_EnableClock(kCLOCK_Capt);

    /* setup clock. */
    CLOCK_Select(kCAPT_Clk_From_Fro);

    /* setup touch module. */
    while (0u != (CAPT_CTRL_INCHANGE_MASK & CAPT->CTRL) )
    {}
    CAPT->CTRL  = CAPT_CTRL_POLLMODE(0) /* inactive, scan later. */
                | CAPT_CTRL_TRIGGER(0) /* gpio mode. */
                | CAPT_CTRL_WAIT(0) /* WAIT when a touch event occurs.*/
                | CAPT_CTRL_FDIV(15000000u/3000000u) /* pulse clock freq. */
                | CAPT_CTRL_XPINUSE(1) /* 0: inactive x pins are high-z. 1: the inactive x pins are grounded. */
                | CAPT_CTRL_XPINSEL(0) /* x0-x3. */
                ;

    CAPT->POLL_TCNT = CAPT_POLL_TCNT_TCNT(0x0) /* threshold. */
                    | CAPT_POLL_TCNT_TOUT(0xC) /* timeout factor. */
                    | CAPT_POLL_TCNT_POLL(0) /* idle time between successive scan. */
                    | CAPT_POLL_TCNT_MDELAY(0x3)
                    | CAPT_POLL_TCNT_RDELAY(0x0)
                    | CAPT_POLL_TCNT_TCHLOW_ER(1)
                    ;

    /* disable all interrupts. */
    CAPT->INTENCLR = CAPT->INTENCLR;

    //touch_init_pins();
}

void touch_hal_enable_interrupt(void)
{
    /* clear flags. */
    CAPT->STATUS = CAPT->STATUS;

    /* nvic. */
    NVIC_EnableIRQ(CMP_CAPT_IRQn);

    /* capt. */
    CAPT->INTENSET = //CAPT_INTENSET_YESTOUCH_MASK
                   //| CAPT_INTENSET_NOTOUCH_MASK
                     CAPT_INTENSET_POLLDONE_MASK
                   | CAPT_INTENSET_TIMEOUT_MASK
                   | CAPT_INTENSET_OVERUN_MASK
                   ;
}

void touch_hal_disable_interrupt(void)
{

    /* capt. disable all interrupts. */
    CAPT->INTENCLR = CAPT->INTENCLR;

    /* nvic. */
    NVIC_DisableIRQ(CMP_CAPT_IRQn);
}

#if 0
uint16_t touch_hal_get_sensing_value_polling(uint32_t group_index)
{


    //while (0u != (CAPT_CTRL_INCHANGE_MASK & CAPT->CTRL) )
    //{}
    CAPT->CTRL &= ~(CAPT_CTRL_POLLMODE_MASK | CAPT_CTRL_XPINSEL_MASK);
    CAPT->CTRL |= (  CAPT_CTRL_POLLMODE(kCAPT_PollNowMode)
                              //| CAPT_CTRL_XPINSEL(0x1F & ~(1u << group_index))
                              | CAPT_CTRL_XPINSEL(1u << group_index)
                             );

    while (0u == (CAPT_STATUS_POLLDONE_MASK & CAPT->STATUS) )
    {}

    CAPT->STATUS = CAPT->STATUS; /* clear flags. */
    uint32_t val = CAPT->TOUCH & CAPT_TOUCH_COUNT_MASK;

    //while (0u != (CAPT_CTRL_INCHANGE_MASK & CAPT->CTRL) )
    //{}
    //CAPT->CTRL &= ~CAPT_CTRL_POLLMODE_MASK;

    return (uint16_t)val;
}
#endif

void touch_hal_start_conv(uint32_t channel_mask)
{
    CAPT->CTRL &= ~(CAPT_CTRL_POLLMODE_MASK | CAPT_CTRL_XPINSEL_MASK);
    CAPT->CTRL |= (  CAPT_CTRL_POLLMODE(kCAPT_PollNowMode)
                   | CAPT_CTRL_XPINSEL(channel_mask) /* 1u << index */
                  );

}

uint16_t touch_hal_read_conv(void)
{
    while (0u == (CAPT_STATUS_POLLDONE_MASK & CAPT->STATUS) )
    {}

    CAPT->STATUS = CAPT->STATUS; /* clear flags. */
    uint32_t val = CAPT->TOUCH & CAPT_TOUCH_COUNT_MASK;

    //while (0u != (CAPT_CTRL_INCHANGE_MASK & CAPT->CTRL) )
    //{}
    //CAPT->CTRL &= ~CAPT_CTRL_POLLMODE_MASK;

    return (uint16_t)val;
}

uint16_t touch_hal_read_conv_polling(uint16_t channel_mask)
{
    touch_hal_start_conv(channel_mask);
    return touch_hal_read_conv();
}

/* EOF. */

