/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

///////////////////////////////////////////////////////////////////////////////
//  Includes
///////////////////////////////////////////////////////////////////////////////

// SDK Included Files
#include "board.h"
#include "fsl_debug_console.h"
#include "qcom_api.h"
#include "wlan_qcom.h"

#include "pin_mux.h"
#include "clock_config.h"

#include "mqtt.h"
#include "config.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define APP_BOARD_TEST_LED_PORT 1U
#define APP_BOARD_TEST_LED_PIN 6U

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/

// 0 is the highest priority and priority 15 is the lowest priority
const int TASK_MAIN_PRIO       = configMAX_PRIORITIES - 3;
const int TASK_MAIN_STACK_SIZE = 4096;

portSTACK_TYPE *task_main_stack = NULL;
TaskHandle_t task_main_task_handler;



QCOM_SSID g_ssid             = {.ssid = (AP_SSID)};
QCOM_PASSPHRASE g_passphrase = {.passphrase = (AP_PASSPHRASE)};

WLAN_AUTH_MODE g_auth    = WLAN_AUTH_WPA2_PSK;
WLAN_CRYPT_TYPE g_cipher = WLAN_CRYPT_AES_CRYPT;

// ============================================================================
// Menu Handling
// ============================================================================

extern int numIrqs;
extern int initTime;

static void printSeparator(void)
{
    PRINTF("========================================\r\n");
}

static void menuConnectToAP(void)
{
    apConnect(&g_ssid, &g_passphrase, g_auth, g_cipher);
}



static void menuUdpServerStart(void)
{
    udpBind(9000);
}

enum STATE
{
    STATE_IDLE,
    STATE_CONNECTING,
    STATE_CONNECTED,
};
int state = STATE_IDLE;

static void menuAllStateMachine(void)
{
    if (state == STATE_IDLE)
        return;

    if (state == STATE_CONNECTING && isConnected())
    {
        state = STATE_CONNECTED;
        getDhcp();
        PRINTF("Connected to AP and IP address assigned\r\n");

        pingHost(NULL);

        menuUdpServerStart();

        state = STATE_IDLE;
    }
}


static void menuSeparator(void)
{
    printSeparator();
    PRINTF("numIrqs = %d, initTime = %d\r\n", numIrqs, initTime);

#if (INCLUDE_uxTaskGetStackHighWaterMark == 1)
    PRINTF("mainTask  watermark=%4d\r\n", uxTaskGetStackHighWaterMark(NULL) * sizeof(StackType_t));
    PRINTF("drvTask   watermark=%4d\r\n", uxTaskGetStackHighWaterMark(atheros_wifi_task_id) * sizeof(StackType_t));
#endif
    printHeapFree(NULL);

    extern TaskHandle_t atheros_wifi_task_id;
    extern TaskHandle_t task_main_task_handler;
    uint16_t wifiTaskPrio = uxTaskPriorityGet(atheros_wifi_task_id);
    uint16_t mainTaskPrio = uxTaskPriorityGet(task_main_task_handler);
    PRINTF("wifiPrio=%d, mainPrio=%d\r\n", wifiTaskPrio, mainTaskPrio);
}






// ============================================================================
// Main
// ============================================================================

static void print_version(void)
{
    ATH_VERSION_STR verstr;

    int res = qcom_get_versionstr(&verstr);
    if (A_OK == res)
    {
        PRINTF("Host version:      %s\r\n", verstr.host_ver);
        PRINTF("Target version:    %s\r\n", verstr.target_ver);
        PRINTF("Firmware version:  %s\r\n", verstr.wlan_ver);
        PRINTF("Interface version: %s\r\n", verstr.abi_ver);
    }
    else
    {
        PRINTF("ERROR: Failed to get QCA400X version information\r\n");
    }
}
void publish_callback(void** unused, struct mqtt_response_publish *published)
{
	uint8_t *cpTopic = calloc(1, published->topic_name_size + 1);
	if(cpTopic == NULL){
		return;
	}
	uint8_t *cpMessage = calloc(1, published->application_message_size + 1);
	if(cpMessage == NULL){
		free(cpTopic);
		return;
	}
	memcpy(cpTopic, published->topic_name, published->topic_name_size);
	memcpy(cpMessage, published->application_message, published->application_message_size);
	PRINTF("Received message:");
	PRINTF("    Topic is %s,", cpTopic);
	PRINTF("    message is %s.\r\n", cpMessage);
	if(memcmp(published->topic_name, CONFIG_TOPIC_NAME, published->topic_name_size) == 0){
		GPIO_PortToggle(GPIO, APP_BOARD_TEST_LED_PORT, 1u << APP_BOARD_TEST_LED_PIN);
	}
	free(cpTopic);
	free(cpMessage);
	return;
}
uint8_t sendbuf[2048]; /* sendbuf should be large enough to hold multiple whole mqtt messages */
uint8_t recvbuf[1024]; /* recvbuf should be large enough any whole mqtt message expected to be received */
struct mqtt_client client;
mqtt_pal_socket_handle  sockfd;	
void task_main(void *param)
{
    int32_t result = 0;
    (void)result;

    /* Initialize WIFI shield */
    result = WIFISHIELD_Init();
    assert(A_OK == result);

    /* Initialize the WIFI driver (thus starting the driver task) */
    result = wlan_driver_start();
    assert(A_OK == result);

    print_version();

    UBaseType_t numTasks = uxTaskGetNumberOfTasks();
    PRINTF("number of FreeRTOS tasks = %d\r\n", numTasks);
    DbgConsole_Flush();
    PRINTF("Entering main loop\r\n");

    printSeparator();
		PRINTF("Connect to router\r\n");
		menuConnectToAP();
		while(isConnected() == 0){}
		getDhcp();
		
		//httpGet(addr, 2000);	
		
		if (TLS_Init() != 0){
			PRINTF("ERROR: failed to initialize for TLS!\r\n");
			while(1);
		}
		sockfd = mqttbrokerconnect(CONFIG_BROKER_HOST_IP, 8883, 100);
		mqtt_do_tls_handshake();

    mqtt_init(&client, sockfd, sendbuf, sizeof(sendbuf), recvbuf, sizeof(recvbuf), publish_callback);
    mqtt_connect(&client, "Led_Control", NULL, NULL, 0, NULL, NULL, 0, 40);
		static int32_t senddelay = 2;
		char topic[] = "SYS";
		char application_message[] = "hello world!!!";
		mqtt_subscribe(&client, CONFIG_TOPIC_NAME, MQTT_PUBLISH_QOS_0);
    while (1)
    {
			mqtt_sync((struct mqtt_client*) &client);
      vTaskDelay(MSEC_TO_TICK(50));
			senddelay--;
			if (senddelay <= 0){
				PRINTF("Publish:");
				PRINTF("    Topic is %s,    Message is %s.\r\n", topic, application_message);
				mqtt_publish(&client, topic, application_message, strlen(application_message), MQTT_PUBLISH_QOS_0);
				senddelay = 50;
			}
    }
}

int main(void)
{
    BaseType_t result = 0;
		gpio_pin_config_t led_config = {
        kGPIO_DigitalOutput,
        0,
    };

    /* attach main clock divide to FLEXCOMM0 (debug console) */
    CLOCK_AttachClk(BOARD_DEBUG_UART_CLK_ATTACH);
		/* enable clock for GPIO*/
    CLOCK_EnableClock(kCLOCK_Gpio0);
    CLOCK_EnableClock(kCLOCK_Gpio1);
	
    BOARD_InitPins();
    BOARD_BootClockFROHF96M();
    BOARD_InitDebugConsole();
		
		/* Init output LED GPIO. */
    GPIO_PortInit(GPIO, APP_BOARD_TEST_LED_PORT);
    GPIO_PinInit(GPIO, APP_BOARD_TEST_LED_PORT, APP_BOARD_TEST_LED_PIN, &led_config);
    GPIO_PinWrite(GPIO, APP_BOARD_TEST_LED_PORT, APP_BOARD_TEST_LED_PIN, 1);

    result =
        xTaskCreate(task_main, "main", TASK_MAIN_STACK_SIZE, task_main_stack, TASK_MAIN_PRIO, &task_main_task_handler);
    assert(pdPASS == result);

    vTaskStartScheduler();
    for (;;)
        ;
}
