#include "board.h"
#include "fsl_debug_console.h"
#define STATIC
 
typedef struct {
    uint32_t    r0, r1, r2, r3, r12, lr, pc, xpsr;
} ExceptionRegisters_t; 
 

STATIC char *fmt_hex(uint32_t val, char *buf) {
    const char *hexDig = "0123456789abcdef";

    buf[0] = hexDig[(val >> 28) & 0x0f];
    buf[1] = hexDig[(val >> 24) & 0x0f];
    buf[2] = hexDig[(val >> 20) & 0x0f];
    buf[3] = hexDig[(val >> 16) & 0x0f];
    buf[4] = hexDig[(val >> 12) & 0x0f];
    buf[5] = hexDig[(val >>  8) & 0x0f];
    buf[6] = hexDig[(val >>  4) & 0x0f];
    buf[7] = hexDig[(val >>  0) & 0x0f];
    buf[8] = '\0';

    return buf;
}


STATIC void print_reg(const char *label, uint32_t val) {
    char hexStr[9];

    PRINTF(label);
    PRINTF(fmt_hex(val, hexStr));
    PRINTF("\r\n");
}


void HardFault_C_Handler(ExceptionRegisters_t *regs, uint32_t *pXtraRegs, uint32_t strType) {
    if ((regs->xpsr & 0xC000) && SCB->CFSR == 0x20000) {
		// INVSTATE with wrong xPSR (EPSR) values
		regs->xpsr &= ~0x0000C000;
		SCB->CFSR = SCB->CFSR;
		return;
	}
	#ifdef __CC_ARM
	__asm {
		bkpt	#0
	}
	return;
	#else
	__asm volatile ("bkpt #0");
	return;
	#endif


	/* rocky ignore
    // We need to disable the USB so it doesn't try to write data out on
    // the VCP and then block indefinitely waiting for the buffer to drain.
    pyb_usb_flags = 0;
	*/

    mp_hal_stdout_tx_str("HardFault\r\n");

    print_reg("R0    ", regs->r0);
    print_reg("R1    ", regs->r1);
    print_reg("R2    ", regs->r2);
    print_reg("R3    ", regs->r3);
    print_reg("R12   ", regs->r12);
    print_reg("SP    ", (uint32_t)regs);
    print_reg("LR    ", regs->lr);
    print_reg("PC    ", regs->pc);
    print_reg("XPSR  ", regs->xpsr);
	
	print_reg("R4    ", pXtraRegs[7]);
	print_reg("R5    ", pXtraRegs[6]);
	print_reg("R6    ", pXtraRegs[5]);
	print_reg("R7    ", pXtraRegs[4]);
	print_reg("R8    ", pXtraRegs[3]);
	print_reg("R9    ", pXtraRegs[2]);
	print_reg("R10   ", pXtraRegs[1]);
	print_reg("R11   ", pXtraRegs[0]);


    uint32_t cfsr = SCB->CFSR;

    print_reg("HFSR  ", SCB->HFSR);
    print_reg("CFSR  ", cfsr);
    if (cfsr & 0x80) {
        print_reg("MMFAR ", SCB->MMFAR);
    }
    if (cfsr & 0x8000) {
        print_reg("BFAR  ", SCB->BFAR);
    }

	#ifndef __CC_ARM
	__asm volatile ("bkpt #0");
	return;
	#endif

    /* Go to infinite loop when Hard Fault exception occurs */
	switch (strType) 
	{
	case 1:
		__fatal_error("MemManage fault");
		break;
	default:
		__fatal_error("HardFault");
		break;
	}
    
}

