/*
 * config.h
 *
 *  Created on: 11.06.2017
 *      Author: sawyer liu
 */

#ifndef CONFIG_H_
#define CONFIG_H_

// Hardwired SSID, passphrase, auth and cipher algo of AP to connect to
// Change this to fit your AP
#define AP_SSID "TP-LINK_4F57C6"
#define AP_PASSPHRASE "123456xu"

/* broker settings */
#define CONFIG_USE_BROKER_LOCAL                 (0) /* 1: use local mosquitto broker; 0: do not use local broker */
#define CONFIG_USE_BROKER_MOSQUITTO_TEST        (1) /* 1: use mosquitto test broker; 0: do not use mosquitto test broker */
#define CONFIG_USE_BROKER_ADAFRUIT              (0) /* 1: use Adafruit I/O broker; 0: do not use Adafruit broker */
#define CONFIG_USE_BROKER_AZURE                 (0) /* 1: use Azure I/O broker; 0: do not use Azure broker */
#define CONFIG_USE_BROKER_HSLU                  (0) /* 1: use HSLU broker; 0: do not use HSLU broker */

/* various configuration settings */
#define CONFIG_USE_SERVER_VERIFICATION          (1 && !CONFIG_USE_BROKER_HSLU && !CONFIG_USE_BROKER_AZURE) /* 1: verify server with certificate; 0: no server verification */
#define CONFIG_SERVER_REQUIRE_CERT							(1)




/* connection settings to broker */
#if CONFIG_USE_BROKER_ADAFRUIT
  #define CONFIG_BROKER_HOST_NAME       "io.adafruit.com"
  #define CONFIG_BROKER_HOST_IP         NULL
  #define CONFIG_CLIENT_ID_NAME         "FRDM-K64F" /* each client connected to the host has to use a unique ID */
  #define CONFIG_CLIENT_USER_NAME       "user name" /* Adafruit IO Username, keep it SECRET! */
  #define CONFIG_CLIENT_USER_PASSWORD   "AIO Key" /* Adafruit AIO Key, keep it SECRET! */
  #define CONFIG_TOPIC_NAME             "erichs/feeds/test"
#elif CONFIG_USE_BROKER_MOSQUITTO_TEST
  #define CONFIG_BROKER_HOST_NAME       "192.168.0.170"
  #define CONFIG_BROKER_HOST_IP         "192.168.0.170"
  #define CONFIG_CLIENT_ID_NAME         NULL
  #define CONFIG_CLIENT_USER_NAME       NULL /* no user name */
  #define CONFIG_CLIENT_USER_PASSWORD   NULL /* no password */
  #define CONFIG_TOPIC_NAME             "test"
#elif CONFIG_USE_BROKER_HSLU
  #define CONFIG_BROKER_HOST_NAME       "eee-00031"
  #define CONFIG_BROKER_HOST_IP         "192.168.0.118" /* raspberry pi running mosquitto */
  #define CONFIG_CLIENT_ID_NAME         "FRDM-K64F" /* each client connected to the host has to use a unique ID */
  #define CONFIG_CLIENT_USER_NAME       "tastyger" /* user name */
  #define CONFIG_CLIENT_USER_PASSWORD   "1234" /* dummy password */
  #define CONFIG_TOPIC_NAME             "tastyger/test" /* hard coded topic name to subscribe to */
#elif CONFIG_USE_BROKER_LOCAL
  #if CONFIG_USE_IN_WORK_NETWORK
    #define CONFIG_BROKER_HOST_NAME     NULL
    #define CONFIG_BROKER_HOST_IP       "10.9.4.26"
  #else
  #define CONFIG_BROKER_HOST_NAME       "ErichStyger-PC"
    #define CONFIG_BROKER_HOST_IP       "192.168.0.111"
  #endif
  #define CONFIG_CLIENT_ID_NAME         "FRDM-K64F" /* each client connected to the host has to use a unique ID */
  #define CONFIG_CLIENT_USER_NAME       NULL /* no user name */
  #define CONFIG_CLIENT_USER_PASSWORD   NULL /* no password */
  #define CONFIG_TOPIC_NAME             "HSLU/test"
#elif CONFIG_USE_BROKER_AZURE
  #define CONFIG_BROKER_HOST_NAME       "GrilloIOTHub.azure-devices.net" /* {iothubhostname} */
  #define CONFIG_CLIENT_ID_NAME         "Erich_Device" /* {deviceId} */
  #define CONFIG_CLIENT_USER_NAME       "GrilloIOTHub.azure-devices.net/Erich_Device/api-version=2016-11-14" /* {iothubhostname}/{device_id}/api-version=2016-11-14  */
  #define CONFIG_CLIENT_USER_PASSWORD   "SharedAccessSignature sr=GrilloIOTHub.azure-devices.net%2Fdevices%2FErich_Device&sig=ovxhASw4alEsJ6ncPAY8aaCZXFTT6OSz5%2BHvs7Rj7TY%3D&se=1493909811" /* part of SAS token */
  #define CONFIG_TOPIC_NAME             "devices/Erich_Device/messages/events/" /* devices/{deviceId}/events */
#endif

#endif /* CONFIG_H_ */
