/*
 * certificate.c
 *
 *  Created on: 19.04.2017
 *      Author: Erich Styger
 */

#include "certificate.h"

/* m2mqtt_srv.crt: see
 * https://mcuoneclipse.com/2017/04/14/enable-secure-communication-with-tls-and-the-mosquitto-broker/
 */

const char mbedtls_m2mqtt_srv_crt[] =
"-----BEGIN CERTIFICATE-----\r\n"
"MIIDIDCCAggCCQCUTXSPenGUBzANBgkqhkiG9w0BAQsFADBSMQswCQYDVQQGEwJD\r\n"
"SDEUMBIGA1UECAwLU3dpdHplcmxhbmQxEDAOBgNVBAcMB0x1Y2VybmUxDTALBgNV\r\n"
"BAoMBEhTTFUxDDAKBgNVBAsMA1QmQTAeFw0xNzA0MjMwNjQxMjdaFw0yNzA0MjEw\r\n"
"NjQxMjdaMFIxCzAJBgNVBAYTAkNIMRQwEgYDVQQIDAtTd2l0emVybGFuZDEQMA4G\r\n"
"A1UEBwwHTHVjZXJuZTENMAsGA1UECgwESFNMVTEMMAoGA1UECwwDVCZBMIIBIjAN\r\n"
"BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxGPL7lmqeDkq9Ah3DTieY0xQqV2Z\r\n"
"oxSHUUpQ10e+A7bhNbumREdRlQP1mHgaBX0IIiflNMHQ7WYZtrfFzVa09tguzN2o\r\n"
"PGhRp0aamKRYsfOa1rTZVy31zzHupKv+NlCi0LXqO1k8Tvvf/BbTa7GYB1hNwxdL\r\n"
"c53rRZtxqveHUt5vywA6jpdux6SL9wmzFcspHJ+WOjfp09SOrLFAc9S3HsBwnK9T\r\n"
"eDn7hVrR4I/6ne8mRLcCTtL1qLUcGHWc2lAep5hyZBKepSVxC5KaqoHlAOyyMVYJ\r\n"
"yDhQhJ0W4ovCKjurK2rpUDIgpjlxnCzNr6xtGXvScRFklF94PiH4x7O4DQIDAQAB\r\n"
"MA0GCSqGSIb3DQEBCwUAA4IBAQAFVuA5+QarBpT7U7w66JhrikxDTwfg/6Q7Guuo\r\n"
"AeuxpU0ida2UDqy3M31d5e/g906DbxctyeVERPXeDbivRFvJixGj2ry2mbjqHaYe\r\n"
"3OYGM2QEhfW3jSkd4IOzrxD5J3BEYLwtz7Yb/7w+CRO34f/5MlYQJWUZiM+IyFh4\r\n"
"R94rS3ietTK9AUnFTforc9GPBSjtagQVCdWoYo43+D2z/jDDIigkVhXL1ozJgsx/\r\n"
"DwoYYGjCqhommSthyzaQsIu4LyDZ0UZ4uUboTAl6yzmGjuO92TdmZl9wMi91dDfv\r\n"
"piwtIz+WkK31VWQYVtY8jIwowTuK6X5IBgodFv04/GYE6sWh\r\n"
"-----END CERTIFICATE-----\r\n";
const size_t mbedtls_m2mqtt_srv_crt_len = sizeof(mbedtls_m2mqtt_srv_crt);

const char mbedtls_mosquitto_test_ca_crt[] =
"-----BEGIN CERTIFICATE-----\r\n"
"MIIDsTCCApmgAwIBAgIJANNDVP1PMrLzMA0GCSqGSIb3DQEBBQUAMG8xCzAJBgNV\r\n"
"BAYTAkNOMRAwDgYDVQQIEwdCZWlqaW5nMQwwCgYDVQQKEwNOWFAxDDAKBgNVBAsT\r\n"
"A01DVTEPMA0GA1UEAxMGc2F3eWVyMSEwHwYJKoZIhvcNAQkBFhJzYXd5ZXIubGl1\r\n"
"QG54cC5jb20wHhcNMjAwMzMxMDQ1MzUzWhcNMjUwMzMxMDQ1MzUzWjBvMQswCQYD\r\n"
"VQQGEwJDTjEQMA4GA1UECBMHQmVpamluZzEMMAoGA1UEChMDTlhQMQwwCgYDVQQL\r\n"
"EwNNQ1UxDzANBgNVBAMTBnNhd3llcjEhMB8GCSqGSIb3DQEJARYSc2F3eWVyLmxp\r\n"
"dUBueHAuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmdB4TA3G\r\n"
"tOB8haYPTXkgMNU+XCvrxpC1kzpnk5Bc3neuiRicQzLWI1KtDoG244cv2JZdBRie\r\n"
"YfNhqDZDhWROvholX2DWEEBUXi8Cu7vBX0h85HlBNGPqTwMm0P4doFcBlWvEIr27\r\n"
"ONjLzGvMZLU11h0rA7TbgKAn9oDBOjJGvN5mbV//phCNQEqMXmNoOblYXYjosvKB\r\n"
"qBbhyLfmJRvU/WplfUbBv7alnZ01JYTdvJ18+ak+2BV+g5dw1NCyc68azudXQX4L\r\n"
"rH/pzkR0jHg0WlrCzCaI+BOW78lZWAo7hJjQz4cAzcbeqgOuPrVHNvMQ8MJxZpZ5\r\n"
"7qQjKemtwcn2BwIDAQABo1AwTjAdBgNVHQ4EFgQUZS0UpJXexyyOUErXNWfFPgsu\r\n"
"m6cwHwYDVR0jBBgwFoAUZS0UpJXexyyOUErXNWfFPgsum6cwDAYDVR0TBAUwAwEB\r\n"
"/zANBgkqhkiG9w0BAQUFAAOCAQEABcloqYjTiWSGeSIN7zpcsBQfB9pov9k3KIvU\r\n"
"0q8hZ7UmBZmejjH3TwwZCZysjfLvAhR+CGOK8dOHKWSj1hrjuGeFUeKa2eAhrS0/\r\n"
"DClgC6Al8FhuCDgkG4efhT4ju4zr5G8C2A+z/PD33Mrtugss4pMDBml0qcrH0Fl2\r\n"
"jj68plUfLuGW6i1+3BDNiNDjFj81ORUAu0nj989pazus+Q9WsRi6IdmC0F0Ua4+k\r\n"
"9V67x5C2wUUEuOx+yeJln7pO93Du8hG5nellF4q0hA1FiSSiwJ76RFkgPnutRg6U\r\n"
"qkb47PZOBBNQvjEABj46BF/BRhy1hLkiygVzV3gpFa3qdRLUgg==\r\n"
"-----END CERTIFICATE-----\r\n";


const size_t mbedtls_mosquitto_test_ca_crt_len = sizeof(mbedtls_mosquitto_test_ca_crt);

const char mbedtls_mosquitto_test_client_crt[] =
"-----BEGIN CERTIFICATE-----\r\n"
"MIIDZzCCAk8CCQDywjV9fQqk7DANBgkqhkiG9w0BAQUFADBvMQswCQYDVQQGEwJD\r\n"
"TjEQMA4GA1UECBMHQmVpamluZzEMMAoGA1UEChMDTlhQMQwwCgYDVQQLEwNNQ1Ux\r\n"
"DzANBgNVBAMTBnNhd3llcjEhMB8GCSqGSIb3DQEJARYSc2F3eWVyLmxpdUBueHAu\r\n"
"Y29tMB4XDTIwMDMzMTA1MTAwMloXDTIxMDMyNjA1MTAwMlowfDELMAkGA1UEBhMC\r\n"
"Q04xEDAOBgNVBAgTB2JlaWppbmcxDDAKBgNVBAoTA05YUDESMBAGA1UECxMJTUNV\r\n"
"Q2xpZW50MRYwFAYDVQQDEw0xOTIuMTY4LjAuMTAxMSEwHwYJKoZIhvcNAQkBFhJz\r\n"
"YXd5ZXIubGl1QG54cC5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\r\n"
"AQC+cW20RrcgIevfNzg6GMwmk0NlY5m5j2J6Kuu+CrHsu9wGUYyi3WUqmVzXgCzg\r\n"
"ijwgJqE8CfbBewvQ0+nLHkg3m2uUmyuKvYIKBX4IzwwWsn809ePpk2iDVwKBDprg\r\n"
"ZXcOQgOO8zW8kYYyc373PBO0kZ+N9lM9tZdFauMeVYP9RsGgR70drF4JfrjcUjoe\r\n"
"wZi6AHQXkXhSFNCL6YgvYvgxNJ8RJ2es9FmJFb/DHh/mJAKXVWzLdf07+vHTARdj\r\n"
"Y642J7cuqVU7PxWCjE1nC7Zrhj0LD91DwfHOARFFSh3ZGKZj9Kx6J0+X7KTIVAhr\r\n"
"m0nW81Xg6O6iv0kk+G9Ov7FpAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAE8ooDt2\r\n"
"oqaOhQ65mp8ecuvEg8I/KUikzc0sUk/DazR5Px80/8agc3JjC+JqusbUkuRCe5oS\r\n"
"0FoQdOozRC9/oKJrGFtPKOppHYoJAHzQvD4jpI/QMSH/SjMpZ2VfozTskOWGO/XJ\r\n"
"Ps5eItwI3gYVL4fL6uCysB5CosWuU3aiGr6XXsSiu4nlhckgBKgEu/RJ7ttwfOlf\r\n"
"lWFYU79aHgw6lpRvoyC8gCuakBtqhxFAlWFz0qS/frt1FdnJb2+S91+WIADavWtW\r\n"
"Gus7HMzzz7bTX5t3CSIM3UJubgBSXv3T731LWEFqbhbgSfEYvMcdkx1njyrkB1zi\r\n"
"ONOaYtCH7GEhKrI=\r\n"
"-----END CERTIFICATE-----\r\n";

const size_t mbedtls_mosquitto_test_client_crt_len = sizeof( mbedtls_mosquitto_test_client_crt );

const char mbedtls_mosquitto_test_client_key[] =
"-----BEGIN RSA PRIVATE KEY-----\r\n"
"MIIEpQIBAAKCAQEAvnFttEa3ICHr3zc4OhjMJpNDZWOZuY9ieirrvgqx7LvcBlGM\r\n"
"ot1lKplc14As4Io8ICahPAn2wXsL0NPpyx5IN5trlJsrir2CCgV+CM8MFrJ/NPXj\r\n"
"6ZNog1cCgQ6a4GV3DkIDjvM1vJGGMnN+9zwTtJGfjfZTPbWXRWrjHlWD/UbBoEe9\r\n"
"HaxeCX643FI6HsGYugB0F5F4UhTQi+mIL2L4MTSfESdnrPRZiRW/wx4f5iQCl1Vs\r\n"
"y3X9O/rx0wEXY2OuNie3LqlVOz8VgoxNZwu2a4Y9Cw/dQ8HxzgERRUod2RimY/Ss\r\n"
"eidPl+ykyFQIa5tJ1vNV4Ojuor9JJPhvTr+xaQIDAQABAoIBAQCddJjYaXM07Pbg\r\n"
"uf4SArif2Dfr1xqdUhCAo4X/vUX4TiYPT1NwwI3JV71sK3xvNbuadXXvdul+dKaD\r\n"
"RQJSvrnEyAp9doHcluyyLnJTBCShi3kjJ34Fe6v4k3Ltk0634ww5TJk2kp1GSCdl\r\n"
"BRrffNtp+tCphhSyu7XTXhlj1h5nw7ABbW4a3hV4Y1nSqXjRLXxMhk5DMIpkux8k\r\n"
"8CTWqDUdUMfhYBinXi+znq/YEmoOkfRGVsVDGcCl9jZQxbjZQjWi7W99oCK6smwm\r\n"
"+fFOzZj5COeyzZYtJdjzSLjzi9Xw2Zh1Hj5Csk8KDLy5s/rymYYFY+ZFRuRjMhPr\r\n"
"Zp++LnABAoGBAOeRPGKeNdRu7XIhwQxoH8hbySieACSp6+ujjH//pcKys1pbtCh1\r\n"
"voMzLpe3z1v48YKuPzF7S/LGrUa/9SYYuG8sdnXiwbAdVOY61Au+cGV9AfrJ2XjH\r\n"
"M8zi5U0ytU18u3vxmWd65HxPPJKT2ed6bjfOS+aqZkERTAmE5NOIBktpAoGBANKJ\r\n"
"Z04UkuW9ZJ0zxi+RLKSJzUgTWSAdjF7JZuvpNLyOqKCzKeJIDw7KSSpFRG1qUU3y\r\n"
"aulp4UFrmY2A5HJyaV9NG1L2GWlp16amHHaDbzHQE7Ana3aq+oZosYJyftjfB0We\r\n"
"dPlaQNZo7xVkWP89Nff0ZUEkmVHUwQYLfdNEX3YBAoGBAJHG23XV1VtjbbVgzG/s\r\n"
"CL4QEiWwubRbCDryXZuiq45TAxeKDXM/FGzxxo4aV761jAxRd1TGIry2GBUm+MQ/\r\n"
"4bOTEQwLcRVWkcDSHfU6sPUi6iEf+vjOpqx/1gxwNLSQJlLTeFgthDNBiodX7mCL\r\n"
"sWEOTLfsY6zon66Ka6dCxXupAoGACB1fq/TDDLPWEvER7Hdt/xGIpgSI5OH+rRCa\r\n"
"NPGSJMpi2X7OWHhqjClj1ItC7eyxIY38bO61ze21x2x2YarjQNcZ/IKbzCJWO4gf\r\n"
"hLngKU1Z1OpQDAzfBxs17E85cGZ4Q0iuPYYrBZiZzntFquDTGbGDzZT5i9vlbLQ4\r\n"
"r1HtVAECgYEAl41rXjoNMwKTTSPx9uTyCFzxh3ABvoW9uagZ8uauBbl367ZMm19Q\r\n"
"d2fY+yRBSq38NgWHQcBuct8+OnkvrQMI4M45+3JkvFgiYXxS9/TVy0i7hPk538oK\r\n"
"64PSH4K7wh0HQJN7qISkhnO3ti+tM55y90gE6b3wUxPPjULx0E0+u8U=\r\n"
"-----END RSA PRIVATE KEY-----\r\n";



const size_t mbedtls_mosquitto_test_client_key_len = sizeof( mbedtls_mosquitto_test_client_key );


/* File from: https://github.com/Azure/azure-iot-sdk-c/blob/master/certs/certs.c  */
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

/* This file contains certs needed to communicate with Azure (IoT) */

const char mbedtls_azure_ca_crt[] =
/* DigiCert Baltimore Root */
"-----BEGIN CERTIFICATE-----\r\n"
"MIIDdzCCAl+gAwIBAgIEAgAAuTANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJJ\r\n"
"RTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MSIwIAYD\r\n"
"VQQDExlCYWx0aW1vcmUgQ3liZXJUcnVzdCBSb290MB4XDTAwMDUxMjE4NDYwMFoX\r\n"
"DTI1MDUxMjIzNTkwMFowWjELMAkGA1UEBhMCSUUxEjAQBgNVBAoTCUJhbHRpbW9y\r\n"
"ZTETMBEGA1UECxMKQ3liZXJUcnVzdDEiMCAGA1UEAxMZQmFsdGltb3JlIEN5YmVy\r\n"
"VHJ1c3QgUm9vdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKMEuyKr\r\n"
"mD1X6CZymrV51Cni4eiVgLGw41uOKymaZN+hXe2wCQVt2yguzmKiYv60iNoS6zjr\r\n"
"IZ3AQSsBUnuId9Mcj8e6uYi1agnnc+gRQKfRzMpijS3ljwumUNKoUMMo6vWrJYeK\r\n"
"mpYcqWe4PwzV9/lSEy/CG9VwcPCPwBLKBsua4dnKM3p31vjsufFoREJIE9LAwqSu\r\n"
"XmD+tqYF/LTdB1kC1FkYmGP1pWPgkAx9XbIGevOF6uvUA65ehD5f/xXtabz5OTZy\r\n"
"dc93Uk3zyZAsuT3lySNTPx8kmCFcB5kpvcY67Oduhjprl3RjM71oGDHweI12v/ye\r\n"
"jl0qhqdNkNwnGjkCAwEAAaNFMEMwHQYDVR0OBBYEFOWdWTCCR1jMrPoIVDaGezq1\r\n"
"BE3wMBIGA1UdEwEB/wQIMAYBAf8CAQMwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3\r\n"
"DQEBBQUAA4IBAQCFDF2O5G9RaEIFoN27TyclhAO992T9Ldcw46QQF+vaKSm2eT92\r\n"
"9hkTI7gQCvlYpNRhcL0EYWoSihfVCr3FvDB81ukMJY2GQE/szKN+OMY3EU/t3Wgx\r\n"
"jkzSswF07r51XgdIGn9w/xZchMB5hbgF/X++ZRGjD8ACtPhSNzkE1akxehi/oCr0\r\n"
"Epn3o0WC4zxe9Z2etciefC7IpJ5OCBRLbf1wbWsaY71k5h+3zvDyny67G7fyUIhz\r\n"
"ksLi4xaNmjICq44Y3ekQEe5+NauQrz4wlHrQMz2nZQ/1/I6eYs9HRCwBXbsdtTLS\r\n"
"R9I4LtD+gdwyah617jzV/OeBHRnDJELqYzmp\r\n"
"-----END CERTIFICATE-----\r\n"
/*DigiCert Global Root CA*/
"-----BEGIN CERTIFICATE-----\r\n"
"MIIDrzCCApegAwIBAgIQCDvgVpBCRrGhdWrJWZHHSjANBgkqhkiG9w0BAQUFADBh\r\n"
"MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3\r\n"
"d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBD\r\n"
"QTAeFw0wNjExMTAwMDAwMDBaFw0zMTExMTAwMDAwMDBaMGExCzAJBgNVBAYTAlVT\r\n"
"MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j\r\n"
"b20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IENBMIIBIjANBgkqhkiG\r\n"
"9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4jvhEXLeqKTTo1eqUKKPC3eQyaKl7hLOllsB\r\n"
"CSDMAZOnTjC3U/dDxGkAV53ijSLdhwZAAIEJzs4bg7/fzTtxRuLWZscFs3YnFo97\r\n"
"nh6Vfe63SKMI2tavegw5BmV/Sl0fvBf4q77uKNd0f3p4mVmFaG5cIzJLv07A6Fpt\r\n"
"43C/dxC//AH2hdmoRBBYMql1GNXRor5H4idq9Joz+EkIYIvUX7Q6hL+hqkpMfT7P\r\n"
"T19sdl6gSzeRntwi5m3OFBqOasv+zbMUZBfHWymeMr/y7vrTC0LUq7dBMtoM1O/4\r\n"
"gdW7jVg/tRvoSSiicNoxBN33shbyTApOB6jtSj1etX+jkMOvJwIDAQABo2MwYTAO\r\n"
"BgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUA95QNVbR\r\n"
"TLtm8KPiGxvDl7I90VUwHwYDVR0jBBgwFoAUA95QNVbRTLtm8KPiGxvDl7I90VUw\r\n"
"DQYJKoZIhvcNAQEFBQADggEBAMucN6pIExIK+t1EnE9SsPTfrgT1eXkIoyQY/Esr\r\n"
"hMAtudXH/vTBH1jLuG2cenTnmCmrEbXjcKChzUyImZOMkXDiqw8cvpOp/2PV5Adg\r\n"
"06O/nVsJ8dWO41P0jmP6P6fbtGbfYmbW0W5BjfIttep3Sp+dWOIrWcBAI+0tKIJF\r\n"
"PnlUkiaY4IBIqDfv8NZ5YBberOgOzW6sRBc4L0na4UU+Krk2U886UAb3LujEV0ls\r\n"
"YSEY1QSteDwsOoBrp+uvFRTp2InBuThs4pFsiv9kuXclVzDAGySj4dzp30d8tbQk\r\n"
"CAUw7C29C79Fv1C5qfPrmAESrciIxpg0X40KPMbp1ZWVbd4=\r\n"
"-----END CERTIFICATE-----\r\n"
/*D-TRUST Root Class 3 CA 2 2009*/
"-----BEGIN CERTIFICATE-----\r\n"
"MIIEMzCCAxugAwIBAgIDCYPzMA0GCSqGSIb3DQEBCwUAME0xCzAJBgNVBAYTAkRF\r\n"
"MRUwEwYDVQQKDAxELVRydXN0IEdtYkgxJzAlBgNVBAMMHkQtVFJVU1QgUm9vdCBD\r\n"
"bGFzcyAzIENBIDIgMjAwOTAeFw0wOTExMDUwODM1NThaFw0yOTExMDUwODM1NTha\r\n"
"ME0xCzAJBgNVBAYTAkRFMRUwEwYDVQQKDAxELVRydXN0IEdtYkgxJzAlBgNVBAMM\r\n"
"HkQtVFJVU1QgUm9vdCBDbGFzcyAzIENBIDIgMjAwOTCCASIwDQYJKoZIhvcNAQEB\r\n"
"BQADggEPADCCAQoCggEBANOySs96R+91myP6Oi/WUEWJNTrGa9v+2wBoqOADER03\r\n"
"UAifTUpolDWzU9GUY6cgVq/eUXjsKj3zSEhQPgrfRlWLJ23DEE0NkVJD2IfgXU42\r\n"
"tSHKXzlABF9bfsyjxiupQB7ZNoTWSPOSHjRGICTBpFGOShrvUD9pXRl/RcPHAY9R\r\n"
"ySPocq60vFYJfxLLHLGvKZAKyVXMD9O0Gu1HNVpK7ZxzBCHQqr0ME7UAyiZsxGsM\r\n"
"lFqVlNpQmvH/pStmMaTJOKDfHR+4CS7zp+hnUquVH+BGPtikw8paxTGA6Eian5Rp\r\n"
"/hnd2HN8gcqW3o7tszIFZYQ05ub9VxC1X3a/L7AQDcUCAwEAAaOCARowggEWMA8G\r\n"
"A1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFP3aFMSfMN4hvR5COfyrYyNJ4PGEMA4G\r\n"
"A1UdDwEB/wQEAwIBBjCB0wYDVR0fBIHLMIHIMIGAoH6gfIZ6bGRhcDovL2RpcmVj\r\n"
"dG9yeS5kLXRydXN0Lm5ldC9DTj1ELVRSVVNUJTIwUm9vdCUyMENsYXNzJTIwMyUy\r\n"
"MENBJTIwMiUyMDIwMDksTz1ELVRydXN0JTIwR21iSCxDPURFP2NlcnRpZmljYXRl\r\n"
"cmV2b2NhdGlvbmxpc3QwQ6BBoD+GPWh0dHA6Ly93d3cuZC10cnVzdC5uZXQvY3Js\r\n"
"L2QtdHJ1c3Rfcm9vdF9jbGFzc18zX2NhXzJfMjAwOS5jcmwwDQYJKoZIhvcNAQEL\r\n"
"BQADggEBAH+X2zDI36ScfSF6gHDOFBJpiBSVYEQBrLLpME+bUMJm2H6NMLVwMeni\r\n"
"acfzcNsgFYbQDfC+rAF1hM5+n02/t2A7nPPKHeJeaNijnZflQGDSNiH+0LS4F9p0\r\n"
"o3/U37CYAqxva2ssJSRyoWXuJVrl5jLn8t+rSfrzkGkj2wTZ51xY/GXUl77M/C4K\r\n"
"zCUqNQT4YJEVdT1B/yMfGchs64JTBKbkTCJNjYy6zltz7GRUUG3RnFX7acM2w4y8\r\n"
"PIWmawomDeCTmGCufsYkl4phX5GOZpIJhzbNi5stPvZR1FDUWSi9g/LMKHtThm3Y\r\n"
"Johw1+qRzT65ysCQblrGXnRl11z+o+I=\r\n"
"-----END CERTIFICATE-----\r\n"
/*WoSign*/
"-----BEGIN CERTIFICATE-----\r\n"
"MIIFdjCCA16gAwIBAgIQXmjWEXGUY1BWAGjzPsnFkTANBgkqhkiG9w0BAQUFADBV\r\n"
"MQswCQYDVQQGEwJDTjEaMBgGA1UEChMRV29TaWduIENBIExpbWl0ZWQxKjAoBgNV\r\n"
"BAMTIUNlcnRpZmljYXRpb24gQXV0aG9yaXR5IG9mIFdvU2lnbjAeFw0wOTA4MDgw\r\n"
"MTAwMDFaFw0zOTA4MDgwMTAwMDFaMFUxCzAJBgNVBAYTAkNOMRowGAYDVQQKExFX\r\n"
"b1NpZ24gQ0EgTGltaXRlZDEqMCgGA1UEAxMhQ2VydGlmaWNhdGlvbiBBdXRob3Jp\r\n"
"dHkgb2YgV29TaWduMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAvcqN\r\n"
"rLiRFVaXe2tcesLea9mhsMMQI/qnobLMMfo+2aYpbxY94Gv4uEBf2zmoAHqLoE1U\r\n"
"fcIiePyOCbiohdfMlZdLdNiefvAA5A6JrkkoRBoQmTIPJYhTpA2zDxIIFgsDcScc\r\n"
"f+Hb0v1naMQFXQoOXXDX2JegvFNBmpGN9J42Znp+VsGQX+axaCA2pIwkLCxHC1l2\r\n"
"ZjC1vt7tj/id07sBMOby8w7gLJKA84X5KIq0VC6a7fd2/BVoFutKbOsuEo/Uz/4M\r\n"
"x1wdC34FMr5esAkqQtXJTpCzWQ27en7N1QhatH/YHGkR+ScPewavVIMYe+HdVHpR\r\n"
"aG53/Ma/UkpmRqGyZxq7o093oL5d//xWC0Nyd5DKnvnyOfUNqfTq1+ezEC8wQjch\r\n"
"zDBwyYaYD8xYTYO7feUapTeNtqwylwA6Y3EkHp43xP901DfA4v6IRmAR3Qg/UDar\r\n"
"uHqklWJqbrDKaiFaafPz+x1wOZXzp26mgYmhiMU7ccqjUu6Du/2gd/Tkb+dC221K\r\n"
"mYo0SLwX3OSACCK28jHAPwQ+658geda4BmRkAjHXqc1S+4RFaQkAKtxVi8QGRkvA\r\n"
"Sh0JWzko/amrzgD5LkhLJuYwTKVYyrREgk/nkR4zw7CT/xH8gdLKH3Ep3XZPkiWv\r\n"
"HYG3Dy+MwwbMLyejSuQOmbp8HkUff6oZRZb9/D0CAwEAAaNCMEAwDgYDVR0PAQH/\r\n"
"BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFOFmzw7R8bNLtwYgFP6H\r\n"
"EtX2/vs+MA0GCSqGSIb3DQEBBQUAA4ICAQCoy3JAsnbBfnv8rWTjMnvMPLZdRtP1\r\n"
"LOJwXcgu2AZ9mNELIaCJWSQBnfmvCX0KI4I01fx8cpm5o9dU9OpScA7F9dY74ToJ\r\n"
"MuYhOZO9sxXqT2r09Ys/L3yNWC7F4TmgPsc9SnOeQHrAK2GpZ8nzJLmzbVUsWh2e\r\n"
"JXLOC62qx1ViC777Y7NhRCOjy+EaDveaBk3e1CNOIZZbOVtXHS9dCF4Jef98l7VN\r\n"
"g64N1uajeeAz0JmWAjCnPv/So0M/BVoG6kQC2nz4SNAzqfkHx5Xh9T71XXG68pWp\r\n"
"dIhhWeO/yloTunK0jF02h+mmxTwTv97QRCbut+wucPrXnbes5cVAWubXbHssw1ab\r\n"
"R80LzvobtCHXt2a49CUwi1wNuepnsvRtrtWhnk/Yn+knArAdBtaP4/tIEp9/EaEQ\r\n"
"PkxROpaw0RPxx9gmrjrKkcRpnd8BKWRRb2jaFOwIQZeQjdCygPLPwj2/kWjFgGce\r\n"
"xGATVdVhmVd8upUPYUk6ynW8yQqTP2cOEvIo4jEbwFcW3wh8GcF+Dx+FHgo2fFt+\r\n"
"J7x6v+Db9NpSvd4MVHAxkUOVyLzwPt0JfjBkUO1/AaQzZ01oT74V77D2AhGiGxMl\r\n"
"OtzCWfHjXEa7ZywCRuoeSKbmW9m1vFGikpbbqsY3Iqb+zCB0oy2pLmvLwIIRIbWT\r\n"
"ee5Ehr7XHuQe+w==\r\n"
"-----END CERTIFICATE-----\r\n";
const size_t mbedtls_azure_ca_crt_len = sizeof(mbedtls_azure_ca_crt);

