/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : UTIL1.h
**     Project     : FRDM-KL27Z_McuOnEclipseLib
**     Processor   : MKL25Z128VLK4
**     Component   : Utility
**     Version     : Component 01.154, Driver 01.00, CPU db: 3.00.000
**     Repository  : Legacy User Components
**     Compiler    : GNU C Compiler
**     Date/Time   : 2017-06-01, 09:37, # CodeGen: 206
**     Abstract    :
**          Contains various utility functions.
**     Settings    :
**          Component name                                 : UTIL1
**          SDK                                            : MCUC1
**     Contents    :
**         strcpy                  - void UTIL1_strcpy(uint8_t *dst, size_t dstSize, const unsigned char *src);
**         strcat                  - void UTIL1_strcat(uint8_t *dst, size_t dstSize, const unsigned char *src);
**         strcatPad               - void UTIL1_strcatPad(uint8_t *dst, size_t dstSize, const unsigned char *src,...
**         chcat                   - void UTIL1_chcat(uint8_t *dst, size_t dstSize, uint8_t ch);
**         Num8sToStr              - void UTIL1_Num8sToStr(uint8_t *dst, size_t dstSize, signed char val);
**         Num8uToStr              - void UTIL1_Num8uToStr(uint8_t *dst, size_t dstSize, uint8_t val);
**         Num16sToStr             - void UTIL1_Num16sToStr(uint8_t *dst, size_t dstSize, int16_t val);
**         Num16uToStr             - void UTIL1_Num16uToStr(uint8_t *dst, size_t dstSize, uint16_t val);
**         Num32uToStr             - void UTIL1_Num32uToStr(uint8_t *dst, size_t dstSize, uint32_t val);
**         Num32sToStr             - void UTIL1_Num32sToStr(uint8_t *dst, size_t dstSize, int32_t val);
**         NumFloatToStr           - void UTIL1_NumFloatToStr(uint8_t *dst, size_t dstSize, float val, uint8_t...
**         Num16sToStrFormatted    - void UTIL1_Num16sToStrFormatted(uint8_t *dst, size_t dstSize, int16_t val,...
**         Num16uToStrFormatted    - void UTIL1_Num16uToStrFormatted(uint8_t *dst, size_t dstSize, uint16_t val,...
**         Num32uToStrFormatted    - void UTIL1_Num32uToStrFormatted(uint8_t *dst, size_t dstSize, uint32_t val,...
**         Num32sToStrFormatted    - void UTIL1_Num32sToStrFormatted(uint8_t *dst, size_t dstSize, int32_t val,...
**         strcatNum8u             - void UTIL1_strcatNum8u(uint8_t *dst, size_t dstSize, uint8_t val);
**         strcatNum8s             - void UTIL1_strcatNum8s(uint8_t *dst, size_t dstSize, signed char val);
**         strcatNum16u            - void UTIL1_strcatNum16u(uint8_t *dst, size_t dstSize, uint16_t val);
**         strcatNum16s            - void UTIL1_strcatNum16s(uint8_t *dst, size_t dstSize, int16_t val);
**         strcatNum32u            - void UTIL1_strcatNum32u(uint8_t *dst, size_t dstSize, uint32_t val);
**         strcatNum32s            - void UTIL1_strcatNum32s(uint8_t *dst, size_t dstSize, int32_t val);
**         strcatNum16uFormatted   - void UTIL1_strcatNum16uFormatted(uint8_t *dst, size_t dstSize, uint16_t val,...
**         strcatNum16sFormatted   - void UTIL1_strcatNum16sFormatted(uint8_t *dst, size_t dstSize, int16_t val,...
**         strcatNum32uFormatted   - void UTIL1_strcatNum32uFormatted(uint8_t *dst, size_t dstSize, uint32_t val,...
**         strcatNum32sFormatted   - void UTIL1_strcatNum32sFormatted(uint8_t *dst, size_t dstSize, int32_t val,...
**         strcatNum8Hex           - void UTIL1_strcatNum8Hex(uint8_t *dst, size_t dstSize, uint8_t num);
**         strcatNum16Hex          - void UTIL1_strcatNum16Hex(uint8_t *dst, size_t dstSize, uint16_t num);
**         strcatNum24Hex          - void UTIL1_strcatNum24Hex(uint8_t *dst, size_t dstSize, uint32_t num);
**         strcatNum32Hex          - void UTIL1_strcatNum32Hex(uint8_t *dst, size_t dstSize, uint32_t num);
**         strcatNum32sDotValue100 - void UTIL1_strcatNum32sDotValue100(uint8_t *dst, size_t dstSize, int32_t num);
**         strcatNumFloat          - void UTIL1_strcatNumFloat(uint8_t *dst, size_t dstSize, float val, uint8_t...
**         IsLeapYear              - bool UTIL1_IsLeapYear(uint16_t year);
**         WeekDay                 - uint8_t UTIL1_WeekDay(uint16_t year, uint8_t month, uint8_t day);
**         ReadEscapedName         - uint8_t UTIL1_ReadEscapedName(const unsigned char *filename, uint8_t...
**         xatoi                   - uint8_t UTIL1_xatoi(const unsigned char **str, int32_t *res);
**         ScanDate                - uint8_t UTIL1_ScanDate(const unsigned char **str, uint8_t *day, uint8_t...
**         ScanTime                - uint8_t UTIL1_ScanTime(const unsigned char **str, uint8_t *hour, uint8_t...
**         ScanDecimal8uNumber     - uint8_t UTIL1_ScanDecimal8uNumber(const unsigned char **str, uint8_t *val);
**         ScanDecimal8sNumber     - uint8_t UTIL1_ScanDecimal8sNumber(const unsigned char **str, signed char *val);
**         ScanDecimal16uNumber    - uint8_t UTIL1_ScanDecimal16uNumber(const unsigned char **str, uint16_t *val);
**         ScanDecimal16sNumber    - uint8_t UTIL1_ScanDecimal16sNumber(const unsigned char **str, int16_t *val);
**         ScanDecimal32uNumber    - uint8_t UTIL1_ScanDecimal32uNumber(const unsigned char **str, uint32_t *val);
**         ScanDecimal32sNumber    - uint8_t UTIL1_ScanDecimal32sNumber(const unsigned char **str, int32_t *val);
**         ScanDecimal32sDotNumber - uint8_t UTIL1_ScanDecimal32sDotNumber(const unsigned char **str, int32_t...
**         ScanHex8uNumber         - uint8_t UTIL1_ScanHex8uNumber(const unsigned char **str, uint8_t *val);
**         ScanHex8uNumberNoPrefix - uint8_t UTIL1_ScanHex8uNumberNoPrefix(const unsigned char **str, uint8_t *val);
**         ScanHex16uNumber        - uint8_t UTIL1_ScanHex16uNumber(const unsigned char **str, uint16_t *val);
**         ScanHex32uNumber        - uint8_t UTIL1_ScanHex32uNumber(const unsigned char **str, uint32_t *val);
**         ScanSeparatedNumbers    - uint8_t UTIL1_ScanSeparatedNumbers(const unsigned char **str, uint8_t...
**         ScanDoubleQuotedString  - uint8_t UTIL1_ScanDoubleQuotedString(const uint8_t **cmd, uint8_t *buf,...
**         strcmp                  - int16_t UTIL1_strcmp(const char *, const char *);
**         strncmp                 - int16_t UTIL1_strncmp(const char *, const char *, size_t size);
**         strFind                 - int16_t UTIL1_strFind(uint8_t *str, uint8_t *subStr);
**         strtailcmp              - uint8_t UTIL1_strtailcmp(const uint8_t *str, const uint8_t *tail);
**         strlen                  - uint16_t UTIL1_strlen(const char *);
**         strCutTail              - uint8_t UTIL1_strCutTail(uint8_t *str, uint8_t *tail);
**         GetValue16LE            - uint16_t UTIL1_GetValue16LE(uint8_t *dataP);
**         GetValue24LE            - uint32_t UTIL1_GetValue24LE(uint8_t *dataP);
**         GetValue32LE            - uint32_t UTIL1_GetValue32LE(uint8_t *dataP);
**         SetValue16LE            - void UTIL1_SetValue16LE(uint16_t data, uint8_t *dataP);
**         SetValue24LE            - void UTIL1_SetValue24LE(uint32_t data, uint8_t *dataP);
**         SetValue32LE            - void UTIL1_SetValue32LE(uint32_t data, uint8_t *dataP);
**         map                     - int32_t UTIL1_map(int32_t x, int32_t in_min, int32_t in_max, int32_t out_min,...
**         constrain               - int32_t UTIL1_constrain(int32_t val, int32_t min, int32_t max);
**         random                  - int32_t UTIL1_random(int32_t min, int32_t max);
**         randomSetSeed           - void UTIL1_randomSetSeed(unsigned int seed);
**         Deinit                  - void UTIL1_Deinit(void);
**         Init                    - void UTIL1_Init(void);
**
**     * Copyright (c) 2014-2017, Erich Styger
**      * Web:         https://mcuoneclipse.com
**      * SourceForge: https://sourceforge.net/projects/mcuoneclipse
**      * Git:         https://github.com/ErichStyger/McuOnEclipse_PEx
**      * All rights reserved.
**      *
**      * Redistribution and use in source and binary forms, with or without modification,
**      * are permitted provided that the following conditions are met:
**      *
**      * - Redistributions of source code must retain the above copyright notice, this list
**      *   of conditions and the following disclaimer.
**      *
**      * - Redistributions in binary form must reproduce the above copyright notice, this
**      *   list of conditions and the following disclaimer in the documentation and/or
**      *   other materials provided with the distribution.
**      *
**      * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**      * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**      * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**      * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**      * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**      * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**      * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**      * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**      * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**      * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
** ###################################################################*/
/*!
** @file UTIL1.h
** @version 01.00
** @brief
**          Contains various utility functions.
*/         
/*!
**  @addtogroup UTIL1_module UTIL1 module documentation
**  @{
*/         

#ifndef __UTIL1_H
#define __UTIL1_H

/* other includes needed */
#include <string.h>
#include <stddef.h> /* for size_t */
#include "stdint.h"
#include <stdbool.h>

  /* boolean values */
  #ifndef FALSE
    #define  FALSE  0x00u
  #endif
  #ifndef TRUE
    #define  TRUE   0x01u
  #endif

  /* error codes */

  #define ERR_OKOK                        0x00U /*!< OK */
  #define ERR_SPEED                       0x01U /*!< This device does not work in the active speed mode. */
  #define ERR_RANGE                       0x02U /*!< Parameter out of range. */
  #define ERR_VALUE                       0x03U /*!< Parameter of incorrect value. */
  #define ERR_OVERFLOW                    0x04U /*!< Timer overflow. */
  #define ERR_MATH                        0x05U /*!< Overflow during evaluation. */
  #define ERR_ENABLED                     0x06U /*!< Device is enabled. */
  #define ERR_DISABLED                    0x07U /*!< Device is disabled. */
  #define ERR_BUSY                        0x08U /*!< Device is busy. */
  #define ERR_NOTAVAIL                    0x09U /*!< Requested value or method not available. */
  #define ERR_RXEMPTY                     0x0AU /*!< No data in receiver. */
  #define ERR_TXFULL                      0x0BU /*!< Transmitter is full. */
  #define ERR_BUSOFF                      0x0CU /*!< Bus not available. */
  #define ERR_OVERRUN                     0x0DU /*!< Overrun error is detected. */
  #define ERR_FRAMING                     0x0EU /*!< Framing error is detected. */
  #define ERR_PARITY                      0x0FU /*!< Parity error is detected. */
  #define ERR_NOISE                       0x10U /*!< Noise error is detected. */
  #define ERR_IDLE                        0x11U /*!< Idle error is detected. */
  #define ERR_FAULT                       0x12U /*!< Fault error is detected. */
  #define ERR_BREAK                       0x13U /*!< Break char is received during communication. */
  #define ERR_CRC                         0x14U /*!< CRC error is detected. */
  #define ERR_ARBITR                      0x15U /*!< A node losts arbitration. This error occurs if two nodes start transmission at the same time. */
  #define ERR_PROTECT                     0x16U /*!< Protection error is detected. */
  #define ERR_UNDERFLOW                   0x17U /*!< Underflow error is detected. */
  #define ERR_UNDERRUN                    0x18U /*!< Underrun error is detected. */
  #define ERR_COMMON                      0x19U /*!< Common error of a device. */
  #define ERR_LINSYNC                     0x1AU /*!< LIN synchronization error is detected. */
  #define ERR_FAILED                      0x1BU /*!< Requested functionality or process failed. */
  #define ERR_QFULL                       0x1CU /*!< Queue is full. */
  #define ERR_PARAM_MASK                  0x80U /*!< Invalid mask. */
  #define ERR_PARAM_MODE                  0x81U /*!< Invalid mode. */
  #define ERR_PARAM_INDEX                 0x82U /*!< Invalid index. */
  #define ERR_PARAM_DATA                  0x83U /*!< Invalid data. */
  #define ERR_PARAM_SIZE                  0x84U /*!< Invalid size. */
  #define ERR_PARAM_VALUE                 0x85U /*!< Invalid value. */
  #define ERR_PARAM_RANGE                 0x86U /*!< Invalid parameter's range or parameters' combination. */
  #define ERR_PARAM_LOW_VALUE             0x87U /*!< Invalid value (LOW part). */
  #define ERR_PARAM_HIGH_VALUE            0x88U /*!< Invalid value (HIGH part). */
  #define ERR_PARAM_ADDRESS               0x89U /*!< Invalid address. */
  #define ERR_PARAM_PARITY                0x8AU /*!< Invalid parity. */
  #define ERR_PARAM_WIDTH                 0x8BU /*!< Invalid width. */
  #define ERR_PARAM_LENGTH                0x8CU /*!< Invalid length. */
  #define ERR_PARAM_ADDRESS_TYPE          0x8DU /*!< Invalid address type. */
  #define ERR_PARAM_COMMAND_TYPE          0x8EU /*!< Invalid command type. */
  #define ERR_PARAM_COMMAND               0x8FU /*!< Invalid command. */
  #define ERR_PARAM_RECIPIENT             0x90U /*!< Invalid recipient. */
  #define ERR_PARAM_BUFFER_COUNT          0x91U /*!< Invalid buffer count. */
  #define ERR_PARAM_ID                    0x92U /*!< Invalid ID. */
  #define ERR_PARAM_GROUP                 0x93U /*!< Invalid group. */
  #define ERR_PARAM_CHIP_SELECT           0x94U /*!< Invalid chip select. */
  #define ERR_PARAM_ATTRIBUTE_SET         0x95U /*!< Invalid set of attributes. */
  #define ERR_PARAM_SAMPLE_COUNT          0x96U /*!< Invalid sample count. */
  #define ERR_PARAM_CONDITION             0x97U /*!< Invalid condition. */
  #define ERR_PARAM_TICKS                 0x98U /*!< Invalid ticks parameter. */


#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
  UTIL1_SEP_NUM_TYPE_UINT8, /* uint8_t number type */
  UTIL1_SEP_NUM_TYPE_UINT8_HEX_NO_PREFIX /* uint8_t hex number type, no 0x prefix */
} UTIL1_SeparatedNumberType;

void UTIL1_strcpy(uint8_t *dst, size_t dstSize, const unsigned char *src);
/*
** ===================================================================
**     Method      :  UTIL1_strcpy (component Utility)
**     Description :
**         Same as normal strcpy, but safe as it does not write beyond
**         the buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**       * src             - Pointer to source string.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcat(uint8_t *dst, size_t dstSize, const unsigned char *src);
/*
** ===================================================================
**     Method      :  UTIL1_strcat (component Utility)
**     Description :
**         Same as normal strcat, but safe as it does not write beyond
**         the buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**       * src             - Pointer to source string.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Num16sToStr(uint8_t *dst, size_t dstSize, int16_t val);
/*
** ===================================================================
**     Method      :  UTIL1_Num16sToStr (component Utility)
**     Description :
**         Converts a signed 16bit value into a string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to be converted.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Num16sToStrFormatted(uint8_t *dst, size_t dstSize, int16_t val, char fill, uint8_t nofFill);
/*
** ===================================================================
**     Method      :  UTIL1_Num16sToStrFormatted (component Utility)
**     Description :
**         Converts a 16bit signed value to string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**         fill            - Fill character
**         nofFill         - Number of fill characters
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum16s(uint8_t *dst, size_t dstSize, int16_t val);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum16s (component Utility)
**     Description :
**         Appends a 16bit signed value to a string buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum16sFormatted(uint8_t *dst, size_t dstSize, int16_t val, char fill, uint8_t nofFill);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum16sFormatted (component Utility)
**     Description :
**         Appends a 16bit signed value to a string buffer in a
**         formatted way.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**         fill            - Fill character
**         nofFill         - Number of fill characters
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum8Hex(uint8_t *dst, size_t dstSize, uint8_t num);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum8Hex (component Utility)
**     Description :
**         Appends a 8bit unsigned value to a string buffer as hex
**         number (without a 0x prefix).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         num             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum16Hex(uint8_t *dst, size_t dstSize, uint16_t num);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum16Hex (component Utility)
**     Description :
**         Appends a 16bit unsigned value to a string buffer as hex
**         number (without a 0x prefix).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         num             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum32s(uint8_t *dst, size_t dstSize, int32_t val);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum32s (component Utility)
**     Description :
**         Appends a 32bit signed value to a string buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Num32sToStr(uint8_t *dst, size_t dstSize, int32_t val);
/*
** ===================================================================
**     Method      :  UTIL1_Num32sToStr (component Utility)
**     Description :
**         Converts a signed 32bit value into a string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to be converted.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum32Hex(uint8_t *dst, size_t dstSize, uint32_t num);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum32Hex (component Utility)
**     Description :
**         Appends a 16bit unsigned value to a string buffer as hex
**         number (without a 0x prefix).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         num             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

bool UTIL1_IsLeapYear(uint16_t year);
/*
** ===================================================================
**     Method      :  UTIL1_IsLeapYear (component Utility)
**     Description :
**         Returns true if a given year is a leap year
**     Parameters  :
**         NAME            - DESCRIPTION
**         year            - Year, in the YYYY format.
**     Returns     :
**         ---             - If the year is a leap year or not.
** ===================================================================
*/

uint8_t UTIL1_WeekDay(uint16_t year, uint8_t month, uint8_t day);
/*
** ===================================================================
**     Method      :  UTIL1_WeekDay (component Utility)
**     Description :
**         Returns the weekday for a given date >= 1.Jan.1900
**     Parameters  :
**         NAME            - DESCRIPTION
**         year            - year in YYYY format
**         month           - month of the year (1: January, 2:
**                           February, etc)
**         day             - day of the moth (starting with 1)
**     Returns     :
**         ---             - Returns the weekday, 0 for Sunday, 1 for
**                           Monday, 2 for Tuesday, etc.
** ===================================================================
*/

void UTIL1_chcat(uint8_t *dst, size_t dstSize, uint8_t ch);
/*
** ===================================================================
**     Method      :  UTIL1_chcat (component Utility)
**     Description :
**         Adds a single character to a zero byte terminated string
**         buffer. It cares about buffer overflow.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         ch              - character to append
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum32u(uint8_t *dst, size_t dstSize, uint32_t val);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum32u (component Utility)
**     Description :
**         Appends a 32bit signed value to a string buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Num32uToStr(uint8_t *dst, size_t dstSize, uint32_t val);
/*
** ===================================================================
**     Method      :  UTIL1_Num32uToStr (component Utility)
**     Description :
**         Converts an unsigned 32bit value into a string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to be converted.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum32uFormatted(uint8_t *dst, size_t dstSize, uint32_t val, char fill, uint8_t nofFill);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum32uFormatted (component Utility)
**     Description :
**         Appends a 32bit unsigned value to a string buffer in a
**         formatted way.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**         fill            - Fill character
**         nofFill         - Number of fill characters
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Num32uToStrFormatted(uint8_t *dst, size_t dstSize, uint32_t val, char fill, uint8_t nofFill);
/*
** ===================================================================
**     Method      :  UTIL1_Num32uToStrFormatted (component Utility)
**     Description :
**         Converts a 32bit unsigned value to string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**         fill            - Fill character
**         nofFill         - Number of fill characters
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum24Hex(uint8_t *dst, size_t dstSize, uint32_t num);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum24Hex (component Utility)
**     Description :
**         Appends a 32bit unsigned value to a string buffer as hex
**         number (without a 0x prefix). Only 24bits are used.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         num             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

uint8_t UTIL1_ReadEscapedName(const unsigned char *filename, uint8_t *destname, size_t maxlen, size_t *lenRead, size_t *lenWritten, const char *terminators);
/*
** ===================================================================
**     Method      :  UTIL1_ReadEscapedName (component Utility)
**     Description :
**         Scans an escaped name from a string. This is useful e.g. for
**         double quoted file names.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * filename        - the name to be copied. Names may
**                           be in quoted format
**       * destname        - the destination of the copy.
**                           Names are not in quoted format. destname
**                           may be NULL to get the other return values
**                           only
**         maxlen          - length allocated for destname
**       * lenRead         - length read in filename to copy
**                           the whole name. Note that filenames maybe
**                           space terminated, so *lenRead <
**                           strlen(filename)
**         lenWritten      - the size written in destname.
**                           In case of overflows in destname,
**                           lenWritten is still increased but destname
**                           no longer written. The have the string
**                           length in these cases use strlen(destname)
**         terminators     - additional characters
**                           where a name should terminate. May be NULL
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_xatoi(const unsigned char **str, int32_t *res);
/*
** ===================================================================
**     Method      :  UTIL1_xatoi (component Utility)
**     Description :
**         Custom atoi() (ascii to int) implementation by Elm Chan
**     Parameters  :
**         NAME            - DESCRIPTION
**       * str             - Pointer to string to scan. Returns until
**                           where it has scanned.
**       * res             - Pointer to where to store the result
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanDate(const unsigned char **str, uint8_t *day, uint8_t *month, uint16_t *year);
/*
** ===================================================================
**     Method      :  UTIL1_ScanDate (component Utility)
**     Description :
**         Scans a date in the format "dd.mm.yyyy" or "dd-mm-yyyy". For
**         yy it will expand it to 20yy.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * str             - Pointer to the string to be scanned. The
**                           function advances the pointer.
**       * day             - Pointer to where to store the day value
**       * month           - Pointer to where to store the month
**                           value
**       * year            - Pointer to where to store the year value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanTime(const unsigned char **str, uint8_t *hour, uint8_t *minute, uint8_t *second, uint8_t *hSecond);
/*
** ===================================================================
**     Method      :  UTIL1_ScanTime (component Utility)
**     Description :
**         Scans a time string in the format "hh:mm:ss,hh" with the
**         part for the ",hh" is optional.
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - Pointer to the string to be scanned. The
**                           function advances the pointer.
**       * hour            - Pointer to where to store the hour value
**       * minute          - Pointer to where to store the minute
**                           value
**       * second          - Pointer to where to store the second
**                           value
**       * hSecond         - Pointer to scans the hundreds of
**                           second part. If not present in string, zero
**                           is stored
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanDecimal16uNumber(const unsigned char **str, uint16_t *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanDecimal16uNumber (component Utility)
**     Description :
**         Scans a decimal 16bit unsigned number
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - String to scan. It returns as well until
**                           where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanDecimal8uNumber(const unsigned char **str, uint8_t *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanDecimal8uNumber (component Utility)
**     Description :
**         Scans a decimal 8bit unsigned number
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - String to scan. It returns as well until
**                           where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

void UTIL1_Num16uToStr(uint8_t *dst, size_t dstSize, uint16_t val);
/*
** ===================================================================
**     Method      :  UTIL1_Num16uToStr (component Utility)
**     Description :
**         Converts a signed 16bit value into a string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to be converted.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Num8sToStr(uint8_t *dst, size_t dstSize, signed char val);
/*
** ===================================================================
**     Method      :  UTIL1_Num8sToStr (component Utility)
**     Description :
**         Converts a signed 8bit value into a string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to be converted.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Num8uToStr(uint8_t *dst, size_t dstSize, uint8_t val);
/*
** ===================================================================
**     Method      :  UTIL1_Num8uToStr (component Utility)
**     Description :
**         Converts an unsigned 8bit value into a string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to be converted.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Num16uToStrFormatted(uint8_t *dst, size_t dstSize, uint16_t val, char fill, uint8_t nofFill);
/*
** ===================================================================
**     Method      :  UTIL1_Num16uToStrFormatted (component Utility)
**     Description :
**         Converts a 16bit unsigned value to string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**         fill            - Fill character
**         nofFill         - Number of fill characters
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Num32sToStrFormatted(uint8_t *dst, size_t dstSize, int32_t val, char fill, uint8_t nofFill);
/*
** ===================================================================
**     Method      :  UTIL1_Num32sToStrFormatted (component Utility)
**     Description :
**         Converts a 32bit signed value to string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**         fill            - Fill character
**         nofFill         - Number of fill characters
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum16u(uint8_t *dst, size_t dstSize, uint16_t val);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum16u (component Utility)
**     Description :
**         Appends a 16bit unsigned value to a string buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum16uFormatted(uint8_t *dst, size_t dstSize, uint16_t val, char fill, uint8_t nofFill);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum16uFormatted (component Utility)
**     Description :
**         Appends a 16bit unsigned value to a string buffer in a
**         formatted way.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**         fill            - Fill character
**         nofFill         - Number of fill characters
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum32sFormatted(uint8_t *dst, size_t dstSize, int32_t val, char fill, uint8_t nofFill);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum32sFormatted (component Utility)
**     Description :
**         Appends a 32bit signed value to a string buffer in a
**         formatted way.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**         fill            - Fill character
**         nofFill         - Number of fill characters
**     Returns     : Nothing
** ===================================================================
*/

uint8_t UTIL1_ScanDecimal32uNumber(const unsigned char **str, uint32_t *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanDecimal32uNumber (component Utility)
**     Description :
**         Scans a decimal 32bit unsigned number
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - string to scan. It returns as well until
**                           where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

void UTIL1_strcatNum8u(uint8_t *dst, size_t dstSize, uint8_t val);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum8u (component Utility)
**     Description :
**         Appends a 8bit unsigned value to a string buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNum8s(uint8_t *dst, size_t dstSize, signed char val);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum8s (component Utility)
**     Description :
**         Appends a 8bit signed value to a string buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

#define UTIL1_strcmp(str1, str2) \
  strcmp(str1, str2)

/*
** ===================================================================
**     Method      :  UTIL1_strcmp (component Utility)
**     Description :
**         Wrapper to the standard strcmp() routine
**     Parameters  :
**         NAME            - DESCRIPTION
**       * str1            - Pointer to string
**       * str2            - Pointer to string
**     Returns     :
**         ---             - Returns zero if the two strings are the
**                           same
** ===================================================================
*/

#define UTIL1_strncmp(str1, str2, size) \
  strncmp(str1, str2, size)

/*
** ===================================================================
**     Method      :  UTIL1_strncmp (component Utility)
**     Description :
**         Wrapper to the standard strncmp() routine
**     Parameters  :
**         NAME            - DESCRIPTION
**       * str1            - Pointer to string
**       * str2            - Pointer to string
**         size            - 
**     Returns     :
**         ---             - Returns zero if the two strings are the
**                           same
** ===================================================================
*/

#define UTIL1_strlen(str) \
  strlen(str)

/*
** ===================================================================
**     Method      :  UTIL1_strlen (component Utility)
**     Description :
**         Wrapper to the standard strlen() function.
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - 
**     Returns     :
**         ---             - size of strinig
** ===================================================================
*/

uint8_t UTIL1_ScanHex32uNumber(const unsigned char **str, uint32_t *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanHex32uNumber (component Utility)
**     Description :
**         Scans a hexadecimal 32bit number, starting with 0x
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - String to scan, starting with 0x. It
**                           returns as well until where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanHex16uNumber(const unsigned char **str, uint16_t *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanHex16uNumber (component Utility)
**     Description :
**         Scans a hexadecimal 16bit number, starting with 0x
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - String to scan, starting with 0x.. It
**                           returns as well until where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanHex8uNumber(const unsigned char **str, uint8_t *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanHex8uNumber (component Utility)
**     Description :
**         Scans a hexadecimal 8bit number, starting with 0x
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - String to scan, starting with 0x. It
**                           returns as well until where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_strtailcmp(const uint8_t *str, const uint8_t *tail);
/*
** ===================================================================
**     Method      :  UTIL1_strtailcmp (component Utility)
**     Description :
**         Compares the tail of a string and returns 0 if it matches, 1
**         otherwise
**     Parameters  :
**         NAME            - DESCRIPTION
**       * str             - Pointer to string. This string is compared
**                           if it contains the tail.
**       * tail            - Pointer to tail string.
**     Returns     :
**         ---             - returns 0 if tail matches, -1 otherwise
** ===================================================================
*/

uint8_t UTIL1_strCutTail(uint8_t *str, uint8_t *tail);
/*
** ===================================================================
**     Method      :  UTIL1_strCutTail (component Utility)
**     Description :
**         Removes a tailing substring from a string. The string passed
**         will be modified (the tail is cut by writing a zero byte to
**         the string!)
**     Parameters  :
**         NAME            - DESCRIPTION
**       * str             - Pointer to string where to remove the tail
**       * tail            - Pointer to substring to remove
**     Returns     :
**         ---             - Error code, ERR_OK if no error, otherwise
**                           ERR_FAIL if tail is not found
** ===================================================================
*/

uint8_t UTIL1_ScanHex8uNumberNoPrefix(const unsigned char **str, uint8_t *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanHex8uNumberNoPrefix (component Utility)
**     Description :
**         Scans a hexadecimal 8bit number, without 0x
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - String to scan, starting with 0x. It
**                           returns as well until where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

void UTIL1_strcatNum32sDotValue100(uint8_t *dst, size_t dstSize, int32_t num);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNum32sDotValue100 (component Utility)
**     Description :
**         Appends a 32bit signed value to a string buffer. The value
**         is in 1/100 units.  For example for the value -13456 it will
**         append the string "-134.56"
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         num             - Value to convert.
**     Returns     : Nothing
** ===================================================================
*/

uint8_t UTIL1_ScanDecimal8sNumber(const unsigned char **str, signed char *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanDecimal8sNumber (component Utility)
**     Description :
**         Scans a decimal 8bit signed number
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - String to scan. It returns as well until
**                           where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanDecimal16sNumber(const unsigned char **str, int16_t *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanDecimal16sNumber (component Utility)
**     Description :
**         Scans a decimal 16bit signed number
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - String to scan. It returns as well until
**                           where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanDecimal32sNumber(const unsigned char **str, int32_t *val);
/*
** ===================================================================
**     Method      :  UTIL1_ScanDecimal32sNumber (component Utility)
**     Description :
**         Scans a decimal 32bit signed number
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - string to scan. It returns as well until
**                           where it has scanned
**       * val             - Pointer to value
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

int16_t UTIL1_strFind(uint8_t *str, uint8_t *subStr);
/*
** ===================================================================
**     Method      :  UTIL1_strFind (component Utility)
**     Description :
**         Searches a substring inside a string and returns the
**         position.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * str             - Pointer to string which will be searched
**       * subStr          - Pointer to substring to search
**                           inside str
**     Returns     :
**         ---             - -1 if not found, otherwise the character
**                           index.
** ===================================================================
*/

uint8_t UTIL1_ScanSeparatedNumbers(const unsigned char **str, uint8_t *values, uint8_t nofValues, char separator, UTIL1_SeparatedNumberType numberType);
/*
** ===================================================================
**     Method      :  UTIL1_ScanSeparatedNumbers (component Utility)
**     Description :
**         Scans multiple numbers separated by character, e.g. "123.68.
**         5.3"
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - String to scan. It returns as well until
**                           where it has scanned
**       * values          - Pointer to array where to store the
**                           values
**         nofValues       - Number of values in the array
**         separator       - Character separator, e.g. '.'
**         numberType      - type of number to scan
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanDoubleQuotedString(const uint8_t **cmd, uint8_t *buf, size_t bufSize);
/*
** ===================================================================
**     Method      :  UTIL1_ScanDoubleQuotedString (component Utility)
**     Description :
**         Scans a string inside double quotes and returns it without
**         the double quotes.
**     Parameters  :
**         NAME            - DESCRIPTION
**         cmd             - Pointer to pointer to string to parse.
**                           This pointer will be advanced as much as
**                           parsing is done.
**       * buf             - Pointer to buffer where to store the string
**         bufSize         - Size of buffer in bytes
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t UTIL1_ScanDecimal32sDotNumber(const unsigned char **str, int32_t *integral, uint32_t *fractional, uint8_t *nofFractionalZeros);
/*
** ===================================================================
**     Method      :  UTIL1_ScanDecimal32sDotNumber (component Utility)
**     Description :
**         Scans a decimal 32bit signed number with a following dot
**         (fractional part), e.g. "-34587.0248", it will return the
**         (signed) integral and fractional part with number of
**         fractional zeros. The function accepts as well numbers  like
**         "17" (no fractional part" or "17.0" 
**     Parameters  :
**         NAME            - DESCRIPTION
**         str             - string to scan. It returns as well until
**                           where it has scanned
**       * integral        - Pointer to value before the dot
**       * fractional      - Pointer to value after the
**                           dot, e.g. 32 for "-134.0032"
**         nofFractionalZeros - Number of
**                           fractional leading zeros, e.g. 2 for "-134.
**                           0032"
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

void UTIL1_strcatPad(uint8_t *dst, size_t dstSize, const unsigned char *src, char padChar, uint8_t srcPadSize);
/*
** ===================================================================
**     Method      :  UTIL1_strcatPad (component Utility)
**     Description :
**         Same as normal strcat, but safe as it does not write beyond
**         the buffer. The buffer will be filled with a pad character
**         for a given length.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**       * src             - Pointer to source string.
**         padChar         - Character to be used for padding
**         srcPadSize      - To which size the src string
**                           has to be padded.
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_NumFloatToStr(uint8_t *dst, size_t dstSize, float val, uint8_t nofFracDigits);
/*
** ===================================================================
**     Method      :  UTIL1_NumFloatToStr (component Utility)
**     Description :
**         Converts a float value into a string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to be converted.
**         nofFracDigits   - Number of fractional
**                           digits to print
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_strcatNumFloat(uint8_t *dst, size_t dstSize, float val, uint8_t nofFracDigits);
/*
** ===================================================================
**     Method      :  UTIL1_strcatNumFloat (component Utility)
**     Description :
**         Converts a float value into a string.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dst             - Pointer to destination string
**         dstSize         - Size of the destination buffer (in
**                           bytes).
**         val             - Value to be converted.
**         nofFracDigits   - Number of factional
**                           digits to print
**     Returns     : Nothing
** ===================================================================
*/

uint16_t UTIL1_GetValue16LE(uint8_t *dataP);
/*
** ===================================================================
**     Method      :  UTIL1_GetValue16LE (component Utility)
**     Description :
**         Returns a 16bit Little Endian value from memory
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dataP           - Pointer to memory
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint32_t UTIL1_GetValue24LE(uint8_t *dataP);
/*
** ===================================================================
**     Method      :  UTIL1_GetValue24LE (component Utility)
**     Description :
**         Returns a 24bit Little Endian value from memory
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dataP           - Pointer to memory
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint32_t UTIL1_GetValue32LE(uint8_t *dataP);
/*
** ===================================================================
**     Method      :  UTIL1_GetValue32LE (component Utility)
**     Description :
**         Returns a 32bit Little Endian value from memory
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dataP           - Pointer to memory
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

void UTIL1_SetValue16LE(uint16_t data, uint8_t *dataP);
/*
** ===================================================================
**     Method      :  UTIL1_SetValue16LE (component Utility)
**     Description :
**         Stores a 16bit value in memory as Little Endian
**     Parameters  :
**         NAME            - DESCRIPTION
**         data            - Value to store
**       * dataP           - Pointer to memory
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_SetValue24LE(uint32_t data, uint8_t *dataP);
/*
** ===================================================================
**     Method      :  UTIL1_SetValue24LE (component Utility)
**     Description :
**         Stores a 24bit value in memory as Little Endian
**     Parameters  :
**         NAME            - DESCRIPTION
**         data            - Value to store
**       * dataP           - Pointer to memory
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_SetValue32LE(uint32_t data, uint8_t *dataP);
/*
** ===================================================================
**     Method      :  UTIL1_SetValue32LE (component Utility)
**     Description :
**         Stores a 32bit value in memory as Little Endian
**     Parameters  :
**         NAME            - DESCRIPTION
**         data            - Value to store
**       * dataP           - Pointer to memory
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Deinit(void);
/*
** ===================================================================
**     Method      :  UTIL1_Deinit (component Utility)
**     Description :
**         Driver De-Initialization
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void UTIL1_Init(void);
/*
** ===================================================================
**     Method      :  UTIL1_Init (component Utility)
**     Description :
**         Driver Initialization
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

int32_t UTIL1_map(int32_t x, int32_t in_min, int32_t in_max, int32_t out_min, int32_t out_max);
/*
** ===================================================================
**     Method      :  UTIL1_map (component Utility)
**     Description :
**         Maps a value from one range to another
**     Parameters  :
**         NAME            - DESCRIPTION
**         x               - value to be mapped
**         in_min          - input range minimum value
**         in_max          - input range maximum value
**         out_min         - output range maximum value
**         out_max         - 
**     Returns     :
**         ---             - remapped value
** ===================================================================
*/

int32_t UTIL1_constrain(int32_t val, int32_t min, int32_t max);
/*
** ===================================================================
**     Method      :  UTIL1_constrain (component Utility)
**     Description :
**         Makes sure that a given input value is inside a given range.
**     Parameters  :
**         NAME            - DESCRIPTION
**         val             - input value
**         min             - range minimum value
**         max             - range maximum value
**     Returns     :
**         ---             - the constrained value
** ===================================================================
*/

int32_t UTIL1_random(int32_t min, int32_t max);
/*
** ===================================================================
**     Method      :  UTIL1_random (component Utility)
**     Description :
**         Provides a random value. You have to call intialize the
**         random number generator with randomSetSeed() first!
**     Parameters  :
**         NAME            - DESCRIPTION
**         min             - range minimum value
**         max             - range maximum value
**     Returns     :
**         ---             - random value between min and max
** ===================================================================
*/

void UTIL1_randomSetSeed(unsigned int seed);
/*
** ===================================================================
**     Method      :  UTIL1_randomSetSeed (component Utility)
**     Description :
**         Sets a seed for the random number generator
**     Parameters  :
**         NAME            - DESCRIPTION
**         seed            - seed to be used for random number
**                           generator
**     Returns     : Nothing
** ===================================================================
*/

/* END UTIL1. */

#ifdef __cplusplus
}  /* extern "C" */
#endif

#endif
/* ifndef __UTIL1_H */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
