/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : RNG1.h
**     Project     : FRDM-K64F_lwip_mqtt_bm
**     Processor   : MK64FN1M0VLL12
**     Component   : RingBuffer
**     Version     : Component 01.053, Driver 01.00, CPU db: 3.00.000
**     Compiler    : GNU C Compiler
**     Date/Time   : 2019-03-03, 06:44, # CodeGen: 0
**     Abstract    :
**         This component implements a ring buffer for different integer data type.
**     Settings    :
**          Component name                                 : RNG1
**          Buffer Size                                    : 4096
**     Contents    :
**         Clear           - void RNG1_Clear(void);
**         Put             - uint8_t RNG1_Put(RNG1_ElementType elem);
**         Get             - uint8_t RNG1_Get(RNG1_ElementType *elemP);
**         Peek            - uint8_t RNG1_Peek(RNG1_BufSizeType index, RNG1_ElementType *elemP);
**         Update          - uint8_t RNG1_Update(RNG1_BufSizeType index, RNG1_ElementType *elemP);
**         Putn            - uint8_t RNG1_Putn(RNG1_ElementType *elem, RNG1_BufSizeType nof);
**         Getn            - uint8_t RNG1_Getn(RNG1_ElementType *buf, RNG1_BufSizeType nof);
**         Compare         - uint8_t RNG1_Compare(RNG1_BufSizeType index, RNG1_ElementType *elemP,...
**         Delete          - uint8_t RNG1_Delete(void);
**         NofElements     - RNG1_BufSizeType RNG1_NofElements(void);
**         NofFreeElements - RNG1_BufSizeType RNG1_NofFreeElements(void);
**         Deinit          - void RNG1_Deinit(void);
**         Init            - void RNG1_Init(void);
**
** * Copyright (c) 2014-2018, Erich Styger
**  * Web:         https://mcuoneclipse.com
**  * SourceForge: https://sourceforge.net/projects/mcuoneclipse
**  * Git:         https://github.com/ErichStyger/McuOnEclipse_PEx
**  * All rights reserved.
**  *
**  * Redistribution and use in source and binary forms, with or without modification,
**  * are permitted provided that the following conditions are met:
**  *
**  * - Redistributions of source code must retain the above copyright notice, this list
**  *   of conditions and the following disclaimer.
**  *
**  * - Redistributions in binary form must reproduce the above copyright notice, this
**  *   list of conditions and the following disclaimer in the documentation and/or
**  *   other materials provided with the distribution.
**  *
**  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**  * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**  * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**  * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**  * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**  * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**  * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**  * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
** ###################################################################*/
/*!
** @file RNG1.h
** @version 01.00
** @brief
**         This component implements a ring buffer for different integer data type.
*/         
/*!
**  @addtogroup RNG1_module RNG1 module documentation
**  @{
*/         

#ifndef __RNG1_H
#define __RNG1_H

/* MODULE RNG1. */
#include "RNG1config.h" /* configuration */
#include "stdint.h"

  /* boolean values */
  #ifndef FALSE
    #define  FALSE  0x00u
  #endif
  #ifndef TRUE
    #define  TRUE   0x01u
  #endif

  /* error codes */
  #define ERR_OK                          0x00U /*!< OK */
  #define ERR_SPEED                       0x01U /*!< This device does not work in the active speed mode. */
  #define ERR_RANGE                       0x02U /*!< Parameter out of range. */
  #define ERR_VALUE                       0x03U /*!< Parameter of incorrect value. */
  #define ERR_OVERFLOW                    0x04U /*!< Timer overflow. */
  #define ERR_MATH                        0x05U /*!< Overflow during evaluation. */
  #define ERR_ENABLED                     0x06U /*!< Device is enabled. */
  #define ERR_DISABLED                    0x07U /*!< Device is disabled. */
  #define ERR_BUSY                        0x08U /*!< Device is busy. */
  #define ERR_NOTAVAIL                    0x09U /*!< Requested value or method not available. */
  #define ERR_RXEMPTY                     0x0AU /*!< No data in receiver. */
  #define ERR_TXFULL                      0x0BU /*!< Transmitter is full. */
  #define ERR_BUSOFF                      0x0CU /*!< Bus not available. */
  #define ERR_OVERRUN                     0x0DU /*!< Overrun error is detected. */
  #define ERR_FRAMING                     0x0EU /*!< Framing error is detected. */
  #define ERR_PARITY                      0x0FU /*!< Parity error is detected. */
  #define ERR_NOISE                       0x10U /*!< Noise error is detected. */
  #define ERR_IDLE                        0x11U /*!< Idle error is detected. */
  #define ERR_FAULT                       0x12U /*!< Fault error is detected. */
  #define ERR_BREAK                       0x13U /*!< Break char is received during communication. */
  #define ERR_CRC                         0x14U /*!< CRC error is detected. */
  #define ERR_ARBITR                      0x15U /*!< A node losts arbitration. This error occurs if two nodes start transmission at the same time. */
  #define ERR_PROTECT                     0x16U /*!< Protection error is detected. */
  #define ERR_UNDERFLOW                   0x17U /*!< Underflow error is detected. */
  #define ERR_UNDERRUN                    0x18U /*!< Underrun error is detected. */
  #define ERR_COMMON                      0x19U /*!< Common error of a device. */
  #define ERR_LINSYNC                     0x1AU /*!< LIN synchronization error is detected. */
  #define ERR_FAILED                      0x1BU /*!< Requested functionality or process failed. */
  #define ERR_QFULL                       0x1CU /*!< Queue is full. */
  #define ERR_PARAM_MASK                  0x80U /*!< Invalid mask. */
  #define ERR_PARAM_MODE                  0x81U /*!< Invalid mode. */
  #define ERR_PARAM_INDEX                 0x82U /*!< Invalid index. */
  #define ERR_PARAM_DATA                  0x83U /*!< Invalid data. */
  #define ERR_PARAM_SIZE                  0x84U /*!< Invalid size. */
  #define ERR_PARAM_VALUE                 0x85U /*!< Invalid value. */
  #define ERR_PARAM_RANGE                 0x86U /*!< Invalid parameter's range or parameters' combination. */
  #define ERR_PARAM_LOW_VALUE             0x87U /*!< Invalid value (LOW part). */
  #define ERR_PARAM_HIGH_VALUE            0x88U /*!< Invalid value (HIGH part). */
  #define ERR_PARAM_ADDRESS               0x89U /*!< Invalid address. */
  #define ERR_PARAM_PARITY                0x8AU /*!< Invalid parity. */
  #define ERR_PARAM_WIDTH                 0x8BU /*!< Invalid width. */
  #define ERR_PARAM_LENGTH                0x8CU /*!< Invalid length. */
  #define ERR_PARAM_ADDRESS_TYPE          0x8DU /*!< Invalid address type. */
  #define ERR_PARAM_COMMAND_TYPE          0x8EU /*!< Invalid command type. */
  #define ERR_PARAM_COMMAND               0x8FU /*!< Invalid command. */
  #define ERR_PARAM_RECIPIENT             0x90U /*!< Invalid recipient. */
  #define ERR_PARAM_BUFFER_COUNT          0x91U /*!< Invalid buffer count. */
  #define ERR_PARAM_ID                    0x92U /*!< Invalid ID. */
  #define ERR_PARAM_GROUP                 0x93U /*!< Invalid group. */
  #define ERR_PARAM_CHIP_SELECT           0x94U /*!< Invalid chip select. */
  #define ERR_PARAM_ATTRIBUTE_SET         0x95U /*!< Invalid set of attributes. */
  #define ERR_PARAM_SAMPLE_COUNT          0x96U /*!< Invalid sample count. */
  #define ERR_PARAM_CONDITION             0x97U /*!< Invalid condition. */
  #define ERR_PARAM_TICKS                 0x98U /*!< Invalid ticks parameter. */


#ifdef __cplusplus
extern "C" {
#endif

#if RNG1_CONFIG_ELEM_SIZE==1
  typedef uint8_t RNG1_ElementType; /* type of single element */
#elif RNG1_CONFIG_ELEM_SIZE==2
  typedef uint16_t RNG1_ElementType; /* type of single element */
#elif RNG1_CONFIG_ELEM_SIZE==4
  typedef uint32_t RNG1_ElementType; /* type of single element */
#else
  #error "illegal element type size in properties"
#endif
#if RNG1_CONFIG_BUF_SIZE<256
  typedef uint8_t RNG1_BufSizeType; /* up to 255 elements (index 0x00..0xff) */
#else
  typedef uint16_t RNG1_BufSizeType; /* more than 255 elements, up to 2^16 */
#endif

uint8_t RNG1_Put(RNG1_ElementType elem);
/*
** ===================================================================
**     Method      :  Put (component RingBuffer)
**
**     Description :
**         Puts a new element into the buffer
**     Parameters  :
**         NAME            - DESCRIPTION
**         elem            - New element to be put into the buffer
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t RNG1_Get(RNG1_ElementType *elemP);
/*
** ===================================================================
**     Method      :  Get (component RingBuffer)
**
**     Description :
**         Removes an element from the buffer
**     Parameters  :
**         NAME            - DESCRIPTION
**       * elemP           - Pointer to where to store the received
**                           element
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

RNG1_BufSizeType RNG1_NofElements(void);
/*
** ===================================================================
**     Method      :  NofElements (component RingBuffer)
**
**     Description :
**         Returns the actual number of elements in the buffer.
**     Parameters  : None
**     Returns     :
**         ---             - Number of elements in the buffer.
** ===================================================================
*/

void RNG1_Init(void);
/*
** ===================================================================
**     Method      :  Init (component RingBuffer)
**
**     Description :
**         Initializes the data structure
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

RNG1_BufSizeType RNG1_NofFreeElements(void);
/*
** ===================================================================
**     Method      :  NofFreeElements (component RingBuffer)
**
**     Description :
**         Returns the actual number of free elements/space in the
**         buffer.
**     Parameters  : None
**     Returns     :
**         ---             - Number of elements in the buffer.
** ===================================================================
*/

void RNG1_Clear(void);
/*
** ===================================================================
**     Method      :  Clear (component RingBuffer)
**
**     Description :
**         Clear (empty) the ring buffer.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

uint8_t RNG1_Peek(RNG1_BufSizeType index, RNG1_ElementType *elemP);
/*
** ===================================================================
**     Method      :  Peek (component RingBuffer)
**
**     Description :
**         Returns an element of the buffer without removiing it.
**     Parameters  :
**         NAME            - DESCRIPTION
**         index           - Index of element. 0 peeks the top
**                           element, 1 the next, and so on.
**       * elemP           - Pointer to where to store the received
**                           element
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

#define RNG1_Deinit() \
   /* nothing to deinitialize */
/*
** ===================================================================
**     Method      :  Deinit (component RingBuffer)
**
**     Description :
**         Driver de-initialization
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

uint8_t RNG1_Delete(void);
/*
** ===================================================================
**     Method      :  Delete (component RingBuffer)
**
**     Description :
**         Removes an element from the buffer
**     Parameters  : None
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t RNG1_Putn(RNG1_ElementType *elem, RNG1_BufSizeType nof);
/*
** ===================================================================
**     Method      :  Putn (component RingBuffer)
**
**     Description :
**         Put a number new element into the buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * elem            - Pointer to new elements to be put into
**                           the buffer
**         nof             - number of elements
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t RNG1_Compare(RNG1_BufSizeType index, RNG1_ElementType *elemP, RNG1_BufSizeType nof);
/*
** ===================================================================
**     Method      :  Compare (component RingBuffer)
**
**     Description :
**         Compares the elements in the buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**         index           - Index of element. 0 peeks the top
**                           element, 1 the next, and so on.
**       * elemP           - Pointer to elements to compare with
**         nof             - number of elements to compare
**     Returns     :
**         ---             - zero if elements are the same, -1 otherwise
** ===================================================================
*/

uint8_t RNG1_Getn(RNG1_ElementType *buf, RNG1_BufSizeType nof);
/*
** ===================================================================
**     Method      :  Getn (component RingBuffer)
**
**     Description :
**         Get a number elements into a buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * buf             - Pointer to buffer where to store the
**                           elements
**         nof             - number of elements
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

uint8_t RNG1_Update(RNG1_BufSizeType index, RNG1_ElementType *elemP);
/*
** ===================================================================
**     Method      :  Update (component RingBuffer)
**
**     Description :
**         Updates the data of an element.
**     Parameters  :
**         NAME            - DESCRIPTION
**         index           - Index of element. 0 peeks the top
**                           element, 1 the next, and so on.
**       * elemP           - Pointer to where to store the received
**                           element
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

/* END RNG1. */

#ifdef __cplusplus
}  /* extern "C" */
#endif

#endif
/* ifndef __RNG1_H */
/*!
** @}
*/
