/*
 * SCT_UART.h
 *
 *  Created on: 
 *      Author:
 */

#ifndef __SCT_UART_H__
#define __SCT_UART_H__

/**
 * @brief   This function will call back when SCT UART receive one byte data.
 *          Please implement it according to your needs.
 *          Because it will run in the ISR, make sure it run as fast as possible and without blocking.
 *          This function has its name emitted as a weak symbol instead of a global name. This is primarily for the naming of library routines that can be overridden by user code.
 * @param   ReceiveByte     One byte of data that has been received.
 *                          When this function is called, The received one byte data will be passed as actual parameter to this function.
 * @return  Nothing.
 */
void SCT_UART_Receive_Byte_CallBack(uint8_t ReceiveByte);

/**
 * @brief   Initialize SCT UART.
 * @param   Nothing.
 * @return  Nothing.
 */
extern void SCT_UART_Init(void);

/**
 * @brief   Send one byte of data through SCT UART.
 * @param   Nothing.
 * @return  Nothing.
 */
extern void SCT_UART_Send_Byte(uint8_t BytetoSend);

#endif /* __SCT_UART_H__ */
