/*
 * Copyright (c) 2018, NXP Semiconductors, Inc.
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v4.1
processor: LPC845
package_id: LPC845M301JBD64
mcu_data: ksdk2_0
processor_version: 0.0.1
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_iocon.h"
#include "fsl_swm.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '37', peripheral: USART0, signal: TXD, pin_signal: PIO1_17, mode: pullUp, invert: disabled, hysteresis: enabled, opendrain: disabled, smode: bypass,
    clkdiv: div0}
  - {pin_num: '36', peripheral: USART0, signal: RXD, pin_signal: PIO1_16, mode: pullUp, invert: disabled, hysteresis: enabled, opendrain: disabled, smode: bypass,
    clkdiv: div0}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M0P */
void BOARD_InitPins(void)
{
    /* Enables clock for IOCON.: enable */
    CLOCK_EnableClock(kCLOCK_Iocon);
    /* Enables clock for switch matrix.: enable */
    CLOCK_EnableClock(kCLOCK_Swm);
    
    CLOCK_EnableClock(kCLOCK_Gpio0);

    CLOCK_EnableClock(kCLOCK_Gpio1);
    
    CLOCK_EnableClock(kCLOCK_Sct);
   
    CLOCK_EnableClock(kCLOCK_GpioInt);

    const uint32_t pio44_config = (/* Selects pull-up function */
                                   IOCON_PIO_MODE_PULLUP |
                                   /* Enable hysteresis */
                                   IOCON_PIO_HYS_EN |
                                   /* Input not invert */
                                   IOCON_PIO_INV_DI |
                                   /* Disables Open-drain function */
                                   IOCON_PIO_OD_DI |
                                   /* Bypass input filter */
                                   IOCON_PIO_SMODE_BYPASS |
                                   /* IOCONCLKDIV0 */
                                   IOCON_PIO_CLKDIV0);
    /* PORT4 PIN4 (coords: ) is configured as  */
    IOCON_PinMuxSet(IOCON, 44, pio44_config);

    const uint32_t pio45_config = (/* Selects pull-up function */
                                   IOCON_PIO_MODE_PULLUP |
                                   /* Enable hysteresis */
                                   IOCON_PIO_HYS_EN |
                                   /* Input not invert */
                                   IOCON_PIO_INV_DI |
                                   /* Disables Open-drain function */
                                   IOCON_PIO_OD_DI |
                                   /* Bypass input filter */
                                   IOCON_PIO_SMODE_BYPASS |
                                   /* IOCONCLKDIV0 */
                                   IOCON_PIO_CLKDIV0);
    /* PORT4 PIN5 (coords: ) is configured as  */
    IOCON_PinMuxSet(IOCON, 45, pio45_config);

    /* USART0_TXD connect to P1_17 */
    SWM_SetMovablePinSelect(SWM0, kSWM_USART0_TXD, kSWM_PortPin_P1_17);

    /* USART0_RXD connect to P1_16 */
    SWM_SetMovablePinSelect(SWM0, kSWM_USART0_RXD, kSWM_PortPin_P1_16);
    
    /* SCT_OUT0 connect to P0_24 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SCT_OUT0, kSWM_PortPin_P0_24);
    
    /* SCT_OUT1 connect to P0_21 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SCT_OUT1, kSWM_PortPin_P0_21);
    
    /* SCT_OUT2 connect to P0_20 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SCT_OUT2, kSWM_PortPin_P0_20);
    
    /* SCT_OUT3 connect to P1_21 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SCT_OUT3, kSWM_PortPin_P1_21);
    
    /* SCT_OUT4 connect to P0_28 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SCT_OUT5, kSWM_PortPin_P1_20);
    
    /* SCT_OUT5 connect to P1_20 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SCT_OUT6, kSWM_PortPin_P0_28);  
    
    /* SCT_OUT4 connect to P1_14 */
    /* this is the ADC trigger output; does not need a pin - used for debugging purpose only !!! */
    SWM_SetMovablePinSelect(SWM0, kSWM_SCT_OUT4, kSWM_PortPin_P1_14); 
    
    /* disable pull-ups for ADC_2/3 @ PIO014_/PIO0_23 */
    const uint32_t pio_adcin_config = (/* Disables pull-up/downs */
                                       IOCON_PIO_MODE_PUPD_DI |
                                       /* Enable hysteresis */
                                       IOCON_PIO_HYS_EN |
                                       /* Input not invert */
                                       IOCON_PIO_INV_DI |
                                       /* Disables Open-drain function */
                                       IOCON_PIO_OD_DI |
                                       /* Bypass input filter */
                                       IOCON_PIO_SMODE_BYPASS |
                                       /* IOCONCLKDIV0 */
                                       IOCON_PIO_CLKDIV0 |
                                       /* reserved content as per the UM */
                                       1<<7);
    
    /* PORT0 PIN23 is configured as an ADC input */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_23, pio_adcin_config);

    /* PORT0 PIN14 is configured as an ADC input */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_14, pio_adcin_config);

}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
