/*******************************************************************************
*
 * Copyright (c) 2013 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
* 
*
****************************************************************************//*!
*
* @brief  Negation
* 
*******************************************************************************/
#ifndef _MLIB_NEG_F16_H_
#define _MLIB_NEG_F16_H_

#if defined(__cplusplus)
extern "C" {
#endif

/*******************************************************************************
* Includes
*******************************************************************************/
#include "mlib_types.h"

/*******************************************************************************
* Macros
*******************************************************************************/  
#define MLIB_Neg_F16_Ci(f16Val)    MLIB_Neg_F16_FCi(f16Val) 
  
/***************************************************************************//*!
*
* f16Out = -f16Val
* Without saturation
*******************************************************************************/
static inline frac16_t MLIB_Neg_F16_FCi(register frac16_t f16Val)
{
    return((frac16_t)(-f16Val)); 
}
 
#if defined(__cplusplus)
}
#endif

#endif /* _MLIB_NEG_F16_H_ */
