/* hal_sct.c */
#include "hal_sct.h"


/* 只有当事件的中断被启用，并且事件在特定状态被使能，此时当事件发生时才能触发中断 */
void SCT_EnableEventInterrupts(SCT_Type *base, uint32_t eventMask)
{
	base->EVEN |= eventMask;
}

void SCT_DisableEventInterrupts(SCT_Type *base, uint32_t eventMask)
{
	base->EVEN &= ~eventMask;
}

uint32_t SCT_GetEventFlags(SCT_Type *base)
{
    return base->EVFLAG;
}

void SCT_ClearEventFlags(SCT_Type *base, uint32_t eventMask)
{
	base->EVFLAG = eventMask;
}


/* EOF. */

