/*!
* @file    servo.h
* @version v1.0
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   基于CTIMER实现输出PWM控制舵机的功能
*/

#ifndef __SERVO_H__
#define __SERVO_H__

#include <stdint.h>

/*
* 舵机要求接收50Hz的PWM波形，通过调整PWM波的占空比控制偏转角度（高电平越多，偏转角度越大）
* 本例通过CTimer实现输出PWM波形，在保证50Hz频率的基础上，计数基础频率可较高，从而实现较高的调整精度
*/

/*
* SG90舵机解锁之后，在5500到27700之间为有效控制区间
* - 0-4000之间为匀速旋转状态
* - 27000以上为停止状态
* S3010舵机在智能车模上的有效控制区间是：
* - 车轮最右转（舵机左偏）对应配置值为16300
* - 车轮最左转（舵机右偏）对应配置值为20300
*/

#define SERVO_CTIMER_CLOCK_SOURCE_FREQ_HZ 12000000UL /* Async APB时钟，选择FRO 12MHz */
#define SERVO_CTIMER_CLOCK_PRE_DIV  1U /* 对APB总线时钟的预分频，可以让CTIMER内部的计数值小一点 */
#define SERVO_CTIMER_PWM_FREQ_HZ  50U /* 舵机的控制频率为60Hz，常规值为50Hz */
/* 设定PWM周期时使用，这个值也是更改PWM输出占空比的最大值 */
#define SERVO_CTIMER_PWM_PERIOD_COUNT_VAL (SERVO_CTIMER_CLOCK_SOURCE_FREQ_HZ/SERVO_CTIMER_CLOCK_PRE_DIV/SERVO_CTIMER_PWM_FREQ_HZ)
#define SERVO_CTIMER_PWM_CHANNEL_SILENT_VAL 0xFFFFFFFF

/* 能够偏转的最大角度 */
#define SERVO_PWM_DUTY_MAX  20300U /* 10% */
#define SERVO_PWM_DUTY_MIN  16300U  /* 3.2% */
#define SERVO_PWM_DUTY_MID  18300U  /* 3.2% */

#define SERVO_PWM_DUYT_LEFT_MAX   20300U
#define SERVO_PWM_DUYT_RIGHT_MAX  16300U

void Servo_Init(uint32_t initPosition);
void Servo_SetPosition(uint32_t positionVal);

#endif /* __SERVO_H__ */

