/*!
* @file    pid.h
* @version v0.1
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   实现PID算法的处理流程
*/

#ifndef __PID_H__
#define __PID_H__

typedef struct
{
    float ParamP;  /* P参数，反馈量到控制量的换算比例参数. */
    float ParamI;  /* I参数，一阶差分调整参数 */
    float ParamD;  /* D参数，二阶差分调整参数*/
    float Diff1;   /* 一阶差值 */
    float Diff2;   /* 二阶差值 */
    float TargetVal; /* 目标值 */
    float CtrlDeltaVal; /* 计算修正误差时需要基于目标值的调整量 */
} PID_Handle_T;

void PID_Init(PID_Handle_T *handler, float p, float i, float d);
void PID_SetTargetValue(PID_Handle_T *handler, float targetVal);
float PID_GetDeltaOutput(PID_Handle_T *handler, float newBackVal);
float PID_GetAbsOutput(PID_Handle_T *handler, float newBackVal);

#endif /* __PID_H__ */

