/*!
* @file    oled_12864.h
* @version v1.0
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   实现对OLED显示器的基本操作，并提供了基于GPIO移植底层驱动的函数接口
*/

#ifndef __OLED_12864_H__
#define __OLED_12864_H__

#include <stdint.h>
#include <stdbool.h>

/*
+-----------------> OLED_ROW_COUNT_MAX
|
|
v
OLED_LINE_COUNT_MAX
*/

#define OLED_ROW_COUNT_MAX 128U
#define OLED_LINE_COUNT_MAX 8U /* 8 x 8，在竖排一个y对应8个像素 */

/* 移植与通信相关的函数 */
void OLED_HW_Init(void);

typedef enum
{
    eOLED_GpioPin_DC  = 0U,
    eOLED_GpioPin_RST = 1U,
    eOLED_GpioPin_SDA = 2U, /* SPI的TX */
    eOLED_GpioPin_CLK = 3U, /* SPI的SCL */
} OLED_GpioPin_T;
void OLED_HW_SetGpioPin(OLED_GpioPin_T pin, uint8_t val);
void OLED_HW_DelayMs(uint32_t ms);


void OLED_WriteData(uint8_t dat);
void OLED_WriteCmd(uint8_t cmd);


/* 功能显示API */
void OLED_Init(void);
void OLED_SetPosition(uint8_t line, uint8_t row);
void OLED_ClearScreen(uint8_t dat);
void OLED_WriteLine(uint8_t line, uint8_t row, uint8_t *buf, uint8_t bufLen);
void OLED_PutCharP6x8(uint8_t line, uint8_t row, uint8_t ch);
void OLED_PutCharP8x16(uint8_t line, uint8_t row, uint8_t ch);
void OLED_PutStrP6x8(uint8_t line, uint8_t row, uint8_t *str);
void OLED_PutStrP8x16(uint8_t line, uint8_t row, uint8_t *str);

#endif /* __OLED_12864_H__ */

