/*!
* @file    image_edge.c
* @version v0.1
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   实现对灰度图像的边沿检测功能
*/
#include "image.h"

#define IMAGE_EDGE_FILTER_COUNT 5

/* 处理每一行的像素
 * 从两边向中间开始找
 * 使用迟滞滤波器
 */
bool Image_GetEdgePixels(uint8_t *pixels, uint32_t lineLen, uint32_t *leftPos, uint32_t *rightPos)
{
    uint32_t accCount;
    /* 找左边界 */
    *leftPos = 0U;
    accCount = 0U;
    while ((*leftPos) < (lineLen-1U)) /* 实在没有边界就以屏幕最右方为边界 */
    {
        if (pixels[*leftPos] == 0U)
        {
            accCount = 0U; /* 累加器归零 */
        }
        else
        {
            accCount++;
            if (accCount >= IMAGE_EDGE_FILTER_COUNT)
            {
                break;
            }
        }
        (*leftPos)++;
    }

    /* 找右边界 */
    *rightPos = lineLen-1U;
    accCount = 0U;
    while ((*rightPos) > 0U) /* 实在没有边界就以屏幕最左方为边界 */
    {
        if (pixels[*rightPos] == 0U)
        {
            accCount = 0U; /* 累加器归零 */
        }
        else
        {
            accCount++;
            if (accCount >= IMAGE_EDGE_FILTER_COUNT)
            {
                break;
            }
        }
        (*rightPos)--;
    }

    if ((*leftPos) > (*rightPos))
    {
        return false;
    }
    return true;
}

/* EOF. */

