/*!
* @file    camera_ov7620.h
* @version v1.0
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   基于SCT和DMA实现捕获ov7620摄像头数据的功能
*/

#ifndef __CAMERA_OV7620_H__
#define __CAMERA_OV7620_H__

#include <stdint.h>
#include <stdbool.h>

#include "fsl_gpio.h"
#include "fsl_inputmux.h"
#include "hal_dma.h"
#include "hal_sct.h"

/* 使用DMA29通道作为Cam专用通道 */
#define CAMERA_DMA_CHANNEL_IDX   29U

/* SCT事件及状态 */
#define CAMERA_SCT_EVENT_VSYNC_START 0U /* IN0下降沿 */
#define CAMERA_SCT_EVENT_VSYNC_END   1U /* IN0上升沿 */
#define CAMERA_SCT_EVENT_HREF_START  2U /* IN1上升沿 */
#define CAMERA_SCT_EVENT_HREF_END    3U /* IN1下降沿 */
#define CAMERA_SCT_EVENT_PCLK_START  4U /* IN2上升沿，PCLK能触发DMA的事件，仅仅在CAMERA_SCT_STATE_WAIT_NEW_PCLK状态下起作用*/
#define CAMERA_SCT_EVENT_PCLK_START2  5U /* IN2上升沿，PCLK的影子事件，但仅仅在CAMERA_SCT_STATE_WAIT_NEW_PCLK2状态下起作用 */

#define CAMERA_SCT_STATE_WAIT_NEW_FRAME  0U /* 准备接收新的一帧（Field） */
#define CAMERA_SCT_STATE_WAIT_NEW_LINE   1U /* 准备接收新的一行 */
#define CAMERA_SCT_STATE_WAIT_NEW_PCLK   2U /* 准备接收新的像素 */
#define CAMERA_SCT_STATE_WAIT_NEXT_FRAME 3U /* 各场采样时使用的Dummy状态，暂时未启用 */
#define CAMERA_SCT_STATE_WAIT_NEW_PCLK2  4U /* 隔点采样的状态 */

#define CAMERA_SCT_INPUT_LINE_VSYNC  0U
#define CAMERA_SCT_INPUT_LINE_HREF   1U
#define CAMERA_SCT_INPUT_LINE_PCLK   2U

#define CAMERA_PIXELS_PER_LINE  640U
#define CAMERA_PIXELS_PER_LINE2 320U /* 隔点采样时采集的像素点 */
#define CAMERA_LINES_PER_FRAME  240U /* OV7620摄像头是各行采样, 两个采样帧交叠才能重载一幅原始图像 */
#define CAMERA_PIXELS_PER_FRAME  (CAMERA_PIXELS_PER_LINE2 * CAMERA_LINES_PER_FRAME)

/*
 +---------------> CAMERA_PIXELS_PER_LINE
 |
 |  PIXEL
 v
 CAMERA_LINES_PER_FRAME
*/


/*
* Pin Connection.
 D0		PIO1_24
 D1		PIO1_25
 D2		PIO1_26
 D3		PIO1_27
 D4		PIO1_28
 D5		PIO1_29
 D6		PIO1_30
 D7		PIO1_31
 PCLK	PIO0_17
 HREF	PIO0_14
 VSY	PIO0_13
*/

extern volatile uint8_t  gCameraPixelData[CAMERA_LINES_PER_FRAME * CAMERA_PIXELS_PER_LINE2];

void Camera_Init(void);
void Camera_StartCapture(void);
void Camera_StopCapture(void);
void Camera_DmaIRQHandlerHook(void);

#endif /* __CAMERA_OV7620_H__ */
