/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v3.0
processor: LPC54606J512
package_id: LPC54606J512BD100
mcu_data: ksdk2_0
processor_version: 2.0.2
pin_labels:
- {pin_num: '26', pin_signal: PIO0_15/FC6_CTS_SDA_SSEL0/UTICK_CAP2/CTIMER4_CAP0/SCT0_OUT2/EMC_WEN/ENET_TX_EN/ADC0_3, label: ENC1-CLK}
- {pin_num: '93', pin_signal: PIO0_0/CAN1_RD/FC3_SCK/CTIMER0_MAT0/SCT0_GPI0/PDM0_CLK, label: SERVO-PWM0}
- {pin_num: '72', pin_signal: PIO0_18/FC4_CTS_SDA_SSEL0/SD_WR_PRT/CTIMER1_MAT0/SCT0_OUT1/SCI1_SCLK/EMC_A(0), label: MOTOR-L-PWM0}
- {pin_num: '74', pin_signal: PIO0_20/FC3_CTS_SDA_SSEL0/CTIMER1_MAT1/CTIMER3_CAP3/SCT0_GPI2/SCI0_IO/EMC_A(2)/FC7_RXD_SDA_MOSI_DATA, label: MOTOR-L-PWM1}
- {pin_num: '4', pin_signal: PIO1_5/FC0_RXD_SDA_MOSI/SD_D(2)/CTIMER2_MAT0/SCT0_GPI0/EMC_A(4), label: MOTOR-R-PWM0}
- {pin_num: '3', pin_signal: PIO1_4/FC0_SCK/SD_D(0)/CTIMER2_MAT1/SCT0_OUT0/FREQME_GPIO_CLK_A/EMC_D(11), label: MOTOR-R-PWM1}
- {pin_num: '82', pin_signal: PIO0_29/FC0_RXD_SDA_MOSI/CTIMER2_MAT3/SCT0_OUT8/TRACEDATA(2), label: UART0_RX}
- {pin_num: '95', pin_signal: PIO0_30/FC0_TXD_SCL_MISO/CTIMER0_MAT0/SCT0_OUT9/TRACEDATA(1), label: UART0_TX}
- {pin_num: '57', pin_signal: PIO1_24/FC2_RXD_SDA_MOSI/SCT0_OUT1/FC3_SSEL3/EMC_A(12), label: OV7620-D0}
- {pin_num: '59', pin_signal: PIO1_25/FC2_TXD_SCL_MISO/SCT0_OUT2/UTICK_CAP0/EMC_A(13), label: OV7620-D1}
- {pin_num: '63', pin_signal: PIO1_26/FC2_CTS_SDA_SSEL0/SCT0_OUT3/CTIMER0_CAP3/UTICK_CAP1/EMC_A(8), label: OV7620-D2}
- {pin_num: '68', pin_signal: PIO1_27/FC2_RTS_SCL_SSEL1/SD_D(4)/CTIMER0_MAT3/CLKOUT/EMC_A(9), label: OV7620-D3}
- {pin_num: '73', pin_signal: PIO1_28/FC7_SCK/SD_D(5)/CTIMER0_CAP2/EMC_D(12), label: OV7620-D4}
- {pin_num: '81', pin_signal: PIO1_29/FC7_RXD_SDA_MOSI_DATA/SD_D(6)/SCT0_GPI6/USB1_PORTPWRN/USB1_FRAME/EMC_D(13), label: OV7620-D5}
- {pin_num: '86', pin_signal: PIO1_30/FC7_TXD_SCL_MISO_WS/SD_D(7)/SCT0_GPI7/USB1_OVERCURRENTN/USB1_UP_LED/EMC_D(14), label: OV7620-D6}
- {pin_num: '92', pin_signal: PIO1_31/MCLK/CTIMER0_MAT2/SCT0_OUT6/FC8_CTS_SDA_SSEL0/EMC_D(15), label: OV7620-D7}
- {pin_num: '67', pin_signal: PIO0_13/FC1_CTS_SDA_SSEL0/UTICK_CAP0/CTIMER0_CAP0/SCT0_GPI0/ENET_RXD0, label: OV7620-VSYNC}
- {pin_num: '91', pin_signal: PIO0_19/FC4_RTS_SCL_SSEL1/UTICK_CAP0/CTIMER0_MAT2/SCT0_OUT2/EMC_A(1)/FC7_TXD_SCL_MISO_WS, label: OV7620-HREF}
- {pin_num: '70', pin_signal: PIO0_17/FC4_SSEL2/SD_CARD_DET_N/SCT0_GPI7/SCT0_OUT0/EMC_OEN/ENET_TXD1, label: OV7620-PCLK}
- {pin_num: '69', pin_signal: PIO0_14/FC1_RTS_SCL_SSEL1/UTICK_CAP1/CTIMER0_CAP1/SCT0_GPI1/ENET_RXD1, label: OV7620-HREF}
- {pin_num: '84', pin_signal: PIO1_15/ENET_RX_CLK/UTICK_CAP3/CTIMER1_CAP3/FC5_RTS_SCL_SSEL1/FC4_RTS_SCL_SSEL1/EMC_CKE(0), label: ENC-R-DIR}
- {pin_num: '23', pin_signal: PIO0_10/FC6_SCK/CTIMER2_CAP2/CTIMER2_MAT0/FC1_TXD_SCL_MISO/SWO/ADC0_0, label: AD-CH0}
- {pin_num: '24', pin_signal: PIO0_11/FC6_RXD_SDA_MOSI_DATA/CTIMER2_MAT2/FREQME_GPIO_CLK_A/SWCLK/ADC0_1, label: AD-CH1}
- {pin_num: '25', pin_signal: PIO0_12/FC3_TXD_SCL_MISO/FREQME_GPIO_CLK_B/SCT0_GPI7/SWDIO/ADC0_2, label: AD-CH2}
- {pin_num: '27', pin_signal: PIO0_16/FC4_TXD_SCL_MISO/CLKOUT/CTIMER1_CAP0/EMC_CSN(0)/ENET_TXD0/ADC0_4, label: AD-CH3}
- {pin_num: '28', pin_signal: PIO0_31/FC0_CTS_SDA_SSEL0/SD_D(2)/CTIMER0_MAT1/SCT0_OUT3/TRACEDATA(0)/ADC0_5, label: AD-CH4}
- {pin_num: '35', pin_signal: PIO0_23/MCLK/CTIMER1_MAT2/CTIMER3_MAT3/SCT0_OUT4/SPIFI_CSN/ADC0_11, label: AD-CH5}
- {pin_num: '29', pin_signal: PIO1_0/FC0_RTS_SCL_SSEL1/SD_D(3)/CTIMER0_CAP2/SCT0_GPI4/TRACECLK/ADC0_6, label: AD-CH6}
- {pin_num: '56', pin_signal: PIO0_26/FC2_RXD_SDA_MOSI/CLKOUT/CTIMER3_CAP2/SCT0_OUT5/PDM0_CLK/SPIFI_CLK/USB0_IDVALUE, label: ACC-SDA}
- {pin_num: '42', pin_signal: PIO0_27/FC2_TXD_SCL_MISO/CTIMER3_MAT2/SCT0_OUT6/PDM0_DATA/SPIFI_IO(3), label: ACC-SCL}
- {pin_num: '85', pin_signal: PIO0_3/FC3_RXD_SDA_MOSI/CTIMER0_MAT1/SCT0_OUT1/SCT0_GPI3/EMC_D(1), label: OLED-SPI-SOUT}
- {pin_num: '41', pin_signal: PIO1_10/ENET_TXD1/FC1_RXD_SDA_MOSI/CTIMER1_MAT0/SCT0_OUT3/EMC_RASN, label: OLED-DC}
- {pin_num: '89', pin_signal: PIO0_5/CAN0_TD/FC4_RXD_SDA_MOSI/CTIMER3_MAT0/SCT0_GPI5/EMC_D(3)/ENET_MDIO, label: KEY1}
- {pin_num: '37', pin_signal: PIO1_21/FC7_CTS_SDA_SSEL0/CTIMER3_MAT2/FC4_RXD_SDA_MOSI/EMC_D(10), label: OLED-RST}
- {pin_num: '15', pin_signal: PIO1_6/FC0_TXD_SCL_MISO/SD_D(3)/CTIMER2_MAT1/SCT0_GPI3/EMC_A(5), label: LED0}
- {pin_num: '17', pin_signal: PIO1_20/FC7_RTS_SCL_SSEL1/CTIMER3_CAP2/FC4_TXD_SCL_MISO/EMC_D(9), label: LED1}
- {pin_num: '100', pin_signal: PIO0_1/CAN1_TD/FC3_CTS_SDA_SSEL0/CTIMER0_CAP0/SCT0_GPI1/PDM0_DATA, label: ENC-L-CLK}
- {pin_num: '94', pin_signal: PIO1_11/ENET_TX_EN/FC1_TXD_SCL_MISO/CTIMER1_CAP1/USB0_VBUS/EMC_CLK(0), label: KEY0}
- {pin_num: '88', pin_signal: PIO1_16/ENET_MDC/FC6_TXD_SCL_MISO_WS/CTIMER1_MAT3/SD_CMD/EMC_A(10), label: KEY2}
- {pin_num: '62', pin_signal: PIO1_12/ENET_RXD0/FC6_SCK/CTIMER1_MAT1/USB0_PORTPWRN/EMC_DYCSN(0), label: BM0}
- {pin_num: '64', pin_signal: PIO0_8/FC3_SSEL3/SD_CMD/FC5_RXD_SDA_MOSI/SWO/PDM1_DATA/EMC_D(6), label: BM1}
- {pin_num: '65', pin_signal: PIO0_9/FC3_SSEL2/SD_POW_EN/FC5_TXD_SCL_MISO/SCI1_IO/EMC_D(7), label: BM2}
- {pin_num: '61', pin_signal: PIO0_7/FC3_RTS_SCL_SSEL1/SD_CLK/FC5_SCK/FC1_SCK/PDM1_CLK/EMC_D(5)/ENET_RX_CLK, label: BM3}
- {pin_num: '18', pin_signal: PIO1_7/FC0_RTS_SCL_SSEL1/SD_D(1)/CTIMER2_MAT2/SCT0_GPI4/EMC_A(6), label: OLED-SPI-SOUT}
- {pin_num: '16', pin_signal: PIO1_19/FC8_SCK/SCT0_OUT7/CTIMER3_MAT1/SCT0_GPI7/FC4_SCK/EMC_D(8), label: OLED-SPI-SCLK}
- {pin_num: '90', pin_signal: PIO0_6/FC3_SCK/CTIMER3_CAP1/CTIMER4_MAT0/SCT0_GPI6/EMC_D(4)/ENET_RX_DV, label: SERVO-PWM}
- {pin_num: '83', pin_signal: PIO0_2/FC3_TXD_SCL_MISO/CTIMER0_CAP1/SCT0_OUT0/SCT0_GPI2/EMC_D(0), label: ENC-L-DIR}
- {pin_num: '87', pin_signal: PIO0_4/CAN0_RD/FC4_SCK/CTIMER3_CAP0/SCT0_GPI4/EMC_D(2)/ENET_MDC, label: ENC-R-CLK}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

#include "fsl_common.h"
#include "fsl_inputmux.h"
#include "pin_mux.h"

/*FUNCTION**********************************************************************
 * 
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 * 
 *END**************************************************************************/
void BOARD_InitBootPins(void) {
    BOARD_InitPins();
}

#define PINTSEL6_IDX                     6u   /*!< Inputmux PINTSEL register index 6 */
#define PINTSEL7_IDX                     7u   /*!< Inputmux PINTSEL register index 7 */
#define PIO013_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO013_FUNC_ALT4              0x04u   /*!< Selects pin function.: Alternative connection 4. */
#define PIO014_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO014_FUNC_ALT4              0x04u   /*!< Selects pin function.: Alternative connection 4. */
#define PIO017_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO017_FUNC_ALT3              0x03u   /*!< Selects pin function.: Alternative connection 3. */
#define PIO018_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO018_FUNC_ALT3              0x03u   /*!< Selects pin function.: Alternative connection 3. */
#define PIO01_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO01_FUNC_ALT3               0x03u   /*!< Selects pin function.: Alternative connection 3. */
#define PIO020_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO020_FUNC_ALT2              0x02u   /*!< Selects pin function.: Alternative connection 2. */
#define PIO029_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO029_FILTEROFF_DISABLED     0x01u   /*!< Controls input glitch filter.: Filter disabled. No input filtering is done. */
#define PIO029_FUNC_ALT1              0x01u   /*!< Selects pin function.: Alternative connection 1. */
#define PIO029_INVERT_DISABLED        0x00u   /*!< Input polarity.: Disabled. Input function is not inverted. */
#define PIO029_OD_NORMAL              0x00u   /*!< Controls open-drain mode.: Normal. Normal push-pull output */
#define PIO029_SLEW_STANDARD          0x00u   /*!< Driver slew rate.: Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously. */
#define PIO02_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO02_FUNC_ALT0               0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO030_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO030_FILTEROFF_DISABLED     0x01u   /*!< Controls input glitch filter.: Filter disabled. No input filtering is done. */
#define PIO030_FUNC_ALT1              0x01u   /*!< Selects pin function.: Alternative connection 1. */
#define PIO030_INVERT_DISABLED        0x00u   /*!< Input polarity.: Disabled. Input function is not inverted. */
#define PIO030_OD_NORMAL              0x00u   /*!< Controls open-drain mode.: Normal. Normal push-pull output */
#define PIO030_SLEW_STANDARD          0x00u   /*!< Driver slew rate.: Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously. */
#define PIO04_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO04_FUNC_ALT3               0x03u   /*!< Selects pin function.: Alternative connection 3. */
#define PIO05_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO05_FUNC_ALT0               0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO06_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO06_FUNC_ALT3               0x03u   /*!< Selects pin function.: Alternative connection 3. */
#define PIO110_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO110_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO111_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO111_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO115_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO115_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO116_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO116_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO119_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO119_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO121_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO121_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO124_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO124_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO125_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO125_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO126_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO126_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO127_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO127_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO128_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO128_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO129_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO129_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO130_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO130_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO131_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO131_FUNC_ALT0              0x00u   /*!< Selects pin function.: Alternative connection 0. */
#define PIO14_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO14_FUNC_ALT3               0x03u   /*!< Selects pin function.: Alternative connection 3. */
#define PIO15_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO15_FUNC_ALT3               0x03u   /*!< Selects pin function.: Alternative connection 3. */
#define PIO17_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO17_FUNC_ALT0               0x00u   /*!< Selects pin function.: Alternative connection 0. */

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '82', peripheral: FLEXCOMM0, signal: RXD_SDA_MOSI, pin_signal: PIO0_29/FC0_RXD_SDA_MOSI/CTIMER2_MAT3/SCT0_OUT8/TRACEDATA(2), invert: disabled, glitch_filter: disabled,
    slew_rate: standard, open_drain: disabled}
  - {pin_num: '95', peripheral: FLEXCOMM0, signal: TXD_SCL_MISO, pin_signal: PIO0_30/FC0_TXD_SCL_MISO/CTIMER0_MAT0/SCT0_OUT9/TRACEDATA(1), invert: disabled, glitch_filter: disabled,
    slew_rate: standard, open_drain: disabled}
  - {pin_num: '92', peripheral: GPIO, signal: 'PIO1, 31', pin_signal: PIO1_31/MCLK/CTIMER0_MAT2/SCT0_OUT6/FC8_CTS_SDA_SSEL0/EMC_D(15)}
  - {pin_num: '86', peripheral: GPIO, signal: 'PIO1, 30', pin_signal: PIO1_30/FC7_TXD_SCL_MISO_WS/SD_D(7)/SCT0_GPI7/USB1_OVERCURRENTN/USB1_UP_LED/EMC_D(14)}
  - {pin_num: '81', peripheral: GPIO, signal: 'PIO1, 29', pin_signal: PIO1_29/FC7_RXD_SDA_MOSI_DATA/SD_D(6)/SCT0_GPI6/USB1_PORTPWRN/USB1_FRAME/EMC_D(13)}
  - {pin_num: '73', peripheral: GPIO, signal: 'PIO1, 28', pin_signal: PIO1_28/FC7_SCK/SD_D(5)/CTIMER0_CAP2/EMC_D(12)}
  - {pin_num: '68', peripheral: GPIO, signal: 'PIO1, 27', pin_signal: PIO1_27/FC2_RTS_SCL_SSEL1/SD_D(4)/CTIMER0_MAT3/CLKOUT/EMC_A(9)}
  - {pin_num: '63', peripheral: GPIO, signal: 'PIO1, 26', pin_signal: PIO1_26/FC2_CTS_SDA_SSEL0/SCT0_OUT3/CTIMER0_CAP3/UTICK_CAP1/EMC_A(8)}
  - {pin_num: '59', peripheral: GPIO, signal: 'PIO1, 25', pin_signal: PIO1_25/FC2_TXD_SCL_MISO/SCT0_OUT2/UTICK_CAP0/EMC_A(13)}
  - {pin_num: '57', peripheral: GPIO, signal: 'PIO1, 24', pin_signal: PIO1_24/FC2_RXD_SDA_MOSI/SCT0_OUT1/FC3_SSEL3/EMC_A(12)}
  - {pin_num: '67', peripheral: SCT0, signal: 'IN, 0', pin_signal: PIO0_13/FC1_CTS_SDA_SSEL0/UTICK_CAP0/CTIMER0_CAP0/SCT0_GPI0/ENET_RXD0}
  - {pin_num: '69', peripheral: SCT0, signal: 'IN, 1', pin_signal: PIO0_14/FC1_RTS_SCL_SSEL1/UTICK_CAP1/CTIMER0_CAP1/SCT0_GPI1/ENET_RXD1}
  - {pin_num: '70', peripheral: SCT0, signal: 'IN, 7', pin_signal: PIO0_17/FC4_SSEL2/SD_CARD_DET_N/SCT0_GPI7/SCT0_OUT0/EMC_OEN/ENET_TXD1}
  - {pin_num: '18', peripheral: GPIO, signal: 'PIO1, 7', pin_signal: PIO1_7/FC0_RTS_SCL_SSEL1/SD_D(1)/CTIMER2_MAT2/SCT0_GPI4/EMC_A(6)}
  - {pin_num: '16', peripheral: GPIO, signal: 'PIO1, 19', pin_signal: PIO1_19/FC8_SCK/SCT0_OUT7/CTIMER3_MAT1/SCT0_GPI7/FC4_SCK/EMC_D(8)}
  - {pin_num: '41', peripheral: GPIO, signal: 'PIO1, 10', pin_signal: PIO1_10/ENET_TXD1/FC1_RXD_SDA_MOSI/CTIMER1_MAT0/SCT0_OUT3/EMC_RASN}
  - {pin_num: '37', peripheral: GPIO, signal: 'PIO1, 21', pin_signal: PIO1_21/FC7_CTS_SDA_SSEL0/CTIMER3_MAT2/FC4_RXD_SDA_MOSI/EMC_D(10)}
  - {pin_num: '94', peripheral: GPIO, signal: 'PIO1, 11', pin_signal: PIO1_11/ENET_TX_EN/FC1_TXD_SCL_MISO/CTIMER1_CAP1/USB0_VBUS/EMC_CLK(0)}
  - {pin_num: '89', peripheral: GPIO, signal: 'PIO0, 5', pin_signal: PIO0_5/CAN0_TD/FC4_RXD_SDA_MOSI/CTIMER3_MAT0/SCT0_GPI5/EMC_D(3)/ENET_MDIO}
  - {pin_num: '88', peripheral: GPIO, signal: 'PIO1, 16', pin_signal: PIO1_16/ENET_MDC/FC6_TXD_SCL_MISO_WS/CTIMER1_MAT3/SD_CMD/EMC_A(10)}
  - {pin_num: '90', peripheral: CTIMER4, signal: 'MATCH, 0', pin_signal: PIO0_6/FC3_SCK/CTIMER3_CAP1/CTIMER4_MAT0/SCT0_GPI6/EMC_D(4)/ENET_RX_DV}
  - {pin_num: '72', peripheral: CTIMER1, signal: 'MATCH, 0', pin_signal: PIO0_18/FC4_CTS_SDA_SSEL0/SD_WR_PRT/CTIMER1_MAT0/SCT0_OUT1/SCI1_SCLK/EMC_A(0)}
  - {pin_num: '74', peripheral: CTIMER1, signal: 'MATCH, 1', pin_signal: PIO0_20/FC3_CTS_SDA_SSEL0/CTIMER1_MAT1/CTIMER3_CAP3/SCT0_GPI2/SCI0_IO/EMC_A(2)/FC7_RXD_SDA_MOSI_DATA}
  - {pin_num: '4', peripheral: CTIMER2, signal: 'MATCH, 0', pin_signal: PIO1_5/FC0_RXD_SDA_MOSI/SD_D(2)/CTIMER2_MAT0/SCT0_GPI0/EMC_A(4)}
  - {pin_num: '3', peripheral: CTIMER2, signal: 'MATCH, 1', pin_signal: PIO1_4/FC0_SCK/SD_D(0)/CTIMER2_MAT1/SCT0_OUT0/FREQME_GPIO_CLK_A/EMC_D(11)}
  - {pin_num: '100', peripheral: CTIMER0, signal: 'CAPTURE, 0', pin_signal: PIO0_1/CAN1_TD/FC3_CTS_SDA_SSEL0/CTIMER0_CAP0/SCT0_GPI1/PDM0_DATA}
  - {pin_num: '83', peripheral: PINT, signal: 'PINT, 7', pin_signal: PIO0_2/FC3_TXD_SCL_MISO/CTIMER0_CAP1/SCT0_OUT0/SCT0_GPI2/EMC_D(0)}
  - {pin_num: '87', peripheral: CTIMER3, signal: 'CAPTURE, 0', pin_signal: PIO0_4/CAN0_RD/FC4_SCK/CTIMER3_CAP0/SCT0_GPI4/EMC_D(2)/ENET_MDC}
  - {pin_num: '84', peripheral: PINT, signal: 'PINT, 6', pin_signal: PIO1_15/ENET_RX_CLK/UTICK_CAP3/CTIMER1_CAP3/FC5_RTS_SCL_SSEL1/FC4_RTS_SCL_SSEL1/EMC_CKE(0)}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/*FUNCTION**********************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 *END**************************************************************************/
void BOARD_InitPins(void) { /* Function assigned for the Core #0 (ARM Cortex-M4) */
  CLOCK_EnableClock(kCLOCK_InputMux);                        /* Enables the clock for the input muxes. 0 = Disable; 1 = Enable.: 0x01u */
  CLOCK_EnableClock(kCLOCK_Iocon);                           /* Enables the clock for the IOCON block. 0 = Disable; 1 = Enable.: 0x01u */

  INPUTMUX_AttachSignal(INPUTMUX,PINTSEL6_IDX,kINPUTMUX_GpioPort1Pin15ToPintsel); /* PIO1_15 is selected for PINT input 6 */
  INPUTMUX_AttachSignal(INPUTMUX,PINTSEL7_IDX,kINPUTMUX_GpioPort0Pin2ToPintsel); /* PIO0_2 is selected for PINT input 7 */
  IOCON->PIO[0][1] = ((IOCON->PIO[0][1] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO01_FUNC_ALT3)                      /* Selects pin function.: PORT01 (pin 100) is configured as CTIMER0_CAP0 */
      | IOCON_PIO_DIGIMODE(PIO01_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][13] = ((IOCON->PIO[0][13] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO013_FUNC_ALT4)                     /* Selects pin function.: PORT013 (pin 67) is configured as SCT0_GPI0 */
      | IOCON_PIO_DIGIMODE(PIO013_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][14] = ((IOCON->PIO[0][14] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO014_FUNC_ALT4)                     /* Selects pin function.: PORT014 (pin 69) is configured as SCT0_GPI1 */
      | IOCON_PIO_DIGIMODE(PIO014_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][17] = ((IOCON->PIO[0][17] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO017_FUNC_ALT3)                     /* Selects pin function.: PORT017 (pin 70) is configured as SCT0_GPI7 */
      | IOCON_PIO_DIGIMODE(PIO017_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][18] = ((IOCON->PIO[0][18] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO018_FUNC_ALT3)                     /* Selects pin function.: PORT018 (pin 72) is configured as CTIMER1_MAT0 */
      | IOCON_PIO_DIGIMODE(PIO018_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][2] = ((IOCON->PIO[0][2] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO02_FUNC_ALT0)                      /* Selects pin function.: PORT02 (pin 83) is configured as PIO0_2 */
      | IOCON_PIO_DIGIMODE(PIO02_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][20] = ((IOCON->PIO[0][20] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO020_FUNC_ALT2)                     /* Selects pin function.: PORT020 (pin 74) is configured as CTIMER1_MAT1 */
      | IOCON_PIO_DIGIMODE(PIO020_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][29] = ((IOCON->PIO[0][29] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_INVERT_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_FILTEROFF_MASK | IOCON_PIO_SLEW_MASK | IOCON_PIO_OD_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO029_FUNC_ALT1)                     /* Selects pin function.: PORT029 (pin 82) is configured as FC0_RXD_SDA_MOSI */
      | IOCON_PIO_INVERT(PIO029_INVERT_DISABLED)             /* Input polarity.: Disabled. Input function is not inverted. */
      | IOCON_PIO_DIGIMODE(PIO029_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
      | IOCON_PIO_FILTEROFF(PIO029_FILTEROFF_DISABLED)       /* Controls input glitch filter.: Filter disabled. No input filtering is done. */
      | IOCON_PIO_SLEW(PIO029_SLEW_STANDARD)                 /* Driver slew rate.: Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously. */
      | IOCON_PIO_OD(PIO029_OD_NORMAL)                       /* Controls open-drain mode.: Normal. Normal push-pull output */
    );
  IOCON->PIO[0][30] = ((IOCON->PIO[0][30] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_INVERT_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_FILTEROFF_MASK | IOCON_PIO_SLEW_MASK | IOCON_PIO_OD_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO030_FUNC_ALT1)                     /* Selects pin function.: PORT030 (pin 95) is configured as FC0_TXD_SCL_MISO */
      | IOCON_PIO_INVERT(PIO030_INVERT_DISABLED)             /* Input polarity.: Disabled. Input function is not inverted. */
      | IOCON_PIO_DIGIMODE(PIO030_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
      | IOCON_PIO_FILTEROFF(PIO030_FILTEROFF_DISABLED)       /* Controls input glitch filter.: Filter disabled. No input filtering is done. */
      | IOCON_PIO_SLEW(PIO030_SLEW_STANDARD)                 /* Driver slew rate.: Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously. */
      | IOCON_PIO_OD(PIO030_OD_NORMAL)                       /* Controls open-drain mode.: Normal. Normal push-pull output */
    );
  IOCON->PIO[0][4] = ((IOCON->PIO[0][4] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO04_FUNC_ALT3)                      /* Selects pin function.: PORT04 (pin 87) is configured as CTIMER3_CAP0 */
      | IOCON_PIO_DIGIMODE(PIO04_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][5] = ((IOCON->PIO[0][5] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO05_FUNC_ALT0)                      /* Selects pin function.: PORT05 (pin 89) is configured as PIO0_5 */
      | IOCON_PIO_DIGIMODE(PIO05_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][6] = ((IOCON->PIO[0][6] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO06_FUNC_ALT3)                      /* Selects pin function.: PORT06 (pin 90) is configured as CTIMER4_MAT0 */
      | IOCON_PIO_DIGIMODE(PIO06_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][10] = ((IOCON->PIO[1][10] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO110_FUNC_ALT0)                     /* Selects pin function.: PORT110 (pin 41) is configured as PIO1_10 */
      | IOCON_PIO_DIGIMODE(PIO110_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][11] = ((IOCON->PIO[1][11] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO111_FUNC_ALT0)                     /* Selects pin function.: PORT111 (pin 94) is configured as PIO1_11 */
      | IOCON_PIO_DIGIMODE(PIO111_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][15] = ((IOCON->PIO[1][15] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO115_FUNC_ALT0)                     /* Selects pin function.: PORT115 (pin 84) is configured as PIO1_15 */
      | IOCON_PIO_DIGIMODE(PIO115_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][16] = ((IOCON->PIO[1][16] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO116_FUNC_ALT0)                     /* Selects pin function.: PORT116 (pin 88) is configured as PIO1_16 */
      | IOCON_PIO_DIGIMODE(PIO116_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][19] = ((IOCON->PIO[1][19] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO119_FUNC_ALT0)                     /* Selects pin function.: PORT119 (pin 16) is configured as PIO1_19 */
      | IOCON_PIO_DIGIMODE(PIO119_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][21] = ((IOCON->PIO[1][21] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO121_FUNC_ALT0)                     /* Selects pin function.: PORT121 (pin 37) is configured as PIO1_21 */
      | IOCON_PIO_DIGIMODE(PIO121_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][24] = ((IOCON->PIO[1][24] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO124_FUNC_ALT0)                     /* Selects pin function.: PORT124 (pin 57) is configured as PIO1_24 */
      | IOCON_PIO_DIGIMODE(PIO124_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][25] = ((IOCON->PIO[1][25] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO125_FUNC_ALT0)                     /* Selects pin function.: PORT125 (pin 59) is configured as PIO1_25 */
      | IOCON_PIO_DIGIMODE(PIO125_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][26] = ((IOCON->PIO[1][26] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO126_FUNC_ALT0)                     /* Selects pin function.: PORT126 (pin 63) is configured as PIO1_26 */
      | IOCON_PIO_DIGIMODE(PIO126_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][27] = ((IOCON->PIO[1][27] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO127_FUNC_ALT0)                     /* Selects pin function.: PORT127 (pin 68) is configured as PIO1_27 */
      | IOCON_PIO_DIGIMODE(PIO127_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][28] = ((IOCON->PIO[1][28] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO128_FUNC_ALT0)                     /* Selects pin function.: PORT128 (pin 73) is configured as PIO1_28 */
      | IOCON_PIO_DIGIMODE(PIO128_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][29] = ((IOCON->PIO[1][29] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO129_FUNC_ALT0)                     /* Selects pin function.: PORT129 (pin 81) is configured as PIO1_29 */
      | IOCON_PIO_DIGIMODE(PIO129_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][30] = ((IOCON->PIO[1][30] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO130_FUNC_ALT0)                     /* Selects pin function.: PORT130 (pin 86) is configured as PIO1_30 */
      | IOCON_PIO_DIGIMODE(PIO130_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][31] = ((IOCON->PIO[1][31] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO131_FUNC_ALT0)                     /* Selects pin function.: PORT131 (pin 92) is configured as PIO1_31 */
      | IOCON_PIO_DIGIMODE(PIO131_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][4] = ((IOCON->PIO[1][4] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO14_FUNC_ALT3)                      /* Selects pin function.: PORT14 (pin 3) is configured as CTIMER2_MAT1 */
      | IOCON_PIO_DIGIMODE(PIO14_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][5] = ((IOCON->PIO[1][5] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO15_FUNC_ALT3)                      /* Selects pin function.: PORT15 (pin 4) is configured as CTIMER2_MAT0 */
      | IOCON_PIO_DIGIMODE(PIO15_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][7] = ((IOCON->PIO[1][7] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))      /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO17_FUNC_ALT0)                      /* Selects pin function.: PORT17 (pin 18) is configured as PIO1_7 */
      | IOCON_PIO_DIGIMODE(PIO17_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
}

/*******************************************************************************
 * EOF
 ******************************************************************************/
