/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


/*=========================================================================

Public type definitions

===========================================================================*/
#define TRUE                        1
#define FALSE                       0

#define USE_SET_XPANID				1
#define USE_MATCH_DESCRIPTOR		1
#define USE_SIMPLE_DESCRIPTOR  		1
#define USE_READ_ATTRIBUTES			1
#define USE_DYNAMIC_ATTRIBUTES		0
#define USE_SET_ATTRIBUTE			1
#define USE_FIND_AND_BIND			1
#define USE_INSTALL_CODE			1
#define SEE_ATTRIBUTE_LIST			0

/* FSCI protocol attributes */
#define LENGTH_FIELD_SIZE           2  /* size in bytes of FSCI length field */
#define CRC_FIELD_SIZE              1  /* size in bytes of FSCI CRC field */
#define VIF                         0  /* do not use FSCI virtual interfaces */

/* Zigbee FSCI operation groups and codes */
#define TX_OG 						0x37
#define TX_REQ_OG					0x38
#define RX_OG						0xB7
#define RX_RSP_OG					0xB8
#define RX_DISC_OG					0xBE

#define FACTORY_RST_OC				0x12
#define FACTORY_NEW_RESTART_OC		0x07
#define NODE_CMD_ID_LIST_OC			0x05
#define NODE_CLUSTER_ATT_LIST_OC	0x04
#define NODE_CLUSTER_LIST_OC        0x03
#define SET_CHANNEL_MASK_OC			0x21
#define SET_EPID_OC					0x20
#define CREATE_NWK_OC				0x24
#define PERMIT_JOIN_OC				0x49
#define DEVICE_ANNOUNCE_OC			0x4D
#define ROUTER_DISCOVERY_OC			0x01
#define READ_ATT_OC					0x00
#define ON_OFF_CMD_OC				0x92
#define LEAVE_IND_OC				0x48
#define CONFIG_REPORTING_OC			0x20
#define BIND_OC						0x30
#define SIMPLE_DESCRIPTOR_OC 		0x43
#define MATCH_DESCRIPTOR_OC			0x46
#define SET_SECURITY_OC				0x22
#define SET_DEVICE_TYPE_OC			0x23
#define NETWORK_SCAN_OC				0x25
#define INSTALL_CODE_OC				0x15
#define NODE_DESCRIPTOR_OC			0x42

/* Zigbee Clusters */
#define CLUSTER_ID_HIGH				0x00
#define BASIC_CLUSTER_ID_LOW		0x00
#define IDENTIFY_CLUSTER_ID_LOW		0x03
#define GROUPS_CLUSTER_ID_LOW		0x04
#define ON_OFF_CLUSTER_ID_LOW		0x06
#define LVL_CTRL_CLUSTER_ID_LOW     0X08

/* Other constants */
#define DEFAULT_ENDPOINT			0x01
#define HOME_AUTO_APP_PROFILE_HIGH	0x01
#define HOME_AUTO_APP_PROFILE_LOW	0x04

#define COORDINATOR_DEVICE_TYPE		0x00
#define ROUTER_DEVICE_TYPE			0x01
#define LEGACY_ROUTER_TYPE			0x02

#define OFF_CMD						0x00
#define ON_CMD						0x01
#define TOGGLE_CMD 					0x02

#define BROADCAST_ADD_MODE			0x01
#define UNICAST_ADD_MODE			0x02

#define SERVER_TO_CLIENT			0x00
#define CLIENT_TO_SERVER			0x01
#define NUMBER_OF_ATTRIBUTES		0x01
#define INPUT_CLUSTERS				0x03
#define OUTPUT_CLUSTERS				0x01

typedef uint8_t bool_t;

