/*
 * System.c
 *
 *  Created on: Apr 15, 2017
 *      Author: Osvaldo
 */

/*
 * System_cfg.c
 *
 *  Created on: Apr 15, 2017
 *      Author: Osvaldo
 */




/**********************************************************************************************
* External objects
**********************************************************************************************/
#include "System.h"

/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/

/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

void PORT_init (void)
{
  PCC->PCCn[PCC_PORTE_INDEX] |= PCC_PCCn_CGC_MASK; /* Enable clock for PORTE */
  PORTE->PCR[4] |= PORT_PCR_MUX(5); /* Port E4: MUX = ALT5, CAN0_RX */
  PORTE->PCR[5] |= PORT_PCR_MUX(5); /* Port E5: MUX = ALT5, CAN0_TX */
}

void PORT_deinit(void)
{
	  PORTE->PCR[4] |= PORT_PCR_MUX(0);
	  PORTE->PCR[5] |= PORT_PCR_MUX(0);
	  PCC->PCCn[PCC_PORTE_INDEX] &= ~PCC_PCCn_CGC_MASK; /* Disable clock for PORTE */
}

void init_IRQs (void)
{
	S32_NVIC->ICPR[1] = 1 << (48 % 32);  /* IRQ48-LPIT0 ch0: clr any pending IRQ*/
	S32_NVIC->ISER[1] = 1 << (48 % 32);  /* IRQ48-LPIT0 ch0: enable IRQ */
 	S32_NVIC->IP[48] = 0xA;              /* IRQ48-LPIT0 ch0: priority 10 of 0-15*/
}

void deinit_IRQs (void)
{
	S32_NVIC->ICPR[1] = 1 << (48 % 32);  /* IRQ48-LPIT0 ch0: clr any pending IRQ*/
	S32_NVIC->ISER[1] = 0x00000000;      /* IRQ48-LPIT0 ch0: enable IRQ */
 	S32_NVIC->IP[48] = 0x00000000;       /* IRQ48-LPIT0 ch0: priority 10 of 0-15*/
}




