
MEMORY {
// Memory map for the MPC5744P

//   16KB of UTEST flash starting at 0x00400000.
//   96KB of data flash starting at 0x00800000.
//  416KB of small flash blocks starting at 0x00f98000.
// 2048KB of large flash blocks starting at 0x01000000.

    flash_rsvd1  : ORIGIN = 0x00400000, LENGTH = 0x00b98000
    flash_memory : ORIGIN = 0x00f98000,	LENGTH = 0x00268000 // small and large flash blocks
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0 

// 384KB of system SRAM starting at 0x40000000
    dram_rsvd1   : ORIGIN = 0x40000000, LENGTH = 0x100 // reserved for interrupt vectors
    dram_reset   : ORIGIN = .,	        LENGTH = 0
    dram_memory  : ORIGIN = .,          LENGTH = 384K-0x100
    dram_rsvd2   : ORIGIN = .,          LENGTH = 0
}
DEFAULTS {
    stack_reserve = 32k
    heap_reserve = 32k
}
//
// Program layout for starting in ROM, copying text and data to RAM,
// and then running out of RAM.
//

SECTIONS
{
//
// RAM SECTIONS
//
    .PPC.EMB.sdata0 	            		    ABS : > dram_memory
    .PPC.EMB.sbss0                            CLEAR ABS : > .

    .boottext : {
	  // All .text which is reachable between
	  // _start and __ghs_ind_crt1 needs to be
	  // pulled into .boottext and left
	  // uncompressed.
	  crt0.o(.text, .vletext)
          libboardinit.a(*)(.text, .vletext)
	  libstartup.a(*)(.text, .vletext)
	  libsys.a(ind_crt1.o)(.text, .vletext)
     }                                                    > dram_memory
    .syscall						: > .
    .text 			        	        : > dram_memory
    .vletext 			        	        : > .
   
    .sdabase 		       		       ALIGN(16): > .
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 						: > .
    .ghcovfz 					  CLEAR : > .
    .ghcovcz 					  CLEAR	: > .
    .ghcovdz 					  CLEAR	: > .
    .heap                  ALIGN(16) PAD(heap_reserve)  : > .   
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

//
// ROM SECTIONS
//

    .rchw						: > flash_memory
    .ROM.boottext  	                 ROM(.boottext)	: > flash_memory
    .ROM.syscall 	          	 ROM(.syscall)	: > .
    
    .rodata 						: > flash_memory
    .toc 				     SHFLAGS(2)	: > .

    .sdata2 						: > .
    .opd 				     SHFLAGS(2)	: > .

    .secinfo 						: > .
    .fixaddr 						: > .
    .fixtype 						: > .

    .CROM.PPC.EMB.sdata0 	  CROM(.PPC.EMB.sdata0) : > .
    .CROM.sdata  	          	   CROM(.sdata)	: > .
    .CROM.data 	          		    CROM(.data) : > .
    .CROM.text  	      		    CROM(.text)	: > .
    .CROM.vletext  	      		 CROM(.vletext)	: > flash_memory

//
// These special symbols mark the bounds of RAM and ROM images of boot code.
// They are used by the GHS startup code (_start and __ghs_ind_crt0).
//
    __ghs_rambootcodestart  = ADDR(.boottext);
    __ghs_rambootcodeend    = ENDADDR(.stack);	
    __ghs_rombootcodestart  = ADDR(.ROM.boottext);
    __ghs_rombootcodeend    = ENDADDR(.fixtype);

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(dram_rsvd1);
    __ghs_ramend    = MEMENDADDR(dram_memory);
    __ghs_romstart  = MEMADDR(flash_rsvd1);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);

//
// This special symbol marks the the first address executed after the
// ROM to RAM copy is complete.  It is used by the MULTI debugger.
//
    __ghs_after_romcopy = __ghs_ind_crt1;
}
