/*******************************************************************************
* NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. NXP neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE OR ADVISE SUPPLIED TO THE PROJECT
BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. IN NO EVENT
SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold NXP harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File      main.c
* Owner     NXA19261
* Version   1.0
* Date      Aug-17-2017
* Classification   General Business Information
* Brief     S12Z EEPROM routines header file.
********************************************************************************
* Detailed Description:
* S12Z EEPROM routines header file.
* 
********************************************************************************
Revision History:
Version  Date         Author    Description of Changes
1.0      Aug-17-2017  NXA19261  Initial version
*******************************************************************************/

#ifndef _EEPROM_12Z_H
#define _EEPROM_12Z_H
#include "Config.h"

//==============================================================================
// Definitions
//==============================================================================
#define EEPROM_SECTOR_SIZE 4  //4 bytes

/* Error codes */
#define OK          0
#define ERASED      1
#define NON_ERASED  2
#define MISALIGNED_ADDRESS  3
#define ACCESS_ERROR        4

//==============================================================================
// Function Prototypes
//==============================================================================
#if BOOTLODER_REWRITABLE 
#pragma CODE_SEG DEFAULT_RAM
#endif /* BOOTLODER_REWRITABLE */
extern unsigned char EEPROM_Erase_Verify_Section(unsigned long int address, unsigned int number_of_words);
extern unsigned char EEPROM_Program(unsigned long int address, unsigned int *ptr, unsigned int number_of_words);
extern unsigned char EEPROM_Erase_Sector(unsigned long int address);
extern unsigned char EEPROM_EraseSectorBySector(unsigned long int addr_l, unsigned long int addr_h);
extern unsigned char EEPROM_Read_Byte(unsigned long int address);
extern unsigned int EEPROM_Read_Word(unsigned long int address);
#if BOOTLODER_REWRITABLE 
#pragma CODE_SEG DEFAULT
#endif /* BOOTLODER_REWRITABLE */

extern void EEPROM_Init(unsigned char fdiv);


#endif /* _EEPROM_12Z_H */

