/*******************************************************************************
* NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. NXP neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE OR ADVISE SUPPLIED TO THE PROJECT
BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. IN NO EVENT
SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold NXP harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File      main.c
* Owner     NXA19261
* Version   1.0
* Date      Aug-17-2017
* Classification   General Business Information
* Brief     SCI header file
********************************************************************************
* Detailed Description:
* SCI header file
* 
********************************************************************************
Revision History:
Version  Date         Author    Description of Changes
1.0      Aug-17-2017  NXA19261  Initial version
*******************************************************************************/
#ifndef _SCI_H
#define _SCI_H

#include "Config.h"

//==============================================================================
// Definitions
//==============================================================================
#define SCI0 0
#define SCI1 1

//SCIV6 
//SBR[15:0] = SCI bus clock / (SCI baud rate)  
#define Baud9600 2604
#define Baud38400 651
#define Baud57600 434
#define Baud115200 217

#define XOn 0x11
#define XOff 0x13

#define RxBufSize 96
#define TxBufSize 64

#define XOnCount RxBufSize - 8
#define XOffCount (RxBufSize-16)+2

#if SCI_MODULE == SCI0
#define SCI_BASE_ADD (&SCI0BDH)  //SCI0
#define SCI_VEC_ADR 0x19C
#endif /* SCI_MODULE == SCI0 */
#if SCI_MODULE == SCI1
#define SCI_BASE_ADD (&SCI1BDH)  //SCI1
#define SCI_VEC_ADR 0x198
#endif /* SCI_MODULE == SCI1 */

#define SCIBD       (*(volatile unsigned int  *)   SCI_BASE_ADD   )
#define SCICR2      (*(volatile unsigned char *)  (SCI_BASE_ADD+3))
#define SCISR1      (*(volatile unsigned char *)  (SCI_BASE_ADD+4))
#define SCIDRL      (*(volatile unsigned char *)  (SCI_BASE_ADD+7))

#define SCICR2_SBK_MASK                 1
#define SCICR2_RWU_MASK                 2
#define SCICR2_RE_MASK                  4
#define SCICR2_TE_MASK                  8
#define SCICR2_ILIE_MASK                16
#define SCICR2_RIE_MASK                 32
#define SCICR2_TCIE_MASK                64
#define SCICR2_TIE_MASK                 128

#define SCISR1_PF_MASK                  1
#define SCISR1_FE_MASK                  2
#define SCISR1_NF_MASK                  4
#define SCISR1_OR_MASK                  8
#define SCISR1_IDLE_MASK                16
#define SCISR1_RDRF_MASK                32
#define SCISR1_TC_MASK                  64
#define SCISR1_TDRE_MASK                128

//==============================================================================
// Function Prototypes
//============================================================================== 
extern void InitSCI(void);

#if BOOTLODER_REWRITABLE 
#pragma CODE_SEG DEFAULT_RAM
#endif /* BOOTLODER_REWRITABLE */

extern void RxISR(void);
extern void TxISR(void);
interrupt void SCIISR(void);

extern void OutStr(char * Str);
extern signed char putchar(char c);
extern signed char getchar(void);
extern void SetBaud(void);
#if BOOTLODER_REWRITABLE 
#pragma CODE_SEG DEFAULT
#endif /* BOOTLODER_REWRITABLE */

#endif /* _SCI_H */

